/*
 *	prefDialog.cpp - mathgl plot wrapper class
 *	Copyright (C) 2018, D Haley 

 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.

 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.

 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// -*- C++ -*- generated by wxGlade HG on Fri Dec  3 22:26:29 2010

#include "prefDialog.h"

#include "backend/filters/allFilter.h"
#include "backend/viscontrol.h"
#include "common/stringFuncs.h"

#include "wx/wxcommon.h"
#include "wx/wxcomponents.h"
#include "wx/propertyGridUpdater.h"

#include <wx/colordlg.h>


using std::vector;



// begin wxGlade: ::extracode
// end wxGlade
enum
{
	ID_LIST_FILTERS = wxID_ANY+1,
	ID_GRID_PROPERTIES,
	ID_BTN_RESET_FILTER,
	ID_BTN_RESET_FILTER_ALL,
	ID_START_CHECK_CONTROL,
	ID_START_CHECK_PLOTLIST,
	ID_START_CHECK_RAWDATA,
	ID_START_COMBO_PANEL,
	ID_CHECK_PREFER_ORTHO,
	ID_MOUSE_MOVE_SLIDER,
	ID_MOUSE_ZOOM_SLIDER,
};


//Number that 
enum
{
	STARTUP_COMBO_SELECT_SHOW_ALL,
	STARTUP_COMBO_SELECT_REMEMBER,
	STARTUP_COMBO_SELECT_SPECIFY
};


PrefDialog::PrefDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxDialog(parent, id, title, pos, size, style)
{
    // begin wxGlade: prefDialog::prefDialog
	notePrefPanels = new wxNotebook(this, wxID_ANY, wxDefaultPosition, wxDefaultSize, 0);
    notePrefPanels_pane_3 = new wxPanel(notePrefPanels, wxID_ANY);
	panelStartup = new wxPanel(notePrefPanels, wxID_ANY);
	panelFilters = new wxPanel(notePrefPanels, wxID_ANY);
	sizer_2_staticbox = new wxStaticBox(panelStartup, -1, TRANS("Panel Display"));
#ifndef DISABLE_ONLINE_UPDATE
	updateSizer_staticbox = new wxStaticBox(panelStartup, -1, TRANS("Online Updates"));
#endif
    	sizer_7_staticbox = new wxStaticBox(notePrefPanels_pane_3, wxID_ANY, TRANS("Startup"));
    	sizerCamSpeed_staticbox = new wxStaticBox(notePrefPanels_pane_3, -1, TRANS("Camera Speed"));
	lblFilters = new wxStaticText(panelFilters, wxID_ANY, TRANS("Available Filters"));
	listFilters = new wxListBox(panelFilters, ID_LIST_FILTERS, wxDefaultPosition, wxDefaultSize, 0, NULL, wxLB_SINGLE|wxLB_SORT);
	filterGridProperties =new wxPropertyGrid(panelFilters, ID_GRID_PROPERTIES,
						wxDefaultPosition,wxDefaultSize,PROPERTY_GRID_STYLE);
	filterGridProperties->SetExtraStyle(PROPERTY_GRID_EXTRA_STYLE);
	filterBtnResetAllFilters = new wxButton(panelFilters, ID_BTN_RESET_FILTER_ALL, TRANS("Reset All"));
	filterResetDefaultFilter = new wxButton(panelFilters, ID_BTN_RESET_FILTER, TRANS("Reset"));
	const wxString comboPanelStartMode_choices[] = {
		NTRANS("Show all panels"),
		NTRANS("Remember last"),
		NTRANS("Show Selected")
	};
	comboPanelStartMode = new wxComboBox(panelStartup, ID_START_COMBO_PANEL, wxT(""), wxDefaultPosition, wxDefaultSize, 3, comboPanelStartMode_choices, wxCB_SIMPLE|wxCB_DROPDOWN|wxCB_READONLY);
	chkControl = new wxCheckBox(panelStartup, ID_START_CHECK_CONTROL, TRANS("Control Pane"));
	chkRawData = new wxCheckBox(panelStartup, ID_START_CHECK_RAWDATA, TRANS("Raw Data Panel"));
	chkPlotlist = new wxCheckBox(panelStartup, ID_START_CHECK_PLOTLIST, TRANS("Plot List"));
#ifndef DISABLE_ONLINE_UPDATE
	checkAllowOnlineUpdate = new wxCheckBox(panelStartup, wxID_ANY, TRANS("Periodically notify about available updates"));
#endif
    	chkPreferOrtho = new wxCheckBox(notePrefPanels_pane_3, wxID_ANY, TRANS("Prefer orthographic at startup"));
	lblMoveSpeed = new wxStaticText(notePrefPanels_pane_3, wxID_ANY, TRANS("Move Rate"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
	labelSlowCamMoveRate = new wxStaticText(notePrefPanels_pane_3,wxID_ANY, TRANS("(slow)"));
	sliderCamMoveRate = new wxSlider(notePrefPanels_pane_3, ID_MOUSE_MOVE_SLIDER, 25, 1, 400,wxDefaultPosition,wxDefaultSize,wxSL_HORIZONTAL|wxSL_LABELS);
	labelFastCamMoveRate = new wxStaticText(notePrefPanels_pane_3, wxID_ANY, TRANS("(fast)"));
	lblZoomSpeed = new wxStaticText(notePrefPanels_pane_3, wxID_ANY, TRANS("Zoom Rate"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
	labelSlowCamZoomRate = new wxStaticText(notePrefPanels_pane_3, wxID_ANY, TRANS("(slow)"));
	sliderCamZoomRate = new wxSlider(notePrefPanels_pane_3, ID_MOUSE_ZOOM_SLIDER, 25, 1, 400,wxDefaultPosition,wxDefaultSize,wxSL_HORIZONTAL|wxSL_LABELS);
	labelSlowFastZoomRate = new wxStaticText(notePrefPanels_pane_3, wxID_ANY, TRANS("(fast)"));
	btnOK = new wxButton(this, wxID_OK, wxEmptyString);
	btnCancel = new wxButton(this, wxID_CANCEL, wxEmptyString);

	bool enable=(comboPanelStartMode->GetSelection()  == STARTUP_COMBO_SELECT_SPECIFY);

	chkRawData->Enable(enable);
	chkControl->Enable(enable);
	chkPlotlist->Enable(enable);

	comboPanelStartMode->SetSelection(0);
	programmaticEvent=false;
	curFilter=0;

	backFilterPropGrid=0;

	set_properties();
	do_layout();
	// end wxGlade
}

PrefDialog::~PrefDialog()
{
	filterGridProperties->Destroy();
}

BEGIN_EVENT_TABLE(PrefDialog, wxDialog)
    // begin wxGlade: PrefDialog::event_table
    EVT_LISTBOX(ID_LIST_FILTERS, PrefDialog::OnFilterListClick)
    EVT_PG_CHANGING(ID_GRID_PROPERTIES, PrefDialog::OnFilterCellChange)
    EVT_BUTTON(ID_BTN_RESET_FILTER,PrefDialog::OnResetFilterButton)
    EVT_BUTTON(ID_BTN_RESET_FILTER_ALL,PrefDialog::OnResetFilterAllButton)
    EVT_COMBOBOX(ID_START_COMBO_PANEL, PrefDialog::OnStartupPanelCombo)
    EVT_CHECKBOX(ID_CHECK_PREFER_ORTHO, PrefDialog::OnCheckPreferOrtho)
    EVT_COMMAND_SCROLL(ID_MOUSE_ZOOM_SLIDER, PrefDialog::OnMouseZoomSlider)
    EVT_COMMAND_SCROLL(ID_MOUSE_MOVE_SLIDER, PrefDialog::OnMouseMoveSlider)
    EVT_IDLE(PrefDialog::OnIdle)
    // end wxGlade
END_EVENT_TABLE();


void PrefDialog::createFilterListing()
{
	listFilters->Clear();

	wxString s;
	vector<size_t> v;
	for(size_t ui=0;ui<filterDefaults.size();ui++)
	{
		s=(filterDefaults[ui]->typeString());
		v.push_back(filterDefaults[ui]->getType());
		listFilters->Append(s);
	}

	std::sort(v.begin(),v.end());
	unsigned int pos=0;
	for(unsigned int ui=0;ui<FILTER_TYPE_ENUM_END;ui++)
	{
		//If we have a default, don't create a new filter entry
		if(pos >=v.size() || v[pos] != ui)
		{
			//This is a bit of a hack, but it works.
			Filter *t;
			t=makeFilter(ui);
			s = (t->typeString());
			listFilters->Append(s);
			delete t;
		}
		else
			pos++;
	}
	
}

void PrefDialog::initialise()
{
	createFilterListing();

	//Transfer the movement rates from class  to the slider
	ASSERT(mouseZoomRatePercent  >=sliderCamZoomRate->GetMin() && 
			mouseZoomRatePercent <=sliderCamZoomRate->GetMax());
	ASSERT(mouseMoveRatePercent  >=sliderCamMoveRate->GetMin() && 
			mouseMoveRatePercent <=sliderCamMoveRate->GetMax());


	sliderCamZoomRate->SetValue(mouseZoomRatePercent);
	sliderCamMoveRate->SetValue(mouseMoveRatePercent);



}

void PrefDialog::cleanup()
{
	if(curFilter)
	{
		if(find(filterDefaults.begin(),filterDefaults.end(),
					curFilter) == filterDefaults.end())
		{
			delete curFilter;
			curFilter=0;
		}
	}

	for(unsigned int ui=0;ui<filterDefaults.size();ui++)
		delete filterDefaults[ui];
	filterDefaults.clear();
}


//-------------- Filter page-----------------------
void PrefDialog::getFilterDefaults(vector<Filter *> &defs) const
{
	defs.resize(filterDefaults.size());

	for(unsigned int ui=0;ui<defs.size();ui++)
		defs[ui]=filterDefaults[ui]->cloneUncached();
}

void PrefDialog::setFilterDefaults(const vector<Filter *> &defs)
{
	filterDefaults.resize(defs.size());

	for(unsigned int ui=0;ui<defs.size();ui++)
		filterDefaults[ui]=defs[ui]->cloneUncached();
}


void PrefDialog::OnIdle(wxIdleEvent &evt)
{
	//This is required due to a bug in wx's propertygrid
	// see wx bug #16222
	if(backFilterPropGrid)
	{
		delete backFilterPropGrid;
		backFilterPropGrid=0;
	
	}
}

void PrefDialog::OnFilterListClick(wxCommandEvent &event)
{

	//get the string associated with the current click
	string s;

	//Check to see if we need to delete the current filter
	//or if we have it as a default
	if(find(filterDefaults.begin(),filterDefaults.end(),
				curFilter) == filterDefaults.end())
		delete curFilter;


	Filter *f=0;
	s=stlStr(listFilters->GetString(event.GetSelection()));

	for(size_t ui=0;ui<filterDefaults.size();ui++)
	{
		if(filterDefaults[ui]->getUserString() == s)
		{
			f=filterDefaults[ui];
			break;
		}
	}

	if(!f)
		f=makeFilterFromDefUserString(s);

	ASSERT(f);
	updateFilterProp(f);

	curFilter=f;
}


void PrefDialog::OnFilterCellChange(wxPropertyGridEvent &event)
{
	event.SetValidationFailureBehavior(0);
	//Disallow programmatic event from causing filter update (stack loop->overflow)
	if(programmaticEvent)
	{
		event.Veto();
		return;
	}

	//Grab the changed value	
	std::string value,keyStr; 
	value = getPropValueFromEvent(event);
	
	size_t key;
	keyStr=event.GetProperty()->GetName();
	stream_cast(key,keyStr);

	bool needUpdate;
	curFilter->setProperty(key,value,needUpdate);

	if(find(filterDefaults.begin(),filterDefaults.end(),
				curFilter) == filterDefaults.end())
		filterDefaults.push_back(curFilter);

	//Build the new property grid in an aside,
	// due to wx bug, 
	backFilterPropGrid= new wxPropertyGrid(panelFilters,ID_GRID_PROPERTIES,
					wxDefaultPosition,wxDefaultSize,PROPERTY_GRID_STYLE);
	filterGridProperties->SetExtraStyle(PROPERTY_GRID_EXTRA_STYLE);
	
	std::swap(backFilterPropGrid,filterGridProperties);
	updateFilterProp(curFilter);

	do_filtergrid_prop_layout();
	
	//reforce layout code
	programmaticEvent=false;
}

void PrefDialog::OnResetFilterButton(wxCommandEvent &evt)
{

	if(!curFilter)
	{
		evt.Skip();
		return;
	}

	//Erase the filter from the modified defaults list
	for(size_t ui=0;ui<filterDefaults.size();ui++)
	{
		//If we need to wipe the modified default,
		//do so. Otherwise, do nothing.
		if(filterDefaults[ui] == curFilter)
		{
			delete filterDefaults[ui];
			curFilter=0;

			filterDefaults[ui]=filterDefaults.back();
			filterDefaults.pop_back();

			//Create a new "Cur" filter
			string s;
			s=stlStr(listFilters->GetString(
					listFilters->GetSelection()));
			curFilter=makeFilterFromDefUserString(s);
			
			//Update the prop grid 
			updateFilterProp(curFilter);
			break;
		}
	}

}

void PrefDialog::OnResetFilterAllButton(wxCommandEvent &evt)
{
	if(!curFilter)
	{
		evt.Skip();
		return;
	}

	//Check to see if we have it in the non-"true" default list
	for(size_t ui=0;ui<filterDefaults.size();ui++)
	{
		if(filterDefaults[ui] != curFilter)
		{
			//Delete the modified default
			delete filterDefaults[ui];
		}
	}
	filterDefaults.clear();
	delete curFilter;

	string s;
	s=stlStr(listFilters->GetString(
			listFilters->GetSelection()));

	curFilter=makeFilterFromDefUserString(s);
	updateFilterProp(curFilter);
}


void PrefDialog::updateFilterProp(const Filter *f)
{
	if(!(f->canBeHazardous()))
	{
		filterGridProperties->Enable(true);
		updateFilterPropertyGrid(filterGridProperties,f,"");
	}
	else
	{
		//If the filter is potentially hazardous,
		//then we will disallow editing of the properties.
		//and give a notice to that effect	
		filterGridProperties->Freeze();
		filterGridProperties->Enable(false);
		filterGridProperties->Clear();
		filterGridProperties->Append(new wxPropertyCategory(string("Not Editable for security reasons")));
		filterGridProperties->Thaw();

	}
}

//-------------- End Filter page-----------------------

void PrefDialog::OnCheckPreferOrtho(wxCommandEvent &event)
{
    event.Skip();
    // notify the user that he hasn't implemented the event handler yet
    wxLogDebug(wxT("Event handler (PrefDialog::OnCheckPreferOrtho) not implemented yet"));
}

//-------------- Startup panel page-----------------------

void PrefDialog::OnStartupPanelCombo(wxCommandEvent &event)
{
	setStartupCheckboxEnables(event.GetSelection());
}

void PrefDialog::setStartupCheckboxEnables(unsigned int value)
{
	bool enable=( value  == STARTUP_COMBO_SELECT_SPECIFY);

	chkRawData->Enable(enable);
	chkControl->Enable(enable);
	chkPlotlist->Enable(enable);
	switch(value)
	{
		case STARTUP_COMBO_SELECT_SHOW_ALL:
			comboPanelStartMode->SetToolTip(TRANS("Show all panels when starting program"));
			break;
		case STARTUP_COMBO_SELECT_REMEMBER:
			comboPanelStartMode->SetToolTip(TRANS("Show panels visible at last shutdown when starting program"));
			
			chkRawData->SetValue(true);
			chkControl->SetValue(true);
			chkPlotlist->SetValue(true);
			break;
		case STARTUP_COMBO_SELECT_SPECIFY:
			comboPanelStartMode->SetToolTip(TRANS("Show selected panels when starting program"));
			break;
		default:
			ASSERT(false);
	}
}
void PrefDialog::setPanelDefaults(unsigned int panelMode, bool panelControl,
				bool panelRaw,bool panelPlotlist)
{
	ASSERT(panelMode < comboPanelStartMode->GetCount());

	chkRawData->SetValue(panelRaw);
	chkControl->SetValue(panelControl);
	chkPlotlist->SetValue(panelPlotlist);

	comboPanelStartMode->SetSelection(panelMode);
	setStartupCheckboxEnables(panelMode);

}
void PrefDialog::getPanelDefaults(unsigned int &panelMode, bool &panelControl,
				bool &panelRaw,bool &panelPlotlist) const
{
	panelControl=chkControl->IsChecked();
	panelRaw=chkRawData->IsChecked();
	panelPlotlist=chkPlotlist->IsChecked();

	panelMode=comboPanelStartMode->GetSelection();
}


//-------------- End Startup panel page-----------------------


//------------Mouse page -----------
void PrefDialog::OnMouseZoomSlider(wxScrollEvent &event)
{
	mouseZoomRatePercent=sliderCamZoomRate->GetValue();
}
void PrefDialog::OnMouseMoveSlider(wxScrollEvent &event)
{
	mouseMoveRatePercent=sliderCamMoveRate->GetValue();
}
//------------End mouse page-------------
// wxGlade: add PrefDialog event handlers


void PrefDialog::set_properties()
{
    // begin wxGlade: PrefDialog::set_properties
    SetTitle(TRANS("Preferences"));
    SetSize(wxSize(640, 487));
    comboPanelStartMode->SetToolTip(TRANS("Set the method of panel layout when starting the program"));
    comboPanelStartMode->SetSelection(0);
#ifndef DISABLE_ONLINE_UPDATE
    checkAllowOnlineUpdate->SetToolTip(TRANS("Lets the program check the internet to see if updates to the program version are available, then notifies you about updates now and again."));
#endif
    chkPreferOrtho->SetToolTip(TRANS("By default, use an orthographic camera at startup. State files will override this preference."));
    sliderCamMoveRate->SetToolTip(TRANS("Camera translation, orbit and swivel rates. "));
    sliderCamZoomRate->SetToolTip(TRANS("Camera zooming rate."));

    filterResetDefaultFilter->SetToolTip(TRANS("Reset the filter initial values back to program defaults"));
    filterBtnResetAllFilters->SetToolTip(TRANS("Reset all filter initial values back to program defaults"));
    
    // end wxGlade
}


void PrefDialog::do_layout()
{
	// begin wxGlade: PrefDialog::do_layout
	wxBoxSizer* panelSizer = new wxBoxSizer(wxVERTICAL);
	wxBoxSizer* exitButtonSizer = new wxBoxSizer(wxHORIZONTAL);
    	wxBoxSizer* sizer_5 = new wxBoxSizer(wxVERTICAL);
    	sizerCamSpeed_staticbox->Lower();
	wxStaticBoxSizer* sizerCamSpeed = new wxStaticBoxSizer(sizerCamSpeed_staticbox, wxVERTICAL);
	wxBoxSizer* sizer_6_copy = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer* sizer_6 = new wxBoxSizer(wxHORIZONTAL);
    	sizer_7_staticbox->Lower();
    	wxStaticBoxSizer* sizer_7 = new wxStaticBoxSizer(sizer_7_staticbox, wxHORIZONTAL);
	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
#ifndef DISABLE_ONLINE_UPDATE
	wxStaticBoxSizer* updateSizer = new wxStaticBoxSizer(updateSizer_staticbox, wxVERTICAL);
#endif
	wxStaticBoxSizer* sizer_2 = new wxStaticBoxSizer(sizer_2_staticbox, wxVERTICAL);
	wxBoxSizer* sizer_3 = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer* sizer_4 = new wxBoxSizer(wxVERTICAL);
	do_filtergrid_prop_layout();
//	filterPropSizer_staticbox->Lower();
#if defined(__WIN32) || defined(__WIN64)
	sizer_2->Add(comboPanelStartMode, 0, wxBOTTOM|wxFIXED_MINSIZE, 4);
#else
	sizer_2->Add(comboPanelStartMode, 0, 0,0);

#endif
	sizer_3->Add(20, 20, 0, 0, 0);
	sizer_4->Add(chkControl, 0, 0, 0);
	sizer_4->Add(chkRawData, 0, 0, 0);
	sizer_4->Add(chkPlotlist, 0, 0, 0);
	sizer_3->Add(sizer_4, 1, wxEXPAND, 0);
	sizer_2->Add(sizer_3, 1, wxEXPAND, 0);
	sizer_1->Add(sizer_2, 0, wxALL|wxEXPAND, 5);
#ifndef DISABLE_ONLINE_UPDATE
	updateSizer->Add(checkAllowOnlineUpdate, 0, 0, 0);
	sizer_1->Add(updateSizer, 0, wxALL|wxEXPAND, 5);
#endif
	panelStartup->SetSizer(sizer_1);
	sizer_7->Add(chkPreferOrtho, 0, wxALL, 5);
	sizer_5->Add(sizer_7, 0, wxEXPAND, 0);
	sizer_6->Add(lblMoveSpeed, 0, 0, 0);
	sizer_6->Add(20, 20, 0, 0, 0);
	sizer_6->Add(labelSlowCamMoveRate, 0, 0, 0);
#if defined(__WIN32) || defined(__WIN64)
	sizer_6->Add(sliderCamMoveRate, 1, 0, 0);
#else
	sizer_6->Add(sliderCamMoveRate, 1, wxEXPAND|0, 0);
#endif
	sizer_6->Add(labelFastCamMoveRate, 0, 0, 0);
	sizerCamSpeed->AddStretchSpacer();
	sizerCamSpeed->Add(sizer_6, 1, wxEXPAND, 0);
	sizerCamSpeed->AddStretchSpacer();
	sizer_6_copy->Add(lblZoomSpeed, 0, 0, 0);
	sizer_6_copy->Add(20, 20, 0, 0, 0);
	sizer_6_copy->Add(labelSlowCamZoomRate, 0, 0, 0);
#if defined(__WIN32) || defined(__WIN64)
	sizer_6_copy->Add(sliderCamZoomRate, 1, wxEXPAND|0, 0);
#else
	sizer_6_copy->Add(sliderCamZoomRate, 1, 0, 0);
#endif
	sizer_6_copy->Add(labelSlowFastZoomRate, 0, 0, 0);
	sizerCamSpeed->Add(sizer_6_copy, 1, wxEXPAND, 0);
	sizerCamSpeed->AddStretchSpacer();
    sizer_5->Add(sizerCamSpeed, 1, wxEXPAND, 0);
    notePrefPanels_pane_3->SetSizer(sizer_5);
	notePrefPanels->AddPage(panelFilters, TRANS("Filt. Default"));
	notePrefPanels->AddPage(panelStartup, TRANS("Startup"));
	notePrefPanels->AddPage(notePrefPanels_pane_3, TRANS("Camera"));
	panelSizer->Add(notePrefPanels, 2, wxEXPAND, 0);
	exitButtonSizer->Add(20, 20, 1, wxEXPAND, 0);
	exitButtonSizer->Add(btnOK, 0, wxTOP, 8);
	exitButtonSizer->Add(btnCancel, 0, wxLEFT|wxTOP|wxBOTTOM, 8);
	exitButtonSizer->Add(10, 20, 0, 0, 0);
	panelSizer->Add(exitButtonSizer, 0, wxEXPAND, 0);
	SetSizer(panelSizer);
	Layout();
	// end wxGlade
}

void PrefDialog::do_filtergrid_prop_layout()
{
	panelFilters->SetSizer(NULL);
	wxBoxSizer* filterPropSizer = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer* filterRightSideSizer = new wxBoxSizer(wxVERTICAL);
	wxBoxSizer* resetButtonSizer = new wxBoxSizer(wxHORIZONTAL);
	wxBoxSizer* filterLeftSizer = new wxBoxSizer(wxVERTICAL);
	
	filterLeftSizer->Add(lblFilters, 0, 0, 0);
	filterLeftSizer->Add(listFilters, 1, wxEXPAND, 0);
	filterPropSizer->Add(filterLeftSizer, 1, wxEXPAND, 0);
	filterPropSizer->Add(20, 20, 0, 0, 0);
	filterRightSideSizer->Add(filterGridProperties, 1, wxEXPAND, 0);
	resetButtonSizer->Add(filterBtnResetAllFilters, 0, 0, 0);
	resetButtonSizer->Add(filterResetDefaultFilter, 0, 0, 0);
	resetButtonSizer->Add(20, 20, 1, 0, 0);
	filterRightSideSizer->Add(resetButtonSizer, 0, wxEXPAND, 0);
	filterPropSizer->Add(filterRightSideSizer, 2, wxEXPAND, 0);
	panelFilters->SetSizer(filterPropSizer);

	panelFilters->Fit();
	panelFilters->Layout();
}

