      SUBROUTINE COMVEC(NDEG,TYPE,ORDER,COUNT,AXIS,NATMS,Q,SCRATCH,
     &NORD,V,CHAR)
C
C SUBROUTINE PERFORMS A GIVEN SYMMETRY OPERATION ON COORDINATES AND
C  AN INPUT VECTOR (V), SHUFFLES THE TRANSFORMED VECTOR AND RETURNS 
C  OVERLAP OF TRANSFORMED V WITH ORIGINAL V.  USED TO COMPUTE CHARACTERS
C  OF SYMMETRY OPERATIONS.  FOR N-FOLD DEGENERACIES, V WILL BE N TIMES
C  AS LONG AS Q.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C MXATMS     : Maximum number of atoms currently allowed
C MAXCNTVS   : Maximum number of connectivites per center
C MAXREDUNCO : Maximum number of redundant coordinates.
C
      INTEGER MXATMS, MAXCNTVS, MAXREDUNCO
      PARAMETER (MXATMS=200, MAXCNTVS = 10, MAXREDUNCO = 3*MXATMS)
      DIMENSION V(NDEG*3*NATMS),SCRATCH(9*NATMS)
      DIMENSION NORD(2*MXATMS),Q(3*NATMS)
      CHARACTER*1 TYPE
      INTEGER ORDER,COUNT,AXIS,ERR
      IX1=3*NATMS+1
      IX2=3*NATMS+IX1
      IJ1=NATMS+1
      IJ2=IJ1+NATMS
      CHAR=0.D0
C
C ZERO OUT SCRATCH VECTOR
C

      CALL ZERO(SCRATCH,9*NATMS)
C
C PERFORM PARTICULAR SYMMETRY OPERATION ON COORINATES AND GENERATE
C   "STANDARD" LIST OF CENTERS WITH SORTXYZ.
C
      CALL DOSYOP(TYPE,ORDER,COUNT,AXIS,NATMS,Q,SCRATCH,ERR,0)
      CALL SORTXYZ(SCRATCH(1),SCRATCH(IX1),NORD(IJ1),NATMS)
C
C NOW DO SAME OPERATION TO V INPUT VECTOR AND THEN SWAP ATOM
C  ORDERING TO COMPARE WITH OLD (UNTRANSFORMED) V.
C    
C LOOP OVER LEVEL OF DEGENERACY AND COMPUTE CHARACTER.
C
      DO 10 I=0,NDEG-1
      IBOT=1+3*I*NATMS
      CALL DOSYOP(TYPE,ORDER,COUNT,AXIS,NATMS,V(IBOT),
     &SCRATCH(IX2),ERR,0)
      CALL SWPORD(NORD(1),NORD(IJ1),SCRATCH(IX2),SCRATCH(IX1),NATMS)
      CHAR=xdot(3*NATMS,SCRATCH(IX1),1,V(IBOT),1)+CHAR
 10   CONTINUE
      RETURN
      END
