# Arc Theme

Arc is a flat theme with transparent elements for GTK 3, GTK 2 and various desktop shells, window managers and applications. It's well suited for GTK based desktop environments such as GNOME, Cinnamon, Xfce, Unity, MATE, Budgie etc.

The theme was originally designed and developed by [horst3180](https://github.com/horst3180/arc-theme), but the project has been unmaintained since May 2017.

This fork aims to keep the theme updated with new toolkit and desktop environment versions, resolve pre-existing issues, and improve and polish the theme while preserving the original visual design.

## Arc is available in four variants

##### Arc

![A screenshot of the Arc theme](https://raw.githubusercontent.com/jnsh/arc-theme/master/.github/arc-prv.png)

##### Arc-Darker

![A screenshot of the Arc-Darker theme](https://raw.githubusercontent.com/jnsh/arc-theme/master/.github/arc-darker-prv.png)

##### Arc-Dark

![A screenshot of the Arc-Dark theme](https://raw.githubusercontent.com/jnsh/arc-theme/master/.github/arc-dark-prv.png)

##### Arc-Lighter

![A screenshot of the Arc-Lighter theme](https://raw.githubusercontent.com/jnsh/arc-theme/master/.github/arc-lighter-prv.png)

## Supported toolkits and desktops

Arc comes with themes for the following:
* GTK 2
* GTK 3 >=3.18
* GNOME Shell >=3.18
* Cinnamon >=2.8
* Unity
* Metacity
* Xfwm
* Plank

## Installation

#### Packages

Distribution | Package name | Notes
-------|-------|-------
Arch Linux | [arc-gtk-theme](https://www.archlinux.org/packages/community/any/arc-gtk-theme/) | 
Arch Linux | [arc-gtk-theme-git](https://aur.archlinux.org/packages/arc-gtk-theme-git/) | latest git version, [AUR](https://wiki.archlinux.org/index.php/Arch_User_Repository) package
Debian | [arc-theme](https://packages.debian.org/bullseye/arc-theme) | *bullseye* and newer
Fedora | [arc-theme](https://copr.fedorainfracloud.org/coprs/mhdahmad/workstation/package/arc-theme/) | unofficial COPR repository (see [#71](https://github.com/jnsh/arc-theme/issues/71) for details)
Gentoo | [arc-theme](https://packages.gentoo.org/packages/x11-themes/arc-theme) | 
NixOS | [arc-theme](https://nixos.org/nixos/packages.html?attr=arc-theme&channel=nixpkgs-unstable) | `nixpkgs-unstable` channel
openSUSE | [arc-gtk-theme](https://build.opensuse.org/package/show/openSUSE:Leap:15.2:Update/arc-gtk-theme) | *Leap 15.2* and newer

The theme may be available for other distributions as well. The package is usually named either `arc-theme` or `arc-gtk-theme`, and versions starting with `2020` or later should be built from this repository.

#### Manual installation

See [INSTALL.md](https://github.com/jnsh/arc-theme/blob/master/INSTALL.md) for build instructions, list of dependencies, build options and additional details.

## Bugs

If you find a bug, or have a suggestion for improving the theme, please open an issue at <https://github.com/jnsh/arc-theme/issues>.

## Contributing

If you'd like to contribute to the project, open an pull request, or an issue for discussion. See [HACKING.md](https://github.com/jnsh/arc-theme/blob/master/HACKING.md) for further details.

## License

Arc is available under the terms of the GPL-3.0. See [COPYING](https://github.com/jnsh/arc-theme/blob/master/COPYING) for details.

## Full Preview

![A full screenshot of the Arc theme](http://i.imgur.com/tD1OBQ3.png)
<sub>Screenshot Details: Icons: [Arc](https://github.com/horst3180/arc-icon-theme) | Launcher Icons based on [White Pixel Icons](http://darkdawg.deviantart.com/art/White-Pixel-Icons-252310560) | [Wallpaper](https://pixabay.com/photo-869593/) | Font: Futura Bk bt</sub>
