/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-07 20:09
 */

#include <unistd.h>
#include <signal.h>
#include <iostream> 
#include "TrackerManager.h"
#include "TCPTracker.h"
#include "UDPTracker.h"
#include "utils.h"
#include "log.h"


void* trackerThreadFunc(void* param)
{
	sigset_t sigset;
	sigemptyset(&sigset);
	pthread_sigmask(SIG_SETMASK, &sigset, NULL);
		
	CTrackerManager* manager = (CTrackerManager*)param;
	int ret = manager->svc();
	pthread_exit(&ret);
	
	return NULL;
}

CTrackerManager::CTrackerManager()
: _task(NULL)
, _peerCount(0)
, _seedCount(0)
{
}

CTrackerManager::~CTrackerManager()
{
}

void CTrackerManager::setBTTask(IBTTask* task)
{
	_task = task;
}

IBTTask* CTrackerManager::getBTTask()
{
	return _task;
}

bool CTrackerManager::start()
{
	LOG_INFO("TrackerManager starting");
	
	_peerCount = 0;
	_seedCount = 0;
	
	createTrackers();
	
	_toExit = false;
	pthread_create(&_thrHandle, NULL, trackerThreadFunc, this);	
	
	LOG_INFO("TrackerManager started");
	return true;
}

void CTrackerManager::stop()
{
	LOG_INFO("TrackerManager stopping");
	
	_toExit = true;
	
	stopTrackers();
	
	if(_thrHandle != 0)
	{
		pthread_join(_thrHandle, NULL);
		_thrHandle = 0;
	}	
	
	destroyTrackers();
	
	LOG_INFO("TrackerManager stopped");
}

void CTrackerManager::createTrackers()
{
	for(unsigned int i=0; i<_task->getTorrentFile()->getAnnounceCount(); ++i)
	{
		ITracker* tracker = NULL;
		const char* trackerUrl = _task->getTorrentFile()->getAnnounce(i);
		std::string protocol = getUrlProtocol(trackerUrl);
		
		LOG_DEBUG("Tracker URL = "<<trackerUrl);
		
		if(protocol == "http"
			|| protocol == "HTTP")
		{
			tracker = new CTCPTracker();
		}
		
		if(protocol == "udp"
			|| protocol == "UDP")
		{
			tracker = new CUDPTracker();
		}		
		
		if(tracker != NULL)
		{
			tracker->setUrl(trackerUrl);
			tracker->setTrackerManager(this);
			_trackerList.push_back(tracker);
		}		
	}
}

void CTrackerManager::stopTrackers()
{
	TTrackerList::iterator iter = _trackerList.begin();
	for(; iter!=_trackerList.end(); ++iter)
	{
		ITracker* tracker = *iter;
		tracker->stop();		
	}
}

void CTrackerManager::destroyTrackers()
{
	while(!_trackerList.empty())
	{
		ITracker* tracker = _trackerList.front();
		delete tracker;
		_trackerList.pop_front();
	}
}

int CTrackerManager::svc()
{
	for(; !_toExit; )
	{
		TTrackerList::iterator iter = _trackerList.begin();
		for(; iter!=_trackerList.end(); ++iter)
		{	
			if(_toExit)
			{
				break;
			}
			
			ITracker* tracker = *iter;
			
			if(tracker->getPeerCount() > _peerCount)
			{
				_peerCount = tracker->getPeerCount();
			}
			
			if(tracker->getSeedCount() > _seedCount)
			{
				_seedCount = tracker->getSeedCount();
			}
						
			if(GetTickCount() < tracker->getNextUpdateTick())
			{
				continue;				
			}
			
			tracker->update();
			
			TTrackerState state = tracker->getState();
			if(state == TS_OK)
			{
			}
		}
		
		usleep(100*1000);
	}
	
	return 0;
}

int CTrackerManager::getSeedCount()
{
	return _seedCount;
}

int CTrackerManager::getPeerCount()
{
	return _peerCount;
}
