// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// AUTOGENERATED - DO NOT EDIT!
// This file is generated by sea_pen_client_generator.py

import {loadTimeData} from 'chrome://resources/js/load_time_data.js';

import {SeaPenTemplate} from './constants.js';
import {SeaPenTemplateChip, SeaPenTemplateId, SeaPenTemplateOption} from './sea_pen_generated.mojom-webui.js';


export function getWallpaperTemplates(): SeaPenTemplate[] {
  return [
    {
      id: SeaPenTemplateId.kGlowscapes,
      title: loadTimeData.getString('seaPenTemplateTitleGlowscapes'),
      text: loadTimeData.getStringF(
          'seaPenTemplateGlowscapes',
          `<${SeaPenTemplateChip.kGlowscapesLandscape}>`,
          `<${SeaPenTemplateChip.kGlowscapesFeature}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_glowscapes.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kGlowscapesLandscape,
          [
            {
              value: SeaPenTemplateOption.kGlowscapesLandscapeValley,
              translation: loadTimeData.getString(
                  'seaPenOptionGlowscapesLandscapeValley'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesLandscapeHotSpring,
              translation: loadTimeData.getString(
                  'seaPenOptionGlowscapesLandscapeHotSpring'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_spring.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesLandscapeMeadow,
              translation: loadTimeData.getString(
                  'seaPenOptionGlowscapesLandscapeMeadow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesLandscapeCoralReef,
              translation: loadTimeData.getString(
                  'seaPenOptionGlowscapesLandscapeCoralReef'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_reef.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesLandscapePond,
              translation:
                  loadTimeData.getString('seaPenOptionGlowscapesLandscapePond'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pond.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kGlowscapesFeature,
          [
            {
              value: SeaPenTemplateOption.kGlowscapesFeatureRiver,
              translation:
                  loadTimeData.getString('seaPenOptionGlowscapesFeatureRiver'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesFeatureSaltRock,
              translation: loadTimeData.getString(
                  'seaPenOptionGlowscapesFeatureSaltRock'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_rock.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesFeatureFlower,
              translation:
                  loadTimeData.getString('seaPenOptionGlowscapesFeatureFlower'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flower.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesFeatureWalkway,
              translation: loadTimeData.getString(
                  'seaPenOptionGlowscapesFeatureWalkway'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/walkway.jpg',
            },
            {
              value: SeaPenTemplateOption.kGlowscapesFeaturePool,
              translation:
                  loadTimeData.getString('seaPenOptionGlowscapesFeaturePool'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pool.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kDreamscapes,
      title: loadTimeData.getString('seaPenTemplateTitleDreamscapes'),
      text: loadTimeData.getStringF(
          'seaPenTemplateDreamscapes',
          `<${SeaPenTemplateChip.kDreamscapesObject}>`,
          `<${SeaPenTemplateChip.kDreamscapesMaterial}>`,
          `<${SeaPenTemplateChip.kDreamscapesColors}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_dreamscapes.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kDreamscapesObject,
          [
            {
              value: SeaPenTemplateOption.kDreamscapesObjectBicycle,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesObjectBicycle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycle.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectCastle,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesObjectCastle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/castle.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectBuilding,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesObjectBuilding'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/building.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectBoat,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesObjectBoat'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boat.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectLamp,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesObjectLamp'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lamp.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectTable,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesObjectTable'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/table.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectBridge,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesObjectBridge'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bridge.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectPagoda,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesObjectPagoda'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pagoda.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesObjectPalace,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesObjectPalace'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/palace.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kDreamscapesMaterial,
          [
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialFlowers,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialFlowers'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialSilk,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialSilk'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/silk.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialFelt,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialFelt'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/felt.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialBurlap,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialBurlap'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burlap.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialChiffon,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialChiffon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/chiffon.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialCotton,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialCotton'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cotton.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialFur,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialFur'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fur.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialLace,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialLace'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lace.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialLinen,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialLinen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/linen.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialOrganza,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialOrganza'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/organza.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialTulle,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialTulle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tulle.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialWool,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialWool'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wool.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialYarn,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialYarn'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yarn.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialFleece,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialFleece'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fleece.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialClay,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialClay'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialStone,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialStone'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/stone.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialWood,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialWood'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wood.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialAmethyst,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialAmethyst'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/amethyst.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialLapisLuzuli,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialLapisLuzuli'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lapis_luzuli.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialObsidian,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialObsidian'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/obsidian.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialOpal,
              translation:
                  loadTimeData.getString('seaPenOptionDreamscapesMaterialOpal'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/opal.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesMaterialSapphire,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesMaterialSapphire'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sapphire.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kDreamscapesColors,
          [
            {
              value: SeaPenTemplateOption.kDreamscapesColorsPinkPurple,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesColorsPinkPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesColorsCoralTan,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesColorsCoralTan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_tan.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesColorsCreamOrange,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesColorsCreamOrange'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cream_orange.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesColorsBlueIndigo,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesColorsBlueIndigo'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_indigo.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesColorsGreenTeal,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesColorsGreenTeal'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green_teal.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesColorsBurgundyMaroon,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesColorsBurgundyMaroon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burgundy_maroon.jpg',
            },
            {
              value: SeaPenTemplateOption.kDreamscapesColorsYellowTeal,
              translation: loadTimeData.getString(
                  'seaPenOptionDreamscapesColorsYellowTeal'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow_teal.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kTerrain,
      title: loadTimeData.getString('seaPenTemplateTitleTerrain'),
      text: loadTimeData.getStringF(
          'seaPenTemplateTerrain', `<${SeaPenTemplateChip.kTerrainFeature}>`,
          `<${SeaPenTemplateChip.kTerrainColor}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_terrain.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kTerrainFeature,
          [
            {
              value: SeaPenTemplateOption.kTerrainFeatureSaltLake,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainFeatureSaltLake'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_lake.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureRiver,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainFeatureRiver'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacial_river.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureNorthernLights,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureNorthernLights'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/northern_lights.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureSandDunes,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainFeatureSandDunes'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureClayHills,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainFeatureClayHills'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay_hills.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureSandyLagoon,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureSandyLagoon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sandy_lagoon.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureMountains,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainFeatureMountains'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureBioluminescentBeach,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureBioluminescentBeach'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bioluminescent_beach.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureDifferentPlanet,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureDifferentPlanet'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/different_planet.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureTreeTunnel,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureTreeTunnel'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tree_tunnel.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureBaobabTrees,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureBaobabTrees'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/baobab_trees.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureMistyForest,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureMistyForest'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/misty_forest.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainFeatureCactusForest,
              translation: loadTimeData.getString(
                  'seaPenOptionTerrainFeatureCactusForest'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cactus_forest.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kTerrainColor,
          [
            {
              value: SeaPenTemplateOption.kTerrainColorPink,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorCyan,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorCyan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorWhite,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorWhite'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorPurple,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorBlue,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorYellow,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorMaroonPink,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorMaroonPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/maroon_pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorBluePurple,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorBluePurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorPinkYellow,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorPinkYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kTerrainColorBluePink,
              translation:
                  loadTimeData.getString('seaPenOptionTerrainColorBluePink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_pink.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kSurreal,
      title: loadTimeData.getString('seaPenTemplateTitleSurreal'),
      text: loadTimeData.getStringF(
          'seaPenTemplateSurreal', `<${SeaPenTemplateChip.kSurrealLandscape}>`,
          `<${SeaPenTemplateChip.kSurrealSubject}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_surreal.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kSurrealLandscape,
          [
            {
              value: SeaPenTemplateOption.kSurrealLandscapeMeadow,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealLandscapeMeadow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealLandscapeSaltRock,
              translation: loadTimeData.getString(
                  'seaPenOptionSurrealLandscapeSaltRock'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_rock.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealLandscapeIsland,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealLandscapeIsland'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/island.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealLandscapeLake,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealLandscapeLake'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lake.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealLandscapeBeach,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealLandscapeBeach'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beach.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealLandscapeCliff,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealLandscapeCliff'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cliff.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kSurrealSubject,
          [
            {
              value: SeaPenTemplateOption.kSurrealSubjectFlowers,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealSubjectFlowers'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealSubjectPools,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealSubjectPools'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pool.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealSubjectSnow,
              translation:
                  loadTimeData.getString('seaPenOptionSurrealSubjectSnow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/snow.jpg',
            },
            {
              value: SeaPenTemplateOption.kSurrealSubjectGlowingBubbles,
              translation: loadTimeData.getString(
                  'seaPenOptionSurrealSubjectGlowingBubbles'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glowing_bubbles.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kArt,
      title: loadTimeData.getString('seaPenTemplateTitleArt'),
      text: loadTimeData.getStringF(
          'seaPenTemplateArt', `<${SeaPenTemplateChip.kArtFeature}>`,
          `<${SeaPenTemplateChip.kArtMovement}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_art.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kArtFeature,
          [
            {
              value: SeaPenTemplateOption.kArtFeatureField,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureField'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/field_of_flowers.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureSwamp,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureSwamp'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/swamp.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureBeach,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureBeach'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beach.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureMeadow,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureMeadow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureForest,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureForest'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/forest.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureGlacier,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureGlacier'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacier.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureIsland,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureIsland'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/island.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureJungle,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureJungle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/jungle.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureLake,
              translation: loadTimeData.getString('seaPenOptionArtFeatureLake'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lake.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureCliff,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureCliff'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cliff.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureOcean,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureOcean'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/vast_ocean.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureRiver,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureRiver'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureDune,
              translation: loadTimeData.getString('seaPenOptionArtFeatureDune'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureMountain,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureMountain'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureValley,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureValley'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureWaterfall,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureWaterfall'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/waterfall.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureCanyon,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureCanyon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/canyon.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureCityscape,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureCityscape'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cityscape.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtFeatureVillage,
              translation:
                  loadTimeData.getString('seaPenOptionArtFeatureVillage'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mediterranean_village.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kArtMovement,
          [
            {
              value: SeaPenTemplateOption.kArtMovementAvantGarde,
              translation:
                  loadTimeData.getString('seaPenOptionArtMovementAvantGarde'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/avant-garde.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementRealist,
              translation:
                  loadTimeData.getString('seaPenOptionArtMovementRealist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/realist.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementExpressionist,
              translation: loadTimeData.getString(
                  'seaPenOptionArtMovementExpressionist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/expressionist.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementImpressionist,
              translation: loadTimeData.getString(
                  'seaPenOptionArtMovementImpressionist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/impressionist.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementPostImpressionist,
              translation: loadTimeData.getString(
                  'seaPenOptionArtMovementPostImpressionist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/post-impressionist.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementArtNouveau,
              translation:
                  loadTimeData.getString('seaPenOptionArtMovementArtNouveau'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/art_nouveau.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementBauhaus,
              translation:
                  loadTimeData.getString('seaPenOptionArtMovementBauhaus'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bauhaus.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementWatercolor,
              translation:
                  loadTimeData.getString('seaPenOptionArtMovementWatercolor'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watercolor.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementAbstract,
              translation:
                  loadTimeData.getString('seaPenOptionArtMovementAbstract'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/abstract.jpg',
            },
            {
              value: SeaPenTemplateOption.kArtMovementModernArt,
              translation:
                  loadTimeData.getString('seaPenOptionArtMovementModernArt'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern_art.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kLetters,
      title: loadTimeData.getString('seaPenTemplateTitleLetters'),
      text: loadTimeData.getStringF(
          'seaPenTemplateLetters', `<${SeaPenTemplateChip.kLettersColor}>`,
          `<${SeaPenTemplateChip.kLettersLetter}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_letters.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kLettersColor,
          [
            {
              value: SeaPenTemplateOption.kLettersColorPastel,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorPastel'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pastel.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorBlack,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorBlack'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/black.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorYellow,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorRed,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorRed'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorBlue,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorIndigo,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorIndigo'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorGreen,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorCyan,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorCyan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorPurple,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorOlive,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorOlive'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorGray,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorGray'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorMagenta,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorMagenta'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorNeonGreen,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorNeonGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorLightBlue,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorLightBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorNeonPink,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorNeonPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kLettersColorCoralPink,
              translation:
                  loadTimeData.getString('seaPenOptionLettersColorCoralPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kLettersLetter,
          [
            {
              value: SeaPenTemplateOption.kLettersLetterA,
              translation: 'A',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterB,
              translation: 'B',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterC,
              translation: 'C',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterD,
              translation: 'D',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterE,
              translation: 'E',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterF,
              translation: 'F',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterG,
              translation: 'G',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterH,
              translation: 'H',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterI,
              translation: 'I',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterJ,
              translation: 'J',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterK,
              translation: 'K',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterL,
              translation: 'L',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterM,
              translation: 'M',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterN,
              translation: 'N',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterO,
              translation: 'O',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterP,
              translation: 'P',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterQ,
              translation: 'Q',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterR,
              translation: 'R',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterS,
              translation: 'S',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterT,
              translation: 'T',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterU,
              translation: 'U',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterV,
              translation: 'V',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterW,
              translation: 'W',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterX,
              translation: 'X',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterY,
              translation: 'Y',
            },
            {
              value: SeaPenTemplateOption.kLettersLetterZ,
              translation: 'Z',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kCharacters,
      title: loadTimeData.getString('seaPenTemplateTitleCharacters'),
      text: loadTimeData.getStringF(
          'seaPenTemplateCharacters',
          `<${SeaPenTemplateChip.kCharactersColor}>`,
          `<${SeaPenTemplateChip.kCharactersSubjects}>`,
          `<${SeaPenTemplateChip.kCharactersBackground}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_characters.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kCharactersColor,
          [
            {
              value: SeaPenTemplateOption.kCharactersColorPink,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorYellow,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorRed,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorRed'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorBlue,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorIndigo,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorIndigo'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorGreen,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorCyan,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorCyan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorPurple,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorBrown,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorBrown'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorGold,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorGold'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorRust,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorRust'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorOlive,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorOlive'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorGray,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorGray'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorWhite,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorWhite'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorBeige,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorBeige'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorMagenta,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorMagenta'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorNeonGreen,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersColorNeonGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorLightBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersColorLightBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorNeonPink,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersColorNeonPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersColorCoralPink,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersColorCoralPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kCharactersSubjects,
          [
            {
              value: SeaPenTemplateOption.kCharactersSubjectsLemons,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsLemons'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lemons.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsFlowers,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsFlowers'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsApples,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsApples'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/apples.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsCherries,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsCherries'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cherries.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsOranges,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsOranges'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/oranges.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsPineapples,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsPineapples'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pineapples.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsStrawberries,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsStrawberries'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/strawberries.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsWatermelons,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsWatermelons'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watermelons.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsPotatoes,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsPotatoes'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/potatoes.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsSushi,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsSushi'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sushi.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsBaconAndEggs,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsBaconAndEggs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bacon_and_eggs.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsPizza,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsPizza'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pizza.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsHotDogs,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsHotDogs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_dogs.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsHamburgers,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsHamburgers'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hamburgers.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsRamen,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsRamen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ramen.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsTacos,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsTacos'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tacos.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsBunnies,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsBunnies'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bunnies.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsCats,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsCats'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rectangle_3471020.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsDogs,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsDogs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dogs.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsKoalas,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsKoalas'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/koalas.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsPandas,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsPandas'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pandas.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsPenguins,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsPenguins'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/penguins.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsPigs,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsPigs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pigs.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsSloths,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsSloths'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sloths.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsPonies,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsPonies'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ponies.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsElephants,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsElephants'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/elephants.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsFoxes,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsFoxes'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/foxes.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsOwls,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsOwls'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/owls.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsCrabs,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsCrabs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/crabs.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsBees,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsBees'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bees.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsButterflies,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsButterflies'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/butterflies.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsBicycles,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsBicycles'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycles.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsBoats,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsBoats'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boats.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsBooks,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersSubjectsBooks'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/books.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsCutlery,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsCutlery'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cutlery.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsUmbrellas,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsUmbrellas'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/umbrellas.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersSubjectsInstruments,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersSubjectsInstruments'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/musical_instruments.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kCharactersBackground,
          [
            {
              value: SeaPenTemplateOption.kCharactersBackgroundPurple,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundIndigo,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundIndigo'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundGreen,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundCyan,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundCyan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundBrown,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundBrown'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundGold,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundGold'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundRed,
              translation:
                  loadTimeData.getString('seaPenOptionCharactersBackgroundRed'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundRust,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundRust'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundOlive,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundOlive'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundPink,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundGray,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundGray'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundYellow,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundWhite,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundWhite'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundBeige,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundBeige'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundMagenta,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundMagenta'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundNeonGreen,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundNeonGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundLightBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundLightBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundNeonPink,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundNeonPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kCharactersBackgroundCoralPink,
              translation: loadTimeData.getString(
                  'seaPenOptionCharactersBackgroundCoralPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kFlower,
      title: loadTimeData.getString('seaPenTemplateTitleFlower'),
      text: loadTimeData.getStringF(
          'seaPenTemplateFlower', `<${SeaPenTemplateChip.kFlowerColor}>`,
          `<${SeaPenTemplateChip.kFlowerType}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_flower.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kFlowerColor,
          [
            {
              value: SeaPenTemplateOption.kFlowerColorPink,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerColorPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerColorPurple,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerColorPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerColorBlue,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerColorBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerColorWhite,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerColorWhite'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerColorCoral,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerColorCoral'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerColorYellow,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerColorYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerColorGreen,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerColorGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerColorRed,
              translation: loadTimeData.getString('seaPenOptionFlowerColorRed'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kFlowerType,
          [
            {
              value: SeaPenTemplateOption.kFlowerTypeOrchid,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerTypeOrchid'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/orchid.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeTulip,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerTypeTulip'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tulip.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeBirdOfParadise,
              translation: loadTimeData.getString(
                  'seaPenOptionFlowerTypeBirdOfParadise'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bird_of_paradise.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeRose,
              translation: loadTimeData.getString('seaPenOptionFlowerTypeRose'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/garden_rose.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeDaisy,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerTypeDaisy'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/daisy.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeHydrangea,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerTypeHydrangea'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hydrangea.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeSucculent,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerTypeSucculent'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/succulent.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeGrass,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerTypeGrass'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/grass.jpg',
            },
            {
              value: SeaPenTemplateOption.kFlowerTypeCactusFlower,
              translation:
                  loadTimeData.getString('seaPenOptionFlowerTypeCactusFlower'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cactus_flower.jpg',
            },
          ],
        ],
      ]),
    },
  ];
}

export function getVcBackgroundTemplates(): SeaPenTemplate[] {
  return [
    {
      id: SeaPenTemplateId.kVcBackgroundSimple,
      title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundSimple'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundSimple',
          `<${SeaPenTemplateChip.kVcBackgroundSimpleStyle}>`,
          `<${SeaPenTemplateChip.kVcBackgroundSimpleTone}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_simple.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundSimpleStyle,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundSimpleStyleMinimal,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundSimpleStyleMinimal'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/minimal.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundSimpleStyleZen,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundSimpleStyleZen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/zen.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundSimpleStyleModern,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundSimpleStyleModern'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundSimpleStyleMagical,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundSimpleStyleMagical'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magical.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundSimpleTone,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundSimpleToneNeutral,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundSimpleToneNeutral'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neutral.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundSimpleToneDark,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundSimpleToneDark'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dark.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundSimpleToneLight,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundSimpleToneLight'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kVcBackgroundOffice,
      title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundOffice'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundOffice',
          `<${SeaPenTemplateChip.kVcBackgroundOfficeStyle}>`,
          `<${SeaPenTemplateChip.kVcBackgroundOfficeColor}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_office.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundOfficeStyle,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeStyleModern,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeStyleModern'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeStyleCreative,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeStyleCreative'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/creative.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeStyleTraditional,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeStyleTraditional'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/traditional.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeStyleFuturistic,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeStyleFuturistic'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/futuristic.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundOfficeColor,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeColorNeutral,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeColorNeutral'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neutral.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeColorDark,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeColorDark'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dark.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeColorColorful,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeColorColorful'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/colorful.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundOfficeColorEarthy,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundOfficeColorEarthy'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/earthy.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kVcBackgroundTerrainVc,
      title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundTerrainVc'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundTerrainVc',
          `<${SeaPenTemplateChip.kVcBackgroundTerrainFeature}>`,
          `<${SeaPenTemplateChip.kVcBackgroundTerrainColor}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_terrain_vc.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundTerrainFeature,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureSaltLake,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureSaltLake'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_lake.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureRiver,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureRiver'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacial_river.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundTerrainFeatureNorthernLights,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureNorthernLights'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/northern_lights.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureSandDunes,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureSandDunes'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureClayHills,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureClayHills'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay_hills.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundTerrainFeatureSandyLagoon,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureSandyLagoon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sandy_lagoon.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureMountains,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureMountains'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundTerrainFeatureBioluminescentBeach,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureBioluminescentBeach'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bioluminescent_beach.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundTerrainFeatureFireflyForest,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureFireflyForest'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/firefly_forest.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundTerrainFeatureDifferentPlanet,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureDifferentPlanet'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/different_planet.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureTreeTunnel,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureTreeTunnel'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tree_tunnel.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundTerrainFeatureBaobabTrees,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureBaobabTrees'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/baobab_trees.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundTerrainFeatureMistyForest,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureMistyForest'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/misty_forest.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundTerrainFeatureCactusForest,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainFeatureCactusForest'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cactus_forest.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundTerrainColor,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorCyan,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorCyan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorWhite,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorWhite'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorPurple,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorYellow,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorMaroonPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorMaroonPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/maroon_pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorBluePurple,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorBluePurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorPinkYellow,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorPinkYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundTerrainColorBluePink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundTerrainColorBluePink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_pink.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kVcBackgroundCafe,
      title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundCafe'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundCafe',
          `<${SeaPenTemplateChip.kVcBackgroundCafeStyle}>`,
          `<${SeaPenTemplateChip.kVcBackgroundCafeType}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_cafe.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundCafeStyle,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeStyleCozy,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeStyleCozy'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cozy.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeStyleNeutral,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeStyleNeutral'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neutral.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeStyleDistressed,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeStyleDistressed'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/distressed.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeStyleClassic,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeStyleClassic'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/classic.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeStyleRomantic,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeStyleRomantic'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/romantic.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundCafeType,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeTypeCottage,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeTypeCottage'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cottage.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeTypeModern,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeTypeModern'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeTypeTeaHouse,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeTypeTeaHouse'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tea_house.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeTypeHighTea,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeTypeHighTea'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/high_tea.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCafeTypeOutdoor,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCafeTypeOutdoor'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/outdoor.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kVcBackgroundArt,
      title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundArt'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundArt',
          `<${SeaPenTemplateChip.kVcBackgroundArtFeature}>`,
          `<${SeaPenTemplateChip.kVcBackgroundArtMovement}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_art.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundArtFeature,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureField,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureField'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/field_of_flowers.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureSwamp,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureSwamp'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/swamp.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureBeach,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureBeach'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beach.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureMeadow,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureMeadow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureForest,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureForest'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/forest.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureGlacier,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureGlacier'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacier.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureIsland,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureIsland'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/island.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureJungle,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureJungle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/jungle.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureLake,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureLake'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lake.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureCliff,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureCliff'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cliff.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureOcean,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureOcean'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ocean.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureRiver,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureRiver'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureDune,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureDune'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureMountain,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureMountain'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureValley,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureValley'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureWaterfall,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureWaterfall'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/waterfall.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureCanyon,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureCanyon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/canyon.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureCityscape,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureCityscape'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cityscape.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtFeatureVillage,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtFeatureVillage'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mediterranean_village.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundArtMovement,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementAvantGarde,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementAvantGarde'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/avant-garde.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementRealist,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementRealist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/realist.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementExpressionist,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementExpressionist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/expressionist.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementImpressionist,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementImpressionist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/impressionist.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundArtMovementPostImpressionist,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementPostImpressionist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/post-impressionist.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementArtNouveau,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementArtNouveau'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/art_nouveau.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementBaroque,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementBaroque'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/baroque.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementBauhaus,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementBauhaus'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bauhaus.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementClassicist,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementClassicist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/classicist.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementWatercolor,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementWatercolor'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watercolor.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementAbstract,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementAbstract'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/abstract.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementPointillist,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementPointillist'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pointillist.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementGraphicDesign,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementGraphicDesign'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/graphic.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementModernArt,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementModernArt'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern_art.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementAnime,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementAnime'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/anime.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementPixelArt,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementPixelArt'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pixel_art.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundArtMovementCyberpunk,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundArtMovementCyberpunk'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyberpunk.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kVcBackgroundDreamscapesVc,
      title: loadTimeData.getString(
          'seaPenTemplateTitleVcBackgroundDreamscapesVc'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundDreamscapesVc',
          `<${SeaPenTemplateChip.kVcBackgroundDreamscapesObject}>`,
          `<${SeaPenTemplateChip.kVcBackgroundDreamscapesMaterial}>`,
          `<${SeaPenTemplateChip.kVcBackgroundDreamscapesColors}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_dreamscapes_vc.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundDreamscapesObject,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBicycle,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectBicycle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycle.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectCastle,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectCastle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/castle.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBuilding,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectBuilding'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/building.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBoat,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectBoat'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boat.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectLamp,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectLamp'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lamp.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectTable,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectTable'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/table.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBridge,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectBridge'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bridge.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesObjectLighthouse,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectLighthouse'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lighthouse.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectPagoda,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectPagoda'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pagoda.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectPalace,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectPalace'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/palace.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectTower,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectTower'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tower.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectChair,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesObjectChair'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/chair.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundDreamscapesMaterial,
          [
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFlowers,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialFlowers'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialSilk,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialSilk'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/silk.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFelt,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialFelt'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/felt.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialBurlap,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialBurlap'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burlap.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialChiffon,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialChiffon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/chiffon.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialCotton,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialCotton'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cotton.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFur,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialFur'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fur.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialLace,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialLace'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lace.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialLinen,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialLinen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/linen.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialOrganza,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialOrganza'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/organza.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialTulle,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialTulle'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tulle.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialWool,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialWool'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wool.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialYarn,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialYarn'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yarn.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFleece,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialFleece'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fleece.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialClay,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialClay'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialStone,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialStone'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/stone.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialWood,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialWood'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wood.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialAmethyst,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialAmethyst'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/amethyst.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundDreamscapesMaterialLapisLuzuli,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialLapisLuzuli'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lapis_luzuli.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialObsidian,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialObsidian'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/obsidian.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialOpal,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialOpal'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/opal.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialSapphire,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesMaterialSapphire'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sapphire.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundDreamscapesColors,
          [
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesColorsPinkPurple,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesColorsPinkPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_purple.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesColorsCoralTan,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesColorsCoralTan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_tan.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundDreamscapesColorsCreamOrange,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesColorsCreamOrange'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cream_orange.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesColorsBlueIndigo,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesColorsBlueIndigo'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_indigo.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesColorsGreenTeal,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesColorsGreenTeal'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green_teal.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundDreamscapesColorsBurgundyMaroon,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesColorsBurgundyMaroon'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burgundy_maroon.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundDreamscapesColorsYellowTeal,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundDreamscapesColorsYellowTeal'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow_teal.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kVcBackgroundCharacters,
      title:
          loadTimeData.getString('seaPenTemplateTitleVcBackgroundCharacters'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundCharacters',
          `<${SeaPenTemplateChip.kVcBackgroundCharactersColor}>`,
          `<${SeaPenTemplateChip.kVcBackgroundCharactersSubjects}>`,
          `<${SeaPenTemplateChip.kVcBackgroundCharactersBackground}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_characters.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundCharactersColor,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorYellow,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorRed,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorRed'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorIndigo,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorIndigo'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorGreen,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorCyan,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorCyan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorPurple,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorBrown,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorBrown'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorGold,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorGold'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorRust,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorRust'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorOlive,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorOlive'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorGray,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorGray'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorWhite,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorWhite'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorBeige,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorBeige'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorMagenta,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorMagenta'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorNeonGreen,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorNeonGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorLightBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorLightBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorNeonPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorNeonPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersColorCoralPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersColorCoralPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundCharactersSubjects,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsLemons,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsLemons'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lemons.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsFlowers,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsFlowers'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsApples,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsApples'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/apples.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCherries,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsCherries'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cherries.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsOranges,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsOranges'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/oranges.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersSubjectsPineapples,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsPineapples'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pineapples.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersSubjectsStrawberries,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsStrawberries'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/strawberries.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersSubjectsWatermelons,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsWatermelons'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watermelons.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPotatoes,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsPotatoes'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/potatoes.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsSushi,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsSushi'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sushi.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersSubjectsBaconAndEggs,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsBaconAndEggs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bacon_and_eggs.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPizza,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsPizza'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pizza.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsHotDogs,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsHotDogs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_dogs.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersSubjectsHamburgers,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsHamburgers'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hamburgers.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsRamen,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsRamen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ramen.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsTacos,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsTacos'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tacos.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBunnies,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsBunnies'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bunnies.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCats,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsCats'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rectangle_3471020.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsDogs,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsDogs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dogs.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsKoalas,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsKoalas'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/koalas.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPandas,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsPandas'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pandas.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPenguins,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsPenguins'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/penguins.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPigs,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsPigs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pigs.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsSloths,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsSloths'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sloths.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPonies,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsPonies'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ponies.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsElephants,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsElephants'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/elephants.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsFoxes,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsFoxes'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/foxes.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsOwls,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsOwls'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/owls.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCrabs,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsCrabs'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/crabs.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBees,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsBees'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bees.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersSubjectsButterflies,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsButterflies'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/butterflies.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBicycles,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsBicycles'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycles.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBoats,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsBoats'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boats.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBooks,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsBooks'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/books.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCutlery,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsCutlery'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cutlery.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersSubjectsUmbrellas,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsUmbrellas'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/umbrellas.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersSubjectsInstruments,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersSubjectsInstruments'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/musical_instruments.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundCharactersBackground,
          [
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundPurple,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundPurple'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundIndigo,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundIndigo'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundGreen,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundCyan,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundCyan'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundBrown,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundBrown'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundGold,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundGold'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundRed,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundRed'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundRust,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundRust'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundOlive,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundOlive'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundGray,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundGray'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundYellow,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundYellow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundWhite,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundWhite'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundBeige,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundBeige'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundCharactersBackgroundMagenta,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundMagenta'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersBackgroundNeonGreen,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundNeonGreen'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersBackgroundLightBlue,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundLightBlue'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersBackgroundNeonPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundNeonPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundCharactersBackgroundCoralPink,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundCharactersBackgroundCoralPink'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
            },
          ],
        ],
      ]),
    },
    {
      id: SeaPenTemplateId.kVcBackgroundGlowscapes,
      title:
          loadTimeData.getString('seaPenTemplateTitleVcBackgroundGlowscapes'),
      text: loadTimeData.getStringF(
          'seaPenTemplateVcBackgroundGlowscapes',
          `<${SeaPenTemplateChip.kVcBackgroundGlowscapesLandscape}>`,
          `<${SeaPenTemplateChip.kVcBackgroundGlowscapesFeature}>`),
      preview: [{
        url:
            'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_glowscapes.jpg',
      }],
      options: new Map([
        [
          SeaPenTemplateChip.kVcBackgroundGlowscapesLandscape,
          [
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundGlowscapesLandscapeValley,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesLandscapeValley'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundGlowscapesLandscapeHotSpring,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesLandscapeHotSpring'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_spring.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundGlowscapesLandscapeMeadow,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesLandscapeMeadow'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
            },
            {
              value: SeaPenTemplateOption
                         .kVcBackgroundGlowscapesLandscapeCoralReef,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesLandscapeCoralReef'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_reef.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundGlowscapesLandscapePond,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesLandscapePond'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pond.jpg',
            },
          ],
        ],
        [
          SeaPenTemplateChip.kVcBackgroundGlowscapesFeature,
          [
            {
              value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureRiver,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesFeatureRiver'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
            },
            {
              value:
                  SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureSaltRock,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesFeatureSaltRock'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_rock.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureFlower,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesFeatureFlower'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flower.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureWalkway,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesFeatureWalkway'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/walkway.jpg',
            },
            {
              value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeaturePool,
              translation: loadTimeData.getString(
                  'seaPenOptionVcBackgroundGlowscapesFeaturePool'),
              previewUrl:
                  'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pool.jpg',
            },
          ],
        ],
      ]),
    },
  ];
}
