/*
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "siemens_fernschreiber.h"

#define COMP_(x) siemens_fernschreiber_ ## x

struct cpssp {
	struct sig_serial *port_paper;

	int state;
};

static void
COMP_(recv)(void *_cpssp, uint8_t c)
{
	struct cpssp *cpssp = _cpssp;

	if (c == 31) {
		/* Buchstabe */
		cpssp->state = 0;
	} else if (c == 27) {
		/* Ziffer/Zeichen */
		cpssp->state = 1;
	} else {
		/* Normales Zeichen */
		static const char trans[2][32] = {
			{	/* Buchstabe */
				'#', 'E',
				'\n', /* Zeilentransport */
				'A',
				' ', /* Zwischenraum */
				'S', 'I', 'U',
				'\r', /* Wagentransport */
				'D', 'R', 'J',
				'N', 'F', 'C', 'K',
				'T', 'Z', 'L', 'W',
				'H', 'Y', 'P', 'Q',
				'O', 'B', 'G',
				'\0', /* Ziffer */
				'M', 'X', 'V',
				'\0', /* Buchstabe */
			}, { /* Ziffer/Zeichen */
				'*', '3',
				'\n', /* Zeilentransport */
				'-',
				' ', /* Zwischenraum */
				'\'', '8', '7',
				'\r', /* Wagentransport */
				'@', /* Stern */
				'4', ';',
				',', '[', ':', '(',
				'5', '+', ')', '2',
				'@'/*FIXME*/, /* kleine 10 */
				'6', '0', '1',
				'9', '?', ']',
				'\0', /* Ziffer */
				'.', '/', '-',
				'\0', /* Buchstabe */
			},
		};

		c = trans[cpssp->state][c];

		sig_serial_send(cpssp->port_paper, cpssp, c);
	}
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_serial *port_in,
	struct sig_serial *port_paper
)
{
	static const struct sig_serial_funcs in_funcs = {
		.recv = COMP_(recv),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->state = 0;

	cpssp->port_paper = port_paper;

	sig_serial_connect(port_in, cpssp, &in_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
}
