## How to get help

#### **Do you have questions about how to use GoldenCheetah?**

* Ask any question about how to use GoldenCheetah on [golden-cheetah-users mailing list](https://groups.google.com/forum/#!forum/golden-cheetah-users), ideally after watching the corresponding [tutorials](https://www.goldencheetah.org/#section-tutorials) and/or reading the relevant parts of the [documentation](https://github.com/GoldenCheetah/GoldenCheetah/wiki).

#### **Do you have questions about the source code?**

* Ask any question about how to build GoldenCheetah or anything related to the source code in the [golden-cheetah-developers mailing list](https://groups.google.com/forum/#!forum/golden-cheetah-developers), please see the [GoldenCheetah Developers Guide](https://github.com/GoldenCheetah/GoldenCheetah/wiki/Developers-guide) for addtional information.

## How to contribute to GoldenCheetah

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/GoldenCheetah/GoldenCheetah/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/GoldenCheetah/GoldenCheetah/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and **steps to reproduce the problem** or a **test file** demonstrating the expected behavior that is not occurring.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

* See [GoldenCheetah Guidelines for submitting a patch](https://github.com/GoldenCheetah/GoldenCheetah/wiki/Guidelines-for-submitting-a-patch) for additional information.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability or functionality of GoldenCheetah will generally not be accepted.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in the [golden-cheetah-developers mailing list](https://groups.google.com/forum/#!forum/golden-cheetah-developers) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you want to contribute to GoldenCheetah translations?**

* Translators are very welcome, please see [GoldenCheetah Guidelines for translators](https://github.com/GoldenCheetah/GoldenCheetah/wiki/Guidelines-for-translators)

#### **Do you want to contribute to GoldenCheetah documentation?**

* The [GoldenCheetah wiki](https://github.com/GoldenCheetah/GoldenCheetah/wiki) is open to user's contributions. feel free to add what you consider relevant to make other's users experience smoother.

GoldenCheetah is a volunteer effort. Contributions are welcome!

Thanks!

GoldenCheetah Team
