/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2015,2016,2017,2018, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*! \internal \file
 * \brief Functionality for printing cool strings
 *
 * \ingroup module_utility
 */
#include "gmxpre.h"

#include "coolstuff.h"

#include "config.h"

#include <random>
#include <string>

/* This file is completely threadsafe - keep it that way! */

#include "gromacs/utility/arrayref.h"
#include "gromacs/utility/stringutil.h"

namespace gmx
{

namespace
{

//! Whether printing of cool quotes is enabled
bool beCool()
{
    /* Yes, it is bad to check the environment variable every call,
     * but we dont call this routine often, and it avoids using
     * a mutex for locking the variable...
     */
#if GMX_COOL_QUOTES
    return (getenv("GMX_NO_QUOTES") == nullptr);
#else
    /*be uncool*/
    return false;
#endif
}

//! Return a valid random index into \c arrayRef
template <typename T>
const T &getRandomElement(gmx::ArrayRef<const T> arrayRef)
{
    std::random_device                    generator;
    std::uniform_int_distribution<size_t> distribution(0, arrayRef.size()-1);
    return arrayRef[distribution(generator)];
}

}   // namespace

std::string bromacs()
{
    const char * const bromacsArray[] = {
        "Good gRace! Old Maple Actually Chews Slate",
        "GRoups of Organic Molecules in ACtion for Science",
        "GRowing Old MAkes el Chrono Sweat",
        "Gyas ROwers Mature At Cryogenic Speed",
        "Great Red Owns Many ACres of Sand ",
        "GROningen MAchine for Chemical Simulation",
        "GROup of MAchos and Cynical Suckers",
        "GROtesk MACabre and Sinister",
        "GROwing Monsters And Cloning Shrimps",
        "Great Red Oystrich Makes All Chemists Sane",
        "Good ROcking Metal Altar for Chronical Sinners",
        "Gnomes, ROck Monsters And Chili Sauce",
        "S  C  A  M  O  R  G",
        "Giant Rising Ordinary Mutants for A Clerical Setup",
        "Gromacs Runs On Most of All Computer Systems",
        "Grunge ROck MAChoS",
        "Green Red Orange Magenta Azure Cyan Skyblue",
        "GROningen Mixture of Alchemy and Childrens' Stories",
        "Guyana Rwanda Oman Macau Angola Cameroon Senegal",
        "God Rules Over Mankind, Animals, Cosmos and Such",
        "Georgetown Riga Oslo Madrid Amsterdam Chisinau Stockholm",
        "Gallium Rubidium Oxygen Manganese Argon Carbon Silicon",
        "Glycine aRginine prOline Methionine Alanine Cystine Serine",
        "Gravel Rubs Often Many Awfully Cauterized Sores",
        "Getting the Right Output Means no Artefacts in Calculating Stuff",
        "Gromacs Runs One Microsecond At Cannonball Speeds",
    };

    if (beCool())
    {
        return getRandomElement<const char *>(bromacsArray);
    }
    else
    {
        return "GROMACS";
    }
}

std::string getCoolQuote()
{
    struct Quote
    {
        const char *text;
        const char *author;
    };

    const Quote quoteArray[] = {
        { "If You Want Something Done You Have to Do It Yourself", "Highlander II" },
        { "I Live the Life They Wish They Did", "Tricky" },
        { "Jesus Built My Hotrod", "Ministry" },
        { "Nurture Another Mind, Before Yours Expires", "Arrested Development" },
        { "Hmm, It *Does* Go Well With the Chicken", "Beastie Boys" },
        { "We Can Dance Like Iggy Pop", "Red Hot Chili Peppers" },
        { "It's So Lonely When You Don't Even Know Yourself", "Red Hot Chili Peppers" },
        { "Do the Dog On the Ground", "Red Hot Chili Peppers" },
        { "Don't Push Me, Cause I'm Close to the Edge", "Tricky" },
        { "Don't Push Me, Cause I'm Close to the Edge", "Grandmaster Flash" },
        { "Bum Stikkie Di Bum Stikkie Di Bum Stikkie Di Bum", "R. Slijngaard" },
        { "She's Not Bad, She's Just Genetically Mean", "Captain Beefheart" },
        { "Being Great is Not So Good", "Red Hot Chili Peppers" },
        { "If Life Seems Jolly Rotten, There's Something You've Forgotten !", "Monty Python" },
        { "Your Proposal is Accepted", "Men In Black" },
        { "Don't Grumble, Give a Whistle !", "Monty Python" },
        { "Stop Drinking My Beer !", "The Amps" },
        { "I Calculate My Birthright", "P.J. Harvey" },
        { "You Should Sleep Late Man, It's Much Easier On Your Constitution", "Beastie Boys" },
        { "You're Insignificant", "Tricky" },
        { "Check Your Output", "P. Ahlstrom" },
        { "What Kind Of Guru are You, Anyway ?", "F. Zappa" },
        { "I Had So Many Problem, and Then I Got Me a Walkman", "F. Black" },
        { "I Caught It In the Face", "P.J. Harvey" },
        { "If You Touch Me, You'll Get Shocked", "Beastie Boys" },
        { "This Puke Stinks Like Beer", "LIVE" },
        { "Art For Arts Sake, Money For Gods Sake", "10 CC" },
        { "A Man Needs a Maid", "N. Young" },
        { "No One Could Foresee the End That Came So Fast", "Slayer" },
        { "Stay Cool, This is a Robbery", "Pulp Fiction" },
        { "With a Little Penknife", "Nick Cave" },
        { "In a Deep Deep Well", "Nick Cave" },
        { "I'm Only Faking When I Get It Right", "Soundgarden" },
        { "Sisters Have Always Fascinated Me", "Speech" },
        { "There's No Room For the Weak", "Joy Division" },
        { "All Work and No Play Makes Jack a Dull Boy", "The Shining" },
        { "They Were So Quiet About It", "Pixies" },
        { "Never Get a Chance to Kick Ass", "The Amps" },
        { "Yeah, a Wuzz, Or a Jerk", "F. Black" },
        { "It's Time to Move On", "F. Black" },
        { "It'll Cure Your Asthma Too !", "F. Zappa" },
        { "Out Of Register Space (Ugh)", "Vi" },
        { "May the Force Be With You", "Star Wars" },
        { "You Try to Run the Universe", "Tricky" },
        { "This May Come As a Shock", "F. Black" },
        { "I Wonder, Should I Get Up...", "J. Lennon" },
        { "I Am Testing Your Grey Matter", "Red Hot Chili Peppers" },
        { "Insane In Tha Membrane", "Cypress Hill" },
        { "You Could Make More Money As a Butcher", "F. Zappa" },
        { "I'll Master Your Language, and In the Meantime I'll Create My Own", "Tricky" },
        { "The Stingrays Must Be Fat This Year", "Red Hot Chili Peppers" },
        { "I'm a Wishbone and I'm Breaking", "Pixies" },
        { "You Think That You're Bigger When You Fill the Void", "Urban Dance Squad" },
        { "And It Goes a Little Something Like This", "Tag Team" },
        { "Kissing You is Like Kissing Gravel", "Throwing Muses" },
        { "You Look Better Upside Down", "Throwing Muses" },
        { "Lunatics On Pogo Sticks", "Red Hot Chili Peppers" },
        { "I Could Take You Home and Abuse You", "Magnapop" },
        { "Move Over Hogey Bear", "Urban Dance Squad" },
        { "You Leave Me Dry", "P.J. Harvey" },
        { "Would You Like to Be the Monster Tonight ?", "Captain Beefheart" },
        { "Meet Me At the Coffee Shop", "Red Hot Chili Peppers" },
        { "She Says She Can't Go Home Without a Chaperone", "E. Costello" },
        { "Keep Your Shoes and Socks On, People", "F. Zappa" },
        { "What If None Of Your Dreams Come True ?", "E. Costello" },
        { "Give a Man a Fish", "Arrested Development" },
        { "The Wheels On the Bus Go Round and Round", "J. Richman" },
        { "I Want to Know Right Now", "Meatloaf" },
        { "What's Your Definition Of Dirty ?", "G. Michael" },
        { "Here's the Way It Might End", "G. Michael" },
        { "Breaking the Law, Breaking the Law", "Judas Priest" },
        { "Just Because the Sun Wants a Place In the Sky", "F. Zappa" },
        { "Baseball Heroes Only", "P.J. Harvey" },
        { "One Cross Each", "Monty Python" },
        { "I Snipe Like Wesley", "Urban Dance Squad" },
        { "Hold On Like Cliffhanger", "Urban Dance Squad" },
        { "It Costs Too Much If It Costs a Lot", "Magnapop" },
        { "Every Sperm is Sacred", "Monty Python" },
        { "Everybody Lie Down On the Floor and Keep Calm", "KLF" },
        { "Love is Like Moby Dick, Get Chewed and Get Spat Out", "Urban Dance Squad" },
        { "Don't Follow Me Home", "Throwing Muses" },
        { "All Beauty Must Die", "Nick Cave" },
        { "I Don't Want to Calm Down", "Throwing Muses" },
        { "We're Gonna Hit You Harder", "Scoter" },
        { "Shake Barrels Of Whisky Down My Throat", "Throwing Muses" },
        { "It's Because Of the Metric System", "Pulp Fiction" },
        { "I Don't Want to Catch Anybody Not Drinking.", "Monty Python" },
        { "This Doesn't Suck, It's a Black Hole !", "K.A. Feenstra" },
        { "Let Me Do This", "Urban Dance Squad" },
        { "I Can't Shake It", "Dinosaur Jr" },
        { "Once Again Let Me Do This", "Urban Dance Squad" },
        { "Pretend That You're Hercule Poirot", "TeX" },
        { "Exactly", "Pulp Fiction" },
        { "Sort Of", "Urban Dance Squad" },
        { "Proceed, With Fingers Crossed", "TeX" },
        { "The Universe is Somewhere In Here", "J.G.E.M. Fraaije" },
        { "You're About to Hurt Somebody", "Jazzy Jeff" },
        { "I Should Be the Pimp Of the Year", "Urban Dance Squad" },
        { "Jesus Can't Save You, Though It's Nice to Think He Tried", "Black Crowes" },
        { "My Heart is Just a Muscle In a Cavity", "F. Black" },
        { "Step Aside, Butch", "Pulp Fiction" },
        { "The World is a Friendly Place", "Magnapop" },
        { "Sometimes Life is Obscene", "Black Crowes" },
        { "Take Your Medications and Preparations and Ram It Up Your Snout", "F. Zappa" },
        { "Count the Bubbles In Your Hair", "The Breeders" },
        { "You Own the Sun", "Throwing Muses" },
        { "I Need a Little Poison", "Throwing Muses" },
        { "Ease Myself Into the Body Bag", "P.J. Harvey" },
        { "Motherhood Means Mental Freeze", "The Breeders" },
        { "Correctomundo", "Pulp Fiction" },
        { "I Don't Like Dirt", "The Breeders" },
        { "Bring Out the Gimp", "Pulp Fiction" },
        { "You Could Be a Shadow", "The Breeders" },
        { "If You're So Special Why aren't You Dead ?", "The Breeders" },
        { "The Path Of the Righteous Man is Beset On All Sides With the Iniquities Of the Selfish and the Tyranny Of Evil Men.", "Pulp Fiction" },
        { "Blessed is He Who In the Name Of Charity and Good Will Shepherds the Weak Through the Valley Of Darkness, For He is Truly His Brother's Keeper and the Finder Of Lost Children.", "Pulp Fiction" },
        { "And I Will Strike Down Upon Thee With Great Vengeance and With Furious Anger Those Who Attempt to Poison and Destroy My Brothers.", "Pulp Fiction" },
        { "And You Will Know That My Name is the Lord When I Lay My Vengeance Upon Thee.", "Pulp Fiction" },
        { "Step On the Brakes", "2 Unlimited" },
        { "You Don't Wanna Know", "Pulp Fiction" },
        { "You Dirty Switch, You're On Again", "The Breeders" },
        { "She's a Good Sheila Bruce", "Monty Python" },
        { "I'm Gonna Get Medieval On Your Ass", "Pulp Fiction" },
        { "Three Little Fonzies", "Pulp Fiction" },
        { "It's Not Your Fault", "Pulp Fiction" },
        { "You Will Be Surprised At What Resides In Your Inside", "Arrested Development" },
        { "The Carpenter Goes Bang Bang", "The Breeders" },
        { "Everybody Wants to Be Naked and Famous", "Tricky" },
        { "Royale With Cheese", "Pulp Fiction" },
        { "Shit Happens", "Pulp Fiction" },
        { "You Fill Your Space So Sweet", "F. Apple" },
        { "Push It Real Good", "Salt 'n' Pepa" },
        { "Check Your Input", "D. Van Der Spoel" },
        { "Catholic School Girls Rule", "Red Hot Chili Peppers" },
        { "It Was My Pleasure", "Pulp Fiction" },
        { "We Don't Bother Anyone", "LIVE" },
        { "I Wrapped a Newspaper Round My Head", "F. Zappa" },
        { "Kick the Dog and You Will Die", "Magnapop" },
        { "We All Get the Flu, We All Get Aids", "LIVE" },
        { "One Ripple At a Time", "Bianca's Smut Shack" },
        { "We Have No Money", "E. Clementi" },
        { "Carry Me Away", "Motors" },
        { "I Solve Problems", "Pulp Fiction" },
        { "A Protein is a Set Of Coordinates", "A.P. Heiner" },
        { "It Doesn't Have to Be Tip Top", "Pulp Fiction" },
        { "Everybody's Good Enough For Some Change", "LIVE" },
        { "It's Against the Rules", "Pulp Fiction" },
        { "I'm An Oakman", "Pulp Fiction" },
        { "I Ripped the Cord Right Out Of the Phone", "Capt. Beefheart" },
        { "I Smell Smoke From a Gun Named Extinction", "Pixies" },
        { "With a Lead Filled Snowshoe", "F. Zappa" },
        { "Right Between the Eyes", "F. Zappa" },
        { "BioBeat is Not Available In Regular Shops", "P.J. Meulenhoff" },
        { "Rub It Right Accross Your Eyes", "F. Zappa" },
        { "Shake Yourself", "YES" },
        { "I Am a Wonderful Thing", "Kid Creole" },
        { "Way to Go Dude", "Beavis and Butthead" },
        { "The Microsecond is Within Reach", "P.J. Van Maaren" },
        { "Microsecond Here I Come", "P.J. Van Maaren" },
        { "Confirmed", "Star Trek" },
        { "If You Don't Like Cool Quotes Check Your GMXRC File", "Your Sysadmin" },
        { "When It Starts to Start It'll Never Stop", "Magnapop" },
        { "I'm a Jerk", "F. Black" },
        { "It Wouldn't Hurt to Wipe Once In a While", "Beavis and Butthead" },
        { "Welcome to the Power Age", "2 Unlimited" },
        { "If You See Me Getting High, Knock Me Down", "Red Hot Chili Peppers" },
        { "The Poodle Bites", "F. Zappa" },
        { "The Poodle Chews It", "F. Zappa" },
        { "I Got a Forty Dollar Bill", "F. Zappa" },
        { "We Look Pretty Sharp In These Clothes", "F. Zappa" },
        { "You Got to Relate to It", "A.E. Torda" },
        { "That Was Pretty Cool", "Beavis" },
        { "That Was Really Cool", "Butthead" },
        { "Hang On to Your Ego", "F. Black" },
        { "Pump Up the Volume Along With the Tempo", "Jazzy Jeff" },
        { "Ramones For Ever", "P.J. Van Maaren" },
        { "Have a Nice Day", "R. McDonald" },
        { "Whatever Happened to Pong ?", "F. Black" },
        { "Make the Floor Burn", "2 Unlimited" },
        { "That Was Cool", "Beavis and Butthead" },
        { "These Gromacs Guys Really Rock", "P.J. Meulenhoff" },
        { "You Hear Footsteps Coming From Behind", "Colossal Cave" },
        { "It is Lunchtime", "A.R. Van Buuren" },
        { "You Crashed Into the Swamps", "Silicon Graphics" },
        { "I Am a Poor Lonesome Cowboy", "Lucky Luke" },
        { "Clickety Clickety Click", "System Manager From Hell" },
        { "Been There, Done It", "Beavis and Butthead" },
        { "Load Up Your Rubber Bullets", "10 CC" },
        { "How Do You Like Your Vacation So Far ?", "Speed 2 - Cruise Control" },
        { "It's So Fast It's Slow", "F. Black" },
        { "Ich Bin Ein Berliner", "J.F. Kennedy" },
        { "Take Dehydrated Water On Your Desert Trips", "Space Quest III" },
        { "Your Country Needs YOU", "U.S. Army" },
        { "Don't Eat That Yellow Snow", "F. Zappa" },
        { "I Do It All the Time", "Magnapop" },
        { "Just Give Me a Blip", "F. Black" },
        { "Garbage Collecting...", "GNU Emacs" },
        { "Cut It Deep and Cut It Wide", "The Walkabouts" },
        { "Beat On the Brat With a Baseball Bat", "The Ramones" },
        { "My Head Goes Pop Pop Pop Pop Pop", "F. Black" },
        { "Hangout In the Suburbs If You've Got the Guts", "Urban Dance Squad" },
        { "I Have a Bad Case Of Purple Diarrhea", "Urban Dance Squad" },
        { "It's Bicycle Repair Man !", "Monty Python" },
        { "I've Got Two Turntables and a Microphone", "B. Hansen" },
        { "I Am the Psychotherapist. Please, Describe Your Problems.", "GNU Emacs" },
        { "Watch Out Where the Huskies Go", "F. Zappa" },
        { "I Was Born to Have Adventure", "F. Zappa" },
        { "Is That a Real Poncho ?", "F. Zappa" },
        { "They're Red Hot", "Red Hot Chili Peppers" },
        { "Your Bones Got a Little Machine", "Pixies" },
        { "Oh My God ! It's the Funky Shit", "Beastie Boys" },
        { "Throwing the Baby Away With the SPC", "S. Hayward" },
        { "Engage", "J.L. Picard" },
        { "Everybody is Smashing Things Down", "Offspring" },
        { "Hey Man You Know, I'm Really OK", "Offspring" },
        { "I'm Not Gonna Die Here !", "Sphere" },
        { "I'd Like Monday Mornings Better If They Started Later", "Garfield" },
        { "Here's Another Useful Quote", "S. Boot" },
        { "Wild Pointers Couldn't Drag Me Away", "K.A. Feenstra" },
        { "Let's Go Hang Out In a Mall", "LIVE" },
        { "These are Ideas, They are Not Lies", "Magnapop" },
        { "Bad As This Shit Is, This Shit Ain't As Bad As You Think It Is.", "Jackie Brown" },
        { "My Ass May Be Dumb, But I Ain't No Dumbass.", "Jackie Brown" },
        { "Jesus Not Only Saves, He Also Frequently Makes Backups.", "Myron Bradshaw" },
        { "Player Sleeps With the Fishes", "Ein Bekanntes Spiel Von ID Software" },
        { "Bailed Out Of Edge Synchronization After 10,000 Iterations", "X/Motif" },
        { "God is a DJ", "Faithless" },
        { "Encountered Subspace Anomaly", "Star Trek" },
        { "If I Were You I Would Give Me a Break", "F. Black" },
        { "She Needs Cash to Buy Aspirine For Her Pain", "LIVE" },
        { "Got Coffee, Got Donuts, Got Wasted", "F. Black" },
        { "Boom Boom Boom Boom, I Want You in My Room", "Venga Boys" },
        { "Right Now My Job is Eating These Doughnuts", "Bodycount" },
        { "Wait a Minute, aren't You.... ? (gunshots) Yeah.", "Bodycount" },
        { "If I Wanted You to Understand This, I Would Explain it Better", "J. Cruijff" },
        { "Uh-oh", "Tinky Winky" },
        { "Uh-oh, We're In Trouble", "Shampoo" },
        { "Can't You Make This Thing Go Faster ?", "Black Crowes" },
        { "Get Down In 3D", "George Clinton" },
        { "Uh-oh .... Right Again", "Laurie Anderson" },
        { "(That makes 100 errors; please try again.)", "TeX" },
        { "O My God, They Killed Kenny !", "South Park" },
        { "Drugs are Bad, mmokay", "South Park" },
        { "Let's Unzip And Let's Unfold", "Red Hot Chili Peppers" },
        { "I'd Be Water If I Could", "Red Hot Chili Peppers" },
        { "Space May Be the Final Frontier, But It's Made in a Hollywood Basement", "Red Hot Chili Peppers" },
        { "Everything Must Go", "Red Hot Chili Peppers" },
        { "There's Nothing We Can't Fix, 'coz We Can Do It in the Mix", "Indeep" },
        { "It's Coming Right For Us !", "South Park" },
        { "Disturb the Peace of a John Q Citizen", "Urban Dance Squad" },
        { "Wicky-wicky Wa-wild West", "Will Smith" },
        { "This is Tense !", "Star Wars Episode I The Phantom Menace" },
        { "Fly to the Court of England and Unfold", "Macbeth, Act 3, Scene 6, William Shakespeare" },
        { "Why, how now, Claudio ! Whence Comes this Restraint ?", "Lucio in Measure for measure, Act 1, Scene 4, William Shakespeare" },
        { "In the End Science Comes Down to Praying", "P. v.d. Berg" },
        { "I'm Looking for a New Simulation", "Stone Temple Pilots" },
        { "I Quit My Job Blowing Leaves", "Beck" },
        { "Live for Liposuction", "Robbie Williams" },
        { "All You Need is Greed", "Aztec Camera" },
        { "You Can Be Too Early, You Can Be Too Late and You Can Be On Time", "J. Cruijff" },
        { "RTFM", "B. Hess" },
        { "Why Do *You* Use Constraints ?", "H.J.C. Berendsen" },
        { "Why Weren't You at My Funeral ?", "G. Groenhof" },
        { "You Can Always Go On Ricky Lake", "Offspring" },
        { "As Always Your Logic Is Impeccable", "Tuvok" },
        { "set: No match.", "tcsh" },
        { "AH ....Satisfaction", "IRIX imapd" },
        { "I Need Love, Not Games", "Iggy Pop & Kate Pierson" },
        { "It's Not Dark Yet, But It's Getting There", "Bob Dylan" },
        { "I Used To Care, But Things Have Changed", "Bob Dylan" },
        { "Working in the Burger Kings, Spitting on your Onion Rings", "Slim Shady" },
        { "Does All This Money Really Have To Go To Charity ?", "Rick" },
        { "Yeah, uh uh, Neil's Head !", "Neil" },
        { "In the Meantime, Take Care of Yourself aaand Eachother", "J. Springer" },
        { "I Feel a Great Disturbance in the Force", "The Emperor Strikes Back" },
        { "Do You Have a Mind of Your Own ?", "Garbage" },
        { "I'll Match Your DNA", "Red Hot Chili Peppers" },
        { "All I Ever Wanted Was Your Life", "Red Hot Chili Peppers" },
        { "Just a Minute While I Reinvent Myself", "Red Hot Chili Peppers" },
        { "There's Still Time to Change the Road You're On", "Led Zeppelin" },
        { "Baby, It Aint Over Till It's Over", "Lenny Kravitz" },
        { "It Just Tastes Better", "Burger King" },
        { "'Nay. We are but men.' Rock!", "Tenacious D" },
        { "Cowardly refusing to create an empty archive", "GNU tar" },
        { "Shaken, not Stirred", "J. Bond" },
        { "Oh, There Goes Gravity", "Eminem" },
        { "Is This the Right Room for an Argument ?", "Monty Python" },
        { "I was detained, I was restrained", "The Smiths" },
        { "The Candlelight Was Just Right", "Beastie Boys" },
        { "Fresh Air, Green Hair", "Frank Black" },
        { "Rat-tat-tat Ka boom boom", "The Smashing Pumpkins" },
        { "Youth is wasted on the young", "The Smashing Pumpkins" },
        { "Miggida-Miggida-Miggida-Mac", "Kriss Kross" },
        { "Interfacing Space and Beyond...", "P. J. Harvey" },
        { "Everything He Lacks, He Makes Up In Denial", "Offspring" },
        { "A Pretty Village Burning Makes a Pretty Fire", "David Sandstrom" },
        { "They don't have any beavers in India, so they have to simulate them", "The Tubes" },
        { "It's Calling Me to Break my Bonds, Again...", "Van der Graaf" },
        { "I believe in miracles cause I'm one", "The Ramones" },
        { "Gabba Gabba Hey!", "The Ramones" },
        { "Shoot them in the back now", "The Ramones" },
        { "Read me your scripture and I will twist it", "Red Hot Chili Peppers" },
        { "Good Music Saves your Soul", "Lemmy" },
        { "I believe in miracles cause I'm one", "The Ramones" },
        { "Gabba Gabba Hey!", "The Ramones" },
        { "Good Music Saves your Soul", "Lemmy" },
        { "Move about like a Scientist, lay down, get kissed", "Red Hot Chili Peppars" },
        { "California, R.I.P.", "Red Hot Chili Peppars" },
        { "Don't You Wish You Never Met Her, Dirty Blue Gene?", "Captain Beefheart" },
        { "Nobody Never Learnt No-Nothing from No History", "Gogol Bordello" },
        { "I'd be Safe and Warm if I was in L.A.", "The Mamas and the Papas" },
        { "It's Unacceptable That Choclate Makes You Fat", "MI 3" },
        { "My Brothers are Protons (Protons!), My Sisters are Neurons (Neurons)", "Gogol Bordello" },
        { "Put Me Inside SSC, Let's Test Superstring Theory, Oh Yoi Yoi Accelerate the Protons", "Gogol Bordello" },
        { "Do You Have Sex Maniacs or Schizophrenics or Astrophysicists in Your Family?", "Gogol Bordello" },
        { "Screw a Lightbulb in your Head", "Gogol Bordello" },
        { "Alas, You're Welcome", "Prof. Dumbledore in Potter Puppet Pals" },
        { "Your Shopping Techniques are Amazing", "Gogol Bordello" },
        { "Your Country Raised You, Your Country Fed You, and Just Like Any Other Country it Will Break You", "Gogol Bordello" },
        { "What They Need's a Damn Good Whacking", "The Beatles" },
        { "They Paint Their Faces So Differently From Ours", "Gogol Bordello" },
        { "The Feeling of Power was Intoxicating, Magic", "Frida Hyvonen" },
        { "I was elected to lead, not to read", "President A. Schwarzenegger" },
        { "I managed to get two hours of work done before work", "E. Lindahl" },
        { "Go back to the rock from under which you came", "Fiona Apple" },
        { "It's just the way this stuff is done", "Built to Spill" },
        { "You Fill Me With Inertia", "The Long Blondes" },
        { "I used to be blond and stupid, but now I dyed it black", "Miss Li" },
        { "Aber wenn der Quarterback kommt, um dir die Brille abzunehmen, sag ihm: Danke, die bleibt wo sie ist", "Wir sind Helden" },
        { "Jede der Scherben spiegelt das Licht", "Wir sind Helden" },
        { "Ohne Arbeit waer das Leben oede", "Wir Sind Helden" },
        { "Act like Prometheus would", "Gogol Bordello" },
        { "Making merry out of nothing, like in refugee camp", "Gogol Bordello" },
        { "History has expired", "PubMed Central" },
        { "There's only music to make new ringtones", "Arctic Monkeys" },
        { "Can someone please tell Icarus that he's not the only one falling from the sky?", "Urban Dance Squad" },
        { "Ich war schwanger, mir gings zum kotzen", "Nina Hagen" },
        { "What if you're wrong about the great Ju Ju at the bottom of the sea?", "Richard Dawkins" },
        { "Come on boys, Let's push it hard", "P.J. Harvey" },
        { "Look at these, my work-strong arms", "P.J. Harvey" },
        { "Is it the invisible chemistry stuff?", "Frida Hyvonen" },
        { "Nada e organico, e tudo programado", "Pitty" },
        { "Sitting on a rooftop watching molecules collide", "A Camp" },
        { "Though the path of the comet is sure, it's constitution is not", "Peter Hammill" },
        { "Everything's formed from particles", "Van der Graaf Generator" },
        { "The time for theory is over", "J. Hajdu" },
        { "What's the point, yo, what's the spread?", "Red Hot Chili Peppers" },
        { "If There Is No Guitar In The House, You Know It's Owner Can Not Be Trusted", "Gogol Bordello" },
        { "Carbohydrates is all they groove", "Frank Zappa" },
        { "Never, I said never, compare with experiment", "Magnus Bergh" },
        { "Suzy is a headbanger, her mother is a geek", "The Ramones" },
        { "Now it's filled with hundreds and hundreds of chemicals", "Midlake" },
        { "If it weren't for bad luck, we'd have no luck at all", "The Unthanks" },
        { "There's no way you can rely on an experiment", "Gerrit Groenhof" },
        { "I like to wait, then I feel like I do something", "Carl Caleman" },
        { "Can I have everything louder than everything else?", "Deep Purple" },
        { "He's using code that only you and I know", "Kate Bush" },
        { "Chemical gases filling lungs of little ones", "Black Eyed Peas" },
        { "I've basically become a vegetarian since the only meat I'm eating is from animals I've killed myself", "Mark Zuckerberg" },
        { "Years of calculations and the stress, My science is waiting, nearly complete", "Midlake" },
        { "error: too many template-parameter-lists", "g++" },
        { "Science Won't Change You", "The Talking Heads" },
        { "It Doesn't Seem Right, No Computers in Sight", "Faun Fables" },
        { "Some People Say Not to Worry About the Air", "The Talking Heads" },
        { "It seemed a good idea at first", "Gerrit Groenhof" },
        { "There's no kill like overkill, right?", "Erik Lindahl" },
        { "I removed all the lambda defaults so that users have to think!", "Berk Hess" },
        { "I originally implemented PME to prove that you didn't need it...", "Erik Lindahl" },
        { "Take what you want, but just what you need for survival", "Joe Jackson" },
        { "When the universe has expanded, time will contract", "Franz Ferdinand" },
        { "This really is a pretty scene, could you ask your kid to smile please?", "Joe Jackson" },
        { "England's dancing days are done", "P. J. Harvey" },
        { "The future still looks good, and you've got time to rectify all the things that you should", "G. Harrison" },
        { "If humanity has fled shivering from the starry spaces, it has become minutely at home in the interstices of the speck that it inhabits for an instant", "George H. Mead" },
        { "The scientific method is an integral part of human intelligence, and when it has once been set at work it can only be dismissed by dismissing the intelligence itself", "George H. Mead" },
        { "Der Ball ist rund, das Spiel dauert 90 minuten, alles andere ist Theorie", "Lola rennt" },
        { "Life in the streets is not easy", "Marky Mark" },
        { "How will I know it's working right?", "MGMT" },
        { "There was no preconception on what to do", "Daft Punk" },
        { "It takes money to make money, they say", "Lou Reed" },
        { "The future always gets twisted and turned", "Lisa o Piu" },
        { "Do not go where the path may lead, go instead where there is no path and leave a trail", "Ralph Waldo Emerson" },
        { "I went to Venice and looked at the paintings of Canaletto to understand how he presented perspective, and it turned out it was an exponential law. If I had published this, maybe there would be a Karplus law in art theory as well as the Karplus equation in NMR", "Martin Karplus, Nobel lecture 2013" },
        { "Theoretical chemistry has of course always been important and useful ... at least to theoretical chemists", "Sven Lidin" },
        { "I do not believe continuum electrostatics", "Arieh Warshel, Nobel lecture 2013" },
        { "During my undergraduate work I concluded that electrostatics is unlikely to be important [for enzymes]", "Arieh Warshel, Nobel lecture 2013" },
        { "Martin [Karplus] had a green laser, Arieh [Warshel] had a red laser, I have a *blue* laser", "Michael Levitt, Nobel lecture 2013" },
        { "There's so many shades of black", "The Raconteurs" },
        { "Let us not get carried away with our ideas and take our models too seriously", "Nancy Swanson" },
        { "Unfortunately, \"simulation\" has become increasingly misused to mean nothing more than \"calculation\"", "Bill Jorgensen" },
        { "Physics is a few rules, and with some handwaving you can make up the rest", "Michael Levitt" },
        { "It doesn't pay to make predictions", "Crowded House" },
        { "Strength is just an accident arising from the weakness of others", "Joseph Conrad" },
        { "On the East coast, a purple patch, to show where the jolly pioneers of progress drink the jolly lager-beer", "Joseph Conrad" },
        { "Restraint! What possible restraint?", "Joseph Conrad" },
        { "It was something to at least have a choice of nightmares", "Joseph Conrad" },
        { "You fight, work, sweat, nearly kill yourself, sometimes you do kill yourself, trying to accomplish something - and you can't.", "Joseph Conrad" },
        { "And after some more talk we agreed that the wisdom of rats had been grossly overrated, being in fact no greater than that of men", "Joseph Conrad" },
        { "It's an easy game, just don't let the ball past!", "Szilard Pall" },
        { "The soul? There's nothing but chemistry here", "Breaking Bad" },
        { "You got one part of that wrong. This is not meth.", "Breaking Bad" },
        { "It's easy to remember: a half a kT is equal to five fourths of a kJ/mol.", "Anders Gabrielsson" },
        { "Ubiquitin's just a rock", "Berk Hess" },
        { "... an excellent man, almost worthy of such a wife ...", "Jane Eyre in Jane Eyre by Charlotte Bronte" },
        { "Humbug! Most things free-born will submit to anything for a salary", "Mr. Rochester in Jane Eyre by Charlotte Bronte" },
        { "Like other defaulters, I like to lay half the blame on ill-fortune and adverse circumstances", "Mr. Rochester in Jane Eyre by Charlotte Bronte" },
        { "Either you will be dashed to atoms on crag points, or lifted up and borne by some master-wave into a calmer current", "Charlotte Bronte" },
        { "I ought to warn you, I have no faith", "Jane Eyre in Jane Eyre by Charlotte Bronte" },
        { "... yet the [economic] profession continued to churn out purely theoretical results without even knowing what facts needed to be explained.", "Thomas Piketty" },
        { "Scientists think they are born with logic; God forbid they should study this discipline with a history of more than two and a half millennia.", "Roald Hoffmann" },
        { "In the processing of models we must be especially cautious of the human weakness to think that models can be verified or validated. Especially one's own.", "Roald Hoffmann" },
        { "... and that dream of dreams, a computational model that predicts everything accurately.", "Roald Hoffmann" },
        { "You see it through a charmed medium: you can not discern that the gilding is slime and the silk draperies cobwebs; that the marble is sordid slate, and the polished woods mere refuse chips and scale bark.", "Mr. Rochester in Jane Eyre by Charlotte Bronte" },
        { "I know poetry is not dead, nor genius lost; nor has Mammon gained power over either, to bind or slay; they will both assert their existence, their presence, their liberty and strength again one day.", "Jane Eyre in Jane Eyre by Charlotte Bronte" },
        { "Parallel programming is not about elegance!", "Bill Gropp" },
        { "In a talk you have a choice: You can make one point or no points.", "Paul Sigler" },
        { "Where all think alike, no one thinks very much.", "Walter Lippmann" },
        { "The scientist is not the person who always gives the right answers, he is the one who asks the right questions.", "Claude Levi-Strauss" },
        { "A curious aspect of the theory of evolution is that everybody thinks he understands it.", "Jacques Monod" },
        { "When a distinguished but elderly scientist states that something is possible, he is almost certainly right. When he states that something is impossible, he is very probably wrong.", "Arthur C. Clarke" },
        { "Energy is a very subtle concept. It is very, very difficult to get right.", "Richard Feynman" },
        { "The determined Real Programmer can write FORTRAN programs in any language.", "Ed Post" },
        { "FORTRAN was the language of choice for the same reason that three-legged races are popular.", "Ken Thompson" },
        { "A computer without COBOL and FORTRAN is like a piece of chocolate cake without ketchup or mustard.", "Unix fortune program" },
        { "Consistently separating words by spaces became a general custom about the tenth century A.D., and lasted until about 1957, when FORTRAN abandoned the practice.", "Sun FORTRAN Reference Manual" },
        { "Ludwig Boltzmann, who spent much of his life studying statistical mechanics, died in 1906, by his own hand. Paul Ehrenfest, carrying on the same work, died similarly in 1933. Now it is our turn to study statistical mechanics. Perhaps it will be wise to approach the subject cautiously.", "David Goodstein" },
        { "It all works because Avogadro's number is closer to infinity than to 10.", "Ralph Baierlein" },
        { "In this house, we OBEY the laws of thermodynamics!", "Homer Simpson" },
        { "We mathematicians are all a bit crazy.", "Lev Landau" },
        { "There is no such thing as free energy. Anyone who advocates it does not know what he is talking about.", "Alireza Haghighat" },
        { "In science it often happens that scientists say, 'You know that's a really good argument; my position is mistaken,' and then they would actually change their minds and you never hear that old view from them again. They really do it. It doesn't happen as often as it should, because scientists are human and change is sometimes painful. But it happens every day. I cannot recall the last time something like that happened in politics or religion.", "Carl Sagan" },
        { "There is nothing new to be discovered in physics now. All that remains is more and more precise measurement.", "Lord Kelvin, 1900" },
        { "I love fools' experiments. I am always making them.", "Charles Darwin" },
        { "If you want to save your child from polio, you can pray or you can inoculate... choose science.", "Carl Sagan" },
        { "Molecular biology is essentially the practice of biochemistry without a license.", "Edwin Chargaff" },
        { "If at one time or another I have brushed a few colleagues the wrong way, I must apologize: I had not realized that they were covered with fur.", "Edwin Chargaff" },
        { "It has not escaped our notice that the specific pairing we have postulated immediately suggests a possible copying mechanism for the genetic material.", "Watson & Crick" },
        { "The researcher's art is first of all to find himself a good boss.", "Andre Lwoff" },
        { "What about my nose?", "Aneesur Rahman, responding to an Argonne manager arguing the long hair of Charles Bennett in his group was disreputing the lab; Retold by Michael Klein" },
        { "Science, my lad, is made up of mistakes, but they are mistakes which it is useful to make, because they lead little by little to the truth.", "Jules Verne" },
        { "Don't be afraid of hard work. Nothing worthwhile comes easily. Don't let others discourage you or tell you that you can't do it. In my day I was told women didn't go into chemistry. I saw no reason why we couldn't.", "Gertrude Elion" },
        { "The Nobel Prize is fine, but the drugs I've developed are rewards in themselves.", "Gertrude Elion" },
        { "...sometimes a scream is better than a thesis.", "Ralph Waldo Emerson" },
        { "The great tragedy of science - the slaying of a beautiful hypothesis by an ugly fact.", "Thomas Henry Huxley" },
        { "Dr Pauling, how do you have so many good ideas? Well David, I have a lot of ideas and throw away the bad ones.", "Linus Pauling" },
        { "I try to identify myself with the atoms... I ask what I would do If I were a carbon atom or a sodium atom.", "Linus Pauling" },
        { "I admired Bohr very much. We had long talks together, long talks in which Bohr did practically all the talking.", "Paul Dirac" },
        { "Predictions can be very difficult - especially about the future.", "Niels Bohr" },
        { "For those who want some proof that physicists are human, the proof is in the idiocy of all the different units which they use for measuring energy.", "Richard Feynman" },
        { "Dreams seldom materialize on their own.", "Dian Fossey" },
        { "Above all, don't fear difficult moments. The best comes from them.", "Rita Levi-Montalcini" },
        { "Our struggle today is not to have a female Einstein get appointed as an assistant professor. It is for a woman schlemiel to get as quickly promoted as a male schlemiel.", "Bella Abzug" },
        { "I never thought of stopping, and I just hated sleeping. I can't imagine having a better life.", "Barbara McClintock" },
        { "The farther the experiment is from theory, the closer it is to the Nobel Prize.", "Irene Joliot-Curie" },
        { "I never see what has been done; I only see what remains to be done.", "Marie Curie" },
        { "There is no reason for any individual to have a computer in his home.", "Ken Olsen, head of Digital Equipment Corp." },
        { "People disagree with me. I just ignore them.", "Linus Torvalds on the use of C++ in the kernel" },
        { "Beware of bugs in the above code; I have only proved it correct, not tried it.", "Donald Knuth" },
        { "My greatest contribution to the field of science is that I never entered it.", "Colin Powell" },
        { "We are perhaps not far removed from the time when we shall be able to submit the bulk of chemical phenomena to calculation.", "Joseph Gay-Lussac, 1808" },
        { "If mathematical analysis should ever hold a prominent place in chemistry - an aberration which is happily almost impossible - it would occasion a rapid and widespread degeneration of that science.", "Aguste Comte, 1830" },
        { "Almost without exception, the talented women I have known have believed they had less ability than they actually had. And almost without exception, the talented men I have known believed they had more.", "Gregory Petsko" },
        { "The first 90% of the code accounts for the first 90% of the development time. The remaining 10% of the code accounts for the other 90% of the development time.", "Tom Cargill" },
        { "The Internet?  We are not interested in it.", "Bill Gates, 1993" },
        { "Perl: The only language that looks the same before and after RSA encryption.", "Keith Bostic" },
        { "There are only two things wrong with C++:  The initial concept and the implementation.", "Bertrand Meyer" },
        { "XML is not a language in the sense of a programming language any more than sketches on a napkin are a language.", "Charles Simonyi" },
        { "It has been discovered that C++ provides a remarkable facility for concealing the trivial details of a program - such as where its bugs are.", "David Keppel" },
        { "UNIX is basically a simple operating system. It just takes a genius to understand its simplicity.", "Dennis Ritchie" },
        { "There are two major products that come out of Berkeley: LSD and UNIX. We don't believe this to be a coincidence.", "Jeremy Anderson" },
        { "There are only two kinds of programming languages: those people always bitch about and those nobody uses.", "Bjarne Stroustrup" },
        { "If Java had true garbage collection, most programs would delete themselves upon execution.", "Robert Sewell" },
        { "Documentation is like sex: When it's good it's great, and when it's bad it's better than nothing.", "Linus Torvalds" },
        { "C has the power of assembly language and the convenience of... assembly language.", "Dennis Ritchie" },
        { "The last good thing written in C was Franz Schubert's Symphony Number 9.", "Erwin Dieterich" },
        { "User-friendly, adj.: Programmer-hostile.", "New Hacker's Dictionary" },
        { "First off, I'd suggest printing out a copy of the GNU coding standards, and NOT read it. Burn them, it's a great symbolic gesture.", "Linus Torvalds" },
        { "I invented the term 'Object-Oriented', and I can tell you I did not have C++ in mind.", "Alay Kay, author of Smalltalk" },
        { "FORTRAN, the infantile disorder, by now nearly 20 years old, is hopelessly inadequate for whatever computer application you have in mind today: it is now too clumsy, too risky, and too expensive to use.", "Edsger Dijkstra, 1970" },
        { "Do you know what cations don't like? Dog-ions. Do you know what they like? Pie.", "Tom Cheatham" },
        { "The most exciting phrase to hear in science, the one that heralds new discoveries, is not \"Eureka\" but \"That's funny...\".", "Isaac Asimov" },
        { "Those people who think they know everything are a great annoyance to those of us who do.", "Isaac Asimov" },
        { "No great discovery was ever made without a bold guess.", "Marie Curie" },
        { "Chance favors the prepared mind.", "Louis Pasteur" },
        { "I love deadlines. I like the whooshing sound they make as they fly by.", "Douglas Adams" },
        { "Good judgement is the result of experience; experience is the result of bad judgement.", "Mark Twain" },
        { "No matter how important you are, you are not as important as lunch.", "Randy Pausch" },
        { "There is just one thing I can promise you about the outer-space program: your tax dollar will go farther.", "Wernher von Braun" },
        { "Harvard makes mistakes too, you know. Kissinger taught there.", "Woody Allen" },
        { "Nothing in biology makes sense except in the light of evolution.", "Theodosius Dobzhansky" },
        { "I have a hunch that the unknown sequences of DNA will decode into copyright notices and patent protections.", "Donald Knuth" },
        { "It always takes longer than you think even when you take Hofstadter's Law into account.", "Hofstadter's Law" },
        { "A ship in port is safe, but that is not what ships are for. Sail out to sea and do new things.", "Grace Hopper, developer of COBOL" },
        { "I was told I'd never make it to VP rank because I was too outspoken. Maybe so, but I think men will always find an excuse for keeping women in their 'place.' So, let's make that place the executive suite and start more of our own companies.", "Jean Bartik, ENIAC developer" },
        { "If it's a good idea, go ahead and do it. It's much easier to apologize than it is to get permission.", "Grace Hopper, developer of COBOL" },
        { "This isn't right. This isn't even wrong.", "Wolfgang Pauli" },
        { "Louis Pasteur's theory of germs is ridiculous fiction.", "Pierre Pachet, Professor of Physiology at Toulouse, 1872" },
        { "Research ! A mere excuse for idleness; it has never achieved, and will never achieve any results of the slightest value.", "Benjamin Jowett, British theologian, 1817-93" },
        { "Problems worthy of attack prove their worth by hitting back.", "Piet Hein" },
        { "You should never bet against anything in science at odds of more than about 10^12 to 1.", "Ernest Rutherford" },
        { "X-rays will prove to be a hoax.", "Lord Kelvin, while president of the Royal Society" },
        { "If you're doing I/O, you're doing it wrong!", "Cannada \"Drew\" Lewis" },
        { "The easiest way to scale well is to have bad single-core performance", "Blind Freddie" },
        { "Heard a talk introducing a new language called Swift, from a guy named Wozniak, and it had nothing to do with Apple!", "Adam Cadien" },
        { "When doing HPC, don't communica", "Jim Demmel" },
        { "Today we're not going to optimize our CUDA code, cause that's just a rabbit hole of misery!", "Tim Warburton" },
        { "Big Data is like teenage sex: everyone talks about it, nobody really knows how to do it, everyone thinks everyone else is doing it, so everyone claims they are doing it...", "Dan Ariely" },
        { "It seems likely that significant software contributions to existing scientific software projects are not likely to be rewarded through the traditional reputation economy of science. Together these factors provide a reason to expect the over-production of independent scientific software packages, and the underproduction of collaborative projects in which later academics build on the work of earlier ones.", "Howison & Herbsleb" },
        { "On average, it takes twenty years for the world's largest super computer to shrink down to the size of your laptop.", "Pete Beckman" },
        { "When using an abacus, a human can achieve about 0.1 flops/watt. Super-computers achieve about 2 gigaflops/watt.", "John Linford" },
        { "Try to calculate the numbers that have been", "The Smoke Fairies" },
        { "Please implement proper hep writing", "GROMACS" },
        { "The three principal virtues of a programmer are Laziness, Impatience, and Hubris", "Larry Wall" },
        { "You're like them scientists on TV explaining black holes. More you talk, less I get", "Jess Walter" },
        { "Wedged as we are between two eternities of idleness, there is no excuse for being idle now", "Anthony Burgess" },
        { "Even the *healthy* people move in clouds of cigarette smoke, women straining polyester, men in raggedly cutoffs slathering mayonnaise on foot-long hot dogs. It's as if the hotel were hosting a conference on adult onset diabetes", "Jess Walter" },
        { "In practice, throwing traditional norms and values overboard results not in perfect freedom and relationships based on reason, but in chaos and fear", "Paul Verhaeghe" },
        { "When I asked a younger colleague at the university how he had been able to change his research field several times within a decade or so, he answered: \"It's just a question of new software\"", "Paul Verhaeghe" },
        { "Never mind, death professor, your structure's fine", "TV on the Radio" },
        { "Come and play on the hospital roof, I got something that's yours", "Sherlock" },
        { "Njuta men inte frossa, springa men inte fly", "Paganus" },
        { "Misslycka kan man med all kod", "Mats Nylen" },
        { "Two guys can move very fast when they're motivated enough and unemployed", "Eric Betzig" },
        { "A protein is a chain of letters.", "Julie Bernauer" },
        { "The best way to obtain plausible negative examples is to run a docking program with a biophysics-based function.", "Julie Bernauer" },
        { "I think everybody should like everybody.", "Andy Warhol" },
        { "But I always say, one's company, two's a crowd, and three's a party.", "Andy Warhol" },
        { "We'll celebrate a woman for anything, as long as it's not her talent.", "Colleen McCullough" },
        { "I believe the big bang of self-driving cars is about to come.", "Jen-Hsun Huang, CEO NVIDIA" },
        { "This is where we have been working hard to push down performance.", "Szilard Pall, GTC 2015 talk" },
        { "Some of these pro-drug messages come from popular culture.", "John Walters" },
        { "Don't pay any attention to what they write about you. Just measure it in inches.", "Andy Warhol" },
        { "Art is what you can get away with.", "Andy Warhol" },
        { "I spent a lot of money on booze, birds and fast cars. The rest I just squandered.", "George Best" },
        { "The only greatness for man is immortality.", "James Dean" },
        { "Do not quench your inspiration and your imagination; do not become the slave of your model.", "Vincent Van Gogh" },
        { "You always pass failure on the way to success.", "Mickey Rooney" },
        { "I always seem to get inspiration and renewed vitality by contact with this great novel land of yours which sticks up out of the Atlantic.", "Winston Churchill" },
        { "I am at two with nature.", "Woody Allen" },
        { "I'm no model lady. A model's just an imitation of the real thing.", "Mae West" },
        { "Science is the great antidote to the poison of enthusiasm and superstition.", "Adam Smith, Wealth of Nations, 1776" },
        { "Science is a wonderful thing if one does not have to earn one's living at it.", "Albert Einstein" },
        { "Science is the record of dead religions.", "Oscar Wilde" },
        { "Physics isn't a religion. If it were, we'd have a much easier time raising money.", "Leon Lederman" },
        { "It is now quite lawful for a Catholic woman to avoid pregnancy by a resort to mathematics, though she is still forbidden to resort to physics and chemistry.", "Henry Louis Mencken" },
        { "An expert is a person who has made all the mistakes that can be made in a very narrow field.", "Niels Bohr" },
        { "In my opinion, we don't devote nearly enough scientific research to finding a cure for jerks.", "Bill Watterson" },
        { "Scientists do not join hands every Sunday and sing \"Yes gravity is real! I know gravity is real! I will have faith! I believe in my heart that what goes up, up, up must come down, down, down. Amen!\" If they did, we would think they were pretty insecure about the concept.", "Dan Barker" },
        { "Take away paradox from the thinker and you have a professor.", "Soren Kirkegaard" },
        { "Measuring programming progress by lines of code is like measuring aircraft building progress by weight.", "Bill Gates" },
        { "Protons give an atom its identity, electrons its personality.", "Bill Bryson" },
        { "Money won't buy happiness, but it will pay the salaries of a large research staff to study the problem.", "Bill Vaughan" },
        { "Torture numbers, and they'll confess to anything.", "Greg Easterbrook" },
        { "Should we force science down the throats of those that have no taste for it? Is it our duty to drag them kicking and screaming into the twenty-first century? I am afraid that it is.", "George Porter" },
        { "A computer would deserve to be called intelligent if it could deceive a human into believing that it was human.", "Alan Turing" },
        { "Any one who considers arithmetical methods of producing random digits is, of course, in a state of sin.", "John von Neumann" },
        { "No, no, you're not thinking, you're just being logical.", "Niels Bohr" },
        { "As an adolescent I aspired to lasting fame, I craved factual certainty, and I thirsted for a meaningful vision of human life -- so I became a scientist. This is like becoming an archbishop so you can meet girls.", "Matt Cartmill" },
        { "Problems worthy / of attack / prove their worth / by hitting back.", "Piet Hein" },
        { "Naive you are if you believe life favours those who aren't naive.", "Piet Hein" },
        { "Never measure the height of a mountain until you have reached the top. Then you will see how low it was.", "Dag Hammarskjold" },
        { "Praise those of your critics for whom nothing is up to standard.", "Dag Hammarskjold" },
        { "Inventions have long since reached their limit, and I see no hope for further development.", "Julius Sextus Frontinus, 1st century A.D." },
        { "Lottery: A tax on people who are bad at math.", "Ambrose Bierce" },
        { "Even if you are on the right track, you will get run over if you just sit there.", "Will Rogers" },
        { "Programming today is a race between software engineers striving to build bigger and better idiot-proof programs, and the universe trying to build bigger and better idiots. So far, the universe is winning.", "Rick Cook" },
        { "There's a limit to how many times you can read how great you are and what an inspiration you are, but I'm not there yet.", "Randy Pausch" },
        { "Throughout my academic career, I'd given some pretty good talks. But being considered the best speaker in the computer science department is like being known as the tallest of the Seven Dwarfs.", "Randy Pausch" },
        { "If everything seems under control, you're just not going fast enough.", "Mario Andretti" },
        { "Sincerity is the key to success. Once you can fake that you’ve got it made.", "Groucho Marx" },
        { "This work contains many things which are new and interesting. Unfortunately, everything that is new is not interesting, and everything which is interesting, is not new.", "Lev Landau" },
        { "Does college pay? They do if you are a good open-field runner.", "Will Rogers" },
        { "Academe, n.: An ancient school where morality and philosophy were taught. Academy, n.: A modern school where football is taught.", "Ambrose Bierce" },
        { "This simulation is not as the former.", "Malvolio, Act II, scene V of Shaphespeare's Twelfth Night" },
        { "Here, kitty, kitty...", "Erwin Schroedinger" },
        { "Sir, spare your threats: The bug which you would fright me with I seek.", "Hermione, Act III, scene II of Shakespeare's Winter's Tale" },
        { "Erwin with his psi can do / Calculations quite a few. / But one thing has not been seen / Just what psi really mean.", "Felix Bloch" },
        { "Only entropy comes easy.", "Anton Chekov" },
        { "The loveliest theories are being overthrown by these damned experiments; it is no fun being a chemist any more.", "Justus von Liebig, letter to J.J. Berzelius 1834" },
        { "If all else fails, immortality can always be assured by spectacular error.", "John Kenneth Galbraith" },
        { "Always code as if the person who ends up maintaining your code is a violent psychopath who knows where you live.", "Martin Golding" },
        { "If I have not seen as far as others, it is because giants were standing on my shoulders.", "Hal Abelson" },
        { "Weaseling out of things is important to learn. It's what separates us from the animals... except the weasels.", "Homer Simpson" },
        { "In science, truth always wins.", "Max Perutz" },
        { "Creativity in science, as in art, cannot be organized. It arises spontaneously from individual talent. Well-run laboratories can foster it, but hierarchical organizations, inflexible bureaucratic rules, and mountains of futile paperwork can kill it.", "Max Perutz" },
        { "Every electron is sacred.", "Greg McMullan, on Cryo-EM detectors" },
        { "Science adjusts its views based on what's observed. Faith is the denial of observation so that belief can be preserved.", "Tim Minchin" },
        { "Isn’t this enough? Just this world? Just this beautiful, complex wonderfully unfathomable world? How does it so fail to hold our attention that we have to diminish it with the invention of cheap, man-made myths and monsters?", "Tim Minchin" },
        { "If you open your mind too much, your brains will fall out.", "Tim Minchin" },
        { "\"Everything organic and natural is good\" - ignoring the fact that organic natural substances include arsenic and poo and crocodiles. And everything chemical is bad, ignoring the fact that... everything is chemicals.", "Tim Minchin" },
        { "A program that has not been tested does not work.", "Bjarne Stroustrup" },
        { "You could give Aristotle a tutorial. And you could thrill him to the core of his being. Such is the privilege of living after Newton, Darwin, Einstein, Planck, Watson, Crick and their colleagues.", "Richard Dawkins" },
        { "A robot will be truly autonomous when you instruct it to go to work and it decides to go to the beach instead.", "Brad Templeton" },
        { "If you want to destroy my sweater, hold this thread as I walk away.", "Weezer" },
        { "To survive science you have to become science.", "Gerrit Groenhof" },
        { "Contemplating answers that could break my bonds.", "Peter Hammill" },
        { "I always think there is something foreign about jolly phrases at breakfast.", "Mr. Carson in Downtown Abbey" },
        { "According to my computations we're overdue for a transformation.", "Jackson Browne" },
        { "Therefore, things must be learned only to be unlearned again or, more likely, to be corrected.", "Richard Feynman" },
        { "You wouldn't walk into a chemistry lab and mix two clear liquids together just because they look pretty much the same, would you?", "Justin Lemkul" },
        { "They don't have half hours in the north", "Carl Caleman" },
        { "Safety lights are for dudes", "Ghostbusters 2016" },
        { "It's 2040 now. Our President is a plant.",  "Ghostbusters 2016" },
        { "It's just B I O L O G Y, can't you see?", "Joe Jackson" },
        { "Input, output, electricity", "Joni Mitchell" },
        { "Your daddy ain't your daddy but your daddy don't know", "Dalahan" },
        { "Why is the Earth moving 'round the sun? Floating in the vacuum with no purpose, not a one", "Fleet Foxes" },
        { "Everybody has a plan until they get punched in the mouth", "Mike Tyson" },
        { "Sacrifices must be made", "Otto Lilienthal, dying after having crashed with his glider in 1896" },
        { "The secret to getting ahead is getting started", "Mark Twain" },
        { "Water is just water", "Berk Hess" },
        { "GROMACS First : Making MD Great Again", "Vedran Miletic" },
        { "You still have to climb to the shoulders of the giants", "Vedran Miletic" },
        { "The road to openness is paved with git commits", "Vedran Miletic" },
        { "Performance and power are great targets for tuning, but really you want to tune for money!", "Erik Lindahl" },
        { "Here are all the 'gmx' tools... but no gmx writethesis", "Christian Blau" },
        { "The best part of winter in Stockholm is going to Australia", "Mark Abraham" },
        { "If you don't know what you're doing, use a (M)BAR-based method", "Erik Lindahl" },
        { "All models are wrong, but some are useful.", "George Box" },
        { "If your experiment needs a statistician, you need a better experiment.", "Ernest Rutherford" },
        { "Facts are stubborn things, but statistics are more pliable.", "Laurence Peter" },
        { "In ancient times they had no statistics so they had to fall back on lies.", "Stephen Leacock" },
        { "If at first you don't succeed, try two more times so that your failure is statistically significant.", "Dallas Warren" },
        { "Your theory is crazy, but it's not crazy enough to be true.", "Niels Bohr" },
        { "Science may never come up with a better office communication system than the coffee break.", "Earl Wilson" },
        { "A scientific truth does not triumph by convincing its opponents and making them see the light, but rather because its opponents eventually die and a new generation grows up that is familiar with it.", "Max Planck" },
        { "Computer science is no more about computers than astronomy is about telescopes", "Edsger Dijkstra" },
        { "If we knew what it was we were doing, it would not be called research, would it?", "Albert Einstein" },
        { "I have not failed. I've just found 10,000 ways that won't work", "Thomas Alva Edison" },
        { "The public have an insatiable curiosity to know everything, except what is worth knowing.", "Oscar Wilde" },
        { "Philosophy of science is about as useful to scientists as ornithology is to birds.", "Richard Feynman" },
        { "I had trouble with physics in college. When I signed up I thought it said psychics.", "Greg Tamblyn" },
        { "There’s an old saying among scientific guys: “You can’t make an omelet without breaking eggs, ideally by dropping a cement truck on them from a crane.", "Dave Barry" },
        { "Occams Razor is the scientific principle that, all things being equal, the simplest explanation is always the dog ate my homework.", "Greg Tamblyn" },
        { "When you get right down to it, almost every explanation Man came up with for anything until about 1926 was stupid.", "Dave Barry" },
        { "We all understand the twinge of discomfort at the thought that we share a common ancestor with the apes. No one can embarrass you like a relative.", "Neal DeGrasse Tyson" },
        { "In physics, you don't have to go around making trouble for yourself. Nature does it for you.", "Frank Wilczek" },
        { "Every revolutionary idea seems to evoke three stages of reaction. They may be summed up by the phrases: (1) It's completely impossible. (2) It's possible, but not worth doing. (3) I said it was a good idea all along.", "Arthur C. Clarke" },
        { "Computers are like humans - they do everything except think.", "John von Neumann" },
        { "With four parameters I can fit an elephant, and with five I can make him wiggle his trunk.", "John von Neumann" },
        { "Christianity may be OK between consenting adults in private but should not be taught to young children.", "Francis Crick" },
        { "All approaches at a higher level are suspect until confirmed at the molecular level.", "Francis Crick" },
        { "We haven’t the money, so we’ve got to think.", "Ernest Rutherford" },
        { "Furious activity is no substitute for understanding.", "H.H. Williams" },
        { "Discovery: A couple of months in the laboratory can frequently save a couple of hours in the library.", "Anonymous" },
        { "Never replicate a successful experiment.", "Fett's law." },
        { "Raw data is like raw sewage, it requires some processing before it can be spread around. The opposite is true of theories.", "Jim Carr" },
        { "A university faculty is 500 egotists with a common parking problem.", "Keith Sullivan" },
        { "Studying expands knowledge. Knowledge is power. Power corrupts. Corruption is a crime. Crime doesn't pay.", "Anonymous" },
        { "A professor is one who talks in someone else's sleep.", "W.H. Auden" },
        { "A tidy laboratory means a lazy chemist.", "J.J. Berzelius" },
        { "Microbiology Lab - Staph Only.", "Anonymous" },
        { "I can’t go to a restaurant and order food because I keep looking at the fonts on the menu. Five minutes later I realize that it’s also talking about food.", "Donald Knuth" },
        { "Physics is like sex: sure, it may give some practical results, but that’s not why we do it", "Richard P. Feynman" },
        { "Statistics: The only science that enables different experts using the same figures to draw different conclusions.", "Evan Esar" },
        { "If I could remember the names of all these particles, I’d be a botanist.", "Albert Einstein" },
        { "Science... never solves a problem without creating ten more.", "George Bernard Shaw" },
        { "A mathematician is a blind man in a dark room looking for a black cat which isn't there.", "Charles Darwin" },
        { "Nothing shocks me. I'm a scientist.", "Harrison Ford as Indiana Jones" },
        { "There is an infinite set A that is not too big.", "John von Neumann" },
        { "If it's all right with Dirac, it's all right with me.", "Enrico Fermi, on being told that there was experimental evidence He-3 nuclei obey Fermi-Dirac statistics." },
        { "I cannot think of a single one, not even intelligence.", "Enrico Fermi, when asked what characteristics physics Nobel laureates had in common." },
        { "Heavier-than-air flying machines are impossible.", "Lord Kelvin, President of Royal Society, 1895." },
        { "All that glitters may not be gold, but at least it contains free electrons.", "John Desmond Baernal" },
        { "It is disconcerting to reflect on the number of students we have flunked in chemistry for not knowing what we later found to be untrue.", "Robert L. Weber" },
        { "People are DNA's way of making more DNA.", "Edward O. Wilson" },
        { "The best model of a cat is another cat..., specially the same cat.", "Arturo Rosenblueth" },
        { "Computer dating is fine, if you are a computer.", "Rita May Brown" },
        { "The most likely way for the world to be destroyed, most experts agree, is by accident. That’s where we come in; we’re computer professionals. We cause accidents.", "Nathaniel Borenstein" },
        { "An intellectual is someone who has found something more interesting than sex.", "Edgar Wallace" },
        { "Base eight is just like base ten really, if you’re missing two fingers.", "Tom Lehrer" },
        { "If 10 years from now, when you are doing something quick and dirty, you suddenly visualize that I am looking over your shoulders and say to yourself: ‘Dijkstra would not have liked this’, well that would be enough immortality for me.", "Edsger Dijkstra" },
        { "Memory is like an orgasm. It’s a lot better if you don’t have to fake it.", "Seymour Cray, on virtual memory" },
        { "A computer once beat me at chess, but it was no match for me at kick boxing.", "Emo Philips" },
        { "Home computers are being called upon to perform many new functions, including the consumption of homework formerly eaten by the dog.", "Doug Larson" },
        { "Forcefields are like dating; things go fine for a while and then sometimes it goes really bad.", "Alex MacKerell" },
        { "This type of advanced sampling techniques... which are not so advanced, really.", "Viveca Lindahl, on AWH, at her thesis defense." },
        { "C++ is tricky. You can do everything. You can even make every mistake.", "Nicolai Josuttis, CppCon2017" },
        { "Why would the backup server database get corrupted anyway?", "Stefan Fleischmann -- system administrator, physicist, optimist." },
        { "Teaching quantum computing is like teaching computer science at Hogwarts.", "Thomas Sterling, ISC2018 keynote" },
        { "It is unfortunate that the authors did not make better use of all the electric power energy that went into these massive computations.", "An anonymous referee" },
        { "This is extremely unlikely.", "Berk Hess" },
        { "Nothing is more anarchic than power.", "Pier Paolo Pasolini" },
    };

    if (beCool())
    {
        auto quote = getRandomElement<Quote>(quoteArray);
        return formatString("GROMACS reminds you: \"%s\" (%s)", quote.text, quote.author);
    }
    else
    {
        return "Thanx for Using GROMACS - Have a Nice Day";
    }
}

}  // namespace gmx
