/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableSortedMapTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testBuilderGenerics_SelfComparable() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testBuilderGenerics_SelfComparable();
}

public void testBuilderGenerics_SuperComparable() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testBuilderGenerics_SuperComparable();
}

public void testHeadMapExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testHeadMapExclusive();
}

public void testHeadMapInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testHeadMapInclusive();
}

public void testMutableValues() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testMutableValues();
}

public void testNullGet() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testNullGet();
}

public void testNullValuesInCopyOfEntries() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testNullValuesInCopyOfEntries();
}

public void testNullValuesInCopyOfMap() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testNullValuesInCopyOfMap();
}

public void testSubMapExclusiveExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testSubMapExclusiveExclusive();
}

public void testSubMapExclusiveInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testSubMapExclusiveInclusive();
}

public void testSubMapInclusiveExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testSubMapInclusiveExclusive();
}

public void testSubMapInclusiveInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testSubMapInclusiveInclusive();
}

public void testTailMapExclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testTailMapExclusive();
}

public void testTailMapInclusive() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest testCase = new com.google.common.collect.ImmutableSortedMapTest();
  testCase.testTailMapInclusive();
}

public void testBuilder__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilder();
}

public void testBuilderComparator__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderComparator();
}

public void testBuilderPutAll__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderPutAll();
}

public void testBuilderPutAllWithEmptyMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderPutAllWithEmptyMap();
}

public void testBuilderPutNullKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderPutNullKey();
}

public void testBuilderPutNullKeyViaPutAll__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderPutNullKeyViaPutAll();
}

public void testBuilderPutNullValue__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderPutNullValue();
}

public void testBuilderPutNullValueViaPutAll__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderPutNullValueViaPutAll();
}

public void testBuilderReuse__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderReuse();
}

public void testBuilderReverseOrder__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilderReverseOrder();
}

public void testBuilder_orderEntriesByValueFails__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilder_orderEntriesByValueFails();
}

public void testBuilder_withImmutableEntry__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilder_withImmutableEntry();
}

public void testBuilder_withImmutableEntryAndNullContents__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilder_withImmutableEntryAndNullContents();
}

public void testBuilder_withMutableEntry__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testBuilder_withMutableEntry();
}

public void testCopyOf__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOf();
}

public void testCopyOfDuplicateKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOfDuplicateKey();
}

public void testCopyOfEmptyMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOfEmptyMap();
}

public void testCopyOfExplicitComparator__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOfExplicitComparator();
}

public void testCopyOfImmutableSortedSetDifferentComparator__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOfImmutableSortedSetDifferentComparator();
}

public void testCopyOfSingletonMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOfSingletonMap();
}

public void testCopyOfSortedExplicit__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOfSortedExplicit();
}

public void testCopyOfSortedNatural__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testCopyOfSortedNatural();
}

public void testEmptyBuilder__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testEmptyBuilder();
}

public void testImmutableMapCopyOfImmutableSortedMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testImmutableMapCopyOfImmutableSortedMap();
}

public void testOf__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testOf();
}

public void testOfNullKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testOfNullKey();
}

public void testOfNullValue__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testOfNullValue();
}

public void testOfWithDuplicateKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testOfWithDuplicateKey();
}

public void testPuttingTheSameKeyTwiceThrowsOnBuild__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testPuttingTheSameKeyTwiceThrowsOnBuild();
}

public void testSingletonBuilder__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testSingletonBuilder();
}

public void testToImmutableSortedMap__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testToImmutableSortedMap();
}

public void testToImmutableSortedMapMerging__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testToImmutableSortedMapMerging();
}

public void testToImmutableSortedMap_exceptionOnDuplicateKey__CreationTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.CreationTests testCase = new com.google.common.collect.ImmutableSortedMapTest.CreationTests();
  testCase.testToImmutableSortedMap_exceptionOnDuplicateKey();
}

public void testClear__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testClear();
}

public void testContainsKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testGetNull();
}

public void testHashCode__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testSize();
}

public void testTailMapClearThrough__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testTailMapWriteThrough();
}

public void testValues__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValues();
}

public void testValuesClear__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__SubMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SubMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SubMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testClear();
}

public void testContainsKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testGetNull();
}

public void testHashCode__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testSize();
}

public void testTailMapClearThrough__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testTailMapWriteThrough();
}

public void testValues__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValues();
}

public void testValuesClear__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TailExclusiveMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailExclusiveMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testClear();
}

public void testContainsKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testGetNull();
}

public void testHashCode__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testSize();
}

public void testTailMapClearThrough__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testTailMapWriteThrough();
}

public void testValues__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValues();
}

public void testValuesClear__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__TailMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.TailMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.TailMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testClear();
}

public void testContainsKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testContainsKey();
}

public void testContainsValue__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testContainsValue();
}

public void testEntrySet__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testGet();
}

public void testGetForEmptyMap__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testGetNull();
}

public void testHashCode__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testRemoveMissingKey();
}

public void testSize__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testSize();
}

public void testTailMapClearThrough__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testTailMapWriteThrough();
}

public void testValues__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValues();
}

public void testValuesClear__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__HeadMapInclusiveTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapInclusiveTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testClear();
}

public void testContainsKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testGetNull();
}

public void testHashCode__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testSize();
}

public void testTailMapClearThrough__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testTailMapWriteThrough();
}

public void testValues__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValues();
}

public void testValuesClear__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__HeadMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.HeadMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.HeadMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testClear();
}

public void testContainsKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testContainsKey();
}

public void testContainsValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testContainsValue();
}

public void testEntrySet__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testGetNull();
}

public void testHashCode__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testSize();
}

public void testTailMapClearThrough__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testTailMapWriteThrough();
}

public void testValues__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValues();
}

public void testValuesClear__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__SingletonMapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.SingletonMapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}

public void testClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testClear();
}

public void testContainsKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testContainsKey();
}

public void testContainsValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testContainsValue();
}

public void testEntrySet__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testEqualsForSmallerMap();
}

public void testGet__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testGet();
}

public void testGetForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testGetForEmptyMap();
}

public void testGetNull__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testGetNull();
}

public void testHashCode__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testKeySetClear();
}

public void testKeySetRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testPutExistingKey();
}

public void testPutNewKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testPutNewKey();
}

public void testPutNullKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testPutNullKey();
}

public void testPutNullValue__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testRemove();
}

public void testRemoveMissingKey__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testRemoveMissingKey();
}

public void testSize__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testSize();
}

public void testTailMapClearThrough__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testTailMapClearThrough();
}

public void testTailMapRemoveThrough__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testTailMapRemoveThrough();
}

public void testTailMapWriteThrough__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testTailMapWriteThrough();
}

public void testValues__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValues();
}

public void testValuesClear__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty__MapTests() throws Exception {
  com.google.common.collect.ImmutableSortedMapTest.MapTests testCase = new com.google.common.collect.ImmutableSortedMapTest.MapTests();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
