-----------------------------------------------------------------------------
-- |
-- Module    : SBVHLint
-- Copyright : (c) Levent Erkok
-- License   : BSD3
-- Maintainer: erkokl@gmail.com
-- Stability : experimental
--
-- HLint interface for SBV testsuite
-----------------------------------------------------------------------------

{-# OPTIONS_GHC -Wall -Werror #-}

module Main (main) where

import Utils.SBVTestFramework (getTestEnvironment, TestEnvironment(..))

import Language.Haskell.HLint (hlint)
import System.Exit (exitFailure, exitSuccess)

arguments :: [String]
arguments =
    [ "Data"
    , "SBVTestSuite"
    , "-i", "Use otherwise"
    , "-i", "Parse error"
    , "--cpp-simple"
    ]

main :: IO ()
main = do
    (testEnv, testPercentage) <- getTestEnvironment

    putStrLn $ "SBVHLint: Test platform: " ++ show testEnv

    case testEnv of
      TestEnvLocal   -> runHLint
      TestEnvCI{}    -> if testPercentage < 50
                           then do putStrLn $ "Test percentage below threshold, skipping hlint: " ++ show testPercentage
                                   exitSuccess
                           else runHLint
      TestEnvUnknown -> do putStrLn "Unknown test environment, skipping hlint run"
                           exitSuccess
 where runHLint = do hints <- hlint arguments
                     if null hints
                        then exitSuccess
                        else exitFailure
