
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaRecorder.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaRecorder>
#include <QAudioEncoderSettings>
#include <QChildEvent>
#include <QEvent>
#include <QMediaObject>
#include <QMetaMethod>
#include <QObject>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include <QVideoEncoderSettings>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaRecorder

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaRecorder::staticMetaObject);
}


// QUrl QMediaRecorder::actualLocation()


static void _init_f_actualLocation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_actualLocation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QMediaRecorder *)cls)->actualLocation ());
}


// void QMediaRecorder::actualLocationChanged(const QUrl &location)


static void _init_f_actualLocationChanged_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_actualLocationChanged_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->actualLocationChanged (arg1);
}


// QString QMediaRecorder::audioCodecDescription(const QString &codecName)


static void _init_f_audioCodecDescription_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codecName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_audioCodecDescription_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QMediaRecorder *)cls)->audioCodecDescription (arg1));
}


// QAudioEncoderSettings QMediaRecorder::audioSettings()


static void _init_f_audioSettings_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioEncoderSettings > ();
}

static void _call_f_audioSettings_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioEncoderSettings > ((QAudioEncoderSettings)((QMediaRecorder *)cls)->audioSettings ());
}


// QMultimedia::AvailabilityStatus QMediaRecorder::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QMediaRecorder *)cls)->availability ()));
}


// void QMediaRecorder::availabilityChanged(bool available)


static void _init_f_availabilityChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_availabilityChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->availabilityChanged (arg1);
}


// void QMediaRecorder::availabilityChanged(QMultimedia::AvailabilityStatus availability)


static void _init_f_availabilityChanged_3555 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("availability");
  decl->add_arg<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_availabilityChanged_3555 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->availabilityChanged (qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(arg1).cref());
}


// QStringList QMediaRecorder::availableMetaData()


static void _init_f_availableMetaData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_availableMetaData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMediaRecorder *)cls)->availableMetaData ());
}


// QString QMediaRecorder::containerDescription(const QString &format)


static void _init_f_containerDescription_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_containerDescription_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QMediaRecorder *)cls)->containerDescription (arg1));
}


// QString QMediaRecorder::containerFormat()


static void _init_f_containerFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_containerFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaRecorder *)cls)->containerFormat ());
}


// qint64 QMediaRecorder::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaRecorder *)cls)->duration ());
}


// void QMediaRecorder::durationChanged(qint64 duration)


static void _init_f_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->durationChanged (arg1);
}


// QMediaRecorder::Error QMediaRecorder::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::Error>::target_type > ((qt_gsi::Converter<QMediaRecorder::Error>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::Error>(((QMediaRecorder *)cls)->error ()));
}


// void QMediaRecorder::error(QMediaRecorder::Error error)


static void _init_f_error_2457 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_2457 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->error (qt_gsi::QtToCppAdaptor<QMediaRecorder::Error>(arg1).cref());
}


// QString QMediaRecorder::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaRecorder *)cls)->errorString ());
}


// bool QMediaRecorder::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaRecorder *)cls)->isAvailable ());
}


// bool QMediaRecorder::isMetaDataAvailable()


static void _init_f_isMetaDataAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMetaDataAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaRecorder *)cls)->isMetaDataAvailable ());
}


// bool QMediaRecorder::isMetaDataWritable()


static void _init_f_isMetaDataWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMetaDataWritable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaRecorder *)cls)->isMetaDataWritable ());
}


// bool QMediaRecorder::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaRecorder *)cls)->isMuted ());
}


// QMediaObject *QMediaRecorder::mediaObject()


static void _init_f_mediaObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_f_mediaObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QMediaRecorder *)cls)->mediaObject ());
}


// QVariant QMediaRecorder::metaData(const QString &key)


static void _init_f_metaData_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_metaData_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QMediaRecorder *)cls)->metaData (arg1));
}


// void QMediaRecorder::metaDataAvailableChanged(bool available)


static void _init_f_metaDataAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_metaDataAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->metaDataAvailableChanged (arg1);
}


// void QMediaRecorder::metaDataChanged()


static void _init_f_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->metaDataChanged ();
}


// void QMediaRecorder::metaDataChanged(const QString &key, const QVariant &value)


static void _init_f_metaDataChanged_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_metaDataChanged_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->metaDataChanged (arg1, arg2);
}


// void QMediaRecorder::metaDataWritableChanged(bool writable)


static void _init_f_metaDataWritableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("writable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_metaDataWritableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->metaDataWritableChanged (arg1);
}


// void QMediaRecorder::mutedChanged(bool muted)


static void _init_f_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->mutedChanged (arg1);
}


// QUrl QMediaRecorder::outputLocation()


static void _init_f_outputLocation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_outputLocation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QMediaRecorder *)cls)->outputLocation ());
}


// void QMediaRecorder::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->pause ();
}


// void QMediaRecorder::record()


static void _init_f_record_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_record_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->record ();
}


// void QMediaRecorder::setAudioSettings(const QAudioEncoderSettings &audioSettings)


static void _init_f_setAudioSettings_3445 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("audioSettings");
  decl->add_arg<const QAudioEncoderSettings & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioSettings_3445 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioEncoderSettings &arg1 = gsi::arg_reader<const QAudioEncoderSettings & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setAudioSettings (arg1);
}


// void QMediaRecorder::setContainerFormat(const QString &container)


static void _init_f_setContainerFormat_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("container");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContainerFormat_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setContainerFormat (arg1);
}


// void QMediaRecorder::setEncodingSettings(const QAudioEncoderSettings &audioSettings, const QVideoEncoderSettings &videoSettings, const QString &containerMimeType)


static void _init_f_setEncodingSettings_8704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("audioSettings");
  decl->add_arg<const QAudioEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("videoSettings", true, "QVideoEncoderSettings()");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("containerMimeType", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setEncodingSettings_8704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioEncoderSettings &arg1 = gsi::arg_reader<const QAudioEncoderSettings & >() (args, heap);
  const QVideoEncoderSettings &arg2 = args ? gsi::arg_reader<const QVideoEncoderSettings & >() (args, heap) : gsi::arg_maker<const QVideoEncoderSettings & >() (QVideoEncoderSettings(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setEncodingSettings (arg1, arg2, arg3);
}


// void QMediaRecorder::setMetaData(const QString &key, const QVariant &value)


static void _init_f_setMetaData_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMetaData_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setMetaData (arg1, arg2);
}


// void QMediaRecorder::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setMuted (arg1);
}


// bool QMediaRecorder::setOutputLocation(const QUrl &location)


static void _init_f_setOutputLocation_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setOutputLocation_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QMediaRecorder *)cls)->setOutputLocation (arg1));
}


// void QMediaRecorder::setVideoSettings(const QVideoEncoderSettings &videoSettings)


static void _init_f_setVideoSettings_3450 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("videoSettings");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoSettings_3450 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = gsi::arg_reader<const QVideoEncoderSettings & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setVideoSettings (arg1);
}


// void QMediaRecorder::setVolume(double volume)


static void _init_f_setVolume_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setVolume (arg1);
}


// QMediaRecorder::State QMediaRecorder::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::State>::target_type > ((qt_gsi::Converter<QMediaRecorder::State>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::State>(((QMediaRecorder *)cls)->state ()));
}


// void QMediaRecorder::stateChanged(QMediaRecorder::State state)


static void _init_f_stateChanged_2448 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_2448 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QMediaRecorder::State>(arg1).cref());
}


// QMediaRecorder::Status QMediaRecorder::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::Status>::target_type > ((qt_gsi::Converter<QMediaRecorder::Status>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::Status>(((QMediaRecorder *)cls)->status ()));
}


// void QMediaRecorder::statusChanged(QMediaRecorder::Status status)


static void _init_f_statusChanged_2579 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::Status>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_statusChanged_2579 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::Status>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::Status>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->statusChanged (qt_gsi::QtToCppAdaptor<QMediaRecorder::Status>(arg1).cref());
}


// void QMediaRecorder::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->stop ();
}


// QStringList QMediaRecorder::supportedAudioCodecs()


static void _init_f_supportedAudioCodecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedAudioCodecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMediaRecorder *)cls)->supportedAudioCodecs ());
}


// QList<int> QMediaRecorder::supportedAudioSampleRates(const QAudioEncoderSettings &settings, bool *continuous)


static void _init_f_supportedAudioSampleRates_c4387 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QAudioEncoderSettings()");
  decl->add_arg<const QAudioEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<int> > ();
}

static void _call_f_supportedAudioSampleRates_c4387 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioEncoderSettings &arg1 = args ? gsi::arg_reader<const QAudioEncoderSettings & >() (args, heap) : gsi::arg_maker<const QAudioEncoderSettings & >() (QAudioEncoderSettings(), heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QList<int> > ((QList<int>)((QMediaRecorder *)cls)->supportedAudioSampleRates (arg1, arg2));
}


// QStringList QMediaRecorder::supportedContainers()


static void _init_f_supportedContainers_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedContainers_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMediaRecorder *)cls)->supportedContainers ());
}


// QList<qreal> QMediaRecorder::supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous)


static void _init_f_supportedFrameRates_c4392 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QVideoEncoderSettings()");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<qreal> > ();
}

static void _call_f_supportedFrameRates_c4392 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = args ? gsi::arg_reader<const QVideoEncoderSettings & >() (args, heap) : gsi::arg_maker<const QVideoEncoderSettings & >() (QVideoEncoderSettings(), heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QList<qreal> > ((QList<qreal>)((QMediaRecorder *)cls)->supportedFrameRates (arg1, arg2));
}


// QList<QSize> QMediaRecorder::supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous)


static void _init_f_supportedResolutions_c4392 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("settings", true, "QVideoEncoderSettings()");
  decl->add_arg<const QVideoEncoderSettings & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<QSize> > ();
}

static void _call_f_supportedResolutions_c4392 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoEncoderSettings &arg1 = args ? gsi::arg_reader<const QVideoEncoderSettings & >() (args, heap) : gsi::arg_maker<const QVideoEncoderSettings & >() (QVideoEncoderSettings(), heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QList<QSize> > ((QList<QSize>)((QMediaRecorder *)cls)->supportedResolutions (arg1, arg2));
}


// QStringList QMediaRecorder::supportedVideoCodecs()


static void _init_f_supportedVideoCodecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedVideoCodecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QMediaRecorder *)cls)->supportedVideoCodecs ());
}


// QString QMediaRecorder::videoCodecDescription(const QString &codecName)


static void _init_f_videoCodecDescription_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codecName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_videoCodecDescription_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QString > ((QString)((QMediaRecorder *)cls)->videoCodecDescription (arg1));
}


// QVideoEncoderSettings QMediaRecorder::videoSettings()


static void _init_f_videoSettings_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVideoEncoderSettings > ();
}

static void _call_f_videoSettings_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoEncoderSettings > ((QVideoEncoderSettings)((QMediaRecorder *)cls)->videoSettings ());
}


// double QMediaRecorder::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaRecorder *)cls)->volume ());
}


// void QMediaRecorder::volumeChanged(double volume)


static void _init_f_volumeChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_volumeChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->volumeChanged (arg1);
}


// static QString QMediaRecorder::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaRecorder::tr (arg1, arg2, arg3));
}


// static QString QMediaRecorder::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaRecorder::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QMediaRecorder_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QMediaRecorder_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QMediaRecorder *)cls);
}

static void _init_f_QMediaRecorder_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QMediaRecorder_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QMediaRecorder *)cls);
}

//  base class cast for QMediaBindableInterface

static void _init_f_QMediaRecorder_as_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaBindableInterface *> ();
}

static void _call_f_QMediaRecorder_as_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QMediaBindableInterface *> ((QMediaBindableInterface *)(QMediaRecorder *)cls);
}

static void _init_f_QMediaRecorder_as_const_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMediaBindableInterface *> ();
}

static void _call_f_QMediaRecorder_as_const_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMediaBindableInterface *> ((const QMediaBindableInterface *)(const QMediaRecorder *)cls);
}


namespace gsi
{

static gsi::Methods methods_QMediaRecorder () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":actualLocation", "@brief Method QUrl QMediaRecorder::actualLocation()\n", true, &_init_f_actualLocation_c0, &_call_f_actualLocation_c0);
  methods += new qt_gsi::GenericMethod ("actualLocationChanged", "@brief Method void QMediaRecorder::actualLocationChanged(const QUrl &location)\n", false, &_init_f_actualLocationChanged_1701, &_call_f_actualLocationChanged_1701);
  methods += new qt_gsi::GenericMethod ("audioCodecDescription", "@brief Method QString QMediaRecorder::audioCodecDescription(const QString &codecName)\n", true, &_init_f_audioCodecDescription_c2025, &_call_f_audioCodecDescription_c2025);
  methods += new qt_gsi::GenericMethod (":audioSettings", "@brief Method QAudioEncoderSettings QMediaRecorder::audioSettings()\n", true, &_init_f_audioSettings_c0, &_call_f_audioSettings_c0);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QMediaRecorder::availability()\n", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod ("availabilityChanged_bool", "@brief Method void QMediaRecorder::availabilityChanged(bool available)\n", false, &_init_f_availabilityChanged_864, &_call_f_availabilityChanged_864);
  methods += new qt_gsi::GenericMethod ("availabilityChanged_status", "@brief Method void QMediaRecorder::availabilityChanged(QMultimedia::AvailabilityStatus availability)\n", false, &_init_f_availabilityChanged_3555, &_call_f_availabilityChanged_3555);
  methods += new qt_gsi::GenericMethod ("availableMetaData", "@brief Method QStringList QMediaRecorder::availableMetaData()\n", true, &_init_f_availableMetaData_c0, &_call_f_availableMetaData_c0);
  methods += new qt_gsi::GenericMethod ("containerDescription", "@brief Method QString QMediaRecorder::containerDescription(const QString &format)\n", true, &_init_f_containerDescription_c2025, &_call_f_containerDescription_c2025);
  methods += new qt_gsi::GenericMethod (":containerFormat", "@brief Method QString QMediaRecorder::containerFormat()\n", true, &_init_f_containerFormat_c0, &_call_f_containerFormat_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method qint64 QMediaRecorder::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("durationChanged", "@brief Method void QMediaRecorder::durationChanged(qint64 duration)\n", false, &_init_f_durationChanged_986, &_call_f_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QMediaRecorder::Error QMediaRecorder::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QMediaRecorder::error(QMediaRecorder::Error error)\n", false, &_init_f_error_2457, &_call_f_error_2457);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QMediaRecorder::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QMediaRecorder::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isMetaDataAvailable?|:metaDataAvailable", "@brief Method bool QMediaRecorder::isMetaDataAvailable()\n", true, &_init_f_isMetaDataAvailable_c0, &_call_f_isMetaDataAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isMetaDataWritable?|:metaDataWritable", "@brief Method bool QMediaRecorder::isMetaDataWritable()\n", true, &_init_f_isMetaDataWritable_c0, &_call_f_isMetaDataWritable_c0);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QMediaRecorder::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Method QMediaObject *QMediaRecorder::mediaObject()\nThis is a reimplementation of QMediaBindableInterface::mediaObject", true, &_init_f_mediaObject_c0, &_call_f_mediaObject_c0);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Method QVariant QMediaRecorder::metaData(const QString &key)\n", true, &_init_f_metaData_c2025, &_call_f_metaData_c2025);
  methods += new qt_gsi::GenericMethod ("metaDataAvailableChanged", "@brief Method void QMediaRecorder::metaDataAvailableChanged(bool available)\n", false, &_init_f_metaDataAvailableChanged_864, &_call_f_metaDataAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("metaDataChanged", "@brief Method void QMediaRecorder::metaDataChanged()\n", false, &_init_f_metaDataChanged_0, &_call_f_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("metaDataChanged_kv", "@brief Method void QMediaRecorder::metaDataChanged(const QString &key, const QVariant &value)\n", false, &_init_f_metaDataChanged_4036, &_call_f_metaDataChanged_4036);
  methods += new qt_gsi::GenericMethod ("metaDataWritableChanged", "@brief Method void QMediaRecorder::metaDataWritableChanged(bool writable)\n", false, &_init_f_metaDataWritableChanged_864, &_call_f_metaDataWritableChanged_864);
  methods += new qt_gsi::GenericMethod ("mutedChanged", "@brief Method void QMediaRecorder::mutedChanged(bool muted)\n", false, &_init_f_mutedChanged_864, &_call_f_mutedChanged_864);
  methods += new qt_gsi::GenericMethod (":outputLocation", "@brief Method QUrl QMediaRecorder::outputLocation()\n", true, &_init_f_outputLocation_c0, &_call_f_outputLocation_c0);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QMediaRecorder::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod ("record", "@brief Method void QMediaRecorder::record()\n", false, &_init_f_record_0, &_call_f_record_0);
  methods += new qt_gsi::GenericMethod ("setAudioSettings|audioSettings=", "@brief Method void QMediaRecorder::setAudioSettings(const QAudioEncoderSettings &audioSettings)\n", false, &_init_f_setAudioSettings_3445, &_call_f_setAudioSettings_3445);
  methods += new qt_gsi::GenericMethod ("setContainerFormat|containerFormat=", "@brief Method void QMediaRecorder::setContainerFormat(const QString &container)\n", false, &_init_f_setContainerFormat_2025, &_call_f_setContainerFormat_2025);
  methods += new qt_gsi::GenericMethod ("setEncodingSettings", "@brief Method void QMediaRecorder::setEncodingSettings(const QAudioEncoderSettings &audioSettings, const QVideoEncoderSettings &videoSettings, const QString &containerMimeType)\n", false, &_init_f_setEncodingSettings_8704, &_call_f_setEncodingSettings_8704);
  methods += new qt_gsi::GenericMethod ("setMetaData", "@brief Method void QMediaRecorder::setMetaData(const QString &key, const QVariant &value)\n", false, &_init_f_setMetaData_4036, &_call_f_setMetaData_4036);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QMediaRecorder::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setOutputLocation|outputLocation=", "@brief Method bool QMediaRecorder::setOutputLocation(const QUrl &location)\n", false, &_init_f_setOutputLocation_1701, &_call_f_setOutputLocation_1701);
  methods += new qt_gsi::GenericMethod ("setVideoSettings|videoSettings=", "@brief Method void QMediaRecorder::setVideoSettings(const QVideoEncoderSettings &videoSettings)\n", false, &_init_f_setVideoSettings_3450, &_call_f_setVideoSettings_3450);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QMediaRecorder::setVolume(double volume)\n", false, &_init_f_setVolume_1071, &_call_f_setVolume_1071);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QMediaRecorder::State QMediaRecorder::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QMediaRecorder::stateChanged(QMediaRecorder::State state)\n", false, &_init_f_stateChanged_2448, &_call_f_stateChanged_2448);
  methods += new qt_gsi::GenericMethod (":status", "@brief Method QMediaRecorder::Status QMediaRecorder::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
  methods += new qt_gsi::GenericMethod ("statusChanged", "@brief Method void QMediaRecorder::statusChanged(QMediaRecorder::Status status)\n", false, &_init_f_statusChanged_2579, &_call_f_statusChanged_2579);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMediaRecorder::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("supportedAudioCodecs", "@brief Method QStringList QMediaRecorder::supportedAudioCodecs()\n", true, &_init_f_supportedAudioCodecs_c0, &_call_f_supportedAudioCodecs_c0);
  methods += new qt_gsi::GenericMethod ("supportedAudioSampleRates", "@brief Method QList<int> QMediaRecorder::supportedAudioSampleRates(const QAudioEncoderSettings &settings, bool *continuous)\n", true, &_init_f_supportedAudioSampleRates_c4387, &_call_f_supportedAudioSampleRates_c4387);
  methods += new qt_gsi::GenericMethod ("supportedContainers", "@brief Method QStringList QMediaRecorder::supportedContainers()\n", true, &_init_f_supportedContainers_c0, &_call_f_supportedContainers_c0);
  methods += new qt_gsi::GenericMethod ("supportedFrameRates", "@brief Method QList<qreal> QMediaRecorder::supportedFrameRates(const QVideoEncoderSettings &settings, bool *continuous)\n", true, &_init_f_supportedFrameRates_c4392, &_call_f_supportedFrameRates_c4392);
  methods += new qt_gsi::GenericMethod ("supportedResolutions", "@brief Method QList<QSize> QMediaRecorder::supportedResolutions(const QVideoEncoderSettings &settings, bool *continuous)\n", true, &_init_f_supportedResolutions_c4392, &_call_f_supportedResolutions_c4392);
  methods += new qt_gsi::GenericMethod ("supportedVideoCodecs", "@brief Method QStringList QMediaRecorder::supportedVideoCodecs()\n", true, &_init_f_supportedVideoCodecs_c0, &_call_f_supportedVideoCodecs_c0);
  methods += new qt_gsi::GenericMethod ("videoCodecDescription", "@brief Method QString QMediaRecorder::videoCodecDescription(const QString &codecName)\n", true, &_init_f_videoCodecDescription_c2025, &_call_f_videoCodecDescription_c2025);
  methods += new qt_gsi::GenericMethod (":videoSettings", "@brief Method QVideoEncoderSettings QMediaRecorder::videoSettings()\n", true, &_init_f_videoSettings_c0, &_call_f_videoSettings_c0);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method double QMediaRecorder::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += new qt_gsi::GenericMethod ("volumeChanged", "@brief Method void QMediaRecorder::volumeChanged(double volume)\n", false, &_init_f_volumeChanged_1071, &_call_f_volumeChanged_1071);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaRecorder::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaRecorder::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QMediaRecorder\nClass QMediaRecorder is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QMediaRecorder_as_QObject, &_call_f_QMediaRecorder_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QMediaRecorder\nClass QMediaRecorder is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QMediaRecorder_as_const_QObject, &_call_f_QMediaRecorder_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QMediaRecorder\nClass QMediaRecorder is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.", false, &_init_f_QMediaRecorder_as_QMediaBindableInterface, &_call_f_QMediaRecorder_as_QMediaBindableInterface);
  methods += new qt_gsi::GenericMethod ("asConstQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QMediaRecorder\nClass QMediaRecorder is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QMediaRecorder_as_const_QMediaBindableInterface, &_call_f_QMediaRecorder_as_const_QMediaBindableInterface);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QMediaRecorder> decl_QMediaRecorder (qtdecl_QObject (), "QtMultimedia", "QMediaRecorder_Native",
  methods_QMediaRecorder (),
  "@hide\n@alias QMediaRecorder");

//  Additional base classes

gsi::Class<QMediaBindableInterface> &qtdecl_QMediaBindableInterface ();

gsi::ClassExt<QMediaRecorder> base_class_QMediaBindableInterface_in_QMediaRecorder (qtdecl_QMediaBindableInterface ());

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaRecorder> &qtdecl_QMediaRecorder () { return decl_QMediaRecorder; }

}


class QMediaRecorder_Adaptor : public QMediaRecorder, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaRecorder_Adaptor();

  //  [adaptor ctor] QMediaRecorder::QMediaRecorder(QMediaObject *mediaObject, QObject *parent)
  QMediaRecorder_Adaptor(QMediaObject *mediaObject) : QMediaRecorder(mediaObject)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaRecorder::QMediaRecorder(QMediaObject *mediaObject, QObject *parent)
  QMediaRecorder_Adaptor(QMediaObject *mediaObject, QObject *parent) : QMediaRecorder(mediaObject, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaRecorder::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaRecorder_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaRecorder::isSignalConnected(signal);
  }

  //  [expose] int QMediaRecorder::receivers(const char *signal)
  int fp_QMediaRecorder_receivers_c1731 (const char *signal) const {
    return QMediaRecorder::receivers(signal);
  }

  //  [expose] QObject *QMediaRecorder::sender()
  QObject * fp_QMediaRecorder_sender_c0 () const {
    return QMediaRecorder::sender();
  }

  //  [expose] int QMediaRecorder::senderSignalIndex()
  int fp_QMediaRecorder_senderSignalIndex_c0 () const {
    return QMediaRecorder::senderSignalIndex();
  }

  //  [adaptor impl] bool QMediaRecorder::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMediaRecorder::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaRecorder_Adaptor, bool, QEvent *>(&QMediaRecorder_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMediaRecorder::event(arg1);
    }
  }

  //  [adaptor impl] bool QMediaRecorder::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMediaRecorder::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaRecorder_Adaptor, bool, QObject *, QEvent *>(&QMediaRecorder_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMediaRecorder::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QMediaObject *QMediaRecorder::mediaObject()
  QMediaObject * cbs_mediaObject_c0_0() const
  {
    return QMediaRecorder::mediaObject();
  }

  virtual QMediaObject * mediaObject() const
  {
    if (cb_mediaObject_c0_0.can_issue()) {
      return cb_mediaObject_c0_0.issue<QMediaRecorder_Adaptor, QMediaObject *>(&QMediaRecorder_Adaptor::cbs_mediaObject_c0_0);
    } else {
      return QMediaRecorder::mediaObject();
    }
  }

  //  [adaptor impl] void QMediaRecorder::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMediaRecorder::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaRecorder_Adaptor, QChildEvent *>(&QMediaRecorder_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMediaRecorder::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaRecorder::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMediaRecorder::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaRecorder_Adaptor, QEvent *>(&QMediaRecorder_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMediaRecorder::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaRecorder::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaRecorder::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaRecorder_Adaptor, const QMetaMethod &>(&QMediaRecorder_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaRecorder::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QMediaRecorder::setMediaObject(QMediaObject *object)
  bool cbs_setMediaObject_1782_0(QMediaObject *object)
  {
    return QMediaRecorder::setMediaObject(object);
  }

  virtual bool setMediaObject(QMediaObject *object)
  {
    if (cb_setMediaObject_1782_0.can_issue()) {
      return cb_setMediaObject_1782_0.issue<QMediaRecorder_Adaptor, bool, QMediaObject *>(&QMediaRecorder_Adaptor::cbs_setMediaObject_1782_0, object);
    } else {
      return QMediaRecorder::setMediaObject(object);
    }
  }

  //  [adaptor impl] void QMediaRecorder::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMediaRecorder::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaRecorder_Adaptor, QTimerEvent *>(&QMediaRecorder_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMediaRecorder::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_mediaObject_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_setMediaObject_1782_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaRecorder_Adaptor::~QMediaRecorder_Adaptor() { }

//  Constructor QMediaRecorder::QMediaRecorder(QMediaObject *mediaObject, QObject *parent) (adaptor class)

static void _init_ctor_QMediaRecorder_Adaptor_2976 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mediaObject");
  decl->add_arg<QMediaObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QMediaRecorder_Adaptor> ();
}

static void _call_ctor_QMediaRecorder_Adaptor_2976 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = gsi::arg_reader<QMediaObject * >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QMediaRecorder_Adaptor *> (new QMediaRecorder_Adaptor (arg1, arg2));
}


// void QMediaRecorder::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaRecorder::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QMediaRecorder::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QMediaRecorder::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaRecorder_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaRecorder::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaRecorder_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QMediaRecorder::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_isSignalConnected_c2394 (arg1));
}


// QMediaObject *QMediaRecorder::mediaObject()

static void _init_cbs_mediaObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_cbs_mediaObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QMediaRecorder_Adaptor *)cls)->cbs_mediaObject_c0_0 ());
}

static void _set_callback_cbs_mediaObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_mediaObject_c0_0 = cb;
}


// exposed int QMediaRecorder::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_receivers_c1731 (arg1));
}


// exposed QObject *QMediaRecorder::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_sender_c0 ());
}


// exposed int QMediaRecorder::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_senderSignalIndex_c0 ());
}


// bool QMediaRecorder::setMediaObject(QMediaObject *object)

static void _init_cbs_setMediaObject_1782_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QMediaObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setMediaObject_1782_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = args.read<QMediaObject * > (heap);
  ret.write<bool > ((bool)((QMediaRecorder_Adaptor *)cls)->cbs_setMediaObject_1782_0 (arg1));
}

static void _set_callback_cbs_setMediaObject_1782_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_setMediaObject_1782_0 = cb;
}


// void QMediaRecorder::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QMediaRecorder> &qtdecl_QMediaRecorder ();

static gsi::Methods methods_QMediaRecorder_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaRecorder::QMediaRecorder(QMediaObject *mediaObject, QObject *parent)\nThis method creates an object of class QMediaRecorder.", &_init_ctor_QMediaRecorder_Adaptor_2976, &_call_ctor_QMediaRecorder_Adaptor_2976);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaRecorder::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaRecorder::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaRecorder::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaRecorder::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaRecorder::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaRecorder::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Virtual method QMediaObject *QMediaRecorder::mediaObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@hide", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0, &_set_callback_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaRecorder::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaRecorder::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaRecorder::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@brief Virtual method bool QMediaRecorder::setMediaObject(QMediaObject *object)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@hide", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0, &_set_callback_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaRecorder::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QMediaRecorder_Adaptor> decl_QMediaRecorder_Adaptor (qtdecl_QMediaRecorder (), "QtMultimedia", "QMediaRecorder",
  methods_QMediaRecorder_Adaptor (),
  "@qt\n@brief Binding of QMediaRecorder");

}


//  Implementation of the enum wrapper class for QMediaRecorder::Error
namespace qt_gsi
{

static gsi::Enum<QMediaRecorder::Error> decl_QMediaRecorder_Error_Enum ("QtMultimedia", "QMediaRecorder_Error",
    gsi::enum_const ("NoError", QMediaRecorder::NoError, "@brief Enum constant QMediaRecorder::NoError") +
    gsi::enum_const ("ResourceError", QMediaRecorder::ResourceError, "@brief Enum constant QMediaRecorder::ResourceError") +
    gsi::enum_const ("FormatError", QMediaRecorder::FormatError, "@brief Enum constant QMediaRecorder::FormatError") +
    gsi::enum_const ("OutOfSpaceError", QMediaRecorder::OutOfSpaceError, "@brief Enum constant QMediaRecorder::OutOfSpaceError"),
  "@qt\n@brief This class represents the QMediaRecorder::Error enum");

static gsi::QFlagsClass<QMediaRecorder::Error > decl_QMediaRecorder_Error_Enums ("QtMultimedia", "QMediaRecorder_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QMediaRecorder::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaRecorder> inject_QMediaRecorder_Error_Enum_in_parent (decl_QMediaRecorder_Error_Enum.defs ());
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Error_Enum_as_child (decl_QMediaRecorder_Error_Enum, "Error");
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Error_Enums_as_child (decl_QMediaRecorder_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QMediaRecorder::State
namespace qt_gsi
{

static gsi::Enum<QMediaRecorder::State> decl_QMediaRecorder_State_Enum ("QtMultimedia", "QMediaRecorder_State",
    gsi::enum_const ("StoppedState", QMediaRecorder::StoppedState, "@brief Enum constant QMediaRecorder::StoppedState") +
    gsi::enum_const ("RecordingState", QMediaRecorder::RecordingState, "@brief Enum constant QMediaRecorder::RecordingState") +
    gsi::enum_const ("PausedState", QMediaRecorder::PausedState, "@brief Enum constant QMediaRecorder::PausedState"),
  "@qt\n@brief This class represents the QMediaRecorder::State enum");

static gsi::QFlagsClass<QMediaRecorder::State > decl_QMediaRecorder_State_Enums ("QtMultimedia", "QMediaRecorder_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QMediaRecorder::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaRecorder> inject_QMediaRecorder_State_Enum_in_parent (decl_QMediaRecorder_State_Enum.defs ());
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_State_Enum_as_child (decl_QMediaRecorder_State_Enum, "State");
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_State_Enums_as_child (decl_QMediaRecorder_State_Enums, "QFlags_State");

}


//  Implementation of the enum wrapper class for QMediaRecorder::Status
namespace qt_gsi
{

static gsi::Enum<QMediaRecorder::Status> decl_QMediaRecorder_Status_Enum ("QtMultimedia", "QMediaRecorder_Status",
    gsi::enum_const ("UnavailableStatus", QMediaRecorder::UnavailableStatus, "@brief Enum constant QMediaRecorder::UnavailableStatus") +
    gsi::enum_const ("UnloadedStatus", QMediaRecorder::UnloadedStatus, "@brief Enum constant QMediaRecorder::UnloadedStatus") +
    gsi::enum_const ("LoadingStatus", QMediaRecorder::LoadingStatus, "@brief Enum constant QMediaRecorder::LoadingStatus") +
    gsi::enum_const ("LoadedStatus", QMediaRecorder::LoadedStatus, "@brief Enum constant QMediaRecorder::LoadedStatus") +
    gsi::enum_const ("StartingStatus", QMediaRecorder::StartingStatus, "@brief Enum constant QMediaRecorder::StartingStatus") +
    gsi::enum_const ("RecordingStatus", QMediaRecorder::RecordingStatus, "@brief Enum constant QMediaRecorder::RecordingStatus") +
    gsi::enum_const ("PausedStatus", QMediaRecorder::PausedStatus, "@brief Enum constant QMediaRecorder::PausedStatus") +
    gsi::enum_const ("FinalizingStatus", QMediaRecorder::FinalizingStatus, "@brief Enum constant QMediaRecorder::FinalizingStatus"),
  "@qt\n@brief This class represents the QMediaRecorder::Status enum");

static gsi::QFlagsClass<QMediaRecorder::Status > decl_QMediaRecorder_Status_Enums ("QtMultimedia", "QMediaRecorder_QFlags_Status",
  "@qt\n@brief This class represents the QFlags<QMediaRecorder::Status> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaRecorder> inject_QMediaRecorder_Status_Enum_in_parent (decl_QMediaRecorder_Status_Enum.defs ());
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Status_Enum_as_child (decl_QMediaRecorder_Status_Enum, "Status");
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Status_Enums_as_child (decl_QMediaRecorder_Status_Enums, "QFlags_Status");

}

