/*
  libnzb

  Copyright (C) 2004 Mattias Nordstrom <matta at ftlight net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Authors:
    Mattias Nordstrom <matta at ftlight net>

  $Id: nzb.cpp,v 1.3 2005/05/15 16:12:02 mnordstr Exp $
    This file provides the nzb XML functions.

*/

#include <iostream>
#include <vector>
#include <stdlib.h>

#include "nzb.h"
#include "libxml/parser.h"

using namespace std;

/*
struct nzb_return {
	unsigned int count;
	nzb_file files[];
};

struct nzb_file {
	int status;
	string poster;
	unsigned int date;
	string subject;

	unsigned int c_groups;
	unsigned int c_segments;
	
	nzb_group groups[];
	nzb_segment segments[];
};

struct nzb_group {
	string group;
};

struct nzb_segment {
	unsigned long bytes;
	unsigned int number;
	string msgid;
};
*/

extern "C" nzb_return parse_nzb(string data /* Add a status variable which is changed during parse, to provide feedback to the user via the UI */)
{
	nzb_return ret;
	ret.count = 0;
	
	xmlDocPtr doc;
	xmlNodePtr cur;

	doc = xmlParseMemory(data.c_str(), data.length() + 1);
	
	if (doc == NULL ) {
		fprintf(stderr,"Document not parsed successfully. \n");
		return ret;
	}

	cur = xmlDocGetRootElement(doc);
	
	if (cur == NULL) {
		fprintf(stderr,"empty document\n");
		xmlFreeDoc(doc);
		return ret;
	}
	
	if (xmlStrcmp(cur->name, (const xmlChar *) "nzb")) {
		fprintf(stderr,"document of the wrong type, root node != nzb");
		xmlFreeDoc(doc);
		return ret;
	}
	
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"file"))) {
			ret.files.push_back(parse_file(doc, cur));
			ret.count++;
		}
	
		cur = cur->next;
	}
	
	xmlFreeDoc(doc);
	
	return ret;
}

nzb_file parse_file(xmlDocPtr doc, xmlNodePtr cur)
{
	nzb_file file;
	
	xmlChar *attr;
	
	attr = xmlGetProp(cur, (xmlChar *)"poster");
	file.poster = (char *)attr;	
	xmlFree(attr);
	
	attr = xmlGetProp(cur, (xmlChar *)"date");
	file.date = atoi((char *)attr);
	xmlFree(attr);
	
	attr = xmlGetProp(cur, (xmlChar *)"subject");
	file.subject = (char *)attr;	
	xmlFree(attr);
	
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"groups"))) {
			file.groups = parse_groups(doc, cur);
		}
		
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"segments"))) {
			file.segments = parse_segments(doc, cur);
		}
	
		cur = cur->next;
	}
	
	file.c_groups = file.groups.size();
	file.c_segments = file.segments.size();

	return file;
}

vector<nzb_group> parse_groups(xmlDocPtr doc, xmlNodePtr cur)
{
	vector<nzb_group> groups;
	nzb_group group;
	
	xmlChar *value;
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"group"))) {
			value = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			group.group = (char *)value;
			groups.push_back(group);
			xmlFree(value);
 		}
	cur = cur->next;
	}
	
	return groups;
}

vector<nzb_segment> parse_segments(xmlDocPtr doc, xmlNodePtr cur)
{
	vector<nzb_segment> segments;
	nzb_segment segment;
	
	xmlChar *attr;
	xmlChar *value;
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"segment"))) {
			value = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			segment.msgid = "<";
			segment.msgid += (char *)value;
			segment.msgid += ">";
			
			attr = xmlGetProp(cur, (xmlChar *)"bytes");
			segment.bytes = atol((char *)attr);	
			xmlFree(attr);
	
			attr = xmlGetProp(cur, (xmlChar *)"number");
			segment.number = atoi((char *)attr);
			xmlFree(attr);
				
			segments.push_back(segment);
			xmlFree(value);
 		}
		cur = cur->next;
	}
	
	return segments;
}
