// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/cxfa_delete.h"

#include "fxjs/xfa/cjx_delete.h"
#include "third_party/base/ptr_util.h"

namespace {

const CXFA_Node::AttributeData kDeleteAttributeData[] = {
    {XFA_Attribute::Id, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Name, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Use, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Usehref, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Unknown, XFA_AttributeType::Integer, nullptr}};

constexpr wchar_t kDeleteName[] = L"delete";

}  // namespace

CXFA_Delete::CXFA_Delete(CXFA_Document* doc, XFA_PacketType packet)
    : CXFA_Node(doc,
                packet,
                XFA_XDPPACKET_SourceSet,
                XFA_ObjectType::TextNode,
                XFA_Element::Delete,
                nullptr,
                kDeleteAttributeData,
                kDeleteName,
                pdfium::MakeUnique<CJX_Delete>(this)) {}

CXFA_Delete::~CXFA_Delete() {}
