/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.tests;

import gr.zeus.ui.JMessage;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class JMessageTester
extends JFrame {
    private JButton m_errorButton;
    private JButton m_infoButton;
    private JButton m_plainButton;
    private JButton m_plainButton2;
    private JButton m_questionButton;
    private JButton m_warningButton;

    public JMessageTester() {
        this.initComponents();
    }

    private void initComponents() {
        this.m_errorButton = new JButton();
        this.m_warningButton = new JButton();
        this.m_infoButton = new JButton();
        this.m_questionButton = new JButton();
        this.m_plainButton = new JButton();
        this.m_plainButton2 = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("JMessageTester");
        this.getContentPane().setLayout(null);
        this.m_errorButton.setText("ERROR");
        this.m_errorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessageTester.this.m_errorButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_errorButton);
        this.m_errorButton.setBounds(10, 130, 110, 21);
        this.m_warningButton.setText("WARNING");
        this.m_warningButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessageTester.this.m_warningButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_warningButton);
        this.m_warningButton.setBounds(10, 70, 110, 21);
        this.m_infoButton.setText("INFO");
        this.m_infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessageTester.this.m_infoButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_infoButton);
        this.m_infoButton.setBounds(10, 40, 110, 21);
        this.m_questionButton.setText("QUESTION");
        this.m_questionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessageTester.this.m_questionButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_questionButton);
        this.m_questionButton.setBounds(10, 100, 110, 21);
        this.m_plainButton.setText("PLAIN");
        this.m_plainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessageTester.this.m_plainButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_plainButton);
        this.m_plainButton.setBounds(10, 10, 110, 21);
        this.m_plainButton2.setText("PLAIN+ICO");
        this.m_plainButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessageTester.this.m_plainButton2ActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_plainButton2);
        this.m_plainButton2.setBounds(130, 10, 110, 21);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 310) / 2, (screenSize.height - 198) / 2, 310, 198);
    }

    private void m_plainButton2ActionPerformed(ActionEvent evt) {
        JMessage.showMessageDialog(this, "A message with a custom icon.", "Hello...", -1, -1, null, new ImageIcon(JMessageTester.class.getResource("/gr/zeus/tests/res/custom.png")), null, "...World", null, null, null);
    }

    private void m_questionButtonActionPerformed(ActionEvent evt) {
        int result = JMessage.showMessageDialog((Frame)this, "A question that it's default button is NO", 3, 1, JMessage.JMessageButtonEnum.NO);
        switch (result) {
            case 2: {
                System.out.println("CANCEL");
                break;
            }
            case 0: {
                System.out.println("YES");
                break;
            }
            case 1: {
                System.out.println("NO");
                break;
            }
            case -1: {
                System.out.println("CLOSED");
                break;
            }
            default: {
                System.out.println("Unknown button!");
            }
        }
    }

    private void m_warningButtonActionPerformed(ActionEvent evt) {
        String s = "100.24";
        try {
            int num = Integer.parseInt(s);
        }
        catch (Exception ex) {
            JMessage.showMessageDialog((Frame)this, "A warning message with an <font color=\"#0066ff\"><i>exception</i></font>.\nCannot parse <code>java.lang.Integer</code> number<br><b>" + ex.getMessage() + "</b>", 2, -1, ex);
        }
    }

    private void m_plainButtonActionPerformed(ActionEvent evt) {
        JMessage.showMessageDialog(this, "A plain message.", -1, -1);
    }

    private void m_infoButtonActionPerformed(ActionEvent evt) {
        boolean acknowledge = false;
        while (!acknowledge) {
            int result = JMessage.showMessageDialog(this, "An info message. Acknowledge?<br>Close the dialog to see what happens...", 1, 0);
            switch (result) {
                case 0: {
                    acknowledge = true;
                    System.out.println("YES");
                    break;
                }
                case 1: {
                    acknowledge = true;
                    System.out.println("NO");
                }
            }
        }
    }

    private void m_errorButtonActionPerformed(ActionEvent evt) {
        try {
            String s = null;
            s.length();
        }
        catch (Exception ex) {
            JMessage.showMessageDialog((Frame)this, "You really did it this time!", 0, -1, ex);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Cannot initialize the look & feel");
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JMessageTester().setVisible(true);
            }
        });
    }
}

