"use strict";

var helpers = require("../../helpers/helpers");

exports["Asia/Amman"] = {

	"guess:by:offset" : helpers.makeTestGuess("Asia/Amman", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Asia/Amman", { abbr: true }),

	"1973" : helpers.makeTestYear("Asia/Amman", [
		["1973-06-05T21:59:59+00:00", "23:59:59", "EET", -120],
		["1973-06-05T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1973-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1973-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1974" : helpers.makeTestYear("Asia/Amman", [
		["1974-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1974-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1974-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1974-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1975" : helpers.makeTestYear("Asia/Amman", [
		["1975-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1975-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1975-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1975-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1976" : helpers.makeTestYear("Asia/Amman", [
		["1976-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1976-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1976-10-31T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1976-10-31T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1977" : helpers.makeTestYear("Asia/Amman", [
		["1977-04-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1977-04-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1977-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1977-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1978" : helpers.makeTestYear("Asia/Amman", [
		["1978-04-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["1978-04-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1978-09-29T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1978-09-29T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1985" : helpers.makeTestYear("Asia/Amman", [
		["1985-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1985-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1985-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1985-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1986" : helpers.makeTestYear("Asia/Amman", [
		["1986-04-03T21:59:59+00:00", "23:59:59", "EET", -120],
		["1986-04-03T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1986-10-02T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1986-10-02T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1987" : helpers.makeTestYear("Asia/Amman", [
		["1987-04-02T21:59:59+00:00", "23:59:59", "EET", -120],
		["1987-04-02T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1987-10-01T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1987-10-01T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1988" : helpers.makeTestYear("Asia/Amman", [
		["1988-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1988-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1988-10-06T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1988-10-06T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1989" : helpers.makeTestYear("Asia/Amman", [
		["1989-05-07T21:59:59+00:00", "23:59:59", "EET", -120],
		["1989-05-07T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1989-10-05T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1989-10-05T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1990" : helpers.makeTestYear("Asia/Amman", [
		["1990-04-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["1990-04-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1990-10-04T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1990-10-04T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1991" : helpers.makeTestYear("Asia/Amman", [
		["1991-04-16T21:59:59+00:00", "23:59:59", "EET", -120],
		["1991-04-16T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1991-09-26T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1991-09-26T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1992" : helpers.makeTestYear("Asia/Amman", [
		["1992-04-09T21:59:59+00:00", "23:59:59", "EET", -120],
		["1992-04-09T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1992-10-01T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1992-10-01T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1993" : helpers.makeTestYear("Asia/Amman", [
		["1993-04-01T21:59:59+00:00", "23:59:59", "EET", -120],
		["1993-04-01T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1993-09-30T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1993-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1994" : helpers.makeTestYear("Asia/Amman", [
		["1994-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["1994-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1994-09-15T20:59:59+00:00", "23:59:59", "EEST", -180],
		["1994-09-15T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1995" : helpers.makeTestYear("Asia/Amman", [
		["1995-04-06T21:59:59+00:00", "23:59:59", "EET", -120],
		["1995-04-06T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1995-09-14T21:59:59+00:00", "00:59:59", "EEST", -180],
		["1995-09-14T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"1996" : helpers.makeTestYear("Asia/Amman", [
		["1996-04-04T21:59:59+00:00", "23:59:59", "EET", -120],
		["1996-04-04T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1996-09-19T21:59:59+00:00", "00:59:59", "EEST", -180],
		["1996-09-19T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"1997" : helpers.makeTestYear("Asia/Amman", [
		["1997-04-03T21:59:59+00:00", "23:59:59", "EET", -120],
		["1997-04-03T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1997-09-18T21:59:59+00:00", "00:59:59", "EEST", -180],
		["1997-09-18T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"1998" : helpers.makeTestYear("Asia/Amman", [
		["1998-04-02T21:59:59+00:00", "23:59:59", "EET", -120],
		["1998-04-02T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1998-09-17T21:59:59+00:00", "00:59:59", "EEST", -180],
		["1998-09-17T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"1999" : helpers.makeTestYear("Asia/Amman", [
		["1999-06-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["1999-06-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["1999-09-23T21:59:59+00:00", "00:59:59", "EEST", -180],
		["1999-09-23T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2000" : helpers.makeTestYear("Asia/Amman", [
		["2000-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2000-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2000-09-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2000-09-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2001" : helpers.makeTestYear("Asia/Amman", [
		["2001-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2001-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2001-09-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2001-09-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2002" : helpers.makeTestYear("Asia/Amman", [
		["2002-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2002-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2002-09-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2002-09-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2003" : helpers.makeTestYear("Asia/Amman", [
		["2003-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2003-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2003-10-23T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2003-10-23T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2004" : helpers.makeTestYear("Asia/Amman", [
		["2004-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2004-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2004-10-14T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2004-10-14T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2005" : helpers.makeTestYear("Asia/Amman", [
		["2005-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2005-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2005-09-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2005-09-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2006" : helpers.makeTestYear("Asia/Amman", [
		["2006-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2006-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2006-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2006-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2007" : helpers.makeTestYear("Asia/Amman", [
		["2007-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2007-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2007-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2007-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2008" : helpers.makeTestYear("Asia/Amman", [
		["2008-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2008-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2008-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2008-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2009" : helpers.makeTestYear("Asia/Amman", [
		["2009-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2009-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2009-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2009-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2010" : helpers.makeTestYear("Asia/Amman", [
		["2010-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2010-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2010-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2010-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2011" : helpers.makeTestYear("Asia/Amman", [
		["2011-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2011-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2011-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2011-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2012" : helpers.makeTestYear("Asia/Amman", [
		["2012-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2012-03-29T22:00:00+00:00", "01:00:00", "EEST", -180]
	]),

	"2013" : helpers.makeTestYear("Asia/Amman", [
		["2013-12-19T20:59:59+00:00", "23:59:59", "EEST", -180],
		["2013-12-19T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"2014" : helpers.makeTestYear("Asia/Amman", [
		["2014-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2014-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2014-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2014-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2015" : helpers.makeTestYear("Asia/Amman", [
		["2015-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2015-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2015-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2015-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2016" : helpers.makeTestYear("Asia/Amman", [
		["2016-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2016-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2016-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2016-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2017" : helpers.makeTestYear("Asia/Amman", [
		["2017-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2017-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2017-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2017-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2018" : helpers.makeTestYear("Asia/Amman", [
		["2018-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2018-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2018-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2018-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2019" : helpers.makeTestYear("Asia/Amman", [
		["2019-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2019-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2019-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2019-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2020" : helpers.makeTestYear("Asia/Amman", [
		["2020-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2020-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2020-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2020-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2021" : helpers.makeTestYear("Asia/Amman", [
		["2021-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2021-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2021-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2021-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2022" : helpers.makeTestYear("Asia/Amman", [
		["2022-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2022-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2022-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2022-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2023" : helpers.makeTestYear("Asia/Amman", [
		["2023-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2023-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2023-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2023-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2024" : helpers.makeTestYear("Asia/Amman", [
		["2024-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2024-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2024-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2024-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2025" : helpers.makeTestYear("Asia/Amman", [
		["2025-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2025-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2025-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2025-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2026" : helpers.makeTestYear("Asia/Amman", [
		["2026-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2026-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2026-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2026-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2027" : helpers.makeTestYear("Asia/Amman", [
		["2027-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2027-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2027-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2027-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2028" : helpers.makeTestYear("Asia/Amman", [
		["2028-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2028-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2028-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2028-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2029" : helpers.makeTestYear("Asia/Amman", [
		["2029-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2029-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2029-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2029-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2030" : helpers.makeTestYear("Asia/Amman", [
		["2030-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2030-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2030-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2030-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2031" : helpers.makeTestYear("Asia/Amman", [
		["2031-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2031-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2031-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2031-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2032" : helpers.makeTestYear("Asia/Amman", [
		["2032-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2032-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2032-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2032-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2033" : helpers.makeTestYear("Asia/Amman", [
		["2033-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2033-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2033-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2033-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2034" : helpers.makeTestYear("Asia/Amman", [
		["2034-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2034-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2034-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2034-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2035" : helpers.makeTestYear("Asia/Amman", [
		["2035-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2035-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2035-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2035-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2036" : helpers.makeTestYear("Asia/Amman", [
		["2036-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2036-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2036-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2036-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2037" : helpers.makeTestYear("Asia/Amman", [
		["2037-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2037-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2037-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2037-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2038" : helpers.makeTestYear("Asia/Amman", [
		["2038-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2038-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2038-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2038-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2039" : helpers.makeTestYear("Asia/Amman", [
		["2039-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2039-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2039-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2039-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2040" : helpers.makeTestYear("Asia/Amman", [
		["2040-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2040-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2040-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2040-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2041" : helpers.makeTestYear("Asia/Amman", [
		["2041-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2041-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2041-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2041-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2042" : helpers.makeTestYear("Asia/Amman", [
		["2042-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2042-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2042-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2042-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2043" : helpers.makeTestYear("Asia/Amman", [
		["2043-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2043-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2043-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2043-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2044" : helpers.makeTestYear("Asia/Amman", [
		["2044-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2044-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2044-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2044-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2045" : helpers.makeTestYear("Asia/Amman", [
		["2045-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2045-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2045-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2045-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2046" : helpers.makeTestYear("Asia/Amman", [
		["2046-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2046-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2046-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2046-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2047" : helpers.makeTestYear("Asia/Amman", [
		["2047-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2047-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2047-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2047-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2048" : helpers.makeTestYear("Asia/Amman", [
		["2048-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2048-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2048-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2048-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2049" : helpers.makeTestYear("Asia/Amman", [
		["2049-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2049-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2049-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2049-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2050" : helpers.makeTestYear("Asia/Amman", [
		["2050-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2050-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2050-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2050-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2051" : helpers.makeTestYear("Asia/Amman", [
		["2051-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2051-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2051-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2051-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2052" : helpers.makeTestYear("Asia/Amman", [
		["2052-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2052-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2052-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2052-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2053" : helpers.makeTestYear("Asia/Amman", [
		["2053-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2053-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2053-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2053-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2054" : helpers.makeTestYear("Asia/Amman", [
		["2054-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2054-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2054-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2054-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2055" : helpers.makeTestYear("Asia/Amman", [
		["2055-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2055-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2055-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2055-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2056" : helpers.makeTestYear("Asia/Amman", [
		["2056-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2056-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2056-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2056-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2057" : helpers.makeTestYear("Asia/Amman", [
		["2057-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2057-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2057-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2057-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2058" : helpers.makeTestYear("Asia/Amman", [
		["2058-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2058-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2058-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2058-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2059" : helpers.makeTestYear("Asia/Amman", [
		["2059-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2059-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2059-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2059-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2060" : helpers.makeTestYear("Asia/Amman", [
		["2060-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2060-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2060-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2060-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2061" : helpers.makeTestYear("Asia/Amman", [
		["2061-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2061-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2061-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2061-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2062" : helpers.makeTestYear("Asia/Amman", [
		["2062-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2062-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2062-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2062-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2063" : helpers.makeTestYear("Asia/Amman", [
		["2063-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2063-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2063-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2063-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2064" : helpers.makeTestYear("Asia/Amman", [
		["2064-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2064-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2064-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2064-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2065" : helpers.makeTestYear("Asia/Amman", [
		["2065-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2065-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2065-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2065-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2066" : helpers.makeTestYear("Asia/Amman", [
		["2066-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2066-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2066-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2066-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2067" : helpers.makeTestYear("Asia/Amman", [
		["2067-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2067-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2067-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2067-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2068" : helpers.makeTestYear("Asia/Amman", [
		["2068-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2068-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2068-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2068-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2069" : helpers.makeTestYear("Asia/Amman", [
		["2069-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2069-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2069-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2069-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2070" : helpers.makeTestYear("Asia/Amman", [
		["2070-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2070-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2070-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2070-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2071" : helpers.makeTestYear("Asia/Amman", [
		["2071-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2071-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2071-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2071-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2072" : helpers.makeTestYear("Asia/Amman", [
		["2072-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2072-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2072-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2072-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2073" : helpers.makeTestYear("Asia/Amman", [
		["2073-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2073-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2073-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2073-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2074" : helpers.makeTestYear("Asia/Amman", [
		["2074-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2074-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2074-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2074-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2075" : helpers.makeTestYear("Asia/Amman", [
		["2075-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2075-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2075-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2075-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2076" : helpers.makeTestYear("Asia/Amman", [
		["2076-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2076-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2076-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2076-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2077" : helpers.makeTestYear("Asia/Amman", [
		["2077-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2077-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2077-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2077-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2078" : helpers.makeTestYear("Asia/Amman", [
		["2078-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2078-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2078-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2078-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2079" : helpers.makeTestYear("Asia/Amman", [
		["2079-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2079-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2079-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2079-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2080" : helpers.makeTestYear("Asia/Amman", [
		["2080-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2080-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2080-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2080-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2081" : helpers.makeTestYear("Asia/Amman", [
		["2081-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2081-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2081-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2081-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2082" : helpers.makeTestYear("Asia/Amman", [
		["2082-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2082-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2082-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2082-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2083" : helpers.makeTestYear("Asia/Amman", [
		["2083-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2083-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2083-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2083-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2084" : helpers.makeTestYear("Asia/Amman", [
		["2084-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2084-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2084-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2084-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2085" : helpers.makeTestYear("Asia/Amman", [
		["2085-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2085-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2085-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2085-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2086" : helpers.makeTestYear("Asia/Amman", [
		["2086-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2086-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2086-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2086-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2087" : helpers.makeTestYear("Asia/Amman", [
		["2087-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2087-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2087-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2087-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2088" : helpers.makeTestYear("Asia/Amman", [
		["2088-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2088-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2088-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2088-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2089" : helpers.makeTestYear("Asia/Amman", [
		["2089-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2089-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2089-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2089-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2090" : helpers.makeTestYear("Asia/Amman", [
		["2090-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2090-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2090-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2090-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2091" : helpers.makeTestYear("Asia/Amman", [
		["2091-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2091-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2091-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2091-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2092" : helpers.makeTestYear("Asia/Amman", [
		["2092-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2092-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2092-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2092-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2093" : helpers.makeTestYear("Asia/Amman", [
		["2093-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2093-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2093-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2093-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2094" : helpers.makeTestYear("Asia/Amman", [
		["2094-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2094-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2094-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2094-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2095" : helpers.makeTestYear("Asia/Amman", [
		["2095-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2095-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2095-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2095-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2096" : helpers.makeTestYear("Asia/Amman", [
		["2096-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2096-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2096-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2096-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2097" : helpers.makeTestYear("Asia/Amman", [
		["2097-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2097-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2097-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2097-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2098" : helpers.makeTestYear("Asia/Amman", [
		["2098-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2098-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2098-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2098-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2099" : helpers.makeTestYear("Asia/Amman", [
		["2099-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2099-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2099-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2099-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2100" : helpers.makeTestYear("Asia/Amman", [
		["2100-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2100-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2100-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2100-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2101" : helpers.makeTestYear("Asia/Amman", [
		["2101-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2101-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2101-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2101-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2102" : helpers.makeTestYear("Asia/Amman", [
		["2102-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2102-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2102-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2102-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2103" : helpers.makeTestYear("Asia/Amman", [
		["2103-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2103-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2103-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2103-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2104" : helpers.makeTestYear("Asia/Amman", [
		["2104-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2104-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2104-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2104-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2105" : helpers.makeTestYear("Asia/Amman", [
		["2105-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2105-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2105-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2105-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2106" : helpers.makeTestYear("Asia/Amman", [
		["2106-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2106-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2106-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2106-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2107" : helpers.makeTestYear("Asia/Amman", [
		["2107-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2107-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2107-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2107-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2108" : helpers.makeTestYear("Asia/Amman", [
		["2108-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2108-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2108-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2108-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2109" : helpers.makeTestYear("Asia/Amman", [
		["2109-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2109-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2109-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2109-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2110" : helpers.makeTestYear("Asia/Amman", [
		["2110-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2110-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2110-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2110-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2111" : helpers.makeTestYear("Asia/Amman", [
		["2111-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2111-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2111-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2111-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2112" : helpers.makeTestYear("Asia/Amman", [
		["2112-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2112-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2112-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2112-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2113" : helpers.makeTestYear("Asia/Amman", [
		["2113-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2113-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2113-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2113-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2114" : helpers.makeTestYear("Asia/Amman", [
		["2114-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2114-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2114-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2114-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2115" : helpers.makeTestYear("Asia/Amman", [
		["2115-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2115-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2115-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2115-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2116" : helpers.makeTestYear("Asia/Amman", [
		["2116-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2116-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2116-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2116-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2117" : helpers.makeTestYear("Asia/Amman", [
		["2117-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2117-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2117-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2117-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2118" : helpers.makeTestYear("Asia/Amman", [
		["2118-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2118-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2118-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2118-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2119" : helpers.makeTestYear("Asia/Amman", [
		["2119-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2119-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2119-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2119-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2120" : helpers.makeTestYear("Asia/Amman", [
		["2120-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2120-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2120-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2120-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2121" : helpers.makeTestYear("Asia/Amman", [
		["2121-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2121-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2121-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2121-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2122" : helpers.makeTestYear("Asia/Amman", [
		["2122-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2122-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2122-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2122-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2123" : helpers.makeTestYear("Asia/Amman", [
		["2123-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2123-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2123-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2123-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2124" : helpers.makeTestYear("Asia/Amman", [
		["2124-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2124-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2124-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2124-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2125" : helpers.makeTestYear("Asia/Amman", [
		["2125-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2125-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2125-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2125-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2126" : helpers.makeTestYear("Asia/Amman", [
		["2126-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2126-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2126-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2126-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2127" : helpers.makeTestYear("Asia/Amman", [
		["2127-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2127-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2127-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2127-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2128" : helpers.makeTestYear("Asia/Amman", [
		["2128-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2128-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2128-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2128-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2129" : helpers.makeTestYear("Asia/Amman", [
		["2129-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2129-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2129-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2129-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2130" : helpers.makeTestYear("Asia/Amman", [
		["2130-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2130-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2130-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2130-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2131" : helpers.makeTestYear("Asia/Amman", [
		["2131-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2131-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2131-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2131-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2132" : helpers.makeTestYear("Asia/Amman", [
		["2132-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2132-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2132-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2132-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2133" : helpers.makeTestYear("Asia/Amman", [
		["2133-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2133-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2133-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2133-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2134" : helpers.makeTestYear("Asia/Amman", [
		["2134-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2134-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2134-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2134-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2135" : helpers.makeTestYear("Asia/Amman", [
		["2135-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2135-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2135-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2135-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2136" : helpers.makeTestYear("Asia/Amman", [
		["2136-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2136-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2136-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2136-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2137" : helpers.makeTestYear("Asia/Amman", [
		["2137-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2137-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2137-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2137-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2138" : helpers.makeTestYear("Asia/Amman", [
		["2138-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2138-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2138-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2138-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2139" : helpers.makeTestYear("Asia/Amman", [
		["2139-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2139-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2139-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2139-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2140" : helpers.makeTestYear("Asia/Amman", [
		["2140-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2140-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2140-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2140-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2141" : helpers.makeTestYear("Asia/Amman", [
		["2141-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2141-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2141-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2141-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2142" : helpers.makeTestYear("Asia/Amman", [
		["2142-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2142-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2142-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2142-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2143" : helpers.makeTestYear("Asia/Amman", [
		["2143-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2143-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2143-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2143-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2144" : helpers.makeTestYear("Asia/Amman", [
		["2144-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2144-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2144-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2144-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2145" : helpers.makeTestYear("Asia/Amman", [
		["2145-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2145-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2145-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2145-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2146" : helpers.makeTestYear("Asia/Amman", [
		["2146-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2146-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2146-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2146-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2147" : helpers.makeTestYear("Asia/Amman", [
		["2147-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2147-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2147-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2147-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2148" : helpers.makeTestYear("Asia/Amman", [
		["2148-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2148-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2148-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2148-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2149" : helpers.makeTestYear("Asia/Amman", [
		["2149-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2149-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2149-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2149-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2150" : helpers.makeTestYear("Asia/Amman", [
		["2150-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2150-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2150-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2150-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2151" : helpers.makeTestYear("Asia/Amman", [
		["2151-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2151-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2151-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2151-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2152" : helpers.makeTestYear("Asia/Amman", [
		["2152-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2152-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2152-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2152-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2153" : helpers.makeTestYear("Asia/Amman", [
		["2153-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2153-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2153-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2153-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2154" : helpers.makeTestYear("Asia/Amman", [
		["2154-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2154-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2154-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2154-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2155" : helpers.makeTestYear("Asia/Amman", [
		["2155-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2155-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2155-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2155-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2156" : helpers.makeTestYear("Asia/Amman", [
		["2156-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2156-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2156-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2156-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2157" : helpers.makeTestYear("Asia/Amman", [
		["2157-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2157-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2157-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2157-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2158" : helpers.makeTestYear("Asia/Amman", [
		["2158-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2158-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2158-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2158-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2159" : helpers.makeTestYear("Asia/Amman", [
		["2159-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2159-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2159-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2159-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2160" : helpers.makeTestYear("Asia/Amman", [
		["2160-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2160-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2160-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2160-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2161" : helpers.makeTestYear("Asia/Amman", [
		["2161-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2161-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2161-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2161-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2162" : helpers.makeTestYear("Asia/Amman", [
		["2162-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2162-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2162-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2162-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2163" : helpers.makeTestYear("Asia/Amman", [
		["2163-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2163-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2163-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2163-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2164" : helpers.makeTestYear("Asia/Amman", [
		["2164-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2164-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2164-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2164-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2165" : helpers.makeTestYear("Asia/Amman", [
		["2165-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2165-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2165-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2165-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2166" : helpers.makeTestYear("Asia/Amman", [
		["2166-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2166-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2166-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2166-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2167" : helpers.makeTestYear("Asia/Amman", [
		["2167-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2167-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2167-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2167-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2168" : helpers.makeTestYear("Asia/Amman", [
		["2168-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2168-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2168-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2168-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2169" : helpers.makeTestYear("Asia/Amman", [
		["2169-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2169-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2169-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2169-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2170" : helpers.makeTestYear("Asia/Amman", [
		["2170-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2170-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2170-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2170-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2171" : helpers.makeTestYear("Asia/Amman", [
		["2171-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2171-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2171-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2171-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2172" : helpers.makeTestYear("Asia/Amman", [
		["2172-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2172-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2172-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2172-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2173" : helpers.makeTestYear("Asia/Amman", [
		["2173-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2173-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2173-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2173-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2174" : helpers.makeTestYear("Asia/Amman", [
		["2174-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2174-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2174-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2174-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2175" : helpers.makeTestYear("Asia/Amman", [
		["2175-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2175-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2175-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2175-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2176" : helpers.makeTestYear("Asia/Amman", [
		["2176-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2176-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2176-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2176-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2177" : helpers.makeTestYear("Asia/Amman", [
		["2177-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2177-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2177-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2177-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2178" : helpers.makeTestYear("Asia/Amman", [
		["2178-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2178-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2178-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2178-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2179" : helpers.makeTestYear("Asia/Amman", [
		["2179-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2179-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2179-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2179-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2180" : helpers.makeTestYear("Asia/Amman", [
		["2180-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2180-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2180-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2180-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2181" : helpers.makeTestYear("Asia/Amman", [
		["2181-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2181-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2181-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2181-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2182" : helpers.makeTestYear("Asia/Amman", [
		["2182-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2182-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2182-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2182-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2183" : helpers.makeTestYear("Asia/Amman", [
		["2183-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2183-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2183-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2183-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2184" : helpers.makeTestYear("Asia/Amman", [
		["2184-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2184-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2184-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2184-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2185" : helpers.makeTestYear("Asia/Amman", [
		["2185-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2185-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2185-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2185-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2186" : helpers.makeTestYear("Asia/Amman", [
		["2186-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2186-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2186-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2186-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2187" : helpers.makeTestYear("Asia/Amman", [
		["2187-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2187-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2187-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2187-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2188" : helpers.makeTestYear("Asia/Amman", [
		["2188-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2188-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2188-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2188-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2189" : helpers.makeTestYear("Asia/Amman", [
		["2189-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2189-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2189-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2189-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2190" : helpers.makeTestYear("Asia/Amman", [
		["2190-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2190-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2190-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2190-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2191" : helpers.makeTestYear("Asia/Amman", [
		["2191-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2191-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2191-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2191-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2192" : helpers.makeTestYear("Asia/Amman", [
		["2192-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2192-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2192-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2192-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2193" : helpers.makeTestYear("Asia/Amman", [
		["2193-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2193-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2193-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2193-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2194" : helpers.makeTestYear("Asia/Amman", [
		["2194-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2194-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2194-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2194-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2195" : helpers.makeTestYear("Asia/Amman", [
		["2195-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2195-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2195-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2195-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2196" : helpers.makeTestYear("Asia/Amman", [
		["2196-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2196-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2196-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2196-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2197" : helpers.makeTestYear("Asia/Amman", [
		["2197-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2197-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2197-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2197-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2198" : helpers.makeTestYear("Asia/Amman", [
		["2198-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2198-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2198-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2198-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2199" : helpers.makeTestYear("Asia/Amman", [
		["2199-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2199-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2199-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2199-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2200" : helpers.makeTestYear("Asia/Amman", [
		["2200-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2200-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2200-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2200-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2201" : helpers.makeTestYear("Asia/Amman", [
		["2201-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2201-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2201-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2201-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2202" : helpers.makeTestYear("Asia/Amman", [
		["2202-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2202-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2202-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2202-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2203" : helpers.makeTestYear("Asia/Amman", [
		["2203-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2203-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2203-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2203-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2204" : helpers.makeTestYear("Asia/Amman", [
		["2204-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2204-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2204-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2204-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2205" : helpers.makeTestYear("Asia/Amman", [
		["2205-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2205-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2205-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2205-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2206" : helpers.makeTestYear("Asia/Amman", [
		["2206-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2206-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2206-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2206-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2207" : helpers.makeTestYear("Asia/Amman", [
		["2207-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2207-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2207-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2207-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2208" : helpers.makeTestYear("Asia/Amman", [
		["2208-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2208-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2208-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2208-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2209" : helpers.makeTestYear("Asia/Amman", [
		["2209-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2209-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2209-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2209-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2210" : helpers.makeTestYear("Asia/Amman", [
		["2210-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2210-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2210-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2210-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2211" : helpers.makeTestYear("Asia/Amman", [
		["2211-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2211-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2211-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2211-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2212" : helpers.makeTestYear("Asia/Amman", [
		["2212-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2212-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2212-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2212-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2213" : helpers.makeTestYear("Asia/Amman", [
		["2213-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2213-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2213-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2213-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2214" : helpers.makeTestYear("Asia/Amman", [
		["2214-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2214-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2214-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2214-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2215" : helpers.makeTestYear("Asia/Amman", [
		["2215-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2215-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2215-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2215-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2216" : helpers.makeTestYear("Asia/Amman", [
		["2216-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2216-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2216-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2216-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2217" : helpers.makeTestYear("Asia/Amman", [
		["2217-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2217-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2217-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2217-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2218" : helpers.makeTestYear("Asia/Amman", [
		["2218-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2218-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2218-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2218-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2219" : helpers.makeTestYear("Asia/Amman", [
		["2219-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2219-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2219-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2219-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2220" : helpers.makeTestYear("Asia/Amman", [
		["2220-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2220-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2220-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2220-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2221" : helpers.makeTestYear("Asia/Amman", [
		["2221-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2221-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2221-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2221-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2222" : helpers.makeTestYear("Asia/Amman", [
		["2222-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2222-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2222-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2222-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2223" : helpers.makeTestYear("Asia/Amman", [
		["2223-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2223-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2223-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2223-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2224" : helpers.makeTestYear("Asia/Amman", [
		["2224-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2224-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2224-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2224-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2225" : helpers.makeTestYear("Asia/Amman", [
		["2225-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2225-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2225-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2225-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2226" : helpers.makeTestYear("Asia/Amman", [
		["2226-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2226-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2226-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2226-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2227" : helpers.makeTestYear("Asia/Amman", [
		["2227-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2227-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2227-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2227-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2228" : helpers.makeTestYear("Asia/Amman", [
		["2228-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2228-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2228-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2228-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2229" : helpers.makeTestYear("Asia/Amman", [
		["2229-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2229-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2229-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2229-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2230" : helpers.makeTestYear("Asia/Amman", [
		["2230-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2230-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2230-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2230-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2231" : helpers.makeTestYear("Asia/Amman", [
		["2231-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2231-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2231-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2231-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2232" : helpers.makeTestYear("Asia/Amman", [
		["2232-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2232-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2232-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2232-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2233" : helpers.makeTestYear("Asia/Amman", [
		["2233-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2233-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2233-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2233-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2234" : helpers.makeTestYear("Asia/Amman", [
		["2234-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2234-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2234-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2234-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2235" : helpers.makeTestYear("Asia/Amman", [
		["2235-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2235-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2235-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2235-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2236" : helpers.makeTestYear("Asia/Amman", [
		["2236-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2236-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2236-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2236-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2237" : helpers.makeTestYear("Asia/Amman", [
		["2237-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2237-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2237-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2237-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2238" : helpers.makeTestYear("Asia/Amman", [
		["2238-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2238-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2238-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2238-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2239" : helpers.makeTestYear("Asia/Amman", [
		["2239-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2239-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2239-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2239-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2240" : helpers.makeTestYear("Asia/Amman", [
		["2240-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2240-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2240-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2240-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2241" : helpers.makeTestYear("Asia/Amman", [
		["2241-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2241-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2241-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2241-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2242" : helpers.makeTestYear("Asia/Amman", [
		["2242-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2242-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2242-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2242-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2243" : helpers.makeTestYear("Asia/Amman", [
		["2243-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2243-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2243-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2243-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2244" : helpers.makeTestYear("Asia/Amman", [
		["2244-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2244-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2244-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2244-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2245" : helpers.makeTestYear("Asia/Amman", [
		["2245-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2245-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2245-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2245-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2246" : helpers.makeTestYear("Asia/Amman", [
		["2246-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2246-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2246-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2246-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2247" : helpers.makeTestYear("Asia/Amman", [
		["2247-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2247-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2247-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2247-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2248" : helpers.makeTestYear("Asia/Amman", [
		["2248-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2248-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2248-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2248-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2249" : helpers.makeTestYear("Asia/Amman", [
		["2249-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2249-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2249-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2249-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2250" : helpers.makeTestYear("Asia/Amman", [
		["2250-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2250-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2250-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2250-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2251" : helpers.makeTestYear("Asia/Amman", [
		["2251-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2251-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2251-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2251-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2252" : helpers.makeTestYear("Asia/Amman", [
		["2252-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2252-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2252-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2252-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2253" : helpers.makeTestYear("Asia/Amman", [
		["2253-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2253-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2253-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2253-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2254" : helpers.makeTestYear("Asia/Amman", [
		["2254-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2254-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2254-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2254-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2255" : helpers.makeTestYear("Asia/Amman", [
		["2255-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2255-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2255-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2255-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2256" : helpers.makeTestYear("Asia/Amman", [
		["2256-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2256-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2256-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2256-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2257" : helpers.makeTestYear("Asia/Amman", [
		["2257-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2257-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2257-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2257-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2258" : helpers.makeTestYear("Asia/Amman", [
		["2258-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2258-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2258-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2258-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2259" : helpers.makeTestYear("Asia/Amman", [
		["2259-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2259-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2259-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2259-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2260" : helpers.makeTestYear("Asia/Amman", [
		["2260-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2260-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2260-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2260-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2261" : helpers.makeTestYear("Asia/Amman", [
		["2261-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2261-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2261-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2261-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2262" : helpers.makeTestYear("Asia/Amman", [
		["2262-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2262-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2262-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2262-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2263" : helpers.makeTestYear("Asia/Amman", [
		["2263-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2263-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2263-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2263-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2264" : helpers.makeTestYear("Asia/Amman", [
		["2264-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2264-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2264-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2264-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2265" : helpers.makeTestYear("Asia/Amman", [
		["2265-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2265-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2265-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2265-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2266" : helpers.makeTestYear("Asia/Amman", [
		["2266-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2266-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2266-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2266-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2267" : helpers.makeTestYear("Asia/Amman", [
		["2267-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2267-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2267-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2267-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2268" : helpers.makeTestYear("Asia/Amman", [
		["2268-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2268-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2268-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2268-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2269" : helpers.makeTestYear("Asia/Amman", [
		["2269-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2269-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2269-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2269-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2270" : helpers.makeTestYear("Asia/Amman", [
		["2270-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2270-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2270-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2270-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2271" : helpers.makeTestYear("Asia/Amman", [
		["2271-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2271-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2271-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2271-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2272" : helpers.makeTestYear("Asia/Amman", [
		["2272-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2272-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2272-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2272-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2273" : helpers.makeTestYear("Asia/Amman", [
		["2273-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2273-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2273-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2273-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2274" : helpers.makeTestYear("Asia/Amman", [
		["2274-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2274-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2274-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2274-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2275" : helpers.makeTestYear("Asia/Amman", [
		["2275-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2275-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2275-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2275-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2276" : helpers.makeTestYear("Asia/Amman", [
		["2276-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2276-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2276-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2276-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2277" : helpers.makeTestYear("Asia/Amman", [
		["2277-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2277-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2277-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2277-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2278" : helpers.makeTestYear("Asia/Amman", [
		["2278-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2278-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2278-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2278-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2279" : helpers.makeTestYear("Asia/Amman", [
		["2279-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2279-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2279-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2279-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2280" : helpers.makeTestYear("Asia/Amman", [
		["2280-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2280-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2280-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2280-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2281" : helpers.makeTestYear("Asia/Amman", [
		["2281-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2281-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2281-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2281-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2282" : helpers.makeTestYear("Asia/Amman", [
		["2282-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2282-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2282-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2282-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2283" : helpers.makeTestYear("Asia/Amman", [
		["2283-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2283-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2283-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2283-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2284" : helpers.makeTestYear("Asia/Amman", [
		["2284-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2284-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2284-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2284-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2285" : helpers.makeTestYear("Asia/Amman", [
		["2285-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2285-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2285-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2285-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2286" : helpers.makeTestYear("Asia/Amman", [
		["2286-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2286-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2286-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2286-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2287" : helpers.makeTestYear("Asia/Amman", [
		["2287-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2287-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2287-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2287-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2288" : helpers.makeTestYear("Asia/Amman", [
		["2288-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2288-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2288-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2288-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2289" : helpers.makeTestYear("Asia/Amman", [
		["2289-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2289-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2289-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2289-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2290" : helpers.makeTestYear("Asia/Amman", [
		["2290-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2290-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2290-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2290-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2291" : helpers.makeTestYear("Asia/Amman", [
		["2291-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2291-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2291-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2291-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2292" : helpers.makeTestYear("Asia/Amman", [
		["2292-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2292-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2292-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2292-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2293" : helpers.makeTestYear("Asia/Amman", [
		["2293-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2293-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2293-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2293-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2294" : helpers.makeTestYear("Asia/Amman", [
		["2294-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2294-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2294-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2294-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2295" : helpers.makeTestYear("Asia/Amman", [
		["2295-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2295-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2295-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2295-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2296" : helpers.makeTestYear("Asia/Amman", [
		["2296-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2296-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2296-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2296-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2297" : helpers.makeTestYear("Asia/Amman", [
		["2297-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2297-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2297-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2297-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2298" : helpers.makeTestYear("Asia/Amman", [
		["2298-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2298-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2298-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2298-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2299" : helpers.makeTestYear("Asia/Amman", [
		["2299-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2299-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2299-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2299-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2300" : helpers.makeTestYear("Asia/Amman", [
		["2300-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2300-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2300-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2300-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2301" : helpers.makeTestYear("Asia/Amman", [
		["2301-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2301-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2301-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2301-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2302" : helpers.makeTestYear("Asia/Amman", [
		["2302-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2302-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2302-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2302-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2303" : helpers.makeTestYear("Asia/Amman", [
		["2303-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2303-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2303-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2303-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2304" : helpers.makeTestYear("Asia/Amman", [
		["2304-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2304-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2304-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2304-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2305" : helpers.makeTestYear("Asia/Amman", [
		["2305-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2305-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2305-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2305-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2306" : helpers.makeTestYear("Asia/Amman", [
		["2306-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2306-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2306-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2306-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2307" : helpers.makeTestYear("Asia/Amman", [
		["2307-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2307-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2307-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2307-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2308" : helpers.makeTestYear("Asia/Amman", [
		["2308-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2308-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2308-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2308-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2309" : helpers.makeTestYear("Asia/Amman", [
		["2309-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2309-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2309-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2309-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2310" : helpers.makeTestYear("Asia/Amman", [
		["2310-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2310-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2310-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2310-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2311" : helpers.makeTestYear("Asia/Amman", [
		["2311-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2311-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2311-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2311-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2312" : helpers.makeTestYear("Asia/Amman", [
		["2312-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2312-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2312-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2312-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2313" : helpers.makeTestYear("Asia/Amman", [
		["2313-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2313-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2313-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2313-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2314" : helpers.makeTestYear("Asia/Amman", [
		["2314-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2314-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2314-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2314-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2315" : helpers.makeTestYear("Asia/Amman", [
		["2315-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2315-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2315-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2315-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2316" : helpers.makeTestYear("Asia/Amman", [
		["2316-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2316-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2316-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2316-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2317" : helpers.makeTestYear("Asia/Amman", [
		["2317-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2317-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2317-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2317-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2318" : helpers.makeTestYear("Asia/Amman", [
		["2318-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2318-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2318-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2318-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2319" : helpers.makeTestYear("Asia/Amman", [
		["2319-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2319-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2319-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2319-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2320" : helpers.makeTestYear("Asia/Amman", [
		["2320-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2320-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2320-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2320-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2321" : helpers.makeTestYear("Asia/Amman", [
		["2321-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2321-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2321-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2321-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2322" : helpers.makeTestYear("Asia/Amman", [
		["2322-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2322-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2322-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2322-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2323" : helpers.makeTestYear("Asia/Amman", [
		["2323-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2323-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2323-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2323-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2324" : helpers.makeTestYear("Asia/Amman", [
		["2324-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2324-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2324-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2324-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2325" : helpers.makeTestYear("Asia/Amman", [
		["2325-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2325-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2325-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2325-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2326" : helpers.makeTestYear("Asia/Amman", [
		["2326-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2326-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2326-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2326-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2327" : helpers.makeTestYear("Asia/Amman", [
		["2327-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2327-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2327-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2327-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2328" : helpers.makeTestYear("Asia/Amman", [
		["2328-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2328-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2328-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2328-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2329" : helpers.makeTestYear("Asia/Amman", [
		["2329-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2329-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2329-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2329-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2330" : helpers.makeTestYear("Asia/Amman", [
		["2330-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2330-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2330-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2330-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2331" : helpers.makeTestYear("Asia/Amman", [
		["2331-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2331-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2331-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2331-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2332" : helpers.makeTestYear("Asia/Amman", [
		["2332-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2332-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2332-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2332-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2333" : helpers.makeTestYear("Asia/Amman", [
		["2333-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2333-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2333-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2333-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2334" : helpers.makeTestYear("Asia/Amman", [
		["2334-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2334-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2334-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2334-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2335" : helpers.makeTestYear("Asia/Amman", [
		["2335-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2335-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2335-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2335-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2336" : helpers.makeTestYear("Asia/Amman", [
		["2336-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2336-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2336-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2336-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2337" : helpers.makeTestYear("Asia/Amman", [
		["2337-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2337-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2337-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2337-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2338" : helpers.makeTestYear("Asia/Amman", [
		["2338-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2338-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2338-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2338-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2339" : helpers.makeTestYear("Asia/Amman", [
		["2339-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2339-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2339-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2339-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2340" : helpers.makeTestYear("Asia/Amman", [
		["2340-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2340-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2340-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2340-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2341" : helpers.makeTestYear("Asia/Amman", [
		["2341-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2341-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2341-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2341-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2342" : helpers.makeTestYear("Asia/Amman", [
		["2342-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2342-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2342-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2342-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2343" : helpers.makeTestYear("Asia/Amman", [
		["2343-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2343-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2343-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2343-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2344" : helpers.makeTestYear("Asia/Amman", [
		["2344-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2344-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2344-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2344-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2345" : helpers.makeTestYear("Asia/Amman", [
		["2345-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2345-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2345-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2345-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2346" : helpers.makeTestYear("Asia/Amman", [
		["2346-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2346-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2346-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2346-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2347" : helpers.makeTestYear("Asia/Amman", [
		["2347-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2347-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2347-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2347-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2348" : helpers.makeTestYear("Asia/Amman", [
		["2348-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2348-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2348-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2348-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2349" : helpers.makeTestYear("Asia/Amman", [
		["2349-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2349-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2349-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2349-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2350" : helpers.makeTestYear("Asia/Amman", [
		["2350-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2350-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2350-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2350-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2351" : helpers.makeTestYear("Asia/Amman", [
		["2351-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2351-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2351-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2351-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2352" : helpers.makeTestYear("Asia/Amman", [
		["2352-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2352-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2352-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2352-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2353" : helpers.makeTestYear("Asia/Amman", [
		["2353-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2353-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2353-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2353-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2354" : helpers.makeTestYear("Asia/Amman", [
		["2354-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2354-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2354-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2354-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2355" : helpers.makeTestYear("Asia/Amman", [
		["2355-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2355-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2355-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2355-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2356" : helpers.makeTestYear("Asia/Amman", [
		["2356-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2356-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2356-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2356-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2357" : helpers.makeTestYear("Asia/Amman", [
		["2357-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2357-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2357-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2357-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2358" : helpers.makeTestYear("Asia/Amman", [
		["2358-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2358-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2358-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2358-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2359" : helpers.makeTestYear("Asia/Amman", [
		["2359-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2359-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2359-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2359-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2360" : helpers.makeTestYear("Asia/Amman", [
		["2360-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2360-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2360-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2360-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2361" : helpers.makeTestYear("Asia/Amman", [
		["2361-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2361-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2361-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2361-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2362" : helpers.makeTestYear("Asia/Amman", [
		["2362-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2362-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2362-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2362-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2363" : helpers.makeTestYear("Asia/Amman", [
		["2363-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2363-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2363-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2363-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2364" : helpers.makeTestYear("Asia/Amman", [
		["2364-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2364-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2364-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2364-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2365" : helpers.makeTestYear("Asia/Amman", [
		["2365-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2365-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2365-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2365-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2366" : helpers.makeTestYear("Asia/Amman", [
		["2366-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2366-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2366-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2366-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2367" : helpers.makeTestYear("Asia/Amman", [
		["2367-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2367-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2367-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2367-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2368" : helpers.makeTestYear("Asia/Amman", [
		["2368-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2368-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2368-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2368-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2369" : helpers.makeTestYear("Asia/Amman", [
		["2369-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2369-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2369-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2369-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2370" : helpers.makeTestYear("Asia/Amman", [
		["2370-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2370-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2370-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2370-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2371" : helpers.makeTestYear("Asia/Amman", [
		["2371-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2371-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2371-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2371-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2372" : helpers.makeTestYear("Asia/Amman", [
		["2372-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2372-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2372-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2372-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2373" : helpers.makeTestYear("Asia/Amman", [
		["2373-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2373-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2373-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2373-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2374" : helpers.makeTestYear("Asia/Amman", [
		["2374-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2374-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2374-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2374-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2375" : helpers.makeTestYear("Asia/Amman", [
		["2375-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2375-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2375-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2375-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2376" : helpers.makeTestYear("Asia/Amman", [
		["2376-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2376-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2376-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2376-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2377" : helpers.makeTestYear("Asia/Amman", [
		["2377-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2377-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2377-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2377-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2378" : helpers.makeTestYear("Asia/Amman", [
		["2378-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2378-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2378-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2378-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2379" : helpers.makeTestYear("Asia/Amman", [
		["2379-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2379-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2379-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2379-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2380" : helpers.makeTestYear("Asia/Amman", [
		["2380-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2380-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2380-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2380-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2381" : helpers.makeTestYear("Asia/Amman", [
		["2381-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2381-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2381-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2381-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2382" : helpers.makeTestYear("Asia/Amman", [
		["2382-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2382-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2382-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2382-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2383" : helpers.makeTestYear("Asia/Amman", [
		["2383-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2383-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2383-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2383-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2384" : helpers.makeTestYear("Asia/Amman", [
		["2384-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2384-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2384-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2384-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2385" : helpers.makeTestYear("Asia/Amman", [
		["2385-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2385-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2385-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2385-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2386" : helpers.makeTestYear("Asia/Amman", [
		["2386-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2386-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2386-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2386-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2387" : helpers.makeTestYear("Asia/Amman", [
		["2387-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2387-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2387-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2387-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2388" : helpers.makeTestYear("Asia/Amman", [
		["2388-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2388-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2388-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2388-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2389" : helpers.makeTestYear("Asia/Amman", [
		["2389-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2389-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2389-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2389-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2390" : helpers.makeTestYear("Asia/Amman", [
		["2390-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2390-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2390-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2390-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2391" : helpers.makeTestYear("Asia/Amman", [
		["2391-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2391-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2391-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2391-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2392" : helpers.makeTestYear("Asia/Amman", [
		["2392-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2392-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2392-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2392-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2393" : helpers.makeTestYear("Asia/Amman", [
		["2393-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2393-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2393-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2393-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2394" : helpers.makeTestYear("Asia/Amman", [
		["2394-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2394-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2394-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2394-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2395" : helpers.makeTestYear("Asia/Amman", [
		["2395-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2395-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2395-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2395-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2396" : helpers.makeTestYear("Asia/Amman", [
		["2396-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2396-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2396-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2396-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2397" : helpers.makeTestYear("Asia/Amman", [
		["2397-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2397-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2397-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2397-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2398" : helpers.makeTestYear("Asia/Amman", [
		["2398-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2398-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2398-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2398-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2399" : helpers.makeTestYear("Asia/Amman", [
		["2399-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2399-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2399-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2399-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2400" : helpers.makeTestYear("Asia/Amman", [
		["2400-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2400-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2400-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2400-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2401" : helpers.makeTestYear("Asia/Amman", [
		["2401-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2401-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2401-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2401-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2402" : helpers.makeTestYear("Asia/Amman", [
		["2402-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2402-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2402-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2402-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2403" : helpers.makeTestYear("Asia/Amman", [
		["2403-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2403-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2403-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2403-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2404" : helpers.makeTestYear("Asia/Amman", [
		["2404-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2404-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2404-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2404-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2405" : helpers.makeTestYear("Asia/Amman", [
		["2405-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2405-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2405-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2405-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2406" : helpers.makeTestYear("Asia/Amman", [
		["2406-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2406-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2406-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2406-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2407" : helpers.makeTestYear("Asia/Amman", [
		["2407-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2407-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2407-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2407-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2408" : helpers.makeTestYear("Asia/Amman", [
		["2408-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2408-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2408-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2408-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2409" : helpers.makeTestYear("Asia/Amman", [
		["2409-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2409-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2409-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2409-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2410" : helpers.makeTestYear("Asia/Amman", [
		["2410-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2410-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2410-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2410-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2411" : helpers.makeTestYear("Asia/Amman", [
		["2411-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2411-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2411-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2411-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2412" : helpers.makeTestYear("Asia/Amman", [
		["2412-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2412-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2412-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2412-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2413" : helpers.makeTestYear("Asia/Amman", [
		["2413-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2413-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2413-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2413-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2414" : helpers.makeTestYear("Asia/Amman", [
		["2414-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2414-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2414-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2414-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2415" : helpers.makeTestYear("Asia/Amman", [
		["2415-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2415-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2415-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2415-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2416" : helpers.makeTestYear("Asia/Amman", [
		["2416-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2416-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2416-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2416-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2417" : helpers.makeTestYear("Asia/Amman", [
		["2417-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2417-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2417-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2417-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2418" : helpers.makeTestYear("Asia/Amman", [
		["2418-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2418-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2418-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2418-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2419" : helpers.makeTestYear("Asia/Amman", [
		["2419-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2419-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2419-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2419-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2420" : helpers.makeTestYear("Asia/Amman", [
		["2420-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2420-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2420-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2420-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2421" : helpers.makeTestYear("Asia/Amman", [
		["2421-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2421-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2421-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2421-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2422" : helpers.makeTestYear("Asia/Amman", [
		["2422-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2422-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2422-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2422-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2423" : helpers.makeTestYear("Asia/Amman", [
		["2423-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2423-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2423-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2423-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2424" : helpers.makeTestYear("Asia/Amman", [
		["2424-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2424-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2424-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2424-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2425" : helpers.makeTestYear("Asia/Amman", [
		["2425-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2425-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2425-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2425-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2426" : helpers.makeTestYear("Asia/Amman", [
		["2426-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2426-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2426-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2426-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2427" : helpers.makeTestYear("Asia/Amman", [
		["2427-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2427-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2427-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2427-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2428" : helpers.makeTestYear("Asia/Amman", [
		["2428-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2428-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2428-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2428-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2429" : helpers.makeTestYear("Asia/Amman", [
		["2429-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2429-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2429-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2429-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2430" : helpers.makeTestYear("Asia/Amman", [
		["2430-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2430-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2430-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2430-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2431" : helpers.makeTestYear("Asia/Amman", [
		["2431-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2431-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2431-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2431-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2432" : helpers.makeTestYear("Asia/Amman", [
		["2432-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2432-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2432-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2432-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2433" : helpers.makeTestYear("Asia/Amman", [
		["2433-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2433-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2433-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2433-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2434" : helpers.makeTestYear("Asia/Amman", [
		["2434-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2434-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2434-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2434-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2435" : helpers.makeTestYear("Asia/Amman", [
		["2435-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2435-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2435-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2435-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2436" : helpers.makeTestYear("Asia/Amman", [
		["2436-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2436-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2436-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2436-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2437" : helpers.makeTestYear("Asia/Amman", [
		["2437-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2437-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2437-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2437-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2438" : helpers.makeTestYear("Asia/Amman", [
		["2438-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2438-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2438-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2438-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2439" : helpers.makeTestYear("Asia/Amman", [
		["2439-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2439-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2439-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2439-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2440" : helpers.makeTestYear("Asia/Amman", [
		["2440-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2440-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2440-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2440-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2441" : helpers.makeTestYear("Asia/Amman", [
		["2441-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2441-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2441-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2441-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2442" : helpers.makeTestYear("Asia/Amman", [
		["2442-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2442-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2442-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2442-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2443" : helpers.makeTestYear("Asia/Amman", [
		["2443-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2443-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2443-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2443-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2444" : helpers.makeTestYear("Asia/Amman", [
		["2444-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2444-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2444-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2444-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2445" : helpers.makeTestYear("Asia/Amman", [
		["2445-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2445-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2445-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2445-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2446" : helpers.makeTestYear("Asia/Amman", [
		["2446-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2446-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2446-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2446-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2447" : helpers.makeTestYear("Asia/Amman", [
		["2447-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2447-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2447-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2447-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2448" : helpers.makeTestYear("Asia/Amman", [
		["2448-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2448-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2448-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2448-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2449" : helpers.makeTestYear("Asia/Amman", [
		["2449-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2449-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2449-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2449-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2450" : helpers.makeTestYear("Asia/Amman", [
		["2450-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2450-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2450-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2450-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2451" : helpers.makeTestYear("Asia/Amman", [
		["2451-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2451-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2451-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2451-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2452" : helpers.makeTestYear("Asia/Amman", [
		["2452-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2452-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2452-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2452-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2453" : helpers.makeTestYear("Asia/Amman", [
		["2453-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2453-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2453-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2453-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2454" : helpers.makeTestYear("Asia/Amman", [
		["2454-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2454-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2454-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2454-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2455" : helpers.makeTestYear("Asia/Amman", [
		["2455-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2455-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2455-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2455-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2456" : helpers.makeTestYear("Asia/Amman", [
		["2456-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2456-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2456-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2456-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2457" : helpers.makeTestYear("Asia/Amman", [
		["2457-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2457-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2457-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2457-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2458" : helpers.makeTestYear("Asia/Amman", [
		["2458-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2458-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2458-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2458-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2459" : helpers.makeTestYear("Asia/Amman", [
		["2459-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2459-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2459-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2459-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2460" : helpers.makeTestYear("Asia/Amman", [
		["2460-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2460-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2460-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2460-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2461" : helpers.makeTestYear("Asia/Amman", [
		["2461-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2461-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2461-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2461-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2462" : helpers.makeTestYear("Asia/Amman", [
		["2462-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2462-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2462-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2462-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2463" : helpers.makeTestYear("Asia/Amman", [
		["2463-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2463-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2463-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2463-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2464" : helpers.makeTestYear("Asia/Amman", [
		["2464-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2464-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2464-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2464-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2465" : helpers.makeTestYear("Asia/Amman", [
		["2465-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2465-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2465-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2465-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2466" : helpers.makeTestYear("Asia/Amman", [
		["2466-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2466-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2466-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2466-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2467" : helpers.makeTestYear("Asia/Amman", [
		["2467-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2467-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2467-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2467-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2468" : helpers.makeTestYear("Asia/Amman", [
		["2468-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2468-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2468-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2468-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2469" : helpers.makeTestYear("Asia/Amman", [
		["2469-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2469-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2469-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2469-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2470" : helpers.makeTestYear("Asia/Amman", [
		["2470-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2470-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2470-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2470-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2471" : helpers.makeTestYear("Asia/Amman", [
		["2471-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2471-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2471-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2471-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2472" : helpers.makeTestYear("Asia/Amman", [
		["2472-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2472-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2472-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2472-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2473" : helpers.makeTestYear("Asia/Amman", [
		["2473-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2473-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2473-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2473-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2474" : helpers.makeTestYear("Asia/Amman", [
		["2474-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2474-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2474-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2474-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2475" : helpers.makeTestYear("Asia/Amman", [
		["2475-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2475-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2475-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2475-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2476" : helpers.makeTestYear("Asia/Amman", [
		["2476-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2476-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2476-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2476-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2477" : helpers.makeTestYear("Asia/Amman", [
		["2477-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2477-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2477-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2477-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2478" : helpers.makeTestYear("Asia/Amman", [
		["2478-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2478-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2478-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2478-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2479" : helpers.makeTestYear("Asia/Amman", [
		["2479-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2479-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2479-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2479-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2480" : helpers.makeTestYear("Asia/Amman", [
		["2480-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2480-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2480-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2480-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2481" : helpers.makeTestYear("Asia/Amman", [
		["2481-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2481-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2481-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2481-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2482" : helpers.makeTestYear("Asia/Amman", [
		["2482-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2482-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2482-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2482-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2483" : helpers.makeTestYear("Asia/Amman", [
		["2483-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2483-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2483-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2483-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2484" : helpers.makeTestYear("Asia/Amman", [
		["2484-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2484-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2484-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2484-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2485" : helpers.makeTestYear("Asia/Amman", [
		["2485-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2485-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2485-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2485-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2486" : helpers.makeTestYear("Asia/Amman", [
		["2486-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2486-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2486-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2486-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2487" : helpers.makeTestYear("Asia/Amman", [
		["2487-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2487-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2487-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2487-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2488" : helpers.makeTestYear("Asia/Amman", [
		["2488-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2488-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2488-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2488-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2489" : helpers.makeTestYear("Asia/Amman", [
		["2489-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2489-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2489-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2489-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2490" : helpers.makeTestYear("Asia/Amman", [
		["2490-03-30T21:59:59+00:00", "23:59:59", "EET", -120],
		["2490-03-30T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2490-10-26T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2490-10-26T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2491" : helpers.makeTestYear("Asia/Amman", [
		["2491-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2491-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2491-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2491-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2492" : helpers.makeTestYear("Asia/Amman", [
		["2492-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2492-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2492-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2492-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2493" : helpers.makeTestYear("Asia/Amman", [
		["2493-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2493-03-26T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2493-10-29T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2493-10-29T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2494" : helpers.makeTestYear("Asia/Amman", [
		["2494-03-25T21:59:59+00:00", "23:59:59", "EET", -120],
		["2494-03-25T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2494-10-28T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2494-10-28T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2495" : helpers.makeTestYear("Asia/Amman", [
		["2495-03-31T21:59:59+00:00", "23:59:59", "EET", -120],
		["2495-03-31T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2495-10-27T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2495-10-27T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2496" : helpers.makeTestYear("Asia/Amman", [
		["2496-03-29T21:59:59+00:00", "23:59:59", "EET", -120],
		["2496-03-29T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2496-10-25T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2496-10-25T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2497" : helpers.makeTestYear("Asia/Amman", [
		["2497-03-28T21:59:59+00:00", "23:59:59", "EET", -120],
		["2497-03-28T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2497-10-24T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2497-10-24T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2498" : helpers.makeTestYear("Asia/Amman", [
		["2498-03-27T21:59:59+00:00", "23:59:59", "EET", -120],
		["2498-03-27T22:00:00+00:00", "01:00:00", "EEST", -180],
		["2498-10-30T21:59:59+00:00", "00:59:59", "EEST", -180],
		["2498-10-30T22:00:00+00:00", "00:00:00", "EET", -120]
	]),

	"2499" : helpers.makeTestYear("Asia/Amman", [
		["2499-03-26T21:59:59+00:00", "23:59:59", "EET", -120],
		["2499-03-26T22:00:00+00:00", "01:00:00", "EEST", -180]
	])
};