"use strict";

var helpers = require("../../helpers/helpers");

exports["Pacific/Chatham"] = {

	"guess:by:offset" : helpers.makeTestGuess("Pacific/Chatham", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Pacific/Chatham", { abbr: true }),

	"1868" : helpers.makeTestYear("Pacific/Chatham", [
		["1868-11-01T11:46:12+00:00", "00:01:12", "+1215", -735]
	]),

	"1945" : helpers.makeTestYear("Pacific/Chatham", [
		["1945-12-31T11:44:59+00:00", "23:59:59", "+1215", -735],
		["1945-12-31T11:45:00+00:00", "00:30:00", "+1245", -765]
	]),

	"1974" : helpers.makeTestYear("Pacific/Chatham", [
		["1974-11-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1974-11-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1975" : helpers.makeTestYear("Pacific/Chatham", [
		["1975-02-22T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1975-02-22T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1975-10-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1975-10-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1976" : helpers.makeTestYear("Pacific/Chatham", [
		["1976-03-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1976-03-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1976-10-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1976-10-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1977" : helpers.makeTestYear("Pacific/Chatham", [
		["1977-03-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1977-03-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1977-10-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1977-10-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1978" : helpers.makeTestYear("Pacific/Chatham", [
		["1978-03-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1978-03-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1978-10-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1978-10-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1979" : helpers.makeTestYear("Pacific/Chatham", [
		["1979-03-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1979-03-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1979-10-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1979-10-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1980" : helpers.makeTestYear("Pacific/Chatham", [
		["1980-03-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1980-03-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1980-10-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1980-10-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1981" : helpers.makeTestYear("Pacific/Chatham", [
		["1981-02-28T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1981-02-28T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1981-10-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1981-10-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1982" : helpers.makeTestYear("Pacific/Chatham", [
		["1982-03-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1982-03-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1982-10-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1982-10-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1983" : helpers.makeTestYear("Pacific/Chatham", [
		["1983-03-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1983-03-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1983-10-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1983-10-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1984" : helpers.makeTestYear("Pacific/Chatham", [
		["1984-03-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1984-03-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1984-10-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1984-10-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1985" : helpers.makeTestYear("Pacific/Chatham", [
		["1985-03-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1985-03-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1985-10-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1985-10-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1986" : helpers.makeTestYear("Pacific/Chatham", [
		["1986-03-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1986-03-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1986-10-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1986-10-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1987" : helpers.makeTestYear("Pacific/Chatham", [
		["1987-02-28T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1987-02-28T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1987-10-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1987-10-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1988" : helpers.makeTestYear("Pacific/Chatham", [
		["1988-03-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1988-03-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1988-10-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1988-10-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1989" : helpers.makeTestYear("Pacific/Chatham", [
		["1989-03-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1989-03-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1989-10-07T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1989-10-07T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1990" : helpers.makeTestYear("Pacific/Chatham", [
		["1990-03-17T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1990-03-17T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1990-10-06T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1990-10-06T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1991" : helpers.makeTestYear("Pacific/Chatham", [
		["1991-03-16T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1991-03-16T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1991-10-05T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1991-10-05T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1992" : helpers.makeTestYear("Pacific/Chatham", [
		["1992-03-14T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1992-03-14T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1992-10-03T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1992-10-03T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1993" : helpers.makeTestYear("Pacific/Chatham", [
		["1993-03-20T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1993-03-20T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1993-10-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1993-10-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1994" : helpers.makeTestYear("Pacific/Chatham", [
		["1994-03-19T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1994-03-19T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1994-10-01T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1994-10-01T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1995" : helpers.makeTestYear("Pacific/Chatham", [
		["1995-03-18T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1995-03-18T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1995-09-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1995-09-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1996" : helpers.makeTestYear("Pacific/Chatham", [
		["1996-03-16T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1996-03-16T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1996-10-05T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1996-10-05T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1997" : helpers.makeTestYear("Pacific/Chatham", [
		["1997-03-15T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1997-03-15T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1997-10-04T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1997-10-04T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1998" : helpers.makeTestYear("Pacific/Chatham", [
		["1998-03-14T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1998-03-14T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1998-10-03T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1998-10-03T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1999" : helpers.makeTestYear("Pacific/Chatham", [
		["1999-03-20T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1999-03-20T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1999-10-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1999-10-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2000" : helpers.makeTestYear("Pacific/Chatham", [
		["2000-03-18T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2000-03-18T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2000-09-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2000-09-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2001" : helpers.makeTestYear("Pacific/Chatham", [
		["2001-03-17T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2001-03-17T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2001-10-06T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2001-10-06T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2002" : helpers.makeTestYear("Pacific/Chatham", [
		["2002-03-16T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2002-03-16T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2002-10-05T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2002-10-05T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2003" : helpers.makeTestYear("Pacific/Chatham", [
		["2003-03-15T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2003-03-15T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2003-10-04T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2003-10-04T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2004" : helpers.makeTestYear("Pacific/Chatham", [
		["2004-03-20T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2004-03-20T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2004-10-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2004-10-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2005" : helpers.makeTestYear("Pacific/Chatham", [
		["2005-03-19T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2005-03-19T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2005-10-01T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2005-10-01T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2006" : helpers.makeTestYear("Pacific/Chatham", [
		["2006-03-18T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2006-03-18T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2006-09-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2006-09-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2007" : helpers.makeTestYear("Pacific/Chatham", [
		["2007-03-17T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2007-03-17T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2007-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2007-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2008" : helpers.makeTestYear("Pacific/Chatham", [
		["2008-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2008-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2008-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2008-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2009" : helpers.makeTestYear("Pacific/Chatham", [
		["2009-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2009-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2009-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2009-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2010" : helpers.makeTestYear("Pacific/Chatham", [
		["2010-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2010-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2010-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2010-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2011" : helpers.makeTestYear("Pacific/Chatham", [
		["2011-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2011-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2011-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2011-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2012" : helpers.makeTestYear("Pacific/Chatham", [
		["2012-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2012-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2012-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2012-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2013" : helpers.makeTestYear("Pacific/Chatham", [
		["2013-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2013-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2013-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2013-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2014" : helpers.makeTestYear("Pacific/Chatham", [
		["2014-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2014-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2014-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2014-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2015" : helpers.makeTestYear("Pacific/Chatham", [
		["2015-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2015-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2015-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2015-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2016" : helpers.makeTestYear("Pacific/Chatham", [
		["2016-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2016-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2016-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2016-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2017" : helpers.makeTestYear("Pacific/Chatham", [
		["2017-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2017-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2017-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2017-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2018" : helpers.makeTestYear("Pacific/Chatham", [
		["2018-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2018-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2018-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2018-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2019" : helpers.makeTestYear("Pacific/Chatham", [
		["2019-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2019-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2019-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2019-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2020" : helpers.makeTestYear("Pacific/Chatham", [
		["2020-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2020-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2020-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2020-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2021" : helpers.makeTestYear("Pacific/Chatham", [
		["2021-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2021-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2021-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2021-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2022" : helpers.makeTestYear("Pacific/Chatham", [
		["2022-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2022-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2022-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2022-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2023" : helpers.makeTestYear("Pacific/Chatham", [
		["2023-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2023-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2023-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2023-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2024" : helpers.makeTestYear("Pacific/Chatham", [
		["2024-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2024-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2024-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2024-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2025" : helpers.makeTestYear("Pacific/Chatham", [
		["2025-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2025-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2025-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2025-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2026" : helpers.makeTestYear("Pacific/Chatham", [
		["2026-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2026-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2026-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2026-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2027" : helpers.makeTestYear("Pacific/Chatham", [
		["2027-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2027-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2027-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2027-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2028" : helpers.makeTestYear("Pacific/Chatham", [
		["2028-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2028-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2028-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2028-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2029" : helpers.makeTestYear("Pacific/Chatham", [
		["2029-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2029-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2029-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2029-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2030" : helpers.makeTestYear("Pacific/Chatham", [
		["2030-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2030-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2030-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2030-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2031" : helpers.makeTestYear("Pacific/Chatham", [
		["2031-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2031-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2031-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2031-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2032" : helpers.makeTestYear("Pacific/Chatham", [
		["2032-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2032-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2032-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2032-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2033" : helpers.makeTestYear("Pacific/Chatham", [
		["2033-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2033-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2033-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2033-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2034" : helpers.makeTestYear("Pacific/Chatham", [
		["2034-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2034-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2034-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2034-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2035" : helpers.makeTestYear("Pacific/Chatham", [
		["2035-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2035-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2035-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2035-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2036" : helpers.makeTestYear("Pacific/Chatham", [
		["2036-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2036-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2036-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2036-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2037" : helpers.makeTestYear("Pacific/Chatham", [
		["2037-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2037-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2037-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2037-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2038" : helpers.makeTestYear("Pacific/Chatham", [
		["2038-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2038-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2038-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2038-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2039" : helpers.makeTestYear("Pacific/Chatham", [
		["2039-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2039-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2039-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2039-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2040" : helpers.makeTestYear("Pacific/Chatham", [
		["2040-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2040-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2040-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2040-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2041" : helpers.makeTestYear("Pacific/Chatham", [
		["2041-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2041-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2041-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2041-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2042" : helpers.makeTestYear("Pacific/Chatham", [
		["2042-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2042-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2042-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2042-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2043" : helpers.makeTestYear("Pacific/Chatham", [
		["2043-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2043-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2043-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2043-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2044" : helpers.makeTestYear("Pacific/Chatham", [
		["2044-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2044-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2044-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2044-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2045" : helpers.makeTestYear("Pacific/Chatham", [
		["2045-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2045-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2045-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2045-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2046" : helpers.makeTestYear("Pacific/Chatham", [
		["2046-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2046-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2046-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2046-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2047" : helpers.makeTestYear("Pacific/Chatham", [
		["2047-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2047-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2047-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2047-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2048" : helpers.makeTestYear("Pacific/Chatham", [
		["2048-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2048-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2048-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2048-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2049" : helpers.makeTestYear("Pacific/Chatham", [
		["2049-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2049-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2049-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2049-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2050" : helpers.makeTestYear("Pacific/Chatham", [
		["2050-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2050-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2050-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2050-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2051" : helpers.makeTestYear("Pacific/Chatham", [
		["2051-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2051-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2051-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2051-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2052" : helpers.makeTestYear("Pacific/Chatham", [
		["2052-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2052-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2052-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2052-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2053" : helpers.makeTestYear("Pacific/Chatham", [
		["2053-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2053-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2053-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2053-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2054" : helpers.makeTestYear("Pacific/Chatham", [
		["2054-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2054-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2054-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2054-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2055" : helpers.makeTestYear("Pacific/Chatham", [
		["2055-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2055-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2055-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2055-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2056" : helpers.makeTestYear("Pacific/Chatham", [
		["2056-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2056-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2056-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2056-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2057" : helpers.makeTestYear("Pacific/Chatham", [
		["2057-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2057-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2057-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2057-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2058" : helpers.makeTestYear("Pacific/Chatham", [
		["2058-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2058-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2058-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2058-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2059" : helpers.makeTestYear("Pacific/Chatham", [
		["2059-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2059-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2059-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2059-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2060" : helpers.makeTestYear("Pacific/Chatham", [
		["2060-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2060-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2060-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2060-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2061" : helpers.makeTestYear("Pacific/Chatham", [
		["2061-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2061-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2061-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2061-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2062" : helpers.makeTestYear("Pacific/Chatham", [
		["2062-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2062-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2062-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2062-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2063" : helpers.makeTestYear("Pacific/Chatham", [
		["2063-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2063-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2063-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2063-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2064" : helpers.makeTestYear("Pacific/Chatham", [
		["2064-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2064-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2064-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2064-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2065" : helpers.makeTestYear("Pacific/Chatham", [
		["2065-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2065-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2065-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2065-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2066" : helpers.makeTestYear("Pacific/Chatham", [
		["2066-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2066-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2066-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2066-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2067" : helpers.makeTestYear("Pacific/Chatham", [
		["2067-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2067-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2067-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2067-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2068" : helpers.makeTestYear("Pacific/Chatham", [
		["2068-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2068-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2068-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2068-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2069" : helpers.makeTestYear("Pacific/Chatham", [
		["2069-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2069-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2069-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2069-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2070" : helpers.makeTestYear("Pacific/Chatham", [
		["2070-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2070-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2070-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2070-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2071" : helpers.makeTestYear("Pacific/Chatham", [
		["2071-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2071-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2071-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2071-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2072" : helpers.makeTestYear("Pacific/Chatham", [
		["2072-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2072-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2072-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2072-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2073" : helpers.makeTestYear("Pacific/Chatham", [
		["2073-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2073-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2073-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2073-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2074" : helpers.makeTestYear("Pacific/Chatham", [
		["2074-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2074-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2074-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2074-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2075" : helpers.makeTestYear("Pacific/Chatham", [
		["2075-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2075-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2075-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2075-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2076" : helpers.makeTestYear("Pacific/Chatham", [
		["2076-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2076-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2076-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2076-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2077" : helpers.makeTestYear("Pacific/Chatham", [
		["2077-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2077-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2077-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2077-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2078" : helpers.makeTestYear("Pacific/Chatham", [
		["2078-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2078-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2078-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2078-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2079" : helpers.makeTestYear("Pacific/Chatham", [
		["2079-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2079-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2079-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2079-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2080" : helpers.makeTestYear("Pacific/Chatham", [
		["2080-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2080-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2080-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2080-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2081" : helpers.makeTestYear("Pacific/Chatham", [
		["2081-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2081-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2081-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2081-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2082" : helpers.makeTestYear("Pacific/Chatham", [
		["2082-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2082-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2082-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2082-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2083" : helpers.makeTestYear("Pacific/Chatham", [
		["2083-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2083-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2083-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2083-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2084" : helpers.makeTestYear("Pacific/Chatham", [
		["2084-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2084-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2084-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2084-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2085" : helpers.makeTestYear("Pacific/Chatham", [
		["2085-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2085-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2085-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2085-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2086" : helpers.makeTestYear("Pacific/Chatham", [
		["2086-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2086-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2086-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2086-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2087" : helpers.makeTestYear("Pacific/Chatham", [
		["2087-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2087-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2087-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2087-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2088" : helpers.makeTestYear("Pacific/Chatham", [
		["2088-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2088-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2088-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2088-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2089" : helpers.makeTestYear("Pacific/Chatham", [
		["2089-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2089-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2089-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2089-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2090" : helpers.makeTestYear("Pacific/Chatham", [
		["2090-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2090-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2090-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2090-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2091" : helpers.makeTestYear("Pacific/Chatham", [
		["2091-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2091-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2091-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2091-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2092" : helpers.makeTestYear("Pacific/Chatham", [
		["2092-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2092-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2092-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2092-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2093" : helpers.makeTestYear("Pacific/Chatham", [
		["2093-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2093-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2093-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2093-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2094" : helpers.makeTestYear("Pacific/Chatham", [
		["2094-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2094-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2094-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2094-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2095" : helpers.makeTestYear("Pacific/Chatham", [
		["2095-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2095-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2095-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2095-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2096" : helpers.makeTestYear("Pacific/Chatham", [
		["2096-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2096-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2096-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2096-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2097" : helpers.makeTestYear("Pacific/Chatham", [
		["2097-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2097-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2097-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2097-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2098" : helpers.makeTestYear("Pacific/Chatham", [
		["2098-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2098-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2098-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2098-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2099" : helpers.makeTestYear("Pacific/Chatham", [
		["2099-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2099-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2099-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2099-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2100" : helpers.makeTestYear("Pacific/Chatham", [
		["2100-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2100-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2100-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2100-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2101" : helpers.makeTestYear("Pacific/Chatham", [
		["2101-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2101-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2101-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2101-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2102" : helpers.makeTestYear("Pacific/Chatham", [
		["2102-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2102-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2102-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2102-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2103" : helpers.makeTestYear("Pacific/Chatham", [
		["2103-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2103-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2103-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2103-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2104" : helpers.makeTestYear("Pacific/Chatham", [
		["2104-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2104-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2104-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2104-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2105" : helpers.makeTestYear("Pacific/Chatham", [
		["2105-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2105-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2105-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2105-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2106" : helpers.makeTestYear("Pacific/Chatham", [
		["2106-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2106-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2106-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2106-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2107" : helpers.makeTestYear("Pacific/Chatham", [
		["2107-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2107-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2107-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2107-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2108" : helpers.makeTestYear("Pacific/Chatham", [
		["2108-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2108-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2108-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2108-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2109" : helpers.makeTestYear("Pacific/Chatham", [
		["2109-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2109-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2109-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2109-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2110" : helpers.makeTestYear("Pacific/Chatham", [
		["2110-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2110-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2110-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2110-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2111" : helpers.makeTestYear("Pacific/Chatham", [
		["2111-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2111-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2111-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2111-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2112" : helpers.makeTestYear("Pacific/Chatham", [
		["2112-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2112-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2112-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2112-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2113" : helpers.makeTestYear("Pacific/Chatham", [
		["2113-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2113-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2113-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2113-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2114" : helpers.makeTestYear("Pacific/Chatham", [
		["2114-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2114-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2114-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2114-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2115" : helpers.makeTestYear("Pacific/Chatham", [
		["2115-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2115-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2115-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2115-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2116" : helpers.makeTestYear("Pacific/Chatham", [
		["2116-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2116-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2116-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2116-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2117" : helpers.makeTestYear("Pacific/Chatham", [
		["2117-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2117-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2117-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2117-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2118" : helpers.makeTestYear("Pacific/Chatham", [
		["2118-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2118-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2118-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2118-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2119" : helpers.makeTestYear("Pacific/Chatham", [
		["2119-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2119-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2119-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2119-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2120" : helpers.makeTestYear("Pacific/Chatham", [
		["2120-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2120-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2120-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2120-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2121" : helpers.makeTestYear("Pacific/Chatham", [
		["2121-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2121-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2121-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2121-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2122" : helpers.makeTestYear("Pacific/Chatham", [
		["2122-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2122-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2122-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2122-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2123" : helpers.makeTestYear("Pacific/Chatham", [
		["2123-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2123-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2123-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2123-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2124" : helpers.makeTestYear("Pacific/Chatham", [
		["2124-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2124-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2124-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2124-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2125" : helpers.makeTestYear("Pacific/Chatham", [
		["2125-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2125-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2125-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2125-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2126" : helpers.makeTestYear("Pacific/Chatham", [
		["2126-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2126-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2126-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2126-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2127" : helpers.makeTestYear("Pacific/Chatham", [
		["2127-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2127-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2127-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2127-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2128" : helpers.makeTestYear("Pacific/Chatham", [
		["2128-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2128-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2128-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2128-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2129" : helpers.makeTestYear("Pacific/Chatham", [
		["2129-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2129-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2129-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2129-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2130" : helpers.makeTestYear("Pacific/Chatham", [
		["2130-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2130-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2130-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2130-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2131" : helpers.makeTestYear("Pacific/Chatham", [
		["2131-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2131-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2131-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2131-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2132" : helpers.makeTestYear("Pacific/Chatham", [
		["2132-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2132-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2132-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2132-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2133" : helpers.makeTestYear("Pacific/Chatham", [
		["2133-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2133-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2133-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2133-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2134" : helpers.makeTestYear("Pacific/Chatham", [
		["2134-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2134-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2134-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2134-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2135" : helpers.makeTestYear("Pacific/Chatham", [
		["2135-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2135-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2135-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2135-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2136" : helpers.makeTestYear("Pacific/Chatham", [
		["2136-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2136-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2136-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2136-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2137" : helpers.makeTestYear("Pacific/Chatham", [
		["2137-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2137-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2137-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2137-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2138" : helpers.makeTestYear("Pacific/Chatham", [
		["2138-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2138-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2138-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2138-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2139" : helpers.makeTestYear("Pacific/Chatham", [
		["2139-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2139-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2139-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2139-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2140" : helpers.makeTestYear("Pacific/Chatham", [
		["2140-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2140-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2140-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2140-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2141" : helpers.makeTestYear("Pacific/Chatham", [
		["2141-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2141-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2141-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2141-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2142" : helpers.makeTestYear("Pacific/Chatham", [
		["2142-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2142-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2142-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2142-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2143" : helpers.makeTestYear("Pacific/Chatham", [
		["2143-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2143-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2143-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2143-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2144" : helpers.makeTestYear("Pacific/Chatham", [
		["2144-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2144-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2144-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2144-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2145" : helpers.makeTestYear("Pacific/Chatham", [
		["2145-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2145-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2145-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2145-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2146" : helpers.makeTestYear("Pacific/Chatham", [
		["2146-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2146-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2146-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2146-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2147" : helpers.makeTestYear("Pacific/Chatham", [
		["2147-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2147-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2147-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2147-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2148" : helpers.makeTestYear("Pacific/Chatham", [
		["2148-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2148-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2148-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2148-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2149" : helpers.makeTestYear("Pacific/Chatham", [
		["2149-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2149-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2149-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2149-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2150" : helpers.makeTestYear("Pacific/Chatham", [
		["2150-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2150-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2150-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2150-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2151" : helpers.makeTestYear("Pacific/Chatham", [
		["2151-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2151-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2151-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2151-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2152" : helpers.makeTestYear("Pacific/Chatham", [
		["2152-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2152-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2152-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2152-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2153" : helpers.makeTestYear("Pacific/Chatham", [
		["2153-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2153-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2153-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2153-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2154" : helpers.makeTestYear("Pacific/Chatham", [
		["2154-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2154-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2154-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2154-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2155" : helpers.makeTestYear("Pacific/Chatham", [
		["2155-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2155-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2155-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2155-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2156" : helpers.makeTestYear("Pacific/Chatham", [
		["2156-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2156-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2156-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2156-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2157" : helpers.makeTestYear("Pacific/Chatham", [
		["2157-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2157-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2157-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2157-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2158" : helpers.makeTestYear("Pacific/Chatham", [
		["2158-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2158-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2158-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2158-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2159" : helpers.makeTestYear("Pacific/Chatham", [
		["2159-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2159-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2159-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2159-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2160" : helpers.makeTestYear("Pacific/Chatham", [
		["2160-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2160-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2160-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2160-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2161" : helpers.makeTestYear("Pacific/Chatham", [
		["2161-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2161-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2161-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2161-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2162" : helpers.makeTestYear("Pacific/Chatham", [
		["2162-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2162-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2162-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2162-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2163" : helpers.makeTestYear("Pacific/Chatham", [
		["2163-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2163-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2163-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2163-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2164" : helpers.makeTestYear("Pacific/Chatham", [
		["2164-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2164-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2164-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2164-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2165" : helpers.makeTestYear("Pacific/Chatham", [
		["2165-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2165-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2165-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2165-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2166" : helpers.makeTestYear("Pacific/Chatham", [
		["2166-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2166-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2166-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2166-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2167" : helpers.makeTestYear("Pacific/Chatham", [
		["2167-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2167-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2167-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2167-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2168" : helpers.makeTestYear("Pacific/Chatham", [
		["2168-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2168-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2168-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2168-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2169" : helpers.makeTestYear("Pacific/Chatham", [
		["2169-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2169-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2169-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2169-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2170" : helpers.makeTestYear("Pacific/Chatham", [
		["2170-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2170-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2170-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2170-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2171" : helpers.makeTestYear("Pacific/Chatham", [
		["2171-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2171-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2171-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2171-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2172" : helpers.makeTestYear("Pacific/Chatham", [
		["2172-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2172-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2172-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2172-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2173" : helpers.makeTestYear("Pacific/Chatham", [
		["2173-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2173-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2173-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2173-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2174" : helpers.makeTestYear("Pacific/Chatham", [
		["2174-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2174-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2174-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2174-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2175" : helpers.makeTestYear("Pacific/Chatham", [
		["2175-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2175-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2175-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2175-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2176" : helpers.makeTestYear("Pacific/Chatham", [
		["2176-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2176-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2176-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2176-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2177" : helpers.makeTestYear("Pacific/Chatham", [
		["2177-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2177-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2177-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2177-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2178" : helpers.makeTestYear("Pacific/Chatham", [
		["2178-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2178-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2178-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2178-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2179" : helpers.makeTestYear("Pacific/Chatham", [
		["2179-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2179-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2179-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2179-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2180" : helpers.makeTestYear("Pacific/Chatham", [
		["2180-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2180-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2180-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2180-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2181" : helpers.makeTestYear("Pacific/Chatham", [
		["2181-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2181-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2181-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2181-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2182" : helpers.makeTestYear("Pacific/Chatham", [
		["2182-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2182-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2182-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2182-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2183" : helpers.makeTestYear("Pacific/Chatham", [
		["2183-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2183-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2183-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2183-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2184" : helpers.makeTestYear("Pacific/Chatham", [
		["2184-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2184-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2184-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2184-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2185" : helpers.makeTestYear("Pacific/Chatham", [
		["2185-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2185-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2185-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2185-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2186" : helpers.makeTestYear("Pacific/Chatham", [
		["2186-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2186-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2186-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2186-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2187" : helpers.makeTestYear("Pacific/Chatham", [
		["2187-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2187-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2187-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2187-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2188" : helpers.makeTestYear("Pacific/Chatham", [
		["2188-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2188-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2188-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2188-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2189" : helpers.makeTestYear("Pacific/Chatham", [
		["2189-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2189-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2189-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2189-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2190" : helpers.makeTestYear("Pacific/Chatham", [
		["2190-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2190-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2190-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2190-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2191" : helpers.makeTestYear("Pacific/Chatham", [
		["2191-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2191-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2191-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2191-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2192" : helpers.makeTestYear("Pacific/Chatham", [
		["2192-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2192-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2192-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2192-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2193" : helpers.makeTestYear("Pacific/Chatham", [
		["2193-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2193-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2193-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2193-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2194" : helpers.makeTestYear("Pacific/Chatham", [
		["2194-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2194-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2194-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2194-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2195" : helpers.makeTestYear("Pacific/Chatham", [
		["2195-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2195-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2195-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2195-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2196" : helpers.makeTestYear("Pacific/Chatham", [
		["2196-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2196-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2196-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2196-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2197" : helpers.makeTestYear("Pacific/Chatham", [
		["2197-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2197-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2197-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2197-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2198" : helpers.makeTestYear("Pacific/Chatham", [
		["2198-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2198-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2198-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2198-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2199" : helpers.makeTestYear("Pacific/Chatham", [
		["2199-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2199-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2199-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2199-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2200" : helpers.makeTestYear("Pacific/Chatham", [
		["2200-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2200-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2200-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2200-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2201" : helpers.makeTestYear("Pacific/Chatham", [
		["2201-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2201-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2201-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2201-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2202" : helpers.makeTestYear("Pacific/Chatham", [
		["2202-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2202-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2202-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2202-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2203" : helpers.makeTestYear("Pacific/Chatham", [
		["2203-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2203-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2203-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2203-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2204" : helpers.makeTestYear("Pacific/Chatham", [
		["2204-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2204-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2204-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2204-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2205" : helpers.makeTestYear("Pacific/Chatham", [
		["2205-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2205-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2205-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2205-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2206" : helpers.makeTestYear("Pacific/Chatham", [
		["2206-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2206-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2206-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2206-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2207" : helpers.makeTestYear("Pacific/Chatham", [
		["2207-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2207-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2207-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2207-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2208" : helpers.makeTestYear("Pacific/Chatham", [
		["2208-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2208-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2208-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2208-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2209" : helpers.makeTestYear("Pacific/Chatham", [
		["2209-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2209-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2209-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2209-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2210" : helpers.makeTestYear("Pacific/Chatham", [
		["2210-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2210-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2210-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2210-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2211" : helpers.makeTestYear("Pacific/Chatham", [
		["2211-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2211-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2211-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2211-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2212" : helpers.makeTestYear("Pacific/Chatham", [
		["2212-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2212-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2212-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2212-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2213" : helpers.makeTestYear("Pacific/Chatham", [
		["2213-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2213-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2213-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2213-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2214" : helpers.makeTestYear("Pacific/Chatham", [
		["2214-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2214-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2214-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2214-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2215" : helpers.makeTestYear("Pacific/Chatham", [
		["2215-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2215-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2215-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2215-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2216" : helpers.makeTestYear("Pacific/Chatham", [
		["2216-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2216-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2216-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2216-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2217" : helpers.makeTestYear("Pacific/Chatham", [
		["2217-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2217-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2217-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2217-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2218" : helpers.makeTestYear("Pacific/Chatham", [
		["2218-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2218-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2218-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2218-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2219" : helpers.makeTestYear("Pacific/Chatham", [
		["2219-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2219-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2219-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2219-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2220" : helpers.makeTestYear("Pacific/Chatham", [
		["2220-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2220-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2220-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2220-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2221" : helpers.makeTestYear("Pacific/Chatham", [
		["2221-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2221-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2221-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2221-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2222" : helpers.makeTestYear("Pacific/Chatham", [
		["2222-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2222-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2222-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2222-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2223" : helpers.makeTestYear("Pacific/Chatham", [
		["2223-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2223-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2223-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2223-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2224" : helpers.makeTestYear("Pacific/Chatham", [
		["2224-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2224-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2224-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2224-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2225" : helpers.makeTestYear("Pacific/Chatham", [
		["2225-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2225-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2225-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2225-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2226" : helpers.makeTestYear("Pacific/Chatham", [
		["2226-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2226-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2226-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2226-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2227" : helpers.makeTestYear("Pacific/Chatham", [
		["2227-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2227-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2227-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2227-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2228" : helpers.makeTestYear("Pacific/Chatham", [
		["2228-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2228-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2228-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2228-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2229" : helpers.makeTestYear("Pacific/Chatham", [
		["2229-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2229-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2229-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2229-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2230" : helpers.makeTestYear("Pacific/Chatham", [
		["2230-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2230-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2230-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2230-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2231" : helpers.makeTestYear("Pacific/Chatham", [
		["2231-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2231-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2231-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2231-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2232" : helpers.makeTestYear("Pacific/Chatham", [
		["2232-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2232-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2232-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2232-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2233" : helpers.makeTestYear("Pacific/Chatham", [
		["2233-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2233-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2233-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2233-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2234" : helpers.makeTestYear("Pacific/Chatham", [
		["2234-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2234-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2234-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2234-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2235" : helpers.makeTestYear("Pacific/Chatham", [
		["2235-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2235-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2235-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2235-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2236" : helpers.makeTestYear("Pacific/Chatham", [
		["2236-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2236-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2236-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2236-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2237" : helpers.makeTestYear("Pacific/Chatham", [
		["2237-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2237-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2237-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2237-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2238" : helpers.makeTestYear("Pacific/Chatham", [
		["2238-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2238-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2238-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2238-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2239" : helpers.makeTestYear("Pacific/Chatham", [
		["2239-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2239-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2239-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2239-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2240" : helpers.makeTestYear("Pacific/Chatham", [
		["2240-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2240-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2240-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2240-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2241" : helpers.makeTestYear("Pacific/Chatham", [
		["2241-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2241-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2241-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2241-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2242" : helpers.makeTestYear("Pacific/Chatham", [
		["2242-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2242-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2242-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2242-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2243" : helpers.makeTestYear("Pacific/Chatham", [
		["2243-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2243-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2243-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2243-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2244" : helpers.makeTestYear("Pacific/Chatham", [
		["2244-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2244-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2244-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2244-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2245" : helpers.makeTestYear("Pacific/Chatham", [
		["2245-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2245-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2245-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2245-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2246" : helpers.makeTestYear("Pacific/Chatham", [
		["2246-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2246-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2246-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2246-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2247" : helpers.makeTestYear("Pacific/Chatham", [
		["2247-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2247-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2247-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2247-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2248" : helpers.makeTestYear("Pacific/Chatham", [
		["2248-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2248-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2248-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2248-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2249" : helpers.makeTestYear("Pacific/Chatham", [
		["2249-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2249-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2249-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2249-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2250" : helpers.makeTestYear("Pacific/Chatham", [
		["2250-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2250-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2250-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2250-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2251" : helpers.makeTestYear("Pacific/Chatham", [
		["2251-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2251-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2251-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2251-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2252" : helpers.makeTestYear("Pacific/Chatham", [
		["2252-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2252-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2252-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2252-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2253" : helpers.makeTestYear("Pacific/Chatham", [
		["2253-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2253-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2253-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2253-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2254" : helpers.makeTestYear("Pacific/Chatham", [
		["2254-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2254-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2254-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2254-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2255" : helpers.makeTestYear("Pacific/Chatham", [
		["2255-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2255-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2255-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2255-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2256" : helpers.makeTestYear("Pacific/Chatham", [
		["2256-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2256-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2256-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2256-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2257" : helpers.makeTestYear("Pacific/Chatham", [
		["2257-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2257-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2257-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2257-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2258" : helpers.makeTestYear("Pacific/Chatham", [
		["2258-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2258-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2258-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2258-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2259" : helpers.makeTestYear("Pacific/Chatham", [
		["2259-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2259-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2259-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2259-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2260" : helpers.makeTestYear("Pacific/Chatham", [
		["2260-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2260-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2260-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2260-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2261" : helpers.makeTestYear("Pacific/Chatham", [
		["2261-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2261-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2261-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2261-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2262" : helpers.makeTestYear("Pacific/Chatham", [
		["2262-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2262-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2262-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2262-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2263" : helpers.makeTestYear("Pacific/Chatham", [
		["2263-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2263-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2263-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2263-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2264" : helpers.makeTestYear("Pacific/Chatham", [
		["2264-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2264-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2264-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2264-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2265" : helpers.makeTestYear("Pacific/Chatham", [
		["2265-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2265-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2265-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2265-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2266" : helpers.makeTestYear("Pacific/Chatham", [
		["2266-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2266-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2266-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2266-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2267" : helpers.makeTestYear("Pacific/Chatham", [
		["2267-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2267-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2267-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2267-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2268" : helpers.makeTestYear("Pacific/Chatham", [
		["2268-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2268-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2268-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2268-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2269" : helpers.makeTestYear("Pacific/Chatham", [
		["2269-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2269-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2269-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2269-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2270" : helpers.makeTestYear("Pacific/Chatham", [
		["2270-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2270-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2270-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2270-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2271" : helpers.makeTestYear("Pacific/Chatham", [
		["2271-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2271-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2271-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2271-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2272" : helpers.makeTestYear("Pacific/Chatham", [
		["2272-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2272-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2272-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2272-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2273" : helpers.makeTestYear("Pacific/Chatham", [
		["2273-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2273-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2273-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2273-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2274" : helpers.makeTestYear("Pacific/Chatham", [
		["2274-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2274-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2274-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2274-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2275" : helpers.makeTestYear("Pacific/Chatham", [
		["2275-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2275-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2275-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2275-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2276" : helpers.makeTestYear("Pacific/Chatham", [
		["2276-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2276-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2276-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2276-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2277" : helpers.makeTestYear("Pacific/Chatham", [
		["2277-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2277-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2277-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2277-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2278" : helpers.makeTestYear("Pacific/Chatham", [
		["2278-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2278-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2278-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2278-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2279" : helpers.makeTestYear("Pacific/Chatham", [
		["2279-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2279-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2279-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2279-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2280" : helpers.makeTestYear("Pacific/Chatham", [
		["2280-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2280-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2280-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2280-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2281" : helpers.makeTestYear("Pacific/Chatham", [
		["2281-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2281-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2281-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2281-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2282" : helpers.makeTestYear("Pacific/Chatham", [
		["2282-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2282-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2282-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2282-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2283" : helpers.makeTestYear("Pacific/Chatham", [
		["2283-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2283-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2283-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2283-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2284" : helpers.makeTestYear("Pacific/Chatham", [
		["2284-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2284-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2284-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2284-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2285" : helpers.makeTestYear("Pacific/Chatham", [
		["2285-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2285-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2285-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2285-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2286" : helpers.makeTestYear("Pacific/Chatham", [
		["2286-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2286-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2286-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2286-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2287" : helpers.makeTestYear("Pacific/Chatham", [
		["2287-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2287-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2287-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2287-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2288" : helpers.makeTestYear("Pacific/Chatham", [
		["2288-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2288-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2288-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2288-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2289" : helpers.makeTestYear("Pacific/Chatham", [
		["2289-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2289-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2289-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2289-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2290" : helpers.makeTestYear("Pacific/Chatham", [
		["2290-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2290-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2290-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2290-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2291" : helpers.makeTestYear("Pacific/Chatham", [
		["2291-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2291-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2291-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2291-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2292" : helpers.makeTestYear("Pacific/Chatham", [
		["2292-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2292-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2292-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2292-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2293" : helpers.makeTestYear("Pacific/Chatham", [
		["2293-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2293-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2293-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2293-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2294" : helpers.makeTestYear("Pacific/Chatham", [
		["2294-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2294-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2294-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2294-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2295" : helpers.makeTestYear("Pacific/Chatham", [
		["2295-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2295-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2295-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2295-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2296" : helpers.makeTestYear("Pacific/Chatham", [
		["2296-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2296-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2296-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2296-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2297" : helpers.makeTestYear("Pacific/Chatham", [
		["2297-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2297-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2297-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2297-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2298" : helpers.makeTestYear("Pacific/Chatham", [
		["2298-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2298-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2298-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2298-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2299" : helpers.makeTestYear("Pacific/Chatham", [
		["2299-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2299-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2299-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2299-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2300" : helpers.makeTestYear("Pacific/Chatham", [
		["2300-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2300-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2300-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2300-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2301" : helpers.makeTestYear("Pacific/Chatham", [
		["2301-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2301-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2301-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2301-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2302" : helpers.makeTestYear("Pacific/Chatham", [
		["2302-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2302-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2302-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2302-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2303" : helpers.makeTestYear("Pacific/Chatham", [
		["2303-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2303-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2303-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2303-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2304" : helpers.makeTestYear("Pacific/Chatham", [
		["2304-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2304-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2304-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2304-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2305" : helpers.makeTestYear("Pacific/Chatham", [
		["2305-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2305-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2305-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2305-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2306" : helpers.makeTestYear("Pacific/Chatham", [
		["2306-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2306-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2306-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2306-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2307" : helpers.makeTestYear("Pacific/Chatham", [
		["2307-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2307-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2307-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2307-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2308" : helpers.makeTestYear("Pacific/Chatham", [
		["2308-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2308-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2308-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2308-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2309" : helpers.makeTestYear("Pacific/Chatham", [
		["2309-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2309-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2309-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2309-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2310" : helpers.makeTestYear("Pacific/Chatham", [
		["2310-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2310-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2310-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2310-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2311" : helpers.makeTestYear("Pacific/Chatham", [
		["2311-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2311-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2311-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2311-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2312" : helpers.makeTestYear("Pacific/Chatham", [
		["2312-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2312-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2312-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2312-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2313" : helpers.makeTestYear("Pacific/Chatham", [
		["2313-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2313-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2313-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2313-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2314" : helpers.makeTestYear("Pacific/Chatham", [
		["2314-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2314-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2314-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2314-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2315" : helpers.makeTestYear("Pacific/Chatham", [
		["2315-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2315-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2315-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2315-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2316" : helpers.makeTestYear("Pacific/Chatham", [
		["2316-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2316-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2316-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2316-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2317" : helpers.makeTestYear("Pacific/Chatham", [
		["2317-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2317-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2317-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2317-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2318" : helpers.makeTestYear("Pacific/Chatham", [
		["2318-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2318-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2318-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2318-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2319" : helpers.makeTestYear("Pacific/Chatham", [
		["2319-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2319-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2319-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2319-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2320" : helpers.makeTestYear("Pacific/Chatham", [
		["2320-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2320-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2320-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2320-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2321" : helpers.makeTestYear("Pacific/Chatham", [
		["2321-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2321-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2321-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2321-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2322" : helpers.makeTestYear("Pacific/Chatham", [
		["2322-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2322-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2322-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2322-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2323" : helpers.makeTestYear("Pacific/Chatham", [
		["2323-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2323-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2323-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2323-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2324" : helpers.makeTestYear("Pacific/Chatham", [
		["2324-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2324-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2324-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2324-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2325" : helpers.makeTestYear("Pacific/Chatham", [
		["2325-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2325-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2325-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2325-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2326" : helpers.makeTestYear("Pacific/Chatham", [
		["2326-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2326-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2326-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2326-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2327" : helpers.makeTestYear("Pacific/Chatham", [
		["2327-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2327-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2327-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2327-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2328" : helpers.makeTestYear("Pacific/Chatham", [
		["2328-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2328-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2328-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2328-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2329" : helpers.makeTestYear("Pacific/Chatham", [
		["2329-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2329-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2329-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2329-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2330" : helpers.makeTestYear("Pacific/Chatham", [
		["2330-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2330-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2330-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2330-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2331" : helpers.makeTestYear("Pacific/Chatham", [
		["2331-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2331-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2331-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2331-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2332" : helpers.makeTestYear("Pacific/Chatham", [
		["2332-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2332-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2332-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2332-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2333" : helpers.makeTestYear("Pacific/Chatham", [
		["2333-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2333-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2333-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2333-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2334" : helpers.makeTestYear("Pacific/Chatham", [
		["2334-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2334-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2334-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2334-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2335" : helpers.makeTestYear("Pacific/Chatham", [
		["2335-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2335-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2335-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2335-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2336" : helpers.makeTestYear("Pacific/Chatham", [
		["2336-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2336-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2336-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2336-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2337" : helpers.makeTestYear("Pacific/Chatham", [
		["2337-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2337-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2337-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2337-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2338" : helpers.makeTestYear("Pacific/Chatham", [
		["2338-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2338-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2338-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2338-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2339" : helpers.makeTestYear("Pacific/Chatham", [
		["2339-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2339-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2339-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2339-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2340" : helpers.makeTestYear("Pacific/Chatham", [
		["2340-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2340-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2340-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2340-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2341" : helpers.makeTestYear("Pacific/Chatham", [
		["2341-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2341-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2341-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2341-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2342" : helpers.makeTestYear("Pacific/Chatham", [
		["2342-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2342-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2342-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2342-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2343" : helpers.makeTestYear("Pacific/Chatham", [
		["2343-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2343-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2343-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2343-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2344" : helpers.makeTestYear("Pacific/Chatham", [
		["2344-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2344-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2344-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2344-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2345" : helpers.makeTestYear("Pacific/Chatham", [
		["2345-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2345-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2345-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2345-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2346" : helpers.makeTestYear("Pacific/Chatham", [
		["2346-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2346-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2346-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2346-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2347" : helpers.makeTestYear("Pacific/Chatham", [
		["2347-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2347-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2347-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2347-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2348" : helpers.makeTestYear("Pacific/Chatham", [
		["2348-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2348-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2348-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2348-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2349" : helpers.makeTestYear("Pacific/Chatham", [
		["2349-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2349-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2349-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2349-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2350" : helpers.makeTestYear("Pacific/Chatham", [
		["2350-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2350-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2350-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2350-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2351" : helpers.makeTestYear("Pacific/Chatham", [
		["2351-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2351-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2351-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2351-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2352" : helpers.makeTestYear("Pacific/Chatham", [
		["2352-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2352-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2352-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2352-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2353" : helpers.makeTestYear("Pacific/Chatham", [
		["2353-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2353-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2353-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2353-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2354" : helpers.makeTestYear("Pacific/Chatham", [
		["2354-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2354-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2354-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2354-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2355" : helpers.makeTestYear("Pacific/Chatham", [
		["2355-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2355-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2355-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2355-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2356" : helpers.makeTestYear("Pacific/Chatham", [
		["2356-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2356-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2356-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2356-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2357" : helpers.makeTestYear("Pacific/Chatham", [
		["2357-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2357-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2357-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2357-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2358" : helpers.makeTestYear("Pacific/Chatham", [
		["2358-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2358-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2358-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2358-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2359" : helpers.makeTestYear("Pacific/Chatham", [
		["2359-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2359-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2359-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2359-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2360" : helpers.makeTestYear("Pacific/Chatham", [
		["2360-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2360-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2360-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2360-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2361" : helpers.makeTestYear("Pacific/Chatham", [
		["2361-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2361-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2361-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2361-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2362" : helpers.makeTestYear("Pacific/Chatham", [
		["2362-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2362-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2362-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2362-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2363" : helpers.makeTestYear("Pacific/Chatham", [
		["2363-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2363-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2363-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2363-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2364" : helpers.makeTestYear("Pacific/Chatham", [
		["2364-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2364-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2364-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2364-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2365" : helpers.makeTestYear("Pacific/Chatham", [
		["2365-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2365-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2365-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2365-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2366" : helpers.makeTestYear("Pacific/Chatham", [
		["2366-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2366-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2366-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2366-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2367" : helpers.makeTestYear("Pacific/Chatham", [
		["2367-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2367-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2367-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2367-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2368" : helpers.makeTestYear("Pacific/Chatham", [
		["2368-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2368-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2368-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2368-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2369" : helpers.makeTestYear("Pacific/Chatham", [
		["2369-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2369-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2369-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2369-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2370" : helpers.makeTestYear("Pacific/Chatham", [
		["2370-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2370-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2370-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2370-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2371" : helpers.makeTestYear("Pacific/Chatham", [
		["2371-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2371-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2371-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2371-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2372" : helpers.makeTestYear("Pacific/Chatham", [
		["2372-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2372-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2372-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2372-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2373" : helpers.makeTestYear("Pacific/Chatham", [
		["2373-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2373-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2373-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2373-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2374" : helpers.makeTestYear("Pacific/Chatham", [
		["2374-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2374-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2374-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2374-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2375" : helpers.makeTestYear("Pacific/Chatham", [
		["2375-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2375-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2375-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2375-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2376" : helpers.makeTestYear("Pacific/Chatham", [
		["2376-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2376-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2376-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2376-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2377" : helpers.makeTestYear("Pacific/Chatham", [
		["2377-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2377-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2377-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2377-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2378" : helpers.makeTestYear("Pacific/Chatham", [
		["2378-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2378-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2378-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2378-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2379" : helpers.makeTestYear("Pacific/Chatham", [
		["2379-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2379-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2379-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2379-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2380" : helpers.makeTestYear("Pacific/Chatham", [
		["2380-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2380-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2380-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2380-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2381" : helpers.makeTestYear("Pacific/Chatham", [
		["2381-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2381-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2381-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2381-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2382" : helpers.makeTestYear("Pacific/Chatham", [
		["2382-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2382-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2382-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2382-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2383" : helpers.makeTestYear("Pacific/Chatham", [
		["2383-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2383-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2383-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2383-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2384" : helpers.makeTestYear("Pacific/Chatham", [
		["2384-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2384-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2384-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2384-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2385" : helpers.makeTestYear("Pacific/Chatham", [
		["2385-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2385-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2385-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2385-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2386" : helpers.makeTestYear("Pacific/Chatham", [
		["2386-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2386-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2386-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2386-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2387" : helpers.makeTestYear("Pacific/Chatham", [
		["2387-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2387-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2387-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2387-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2388" : helpers.makeTestYear("Pacific/Chatham", [
		["2388-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2388-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2388-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2388-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2389" : helpers.makeTestYear("Pacific/Chatham", [
		["2389-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2389-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2389-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2389-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2390" : helpers.makeTestYear("Pacific/Chatham", [
		["2390-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2390-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2390-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2390-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2391" : helpers.makeTestYear("Pacific/Chatham", [
		["2391-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2391-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2391-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2391-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2392" : helpers.makeTestYear("Pacific/Chatham", [
		["2392-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2392-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2392-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2392-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2393" : helpers.makeTestYear("Pacific/Chatham", [
		["2393-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2393-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2393-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2393-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2394" : helpers.makeTestYear("Pacific/Chatham", [
		["2394-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2394-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2394-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2394-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2395" : helpers.makeTestYear("Pacific/Chatham", [
		["2395-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2395-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2395-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2395-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2396" : helpers.makeTestYear("Pacific/Chatham", [
		["2396-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2396-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2396-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2396-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2397" : helpers.makeTestYear("Pacific/Chatham", [
		["2397-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2397-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2397-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2397-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2398" : helpers.makeTestYear("Pacific/Chatham", [
		["2398-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2398-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2398-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2398-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2399" : helpers.makeTestYear("Pacific/Chatham", [
		["2399-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2399-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2399-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2399-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2400" : helpers.makeTestYear("Pacific/Chatham", [
		["2400-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2400-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2400-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2400-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2401" : helpers.makeTestYear("Pacific/Chatham", [
		["2401-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2401-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2401-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2401-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2402" : helpers.makeTestYear("Pacific/Chatham", [
		["2402-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2402-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2402-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2402-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2403" : helpers.makeTestYear("Pacific/Chatham", [
		["2403-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2403-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2403-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2403-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2404" : helpers.makeTestYear("Pacific/Chatham", [
		["2404-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2404-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2404-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2404-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2405" : helpers.makeTestYear("Pacific/Chatham", [
		["2405-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2405-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2405-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2405-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2406" : helpers.makeTestYear("Pacific/Chatham", [
		["2406-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2406-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2406-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2406-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2407" : helpers.makeTestYear("Pacific/Chatham", [
		["2407-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2407-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2407-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2407-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2408" : helpers.makeTestYear("Pacific/Chatham", [
		["2408-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2408-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2408-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2408-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2409" : helpers.makeTestYear("Pacific/Chatham", [
		["2409-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2409-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2409-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2409-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2410" : helpers.makeTestYear("Pacific/Chatham", [
		["2410-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2410-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2410-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2410-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2411" : helpers.makeTestYear("Pacific/Chatham", [
		["2411-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2411-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2411-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2411-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2412" : helpers.makeTestYear("Pacific/Chatham", [
		["2412-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2412-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2412-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2412-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2413" : helpers.makeTestYear("Pacific/Chatham", [
		["2413-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2413-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2413-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2413-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2414" : helpers.makeTestYear("Pacific/Chatham", [
		["2414-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2414-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2414-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2414-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2415" : helpers.makeTestYear("Pacific/Chatham", [
		["2415-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2415-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2415-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2415-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2416" : helpers.makeTestYear("Pacific/Chatham", [
		["2416-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2416-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2416-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2416-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2417" : helpers.makeTestYear("Pacific/Chatham", [
		["2417-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2417-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2417-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2417-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2418" : helpers.makeTestYear("Pacific/Chatham", [
		["2418-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2418-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2418-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2418-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2419" : helpers.makeTestYear("Pacific/Chatham", [
		["2419-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2419-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2419-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2419-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2420" : helpers.makeTestYear("Pacific/Chatham", [
		["2420-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2420-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2420-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2420-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2421" : helpers.makeTestYear("Pacific/Chatham", [
		["2421-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2421-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2421-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2421-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2422" : helpers.makeTestYear("Pacific/Chatham", [
		["2422-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2422-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2422-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2422-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2423" : helpers.makeTestYear("Pacific/Chatham", [
		["2423-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2423-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2423-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2423-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2424" : helpers.makeTestYear("Pacific/Chatham", [
		["2424-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2424-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2424-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2424-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2425" : helpers.makeTestYear("Pacific/Chatham", [
		["2425-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2425-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2425-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2425-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2426" : helpers.makeTestYear("Pacific/Chatham", [
		["2426-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2426-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2426-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2426-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2427" : helpers.makeTestYear("Pacific/Chatham", [
		["2427-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2427-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2427-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2427-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2428" : helpers.makeTestYear("Pacific/Chatham", [
		["2428-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2428-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2428-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2428-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2429" : helpers.makeTestYear("Pacific/Chatham", [
		["2429-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2429-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2429-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2429-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2430" : helpers.makeTestYear("Pacific/Chatham", [
		["2430-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2430-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2430-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2430-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2431" : helpers.makeTestYear("Pacific/Chatham", [
		["2431-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2431-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2431-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2431-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2432" : helpers.makeTestYear("Pacific/Chatham", [
		["2432-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2432-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2432-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2432-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2433" : helpers.makeTestYear("Pacific/Chatham", [
		["2433-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2433-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2433-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2433-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2434" : helpers.makeTestYear("Pacific/Chatham", [
		["2434-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2434-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2434-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2434-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2435" : helpers.makeTestYear("Pacific/Chatham", [
		["2435-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2435-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2435-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2435-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2436" : helpers.makeTestYear("Pacific/Chatham", [
		["2436-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2436-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2436-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2436-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2437" : helpers.makeTestYear("Pacific/Chatham", [
		["2437-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2437-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2437-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2437-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2438" : helpers.makeTestYear("Pacific/Chatham", [
		["2438-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2438-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2438-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2438-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2439" : helpers.makeTestYear("Pacific/Chatham", [
		["2439-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2439-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2439-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2439-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2440" : helpers.makeTestYear("Pacific/Chatham", [
		["2440-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2440-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2440-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2440-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2441" : helpers.makeTestYear("Pacific/Chatham", [
		["2441-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2441-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2441-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2441-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2442" : helpers.makeTestYear("Pacific/Chatham", [
		["2442-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2442-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2442-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2442-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2443" : helpers.makeTestYear("Pacific/Chatham", [
		["2443-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2443-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2443-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2443-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2444" : helpers.makeTestYear("Pacific/Chatham", [
		["2444-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2444-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2444-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2444-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2445" : helpers.makeTestYear("Pacific/Chatham", [
		["2445-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2445-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2445-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2445-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2446" : helpers.makeTestYear("Pacific/Chatham", [
		["2446-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2446-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2446-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2446-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2447" : helpers.makeTestYear("Pacific/Chatham", [
		["2447-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2447-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2447-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2447-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2448" : helpers.makeTestYear("Pacific/Chatham", [
		["2448-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2448-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2448-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2448-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2449" : helpers.makeTestYear("Pacific/Chatham", [
		["2449-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2449-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2449-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2449-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2450" : helpers.makeTestYear("Pacific/Chatham", [
		["2450-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2450-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2450-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2450-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2451" : helpers.makeTestYear("Pacific/Chatham", [
		["2451-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2451-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2451-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2451-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2452" : helpers.makeTestYear("Pacific/Chatham", [
		["2452-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2452-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2452-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2452-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2453" : helpers.makeTestYear("Pacific/Chatham", [
		["2453-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2453-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2453-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2453-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2454" : helpers.makeTestYear("Pacific/Chatham", [
		["2454-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2454-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2454-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2454-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2455" : helpers.makeTestYear("Pacific/Chatham", [
		["2455-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2455-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2455-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2455-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2456" : helpers.makeTestYear("Pacific/Chatham", [
		["2456-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2456-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2456-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2456-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2457" : helpers.makeTestYear("Pacific/Chatham", [
		["2457-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2457-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2457-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2457-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2458" : helpers.makeTestYear("Pacific/Chatham", [
		["2458-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2458-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2458-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2458-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2459" : helpers.makeTestYear("Pacific/Chatham", [
		["2459-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2459-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2459-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2459-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2460" : helpers.makeTestYear("Pacific/Chatham", [
		["2460-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2460-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2460-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2460-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2461" : helpers.makeTestYear("Pacific/Chatham", [
		["2461-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2461-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2461-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2461-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2462" : helpers.makeTestYear("Pacific/Chatham", [
		["2462-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2462-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2462-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2462-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2463" : helpers.makeTestYear("Pacific/Chatham", [
		["2463-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2463-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2463-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2463-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2464" : helpers.makeTestYear("Pacific/Chatham", [
		["2464-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2464-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2464-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2464-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2465" : helpers.makeTestYear("Pacific/Chatham", [
		["2465-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2465-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2465-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2465-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2466" : helpers.makeTestYear("Pacific/Chatham", [
		["2466-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2466-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2466-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2466-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2467" : helpers.makeTestYear("Pacific/Chatham", [
		["2467-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2467-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2467-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2467-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2468" : helpers.makeTestYear("Pacific/Chatham", [
		["2468-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2468-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2468-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2468-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2469" : helpers.makeTestYear("Pacific/Chatham", [
		["2469-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2469-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2469-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2469-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2470" : helpers.makeTestYear("Pacific/Chatham", [
		["2470-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2470-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2470-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2470-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2471" : helpers.makeTestYear("Pacific/Chatham", [
		["2471-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2471-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2471-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2471-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2472" : helpers.makeTestYear("Pacific/Chatham", [
		["2472-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2472-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2472-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2472-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2473" : helpers.makeTestYear("Pacific/Chatham", [
		["2473-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2473-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2473-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2473-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2474" : helpers.makeTestYear("Pacific/Chatham", [
		["2474-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2474-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2474-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2474-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2475" : helpers.makeTestYear("Pacific/Chatham", [
		["2475-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2475-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2475-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2475-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2476" : helpers.makeTestYear("Pacific/Chatham", [
		["2476-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2476-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2476-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2476-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2477" : helpers.makeTestYear("Pacific/Chatham", [
		["2477-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2477-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2477-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2477-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2478" : helpers.makeTestYear("Pacific/Chatham", [
		["2478-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2478-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2478-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2478-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2479" : helpers.makeTestYear("Pacific/Chatham", [
		["2479-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2479-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2479-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2479-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2480" : helpers.makeTestYear("Pacific/Chatham", [
		["2480-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2480-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2480-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2480-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2481" : helpers.makeTestYear("Pacific/Chatham", [
		["2481-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2481-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2481-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2481-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2482" : helpers.makeTestYear("Pacific/Chatham", [
		["2482-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2482-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2482-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2482-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2483" : helpers.makeTestYear("Pacific/Chatham", [
		["2483-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2483-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2483-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2483-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2484" : helpers.makeTestYear("Pacific/Chatham", [
		["2484-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2484-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2484-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2484-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2485" : helpers.makeTestYear("Pacific/Chatham", [
		["2485-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2485-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2485-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2485-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2486" : helpers.makeTestYear("Pacific/Chatham", [
		["2486-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2486-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2486-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2486-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2487" : helpers.makeTestYear("Pacific/Chatham", [
		["2487-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2487-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2487-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2487-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2488" : helpers.makeTestYear("Pacific/Chatham", [
		["2488-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2488-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2488-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2488-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2489" : helpers.makeTestYear("Pacific/Chatham", [
		["2489-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2489-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2489-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2489-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2490" : helpers.makeTestYear("Pacific/Chatham", [
		["2490-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2490-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2490-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2490-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2491" : helpers.makeTestYear("Pacific/Chatham", [
		["2491-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2491-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2491-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2491-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2492" : helpers.makeTestYear("Pacific/Chatham", [
		["2492-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2492-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2492-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2492-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2493" : helpers.makeTestYear("Pacific/Chatham", [
		["2493-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2493-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2493-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2493-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2494" : helpers.makeTestYear("Pacific/Chatham", [
		["2494-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2494-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2494-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2494-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2495" : helpers.makeTestYear("Pacific/Chatham", [
		["2495-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2495-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2495-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2495-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2496" : helpers.makeTestYear("Pacific/Chatham", [
		["2496-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2496-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2496-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2496-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2497" : helpers.makeTestYear("Pacific/Chatham", [
		["2497-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2497-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2497-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2497-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2498" : helpers.makeTestYear("Pacific/Chatham", [
		["2498-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2498-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2498-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2498-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2499" : helpers.makeTestYear("Pacific/Chatham", [
		["2499-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2499-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2499-09-26T13:59:59+00:00", "02:44:59", "+1245", -765]
	])
};