// Copyright 2012 Google, Inc. All rights reserved.

package layers

// Created by gen.go, don't edit manually
// Generated at 2014-09-09 10:09:28.309114133 -0600 MDT
// Fetched from "http://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xml"

// TCPPortNames contains the port names for all TCP ports.
var TCPPortNames = tcpPortNames

// UDPPortNames contains the port names for all UDP ports.
var UDPPortNames = udpPortNames

// SCTPPortNames contains the port names for all SCTP ports.
var SCTPPortNames = sctpPortNames

var tcpPortNames = map[TCPPort]string{
	1:     "tcpmux",
	2:     "compressnet",
	3:     "compressnet",
	5:     "rje",
	7:     "echo",
	9:     "discard",
	11:    "systat",
	13:    "daytime",
	17:    "qotd",
	18:    "msp",
	19:    "chargen",
	20:    "ftp-data",
	21:    "ftp",
	22:    "ssh",
	23:    "telnet",
	25:    "smtp",
	27:    "nsw-fe",
	29:    "msg-icp",
	31:    "msg-auth",
	33:    "dsp",
	37:    "time",
	38:    "rap",
	39:    "rlp",
	41:    "graphics",
	42:    "name",
	43:    "nicname",
	44:    "mpm-flags",
	45:    "mpm",
	46:    "mpm-snd",
	47:    "ni-ftp",
	48:    "auditd",
	49:    "tacacs",
	50:    "re-mail-ck",
	52:    "xns-time",
	53:    "domain",
	54:    "xns-ch",
	55:    "isi-gl",
	56:    "xns-auth",
	58:    "xns-mail",
	61:    "ni-mail",
	62:    "acas",
	63:    "whoispp",
	64:    "covia",
	65:    "tacacs-ds",
	66:    "sql-net",
	67:    "bootps",
	68:    "bootpc",
	69:    "tftp",
	70:    "gopher",
	71:    "netrjs-1",
	72:    "netrjs-2",
	73:    "netrjs-3",
	74:    "netrjs-4",
	76:    "deos",
	78:    "vettcp",
	79:    "finger",
	80:    "http",
	82:    "xfer",
	83:    "mit-ml-dev",
	84:    "ctf",
	85:    "mit-ml-dev",
	86:    "mfcobol",
	88:    "kerberos",
	89:    "su-mit-tg",
	90:    "dnsix",
	91:    "mit-dov",
	92:    "npp",
	93:    "dcp",
	94:    "objcall",
	95:    "supdup",
	96:    "dixie",
	97:    "swift-rvf",
	98:    "tacnews",
	99:    "metagram",
	101:   "hostname",
	102:   "iso-tsap",
	103:   "gppitnp",
	104:   "acr-nema",
	105:   "cso",
	106:   "3com-tsmux",
	107:   "rtelnet",
	108:   "snagas",
	109:   "pop2",
	110:   "pop3",
	111:   "sunrpc",
	112:   "mcidas",
	113:   "ident",
	115:   "sftp",
	116:   "ansanotify",
	117:   "uucp-path",
	118:   "sqlserv",
	119:   "nntp",
	120:   "cfdptkt",
	121:   "erpc",
	122:   "smakynet",
	123:   "ntp",
	124:   "ansatrader",
	125:   "locus-map",
	126:   "nxedit",
	127:   "locus-con",
	128:   "gss-xlicen",
	129:   "pwdgen",
	130:   "cisco-fna",
	131:   "cisco-tna",
	132:   "cisco-sys",
	133:   "statsrv",
	134:   "ingres-net",
	135:   "epmap",
	136:   "profile",
	137:   "netbios-ns",
	138:   "netbios-dgm",
	139:   "netbios-ssn",
	140:   "emfis-data",
	141:   "emfis-cntl",
	142:   "bl-idm",
	143:   "imap",
	144:   "uma",
	145:   "uaac",
	146:   "iso-tp0",
	147:   "iso-ip",
	148:   "jargon",
	149:   "aed-512",
	150:   "sql-net",
	151:   "hems",
	152:   "bftp",
	153:   "sgmp",
	154:   "netsc-prod",
	155:   "netsc-dev",
	156:   "sqlsrv",
	157:   "knet-cmp",
	158:   "pcmail-srv",
	159:   "nss-routing",
	160:   "sgmp-traps",
	161:   "snmp",
	162:   "snmptrap",
	163:   "cmip-man",
	164:   "cmip-agent",
	165:   "xns-courier",
	166:   "s-net",
	167:   "namp",
	168:   "rsvd",
	169:   "send",
	170:   "print-srv",
	171:   "multiplex",
	172:   "cl-1",
	173:   "xyplex-mux",
	174:   "mailq",
	175:   "vmnet",
	176:   "genrad-mux",
	177:   "xdmcp",
	178:   "nextstep",
	179:   "bgp",
	180:   "ris",
	181:   "unify",
	182:   "audit",
	183:   "ocbinder",
	184:   "ocserver",
	185:   "remote-kis",
	186:   "kis",
	187:   "aci",
	188:   "mumps",
	189:   "qft",
	190:   "gacp",
	191:   "prospero",
	192:   "osu-nms",
	193:   "srmp",
	194:   "irc",
	195:   "dn6-nlm-aud",
	196:   "dn6-smm-red",
	197:   "dls",
	198:   "dls-mon",
	199:   "smux",
	200:   "src",
	201:   "at-rtmp",
	202:   "at-nbp",
	203:   "at-3",
	204:   "at-echo",
	205:   "at-5",
	206:   "at-zis",
	207:   "at-7",
	208:   "at-8",
	209:   "qmtp",
	210:   "z39-50",
	211:   "914c-g",
	212:   "anet",
	213:   "ipx",
	214:   "vmpwscs",
	215:   "softpc",
	216:   "CAIlic",
	217:   "dbase",
	218:   "mpp",
	219:   "uarps",
	220:   "imap3",
	221:   "fln-spx",
	222:   "rsh-spx",
	223:   "cdc",
	224:   "masqdialer",
	242:   "direct",
	243:   "sur-meas",
	244:   "inbusiness",
	245:   "link",
	246:   "dsp3270",
	247:   "subntbcst-tftp",
	248:   "bhfhs",
	256:   "rap",
	257:   "set",
	259:   "esro-gen",
	260:   "openport",
	261:   "nsiiops",
	262:   "arcisdms",
	263:   "hdap",
	264:   "bgmp",
	265:   "x-bone-ctl",
	266:   "sst",
	267:   "td-service",
	268:   "td-replica",
	269:   "manet",
	271:   "pt-tls",
	280:   "http-mgmt",
	281:   "personal-link",
	282:   "cableport-ax",
	283:   "rescap",
	284:   "corerjd",
	286:   "fxp",
	287:   "k-block",
	308:   "novastorbakcup",
	309:   "entrusttime",
	310:   "bhmds",
	311:   "asip-webadmin",
	312:   "vslmp",
	313:   "magenta-logic",
	314:   "opalis-robot",
	315:   "dpsi",
	316:   "decauth",
	317:   "zannet",
	318:   "pkix-timestamp",
	319:   "ptp-event",
	320:   "ptp-general",
	321:   "pip",
	322:   "rtsps",
	323:   "rpki-rtr",
	324:   "rpki-rtr-tls",
	333:   "texar",
	344:   "pdap",
	345:   "pawserv",
	346:   "zserv",
	347:   "fatserv",
	348:   "csi-sgwp",
	349:   "mftp",
	350:   "matip-type-a",
	351:   "matip-type-b",
	352:   "dtag-ste-sb",
	353:   "ndsauth",
	354:   "bh611",
	355:   "datex-asn",
	356:   "cloanto-net-1",
	357:   "bhevent",
	358:   "shrinkwrap",
	359:   "nsrmp",
	360:   "scoi2odialog",
	361:   "semantix",
	362:   "srssend",
	363:   "rsvp-tunnel",
	364:   "aurora-cmgr",
	365:   "dtk",
	366:   "odmr",
	367:   "mortgageware",
	368:   "qbikgdp",
	369:   "rpc2portmap",
	370:   "codaauth2",
	371:   "clearcase",
	372:   "ulistproc",
	373:   "legent-1",
	374:   "legent-2",
	375:   "hassle",
	376:   "nip",
	377:   "tnETOS",
	378:   "dsETOS",
	379:   "is99c",
	380:   "is99s",
	381:   "hp-collector",
	382:   "hp-managed-node",
	383:   "hp-alarm-mgr",
	384:   "arns",
	385:   "ibm-app",
	386:   "asa",
	387:   "aurp",
	388:   "unidata-ldm",
	389:   "ldap",
	390:   "uis",
	391:   "synotics-relay",
	392:   "synotics-broker",
	393:   "meta5",
	394:   "embl-ndt",
	395:   "netcp",
	396:   "netware-ip",
	397:   "mptn",
	398:   "kryptolan",
	399:   "iso-tsap-c2",
	400:   "osb-sd",
	401:   "ups",
	402:   "genie",
	403:   "decap",
	404:   "nced",
	405:   "ncld",
	406:   "imsp",
	407:   "timbuktu",
	408:   "prm-sm",
	409:   "prm-nm",
	410:   "decladebug",
	411:   "rmt",
	412:   "synoptics-trap",
	413:   "smsp",
	414:   "infoseek",
	415:   "bnet",
	416:   "silverplatter",
	417:   "onmux",
	418:   "hyper-g",
	419:   "ariel1",
	420:   "smpte",
	421:   "ariel2",
	422:   "ariel3",
	423:   "opc-job-start",
	424:   "opc-job-track",
	425:   "icad-el",
	426:   "smartsdp",
	427:   "svrloc",
	428:   "ocs-cmu",
	429:   "ocs-amu",
	430:   "utmpsd",
	431:   "utmpcd",
	432:   "iasd",
	433:   "nnsp",
	434:   "mobileip-agent",
	435:   "mobilip-mn",
	436:   "dna-cml",
	437:   "comscm",
	438:   "dsfgw",
	439:   "dasp",
	440:   "sgcp",
	441:   "decvms-sysmgt",
	442:   "cvc-hostd",
	443:   "https",
	444:   "snpp",
	445:   "microsoft-ds",
	446:   "ddm-rdb",
	447:   "ddm-dfm",
	448:   "ddm-ssl",
	449:   "as-servermap",
	450:   "tserver",
	451:   "sfs-smp-net",
	452:   "sfs-config",
	453:   "creativeserver",
	454:   "contentserver",
	455:   "creativepartnr",
	456:   "macon-tcp",
	457:   "scohelp",
	458:   "appleqtc",
	459:   "ampr-rcmd",
	460:   "skronk",
	461:   "datasurfsrv",
	462:   "datasurfsrvsec",
	463:   "alpes",
	464:   "kpasswd",
	465:   "urd",
	466:   "digital-vrc",
	467:   "mylex-mapd",
	468:   "photuris",
	469:   "rcp",
	470:   "scx-proxy",
	471:   "mondex",
	472:   "ljk-login",
	473:   "hybrid-pop",
	474:   "tn-tl-w1",
	475:   "tcpnethaspsrv",
	476:   "tn-tl-fd1",
	477:   "ss7ns",
	478:   "spsc",
	479:   "iafserver",
	480:   "iafdbase",
	481:   "ph",
	482:   "bgs-nsi",
	483:   "ulpnet",
	484:   "integra-sme",
	485:   "powerburst",
	486:   "avian",
	487:   "saft",
	488:   "gss-http",
	489:   "nest-protocol",
	490:   "micom-pfs",
	491:   "go-login",
	492:   "ticf-1",
	493:   "ticf-2",
	494:   "pov-ray",
	495:   "intecourier",
	496:   "pim-rp-disc",
	497:   "retrospect",
	498:   "siam",
	499:   "iso-ill",
	500:   "isakmp",
	501:   "stmf",
	502:   "mbap",
	503:   "intrinsa",
	504:   "citadel",
	505:   "mailbox-lm",
	506:   "ohimsrv",
	507:   "crs",
	508:   "xvttp",
	509:   "snare",
	510:   "fcp",
	511:   "passgo",
	512:   "exec",
	513:   "login",
	514:   "shell",
	515:   "printer",
	516:   "videotex",
	517:   "talk",
	518:   "ntalk",
	519:   "utime",
	520:   "efs",
	521:   "ripng",
	522:   "ulp",
	523:   "ibm-db2",
	524:   "ncp",
	525:   "timed",
	526:   "tempo",
	527:   "stx",
	528:   "custix",
	529:   "irc-serv",
	530:   "courier",
	531:   "conference",
	532:   "netnews",
	533:   "netwall",
	534:   "windream",
	535:   "iiop",
	536:   "opalis-rdv",
	537:   "nmsp",
	538:   "gdomap",
	539:   "apertus-ldp",
	540:   "uucp",
	541:   "uucp-rlogin",
	542:   "commerce",
	543:   "klogin",
	544:   "kshell",
	545:   "appleqtcsrvr",
	546:   "dhcpv6-client",
	547:   "dhcpv6-server",
	548:   "afpovertcp",
	549:   "idfp",
	550:   "new-rwho",
	551:   "cybercash",
	552:   "devshr-nts",
	553:   "pirp",
	554:   "rtsp",
	555:   "dsf",
	556:   "remotefs",
	557:   "openvms-sysipc",
	558:   "sdnskmp",
	559:   "teedtap",
	560:   "rmonitor",
	561:   "monitor",
	562:   "chshell",
	563:   "nntps",
	564:   "9pfs",
	565:   "whoami",
	566:   "streettalk",
	567:   "banyan-rpc",
	568:   "ms-shuttle",
	569:   "ms-rome",
	570:   "meter",
	571:   "meter",
	572:   "sonar",
	573:   "banyan-vip",
	574:   "ftp-agent",
	575:   "vemmi",
	576:   "ipcd",
	577:   "vnas",
	578:   "ipdd",
	579:   "decbsrv",
	580:   "sntp-heartbeat",
	581:   "bdp",
	582:   "scc-security",
	583:   "philips-vc",
	584:   "keyserver",
	586:   "password-chg",
	587:   "submission",
	588:   "cal",
	589:   "eyelink",
	590:   "tns-cml",
	591:   "http-alt",
	592:   "eudora-set",
	593:   "http-rpc-epmap",
	594:   "tpip",
	595:   "cab-protocol",
	596:   "smsd",
	597:   "ptcnameservice",
	598:   "sco-websrvrmg3",
	599:   "acp",
	600:   "ipcserver",
	601:   "syslog-conn",
	602:   "xmlrpc-beep",
	603:   "idxp",
	604:   "tunnel",
	605:   "soap-beep",
	606:   "urm",
	607:   "nqs",
	608:   "sift-uft",
	609:   "npmp-trap",
	610:   "npmp-local",
	611:   "npmp-gui",
	612:   "hmmp-ind",
	613:   "hmmp-op",
	614:   "sshell",
	615:   "sco-inetmgr",
	616:   "sco-sysmgr",
	617:   "sco-dtmgr",
	618:   "dei-icda",
	619:   "compaq-evm",
	620:   "sco-websrvrmgr",
	621:   "escp-ip",
	622:   "collaborator",
	623:   "oob-ws-http",
	624:   "cryptoadmin",
	625:   "dec-dlm",
	626:   "asia",
	627:   "passgo-tivoli",
	628:   "qmqp",
	629:   "3com-amp3",
	630:   "rda",
	631:   "ipp",
	632:   "bmpp",
	633:   "servstat",
	634:   "ginad",
	635:   "rlzdbase",
	636:   "ldaps",
	637:   "lanserver",
	638:   "mcns-sec",
	639:   "msdp",
	640:   "entrust-sps",
	641:   "repcmd",
	642:   "esro-emsdp",
	643:   "sanity",
	644:   "dwr",
	645:   "pssc",
	646:   "ldp",
	647:   "dhcp-failover",
	648:   "rrp",
	649:   "cadview-3d",
	650:   "obex",
	651:   "ieee-mms",
	652:   "hello-port",
	653:   "repscmd",
	654:   "aodv",
	655:   "tinc",
	656:   "spmp",
	657:   "rmc",
	658:   "tenfold",
	660:   "mac-srvr-admin",
	661:   "hap",
	662:   "pftp",
	663:   "purenoise",
	664:   "oob-ws-https",
	665:   "sun-dr",
	666:   "mdqs",
	667:   "disclose",
	668:   "mecomm",
	669:   "meregister",
	670:   "vacdsm-sws",
	671:   "vacdsm-app",
	672:   "vpps-qua",
	673:   "cimplex",
	674:   "acap",
	675:   "dctp",
	676:   "vpps-via",
	677:   "vpp",
	678:   "ggf-ncp",
	679:   "mrm",
	680:   "entrust-aaas",
	681:   "entrust-aams",
	682:   "xfr",
	683:   "corba-iiop",
	684:   "corba-iiop-ssl",
	685:   "mdc-portmapper",
	686:   "hcp-wismar",
	687:   "asipregistry",
	688:   "realm-rusd",
	689:   "nmap",
	690:   "vatp",
	691:   "msexch-routing",
	692:   "hyperwave-isp",
	693:   "connendp",
	694:   "ha-cluster",
	695:   "ieee-mms-ssl",
	696:   "rushd",
	697:   "uuidgen",
	698:   "olsr",
	699:   "accessnetwork",
	700:   "epp",
	701:   "lmp",
	702:   "iris-beep",
	704:   "elcsd",
	705:   "agentx",
	706:   "silc",
	707:   "borland-dsj",
	709:   "entrust-kmsh",
	710:   "entrust-ash",
	711:   "cisco-tdp",
	712:   "tbrpf",
	713:   "iris-xpc",
	714:   "iris-xpcs",
	715:   "iris-lwz",
	729:   "netviewdm1",
	730:   "netviewdm2",
	731:   "netviewdm3",
	741:   "netgw",
	742:   "netrcs",
	744:   "flexlm",
	747:   "fujitsu-dev",
	748:   "ris-cm",
	749:   "kerberos-adm",
	750:   "rfile",
	751:   "pump",
	752:   "qrh",
	753:   "rrh",
	754:   "tell",
	758:   "nlogin",
	759:   "con",
	760:   "ns",
	761:   "rxe",
	762:   "quotad",
	763:   "cycleserv",
	764:   "omserv",
	765:   "webster",
	767:   "phonebook",
	769:   "vid",
	770:   "cadlock",
	771:   "rtip",
	772:   "cycleserv2",
	773:   "submit",
	774:   "rpasswd",
	775:   "entomb",
	776:   "wpages",
	777:   "multiling-http",
	780:   "wpgs",
	800:   "mdbs-daemon",
	801:   "device",
	802:   "mbap-s",
	810:   "fcp-udp",
	828:   "itm-mcell-s",
	829:   "pkix-3-ca-ra",
	830:   "netconf-ssh",
	831:   "netconf-beep",
	832:   "netconfsoaphttp",
	833:   "netconfsoapbeep",
	847:   "dhcp-failover2",
	848:   "gdoi",
	860:   "iscsi",
	861:   "owamp-control",
	862:   "twamp-control",
	873:   "rsync",
	886:   "iclcnet-locate",
	887:   "iclcnet-svinfo",
	888:   "accessbuilder",
	900:   "omginitialrefs",
	901:   "smpnameres",
	902:   "ideafarm-door",
	903:   "ideafarm-panic",
	910:   "kink",
	911:   "xact-backup",
	912:   "apex-mesh",
	913:   "apex-edge",
	989:   "ftps-data",
	990:   "ftps",
	991:   "nas",
	992:   "telnets",
	993:   "imaps",
	995:   "pop3s",
	996:   "vsinet",
	997:   "maitrd",
	998:   "busboy",
	999:   "garcon",
	1000:  "cadlock2",
	1010:  "surf",
	1021:  "exp1",
	1022:  "exp2",
	1025:  "blackjack",
	1026:  "cap",
	1029:  "solid-mux",
	1033:  "netinfo-local",
	1034:  "activesync",
	1035:  "mxxrlogin",
	1036:  "nsstp",
	1037:  "ams",
	1038:  "mtqp",
	1039:  "sbl",
	1040:  "netarx",
	1041:  "danf-ak2",
	1042:  "afrog",
	1043:  "boinc-client",
	1044:  "dcutility",
	1045:  "fpitp",
	1046:  "wfremotertm",
	1047:  "neod1",
	1048:  "neod2",
	1049:  "td-postman",
	1050:  "cma",
	1051:  "optima-vnet",
	1052:  "ddt",
	1053:  "remote-as",
	1054:  "brvread",
	1055:  "ansyslmd",
	1056:  "vfo",
	1057:  "startron",
	1058:  "nim",
	1059:  "nimreg",
	1060:  "polestar",
	1061:  "kiosk",
	1062:  "veracity",
	1063:  "kyoceranetdev",
	1064:  "jstel",
	1065:  "syscomlan",
	1066:  "fpo-fns",
	1067:  "instl-boots",
	1068:  "instl-bootc",
	1069:  "cognex-insight",
	1070:  "gmrupdateserv",
	1071:  "bsquare-voip",
	1072:  "cardax",
	1073:  "bridgecontrol",
	1074:  "warmspotMgmt",
	1075:  "rdrmshc",
	1076:  "dab-sti-c",
	1077:  "imgames",
	1078:  "avocent-proxy",
	1079:  "asprovatalk",
	1080:  "socks",
	1081:  "pvuniwien",
	1082:  "amt-esd-prot",
	1083:  "ansoft-lm-1",
	1084:  "ansoft-lm-2",
	1085:  "webobjects",
	1086:  "cplscrambler-lg",
	1087:  "cplscrambler-in",
	1088:  "cplscrambler-al",
	1089:  "ff-annunc",
	1090:  "ff-fms",
	1091:  "ff-sm",
	1092:  "obrpd",
	1093:  "proofd",
	1094:  "rootd",
	1095:  "nicelink",
	1096:  "cnrprotocol",
	1097:  "sunclustermgr",
	1098:  "rmiactivation",
	1099:  "rmiregistry",
	1100:  "mctp",
	1101:  "pt2-discover",
	1102:  "adobeserver-1",
	1103:  "adobeserver-2",
	1104:  "xrl",
	1105:  "ftranhc",
	1106:  "isoipsigport-1",
	1107:  "isoipsigport-2",
	1108:  "ratio-adp",
	1110:  "webadmstart",
	1111:  "lmsocialserver",
	1112:  "icp",
	1113:  "ltp-deepspace",
	1114:  "mini-sql",
	1115:  "ardus-trns",
	1116:  "ardus-cntl",
	1117:  "ardus-mtrns",
	1118:  "sacred",
	1119:  "bnetgame",
	1120:  "bnetfile",
	1121:  "rmpp",
	1122:  "availant-mgr",
	1123:  "murray",
	1124:  "hpvmmcontrol",
	1125:  "hpvmmagent",
	1126:  "hpvmmdata",
	1127:  "kwdb-commn",
	1128:  "saphostctrl",
	1129:  "saphostctrls",
	1130:  "casp",
	1131:  "caspssl",
	1132:  "kvm-via-ip",
	1133:  "dfn",
	1134:  "aplx",
	1135:  "omnivision",
	1136:  "hhb-gateway",
	1137:  "trim",
	1138:  "encrypted-admin",
	1139:  "evm",
	1140:  "autonoc",
	1141:  "mxomss",
	1142:  "edtools",
	1143:  "imyx",
	1144:  "fuscript",
	1145:  "x9-icue",
	1146:  "audit-transfer",
	1147:  "capioverlan",
	1148:  "elfiq-repl",
	1149:  "bvtsonar",
	1150:  "blaze",
	1151:  "unizensus",
	1152:  "winpoplanmess",
	1153:  "c1222-acse",
	1154:  "resacommunity",
	1155:  "nfa",
	1156:  "iascontrol-oms",
	1157:  "iascontrol",
	1158:  "dbcontrol-oms",
	1159:  "oracle-oms",
	1160:  "olsv",
	1161:  "health-polling",
	1162:  "health-trap",
	1163:  "sddp",
	1164:  "qsm-proxy",
	1165:  "qsm-gui",
	1166:  "qsm-remote",
	1167:  "cisco-ipsla",
	1168:  "vchat",
	1169:  "tripwire",
	1170:  "atc-lm",
	1171:  "atc-appserver",
	1172:  "dnap",
	1173:  "d-cinema-rrp",
	1174:  "fnet-remote-ui",
	1175:  "dossier",
	1176:  "indigo-server",
	1177:  "dkmessenger",
	1178:  "sgi-storman",
	1179:  "b2n",
	1180:  "mc-client",
	1181:  "3comnetman",
	1182:  "accelenet",
	1183:  "llsurfup-http",
	1184:  "llsurfup-https",
	1185:  "catchpole",
	1186:  "mysql-cluster",
	1187:  "alias",
	1188:  "hp-webadmin",
	1189:  "unet",
	1190:  "commlinx-avl",
	1191:  "gpfs",
	1192:  "caids-sensor",
	1193:  "fiveacross",
	1194:  "openvpn",
	1195:  "rsf-1",
	1196:  "netmagic",
	1197:  "carrius-rshell",
	1198:  "cajo-discovery",
	1199:  "dmidi",
	1200:  "scol",
	1201:  "nucleus-sand",
	1202:  "caiccipc",
	1203:  "ssslic-mgr",
	1204:  "ssslog-mgr",
	1205:  "accord-mgc",
	1206:  "anthony-data",
	1207:  "metasage",
	1208:  "seagull-ais",
	1209:  "ipcd3",
	1210:  "eoss",
	1211:  "groove-dpp",
	1212:  "lupa",
	1213:  "mpc-lifenet",
	1214:  "kazaa",
	1215:  "scanstat-1",
	1216:  "etebac5",
	1217:  "hpss-ndapi",
	1218:  "aeroflight-ads",
	1219:  "aeroflight-ret",
	1220:  "qt-serveradmin",
	1221:  "sweetware-apps",
	1222:  "nerv",
	1223:  "tgp",
	1224:  "vpnz",
	1225:  "slinkysearch",
	1226:  "stgxfws",
	1227:  "dns2go",
	1228:  "florence",
	1229:  "zented",
	1230:  "periscope",
	1231:  "menandmice-lpm",
	1232:  "first-defense",
	1233:  "univ-appserver",
	1234:  "search-agent",
	1235:  "mosaicsyssvc1",
	1236:  "bvcontrol",
	1237:  "tsdos390",
	1238:  "hacl-qs",
	1239:  "nmsd",
	1240:  "instantia",
	1241:  "nessus",
	1242:  "nmasoverip",
	1243:  "serialgateway",
	1244:  "isbconference1",
	1245:  "isbconference2",
	1246:  "payrouter",
	1247:  "visionpyramid",
	1248:  "hermes",
	1249:  "mesavistaco",
	1250:  "swldy-sias",
	1251:  "servergraph",
	1252:  "bspne-pcc",
	1253:  "q55-pcc",
	1254:  "de-noc",
	1255:  "de-cache-query",
	1256:  "de-server",
	1257:  "shockwave2",
	1258:  "opennl",
	1259:  "opennl-voice",
	1260:  "ibm-ssd",
	1261:  "mpshrsv",
	1262:  "qnts-orb",
	1263:  "dka",
	1264:  "prat",
	1265:  "dssiapi",
	1266:  "dellpwrappks",
	1267:  "epc",
	1268:  "propel-msgsys",
	1269:  "watilapp",
	1270:  "opsmgr",
	1271:  "excw",
	1272:  "cspmlockmgr",
	1273:  "emc-gateway",
	1274:  "t1distproc",
	1275:  "ivcollector",
	1277:  "miva-mqs",
	1278:  "dellwebadmin-1",
	1279:  "dellwebadmin-2",
	1280:  "pictrography",
	1281:  "healthd",
	1282:  "emperion",
	1283:  "productinfo",
	1284:  "iee-qfx",
	1285:  "neoiface",
	1286:  "netuitive",
	1287:  "routematch",
	1288:  "navbuddy",
	1289:  "jwalkserver",
	1290:  "winjaserver",
	1291:  "seagulllms",
	1292:  "dsdn",
	1293:  "pkt-krb-ipsec",
	1294:  "cmmdriver",
	1295:  "ehtp",
	1296:  "dproxy",
	1297:  "sdproxy",
	1298:  "lpcp",
	1299:  "hp-sci",
	1300:  "h323hostcallsc",
	1301:  "ci3-software-1",
	1302:  "ci3-software-2",
	1303:  "sftsrv",
	1304:  "boomerang",
	1305:  "pe-mike",
	1306:  "re-conn-proto",
	1307:  "pacmand",
	1308:  "odsi",
	1309:  "jtag-server",
	1310:  "husky",
	1311:  "rxmon",
	1312:  "sti-envision",
	1313:  "bmc-patroldb",
	1314:  "pdps",
	1315:  "els",
	1316:  "exbit-escp",
	1317:  "vrts-ipcserver",
	1318:  "krb5gatekeeper",
	1319:  "amx-icsp",
	1320:  "amx-axbnet",
	1321:  "pip",
	1322:  "novation",
	1323:  "brcd",
	1324:  "delta-mcp",
	1325:  "dx-instrument",
	1326:  "wimsic",
	1327:  "ultrex",
	1328:  "ewall",
	1329:  "netdb-export",
	1330:  "streetperfect",
	1331:  "intersan",
	1332:  "pcia-rxp-b",
	1333:  "passwrd-policy",
	1334:  "writesrv",
	1335:  "digital-notary",
	1336:  "ischat",
	1337:  "menandmice-dns",
	1338:  "wmc-log-svc",
	1339:  "kjtsiteserver",
	1340:  "naap",
	1341:  "qubes",
	1342:  "esbroker",
	1343:  "re101",
	1344:  "icap",
	1345:  "vpjp",
	1346:  "alta-ana-lm",
	1347:  "bbn-mmc",
	1348:  "bbn-mmx",
	1349:  "sbook",
	1350:  "editbench",
	1351:  "equationbuilder",
	1352:  "lotusnote",
	1353:  "relief",
	1354:  "XSIP-network",
	1355:  "intuitive-edge",
	1356:  "cuillamartin",
	1357:  "pegboard",
	1358:  "connlcli",
	1359:  "ftsrv",
	1360:  "mimer",
	1361:  "linx",
	1362:  "timeflies",
	1363:  "ndm-requester",
	1364:  "ndm-server",
	1365:  "adapt-sna",
	1366:  "netware-csp",
	1367:  "dcs",
	1368:  "screencast",
	1369:  "gv-us",
	1370:  "us-gv",
	1371:  "fc-cli",
	1372:  "fc-ser",
	1373:  "chromagrafx",
	1374:  "molly",
	1375:  "bytex",
	1376:  "ibm-pps",
	1377:  "cichlid",
	1378:  "elan",
	1379:  "dbreporter",
	1380:  "telesis-licman",
	1381:  "apple-licman",
	1382:  "udt-os",
	1383:  "gwha",
	1384:  "os-licman",
	1385:  "atex-elmd",
	1386:  "checksum",
	1387:  "cadsi-lm",
	1388:  "objective-dbc",
	1389:  "iclpv-dm",
	1390:  "iclpv-sc",
	1391:  "iclpv-sas",
	1392:  "iclpv-pm",
	1393:  "iclpv-nls",
	1394:  "iclpv-nlc",
	1395:  "iclpv-wsm",
	1396:  "dvl-activemail",
	1397:  "audio-activmail",
	1398:  "video-activmail",
	1399:  "cadkey-licman",
	1400:  "cadkey-tablet",
	1401:  "goldleaf-licman",
	1402:  "prm-sm-np",
	1403:  "prm-nm-np",
	1404:  "igi-lm",
	1405:  "ibm-res",
	1406:  "netlabs-lm",
	1407:  "dbsa-lm",
	1408:  "sophia-lm",
	1409:  "here-lm",
	1410:  "hiq",
	1411:  "af",
	1412:  "innosys",
	1413:  "innosys-acl",
	1414:  "ibm-mqseries",
	1415:  "dbstar",
	1416:  "novell-lu6-2",
	1417:  "timbuktu-srv1",
	1418:  "timbuktu-srv2",
	1419:  "timbuktu-srv3",
	1420:  "timbuktu-srv4",
	1421:  "gandalf-lm",
	1422:  "autodesk-lm",
	1423:  "essbase",
	1424:  "hybrid",
	1425:  "zion-lm",
	1426:  "sais",
	1427:  "mloadd",
	1428:  "informatik-lm",
	1429:  "nms",
	1430:  "tpdu",
	1431:  "rgtp",
	1432:  "blueberry-lm",
	1433:  "ms-sql-s",
	1434:  "ms-sql-m",
	1435:  "ibm-cics",
	1436:  "saism",
	1437:  "tabula",
	1438:  "eicon-server",
	1439:  "eicon-x25",
	1440:  "eicon-slp",
	1441:  "cadis-1",
	1442:  "cadis-2",
	1443:  "ies-lm",
	1444:  "marcam-lm",
	1445:  "proxima-lm",
	1446:  "ora-lm",
	1447:  "apri-lm",
	1448:  "oc-lm",
	1449:  "peport",
	1450:  "dwf",
	1451:  "infoman",
	1452:  "gtegsc-lm",
	1453:  "genie-lm",
	1454:  "interhdl-elmd",
	1455:  "esl-lm",
	1456:  "dca",
	1457:  "valisys-lm",
	1458:  "nrcabq-lm",
	1459:  "proshare1",
	1460:  "proshare2",
	1461:  "ibm-wrless-lan",
	1462:  "world-lm",
	1463:  "nucleus",
	1464:  "msl-lmd",
	1465:  "pipes",
	1466:  "oceansoft-lm",
	1467:  "csdmbase",
	1468:  "csdm",
	1469:  "aal-lm",
	1470:  "uaiact",
	1471:  "csdmbase",
	1472:  "csdm",
	1473:  "openmath",
	1474:  "telefinder",
	1475:  "taligent-lm",
	1476:  "clvm-cfg",
	1477:  "ms-sna-server",
	1478:  "ms-sna-base",
	1479:  "dberegister",
	1480:  "pacerforum",
	1481:  "airs",
	1482:  "miteksys-lm",
	1483:  "afs",
	1484:  "confluent",
	1485:  "lansource",
	1486:  "nms-topo-serv",
	1487:  "localinfosrvr",
	1488:  "docstor",
	1489:  "dmdocbroker",
	1490:  "insitu-conf",
	1492:  "stone-design-1",
	1493:  "netmap-lm",
	1494:  "ica",
	1495:  "cvc",
	1496:  "liberty-lm",
	1497:  "rfx-lm",
	1498:  "sybase-sqlany",
	1499:  "fhc",
	1500:  "vlsi-lm",
	1501:  "saiscm",
	1502:  "shivadiscovery",
	1503:  "imtc-mcs",
	1504:  "evb-elm",
	1505:  "funkproxy",
	1506:  "utcd",
	1507:  "symplex",
	1508:  "diagmond",
	1509:  "robcad-lm",
	1510:  "mvx-lm",
	1511:  "3l-l1",
	1512:  "wins",
	1513:  "fujitsu-dtc",
	1514:  "fujitsu-dtcns",
	1515:  "ifor-protocol",
	1516:  "vpad",
	1517:  "vpac",
	1518:  "vpvd",
	1519:  "vpvc",
	1520:  "atm-zip-office",
	1521:  "ncube-lm",
	1522:  "ricardo-lm",
	1523:  "cichild-lm",
	1524:  "ingreslock",
	1525:  "orasrv",
	1526:  "pdap-np",
	1527:  "tlisrv",
	1529:  "coauthor",
	1530:  "rap-service",
	1531:  "rap-listen",
	1532:  "miroconnect",
	1533:  "virtual-places",
	1534:  "micromuse-lm",
	1535:  "ampr-info",
	1536:  "ampr-inter",
	1537:  "sdsc-lm",
	1538:  "3ds-lm",
	1539:  "intellistor-lm",
	1540:  "rds",
	1541:  "rds2",
	1542:  "gridgen-elmd",
	1543:  "simba-cs",
	1544:  "aspeclmd",
	1545:  "vistium-share",
	1546:  "abbaccuray",
	1547:  "laplink",
	1548:  "axon-lm",
	1549:  "shivahose",
	1550:  "3m-image-lm",
	1551:  "hecmtl-db",
	1552:  "pciarray",
	1553:  "sna-cs",
	1554:  "caci-lm",
	1555:  "livelan",
	1556:  "veritas-pbx",
	1557:  "arbortext-lm",
	1558:  "xingmpeg",
	1559:  "web2host",
	1560:  "asci-val",
	1561:  "facilityview",
	1562:  "pconnectmgr",
	1563:  "cadabra-lm",
	1564:  "pay-per-view",
	1565:  "winddlb",
	1566:  "corelvideo",
	1567:  "jlicelmd",
	1568:  "tsspmap",
	1569:  "ets",
	1570:  "orbixd",
	1571:  "rdb-dbs-disp",
	1572:  "chip-lm",
	1573:  "itscomm-ns",
	1574:  "mvel-lm",
	1575:  "oraclenames",
	1576:  "moldflow-lm",
	1577:  "hypercube-lm",
	1578:  "jacobus-lm",
	1579:  "ioc-sea-lm",
	1580:  "tn-tl-r1",
	1581:  "mil-2045-47001",
	1582:  "msims",
	1583:  "simbaexpress",
	1584:  "tn-tl-fd2",
	1585:  "intv",
	1586:  "ibm-abtact",
	1587:  "pra-elmd",
	1588:  "triquest-lm",
	1589:  "vqp",
	1590:  "gemini-lm",
	1591:  "ncpm-pm",
	1592:  "commonspace",
	1593:  "mainsoft-lm",
	1594:  "sixtrak",
	1595:  "radio",
	1596:  "radio-sm",
	1597:  "orbplus-iiop",
	1598:  "picknfs",
	1599:  "simbaservices",
	1600:  "issd",
	1601:  "aas",
	1602:  "inspect",
	1603:  "picodbc",
	1604:  "icabrowser",
	1605:  "slp",
	1606:  "slm-api",
	1607:  "stt",
	1608:  "smart-lm",
	1609:  "isysg-lm",
	1610:  "taurus-wh",
	1611:  "ill",
	1612:  "netbill-trans",
	1613:  "netbill-keyrep",
	1614:  "netbill-cred",
	1615:  "netbill-auth",
	1616:  "netbill-prod",
	1617:  "nimrod-agent",
	1618:  "skytelnet",
	1619:  "xs-openstorage",
	1620:  "faxportwinport",
	1621:  "softdataphone",
	1622:  "ontime",
	1623:  "jaleosnd",
	1624:  "udp-sr-port",
	1625:  "svs-omagent",
	1626:  "shockwave",
	1627:  "t128-gateway",
	1628:  "lontalk-norm",
	1629:  "lontalk-urgnt",
	1630:  "oraclenet8cman",
	1631:  "visitview",
	1632:  "pammratc",
	1633:  "pammrpc",
	1634:  "loaprobe",
	1635:  "edb-server1",
	1636:  "isdc",
	1637:  "islc",
	1638:  "ismc",
	1639:  "cert-initiator",
	1640:  "cert-responder",
	1641:  "invision",
	1642:  "isis-am",
	1643:  "isis-ambc",
	1644:  "saiseh",
	1645:  "sightline",
	1646:  "sa-msg-port",
	1647:  "rsap",
	1648:  "concurrent-lm",
	1649:  "kermit",
	1650:  "nkd",
	1651:  "shiva-confsrvr",
	1652:  "xnmp",
	1653:  "alphatech-lm",
	1654:  "stargatealerts",
	1655:  "dec-mbadmin",
	1656:  "dec-mbadmin-h",
	1657:  "fujitsu-mmpdc",
	1658:  "sixnetudr",
	1659:  "sg-lm",
	1660:  "skip-mc-gikreq",
	1661:  "netview-aix-1",
	1662:  "netview-aix-2",
	1663:  "netview-aix-3",
	1664:  "netview-aix-4",
	1665:  "netview-aix-5",
	1666:  "netview-aix-6",
	1667:  "netview-aix-7",
	1668:  "netview-aix-8",
	1669:  "netview-aix-9",
	1670:  "netview-aix-10",
	1671:  "netview-aix-11",
	1672:  "netview-aix-12",
	1673:  "proshare-mc-1",
	1674:  "proshare-mc-2",
	1675:  "pdp",
	1676:  "netcomm1",
	1677:  "groupwise",
	1678:  "prolink",
	1679:  "darcorp-lm",
	1680:  "microcom-sbp",
	1681:  "sd-elmd",
	1682:  "lanyon-lantern",
	1683:  "ncpm-hip",
	1684:  "snaresecure",
	1685:  "n2nremote",
	1686:  "cvmon",
	1687:  "nsjtp-ctrl",
	1688:  "nsjtp-data",
	1689:  "firefox",
	1690:  "ng-umds",
	1691:  "empire-empuma",
	1692:  "sstsys-lm",
	1693:  "rrirtr",
	1694:  "rrimwm",
	1695:  "rrilwm",
	1696:  "rrifmm",
	1697:  "rrisat",
	1698:  "rsvp-encap-1",
	1699:  "rsvp-encap-2",
	1700:  "mps-raft",
	1701:  "l2f",
	1702:  "deskshare",
	1703:  "hb-engine",
	1704:  "bcs-broker",
	1705:  "slingshot",
	1706:  "jetform",
	1707:  "vdmplay",
	1708:  "gat-lmd",
	1709:  "centra",
	1710:  "impera",
	1711:  "pptconference",
	1712:  "registrar",
	1713:  "conferencetalk",
	1714:  "sesi-lm",
	1715:  "houdini-lm",
	1716:  "xmsg",
	1717:  "fj-hdnet",
	1718:  "h323gatedisc",
	1719:  "h323gatestat",
	1720:  "h323hostcall",
	1721:  "caicci",
	1722:  "hks-lm",
	1723:  "pptp",
	1724:  "csbphonemaster",
	1725:  "iden-ralp",
	1726:  "iberiagames",
	1727:  "winddx",
	1728:  "telindus",
	1729:  "citynl",
	1730:  "roketz",
	1731:  "msiccp",
	1732:  "proxim",
	1733:  "siipat",
	1734:  "cambertx-lm",
	1735:  "privatechat",
	1736:  "street-stream",
	1737:  "ultimad",
	1738:  "gamegen1",
	1739:  "webaccess",
	1740:  "encore",
	1741:  "cisco-net-mgmt",
	1742:  "3Com-nsd",
	1743:  "cinegrfx-lm",
	1744:  "ncpm-ft",
	1745:  "remote-winsock",
	1746:  "ftrapid-1",
	1747:  "ftrapid-2",
	1748:  "oracle-em1",
	1749:  "aspen-services",
	1750:  "sslp",
	1751:  "swiftnet",
	1752:  "lofr-lm",
	1753:  "predatar-comms",
	1754:  "oracle-em2",
	1755:  "ms-streaming",
	1756:  "capfast-lmd",
	1757:  "cnhrp",
	1758:  "tftp-mcast",
	1759:  "spss-lm",
	1760:  "www-ldap-gw",
	1761:  "cft-0",
	1762:  "cft-1",
	1763:  "cft-2",
	1764:  "cft-3",
	1765:  "cft-4",
	1766:  "cft-5",
	1767:  "cft-6",
	1768:  "cft-7",
	1769:  "bmc-net-adm",
	1770:  "bmc-net-svc",
	1771:  "vaultbase",
	1772:  "essweb-gw",
	1773:  "kmscontrol",
	1774:  "global-dtserv",
	1775:  "vdab",
	1776:  "femis",
	1777:  "powerguardian",
	1778:  "prodigy-intrnet",
	1779:  "pharmasoft",
	1780:  "dpkeyserv",
	1781:  "answersoft-lm",
	1782:  "hp-hcip",
	1784:  "finle-lm",
	1785:  "windlm",
	1786:  "funk-logger",
	1787:  "funk-license",
	1788:  "psmond",
	1789:  "hello",
	1790:  "nmsp",
	1791:  "ea1",
	1792:  "ibm-dt-2",
	1793:  "rsc-robot",
	1794:  "cera-bcm",
	1795:  "dpi-proxy",
	1796:  "vocaltec-admin",
	1797:  "uma",
	1798:  "etp",
	1799:  "netrisk",
	1800:  "ansys-lm",
	1801:  "msmq",
	1802:  "concomp1",
	1803:  "hp-hcip-gwy",
	1804:  "enl",
	1805:  "enl-name",
	1806:  "musiconline",
	1807:  "fhsp",
	1808:  "oracle-vp2",
	1809:  "oracle-vp1",
	1810:  "jerand-lm",
	1811:  "scientia-sdb",
	1812:  "radius",
	1813:  "radius-acct",
	1814:  "tdp-suite",
	1815:  "mmpft",
	1816:  "harp",
	1817:  "rkb-oscs",
	1818:  "etftp",
	1819:  "plato-lm",
	1820:  "mcagent",
	1821:  "donnyworld",
	1822:  "es-elmd",
	1823:  "unisys-lm",
	1824:  "metrics-pas",
	1825:  "direcpc-video",
	1826:  "ardt",
	1827:  "asi",
	1828:  "itm-mcell-u",
	1829:  "optika-emedia",
	1830:  "net8-cman",
	1831:  "myrtle",
	1832:  "tht-treasure",
	1833:  "udpradio",
	1834:  "ardusuni",
	1835:  "ardusmul",
	1836:  "ste-smsc",
	1837:  "csoft1",
	1838:  "talnet",
	1839:  "netopia-vo1",
	1840:  "netopia-vo2",
	1841:  "netopia-vo3",
	1842:  "netopia-vo4",
	1843:  "netopia-vo5",
	1844:  "direcpc-dll",
	1845:  "altalink",
	1846:  "tunstall-pnc",
	1847:  "slp-notify",
	1848:  "fjdocdist",
	1849:  "alpha-sms",
	1850:  "gsi",
	1851:  "ctcd",
	1852:  "virtual-time",
	1853:  "vids-avtp",
	1854:  "buddy-draw",
	1855:  "fiorano-rtrsvc",
	1856:  "fiorano-msgsvc",
	1857:  "datacaptor",
	1858:  "privateark",
	1859:  "gammafetchsvr",
	1860:  "sunscalar-svc",
	1861:  "lecroy-vicp",
	1862:  "mysql-cm-agent",
	1863:  "msnp",
	1864:  "paradym-31port",
	1865:  "entp",
	1866:  "swrmi",
	1867:  "udrive",
	1868:  "viziblebrowser",
	1869:  "transact",
	1870:  "sunscalar-dns",
	1871:  "canocentral0",
	1872:  "canocentral1",
	1873:  "fjmpjps",
	1874:  "fjswapsnp",
	1875:  "westell-stats",
	1876:  "ewcappsrv",
	1877:  "hp-webqosdb",
	1878:  "drmsmc",
	1879:  "nettgain-nms",
	1880:  "vsat-control",
	1881:  "ibm-mqseries2",
	1882:  "ecsqdmn",
	1883:  "ibm-mqisdp",
	1884:  "idmaps",
	1885:  "vrtstrapserver",
	1886:  "leoip",
	1887:  "filex-lport",
	1888:  "ncconfig",
	1889:  "unify-adapter",
	1890:  "wilkenlistener",
	1891:  "childkey-notif",
	1892:  "childkey-ctrl",
	1893:  "elad",
	1894:  "o2server-port",
	1896:  "b-novative-ls",
	1897:  "metaagent",
	1898:  "cymtec-port",
	1899:  "mc2studios",
	1900:  "ssdp",
	1901:  "fjicl-tep-a",
	1902:  "fjicl-tep-b",
	1903:  "linkname",
	1904:  "fjicl-tep-c",
	1905:  "sugp",
	1906:  "tpmd",
	1907:  "intrastar",
	1908:  "dawn",
	1909:  "global-wlink",
	1910:  "ultrabac",
	1911:  "mtp",
	1912:  "rhp-iibp",
	1913:  "armadp",
	1914:  "elm-momentum",
	1915:  "facelink",
	1916:  "persona",
	1917:  "noagent",
	1918:  "can-nds",
	1919:  "can-dch",
	1920:  "can-ferret",
	1921:  "noadmin",
	1922:  "tapestry",
	1923:  "spice",
	1924:  "xiip",
	1925:  "discovery-port",
	1926:  "egs",
	1927:  "videte-cipc",
	1928:  "emsd-port",
	1929:  "bandwiz-system",
	1930:  "driveappserver",
	1931:  "amdsched",
	1932:  "ctt-broker",
	1933:  "xmapi",
	1934:  "xaapi",
	1935:  "macromedia-fcs",
	1936:  "jetcmeserver",
	1937:  "jwserver",
	1938:  "jwclient",
	1939:  "jvserver",
	1940:  "jvclient",
	1941:  "dic-aida",
	1942:  "res",
	1943:  "beeyond-media",
	1944:  "close-combat",
	1945:  "dialogic-elmd",
	1946:  "tekpls",
	1947:  "sentinelsrm",
	1948:  "eye2eye",
	1949:  "ismaeasdaqlive",
	1950:  "ismaeasdaqtest",
	1951:  "bcs-lmserver",
	1952:  "mpnjsc",
	1953:  "rapidbase",
	1954:  "abr-api",
	1955:  "abr-secure",
	1956:  "vrtl-vmf-ds",
	1957:  "unix-status",
	1958:  "dxadmind",
	1959:  "simp-all",
	1960:  "nasmanager",
	1961:  "bts-appserver",
	1962:  "biap-mp",
	1963:  "webmachine",
	1964:  "solid-e-engine",
	1965:  "tivoli-npm",
	1966:  "slush",
	1967:  "sns-quote",
	1968:  "lipsinc",
	1969:  "lipsinc1",
	1970:  "netop-rc",
	1971:  "netop-school",
	1972:  "intersys-cache",
	1973:  "dlsrap",
	1974:  "drp",
	1975:  "tcoflashagent",
	1976:  "tcoregagent",
	1977:  "tcoaddressbook",
	1978:  "unisql",
	1979:  "unisql-java",
	1980:  "pearldoc-xact",
	1981:  "p2pq",
	1982:  "estamp",
	1983:  "lhtp",
	1984:  "bb",
	1985:  "hsrp",
	1986:  "licensedaemon",
	1987:  "tr-rsrb-p1",
	1988:  "tr-rsrb-p2",
	1989:  "tr-rsrb-p3",
	1990:  "stun-p1",
	1991:  "stun-p2",
	1992:  "stun-p3",
	1993:  "snmp-tcp-port",
	1994:  "stun-port",
	1995:  "perf-port",
	1996:  "tr-rsrb-port",
	1997:  "gdp-port",
	1998:  "x25-svc-port",
	1999:  "tcp-id-port",
	2000:  "cisco-sccp",
	2001:  "dc",
	2002:  "globe",
	2003:  "brutus",
	2004:  "mailbox",
	2005:  "berknet",
	2006:  "invokator",
	2007:  "dectalk",
	2008:  "conf",
	2009:  "news",
	2010:  "search",
	2011:  "raid-cc",
	2012:  "ttyinfo",
	2013:  "raid-am",
	2014:  "troff",
	2015:  "cypress",
	2016:  "bootserver",
	2017:  "cypress-stat",
	2018:  "terminaldb",
	2019:  "whosockami",
	2020:  "xinupageserver",
	2021:  "servexec",
	2022:  "down",
	2023:  "xinuexpansion3",
	2024:  "xinuexpansion4",
	2025:  "ellpack",
	2026:  "scrabble",
	2027:  "shadowserver",
	2028:  "submitserver",
	2029:  "hsrpv6",
	2030:  "device2",
	2031:  "mobrien-chat",
	2032:  "blackboard",
	2033:  "glogger",
	2034:  "scoremgr",
	2035:  "imsldoc",
	2036:  "e-dpnet",
	2037:  "applus",
	2038:  "objectmanager",
	2039:  "prizma",
	2040:  "lam",
	2041:  "interbase",
	2042:  "isis",
	2043:  "isis-bcast",
	2044:  "rimsl",
	2045:  "cdfunc",
	2046:  "sdfunc",
	2047:  "dls",
	2048:  "dls-monitor",
	2049:  "shilp",
	2050:  "av-emb-config",
	2051:  "epnsdp",
	2052:  "clearvisn",
	2053:  "lot105-ds-upd",
	2054:  "weblogin",
	2055:  "iop",
	2056:  "omnisky",
	2057:  "rich-cp",
	2058:  "newwavesearch",
	2059:  "bmc-messaging",
	2060:  "teleniumdaemon",
	2061:  "netmount",
	2062:  "icg-swp",
	2063:  "icg-bridge",
	2064:  "icg-iprelay",
	2065:  "dlsrpn",
	2066:  "aura",
	2067:  "dlswpn",
	2068:  "avauthsrvprtcl",
	2069:  "event-port",
	2070:  "ah-esp-encap",
	2071:  "acp-port",
	2072:  "msync",
	2073:  "gxs-data-port",
	2074:  "vrtl-vmf-sa",
	2075:  "newlixengine",
	2076:  "newlixconfig",
	2077:  "tsrmagt",
	2078:  "tpcsrvr",
	2079:  "idware-router",
	2080:  "autodesk-nlm",
	2081:  "kme-trap-port",
	2082:  "infowave",
	2083:  "radsec",
	2084:  "sunclustergeo",
	2085:  "ada-cip",
	2086:  "gnunet",
	2087:  "eli",
	2088:  "ip-blf",
	2089:  "sep",
	2090:  "lrp",
	2091:  "prp",
	2092:  "descent3",
	2093:  "nbx-cc",
	2094:  "nbx-au",
	2095:  "nbx-ser",
	2096:  "nbx-dir",
	2097:  "jetformpreview",
	2098:  "dialog-port",
	2099:  "h2250-annex-g",
	2100:  "amiganetfs",
	2101:  "rtcm-sc104",
	2102:  "zephyr-srv",
	2103:  "zephyr-clt",
	2104:  "zephyr-hm",
	2105:  "minipay",
	2106:  "mzap",
	2107:  "bintec-admin",
	2108:  "comcam",
	2109:  "ergolight",
	2110:  "umsp",
	2111:  "dsatp",
	2112:  "idonix-metanet",
	2113:  "hsl-storm",
	2114:  "newheights",
	2115:  "kdm",
	2116:  "ccowcmr",
	2117:  "mentaclient",
	2118:  "mentaserver",
	2119:  "gsigatekeeper",
	2120:  "qencp",
	2121:  "scientia-ssdb",
	2122:  "caupc-remote",
	2123:  "gtp-control",
	2124:  "elatelink",
	2125:  "lockstep",
	2126:  "pktcable-cops",
	2127:  "index-pc-wb",
	2128:  "net-steward",
	2129:  "cs-live",
	2130:  "xds",
	2131:  "avantageb2b",
	2132:  "solera-epmap",
	2133:  "zymed-zpp",
	2134:  "avenue",
	2135:  "gris",
	2136:  "appworxsrv",
	2137:  "connect",
	2138:  "unbind-cluster",
	2139:  "ias-auth",
	2140:  "ias-reg",
	2141:  "ias-admind",
	2142:  "tdmoip",
	2143:  "lv-jc",
	2144:  "lv-ffx",
	2145:  "lv-pici",
	2146:  "lv-not",
	2147:  "lv-auth",
	2148:  "veritas-ucl",
	2149:  "acptsys",
	2150:  "dynamic3d",
	2151:  "docent",
	2152:  "gtp-user",
	2153:  "ctlptc",
	2154:  "stdptc",
	2155:  "brdptc",
	2156:  "trp",
	2157:  "xnds",
	2158:  "touchnetplus",
	2159:  "gdbremote",
	2160:  "apc-2160",
	2161:  "apc-2161",
	2162:  "navisphere",
	2163:  "navisphere-sec",
	2164:  "ddns-v3",
	2165:  "x-bone-api",
	2166:  "iwserver",
	2167:  "raw-serial",
	2168:  "easy-soft-mux",
	2169:  "brain",
	2170:  "eyetv",
	2171:  "msfw-storage",
	2172:  "msfw-s-storage",
	2173:  "msfw-replica",
	2174:  "msfw-array",
	2175:  "airsync",
	2176:  "rapi",
	2177:  "qwave",
	2178:  "bitspeer",
	2179:  "vmrdp",
	2180:  "mc-gt-srv",
	2181:  "eforward",
	2182:  "cgn-stat",
	2183:  "cgn-config",
	2184:  "nvd",
	2185:  "onbase-dds",
	2186:  "gtaua",
	2187:  "ssmc",
	2188:  "radware-rpm",
	2189:  "radware-rpm-s",
	2190:  "tivoconnect",
	2191:  "tvbus",
	2192:  "asdis",
	2193:  "drwcs",
	2197:  "mnp-exchange",
	2198:  "onehome-remote",
	2199:  "onehome-help",
	2200:  "ici",
	2201:  "ats",
	2202:  "imtc-map",
	2203:  "b2-runtime",
	2204:  "b2-license",
	2205:  "jps",
	2206:  "hpocbus",
	2207:  "hpssd",
	2208:  "hpiod",
	2209:  "rimf-ps",
	2210:  "noaaport",
	2211:  "emwin",
	2212:  "leecoposserver",
	2213:  "kali",
	2214:  "rpi",
	2215:  "ipcore",
	2216:  "vtu-comms",
	2217:  "gotodevice",
	2218:  "bounzza",
	2219:  "netiq-ncap",
	2220:  "netiq",
	2221:  "rockwell-csp1",
	2222:  "EtherNet-IP-1",
	2223:  "rockwell-csp2",
	2224:  "efi-mg",
	2225:  "rcip-itu",
	2226:  "di-drm",
	2227:  "di-msg",
	2228:  "ehome-ms",
	2229:  "datalens",
	2230:  "queueadm",
	2231:  "wimaxasncp",
	2232:  "ivs-video",
	2233:  "infocrypt",
	2234:  "directplay",
	2235:  "sercomm-wlink",
	2236:  "nani",
	2237:  "optech-port1-lm",
	2238:  "aviva-sna",
	2239:  "imagequery",
	2240:  "recipe",
	2241:  "ivsd",
	2242:  "foliocorp",
	2243:  "magicom",
	2244:  "nmsserver",
	2245:  "hao",
	2246:  "pc-mta-addrmap",
	2247:  "antidotemgrsvr",
	2248:  "ums",
	2249:  "rfmp",
	2250:  "remote-collab",
	2251:  "dif-port",
	2252:  "njenet-ssl",
	2253:  "dtv-chan-req",
	2254:  "seispoc",
	2255:  "vrtp",
	2256:  "pcc-mfp",
	2257:  "simple-tx-rx",
	2258:  "rcts",
	2260:  "apc-2260",
	2261:  "comotionmaster",
	2262:  "comotionback",
	2263:  "ecwcfg",
	2264:  "apx500api-1",
	2265:  "apx500api-2",
	2266:  "mfserver",
	2267:  "ontobroker",
	2268:  "amt",
	2269:  "mikey",
	2270:  "starschool",
	2271:  "mmcals",
	2272:  "mmcal",
	2273:  "mysql-im",
	2274:  "pcttunnell",
	2275:  "ibridge-data",
	2276:  "ibridge-mgmt",
	2277:  "bluectrlproxy",
	2278:  "s3db",
	2279:  "xmquery",
	2280:  "lnvpoller",
	2281:  "lnvconsole",
	2282:  "lnvalarm",
	2283:  "lnvstatus",
	2284:  "lnvmaps",
	2285:  "lnvmailmon",
	2286:  "nas-metering",
	2287:  "dna",
	2288:  "netml",
	2289:  "dict-lookup",
	2290:  "sonus-logging",
	2291:  "eapsp",
	2292:  "mib-streaming",
	2293:  "npdbgmngr",
	2294:  "konshus-lm",
	2295:  "advant-lm",
	2296:  "theta-lm",
	2297:  "d2k-datamover1",
	2298:  "d2k-datamover2",
	2299:  "pc-telecommute",
	2300:  "cvmmon",
	2301:  "cpq-wbem",
	2302:  "binderysupport",
	2303:  "proxy-gateway",
	2304:  "attachmate-uts",
	2305:  "mt-scaleserver",
	2306:  "tappi-boxnet",
	2307:  "pehelp",
	2308:  "sdhelp",
	2309:  "sdserver",
	2310:  "sdclient",
	2311:  "messageservice",
	2312:  "wanscaler",
	2313:  "iapp",
	2314:  "cr-websystems",
	2315:  "precise-sft",
	2316:  "sent-lm",
	2317:  "attachmate-g32",
	2318:  "cadencecontrol",
	2319:  "infolibria",
	2320:  "siebel-ns",
	2321:  "rdlap",
	2322:  "ofsd",
	2323:  "3d-nfsd",
	2324:  "cosmocall",
	2325:  "ansysli",
	2326:  "idcp",
	2327:  "xingcsm",
	2328:  "netrix-sftm",
	2329:  "nvd",
	2330:  "tscchat",
	2331:  "agentview",
	2332:  "rcc-host",
	2333:  "snapp",
	2334:  "ace-client",
	2335:  "ace-proxy",
	2336:  "appleugcontrol",
	2337:  "ideesrv",
	2338:  "norton-lambert",
	2339:  "3com-webview",
	2340:  "wrs-registry",
	2341:  "xiostatus",
	2342:  "manage-exec",
	2343:  "nati-logos",
	2344:  "fcmsys",
	2345:  "dbm",
	2346:  "redstorm-join",
	2347:  "redstorm-find",
	2348:  "redstorm-info",
	2349:  "redstorm-diag",
	2350:  "psbserver",
	2351:  "psrserver",
	2352:  "pslserver",
	2353:  "pspserver",
	2354:  "psprserver",
	2355:  "psdbserver",
	2356:  "gxtelmd",
	2357:  "unihub-server",
	2358:  "futrix",
	2359:  "flukeserver",
	2360:  "nexstorindltd",
	2361:  "tl1",
	2362:  "digiman",
	2363:  "mediacntrlnfsd",
	2364:  "oi-2000",
	2365:  "dbref",
	2366:  "qip-login",
	2367:  "service-ctrl",
	2368:  "opentable",
	2370:  "l3-hbmon",
	2371:  "hp-rda",
	2372:  "lanmessenger",
	2373:  "remographlm",
	2374:  "hydra",
	2375:  "docker",
	2376:  "docker-s",
	2379:  "etcd-client",
	2380:  "etcd-server",
	2381:  "compaq-https",
	2382:  "ms-olap3",
	2383:  "ms-olap4",
	2384:  "sd-request",
	2385:  "sd-data",
	2386:  "virtualtape",
	2387:  "vsamredirector",
	2388:  "mynahautostart",
	2389:  "ovsessionmgr",
	2390:  "rsmtp",
	2391:  "3com-net-mgmt",
	2392:  "tacticalauth",
	2393:  "ms-olap1",
	2394:  "ms-olap2",
	2395:  "lan900-remote",
	2396:  "wusage",
	2397:  "ncl",
	2398:  "orbiter",
	2399:  "fmpro-fdal",
	2400:  "opequus-server",
	2401:  "cvspserver",
	2402:  "taskmaster2000",
	2403:  "taskmaster2000",
	2404:  "iec-104",
	2405:  "trc-netpoll",
	2406:  "jediserver",
	2407:  "orion",
	2408:  "railgun-webaccl",
	2409:  "sns-protocol",
	2410:  "vrts-registry",
	2411:  "netwave-ap-mgmt",
	2412:  "cdn",
	2413:  "orion-rmi-reg",
	2414:  "beeyond",
	2415:  "codima-rtp",
	2416:  "rmtserver",
	2417:  "composit-server",
	2418:  "cas",
	2419:  "attachmate-s2s",
	2420:  "dslremote-mgmt",
	2421:  "g-talk",
	2422:  "crmsbits",
	2423:  "rnrp",
	2424:  "kofax-svr",
	2425:  "fjitsuappmgr",
	2427:  "mgcp-gateway",
	2428:  "ott",
	2429:  "ft-role",
	2430:  "venus",
	2431:  "venus-se",
	2432:  "codasrv",
	2433:  "codasrv-se",
	2434:  "pxc-epmap",
	2435:  "optilogic",
	2436:  "topx",
	2437:  "unicontrol",
	2438:  "msp",
	2439:  "sybasedbsynch",
	2440:  "spearway",
	2441:  "pvsw-inet",
	2442:  "netangel",
	2443:  "powerclientcsf",
	2444:  "btpp2sectrans",
	2445:  "dtn1",
	2446:  "bues-service",
	2447:  "ovwdb",
	2448:  "hpppssvr",
	2449:  "ratl",
	2450:  "netadmin",
	2451:  "netchat",
	2452:  "snifferclient",
	2453:  "madge-ltd",
	2454:  "indx-dds",
	2455:  "wago-io-system",
	2456:  "altav-remmgt",
	2457:  "rapido-ip",
	2458:  "griffin",
	2459:  "community",
	2460:  "ms-theater",
	2461:  "qadmifoper",
	2462:  "qadmifevent",
	2463:  "lsi-raid-mgmt",
	2464:  "direcpc-si",
	2465:  "lbm",
	2466:  "lbf",
	2467:  "high-criteria",
	2468:  "qip-msgd",
	2469:  "mti-tcs-comm",
	2470:  "taskman-port",
	2471:  "seaodbc",
	2472:  "c3",
	2473:  "aker-cdp",
	2474:  "vitalanalysis",
	2475:  "ace-server",
	2476:  "ace-svr-prop",
	2477:  "ssm-cvs",
	2478:  "ssm-cssps",
	2479:  "ssm-els",
	2480:  "powerexchange",
	2481:  "giop",
	2482:  "giop-ssl",
	2483:  "ttc",
	2484:  "ttc-ssl",
	2485:  "netobjects1",
	2486:  "netobjects2",
	2487:  "pns",
	2488:  "moy-corp",
	2489:  "tsilb",
	2490:  "qip-qdhcp",
	2491:  "conclave-cpp",
	2492:  "groove",
	2493:  "talarian-mqs",
	2494:  "bmc-ar",
	2495:  "fast-rem-serv",
	2496:  "dirgis",
	2497:  "quaddb",
	2498:  "odn-castraq",
	2499:  "unicontrol",
	2500:  "rtsserv",
	2501:  "rtsclient",
	2502:  "kentrox-prot",
	2503:  "nms-dpnss",
	2504:  "wlbs",
	2505:  "ppcontrol",
	2506:  "jbroker",
	2507:  "spock",
	2508:  "jdatastore",
	2509:  "fjmpss",
	2510:  "fjappmgrbulk",
	2511:  "metastorm",
	2512:  "citrixima",
	2513:  "citrixadmin",
	2514:  "facsys-ntp",
	2515:  "facsys-router",
	2516:  "maincontrol",
	2517:  "call-sig-trans",
	2518:  "willy",
	2519:  "globmsgsvc",
	2520:  "pvsw",
	2521:  "adaptecmgr",
	2522:  "windb",
	2523:  "qke-llc-v3",
	2524:  "optiwave-lm",
	2525:  "ms-v-worlds",
	2526:  "ema-sent-lm",
	2527:  "iqserver",
	2528:  "ncr-ccl",
	2529:  "utsftp",
	2530:  "vrcommerce",
	2531:  "ito-e-gui",
	2532:  "ovtopmd",
	2533:  "snifferserver",
	2534:  "combox-web-acc",
	2535:  "madcap",
	2536:  "btpp2audctr1",
	2537:  "upgrade",
	2538:  "vnwk-prapi",
	2539:  "vsiadmin",
	2540:  "lonworks",
	2541:  "lonworks2",
	2542:  "udrawgraph",
	2543:  "reftek",
	2544:  "novell-zen",
	2545:  "sis-emt",
	2546:  "vytalvaultbrtp",
	2547:  "vytalvaultvsmp",
	2548:  "vytalvaultpipe",
	2549:  "ipass",
	2550:  "ads",
	2551:  "isg-uda-server",
	2552:  "call-logging",
	2553:  "efidiningport",
	2554:  "vcnet-link-v10",
	2555:  "compaq-wcp",
	2556:  "nicetec-nmsvc",
	2557:  "nicetec-mgmt",
	2558:  "pclemultimedia",
	2559:  "lstp",
	2560:  "labrat",
	2561:  "mosaixcc",
	2562:  "delibo",
	2563:  "cti-redwood",
	2564:  "hp-3000-telnet",
	2565:  "coord-svr",
	2566:  "pcs-pcw",
	2567:  "clp",
	2568:  "spamtrap",
	2569:  "sonuscallsig",
	2570:  "hs-port",
	2571:  "cecsvc",
	2572:  "ibp",
	2573:  "trustestablish",
	2574:  "blockade-bpsp",
	2575:  "hl7",
	2576:  "tclprodebugger",
	2577:  "scipticslsrvr",
	2578:  "rvs-isdn-dcp",
	2579:  "mpfoncl",
	2580:  "tributary",
	2581:  "argis-te",
	2582:  "argis-ds",
	2583:  "mon",
	2584:  "cyaserv",
	2585:  "netx-server",
	2586:  "netx-agent",
	2587:  "masc",
	2588:  "privilege",
	2589:  "quartus-tcl",
	2590:  "idotdist",
	2591:  "maytagshuffle",
	2592:  "netrek",
	2593:  "mns-mail",
	2594:  "dts",
	2595:  "worldfusion1",
	2596:  "worldfusion2",
	2597:  "homesteadglory",
	2598:  "citriximaclient",
	2599:  "snapd",
	2600:  "hpstgmgr",
	2601:  "discp-client",
	2602:  "discp-server",
	2603:  "servicemeter",
	2604:  "nsc-ccs",
	2605:  "nsc-posa",
	2606:  "netmon",
	2607:  "connection",
	2608:  "wag-service",
	2609:  "system-monitor",
	2610:  "versa-tek",
	2611:  "lionhead",
	2612:  "qpasa-agent",
	2613:  "smntubootstrap",
	2614:  "neveroffline",
	2615:  "firepower",
	2616:  "appswitch-emp",
	2617:  "cmadmin",
	2618:  "priority-e-com",
	2619:  "bruce",
	2620:  "lpsrecommender",
	2621:  "miles-apart",
	2622:  "metricadbc",
	2623:  "lmdp",
	2624:  "aria",
	2625:  "blwnkl-port",
	2626:  "gbjd816",
	2627:  "moshebeeri",
	2628:  "dict",
	2629:  "sitaraserver",
	2630:  "sitaramgmt",
	2631:  "sitaradir",
	2632:  "irdg-post",
	2633:  "interintelli",
	2634:  "pk-electronics",
	2635:  "backburner",
	2636:  "solve",
	2637:  "imdocsvc",
	2638:  "sybaseanywhere",
	2639:  "aminet",
	2640:  "sai-sentlm",
	2641:  "hdl-srv",
	2642:  "tragic",
	2643:  "gte-samp",
	2644:  "travsoft-ipx-t",
	2645:  "novell-ipx-cmd",
	2646:  "and-lm",
	2647:  "syncserver",
	2648:  "upsnotifyprot",
	2649:  "vpsipport",
	2650:  "eristwoguns",
	2651:  "ebinsite",
	2652:  "interpathpanel",
	2653:  "sonus",
	2654:  "corel-vncadmin",
	2655:  "unglue",
	2656:  "kana",
	2657:  "sns-dispatcher",
	2658:  "sns-admin",
	2659:  "sns-query",
	2660:  "gcmonitor",
	2661:  "olhost",
	2662:  "bintec-capi",
	2663:  "bintec-tapi",
	2664:  "patrol-mq-gm",
	2665:  "patrol-mq-nm",
	2666:  "extensis",
	2667:  "alarm-clock-s",
	2668:  "alarm-clock-c",
	2669:  "toad",
	2670:  "tve-announce",
	2671:  "newlixreg",
	2672:  "nhserver",
	2673:  "firstcall42",
	2674:  "ewnn",
	2675:  "ttc-etap",
	2676:  "simslink",
	2677:  "gadgetgate1way",
	2678:  "gadgetgate2way",
	2679:  "syncserverssl",
	2680:  "pxc-sapxom",
	2681:  "mpnjsomb",
	2683:  "ncdloadbalance",
	2684:  "mpnjsosv",
	2685:  "mpnjsocl",
	2686:  "mpnjsomg",
	2687:  "pq-lic-mgmt",
	2688:  "md-cg-http",
	2689:  "fastlynx",
	2690:  "hp-nnm-data",
	2691:  "itinternet",
	2692:  "admins-lms",
	2694:  "pwrsevent",
	2695:  "vspread",
	2696:  "unifyadmin",
	2697:  "oce-snmp-trap",
	2698:  "mck-ivpip",
	2699:  "csoft-plusclnt",
	2700:  "tqdata",
	2701:  "sms-rcinfo",
	2702:  "sms-xfer",
	2703:  "sms-chat",
	2704:  "sms-remctrl",
	2705:  "sds-admin",
	2706:  "ncdmirroring",
	2707:  "emcsymapiport",
	2708:  "banyan-net",
	2709:  "supermon",
	2710:  "sso-service",
	2711:  "sso-control",
	2712:  "aocp",
	2713:  "raventbs",
	2714:  "raventdm",
	2715:  "hpstgmgr2",
	2716:  "inova-ip-disco",
	2717:  "pn-requester",
	2718:  "pn-requester2",
	2719:  "scan-change",
	2720:  "wkars",
	2721:  "smart-diagnose",
	2722:  "proactivesrvr",
	2723:  "watchdog-nt",
	2724:  "qotps",
	2725:  "msolap-ptp2",
	2726:  "tams",
	2727:  "mgcp-callagent",
	2728:  "sqdr",
	2729:  "tcim-control",
	2730:  "nec-raidplus",
	2731:  "fyre-messanger",
	2732:  "g5m",
	2733:  "signet-ctf",
	2734:  "ccs-software",
	2735:  "netiq-mc",
	2736:  "radwiz-nms-srv",
	2737:  "srp-feedback",
	2738:  "ndl-tcp-ois-gw",
	2739:  "tn-timing",
	2740:  "alarm",
	2741:  "tsb",
	2742:  "tsb2",
	2743:  "murx",
	2744:  "honyaku",
	2745:  "urbisnet",
	2746:  "cpudpencap",
	2747:  "fjippol-swrly",
	2748:  "fjippol-polsvr",
	2749:  "fjippol-cnsl",
	2750:  "fjippol-port1",
	2751:  "fjippol-port2",
	2752:  "rsisysaccess",
	2753:  "de-spot",
	2754:  "apollo-cc",
	2755:  "expresspay",
	2756:  "simplement-tie",
	2757:  "cnrp",
	2758:  "apollo-status",
	2759:  "apollo-gms",
	2760:  "sabams",
	2761:  "dicom-iscl",
	2762:  "dicom-tls",
	2763:  "desktop-dna",
	2764:  "data-insurance",
	2765:  "qip-audup",
	2766:  "compaq-scp",
	2767:  "uadtc",
	2768:  "uacs",
	2769:  "exce",
	2770:  "veronica",
	2771:  "vergencecm",
	2772:  "auris",
	2773:  "rbakcup1",
	2774:  "rbakcup2",
	2775:  "smpp",
	2776:  "ridgeway1",
	2777:  "ridgeway2",
	2778:  "gwen-sonya",
	2779:  "lbc-sync",
	2780:  "lbc-control",
	2781:  "whosells",
	2782:  "everydayrc",
	2783:  "aises",
	2784:  "www-dev",
	2785:  "aic-np",
	2786:  "aic-oncrpc",
	2787:  "piccolo",
	2788:  "fryeserv",
	2789:  "media-agent",
	2790:  "plgproxy",
	2791:  "mtport-regist",
	2792:  "f5-globalsite",
	2793:  "initlsmsad",
	2795:  "livestats",
	2796:  "ac-tech",
	2797:  "esp-encap",
	2798:  "tmesis-upshot",
	2799:  "icon-discover",
	2800:  "acc-raid",
	2801:  "igcp",
	2802:  "veritas-tcp1",
	2803:  "btprjctrl",
	2804:  "dvr-esm",
	2805:  "wta-wsp-s",
	2806:  "cspuni",
	2807:  "cspmulti",
	2808:  "j-lan-p",
	2809:  "corbaloc",
	2810:  "netsteward",
	2811:  "gsiftp",
	2812:  "atmtcp",
	2813:  "llm-pass",
	2814:  "llm-csv",
	2815:  "lbc-measure",
	2816:  "lbc-watchdog",
	2817:  "nmsigport",
	2818:  "rmlnk",
	2819:  "fc-faultnotify",
	2820:  "univision",
	2821:  "vrts-at-port",
	2822:  "ka0wuc",
	2823:  "cqg-netlan",
	2824:  "cqg-netlan-1",
	2826:  "slc-systemlog",
	2827:  "slc-ctrlrloops",
	2828:  "itm-lm",
	2829:  "silkp1",
	2830:  "silkp2",
	2831:  "silkp3",
	2832:  "silkp4",
	2833:  "glishd",
	2834:  "evtp",
	2835:  "evtp-data",
	2836:  "catalyst",
	2837:  "repliweb",
	2838:  "starbot",
	2839:  "nmsigport",
	2840:  "l3-exprt",
	2841:  "l3-ranger",
	2842:  "l3-hawk",
	2843:  "pdnet",
	2844:  "bpcp-poll",
	2845:  "bpcp-trap",
	2846:  "aimpp-hello",
	2847:  "aimpp-port-req",
	2848:  "amt-blc-port",
	2849:  "fxp",
	2850:  "metaconsole",
	2851:  "webemshttp",
	2852:  "bears-01",
	2853:  "ispipes",
	2854:  "infomover",
	2855:  "msrp",
	2856:  "cesdinv",
	2857:  "simctlp",
	2858:  "ecnp",
	2859:  "activememory",
	2860:  "dialpad-voice1",
	2861:  "dialpad-voice2",
	2862:  "ttg-protocol",
	2863:  "sonardata",
	2864:  "astromed-main",
	2865:  "pit-vpn",
	2866:  "iwlistener",
	2867:  "esps-portal",
	2868:  "npep-messaging",
	2869:  "icslap",
	2870:  "daishi",
	2871:  "msi-selectplay",
	2872:  "radix",
	2874:  "dxmessagebase1",
	2875:  "dxmessagebase2",
	2876:  "sps-tunnel",
	2877:  "bluelance",
	2878:  "aap",
	2879:  "ucentric-ds",
	2880:  "synapse",
	2881:  "ndsp",
	2882:  "ndtp",
	2883:  "ndnp",
	2884:  "flashmsg",
	2885:  "topflow",
	2886:  "responselogic",
	2887:  "aironetddp",
	2888:  "spcsdlobby",
	2889:  "rsom",
	2890:  "cspclmulti",
	2891:  "cinegrfx-elmd",
	2892:  "snifferdata",
	2893:  "vseconnector",
	2894:  "abacus-remote",
	2895:  "natuslink",
	2896:  "ecovisiong6-1",
	2897:  "citrix-rtmp",
	2898:  "appliance-cfg",
	2899:  "powergemplus",
	2900:  "quicksuite",
	2901:  "allstorcns",
	2902:  "netaspi",
	2903:  "suitcase",
	2904:  "m2ua",
	2905:  "m3ua",
	2906:  "caller9",
	2907:  "webmethods-b2b",
	2908:  "mao",
	2909:  "funk-dialout",
	2910:  "tdaccess",
	2911:  "blockade",
	2912:  "epicon",
	2913:  "boosterware",
	2914:  "gamelobby",
	2915:  "tksocket",
	2916:  "elvin-server",
	2917:  "elvin-client",
	2918:  "kastenchasepad",
	2919:  "roboer",
	2920:  "roboeda",
	2921:  "cesdcdman",
	2922:  "cesdcdtrn",
	2923:  "wta-wsp-wtp-s",
	2924:  "precise-vip",
	2926:  "mobile-file-dl",
	2927:  "unimobilectrl",
	2928:  "redstone-cpss",
	2929:  "amx-webadmin",
	2930:  "amx-weblinx",
	2931:  "circle-x",
	2932:  "incp",
	2933:  "4-tieropmgw",
	2934:  "4-tieropmcli",
	2935:  "qtp",
	2936:  "otpatch",
	2937:  "pnaconsult-lm",
	2938:  "sm-pas-1",
	2939:  "sm-pas-2",
	2940:  "sm-pas-3",
	2941:  "sm-pas-4",
	2942:  "sm-pas-5",
	2943:  "ttnrepository",
	2944:  "megaco-h248",
	2945:  "h248-binary",
	2946:  "fjsvmpor",
	2947:  "gpsd",
	2948:  "wap-push",
	2949:  "wap-pushsecure",
	2950:  "esip",
	2951:  "ottp",
	2952:  "mpfwsas",
	2953:  "ovalarmsrv",
	2954:  "ovalarmsrv-cmd",
	2955:  "csnotify",
	2956:  "ovrimosdbman",
	2957:  "jmact5",
	2958:  "jmact6",
	2959:  "rmopagt",
	2960:  "dfoxserver",
	2961:  "boldsoft-lm",
	2962:  "iph-policy-cli",
	2963:  "iph-policy-adm",
	2964:  "bullant-srap",
	2965:  "bullant-rap",
	2966:  "idp-infotrieve",
	2967:  "ssc-agent",
	2968:  "enpp",
	2969:  "essp",
	2970:  "index-net",
	2971:  "netclip",
	2972:  "pmsm-webrctl",
	2973:  "svnetworks",
	2974:  "signal",
	2975:  "fjmpcm",
	2976:  "cns-srv-port",
	2977:  "ttc-etap-ns",
	2978:  "ttc-etap-ds",
	2979:  "h263-video",
	2980:  "wimd",
	2981:  "mylxamport",
	2982:  "iwb-whiteboard",
	2983:  "netplan",
	2984:  "hpidsadmin",
	2985:  "hpidsagent",
	2986:  "stonefalls",
	2987:  "identify",
	2988:  "hippad",
	2989:  "zarkov",
	2990:  "boscap",
	2991:  "wkstn-mon",
	2992:  "avenyo",
	2993:  "veritas-vis1",
	2994:  "veritas-vis2",
	2995:  "idrs",
	2996:  "vsixml",
	2997:  "rebol",
	2998:  "realsecure",
	2999:  "remoteware-un",
	3000:  "hbci",
	3001:  "origo-native",
	3002:  "exlm-agent",
	3003:  "cgms",
	3004:  "csoftragent",
	3005:  "geniuslm",
	3006:  "ii-admin",
	3007:  "lotusmtap",
	3008:  "midnight-tech",
	3009:  "pxc-ntfy",
	3010:  "gw",
	3011:  "trusted-web",
	3012:  "twsdss",
	3013:  "gilatskysurfer",
	3014:  "broker-service",
	3015:  "nati-dstp",
	3016:  "notify-srvr",
	3017:  "event-listener",
	3018:  "srvc-registry",
	3019:  "resource-mgr",
	3020:  "cifs",
	3021:  "agriserver",
	3022:  "csregagent",
	3023:  "magicnotes",
	3024:  "nds-sso",
	3025:  "arepa-raft",
	3026:  "agri-gateway",
	3027:  "LiebDevMgmt-C",
	3028:  "LiebDevMgmt-DM",
	3029:  "LiebDevMgmt-A",
	3030:  "arepa-cas",
	3031:  "eppc",
	3032:  "redwood-chat",
	3033:  "pdb",
	3034:  "osmosis-aeea",
	3035:  "fjsv-gssagt",
	3036:  "hagel-dump",
	3037:  "hp-san-mgmt",
	3038:  "santak-ups",
	3039:  "cogitate",
	3040:  "tomato-springs",
	3041:  "di-traceware",
	3042:  "journee",
	3043:  "brp",
	3044:  "epp",
	3045:  "responsenet",
	3046:  "di-ase",
	3047:  "hlserver",
	3048:  "pctrader",
	3049:  "nsws",
	3050:  "gds-db",
	3051:  "galaxy-server",
	3052:  "apc-3052",
	3053:  "dsom-server",
	3054:  "amt-cnf-prot",
	3055:  "policyserver",
	3056:  "cdl-server",
	3057:  "goahead-fldup",
	3058:  "videobeans",
	3059:  "qsoft",
	3060:  "interserver",
	3061:  "cautcpd",
	3062:  "ncacn-ip-tcp",
	3063:  "ncadg-ip-udp",
	3064:  "rprt",
	3065:  "slinterbase",
	3066:  "netattachsdmp",
	3067:  "fjhpjp",
	3068:  "ls3bcast",
	3069:  "ls3",
	3070:  "mgxswitch",
	3071:  "csd-mgmt-port",
	3072:  "csd-monitor",
	3073:  "vcrp",
	3074:  "xbox",
	3075:  "orbix-locator",
	3076:  "orbix-config",
	3077:  "orbix-loc-ssl",
	3078:  "orbix-cfg-ssl",
	3079:  "lv-frontpanel",
	3080:  "stm-pproc",
	3081:  "tl1-lv",
	3082:  "tl1-raw",
	3083:  "tl1-telnet",
	3084:  "itm-mccs",
	3085:  "pcihreq",
	3086:  "jdl-dbkitchen",
	3087:  "asoki-sma",
	3088:  "xdtp",
	3089:  "ptk-alink",
	3090:  "stss",
	3091:  "1ci-smcs",
	3093:  "rapidmq-center",
	3094:  "rapidmq-reg",
	3095:  "panasas",
	3096:  "ndl-aps",
	3098:  "umm-port",
	3099:  "chmd",
	3100:  "opcon-xps",
	3101:  "hp-pxpib",
	3102:  "slslavemon",
	3103:  "autocuesmi",
	3104:  "autocuelog",
	3105:  "cardbox",
	3106:  "cardbox-http",
	3107:  "business",
	3108:  "geolocate",
	3109:  "personnel",
	3110:  "sim-control",
	3111:  "wsynch",
	3112:  "ksysguard",
	3113:  "cs-auth-svr",
	3114:  "ccmad",
	3115:  "mctet-master",
	3116:  "mctet-gateway",
	3117:  "mctet-jserv",
	3118:  "pkagent",
	3119:  "d2000kernel",
	3120:  "d2000webserver",
	3121:  "pcmk-remote",
	3122:  "vtr-emulator",
	3123:  "edix",
	3124:  "beacon-port",
	3125:  "a13-an",
	3127:  "ctx-bridge",
	3128:  "ndl-aas",
	3129:  "netport-id",
	3130:  "icpv2",
	3131:  "netbookmark",
	3132:  "ms-rule-engine",
	3133:  "prism-deploy",
	3134:  "ecp",
	3135:  "peerbook-port",
	3136:  "grubd",
	3137:  "rtnt-1",
	3138:  "rtnt-2",
	3139:  "incognitorv",
	3140:  "ariliamulti",
	3141:  "vmodem",
	3142:  "rdc-wh-eos",
	3143:  "seaview",
	3144:  "tarantella",
	3145:  "csi-lfap",
	3146:  "bears-02",
	3147:  "rfio",
	3148:  "nm-game-admin",
	3149:  "nm-game-server",
	3150:  "nm-asses-admin",
	3151:  "nm-assessor",
	3152:  "feitianrockey",
	3153:  "s8-client-port",
	3154:  "ccmrmi",
	3155:  "jpegmpeg",
	3156:  "indura",
	3157:  "e3consultants",
	3158:  "stvp",
	3159:  "navegaweb-port",
	3160:  "tip-app-server",
	3161:  "doc1lm",
	3162:  "sflm",
	3163:  "res-sap",
	3164:  "imprs",
	3165:  "newgenpay",
	3166:  "sossecollector",
	3167:  "nowcontact",
	3168:  "poweronnud",
	3169:  "serverview-as",
	3170:  "serverview-asn",
	3171:  "serverview-gf",
	3172:  "serverview-rm",
	3173:  "serverview-icc",
	3174:  "armi-server",
	3175:  "t1-e1-over-ip",
	3176:  "ars-master",
	3177:  "phonex-port",
	3178:  "radclientport",
	3179:  "h2gf-w-2m",
	3180:  "mc-brk-srv",
	3181:  "bmcpatrolagent",
	3182:  "bmcpatrolrnvu",
	3183:  "cops-tls",
	3184:  "apogeex-port",
	3185:  "smpppd",
	3186:  "iiw-port",
	3187:  "odi-port",
	3188:  "brcm-comm-port",
	3189:  "pcle-infex",
	3190:  "csvr-proxy",
	3191:  "csvr-sslproxy",
	3192:  "firemonrcc",
	3193:  "spandataport",
	3194:  "magbind",
	3195:  "ncu-1",
	3196:  "ncu-2",
	3197:  "embrace-dp-s",
	3198:  "embrace-dp-c",
	3199:  "dmod-workspace",
	3200:  "tick-port",
	3201:  "cpq-tasksmart",
	3202:  "intraintra",
	3203:  "netwatcher-mon",
	3204:  "netwatcher-db",
	3205:  "isns",
	3206:  "ironmail",
	3207:  "vx-auth-port",
	3208:  "pfu-prcallback",
	3209:  "netwkpathengine",
	3210:  "flamenco-proxy",
	3211:  "avsecuremgmt",
	3212:  "surveyinst",
	3213:  "neon24x7",
	3214:  "jmq-daemon-1",
	3215:  "jmq-daemon-2",
	3216:  "ferrari-foam",
	3217:  "unite",
	3218:  "smartpackets",
	3219:  "wms-messenger",
	3220:  "xnm-ssl",
	3221:  "xnm-clear-text",
	3222:  "glbp",
	3223:  "digivote",
	3224:  "aes-discovery",
	3225:  "fcip-port",
	3226:  "isi-irp",
	3227:  "dwnmshttp",
	3228:  "dwmsgserver",
	3229:  "global-cd-port",
	3230:  "sftdst-port",
	3231:  "vidigo",
	3232:  "mdtp",
	3233:  "whisker",
	3234:  "alchemy",
	3235:  "mdap-port",
	3236:  "apparenet-ts",
	3237:  "apparenet-tps",
	3238:  "apparenet-as",
	3239:  "apparenet-ui",
	3240:  "triomotion",
	3241:  "sysorb",
	3242:  "sdp-id-port",
	3243:  "timelot",
	3244:  "onesaf",
	3245:  "vieo-fe",
	3246:  "dvt-system",
	3247:  "dvt-data",
	3248:  "procos-lm",
	3249:  "ssp",
	3250:  "hicp",
	3251:  "sysscanner",
	3252:  "dhe",
	3253:  "pda-data",
	3254:  "pda-sys",
	3255:  "semaphore",
	3256:  "cpqrpm-agent",
	3257:  "cpqrpm-server",
	3258:  "ivecon-port",
	3259:  "epncdp2",
	3260:  "iscsi-target",
	3261:  "winshadow",
	3262:  "necp",
	3263:  "ecolor-imager",
	3264:  "ccmail",
	3265:  "altav-tunnel",
	3266:  "ns-cfg-server",
	3267:  "ibm-dial-out",
	3268:  "msft-gc",
	3269:  "msft-gc-ssl",
	3270:  "verismart",
	3271:  "csoft-prev",
	3272:  "user-manager",
	3273:  "sxmp",
	3274:  "ordinox-server",
	3275:  "samd",
	3276:  "maxim-asics",
	3277:  "awg-proxy",
	3278:  "lkcmserver",
	3279:  "admind",
	3280:  "vs-server",
	3281:  "sysopt",
	3282:  "datusorb",
	3283:  "Apple Remote Desktop (Net Assistant)",
	3284:  "4talk",
	3285:  "plato",
	3286:  "e-net",
	3287:  "directvdata",
	3288:  "cops",
	3289:  "enpc",
	3290:  "caps-lm",
	3291:  "sah-lm",
	3292:  "cart-o-rama",
	3293:  "fg-fps",
	3294:  "fg-gip",
	3295:  "dyniplookup",
	3296:  "rib-slm",
	3297:  "cytel-lm",
	3298:  "deskview",
	3299:  "pdrncs",
	3302:  "mcs-fastmail",
	3303:  "opsession-clnt",
	3304:  "opsession-srvr",
	3305:  "odette-ftp",
	3306:  "mysql",
	3307:  "opsession-prxy",
	3308:  "tns-server",
	3309:  "tns-adv",
	3310:  "dyna-access",
	3311:  "mcns-tel-ret",
	3312:  "appman-server",
	3313:  "uorb",
	3314:  "uohost",
	3315:  "cdid",
	3316:  "aicc-cmi",
	3317:  "vsaiport",
	3318:  "ssrip",
	3319:  "sdt-lmd",
	3320:  "officelink2000",
	3321:  "vnsstr",
	3326:  "sftu",
	3327:  "bbars",
	3328:  "egptlm",
	3329:  "hp-device-disc",
	3330:  "mcs-calypsoicf",
	3331:  "mcs-messaging",
	3332:  "mcs-mailsvr",
	3333:  "dec-notes",
	3334:  "directv-web",
	3335:  "directv-soft",
	3336:  "directv-tick",
	3337:  "directv-catlg",
	3338:  "anet-b",
	3339:  "anet-l",
	3340:  "anet-m",
	3341:  "anet-h",
	3342:  "webtie",
	3343:  "ms-cluster-net",
	3344:  "bnt-manager",
	3345:  "influence",
	3346:  "trnsprntproxy",
	3347:  "phoenix-rpc",
	3348:  "pangolin-laser",
	3349:  "chevinservices",
	3350:  "findviatv",
	3351:  "btrieve",
	3352:  "ssql",
	3353:  "fatpipe",
	3354:  "suitjd",
	3355:  "ordinox-dbase",
	3356:  "upnotifyps",
	3357:  "adtech-test",
	3358:  "mpsysrmsvr",
	3359:  "wg-netforce",
	3360:  "kv-server",
	3361:  "kv-agent",
	3362:  "dj-ilm",
	3363:  "nati-vi-server",
	3364:  "creativeserver",
	3365:  "contentserver",
	3366:  "creativepartnr",
	3372:  "tip2",
	3373:  "lavenir-lm",
	3374:  "cluster-disc",
	3375:  "vsnm-agent",
	3376:  "cdbroker",
	3377:  "cogsys-lm",
	3378:  "wsicopy",
	3379:  "socorfs",
	3380:  "sns-channels",
	3381:  "geneous",
	3382:  "fujitsu-neat",
	3383:  "esp-lm",
	3384:  "hp-clic",
	3385:  "qnxnetman",
	3386:  "gprs-data",
	3387:  "backroomnet",
	3388:  "cbserver",
	3389:  "ms-wbt-server",
	3390:  "dsc",
	3391:  "savant",
	3392:  "efi-lm",
	3393:  "d2k-tapestry1",
	3394:  "d2k-tapestry2",
	3395:  "dyna-lm",
	3396:  "printer-agent",
	3397:  "cloanto-lm",
	3398:  "mercantile",
	3399:  "csms",
	3400:  "csms2",
	3401:  "filecast",
	3402:  "fxaengine-net",
	3405:  "nokia-ann-ch1",
	3406:  "nokia-ann-ch2",
	3407:  "ldap-admin",
	3408:  "BESApi",
	3409:  "networklens",
	3410:  "networklenss",
	3411:  "biolink-auth",
	3412:  "xmlblaster",
	3413:  "svnet",
	3414:  "wip-port",
	3415:  "bcinameservice",
	3416:  "commandport",
	3417:  "csvr",
	3418:  "rnmap",
	3419:  "softaudit",
	3420:  "ifcp-port",
	3421:  "bmap",
	3422:  "rusb-sys-port",
	3423:  "xtrm",
	3424:  "xtrms",
	3425:  "agps-port",
	3426:  "arkivio",
	3427:  "websphere-snmp",
	3428:  "twcss",
	3429:  "gcsp",
	3430:  "ssdispatch",
	3431:  "ndl-als",
	3432:  "osdcp",
	3433:  "opnet-smp",
	3434:  "opencm",
	3435:  "pacom",
	3436:  "gc-config",
	3437:  "autocueds",
	3438:  "spiral-admin",
	3439:  "hri-port",
	3440:  "ans-console",
	3441:  "connect-client",
	3442:  "connect-server",
	3443:  "ov-nnm-websrv",
	3444:  "denali-server",
	3445:  "monp",
	3446:  "3comfaxrpc",
	3447:  "directnet",
	3448:  "dnc-port",
	3449:  "hotu-chat",
	3450:  "castorproxy",
	3451:  "asam",
	3452:  "sabp-signal",
	3453:  "pscupd",
	3454:  "mira",
	3455:  "prsvp",
	3456:  "vat",
	3457:  "vat-control",
	3458:  "d3winosfi",
	3459:  "integral",
	3460:  "edm-manager",
	3461:  "edm-stager",
	3462:  "edm-std-notify",
	3463:  "edm-adm-notify",
	3464:  "edm-mgr-sync",
	3465:  "edm-mgr-cntrl",
	3466:  "workflow",
	3467:  "rcst",
	3468:  "ttcmremotectrl",
	3469:  "pluribus",
	3470:  "jt400",
	3471:  "jt400-ssl",
	3472:  "jaugsremotec-1",
	3473:  "jaugsremotec-2",
	3474:  "ttntspauto",
	3475:  "genisar-port",
	3476:  "nppmp",
	3477:  "ecomm",
	3478:  "stun",
	3479:  "twrpc",
	3480:  "plethora",
	3481:  "cleanerliverc",
	3482:  "vulture",
	3483:  "slim-devices",
	3484:  "gbs-stp",
	3485:  "celatalk",
	3486:  "ifsf-hb-port",
	3487:  "ltctcp",
	3488:  "fs-rh-srv",
	3489:  "dtp-dia",
	3490:  "colubris",
	3491:  "swr-port",
	3492:  "tvdumtray-port",
	3493:  "nut",
	3494:  "ibm3494",
	3495:  "seclayer-tcp",
	3496:  "seclayer-tls",
	3497:  "ipether232port",
	3498:  "dashpas-port",
	3499:  "sccip-media",
	3500:  "rtmp-port",
	3501:  "isoft-p2p",
	3502:  "avinstalldisc",
	3503:  "lsp-ping",
	3504:  "ironstorm",
	3505:  "ccmcomm",
	3506:  "apc-3506",
	3507:  "nesh-broker",
	3508:  "interactionweb",
	3509:  "vt-ssl",
	3510:  "xss-port",
	3511:  "webmail-2",
	3512:  "aztec",
	3513:  "arcpd",
	3514:  "must-p2p",
	3515:  "must-backplane",
	3516:  "smartcard-port",
	3517:  "802-11-iapp",
	3518:  "artifact-msg",
	3519:  "nvmsgd",
	3520:  "galileolog",
	3521:  "mc3ss",
	3522:  "nssocketport",
	3523:  "odeumservlink",
	3524:  "ecmport",
	3525:  "eisport",
	3526:  "starquiz-port",
	3527:  "beserver-msg-q",
	3528:  "jboss-iiop",
	3529:  "jboss-iiop-ssl",
	3530:  "gf",
	3531:  "joltid",
	3532:  "raven-rmp",
	3533:  "raven-rdp",
	3534:  "urld-port",
	3535:  "ms-la",
	3536:  "snac",
	3537:  "ni-visa-remote",
	3538:  "ibm-diradm",
	3539:  "ibm-diradm-ssl",
	3540:  "pnrp-port",
	3541:  "voispeed-port",
	3542:  "hacl-monitor",
	3543:  "qftest-lookup",
	3544:  "teredo",
	3545:  "camac",
	3547:  "symantec-sim",
	3548:  "interworld",
	3549:  "tellumat-nms",
	3550:  "ssmpp",
	3551:  "apcupsd",
	3552:  "taserver",
	3553:  "rbr-discovery",
	3554:  "questnotify",
	3555:  "razor",
	3556:  "sky-transport",
	3557:  "personalos-001",
	3558:  "mcp-port",
	3559:  "cctv-port",
	3560:  "iniserve-port",
	3561:  "bmc-onekey",
	3562:  "sdbproxy",
	3563:  "watcomdebug",
	3564:  "esimport",
	3565:  "m2pa",
	3566:  "quest-data-hub",
	3567:  "enc-eps",
	3568:  "enc-tunnel-sec",
	3569:  "mbg-ctrl",
	3570:  "mccwebsvr-port",
	3571:  "megardsvr-port",
	3572:  "megaregsvrport",
	3573:  "tag-ups-1",
	3574:  "dmaf-server",
	3575:  "ccm-port",
	3576:  "cmc-port",
	3577:  "config-port",
	3578:  "data-port",
	3579:  "ttat3lb",
	3580:  "nati-svrloc",
	3581:  "kfxaclicensing",
	3582:  "press",
	3583:  "canex-watch",
	3584:  "u-dbap",
	3585:  "emprise-lls",
	3586:  "emprise-lsc",
	3587:  "p2pgroup",
	3588:  "sentinel",
	3589:  "isomair",
	3590:  "wv-csp-sms",
	3591:  "gtrack-server",
	3592:  "gtrack-ne",
	3593:  "bpmd",
	3594:  "mediaspace",
	3595:  "shareapp",
	3596:  "iw-mmogame",
	3597:  "a14",
	3598:  "a15",
	3599:  "quasar-server",
	3600:  "trap-daemon",
	3601:  "visinet-gui",
	3602:  "infiniswitchcl",
	3603:  "int-rcv-cntrl",
	3604:  "bmc-jmx-port",
	3605:  "comcam-io",
	3606:  "splitlock",
	3607:  "precise-i3",
	3608:  "trendchip-dcp",
	3609:  "cpdi-pidas-cm",
	3610:  "echonet",
	3611:  "six-degrees",
	3612:  "hp-dataprotect",
	3613:  "alaris-disc",
	3614:  "sigma-port",
	3615:  "start-network",
	3616:  "cd3o-protocol",
	3617:  "sharp-server",
	3618:  "aairnet-1",
	3619:  "aairnet-2",
	3620:  "ep-pcp",
	3621:  "ep-nsp",
	3622:  "ff-lr-port",
	3623:  "haipe-discover",
	3624:  "dist-upgrade",
	3625:  "volley",
	3626:  "bvcdaemon-port",
	3627:  "jamserverport",
	3628:  "ept-machine",
	3629:  "escvpnet",
	3630:  "cs-remote-db",
	3631:  "cs-services",
	3632:  "distcc",
	3633:  "wacp",
	3634:  "hlibmgr",
	3635:  "sdo",
	3636:  "servistaitsm",
	3637:  "scservp",
	3638:  "ehp-backup",
	3639:  "xap-ha",
	3640:  "netplay-port1",
	3641:  "netplay-port2",
	3642:  "juxml-port",
	3643:  "audiojuggler",
	3644:  "ssowatch",
	3645:  "cyc",
	3646:  "xss-srv-port",
	3647:  "splitlock-gw",
	3648:  "fjcp",
	3649:  "nmmp",
	3650:  "prismiq-plugin",
	3651:  "xrpc-registry",
	3652:  "vxcrnbuport",
	3653:  "tsp",
	3654:  "vaprtm",
	3655:  "abatemgr",
	3656:  "abatjss",
	3657:  "immedianet-bcn",
	3658:  "ps-ams",
	3659:  "apple-sasl",
	3660:  "can-nds-ssl",
	3661:  "can-ferret-ssl",
	3662:  "pserver",
	3663:  "dtp",
	3664:  "ups-engine",
	3665:  "ent-engine",
	3666:  "eserver-pap",
	3667:  "infoexch",
	3668:  "dell-rm-port",
	3669:  "casanswmgmt",
	3670:  "smile",
	3671:  "efcp",
	3672:  "lispworks-orb",
	3673:  "mediavault-gui",
	3674:  "wininstall-ipc",
	3675:  "calltrax",
	3676:  "va-pacbase",
	3677:  "roverlog",
	3678:  "ipr-dglt",
	3679:  "Escale (Newton Dock)",
	3680:  "npds-tracker",
	3681:  "bts-x73",
	3682:  "cas-mapi",
	3683:  "bmc-ea",
	3684:  "faxstfx-port",
	3685:  "dsx-agent",
	3686:  "tnmpv2",
	3687:  "simple-push",
	3688:  "simple-push-s",
	3689:  "daap",
	3690:  "svn",
	3691:  "magaya-network",
	3692:  "intelsync",
	3695:  "bmc-data-coll",
	3696:  "telnetcpcd",
	3697:  "nw-license",
	3698:  "sagectlpanel",
	3699:  "kpn-icw",
	3700:  "lrs-paging",
	3701:  "netcelera",
	3702:  "ws-discovery",
	3703:  "adobeserver-3",
	3704:  "adobeserver-4",
	3705:  "adobeserver-5",
	3706:  "rt-event",
	3707:  "rt-event-s",
	3708:  "sun-as-iiops",
	3709:  "ca-idms",
	3710:  "portgate-auth",
	3711:  "edb-server2",
	3712:  "sentinel-ent",
	3713:  "tftps",
	3714:  "delos-dms",
	3715:  "anoto-rendezv",
	3716:  "wv-csp-sms-cir",
	3717:  "wv-csp-udp-cir",
	3718:  "opus-services",
	3719:  "itelserverport",
	3720:  "ufastro-instr",
	3721:  "xsync",
	3722:  "xserveraid",
	3723:  "sychrond",
	3724:  "blizwow",
	3725:  "na-er-tip",
	3726:  "array-manager",
	3727:  "e-mdu",
	3728:  "e-woa",
	3729:  "fksp-audit",
	3730:  "client-ctrl",
	3731:  "smap",
	3732:  "m-wnn",
	3733:  "multip-msg",
	3734:  "synel-data",
	3735:  "pwdis",
	3736:  "rs-rmi",
	3737:  "xpanel",
	3738:  "versatalk",
	3739:  "launchbird-lm",
	3740:  "heartbeat",
	3741:  "wysdma",
	3742:  "cst-port",
	3743:  "ipcs-command",
	3744:  "sasg",
	3745:  "gw-call-port",
	3746:  "linktest",
	3747:  "linktest-s",
	3748:  "webdata",
	3749:  "cimtrak",
	3750:  "cbos-ip-port",
	3751:  "gprs-cube",
	3752:  "vipremoteagent",
	3753:  "nattyserver",
	3754:  "timestenbroker",
	3755:  "sas-remote-hlp",
	3756:  "canon-capt",
	3757:  "grf-port",
	3758:  "apw-registry",
	3759:  "exapt-lmgr",
	3760:  "adtempusclient",
	3761:  "gsakmp",
	3762:  "gbs-smp",
	3763:  "xo-wave",
	3764:  "mni-prot-rout",
	3765:  "rtraceroute",
	3766:  "sitewatch-s",
	3767:  "listmgr-port",
	3768:  "rblcheckd",
	3769:  "haipe-otnk",
	3770:  "cindycollab",
	3771:  "paging-port",
	3772:  "ctp",
	3773:  "ctdhercules",
	3774:  "zicom",
	3775:  "ispmmgr",
	3776:  "dvcprov-port",
	3777:  "jibe-eb",
	3778:  "c-h-it-port",
	3779:  "cognima",
	3780:  "nnp",
	3781:  "abcvoice-port",
	3782:  "iso-tp0s",
	3783:  "bim-pem",
	3784:  "bfd-control",
	3785:  "bfd-echo",
	3786:  "upstriggervsw",
	3787:  "fintrx",
	3788:  "isrp-port",
	3789:  "remotedeploy",
	3790:  "quickbooksrds",
	3791:  "tvnetworkvideo",
	3792:  "sitewatch",
	3793:  "dcsoftware",
	3794:  "jaus",
	3795:  "myblast",
	3796:  "spw-dialer",
	3797:  "idps",
	3798:  "minilock",
	3799:  "radius-dynauth",
	3800:  "pwgpsi",
	3801:  "ibm-mgr",
	3802:  "vhd",
	3803:  "soniqsync",
	3804:  "iqnet-port",
	3805:  "tcpdataserver",
	3806:  "wsmlb",
	3807:  "spugna",
	3808:  "sun-as-iiops-ca",
	3809:  "apocd",
	3810:  "wlanauth",
	3811:  "amp",
	3812:  "neto-wol-server",
	3813:  "rap-ip",
	3814:  "neto-dcs",
	3815:  "lansurveyorxml",
	3816:  "sunlps-http",
	3817:  "tapeware",
	3818:  "crinis-hb",
	3819:  "epl-slp",
	3820:  "scp",
	3821:  "pmcp",
	3822:  "acp-discovery",
	3823:  "acp-conduit",
	3824:  "acp-policy",
	3825:  "ffserver",
	3826:  "warmux",
	3827:  "netmpi",
	3828:  "neteh",
	3829:  "neteh-ext",
	3830:  "cernsysmgmtagt",
	3831:  "dvapps",
	3832:  "xxnetserver",
	3833:  "aipn-auth",
	3834:  "spectardata",
	3835:  "spectardb",
	3836:  "markem-dcp",
	3837:  "mkm-discovery",
	3838:  "sos",
	3839:  "amx-rms",
	3840:  "flirtmitmir",
	3841:  "shiprush-db-svr",
	3842:  "nhci",
	3843:  "quest-agent",
	3844:  "rnm",
	3845:  "v-one-spp",
	3846:  "an-pcp",
	3847:  "msfw-control",
	3848:  "item",
	3849:  "spw-dnspreload",
	3850:  "qtms-bootstrap",
	3851:  "spectraport",
	3852:  "sse-app-config",
	3853:  "sscan",
	3854:  "stryker-com",
	3855:  "opentrac",
	3856:  "informer",
	3857:  "trap-port",
	3858:  "trap-port-mom",
	3859:  "nav-port",
	3860:  "sasp",
	3861:  "winshadow-hd",
	3862:  "giga-pocket",
	3863:  "asap-tcp",
	3864:  "asap-tcp-tls",
	3865:  "xpl",
	3866:  "dzdaemon",
	3867:  "dzoglserver",
	3868:  "diameter",
	3869:  "ovsam-mgmt",
	3870:  "ovsam-d-agent",
	3871:  "avocent-adsap",
	3872:  "oem-agent",
	3873:  "fagordnc",
	3874:  "sixxsconfig",
	3875:  "pnbscada",
	3876:  "dl-agent",
	3877:  "xmpcr-interface",
	3878:  "fotogcad",
	3879:  "appss-lm",
	3880:  "igrs",
	3881:  "idac",
	3882:  "msdts1",
	3883:  "vrpn",
	3884:  "softrack-meter",
	3885:  "topflow-ssl",
	3886:  "nei-management",
	3887:  "ciphire-data",
	3888:  "ciphire-serv",
	3889:  "dandv-tester",
	3890:  "ndsconnect",
	3891:  "rtc-pm-port",
	3892:  "pcc-image-port",
	3893:  "cgi-starapi",
	3894:  "syam-agent",
	3895:  "syam-smc",
	3896:  "sdo-tls",
	3897:  "sdo-ssh",
	3898:  "senip",
	3899:  "itv-control",
	3900:  "udt-os",
	3901:  "nimsh",
	3902:  "nimaux",
	3903:  "charsetmgr",
	3904:  "omnilink-port",
	3905:  "mupdate",
	3906:  "topovista-data",
	3907:  "imoguia-port",
	3908:  "hppronetman",
	3909:  "surfcontrolcpa",
	3910:  "prnrequest",
	3911:  "prnstatus",
	3912:  "gbmt-stars",
	3913:  "listcrt-port",
	3914:  "listcrt-port-2",
	3915:  "agcat",
	3916:  "wysdmc",
	3917:  "aftmux",
	3918:  "pktcablemmcops",
	3919:  "hyperip",
	3920:  "exasoftport1",
	3921:  "herodotus-net",
	3922:  "sor-update",
	3923:  "symb-sb-port",
	3924:  "mpl-gprs-port",
	3925:  "zmp",
	3926:  "winport",
	3927:  "natdataservice",
	3928:  "netboot-pxe",
	3929:  "smauth-port",
	3930:  "syam-webserver",
	3931:  "msr-plugin-port",
	3932:  "dyn-site",
	3933:  "plbserve-port",
	3934:  "sunfm-port",
	3935:  "sdp-portmapper",
	3936:  "mailprox",
	3937:  "dvbservdsc",
	3938:  "dbcontrol-agent",
	3939:  "aamp",
	3940:  "xecp-node",
	3941:  "homeportal-web",
	3942:  "srdp",
	3943:  "tig",
	3944:  "sops",
	3945:  "emcads",
	3946:  "backupedge",
	3947:  "ccp",
	3948:  "apdap",
	3949:  "drip",
	3950:  "namemunge",
	3951:  "pwgippfax",
	3952:  "i3-sessionmgr",
	3953:  "xmlink-connect",
	3954:  "adrep",
	3955:  "p2pcommunity",
	3956:  "gvcp",
	3957:  "mqe-broker",
	3958:  "mqe-agent",
	3959:  "treehopper",
	3960:  "bess",
	3961:  "proaxess",
	3962:  "sbi-agent",
	3963:  "thrp",
	3964:  "sasggprs",
	3965:  "ati-ip-to-ncpe",
	3966:  "bflckmgr",
	3967:  "ppsms",
	3968:  "ianywhere-dbns",
	3969:  "landmarks",
	3970:  "lanrevagent",
	3971:  "lanrevserver",
	3972:  "iconp",
	3973:  "progistics",
	3974:  "citysearch",
	3975:  "airshot",
	3976:  "opswagent",
	3977:  "opswmanager",
	3978:  "secure-cfg-svr",
	3979:  "smwan",
	3980:  "acms",
	3981:  "starfish",
	3982:  "eis",
	3983:  "eisp",
	3984:  "mapper-nodemgr",
	3985:  "mapper-mapethd",
	3986:  "mapper-ws-ethd",
	3987:  "centerline",
	3988:  "dcs-config",
	3989:  "bv-queryengine",
	3990:  "bv-is",
	3991:  "bv-smcsrv",
	3992:  "bv-ds",
	3993:  "bv-agent",
	3995:  "iss-mgmt-ssl",
	3996:  "abcsoftware",
	3997:  "agentsease-db",
	3998:  "dnx",
	3999:  "nvcnet",
	4000:  "terabase",
	4001:  "newoak",
	4002:  "pxc-spvr-ft",
	4003:  "pxc-splr-ft",
	4004:  "pxc-roid",
	4005:  "pxc-pin",
	4006:  "pxc-spvr",
	4007:  "pxc-splr",
	4008:  "netcheque",
	4009:  "chimera-hwm",
	4010:  "samsung-unidex",
	4011:  "altserviceboot",
	4012:  "pda-gate",
	4013:  "acl-manager",
	4014:  "taiclock",
	4015:  "talarian-mcast1",
	4016:  "talarian-mcast2",
	4017:  "talarian-mcast3",
	4018:  "talarian-mcast4",
	4019:  "talarian-mcast5",
	4020:  "trap",
	4021:  "nexus-portal",
	4022:  "dnox",
	4023:  "esnm-zoning",
	4024:  "tnp1-port",
	4025:  "partimage",
	4026:  "as-debug",
	4027:  "bxp",
	4028:  "dtserver-port",
	4029:  "ip-qsig",
	4030:  "jdmn-port",
	4031:  "suucp",
	4032:  "vrts-auth-port",
	4033:  "sanavigator",
	4034:  "ubxd",
	4035:  "wap-push-http",
	4036:  "wap-push-https",
	4037:  "ravehd",
	4038:  "fazzt-ptp",
	4039:  "fazzt-admin",
	4040:  "yo-main",
	4041:  "houston",
	4042:  "ldxp",
	4043:  "nirp",
	4044:  "ltp",
	4045:  "npp",
	4046:  "acp-proto",
	4047:  "ctp-state",
	4049:  "wafs",
	4050:  "cisco-wafs",
	4051:  "cppdp",
	4052:  "interact",
	4053:  "ccu-comm-1",
	4054:  "ccu-comm-2",
	4055:  "ccu-comm-3",
	4056:  "lms",
	4057:  "wfm",
	4058:  "kingfisher",
	4059:  "dlms-cosem",
	4060:  "dsmeter-iatc",
	4061:  "ice-location",
	4062:  "ice-slocation",
	4063:  "ice-router",
	4064:  "ice-srouter",
	4065:  "avanti-cdp",
	4066:  "pmas",
	4067:  "idp",
	4068:  "ipfltbcst",
	4069:  "minger",
	4070:  "tripe",
	4071:  "aibkup",
	4072:  "zieto-sock",
	4073:  "iRAPP",
	4074:  "cequint-cityid",
	4075:  "perimlan",
	4076:  "seraph",
	4078:  "cssp",
	4079:  "santools",
	4080:  "lorica-in",
	4081:  "lorica-in-sec",
	4082:  "lorica-out",
	4083:  "lorica-out-sec",
	4085:  "ezmessagesrv",
	4087:  "applusservice",
	4088:  "npsp",
	4089:  "opencore",
	4090:  "omasgport",
	4091:  "ewinstaller",
	4092:  "ewdgs",
	4093:  "pvxpluscs",
	4094:  "sysrqd",
	4095:  "xtgui",
	4096:  "bre",
	4097:  "patrolview",
	4098:  "drmsfsd",
	4099:  "dpcp",
	4100:  "igo-incognito",
	4101:  "brlp-0",
	4102:  "brlp-1",
	4103:  "brlp-2",
	4104:  "brlp-3",
	4105:  "shofar",
	4106:  "synchronite",
	4107:  "j-ac",
	4108:  "accel",
	4109:  "izm",
	4110:  "g2tag",
	4111:  "xgrid",
	4112:  "apple-vpns-rp",
	4113:  "aipn-reg",
	4114:  "jomamqmonitor",
	4115:  "cds",
	4116:  "smartcard-tls",
	4117:  "hillrserv",
	4118:  "netscript",
	4119:  "assuria-slm",
	4121:  "e-builder",
	4122:  "fprams",
	4123:  "z-wave",
	4124:  "tigv2",
	4125:  "opsview-envoy",
	4126:  "ddrepl",
	4127:  "unikeypro",
	4128:  "nufw",
	4129:  "nuauth",
	4130:  "fronet",
	4131:  "stars",
	4132:  "nuts-dem",
	4133:  "nuts-bootp",
	4134:  "nifty-hmi",
	4135:  "cl-db-attach",
	4136:  "cl-db-request",
	4137:  "cl-db-remote",
	4138:  "nettest",
	4139:  "thrtx",
	4140:  "cedros-fds",
	4141:  "oirtgsvc",
	4142:  "oidocsvc",
	4143:  "oidsr",
	4145:  "vvr-control",
	4146:  "tgcconnect",
	4147:  "vrxpservman",
	4148:  "hhb-handheld",
	4149:  "agslb",
	4150:  "PowerAlert-nsa",
	4151:  "menandmice-noh",
	4152:  "idig-mux",
	4153:  "mbl-battd",
	4154:  "atlinks",
	4155:  "bzr",
	4156:  "stat-results",
	4157:  "stat-scanner",
	4158:  "stat-cc",
	4159:  "nss",
	4160:  "jini-discovery",
	4161:  "omscontact",
	4162:  "omstopology",
	4163:  "silverpeakpeer",
	4164:  "silverpeakcomm",
	4165:  "altcp",
	4166:  "joost",
	4167:  "ddgn",
	4168:  "pslicser",
	4169:  "iadt",
	4170:  "d-cinema-csp",
	4171:  "ml-svnet",
	4172:  "pcoip",
	4174:  "smcluster",
	4175:  "bccp",
	4176:  "tl-ipcproxy",
	4177:  "wello",
	4178:  "storman",
	4179:  "MaxumSP",
	4180:  "httpx",
	4181:  "macbak",
	4182:  "pcptcpservice",
	4183:  "gmmp",
	4184:  "universe-suite",
	4185:  "wcpp",
	4186:  "boxbackupstore",
	4187:  "csc-proxy",
	4188:  "vatata",
	4189:  "pcep",
	4190:  "sieve",
	4192:  "azeti",
	4193:  "pvxplusio",
	4199:  "eims-admin",
	4300:  "corelccam",
	4301:  "d-data",
	4302:  "d-data-control",
	4303:  "srcp",
	4304:  "owserver",
	4305:  "batman",
	4306:  "pinghgl",
	4307:  "visicron-vs",
	4308:  "compx-lockview",
	4309:  "dserver",
	4310:  "mirrtex",
	4311:  "p6ssmc",
	4312:  "pscl-mgt",
	4313:  "perrla",
	4314:  "choiceview-agt",
	4316:  "choiceview-clt",
	4320:  "fdt-rcatp",
	4321:  "rwhois",
	4322:  "trim-event",
	4323:  "trim-ice",
	4324:  "balour",
	4325:  "geognosisman",
	4326:  "geognosis",
	4327:  "jaxer-web",
	4328:  "jaxer-manager",
	4329:  "publiqare-sync",
	4330:  "dey-sapi",
	4331:  "ktickets-rest",
	4333:  "ahsp",
	4340:  "gaia",
	4341:  "lisp-data",
	4342:  "lisp-cons",
	4343:  "unicall",
	4344:  "vinainstall",
	4345:  "m4-network-as",
	4346:  "elanlm",
	4347:  "lansurveyor",
	4348:  "itose",
	4349:  "fsportmap",
	4350:  "net-device",
	4351:  "plcy-net-svcs",
	4352:  "pjlink",
	4353:  "f5-iquery",
	4354:  "qsnet-trans",
	4355:  "qsnet-workst",
	4356:  "qsnet-assist",
	4357:  "qsnet-cond",
	4358:  "qsnet-nucl",
	4359:  "omabcastltkm",
	4360:  "matrix-vnet",
	4368:  "wxbrief",
	4369:  "epmd",
	4370:  "elpro-tunnel",
	4371:  "l2c-control",
	4372:  "l2c-data",
	4373:  "remctl",
	4374:  "psi-ptt",
	4375:  "tolteces",
	4376:  "bip",
	4377:  "cp-spxsvr",
	4378:  "cp-spxdpy",
	4379:  "ctdb",
	4389:  "xandros-cms",
	4390:  "wiegand",
	4391:  "apwi-imserver",
	4392:  "apwi-rxserver",
	4393:  "apwi-rxspooler",
	4395:  "omnivisionesx",
	4396:  "fly",
	4400:  "ds-srv",
	4401:  "ds-srvr",
	4402:  "ds-clnt",
	4403:  "ds-user",
	4404:  "ds-admin",
	4405:  "ds-mail",
	4406:  "ds-slp",
	4407:  "nacagent",
	4408:  "slscc",
	4409:  "netcabinet-com",
	4410:  "itwo-server",
	4411:  "found",
	4425:  "netrockey6",
	4426:  "beacon-port-2",
	4427:  "drizzle",
	4428:  "omviserver",
	4429:  "omviagent",
	4430:  "rsqlserver",
	4431:  "wspipe",
	4432:  "l-acoustics",
	4433:  "vop",
	4442:  "saris",
	4443:  "pharos",
	4444:  "krb524",
	4445:  "upnotifyp",
	4446:  "n1-fwp",
	4447:  "n1-rmgmt",
	4448:  "asc-slmd",
	4449:  "privatewire",
	4450:  "camp",
	4451:  "ctisystemmsg",
	4452:  "ctiprogramload",
	4453:  "nssalertmgr",
	4454:  "nssagentmgr",
	4455:  "prchat-user",
	4456:  "prchat-server",
	4457:  "prRegister",
	4458:  "mcp",
	4484:  "hpssmgmt",
	4485:  "assyst-dr",
	4486:  "icms",
	4487:  "prex-tcp",
	4488:  "awacs-ice",
	4500:  "ipsec-nat-t",
	4535:  "ehs",
	4536:  "ehs-ssl",
	4537:  "wssauthsvc",
	4538:  "swx-gate",
	4545:  "worldscores",
	4546:  "sf-lm",
	4547:  "lanner-lm",
	4548:  "synchromesh",
	4549:  "aegate",
	4550:  "gds-adppiw-db",
	4551:  "ieee-mih",
	4552:  "menandmice-mon",
	4553:  "icshostsvc",
	4554:  "msfrs",
	4555:  "rsip",
	4556:  "dtn-bundle",
	4559:  "hylafax",
	4563:  "amahi-anywhere",
	4566:  "kwtc",
	4567:  "tram",
	4568:  "bmc-reporting",
	4569:  "iax",
	4570:  "deploymentmap",
	4590:  "rid",
	4591:  "l3t-at-an",
	4593:  "ipt-anri-anri",
	4594:  "ias-session",
	4595:  "ias-paging",
	4596:  "ias-neighbor",
	4597:  "a21-an-1xbs",
	4598:  "a16-an-an",
	4599:  "a17-an-an",
	4600:  "piranha1",
	4601:  "piranha2",
	4602:  "mtsserver",
	4603:  "menandmice-upg",
	4604:  "irp",
	4658:  "playsta2-app",
	4659:  "playsta2-lob",
	4660:  "smaclmgr",
	4661:  "kar2ouche",
	4662:  "oms",
	4663:  "noteit",
	4664:  "ems",
	4665:  "contclientms",
	4666:  "eportcomm",
	4667:  "mmacomm",
	4668:  "mmaeds",
	4669:  "eportcommdata",
	4670:  "light",
	4671:  "acter",
	4672:  "rfa",
	4673:  "cxws",
	4674:  "appiq-mgmt",
	4675:  "dhct-status",
	4676:  "dhct-alerts",
	4677:  "bcs",
	4678:  "traversal",
	4679:  "mgesupervision",
	4680:  "mgemanagement",
	4681:  "parliant",
	4682:  "finisar",
	4683:  "spike",
	4684:  "rfid-rp1",
	4685:  "autopac",
	4686:  "msp-os",
	4687:  "nst",
	4688:  "mobile-p2p",
	4689:  "altovacentral",
	4690:  "prelude",
	4691:  "mtn",
	4692:  "conspiracy",
	4700:  "netxms-agent",
	4701:  "netxms-mgmt",
	4702:  "netxms-sync",
	4703:  "npqes-test",
	4704:  "assuria-ins",
	4725:  "truckstar",
	4727:  "fcis",
	4728:  "capmux",
	4730:  "gearman",
	4731:  "remcap",
	4733:  "resorcs",
	4737:  "ipdr-sp",
	4738:  "solera-lpn",
	4739:  "ipfix",
	4740:  "ipfixs",
	4741:  "lumimgrd",
	4742:  "sicct",
	4743:  "openhpid",
	4744:  "ifsp",
	4745:  "fmp",
	4749:  "profilemac",
	4750:  "ssad",
	4751:  "spocp",
	4752:  "snap",
	4753:  "simon",
	4784:  "bfd-multi-ctl",
	4786:  "smart-install",
	4787:  "sia-ctrl-plane",
	4788:  "xmcp",
	4800:  "iims",
	4801:  "iwec",
	4802:  "ilss",
	4803:  "notateit",
	4827:  "htcp",
	4837:  "varadero-0",
	4838:  "varadero-1",
	4839:  "varadero-2",
	4840:  "opcua-tcp",
	4841:  "quosa",
	4842:  "gw-asv",
	4843:  "opcua-tls",
	4844:  "gw-log",
	4845:  "wcr-remlib",
	4846:  "contamac-icm",
	4847:  "wfc",
	4848:  "appserv-http",
	4849:  "appserv-https",
	4850:  "sun-as-nodeagt",
	4851:  "derby-repli",
	4867:  "unify-debug",
	4868:  "phrelay",
	4869:  "phrelaydbg",
	4870:  "cc-tracking",
	4871:  "wired",
	4876:  "tritium-can",
	4877:  "lmcs",
	4879:  "wsdl-event",
	4880:  "hislip",
	4883:  "wmlserver",
	4884:  "hivestor",
	4885:  "abbs",
	4894:  "lyskom",
	4899:  "radmin-port",
	4900:  "hfcs",
	4901:  "flr-agent",
	4902:  "magiccontrol",
	4912:  "lutap",
	4913:  "lutcp",
	4914:  "bones",
	4915:  "frcs",
	4940:  "eq-office-4940",
	4941:  "eq-office-4941",
	4942:  "eq-office-4942",
	4949:  "munin",
	4950:  "sybasesrvmon",
	4951:  "pwgwims",
	4952:  "sagxtsds",
	4953:  "dbsyncarbiter",
	4969:  "ccss-qmm",
	4970:  "ccss-qsm",
	4984:  "webyast",
	4985:  "gerhcs",
	4986:  "mrip",
	4987:  "smar-se-port1",
	4988:  "smar-se-port2",
	4989:  "parallel",
	4990:  "busycal",
	4991:  "vrt",
	4999:  "hfcs-manager",
	5000:  "commplex-main",
	5001:  "commplex-link",
	5002:  "rfe",
	5003:  "fmpro-internal",
	5004:  "avt-profile-1",
	5005:  "avt-profile-2",
	5006:  "wsm-server",
	5007:  "wsm-server-ssl",
	5008:  "synapsis-edge",
	5009:  "winfs",
	5010:  "telelpathstart",
	5011:  "telelpathattack",
	5012:  "nsp",
	5013:  "fmpro-v6",
	5015:  "fmwp",
	5020:  "zenginkyo-1",
	5021:  "zenginkyo-2",
	5022:  "mice",
	5023:  "htuilsrv",
	5024:  "scpi-telnet",
	5025:  "scpi-raw",
	5026:  "strexec-d",
	5027:  "strexec-s",
	5028:  "qvr",
	5029:  "infobright",
	5030:  "surfpass",
	5032:  "signacert-agent",
	5042:  "asnaacceler8db",
	5043:  "swxadmin",
	5044:  "lxi-evntsvc",
	5045:  "osp",
	5048:  "texai",
	5049:  "ivocalize",
	5050:  "mmcc",
	5051:  "ita-agent",
	5052:  "ita-manager",
	5053:  "rlm",
	5054:  "rlm-admin",
	5055:  "unot",
	5056:  "intecom-ps1",
	5057:  "intecom-ps2",
	5059:  "sds",
	5060:  "sip",
	5061:  "sips",
	5062:  "na-localise",
	5063:  "csrpc",
	5064:  "ca-1",
	5065:  "ca-2",
	5066:  "stanag-5066",
	5067:  "authentx",
	5068:  "bitforestsrv",
	5069:  "i-net-2000-npr",
	5070:  "vtsas",
	5071:  "powerschool",
	5072:  "ayiya",
	5073:  "tag-pm",
	5074:  "alesquery",
	5075:  "pvaccess",
	5080:  "onscreen",
	5081:  "sdl-ets",
	5082:  "qcp",
	5083:  "qfp",
	5084:  "llrp",
	5085:  "encrypted-llrp",
	5086:  "aprigo-cs",
	5087:  "biotic",
	5093:  "sentinel-lm",
	5094:  "hart-ip",
	5099:  "sentlm-srv2srv",
	5100:  "socalia",
	5101:  "talarian-tcp",
	5102:  "oms-nonsecure",
	5103:  "actifio-c2c",
	5106:  "actifioudsagent",
	5111:  "taep-as-svc",
	5112:  "pm-cmdsvr",
	5114:  "ev-services",
	5115:  "autobuild",
	5117:  "gradecam",
	5120:  "barracuda-bbs",
	5133:  "nbt-pc",
	5134:  "ppactivation",
	5135:  "erp-scale",
	5137:  "ctsd",
	5145:  "rmonitor-secure",
	5146:  "social-alarm",
	5150:  "atmp",
	5151:  "esri-sde",
	5152:  "sde-discovery",
	5153:  "toruxserver",
	5154:  "bzflag",
	5155:  "asctrl-agent",
	5156:  "rugameonline",
	5157:  "mediat",
	5161:  "snmpssh",
	5162:  "snmpssh-trap",
	5163:  "sbackup",
	5164:  "vpa",
	5165:  "ife-icorp",
	5166:  "winpcs",
	5167:  "scte104",
	5168:  "scte30",
	5172:  "pcoip-mgmt",
	5190:  "aol",
	5191:  "aol-1",
	5192:  "aol-2",
	5193:  "aol-3",
	5194:  "cpscomm",
	5195:  "ampl-lic",
	5196:  "ampl-tableproxy",
	5200:  "targus-getdata",
	5201:  "targus-getdata1",
	5202:  "targus-getdata2",
	5203:  "targus-getdata3",
	5209:  "nomad",
	5215:  "noteza",
	5221:  "3exmp",
	5222:  "xmpp-client",
	5223:  "hpvirtgrp",
	5224:  "hpvirtctrl",
	5225:  "hp-server",
	5226:  "hp-status",
	5227:  "perfd",
	5228:  "hpvroom",
	5229:  "jaxflow",
	5230:  "jaxflow-data",
	5231:  "crusecontrol",
	5232:  "csedaemon",
	5233:  "enfs",
	5234:  "eenet",
	5235:  "galaxy-network",
	5236:  "padl2sim",
	5237:  "mnet-discovery",
	5245:  "downtools",
	5248:  "caacws",
	5249:  "caaclang2",
	5250:  "soagateway",
	5251:  "caevms",
	5252:  "movaz-ssc",
	5253:  "kpdp",
	5264:  "3com-njack-1",
	5265:  "3com-njack-2",
	5269:  "xmpp-server",
	5270:  "cartographerxmp",
	5271:  "cuelink",
	5272:  "pk",
	5280:  "xmpp-bosh",
	5281:  "undo-lm",
	5282:  "transmit-port",
	5298:  "presence",
	5299:  "nlg-data",
	5300:  "hacl-hb",
	5301:  "hacl-gs",
	5302:  "hacl-cfg",
	5303:  "hacl-probe",
	5304:  "hacl-local",
	5305:  "hacl-test",
	5306:  "sun-mc-grp",
	5307:  "sco-aip",
	5308:  "cfengine",
	5309:  "jprinter",
	5310:  "outlaws",
	5312:  "permabit-cs",
	5313:  "rrdp",
	5314:  "opalis-rbt-ipc",
	5315:  "hacl-poll",
	5316:  "hpbladems",
	5317:  "hpdevms",
	5318:  "pkix-cmc",
	5320:  "bsfserver-zn",
	5321:  "bsfsvr-zn-ssl",
	5343:  "kfserver",
	5344:  "xkotodrcp",
	5349:  "stuns",
	5352:  "dns-llq",
	5353:  "mdns",
	5354:  "mdnsresponder",
	5355:  "llmnr",
	5356:  "ms-smlbiz",
	5357:  "wsdapi",
	5358:  "wsdapi-s",
	5359:  "ms-alerter",
	5360:  "ms-sideshow",
	5361:  "ms-s-sideshow",
	5362:  "serverwsd2",
	5363:  "net-projection",
	5397:  "stresstester",
	5398:  "elektron-admin",
	5399:  "securitychase",
	5400:  "excerpt",
	5401:  "excerpts",
	5402:  "mftp",
	5403:  "hpoms-ci-lstn",
	5404:  "hpoms-dps-lstn",
	5405:  "netsupport",
	5406:  "systemics-sox",
	5407:  "foresyte-clear",
	5408:  "foresyte-sec",
	5409:  "salient-dtasrv",
	5410:  "salient-usrmgr",
	5411:  "actnet",
	5412:  "continuus",
	5413:  "wwiotalk",
	5414:  "statusd",
	5415:  "ns-server",
	5416:  "sns-gateway",
	5417:  "sns-agent",
	5418:  "mcntp",
	5419:  "dj-ice",
	5420:  "cylink-c",
	5421:  "netsupport2",
	5422:  "salient-mux",
	5423:  "virtualuser",
	5424:  "beyond-remote",
	5425:  "br-channel",
	5426:  "devbasic",
	5427:  "sco-peer-tta",
	5428:  "telaconsole",
	5429:  "base",
	5430:  "radec-corp",
	5431:  "park-agent",
	5432:  "postgresql",
	5433:  "pyrrho",
	5434:  "sgi-arrayd",
	5435:  "sceanics",
	5443:  "spss",
	5445:  "smbdirect",
	5453:  "surebox",
	5454:  "apc-5454",
	5455:  "apc-5455",
	5456:  "apc-5456",
	5461:  "silkmeter",
	5462:  "ttl-publisher",
	5463:  "ttlpriceproxy",
	5464:  "quailnet",
	5465:  "netops-broker",
	5500:  "fcp-addr-srvr1",
	5501:  "fcp-addr-srvr2",
	5502:  "fcp-srvr-inst1",
	5503:  "fcp-srvr-inst2",
	5504:  "fcp-cics-gw1",
	5505:  "checkoutdb",
	5506:  "amc",
	5553:  "sgi-eventmond",
	5554:  "sgi-esphttp",
	5555:  "personal-agent",
	5556:  "freeciv",
	5557:  "farenet",
	5566:  "westec-connect",
	5567:  "enc-eps-mc-sec",
	5568:  "sdt",
	5569:  "rdmnet-ctrl",
	5573:  "sdmmp",
	5574:  "lsi-bobcat",
	5575:  "ora-oap",
	5579:  "fdtracks",
	5580:  "tmosms0",
	5581:  "tmosms1",
	5582:  "fac-restore",
	5583:  "tmo-icon-sync",
	5584:  "bis-web",
	5585:  "bis-sync",
	5586:  "att-mt-sms",
	5597:  "ininmessaging",
	5598:  "mctfeed",
	5599:  "esinstall",
	5600:  "esmmanager",
	5601:  "esmagent",
	5602:  "a1-msc",
	5603:  "a1-bs",
	5604:  "a3-sdunode",
	5605:  "a4-sdunode",
	5618:  "efr",
	5627:  "ninaf",
	5628:  "htrust",
	5629:  "symantec-sfdb",
	5630:  "precise-comm",
	5631:  "pcanywheredata",
	5632:  "pcanywherestat",
	5633:  "beorl",
	5634:  "xprtld",
	5635:  "sfmsso",
	5636:  "sfm-db-server",
	5637:  "cssc",
	5638:  "flcrs",
	5639:  "ics",
	5646:  "vfmobile",
	5670:  "filemq",
	5671:  "amqps",
	5672:  "amqp",
	5673:  "jms",
	5674:  "hyperscsi-port",
	5675:  "v5ua",
	5676:  "raadmin",
	5677:  "questdb2-lnchr",
	5678:  "rrac",
	5679:  "dccm",
	5680:  "auriga-router",
	5681:  "ncxcp",
	5688:  "ggz",
	5689:  "qmvideo",
	5693:  "rbsystem",
	5696:  "kmip",
	5713:  "proshareaudio",
	5714:  "prosharevideo",
	5715:  "prosharedata",
	5716:  "prosharerequest",
	5717:  "prosharenotify",
	5718:  "dpm",
	5719:  "dpm-agent",
	5720:  "ms-licensing",
	5721:  "dtpt",
	5722:  "msdfsr",
	5723:  "omhs",
	5724:  "omsdk",
	5725:  "ms-ilm",
	5726:  "ms-ilm-sts",
	5727:  "asgenf",
	5728:  "io-dist-data",
	5729:  "openmail",
	5730:  "unieng",
	5741:  "ida-discover1",
	5742:  "ida-discover2",
	5743:  "watchdoc-pod",
	5744:  "watchdoc",
	5745:  "fcopy-server",
	5746:  "fcopys-server",
	5747:  "tunatic",
	5748:  "tunalyzer",
	5750:  "rscd",
	5755:  "openmailg",
	5757:  "x500ms",
	5766:  "openmailns",
	5767:  "s-openmail",
	5768:  "openmailpxy",
	5769:  "spramsca",
	5770:  "spramsd",
	5771:  "netagent",
	5777:  "dali-port",
	5780:  "vts-rpc",
	5781:  "3par-evts",
	5782:  "3par-mgmt",
	5783:  "3par-mgmt-ssl",
	5785:  "3par-rcopy",
	5793:  "xtreamx",
	5813:  "icmpd",
	5814:  "spt-automation",
	5841:  "shiprush-d-ch",
	5842:  "reversion",
	5859:  "wherehoo",
	5863:  "ppsuitemsg",
	5868:  "diameters",
	5883:  "jute",
	5900:  "rfb",
	5910:  "cm",
	5911:  "cpdlc",
	5912:  "fis",
	5913:  "ads-c",
	5963:  "indy",
	5968:  "mppolicy-v5",
	5969:  "mppolicy-mgr",
	5984:  "couchdb",
	5985:  "wsman",
	5986:  "wsmans",
	5987:  "wbem-rmi",
	5988:  "wbem-http",
	5989:  "wbem-https",
	5990:  "wbem-exp-https",
	5991:  "nuxsl",
	5992:  "consul-insight",
	5999:  "cvsup",
	6064:  "ndl-ahp-svc",
	6065:  "winpharaoh",
	6066:  "ewctsp",
	6068:  "gsmp-ancp",
	6069:  "trip",
	6070:  "messageasap",
	6071:  "ssdtp",
	6072:  "diagnose-proc",
	6073:  "directplay8",
	6074:  "max",
	6075:  "dpm-acm",
	6076:  "msft-dpm-cert",
	6077:  "iconstructsrv",
	6084:  "reload-config",
	6085:  "konspire2b",
	6086:  "pdtp",
	6087:  "ldss",
	6088:  "doglms",
	6099:  "raxa-mgmt",
	6100:  "synchronet-db",
	6101:  "synchronet-rtc",
	6102:  "synchronet-upd",
	6103:  "rets",
	6104:  "dbdb",
	6105:  "primaserver",
	6106:  "mpsserver",
	6107:  "etc-control",
	6108:  "sercomm-scadmin",
	6109:  "globecast-id",
	6110:  "softcm",
	6111:  "spc",
	6112:  "dtspcd",
	6113:  "dayliteserver",
	6114:  "wrspice",
	6115:  "xic",
	6116:  "xtlserv",
	6117:  "daylitetouch",
	6121:  "spdy",
	6122:  "bex-webadmin",
	6123:  "backup-express",
	6124:  "pnbs",
	6130:  "damewaremobgtwy",
	6133:  "nbt-wol",
	6140:  "pulsonixnls",
	6141:  "meta-corp",
	6142:  "aspentec-lm",
	6143:  "watershed-lm",
	6144:  "statsci1-lm",
	6145:  "statsci2-lm",
	6146:  "lonewolf-lm",
	6147:  "montage-lm",
	6148:  "ricardo-lm",
	6149:  "tal-pod",
	6159:  "efb-aci",
	6160:  "ecmp",
	6161:  "patrol-ism",
	6162:  "patrol-coll",
	6163:  "pscribe",
	6200:  "lm-x",
	6222:  "radmind",
	6241:  "jeol-nsdtp-1",
	6242:  "jeol-nsdtp-2",
	6243:  "jeol-nsdtp-3",
	6244:  "jeol-nsdtp-4",
	6251:  "tl1-raw-ssl",
	6252:  "tl1-ssh",
	6253:  "crip",
	6267:  "gld",
	6268:  "grid",
	6269:  "grid-alt",
	6300:  "bmc-grx",
	6301:  "bmc-ctd-ldap",
	6306:  "ufmp",
	6315:  "scup",
	6316:  "abb-escp",
	6317:  "nav-data-cmd",
	6320:  "repsvc",
	6321:  "emp-server1",
	6322:  "emp-server2",
	6324:  "hrd-ncs",
	6325:  "dt-mgmtsvc",
	6326:  "dt-vra",
	6343:  "sflow",
	6344:  "streletz",
	6346:  "gnutella-svc",
	6347:  "gnutella-rtr",
	6350:  "adap",
	6355:  "pmcs",
	6360:  "metaedit-mu",
	6370:  "metaedit-se",
	6382:  "metatude-mds",
	6389:  "clariion-evr01",
	6390:  "metaedit-ws",
	6417:  "faxcomservice",
	6418:  "syserverremote",
	6419:  "svdrp",
	6420:  "nim-vdrshell",
	6421:  "nim-wan",
	6432:  "pgbouncer",
	6442:  "tarp",
	6443:  "sun-sr-https",
	6444:  "sge-qmaster",
	6445:  "sge-execd",
	6446:  "mysql-proxy",
	6455:  "skip-cert-recv",
	6456:  "skip-cert-send",
	6471:  "lvision-lm",
	6480:  "sun-sr-http",
	6481:  "servicetags",
	6482:  "ldoms-mgmt",
	6483:  "SunVTS-RMI",
	6484:  "sun-sr-jms",
	6485:  "sun-sr-iiop",
	6486:  "sun-sr-iiops",
	6487:  "sun-sr-iiop-aut",
	6488:  "sun-sr-jmx",
	6489:  "sun-sr-admin",
	6500:  "boks",
	6501:  "boks-servc",
	6502:  "boks-servm",
	6503:  "boks-clntd",
	6505:  "badm-priv",
	6506:  "badm-pub",
	6507:  "bdir-priv",
	6508:  "bdir-pub",
	6509:  "mgcs-mfp-port",
	6510:  "mcer-port",
	6513:  "netconf-tls",
	6514:  "syslog-tls",
	6515:  "elipse-rec",
	6543:  "lds-distrib",
	6544:  "lds-dump",
	6547:  "apc-6547",
	6548:  "apc-6548",
	6549:  "apc-6549",
	6550:  "fg-sysupdate",
	6551:  "sum",
	6558:  "xdsxdm",
	6566:  "sane-port",
	6568:  "canit-store",
	6579:  "affiliate",
	6580:  "parsec-master",
	6581:  "parsec-peer",
	6582:  "parsec-game",
	6583:  "joaJewelSuite",
	6600:  "mshvlm",
	6601:  "mstmg-sstp",
	6602:  "wsscomfrmwk",
	6619:  "odette-ftps",
	6620:  "kftp-data",
	6621:  "kftp",
	6622:  "mcftp",
	6623:  "ktelnet",
	6624:  "datascaler-db",
	6625:  "datascaler-ctl",
	6626:  "wago-service",
	6627:  "nexgen",
	6628:  "afesc-mc",
	6632:  "mxodbc-connect",
	6640:  "ovsdb",
	6653:  "openflow",
	6655:  "pcs-sf-ui-man",
	6656:  "emgmsg",
	6670:  "vocaltec-gold",
	6671:  "p4p-portal",
	6672:  "vision-server",
	6673:  "vision-elmd",
	6678:  "vfbp",
	6679:  "osaut",
	6687:  "clever-ctrace",
	6688:  "clever-tcpip",
	6689:  "tsa",
	6697:  "ircs-u",
	6701:  "kti-icad-srvr",
	6702:  "e-design-net",
	6703:  "e-design-web",
	6714:  "ibprotocol",
	6715:  "fibotrader-com",
	6716:  "printercare-cc",
	6767:  "bmc-perf-agent",
	6768:  "bmc-perf-mgrd",
	6769:  "adi-gxp-srvprt",
	6770:  "plysrv-http",
	6771:  "plysrv-https",
	6777:  "ntz-tracker",
	6778:  "ntz-p2p-storage",
	6785:  "dgpf-exchg",
	6786:  "smc-jmx",
	6787:  "smc-admin",
	6788:  "smc-http",
	6789:  "smc-https",
	6790:  "hnmp",
	6791:  "hnm",
	6801:  "acnet",
	6817:  "pentbox-sim",
	6831:  "ambit-lm",
	6841:  "netmo-default",
	6842:  "netmo-http",
	6850:  "iccrushmore",
	6868:  "acctopus-cc",
	6888:  "muse",
	6901:  "jetstream",
	6935:  "ethoscan",
	6936:  "xsmsvc",
	6946:  "bioserver",
	6951:  "otlp",
	6961:  "jmact3",
	6962:  "jmevt2",
	6963:  "swismgr1",
	6964:  "swismgr2",
	6965:  "swistrap",
	6966:  "swispol",
	6969:  "acmsoda",
	6997:  "MobilitySrv",
	6998:  "iatp-highpri",
	6999:  "iatp-normalpri",
	7000:  "afs3-fileserver",
	7001:  "afs3-callback",
	7002:  "afs3-prserver",
	7003:  "afs3-vlserver",
	7004:  "afs3-kaserver",
	7005:  "afs3-volser",
	7006:  "afs3-errors",
	7007:  "afs3-bos",
	7008:  "afs3-update",
	7009:  "afs3-rmtsys",
	7010:  "ups-onlinet",
	7011:  "talon-disc",
	7012:  "talon-engine",
	7013:  "microtalon-dis",
	7014:  "microtalon-com",
	7015:  "talon-webserver",
	7018:  "fisa-svc",
	7019:  "doceri-ctl",
	7020:  "dpserve",
	7021:  "dpserveadmin",
	7022:  "ctdp",
	7023:  "ct2nmcs",
	7024:  "vmsvc",
	7025:  "vmsvc-2",
	7030:  "op-probe",
	7031:  "iposplanet",
	7070:  "arcp",
	7071:  "iwg1",
	7073:  "martalk",
	7080:  "empowerid",
	7099:  "lazy-ptop",
	7100:  "font-service",
	7101:  "elcn",
	7121:  "virprot-lm",
	7128:  "scenidm",
	7129:  "scenccs",
	7161:  "cabsm-comm",
	7162:  "caistoragemgr",
	7163:  "cacsambroker",
	7164:  "fsr",
	7165:  "doc-server",
	7166:  "aruba-server",
	7167:  "casrmagent",
	7168:  "cnckadserver",
	7169:  "ccag-pib",
	7170:  "nsrp",
	7171:  "drm-production",
	7172:  "metalbend",
	7173:  "zsecure",
	7174:  "clutild",
	7200:  "fodms",
	7201:  "dlip",
	7227:  "ramp",
	7228:  "citrixupp",
	7229:  "citrixuppg",
	7236:  "display",
	7237:  "pads",
	7262:  "cnap",
	7272:  "watchme-7272",
	7273:  "oma-rlp",
	7274:  "oma-rlp-s",
	7275:  "oma-ulp",
	7276:  "oma-ilp",
	7277:  "oma-ilp-s",
	7278:  "oma-dcdocbs",
	7279:  "ctxlic",
	7280:  "itactionserver1",
	7281:  "itactionserver2",
	7282:  "mzca-action",
	7283:  "genstat",
	7365:  "lcm-server",
	7391:  "mindfilesys",
	7392:  "mrssrendezvous",
	7393:  "nfoldman",
	7394:  "fse",
	7395:  "winqedit",
	7397:  "hexarc",
	7400:  "rtps-discovery",
	7401:  "rtps-dd-ut",
	7402:  "rtps-dd-mt",
	7410:  "ionixnetmon",
	7411:  "daqstream",
	7421:  "mtportmon",
	7426:  "pmdmgr",
	7427:  "oveadmgr",
	7428:  "ovladmgr",
	7429:  "opi-sock",
	7430:  "xmpv7",
	7431:  "pmd",
	7437:  "faximum",
	7443:  "oracleas-https",
	7471:  "sttunnel",
	7473:  "rise",
	7474:  "neo4j",
	7491:  "telops-lmd",
	7500:  "silhouette",
	7501:  "ovbus",
	7508:  "adcp",
	7509:  "acplt",
	7510:  "ovhpas",
	7511:  "pafec-lm",
	7542:  "saratoga",
	7543:  "atul",
	7544:  "nta-ds",
	7545:  "nta-us",
	7546:  "cfs",
	7547:  "cwmp",
	7548:  "tidp",
	7549:  "nls-tl",
	7560:  "sncp",
	7563:  "cfw",
	7566:  "vsi-omega",
	7569:  "dell-eql-asm",
	7570:  "aries-kfinder",
	7574:  "coherence",
	7588:  "sun-lm",
	7624:  "indi",
	7626:  "simco",
	7627:  "soap-http",
	7628:  "zen-pawn",
	7629:  "xdas",
	7630:  "hawk",
	7631:  "tesla-sys-msg",
	7633:  "pmdfmgt",
	7648:  "cuseeme",
	7672:  "imqstomp",
	7673:  "imqstomps",
	7674:  "imqtunnels",
	7675:  "imqtunnel",
	7676:  "imqbrokerd",
	7677:  "sun-user-https",
	7680:  "pando-pub",
	7689:  "collaber",
	7697:  "klio",
	7700:  "em7-secom",
	7707:  "sync-em7",
	7708:  "scinet",
	7720:  "medimageportal",
	7724:  "nsdeepfreezectl",
	7725:  "nitrogen",
	7726:  "freezexservice",
	7727:  "trident-data",
	7734:  "smip",
	7738:  "aiagent",
	7741:  "scriptview",
	7742:  "msss",
	7743:  "sstp-1",
	7744:  "raqmon-pdu",
	7747:  "prgp",
	7777:  "cbt",
	7778:  "interwise",
	7779:  "vstat",
	7781:  "accu-lmgr",
	7786:  "minivend",
	7787:  "popup-reminders",
	7789:  "office-tools",
	7794:  "q3ade",
	7797:  "pnet-conn",
	7798:  "pnet-enc",
	7799:  "altbsdp",
	7800:  "asr",
	7801:  "ssp-client",
	7810:  "rbt-wanopt",
	7845:  "apc-7845",
	7846:  "apc-7846",
	7847:  "csoauth",
	7869:  "mobileanalyzer",
	7870:  "rbt-smc",
	7871:  "mdm",
	7878:  "owms",
	7880:  "pss",
	7887:  "ubroker",
	7900:  "mevent",
	7901:  "tnos-sp",
	7902:  "tnos-dp",
	7903:  "tnos-dps",
	7913:  "qo-secure",
	7932:  "t2-drm",
	7933:  "t2-brm",
	7962:  "generalsync",
	7967:  "supercell",
	7979:  "micromuse-ncps",
	7980:  "quest-vista",
	7981:  "sossd-collect",
	7982:  "sossd-agent",
	7997:  "pushns",
	7999:  "irdmi2",
	8000:  "irdmi",
	8001:  "vcom-tunnel",
	8002:  "teradataordbms",
	8003:  "mcreport",
	8005:  "mxi",
	8008:  "http-alt",
	8019:  "qbdb",
	8020:  "intu-ec-svcdisc",
	8021:  "intu-ec-client",
	8022:  "oa-system",
	8025:  "ca-audit-da",
	8026:  "ca-audit-ds",
	8032:  "pro-ed",
	8033:  "mindprint",
	8034:  "vantronix-mgmt",
	8040:  "ampify",
	8042:  "fs-agent",
	8043:  "fs-server",
	8044:  "fs-mgmt",
	8051:  "rocrail",
	8052:  "senomix01",
	8053:  "senomix02",
	8054:  "senomix03",
	8055:  "senomix04",
	8056:  "senomix05",
	8057:  "senomix06",
	8058:  "senomix07",
	8059:  "senomix08",
	8066:  "toad-bi-appsrvr",
	8074:  "gadugadu",
	8080:  "http-alt",
	8081:  "sunproxyadmin",
	8082:  "us-cli",
	8083:  "us-srv",
	8086:  "d-s-n",
	8087:  "simplifymedia",
	8088:  "radan-http",
	8091:  "jamlink",
	8097:  "sac",
	8100:  "xprint-server",
	8101:  "ldoms-migr",
	8102:  "kz-migr",
	8115:  "mtl8000-matrix",
	8116:  "cp-cluster",
	8117:  "purityrpc",
	8118:  "privoxy",
	8121:  "apollo-data",
	8122:  "apollo-admin",
	8128:  "paycash-online",
	8129:  "paycash-wbp",
	8130:  "indigo-vrmi",
	8131:  "indigo-vbcp",
	8132:  "dbabble",
	8148:  "isdd",
	8153:  "quantastor",
	8160:  "patrol",
	8161:  "patrol-snmp",
	8162:  "lpar2rrd",
	8181:  "intermapper",
	8182:  "vmware-fdm",
	8183:  "proremote",
	8184:  "itach",
	8191:  "limnerpressure",
	8192:  "spytechphone",
	8194:  "blp1",
	8195:  "blp2",
	8199:  "vvr-data",
	8200:  "trivnet1",
	8201:  "trivnet2",
	8204:  "lm-perfworks",
	8205:  "lm-instmgr",
	8206:  "lm-dta",
	8207:  "lm-sserver",
	8208:  "lm-webwatcher",
	8230:  "rexecj",
	8243:  "synapse-nhttps",
	8276:  "pando-sec",
	8280:  "synapse-nhttp",
	8292:  "blp3",
	8293:  "hiperscan-id",
	8294:  "blp4",
	8300:  "tmi",
	8301:  "amberon",
	8313:  "hub-open-net",
	8320:  "tnp-discover",
	8321:  "tnp",
	8351:  "server-find",
	8376:  "cruise-enum",
	8377:  "cruise-swroute",
	8378:  "cruise-config",
	8379:  "cruise-diags",
	8380:  "cruise-update",
	8383:  "m2mservices",
	8400:  "cvd",
	8401:  "sabarsd",
	8402:  "abarsd",
	8403:  "admind",
	8404:  "svcloud",
	8405:  "svbackup",
	8415:  "dlpx-sp",
	8416:  "espeech",
	8417:  "espeech-rtp",
	8442:  "cybro-a-bus",
	8443:  "pcsync-https",
	8444:  "pcsync-http",
	8445:  "copy",
	8450:  "npmp",
	8457:  "nexentamv",
	8470:  "cisco-avp",
	8471:  "pim-port",
	8472:  "otv",
	8473:  "vp2p",
	8474:  "noteshare",
	8500:  "fmtp",
	8501:  "cmtp-mgt",
	8502:  "ftnmtp",
	8554:  "rtsp-alt",
	8555:  "d-fence",
	8567:  "enc-tunnel",
	8600:  "asterix",
	8610:  "canon-mfnp",
	8611:  "canon-bjnp1",
	8612:  "canon-bjnp2",
	8613:  "canon-bjnp3",
	8614:  "canon-bjnp4",
	8615:  "imink",
	8665:  "monetra",
	8666:  "monetra-admin",
	8675:  "msi-cps-rm",
	8686:  "sun-as-jmxrmi",
	8688:  "openremote-ctrl",
	8699:  "vnyx",
	8711:  "nvc",
	8733:  "ibus",
	8750:  "dey-keyneg",
	8763:  "mc-appserver",
	8764:  "openqueue",
	8765:  "ultraseek-http",
	8766:  "amcs",
	8770:  "dpap",
	8778:  "uec",
	8786:  "msgclnt",
	8787:  "msgsrvr",
	8793:  "acd-pm",
	8800:  "sunwebadmin",
	8804:  "truecm",
	8873:  "dxspider",
	8880:  "cddbp-alt",
	8881:  "galaxy4d",
	8883:  "secure-mqtt",
	8888:  "ddi-tcp-1",
	8889:  "ddi-tcp-2",
	8890:  "ddi-tcp-3",
	8891:  "ddi-tcp-4",
	8892:  "ddi-tcp-5",
	8893:  "ddi-tcp-6",
	8894:  "ddi-tcp-7",
	8899:  "ospf-lite",
	8900:  "jmb-cds1",
	8901:  "jmb-cds2",
	8910:  "manyone-http",
	8911:  "manyone-xml",
	8912:  "wcbackup",
	8913:  "dragonfly",
	8937:  "twds",
	8953:  "ub-dns-control",
	8954:  "cumulus-admin",
	8989:  "sunwebadmins",
	8990:  "http-wmap",
	8991:  "https-wmap",
	8998:  "canto-roboflow",
	8999:  "bctp",
	9000:  "cslistener",
	9001:  "etlservicemgr",
	9002:  "dynamid",
	9008:  "ogs-server",
	9009:  "pichat",
	9010:  "sdr",
	9020:  "tambora",
	9021:  "panagolin-ident",
	9022:  "paragent",
	9023:  "swa-1",
	9024:  "swa-2",
	9025:  "swa-3",
	9026:  "swa-4",
	9050:  "versiera",
	9051:  "fio-cmgmt",
	9080:  "glrpc",
	9083:  "emc-pp-mgmtsvc",
	9084:  "aurora",
	9085:  "ibm-rsyscon",
	9086:  "net2display",
	9087:  "classic",
	9088:  "sqlexec",
	9089:  "sqlexec-ssl",
	9090:  "websm",
	9091:  "xmltec-xmlmail",
	9092:  "XmlIpcRegSvc",
	9093:  "copycat",
	9100:  "hp-pdl-datastr",
	9101:  "bacula-dir",
	9102:  "bacula-fd",
	9103:  "bacula-sd",
	9104:  "peerwire",
	9105:  "xadmin",
	9106:  "astergate",
	9107:  "astergatefax",
	9119:  "mxit",
	9122:  "grcmp",
	9123:  "grcp",
	9131:  "dddp",
	9160:  "apani1",
	9161:  "apani2",
	9162:  "apani3",
	9163:  "apani4",
	9164:  "apani5",
	9191:  "sun-as-jpda",
	9200:  "wap-wsp",
	9201:  "wap-wsp-wtp",
	9202:  "wap-wsp-s",
	9203:  "wap-wsp-wtp-s",
	9204:  "wap-vcard",
	9205:  "wap-vcal",
	9206:  "wap-vcard-s",
	9207:  "wap-vcal-s",
	9208:  "rjcdb-vcards",
	9209:  "almobile-system",
	9210:  "oma-mlp",
	9211:  "oma-mlp-s",
	9212:  "serverviewdbms",
	9213:  "serverstart",
	9214:  "ipdcesgbs",
	9215:  "insis",
	9216:  "acme",
	9217:  "fsc-port",
	9222:  "teamcoherence",
	9255:  "mon",
	9278:  "pegasus",
	9279:  "pegasus-ctl",
	9280:  "pgps",
	9281:  "swtp-port1",
	9282:  "swtp-port2",
	9283:  "callwaveiam",
	9284:  "visd",
	9285:  "n2h2server",
	9287:  "cumulus",
	9292:  "armtechdaemon",
	9293:  "storview",
	9294:  "armcenterhttp",
	9295:  "armcenterhttps",
	9300:  "vrace",
	9306:  "sphinxql",
	9312:  "sphinxapi",
	9318:  "secure-ts",
	9321:  "guibase",
	9343:  "mpidcmgr",
	9344:  "mphlpdmc",
	9346:  "ctechlicensing",
	9374:  "fjdmimgr",
	9380:  "boxp",
	9387:  "d2dconfig",
	9388:  "d2ddatatrans",
	9389:  "adws",
	9390:  "otp",
	9396:  "fjinvmgr",
	9397:  "mpidcagt",
	9400:  "sec-t4net-srv",
	9401:  "sec-t4net-clt",
	9402:  "sec-pc2fax-srv",
	9418:  "git",
	9443:  "tungsten-https",
	9444:  "wso2esb-console",
	9445:  "mindarray-ca",
	9450:  "sntlkeyssrvr",
	9500:  "ismserver",
	9535:  "mngsuite",
	9536:  "laes-bf",
	9555:  "trispen-sra",
	9592:  "ldgateway",
	9593:  "cba8",
	9594:  "msgsys",
	9595:  "pds",
	9596:  "mercury-disc",
	9597:  "pd-admin",
	9598:  "vscp",
	9599:  "robix",
	9600:  "micromuse-ncpw",
	9612:  "streamcomm-ds",
	9614:  "iadt-tls",
	9616:  "erunbook-agent",
	9617:  "erunbook-server",
	9618:  "condor",
	9628:  "odbcpathway",
	9629:  "uniport",
	9630:  "peoctlr",
	9631:  "peocoll",
	9640:  "pqsflows",
	9666:  "zoomcp",
	9667:  "xmms2",
	9668:  "tec5-sdctp",
	9694:  "client-wakeup",
	9695:  "ccnx",
	9700:  "board-roar",
	9747:  "l5nas-parchan",
	9750:  "board-voip",
	9753:  "rasadv",
	9762:  "tungsten-http",
	9800:  "davsrc",
	9801:  "sstp-2",
	9802:  "davsrcs",
	9875:  "sapv1",
	9876:  "sd",
	9888:  "cyborg-systems",
	9889:  "gt-proxy",
	9898:  "monkeycom",
	9900:  "iua",
	9909:  "domaintime",
	9911:  "sype-transport",
	9925:  "xybrid-cloud",
	9950:  "apc-9950",
	9951:  "apc-9951",
	9952:  "apc-9952",
	9953:  "acis",
	9954:  "hinp",
	9955:  "alljoyn-stm",
	9966:  "odnsp",
	9978:  "xybrid-rt",
	9987:  "dsm-scm-target",
	9988:  "nsesrvr",
	9990:  "osm-appsrvr",
	9991:  "osm-oev",
	9992:  "palace-1",
	9993:  "palace-2",
	9994:  "palace-3",
	9995:  "palace-4",
	9996:  "palace-5",
	9997:  "palace-6",
	9998:  "distinct32",
	9999:  "distinct",
	10000: "ndmp",
	10001: "scp-config",
	10002: "documentum",
	10003: "documentum-s",
	10004: "emcrmirccd",
	10005: "emcrmird",
	10006: "netapp-sync",
	10007: "mvs-capacity",
	10008: "octopus",
	10009: "swdtp-sv",
	10010: "rxapi",
	10050: "zabbix-agent",
	10051: "zabbix-trapper",
	10055: "qptlmd",
	10080: "amanda",
	10081: "famdc",
	10100: "itap-ddtp",
	10101: "ezmeeting-2",
	10102: "ezproxy-2",
	10103: "ezrelay",
	10104: "swdtp",
	10107: "bctp-server",
	10110: "nmea-0183",
	10113: "netiq-endpoint",
	10114: "netiq-qcheck",
	10115: "netiq-endpt",
	10116: "netiq-voipa",
	10117: "iqrm",
	10128: "bmc-perf-sd",
	10129: "bmc-gms",
	10160: "qb-db-server",
	10161: "snmptls",
	10162: "snmptls-trap",
	10200: "trisoap",
	10201: "rsms",
	10252: "apollo-relay",
	10260: "axis-wimp-port",
	10288: "blocks",
	10321: "cosir",
	10540: "MOS-lower",
	10541: "MOS-upper",
	10542: "MOS-aux",
	10543: "MOS-soap",
	10544: "MOS-soap-opt",
	10631: "printopia",
	10800: "gap",
	10805: "lpdg",
	10809: "nbd",
	10860: "helix",
	10880: "bveapi",
	10990: "rmiaux",
	11000: "irisa",
	11001: "metasys",
	11095: "weave",
	11103: "origo-sync",
	11104: "netapp-icmgmt",
	11105: "netapp-icdata",
	11106: "sgi-lk",
	11109: "sgi-dmfmgr",
	11110: "sgi-soap",
	11111: "vce",
	11112: "dicom",
	11161: "suncacao-snmp",
	11162: "suncacao-jmxmp",
	11163: "suncacao-rmi",
	11164: "suncacao-csa",
	11165: "suncacao-websvc",
	11172: "oemcacao-jmxmp",
	11173: "t5-straton",
	11174: "oemcacao-rmi",
	11175: "oemcacao-websvc",
	11201: "smsqp",
	11202: "dcsl-backup",
	11208: "wifree",
	11211: "memcache",
	11319: "imip",
	11320: "imip-channels",
	11321: "arena-server",
	11367: "atm-uhas",
	11371: "hkp",
	11489: "asgcypresstcps",
	11600: "tempest-port",
	11623: "emc-xsw-dconfig",
	11720: "h323callsigalt",
	11723: "emc-xsw-dcache",
	11751: "intrepid-ssl",
	11796: "lanschool",
	11876: "xoraya",
	11967: "sysinfo-sp",
	12000: "entextxid",
	12001: "entextnetwk",
	12002: "entexthigh",
	12003: "entextmed",
	12004: "entextlow",
	12005: "dbisamserver1",
	12006: "dbisamserver2",
	12007: "accuracer",
	12008: "accuracer-dbms",
	12010: "edbsrvr",
	12012: "vipera",
	12013: "vipera-ssl",
	12109: "rets-ssl",
	12121: "nupaper-ss",
	12168: "cawas",
	12172: "hivep",
	12300: "linogridengine",
	12302: "rads",
	12321: "warehouse-sss",
	12322: "warehouse",
	12345: "italk",
	12753: "tsaf",
	12865: "netperf",
	13160: "i-zipqd",
	13216: "bcslogc",
	13217: "rs-pias",
	13218: "emc-vcas-tcp",
	13223: "powwow-client",
	13224: "powwow-server",
	13400: "doip-data",
	13720: "bprd",
	13721: "bpdbm",
	13722: "bpjava-msvc",
	13724: "vnetd",
	13782: "bpcd",
	13783: "vopied",
	13785: "nbdb",
	13786: "nomdb",
	13818: "dsmcc-config",
	13819: "dsmcc-session",
	13820: "dsmcc-passthru",
	13821: "dsmcc-download",
	13822: "dsmcc-ccp",
	13823: "bmdss",
	13894: "ucontrol",
	13929: "dta-systems",
	13930: "medevolve",
	14000: "scotty-ft",
	14001: "sua",
	14033: "sage-best-com1",
	14034: "sage-best-com2",
	14141: "vcs-app",
	14142: "icpp",
	14145: "gcm-app",
	14149: "vrts-tdd",
	14150: "vcscmd",
	14154: "vad",
	14250: "cps",
	14414: "ca-web-update",
	14936: "hde-lcesrvr-1",
	14937: "hde-lcesrvr-2",
	15000: "hydap",
	15002: "onep-tls",
	15345: "xpilot",
	15363: "3link",
	15555: "cisco-snat",
	15660: "bex-xr",
	15740: "ptp",
	15999: "programmar",
	16000: "fmsas",
	16001: "fmsascon",
	16002: "gsms",
	16020: "jwpc",
	16021: "jwpc-bin",
	16161: "sun-sea-port",
	16162: "solaris-audit",
	16309: "etb4j",
	16310: "pduncs",
	16311: "pdefmns",
	16360: "netserialext1",
	16361: "netserialext2",
	16367: "netserialext3",
	16368: "netserialext4",
	16384: "connected",
	16619: "xoms",
	16900: "newbay-snc-mc",
	16950: "sgcip",
	16991: "intel-rci-mp",
	16992: "amt-soap-http",
	16993: "amt-soap-https",
	16994: "amt-redir-tcp",
	16995: "amt-redir-tls",
	17007: "isode-dua",
	17184: "vestasdlp",
	17185: "soundsvirtual",
	17219: "chipper",
	17220: "avtp",
	17221: "avdecc",
	17234: "integrius-stp",
	17235: "ssh-mgmt",
	17500: "db-lsp",
	17555: "ailith",
	17729: "ea",
	17754: "zep",
	17755: "zigbee-ip",
	17756: "zigbee-ips",
	17777: "sw-orion",
	18000: "biimenu",
	18104: "radpdf",
	18136: "racf",
	18181: "opsec-cvp",
	18182: "opsec-ufp",
	18183: "opsec-sam",
	18184: "opsec-lea",
	18185: "opsec-omi",
	18186: "ohsc",
	18187: "opsec-ela",
	18241: "checkpoint-rtm",
	18242: "iclid",
	18243: "clusterxl",
	18262: "gv-pf",
	18463: "ac-cluster",
	18634: "rds-ib",
	18635: "rds-ip",
	18769: "ique",
	18881: "infotos",
	18888: "apc-necmp",
	19000: "igrid",
	19007: "scintilla",
	19020: "j-link",
	19191: "opsec-uaa",
	19194: "ua-secureagent",
	19283: "keysrvr",
	19315: "keyshadow",
	19398: "mtrgtrans",
	19410: "hp-sco",
	19411: "hp-sca",
	19412: "hp-sessmon",
	19539: "fxuptp",
	19540: "sxuptp",
	19541: "jcp",
	19998: "iec-104-sec",
	19999: "dnp-sec",
	20000: "dnp",
	20001: "microsan",
	20002: "commtact-http",
	20003: "commtact-https",
	20005: "openwebnet",
	20013: "ss-idi",
	20014: "opendeploy",
	20034: "nburn-id",
	20046: "tmophl7mts",
	20048: "mountd",
	20049: "nfsrdma",
	20167: "tolfab",
	20202: "ipdtp-port",
	20222: "ipulse-ics",
	20480: "emwavemsg",
	20670: "track",
	20999: "athand-mmp",
	21000: "irtrans",
	21010: "notezilla-lan",
	21553: "rdm-tfs",
	21554: "dfserver",
	21590: "vofr-gateway",
	21800: "tvpm",
	21845: "webphone",
	21846: "netspeak-is",
	21847: "netspeak-cs",
	21848: "netspeak-acd",
	21849: "netspeak-cps",
	22000: "snapenetio",
	22001: "optocontrol",
	22002: "optohost002",
	22003: "optohost003",
	22004: "optohost004",
	22005: "optohost004",
	22125: "dcap",
	22128: "gsidcap",
	22222: "easyengine",
	22273: "wnn6",
	22305: "cis",
	22343: "cis-secure",
	22347: "wibukey",
	22350: "codemeter",
	22351: "codemeter-cmwan",
	22537: "caldsoft-backup",
	22555: "vocaltec-wconf",
	22763: "talikaserver",
	22800: "aws-brf",
	22951: "brf-gw",
	23000: "inovaport1",
	23001: "inovaport2",
	23002: "inovaport3",
	23003: "inovaport4",
	23004: "inovaport5",
	23005: "inovaport6",
	23053: "gntp",
	23333: "elxmgmt",
	23400: "novar-dbase",
	23401: "novar-alarm",
	23402: "novar-global",
	23456: "aequus",
	23457: "aequus-alt",
	23546: "areaguard-neo",
	24000: "med-ltp",
	24001: "med-fsp-rx",
	24002: "med-fsp-tx",
	24003: "med-supp",
	24004: "med-ovw",
	24005: "med-ci",
	24006: "med-net-svc",
	24242: "filesphere",
	24249: "vista-4gl",
	24321: "ild",
	24386: "intel-rci",
	24465: "tonidods",
	24554: "binkp",
	24577: "bilobit",
	24676: "canditv",
	24677: "flashfiler",
	24678: "proactivate",
	24680: "tcc-http",
	24754: "cslg",
	24922: "find",
	25000: "icl-twobase1",
	25001: "icl-twobase2",
	25002: "icl-twobase3",
	25003: "icl-twobase4",
	25004: "icl-twobase5",
	25005: "icl-twobase6",
	25006: "icl-twobase7",
	25007: "icl-twobase8",
	25008: "icl-twobase9",
	25009: "icl-twobase10",
	25576: "sauterdongle",
	25604: "idtp",
	25793: "vocaltec-hos",
	25900: "tasp-net",
	25901: "niobserver",
	25902: "nilinkanalyst",
	25903: "niprobe",
	26000: "quake",
	26133: "scscp",
	26208: "wnn6-ds",
	26260: "ezproxy",
	26261: "ezmeeting",
	26262: "k3software-svr",
	26263: "k3software-cli",
	26486: "exoline-tcp",
	26487: "exoconfig",
	26489: "exonet",
	27345: "imagepump",
	27442: "jesmsjc",
	27504: "kopek-httphead",
	27782: "ars-vista",
	27876: "astrolink",
	27999: "tw-auth-key",
	28000: "nxlmd",
	28001: "pqsp",
	28200: "voxelstorm",
	28240: "siemensgsm",
	29167: "otmp",
	29999: "bingbang",
	30000: "ndmps",
	30001: "pago-services1",
	30002: "pago-services2",
	30003: "amicon-fpsu-ra",
	30260: "kingdomsonline",
	30999: "ovobs",
	31020: "autotrac-acp",
	31400: "pace-licensed",
	31416: "xqosd",
	31457: "tetrinet",
	31620: "lm-mon",
	31685: "dsx-monitor",
	31765: "gamesmith-port",
	31948: "iceedcp-tx",
	31949: "iceedcp-rx",
	32034: "iracinghelper",
	32249: "t1distproc60",
	32483: "apm-link",
	32635: "sec-ntb-clnt",
	32636: "DMExpress",
	32767: "filenet-powsrm",
	32768: "filenet-tms",
	32769: "filenet-rpc",
	32770: "filenet-nch",
	32771: "filenet-rmi",
	32772: "filenet-pa",
	32773: "filenet-cm",
	32774: "filenet-re",
	32775: "filenet-pch",
	32776: "filenet-peior",
	32777: "filenet-obrok",
	32801: "mlsn",
	32811: "retp",
	32896: "idmgratm",
	33123: "aurora-balaena",
	33331: "diamondport",
	33333: "dgi-serv",
	33334: "speedtrace",
	33434: "traceroute",
	33656: "snip-slave",
	34249: "turbonote-2",
	34378: "p-net-local",
	34379: "p-net-remote",
	34567: "dhanalakshmi",
	34962: "profinet-rt",
	34963: "profinet-rtm",
	34964: "profinet-cm",
	34980: "ethercat",
	35000: "heathview",
	35001: "rt-viewer",
	35002: "rt-sound",
	35003: "rt-devicemapper",
	35004: "rt-classmanager",
	35005: "rt-labtracker",
	35006: "rt-helper",
	35354: "kitim",
	35355: "altova-lm",
	35356: "guttersnex",
	35357: "openstack-id",
	36001: "allpeers",
	36524: "febooti-aw",
	36602: "observium-agent",
	36865: "kastenxpipe",
	37475: "neckar",
	37483: "gdrive-sync",
	37654: "unisys-eportal",
	38000: "ivs-database",
	38001: "ivs-insertion",
	38201: "galaxy7-data",
	38202: "fairview",
	38203: "agpolicy",
	38800: "sruth",
	38865: "secrmmsafecopya",
	39681: "turbonote-1",
	40000: "safetynetp",
	40404: "sptx",
	40841: "cscp",
	40842: "csccredir",
	40843: "csccfirewall",
	41111: "fs-qos",
	41121: "tentacle",
	41794: "crestron-cip",
	41795: "crestron-ctp",
	41796: "crestron-cips",
	41797: "crestron-ctps",
	42508: "candp",
	42509: "candrp",
	42510: "caerpc",
	43000: "recvr-rc",
	43188: "reachout",
	43189: "ndm-agent-port",
	43190: "ip-provision",
	43191: "noit-transport",
	43210: "shaperai",
	43439: "eq3-update",
	43440: "ew-mgmt",
	43441: "ciscocsdb",
	44123: "z-wave-s",
	44321: "pmcd",
	44322: "pmcdproxy",
	44323: "pmwebapi",
	44444: "cognex-dataman",
	44553: "rbr-debug",
	44818: "EtherNet-IP-2",
	44900: "m3da",
	45000: "asmp",
	45001: "asmps",
	45045: "synctest",
	45054: "invision-ag",
	45678: "eba",
	45824: "dai-shell",
	45825: "qdb2service",
	45966: "ssr-servermgr",
	46998: "spremotetablet",
	46999: "mediabox",
	47000: "mbus",
	47001: "winrm",
	47557: "dbbrowse",
	47624: "directplaysrvr",
	47806: "ap",
	47808: "bacnet",
	48000: "nimcontroller",
	48001: "nimspooler",
	48002: "nimhub",
	48003: "nimgtw",
	48004: "nimbusdb",
	48005: "nimbusdbctrl",
	48049: "3gpp-cbsp",
	48050: "weandsf",
	48128: "isnetserv",
	48129: "blp5",
	48556: "com-bardac-dw",
	48619: "iqobject",
	48653: "robotraconteur",
	49000: "matahari",
}
var udpPortNames = map[UDPPort]string{
	1:     "tcpmux",
	2:     "compressnet",
	3:     "compressnet",
	5:     "rje",
	7:     "echo",
	9:     "discard",
	11:    "systat",
	13:    "daytime",
	17:    "qotd",
	18:    "msp",
	19:    "chargen",
	20:    "ftp-data",
	21:    "ftp",
	22:    "ssh",
	23:    "telnet",
	25:    "smtp",
	27:    "nsw-fe",
	29:    "msg-icp",
	31:    "msg-auth",
	33:    "dsp",
	37:    "time",
	38:    "rap",
	39:    "rlp",
	41:    "graphics",
	42:    "name",
	43:    "nicname",
	44:    "mpm-flags",
	45:    "mpm",
	46:    "mpm-snd",
	47:    "ni-ftp",
	48:    "auditd",
	49:    "tacacs",
	50:    "re-mail-ck",
	52:    "xns-time",
	53:    "domain",
	54:    "xns-ch",
	55:    "isi-gl",
	56:    "xns-auth",
	58:    "xns-mail",
	61:    "ni-mail",
	62:    "acas",
	63:    "whoispp",
	64:    "covia",
	65:    "tacacs-ds",
	66:    "sql-net",
	67:    "bootps",
	68:    "bootpc",
	69:    "tftp",
	70:    "gopher",
	71:    "netrjs-1",
	72:    "netrjs-2",
	73:    "netrjs-3",
	74:    "netrjs-4",
	76:    "deos",
	78:    "vettcp",
	79:    "finger",
	80:    "http",
	82:    "xfer",
	83:    "mit-ml-dev",
	84:    "ctf",
	85:    "mit-ml-dev",
	86:    "mfcobol",
	88:    "kerberos",
	89:    "su-mit-tg",
	90:    "dnsix",
	91:    "mit-dov",
	92:    "npp",
	93:    "dcp",
	94:    "objcall",
	95:    "supdup",
	96:    "dixie",
	97:    "swift-rvf",
	98:    "tacnews",
	99:    "metagram",
	101:   "hostname",
	102:   "iso-tsap",
	103:   "gppitnp",
	104:   "acr-nema",
	105:   "cso",
	106:   "3com-tsmux",
	107:   "rtelnet",
	108:   "snagas",
	109:   "pop2",
	110:   "pop3",
	111:   "sunrpc",
	112:   "mcidas",
	113:   "auth",
	115:   "sftp",
	116:   "ansanotify",
	117:   "uucp-path",
	118:   "sqlserv",
	119:   "nntp",
	120:   "cfdptkt",
	121:   "erpc",
	122:   "smakynet",
	123:   "ntp",
	124:   "ansatrader",
	125:   "locus-map",
	126:   "nxedit",
	127:   "locus-con",
	128:   "gss-xlicen",
	129:   "pwdgen",
	130:   "cisco-fna",
	131:   "cisco-tna",
	132:   "cisco-sys",
	133:   "statsrv",
	134:   "ingres-net",
	135:   "epmap",
	136:   "profile",
	137:   "netbios-ns",
	138:   "netbios-dgm",
	139:   "netbios-ssn",
	140:   "emfis-data",
	141:   "emfis-cntl",
	142:   "bl-idm",
	143:   "imap",
	144:   "uma",
	145:   "uaac",
	146:   "iso-tp0",
	147:   "iso-ip",
	148:   "jargon",
	149:   "aed-512",
	150:   "sql-net",
	151:   "hems",
	152:   "bftp",
	153:   "sgmp",
	154:   "netsc-prod",
	155:   "netsc-dev",
	156:   "sqlsrv",
	157:   "knet-cmp",
	158:   "pcmail-srv",
	159:   "nss-routing",
	160:   "sgmp-traps",
	161:   "snmp",
	162:   "snmptrap",
	163:   "cmip-man",
	164:   "cmip-agent",
	165:   "xns-courier",
	166:   "s-net",
	167:   "namp",
	168:   "rsvd",
	169:   "send",
	170:   "print-srv",
	171:   "multiplex",
	172:   "cl-1",
	173:   "xyplex-mux",
	174:   "mailq",
	175:   "vmnet",
	176:   "genrad-mux",
	177:   "xdmcp",
	178:   "nextstep",
	179:   "bgp",
	180:   "ris",
	181:   "unify",
	182:   "audit",
	183:   "ocbinder",
	184:   "ocserver",
	185:   "remote-kis",
	186:   "kis",
	187:   "aci",
	188:   "mumps",
	189:   "qft",
	190:   "gacp",
	191:   "prospero",
	192:   "osu-nms",
	193:   "srmp",
	194:   "irc",
	195:   "dn6-nlm-aud",
	196:   "dn6-smm-red",
	197:   "dls",
	198:   "dls-mon",
	199:   "smux",
	200:   "src",
	201:   "at-rtmp",
	202:   "at-nbp",
	203:   "at-3",
	204:   "at-echo",
	205:   "at-5",
	206:   "at-zis",
	207:   "at-7",
	208:   "at-8",
	209:   "qmtp",
	210:   "z39-50",
	211:   "914c-g",
	212:   "anet",
	213:   "ipx",
	214:   "vmpwscs",
	215:   "softpc",
	216:   "CAIlic",
	217:   "dbase",
	218:   "mpp",
	219:   "uarps",
	220:   "imap3",
	221:   "fln-spx",
	222:   "rsh-spx",
	223:   "cdc",
	224:   "masqdialer",
	242:   "direct",
	243:   "sur-meas",
	244:   "inbusiness",
	245:   "link",
	246:   "dsp3270",
	247:   "subntbcst-tftp",
	248:   "bhfhs",
	256:   "rap",
	257:   "set",
	259:   "esro-gen",
	260:   "openport",
	261:   "nsiiops",
	262:   "arcisdms",
	263:   "hdap",
	264:   "bgmp",
	265:   "x-bone-ctl",
	266:   "sst",
	267:   "td-service",
	268:   "td-replica",
	269:   "manet",
	270:   "gist",
	280:   "http-mgmt",
	281:   "personal-link",
	282:   "cableport-ax",
	283:   "rescap",
	284:   "corerjd",
	286:   "fxp",
	287:   "k-block",
	308:   "novastorbakcup",
	309:   "entrusttime",
	310:   "bhmds",
	311:   "asip-webadmin",
	312:   "vslmp",
	313:   "magenta-logic",
	314:   "opalis-robot",
	315:   "dpsi",
	316:   "decauth",
	317:   "zannet",
	318:   "pkix-timestamp",
	319:   "ptp-event",
	320:   "ptp-general",
	321:   "pip",
	322:   "rtsps",
	333:   "texar",
	344:   "pdap",
	345:   "pawserv",
	346:   "zserv",
	347:   "fatserv",
	348:   "csi-sgwp",
	349:   "mftp",
	350:   "matip-type-a",
	351:   "matip-type-b",
	352:   "dtag-ste-sb",
	353:   "ndsauth",
	354:   "bh611",
	355:   "datex-asn",
	356:   "cloanto-net-1",
	357:   "bhevent",
	358:   "shrinkwrap",
	359:   "nsrmp",
	360:   "scoi2odialog",
	361:   "semantix",
	362:   "srssend",
	363:   "rsvp-tunnel",
	364:   "aurora-cmgr",
	365:   "dtk",
	366:   "odmr",
	367:   "mortgageware",
	368:   "qbikgdp",
	369:   "rpc2portmap",
	370:   "codaauth2",
	371:   "clearcase",
	372:   "ulistproc",
	373:   "legent-1",
	374:   "legent-2",
	375:   "hassle",
	376:   "nip",
	377:   "tnETOS",
	378:   "dsETOS",
	379:   "is99c",
	380:   "is99s",
	381:   "hp-collector",
	382:   "hp-managed-node",
	383:   "hp-alarm-mgr",
	384:   "arns",
	385:   "ibm-app",
	386:   "asa",
	387:   "aurp",
	388:   "unidata-ldm",
	389:   "ldap",
	390:   "uis",
	391:   "synotics-relay",
	392:   "synotics-broker",
	393:   "meta5",
	394:   "embl-ndt",
	395:   "netcp",
	396:   "netware-ip",
	397:   "mptn",
	398:   "kryptolan",
	399:   "iso-tsap-c2",
	400:   "osb-sd",
	401:   "ups",
	402:   "genie",
	403:   "decap",
	404:   "nced",
	405:   "ncld",
	406:   "imsp",
	407:   "timbuktu",
	408:   "prm-sm",
	409:   "prm-nm",
	410:   "decladebug",
	411:   "rmt",
	412:   "synoptics-trap",
	413:   "smsp",
	414:   "infoseek",
	415:   "bnet",
	416:   "silverplatter",
	417:   "onmux",
	418:   "hyper-g",
	419:   "ariel1",
	420:   "smpte",
	421:   "ariel2",
	422:   "ariel3",
	423:   "opc-job-start",
	424:   "opc-job-track",
	425:   "icad-el",
	426:   "smartsdp",
	427:   "svrloc",
	428:   "ocs-cmu",
	429:   "ocs-amu",
	430:   "utmpsd",
	431:   "utmpcd",
	432:   "iasd",
	433:   "nnsp",
	434:   "mobileip-agent",
	435:   "mobilip-mn",
	436:   "dna-cml",
	437:   "comscm",
	438:   "dsfgw",
	439:   "dasp",
	440:   "sgcp",
	441:   "decvms-sysmgt",
	442:   "cvc-hostd",
	443:   "https",
	444:   "snpp",
	445:   "microsoft-ds",
	446:   "ddm-rdb",
	447:   "ddm-dfm",
	448:   "ddm-ssl",
	449:   "as-servermap",
	450:   "tserver",
	451:   "sfs-smp-net",
	452:   "sfs-config",
	453:   "creativeserver",
	454:   "contentserver",
	455:   "creativepartnr",
	456:   "macon-udp",
	457:   "scohelp",
	458:   "appleqtc",
	459:   "ampr-rcmd",
	460:   "skronk",
	461:   "datasurfsrv",
	462:   "datasurfsrvsec",
	463:   "alpes",
	464:   "kpasswd",
	465:   "igmpv3lite",
	466:   "digital-vrc",
	467:   "mylex-mapd",
	468:   "photuris",
	469:   "rcp",
	470:   "scx-proxy",
	471:   "mondex",
	472:   "ljk-login",
	473:   "hybrid-pop",
	474:   "tn-tl-w2",
	475:   "tcpnethaspsrv",
	476:   "tn-tl-fd1",
	477:   "ss7ns",
	478:   "spsc",
	479:   "iafserver",
	480:   "iafdbase",
	481:   "ph",
	482:   "bgs-nsi",
	483:   "ulpnet",
	484:   "integra-sme",
	485:   "powerburst",
	486:   "avian",
	487:   "saft",
	488:   "gss-http",
	489:   "nest-protocol",
	490:   "micom-pfs",
	491:   "go-login",
	492:   "ticf-1",
	493:   "ticf-2",
	494:   "pov-ray",
	495:   "intecourier",
	496:   "pim-rp-disc",
	497:   "retrospect",
	498:   "siam",
	499:   "iso-ill",
	500:   "isakmp",
	501:   "stmf",
	502:   "mbap",
	503:   "intrinsa",
	504:   "citadel",
	505:   "mailbox-lm",
	506:   "ohimsrv",
	507:   "crs",
	508:   "xvttp",
	509:   "snare",
	510:   "fcp",
	511:   "passgo",
	512:   "comsat",
	513:   "who",
	514:   "syslog",
	515:   "printer",
	516:   "videotex",
	517:   "talk",
	518:   "ntalk",
	519:   "utime",
	520:   "router",
	521:   "ripng",
	522:   "ulp",
	523:   "ibm-db2",
	524:   "ncp",
	525:   "timed",
	526:   "tempo",
	527:   "stx",
	528:   "custix",
	529:   "irc-serv",
	530:   "courier",
	531:   "conference",
	532:   "netnews",
	533:   "netwall",
	534:   "windream",
	535:   "iiop",
	536:   "opalis-rdv",
	537:   "nmsp",
	538:   "gdomap",
	539:   "apertus-ldp",
	540:   "uucp",
	541:   "uucp-rlogin",
	542:   "commerce",
	543:   "klogin",
	544:   "kshell",
	545:   "appleqtcsrvr",
	546:   "dhcpv6-client",
	547:   "dhcpv6-server",
	548:   "afpovertcp",
	549:   "idfp",
	550:   "new-rwho",
	551:   "cybercash",
	552:   "devshr-nts",
	553:   "pirp",
	554:   "rtsp",
	555:   "dsf",
	556:   "remotefs",
	557:   "openvms-sysipc",
	558:   "sdnskmp",
	559:   "teedtap",
	560:   "rmonitor",
	561:   "monitor",
	562:   "chshell",
	563:   "nntps",
	564:   "9pfs",
	565:   "whoami",
	566:   "streettalk",
	567:   "banyan-rpc",
	568:   "ms-shuttle",
	569:   "ms-rome",
	570:   "meter",
	571:   "meter",
	572:   "sonar",
	573:   "banyan-vip",
	574:   "ftp-agent",
	575:   "vemmi",
	576:   "ipcd",
	577:   "vnas",
	578:   "ipdd",
	579:   "decbsrv",
	580:   "sntp-heartbeat",
	581:   "bdp",
	582:   "scc-security",
	583:   "philips-vc",
	584:   "keyserver",
	586:   "password-chg",
	587:   "submission",
	588:   "cal",
	589:   "eyelink",
	590:   "tns-cml",
	591:   "http-alt",
	592:   "eudora-set",
	593:   "http-rpc-epmap",
	594:   "tpip",
	595:   "cab-protocol",
	596:   "smsd",
	597:   "ptcnameservice",
	598:   "sco-websrvrmg3",
	599:   "acp",
	600:   "ipcserver",
	601:   "syslog-conn",
	602:   "xmlrpc-beep",
	603:   "idxp",
	604:   "tunnel",
	605:   "soap-beep",
	606:   "urm",
	607:   "nqs",
	608:   "sift-uft",
	609:   "npmp-trap",
	610:   "npmp-local",
	611:   "npmp-gui",
	612:   "hmmp-ind",
	613:   "hmmp-op",
	614:   "sshell",
	615:   "sco-inetmgr",
	616:   "sco-sysmgr",
	617:   "sco-dtmgr",
	618:   "dei-icda",
	619:   "compaq-evm",
	620:   "sco-websrvrmgr",
	621:   "escp-ip",
	622:   "collaborator",
	623:   "asf-rmcp",
	624:   "cryptoadmin",
	625:   "dec-dlm",
	626:   "asia",
	627:   "passgo-tivoli",
	628:   "qmqp",
	629:   "3com-amp3",
	630:   "rda",
	631:   "ipp",
	632:   "bmpp",
	633:   "servstat",
	634:   "ginad",
	635:   "rlzdbase",
	636:   "ldaps",
	637:   "lanserver",
	638:   "mcns-sec",
	639:   "msdp",
	640:   "entrust-sps",
	641:   "repcmd",
	642:   "esro-emsdp",
	643:   "sanity",
	644:   "dwr",
	645:   "pssc",
	646:   "ldp",
	647:   "dhcp-failover",
	648:   "rrp",
	649:   "cadview-3d",
	650:   "obex",
	651:   "ieee-mms",
	652:   "hello-port",
	653:   "repscmd",
	654:   "aodv",
	655:   "tinc",
	656:   "spmp",
	657:   "rmc",
	658:   "tenfold",
	660:   "mac-srvr-admin",
	661:   "hap",
	662:   "pftp",
	663:   "purenoise",
	664:   "asf-secure-rmcp",
	665:   "sun-dr",
	666:   "mdqs",
	667:   "disclose",
	668:   "mecomm",
	669:   "meregister",
	670:   "vacdsm-sws",
	671:   "vacdsm-app",
	672:   "vpps-qua",
	673:   "cimplex",
	674:   "acap",
	675:   "dctp",
	676:   "vpps-via",
	677:   "vpp",
	678:   "ggf-ncp",
	679:   "mrm",
	680:   "entrust-aaas",
	681:   "entrust-aams",
	682:   "xfr",
	683:   "corba-iiop",
	684:   "corba-iiop-ssl",
	685:   "mdc-portmapper",
	686:   "hcp-wismar",
	687:   "asipregistry",
	688:   "realm-rusd",
	689:   "nmap",
	690:   "vatp",
	691:   "msexch-routing",
	692:   "hyperwave-isp",
	693:   "connendp",
	694:   "ha-cluster",
	695:   "ieee-mms-ssl",
	696:   "rushd",
	697:   "uuidgen",
	698:   "olsr",
	699:   "accessnetwork",
	700:   "epp",
	701:   "lmp",
	702:   "iris-beep",
	704:   "elcsd",
	705:   "agentx",
	706:   "silc",
	707:   "borland-dsj",
	709:   "entrust-kmsh",
	710:   "entrust-ash",
	711:   "cisco-tdp",
	712:   "tbrpf",
	713:   "iris-xpc",
	714:   "iris-xpcs",
	715:   "iris-lwz",
	716:   "pana",
	729:   "netviewdm1",
	730:   "netviewdm2",
	731:   "netviewdm3",
	741:   "netgw",
	742:   "netrcs",
	744:   "flexlm",
	747:   "fujitsu-dev",
	748:   "ris-cm",
	749:   "kerberos-adm",
	750:   "loadav",
	751:   "pump",
	752:   "qrh",
	753:   "rrh",
	754:   "tell",
	758:   "nlogin",
	759:   "con",
	760:   "ns",
	761:   "rxe",
	762:   "quotad",
	763:   "cycleserv",
	764:   "omserv",
	765:   "webster",
	767:   "phonebook",
	769:   "vid",
	770:   "cadlock",
	771:   "rtip",
	772:   "cycleserv2",
	773:   "notify",
	774:   "acmaint-dbd",
	775:   "acmaint-transd",
	776:   "wpages",
	777:   "multiling-http",
	780:   "wpgs",
	800:   "mdbs-daemon",
	801:   "device",
	802:   "mbap-s",
	810:   "fcp-udp",
	828:   "itm-mcell-s",
	829:   "pkix-3-ca-ra",
	830:   "netconf-ssh",
	831:   "netconf-beep",
	832:   "netconfsoaphttp",
	833:   "netconfsoapbeep",
	847:   "dhcp-failover2",
	848:   "gdoi",
	860:   "iscsi",
	861:   "owamp-control",
	862:   "twamp-control",
	873:   "rsync",
	886:   "iclcnet-locate",
	887:   "iclcnet-svinfo",
	888:   "accessbuilder",
	900:   "omginitialrefs",
	901:   "smpnameres",
	902:   "ideafarm-door",
	903:   "ideafarm-panic",
	910:   "kink",
	911:   "xact-backup",
	912:   "apex-mesh",
	913:   "apex-edge",
	989:   "ftps-data",
	990:   "ftps",
	991:   "nas",
	992:   "telnets",
	993:   "imaps",
	995:   "pop3s",
	996:   "vsinet",
	997:   "maitrd",
	998:   "puparp",
	999:   "applix",
	1000:  "cadlock2",
	1010:  "surf",
	1021:  "exp1",
	1022:  "exp2",
	1025:  "blackjack",
	1026:  "cap",
	1027:  "6a44",
	1029:  "solid-mux",
	1033:  "netinfo-local",
	1034:  "activesync",
	1035:  "mxxrlogin",
	1036:  "nsstp",
	1037:  "ams",
	1038:  "mtqp",
	1039:  "sbl",
	1040:  "netarx",
	1041:  "danf-ak2",
	1042:  "afrog",
	1043:  "boinc-client",
	1044:  "dcutility",
	1045:  "fpitp",
	1046:  "wfremotertm",
	1047:  "neod1",
	1048:  "neod2",
	1049:  "td-postman",
	1050:  "cma",
	1051:  "optima-vnet",
	1052:  "ddt",
	1053:  "remote-as",
	1054:  "brvread",
	1055:  "ansyslmd",
	1056:  "vfo",
	1057:  "startron",
	1058:  "nim",
	1059:  "nimreg",
	1060:  "polestar",
	1061:  "kiosk",
	1062:  "veracity",
	1063:  "kyoceranetdev",
	1064:  "jstel",
	1065:  "syscomlan",
	1066:  "fpo-fns",
	1067:  "instl-boots",
	1068:  "instl-bootc",
	1069:  "cognex-insight",
	1070:  "gmrupdateserv",
	1071:  "bsquare-voip",
	1072:  "cardax",
	1073:  "bridgecontrol",
	1074:  "warmspotMgmt",
	1075:  "rdrmshc",
	1076:  "dab-sti-c",
	1077:  "imgames",
	1078:  "avocent-proxy",
	1079:  "asprovatalk",
	1080:  "socks",
	1081:  "pvuniwien",
	1082:  "amt-esd-prot",
	1083:  "ansoft-lm-1",
	1084:  "ansoft-lm-2",
	1085:  "webobjects",
	1086:  "cplscrambler-lg",
	1087:  "cplscrambler-in",
	1088:  "cplscrambler-al",
	1089:  "ff-annunc",
	1090:  "ff-fms",
	1091:  "ff-sm",
	1092:  "obrpd",
	1093:  "proofd",
	1094:  "rootd",
	1095:  "nicelink",
	1096:  "cnrprotocol",
	1097:  "sunclustermgr",
	1098:  "rmiactivation",
	1099:  "rmiregistry",
	1100:  "mctp",
	1101:  "pt2-discover",
	1102:  "adobeserver-1",
	1103:  "adobeserver-2",
	1104:  "xrl",
	1105:  "ftranhc",
	1106:  "isoipsigport-1",
	1107:  "isoipsigport-2",
	1108:  "ratio-adp",
	1110:  "nfsd-keepalive",
	1111:  "lmsocialserver",
	1112:  "icp",
	1113:  "ltp-deepspace",
	1114:  "mini-sql",
	1115:  "ardus-trns",
	1116:  "ardus-cntl",
	1117:  "ardus-mtrns",
	1118:  "sacred",
	1119:  "bnetgame",
	1120:  "bnetfile",
	1121:  "rmpp",
	1122:  "availant-mgr",
	1123:  "murray",
	1124:  "hpvmmcontrol",
	1125:  "hpvmmagent",
	1126:  "hpvmmdata",
	1127:  "kwdb-commn",
	1128:  "saphostctrl",
	1129:  "saphostctrls",
	1130:  "casp",
	1131:  "caspssl",
	1132:  "kvm-via-ip",
	1133:  "dfn",
	1134:  "aplx",
	1135:  "omnivision",
	1136:  "hhb-gateway",
	1137:  "trim",
	1138:  "encrypted-admin",
	1139:  "evm",
	1140:  "autonoc",
	1141:  "mxomss",
	1142:  "edtools",
	1143:  "imyx",
	1144:  "fuscript",
	1145:  "x9-icue",
	1146:  "audit-transfer",
	1147:  "capioverlan",
	1148:  "elfiq-repl",
	1149:  "bvtsonar",
	1150:  "blaze",
	1151:  "unizensus",
	1152:  "winpoplanmess",
	1153:  "c1222-acse",
	1154:  "resacommunity",
	1155:  "nfa",
	1156:  "iascontrol-oms",
	1157:  "iascontrol",
	1158:  "dbcontrol-oms",
	1159:  "oracle-oms",
	1160:  "olsv",
	1161:  "health-polling",
	1162:  "health-trap",
	1163:  "sddp",
	1164:  "qsm-proxy",
	1165:  "qsm-gui",
	1166:  "qsm-remote",
	1167:  "cisco-ipsla",
	1168:  "vchat",
	1169:  "tripwire",
	1170:  "atc-lm",
	1171:  "atc-appserver",
	1172:  "dnap",
	1173:  "d-cinema-rrp",
	1174:  "fnet-remote-ui",
	1175:  "dossier",
	1176:  "indigo-server",
	1177:  "dkmessenger",
	1178:  "sgi-storman",
	1179:  "b2n",
	1180:  "mc-client",
	1181:  "3comnetman",
	1182:  "accelenet-data",
	1183:  "llsurfup-http",
	1184:  "llsurfup-https",
	1185:  "catchpole",
	1186:  "mysql-cluster",
	1187:  "alias",
	1188:  "hp-webadmin",
	1189:  "unet",
	1190:  "commlinx-avl",
	1191:  "gpfs",
	1192:  "caids-sensor",
	1193:  "fiveacross",
	1194:  "openvpn",
	1195:  "rsf-1",
	1196:  "netmagic",
	1197:  "carrius-rshell",
	1198:  "cajo-discovery",
	1199:  "dmidi",
	1200:  "scol",
	1201:  "nucleus-sand",
	1202:  "caiccipc",
	1203:  "ssslic-mgr",
	1204:  "ssslog-mgr",
	1205:  "accord-mgc",
	1206:  "anthony-data",
	1207:  "metasage",
	1208:  "seagull-ais",
	1209:  "ipcd3",
	1210:  "eoss",
	1211:  "groove-dpp",
	1212:  "lupa",
	1213:  "mpc-lifenet",
	1214:  "kazaa",
	1215:  "scanstat-1",
	1216:  "etebac5",
	1217:  "hpss-ndapi",
	1218:  "aeroflight-ads",
	1219:  "aeroflight-ret",
	1220:  "qt-serveradmin",
	1221:  "sweetware-apps",
	1222:  "nerv",
	1223:  "tgp",
	1224:  "vpnz",
	1225:  "slinkysearch",
	1226:  "stgxfws",
	1227:  "dns2go",
	1228:  "florence",
	1229:  "zented",
	1230:  "periscope",
	1231:  "menandmice-lpm",
	1232:  "first-defense",
	1233:  "univ-appserver",
	1234:  "search-agent",
	1235:  "mosaicsyssvc1",
	1236:  "bvcontrol",
	1237:  "tsdos390",
	1238:  "hacl-qs",
	1239:  "nmsd",
	1240:  "instantia",
	1241:  "nessus",
	1242:  "nmasoverip",
	1243:  "serialgateway",
	1244:  "isbconference1",
	1245:  "isbconference2",
	1246:  "payrouter",
	1247:  "visionpyramid",
	1248:  "hermes",
	1249:  "mesavistaco",
	1250:  "swldy-sias",
	1251:  "servergraph",
	1252:  "bspne-pcc",
	1253:  "q55-pcc",
	1254:  "de-noc",
	1255:  "de-cache-query",
	1256:  "de-server",
	1257:  "shockwave2",
	1258:  "opennl",
	1259:  "opennl-voice",
	1260:  "ibm-ssd",
	1261:  "mpshrsv",
	1262:  "qnts-orb",
	1263:  "dka",
	1264:  "prat",
	1265:  "dssiapi",
	1266:  "dellpwrappks",
	1267:  "epc",
	1268:  "propel-msgsys",
	1269:  "watilapp",
	1270:  "opsmgr",
	1271:  "excw",
	1272:  "cspmlockmgr",
	1273:  "emc-gateway",
	1274:  "t1distproc",
	1275:  "ivcollector",
	1277:  "miva-mqs",
	1278:  "dellwebadmin-1",
	1279:  "dellwebadmin-2",
	1280:  "pictrography",
	1281:  "healthd",
	1282:  "emperion",
	1283:  "productinfo",
	1284:  "iee-qfx",
	1285:  "neoiface",
	1286:  "netuitive",
	1287:  "routematch",
	1288:  "navbuddy",
	1289:  "jwalkserver",
	1290:  "winjaserver",
	1291:  "seagulllms",
	1292:  "dsdn",
	1293:  "pkt-krb-ipsec",
	1294:  "cmmdriver",
	1295:  "ehtp",
	1296:  "dproxy",
	1297:  "sdproxy",
	1298:  "lpcp",
	1299:  "hp-sci",
	1300:  "h323hostcallsc",
	1301:  "ci3-software-1",
	1302:  "ci3-software-2",
	1303:  "sftsrv",
	1304:  "boomerang",
	1305:  "pe-mike",
	1306:  "re-conn-proto",
	1307:  "pacmand",
	1308:  "odsi",
	1309:  "jtag-server",
	1310:  "husky",
	1311:  "rxmon",
	1312:  "sti-envision",
	1313:  "bmc-patroldb",
	1314:  "pdps",
	1315:  "els",
	1316:  "exbit-escp",
	1317:  "vrts-ipcserver",
	1318:  "krb5gatekeeper",
	1319:  "amx-icsp",
	1320:  "amx-axbnet",
	1321:  "pip",
	1322:  "novation",
	1323:  "brcd",
	1324:  "delta-mcp",
	1325:  "dx-instrument",
	1326:  "wimsic",
	1327:  "ultrex",
	1328:  "ewall",
	1329:  "netdb-export",
	1330:  "streetperfect",
	1331:  "intersan",
	1332:  "pcia-rxp-b",
	1333:  "passwrd-policy",
	1334:  "writesrv",
	1335:  "digital-notary",
	1336:  "ischat",
	1337:  "menandmice-dns",
	1338:  "wmc-log-svc",
	1339:  "kjtsiteserver",
	1340:  "naap",
	1341:  "qubes",
	1342:  "esbroker",
	1343:  "re101",
	1344:  "icap",
	1345:  "vpjp",
	1346:  "alta-ana-lm",
	1347:  "bbn-mmc",
	1348:  "bbn-mmx",
	1349:  "sbook",
	1350:  "editbench",
	1351:  "equationbuilder",
	1352:  "lotusnote",
	1353:  "relief",
	1354:  "XSIP-network",
	1355:  "intuitive-edge",
	1356:  "cuillamartin",
	1357:  "pegboard",
	1358:  "connlcli",
	1359:  "ftsrv",
	1360:  "mimer",
	1361:  "linx",
	1362:  "timeflies",
	1363:  "ndm-requester",
	1364:  "ndm-server",
	1365:  "adapt-sna",
	1366:  "netware-csp",
	1367:  "dcs",
	1368:  "screencast",
	1369:  "gv-us",
	1370:  "us-gv",
	1371:  "fc-cli",
	1372:  "fc-ser",
	1373:  "chromagrafx",
	1374:  "molly",
	1375:  "bytex",
	1376:  "ibm-pps",
	1377:  "cichlid",
	1378:  "elan",
	1379:  "dbreporter",
	1380:  "telesis-licman",
	1381:  "apple-licman",
	1382:  "udt-os",
	1383:  "gwha",
	1384:  "os-licman",
	1385:  "atex-elmd",
	1386:  "checksum",
	1387:  "cadsi-lm",
	1388:  "objective-dbc",
	1389:  "iclpv-dm",
	1390:  "iclpv-sc",
	1391:  "iclpv-sas",
	1392:  "iclpv-pm",
	1393:  "iclpv-nls",
	1394:  "iclpv-nlc",
	1395:  "iclpv-wsm",
	1396:  "dvl-activemail",
	1397:  "audio-activmail",
	1398:  "video-activmail",
	1399:  "cadkey-licman",
	1400:  "cadkey-tablet",
	1401:  "goldleaf-licman",
	1402:  "prm-sm-np",
	1403:  "prm-nm-np",
	1404:  "igi-lm",
	1405:  "ibm-res",
	1406:  "netlabs-lm",
	1407:  "dbsa-lm",
	1408:  "sophia-lm",
	1409:  "here-lm",
	1410:  "hiq",
	1411:  "af",
	1412:  "innosys",
	1413:  "innosys-acl",
	1414:  "ibm-mqseries",
	1415:  "dbstar",
	1416:  "novell-lu6-2",
	1417:  "timbuktu-srv1",
	1418:  "timbuktu-srv2",
	1419:  "timbuktu-srv3",
	1420:  "timbuktu-srv4",
	1421:  "gandalf-lm",
	1422:  "autodesk-lm",
	1423:  "essbase",
	1424:  "hybrid",
	1425:  "zion-lm",
	1426:  "sais",
	1427:  "mloadd",
	1428:  "informatik-lm",
	1429:  "nms",
	1430:  "tpdu",
	1431:  "rgtp",
	1432:  "blueberry-lm",
	1433:  "ms-sql-s",
	1434:  "ms-sql-m",
	1435:  "ibm-cics",
	1436:  "saism",
	1437:  "tabula",
	1438:  "eicon-server",
	1439:  "eicon-x25",
	1440:  "eicon-slp",
	1441:  "cadis-1",
	1442:  "cadis-2",
	1443:  "ies-lm",
	1444:  "marcam-lm",
	1445:  "proxima-lm",
	1446:  "ora-lm",
	1447:  "apri-lm",
	1448:  "oc-lm",
	1449:  "peport",
	1450:  "dwf",
	1451:  "infoman",
	1452:  "gtegsc-lm",
	1453:  "genie-lm",
	1454:  "interhdl-elmd",
	1455:  "esl-lm",
	1456:  "dca",
	1457:  "valisys-lm",
	1458:  "nrcabq-lm",
	1459:  "proshare1",
	1460:  "proshare2",
	1461:  "ibm-wrless-lan",
	1462:  "world-lm",
	1463:  "nucleus",
	1464:  "msl-lmd",
	1465:  "pipes",
	1466:  "oceansoft-lm",
	1467:  "csdmbase",
	1468:  "csdm",
	1469:  "aal-lm",
	1470:  "uaiact",
	1471:  "csdmbase",
	1472:  "csdm",
	1473:  "openmath",
	1474:  "telefinder",
	1475:  "taligent-lm",
	1476:  "clvm-cfg",
	1477:  "ms-sna-server",
	1478:  "ms-sna-base",
	1479:  "dberegister",
	1480:  "pacerforum",
	1481:  "airs",
	1482:  "miteksys-lm",
	1483:  "afs",
	1484:  "confluent",
	1485:  "lansource",
	1486:  "nms-topo-serv",
	1487:  "localinfosrvr",
	1488:  "docstor",
	1489:  "dmdocbroker",
	1490:  "insitu-conf",
	1492:  "stone-design-1",
	1493:  "netmap-lm",
	1494:  "ica",
	1495:  "cvc",
	1496:  "liberty-lm",
	1497:  "rfx-lm",
	1498:  "sybase-sqlany",
	1499:  "fhc",
	1500:  "vlsi-lm",
	1501:  "saiscm",
	1502:  "shivadiscovery",
	1503:  "imtc-mcs",
	1504:  "evb-elm",
	1505:  "funkproxy",
	1506:  "utcd",
	1507:  "symplex",
	1508:  "diagmond",
	1509:  "robcad-lm",
	1510:  "mvx-lm",
	1511:  "3l-l1",
	1512:  "wins",
	1513:  "fujitsu-dtc",
	1514:  "fujitsu-dtcns",
	1515:  "ifor-protocol",
	1516:  "vpad",
	1517:  "vpac",
	1518:  "vpvd",
	1519:  "vpvc",
	1520:  "atm-zip-office",
	1521:  "ncube-lm",
	1522:  "ricardo-lm",
	1523:  "cichild-lm",
	1524:  "ingreslock",
	1525:  "orasrv",
	1526:  "pdap-np",
	1527:  "tlisrv",
	1529:  "coauthor",
	1530:  "rap-service",
	1531:  "rap-listen",
	1532:  "miroconnect",
	1533:  "virtual-places",
	1534:  "micromuse-lm",
	1535:  "ampr-info",
	1536:  "ampr-inter",
	1537:  "sdsc-lm",
	1538:  "3ds-lm",
	1539:  "intellistor-lm",
	1540:  "rds",
	1541:  "rds2",
	1542:  "gridgen-elmd",
	1543:  "simba-cs",
	1544:  "aspeclmd",
	1545:  "vistium-share",
	1546:  "abbaccuray",
	1547:  "laplink",
	1548:  "axon-lm",
	1549:  "shivasound",
	1550:  "3m-image-lm",
	1551:  "hecmtl-db",
	1552:  "pciarray",
	1553:  "sna-cs",
	1554:  "caci-lm",
	1555:  "livelan",
	1556:  "veritas-pbx",
	1557:  "arbortext-lm",
	1558:  "xingmpeg",
	1559:  "web2host",
	1560:  "asci-val",
	1561:  "facilityview",
	1562:  "pconnectmgr",
	1563:  "cadabra-lm",
	1564:  "pay-per-view",
	1565:  "winddlb",
	1566:  "corelvideo",
	1567:  "jlicelmd",
	1568:  "tsspmap",
	1569:  "ets",
	1570:  "orbixd",
	1571:  "rdb-dbs-disp",
	1572:  "chip-lm",
	1573:  "itscomm-ns",
	1574:  "mvel-lm",
	1575:  "oraclenames",
	1576:  "moldflow-lm",
	1577:  "hypercube-lm",
	1578:  "jacobus-lm",
	1579:  "ioc-sea-lm",
	1580:  "tn-tl-r2",
	1581:  "mil-2045-47001",
	1582:  "msims",
	1583:  "simbaexpress",
	1584:  "tn-tl-fd2",
	1585:  "intv",
	1586:  "ibm-abtact",
	1587:  "pra-elmd",
	1588:  "triquest-lm",
	1589:  "vqp",
	1590:  "gemini-lm",
	1591:  "ncpm-pm",
	1592:  "commonspace",
	1593:  "mainsoft-lm",
	1594:  "sixtrak",
	1595:  "radio",
	1596:  "radio-bc",
	1597:  "orbplus-iiop",
	1598:  "picknfs",
	1599:  "simbaservices",
	1600:  "issd",
	1601:  "aas",
	1602:  "inspect",
	1603:  "picodbc",
	1604:  "icabrowser",
	1605:  "slp",
	1606:  "slm-api",
	1607:  "stt",
	1608:  "smart-lm",
	1609:  "isysg-lm",
	1610:  "taurus-wh",
	1611:  "ill",
	1612:  "netbill-trans",
	1613:  "netbill-keyrep",
	1614:  "netbill-cred",
	1615:  "netbill-auth",
	1616:  "netbill-prod",
	1617:  "nimrod-agent",
	1618:  "skytelnet",
	1619:  "xs-openstorage",
	1620:  "faxportwinport",
	1621:  "softdataphone",
	1622:  "ontime",
	1623:  "jaleosnd",
	1624:  "udp-sr-port",
	1625:  "svs-omagent",
	1626:  "shockwave",
	1627:  "t128-gateway",
	1628:  "lontalk-norm",
	1629:  "lontalk-urgnt",
	1630:  "oraclenet8cman",
	1631:  "visitview",
	1632:  "pammratc",
	1633:  "pammrpc",
	1634:  "loaprobe",
	1635:  "edb-server1",
	1636:  "isdc",
	1637:  "islc",
	1638:  "ismc",
	1639:  "cert-initiator",
	1640:  "cert-responder",
	1641:  "invision",
	1642:  "isis-am",
	1643:  "isis-ambc",
	1644:  "saiseh",
	1645:  "sightline",
	1646:  "sa-msg-port",
	1647:  "rsap",
	1648:  "concurrent-lm",
	1649:  "kermit",
	1650:  "nkd",
	1651:  "shiva-confsrvr",
	1652:  "xnmp",
	1653:  "alphatech-lm",
	1654:  "stargatealerts",
	1655:  "dec-mbadmin",
	1656:  "dec-mbadmin-h",
	1657:  "fujitsu-mmpdc",
	1658:  "sixnetudr",
	1659:  "sg-lm",
	1660:  "skip-mc-gikreq",
	1661:  "netview-aix-1",
	1662:  "netview-aix-2",
	1663:  "netview-aix-3",
	1664:  "netview-aix-4",
	1665:  "netview-aix-5",
	1666:  "netview-aix-6",
	1667:  "netview-aix-7",
	1668:  "netview-aix-8",
	1669:  "netview-aix-9",
	1670:  "netview-aix-10",
	1671:  "netview-aix-11",
	1672:  "netview-aix-12",
	1673:  "proshare-mc-1",
	1674:  "proshare-mc-2",
	1675:  "pdp",
	1676:  "netcomm2",
	1677:  "groupwise",
	1678:  "prolink",
	1679:  "darcorp-lm",
	1680:  "microcom-sbp",
	1681:  "sd-elmd",
	1682:  "lanyon-lantern",
	1683:  "ncpm-hip",
	1684:  "snaresecure",
	1685:  "n2nremote",
	1686:  "cvmon",
	1687:  "nsjtp-ctrl",
	1688:  "nsjtp-data",
	1689:  "firefox",
	1690:  "ng-umds",
	1691:  "empire-empuma",
	1692:  "sstsys-lm",
	1693:  "rrirtr",
	1694:  "rrimwm",
	1695:  "rrilwm",
	1696:  "rrifmm",
	1697:  "rrisat",
	1698:  "rsvp-encap-1",
	1699:  "rsvp-encap-2",
	1700:  "mps-raft",
	1701:  "l2f",
	1702:  "deskshare",
	1703:  "hb-engine",
	1704:  "bcs-broker",
	1705:  "slingshot",
	1706:  "jetform",
	1707:  "vdmplay",
	1708:  "gat-lmd",
	1709:  "centra",
	1710:  "impera",
	1711:  "pptconference",
	1712:  "registrar",
	1713:  "conferencetalk",
	1714:  "sesi-lm",
	1715:  "houdini-lm",
	1716:  "xmsg",
	1717:  "fj-hdnet",
	1718:  "h323gatedisc",
	1719:  "h323gatestat",
	1720:  "h323hostcall",
	1721:  "caicci",
	1722:  "hks-lm",
	1723:  "pptp",
	1724:  "csbphonemaster",
	1725:  "iden-ralp",
	1726:  "iberiagames",
	1727:  "winddx",
	1728:  "telindus",
	1729:  "citynl",
	1730:  "roketz",
	1731:  "msiccp",
	1732:  "proxim",
	1733:  "siipat",
	1734:  "cambertx-lm",
	1735:  "privatechat",
	1736:  "street-stream",
	1737:  "ultimad",
	1738:  "gamegen1",
	1739:  "webaccess",
	1740:  "encore",
	1741:  "cisco-net-mgmt",
	1742:  "3Com-nsd",
	1743:  "cinegrfx-lm",
	1744:  "ncpm-ft",
	1745:  "remote-winsock",
	1746:  "ftrapid-1",
	1747:  "ftrapid-2",
	1748:  "oracle-em1",
	1749:  "aspen-services",
	1750:  "sslp",
	1751:  "swiftnet",
	1752:  "lofr-lm",
	1754:  "oracle-em2",
	1755:  "ms-streaming",
	1756:  "capfast-lmd",
	1757:  "cnhrp",
	1758:  "tftp-mcast",
	1759:  "spss-lm",
	1760:  "www-ldap-gw",
	1761:  "cft-0",
	1762:  "cft-1",
	1763:  "cft-2",
	1764:  "cft-3",
	1765:  "cft-4",
	1766:  "cft-5",
	1767:  "cft-6",
	1768:  "cft-7",
	1769:  "bmc-net-adm",
	1770:  "bmc-net-svc",
	1771:  "vaultbase",
	1772:  "essweb-gw",
	1773:  "kmscontrol",
	1774:  "global-dtserv",
	1776:  "femis",
	1777:  "powerguardian",
	1778:  "prodigy-intrnet",
	1779:  "pharmasoft",
	1780:  "dpkeyserv",
	1781:  "answersoft-lm",
	1782:  "hp-hcip",
	1784:  "finle-lm",
	1785:  "windlm",
	1786:  "funk-logger",
	1787:  "funk-license",
	1788:  "psmond",
	1789:  "hello",
	1790:  "nmsp",
	1791:  "ea1",
	1792:  "ibm-dt-2",
	1793:  "rsc-robot",
	1794:  "cera-bcm",
	1795:  "dpi-proxy",
	1796:  "vocaltec-admin",
	1797:  "uma",
	1798:  "etp",
	1799:  "netrisk",
	1800:  "ansys-lm",
	1801:  "msmq",
	1802:  "concomp1",
	1803:  "hp-hcip-gwy",
	1804:  "enl",
	1805:  "enl-name",
	1806:  "musiconline",
	1807:  "fhsp",
	1808:  "oracle-vp2",
	1809:  "oracle-vp1",
	1810:  "jerand-lm",
	1811:  "scientia-sdb",
	1812:  "radius",
	1813:  "radius-acct",
	1814:  "tdp-suite",
	1815:  "mmpft",
	1816:  "harp",
	1817:  "rkb-oscs",
	1818:  "etftp",
	1819:  "plato-lm",
	1820:  "mcagent",
	1821:  "donnyworld",
	1822:  "es-elmd",
	1823:  "unisys-lm",
	1824:  "metrics-pas",
	1825:  "direcpc-video",
	1826:  "ardt",
	1827:  "asi",
	1828:  "itm-mcell-u",
	1829:  "optika-emedia",
	1830:  "net8-cman",
	1831:  "myrtle",
	1832:  "tht-treasure",
	1833:  "udpradio",
	1834:  "ardusuni",
	1835:  "ardusmul",
	1836:  "ste-smsc",
	1837:  "csoft1",
	1838:  "talnet",
	1839:  "netopia-vo1",
	1840:  "netopia-vo2",
	1841:  "netopia-vo3",
	1842:  "netopia-vo4",
	1843:  "netopia-vo5",
	1844:  "direcpc-dll",
	1845:  "altalink",
	1846:  "tunstall-pnc",
	1847:  "slp-notify",
	1848:  "fjdocdist",
	1849:  "alpha-sms",
	1850:  "gsi",
	1851:  "ctcd",
	1852:  "virtual-time",
	1853:  "vids-avtp",
	1854:  "buddy-draw",
	1855:  "fiorano-rtrsvc",
	1856:  "fiorano-msgsvc",
	1857:  "datacaptor",
	1858:  "privateark",
	1859:  "gammafetchsvr",
	1860:  "sunscalar-svc",
	1861:  "lecroy-vicp",
	1862:  "mysql-cm-agent",
	1863:  "msnp",
	1864:  "paradym-31port",
	1865:  "entp",
	1866:  "swrmi",
	1867:  "udrive",
	1868:  "viziblebrowser",
	1869:  "transact",
	1870:  "sunscalar-dns",
	1871:  "canocentral0",
	1872:  "canocentral1",
	1873:  "fjmpjps",
	1874:  "fjswapsnp",
	1875:  "westell-stats",
	1876:  "ewcappsrv",
	1877:  "hp-webqosdb",
	1878:  "drmsmc",
	1879:  "nettgain-nms",
	1880:  "vsat-control",
	1881:  "ibm-mqseries2",
	1882:  "ecsqdmn",
	1883:  "ibm-mqisdp",
	1884:  "idmaps",
	1885:  "vrtstrapserver",
	1886:  "leoip",
	1887:  "filex-lport",
	1888:  "ncconfig",
	1889:  "unify-adapter",
	1890:  "wilkenlistener",
	1891:  "childkey-notif",
	1892:  "childkey-ctrl",
	1893:  "elad",
	1894:  "o2server-port",
	1896:  "b-novative-ls",
	1897:  "metaagent",
	1898:  "cymtec-port",
	1899:  "mc2studios",
	1900:  "ssdp",
	1901:  "fjicl-tep-a",
	1902:  "fjicl-tep-b",
	1903:  "linkname",
	1904:  "fjicl-tep-c",
	1905:  "sugp",
	1906:  "tpmd",
	1907:  "intrastar",
	1908:  "dawn",
	1909:  "global-wlink",
	1910:  "ultrabac",
	1911:  "mtp",
	1912:  "rhp-iibp",
	1913:  "armadp",
	1914:  "elm-momentum",
	1915:  "facelink",
	1916:  "persona",
	1917:  "noagent",
	1918:  "can-nds",
	1919:  "can-dch",
	1920:  "can-ferret",
	1921:  "noadmin",
	1922:  "tapestry",
	1923:  "spice",
	1924:  "xiip",
	1925:  "discovery-port",
	1926:  "egs",
	1927:  "videte-cipc",
	1928:  "emsd-port",
	1929:  "bandwiz-system",
	1930:  "driveappserver",
	1931:  "amdsched",
	1932:  "ctt-broker",
	1933:  "xmapi",
	1934:  "xaapi",
	1935:  "macromedia-fcs",
	1936:  "jetcmeserver",
	1937:  "jwserver",
	1938:  "jwclient",
	1939:  "jvserver",
	1940:  "jvclient",
	1941:  "dic-aida",
	1942:  "res",
	1943:  "beeyond-media",
	1944:  "close-combat",
	1945:  "dialogic-elmd",
	1946:  "tekpls",
	1947:  "sentinelsrm",
	1948:  "eye2eye",
	1949:  "ismaeasdaqlive",
	1950:  "ismaeasdaqtest",
	1951:  "bcs-lmserver",
	1952:  "mpnjsc",
	1953:  "rapidbase",
	1954:  "abr-api",
	1955:  "abr-secure",
	1956:  "vrtl-vmf-ds",
	1957:  "unix-status",
	1958:  "dxadmind",
	1959:  "simp-all",
	1960:  "nasmanager",
	1961:  "bts-appserver",
	1962:  "biap-mp",
	1963:  "webmachine",
	1964:  "solid-e-engine",
	1965:  "tivoli-npm",
	1966:  "slush",
	1967:  "sns-quote",
	1968:  "lipsinc",
	1969:  "lipsinc1",
	1970:  "netop-rc",
	1971:  "netop-school",
	1972:  "intersys-cache",
	1973:  "dlsrap",
	1974:  "drp",
	1975:  "tcoflashagent",
	1976:  "tcoregagent",
	1977:  "tcoaddressbook",
	1978:  "unisql",
	1979:  "unisql-java",
	1980:  "pearldoc-xact",
	1981:  "p2pq",
	1982:  "estamp",
	1983:  "lhtp",
	1984:  "bb",
	1985:  "hsrp",
	1986:  "licensedaemon",
	1987:  "tr-rsrb-p1",
	1988:  "tr-rsrb-p2",
	1989:  "tr-rsrb-p3",
	1990:  "stun-p1",
	1991:  "stun-p2",
	1992:  "stun-p3",
	1993:  "snmp-tcp-port",
	1994:  "stun-port",
	1995:  "perf-port",
	1996:  "tr-rsrb-port",
	1997:  "gdp-port",
	1998:  "x25-svc-port",
	1999:  "tcp-id-port",
	2000:  "cisco-sccp",
	2001:  "wizard",
	2002:  "globe",
	2003:  "brutus",
	2004:  "emce",
	2005:  "oracle",
	2006:  "raid-cd",
	2007:  "raid-am",
	2008:  "terminaldb",
	2009:  "whosockami",
	2010:  "pipe-server",
	2011:  "servserv",
	2012:  "raid-ac",
	2013:  "raid-cd",
	2014:  "raid-sf",
	2015:  "raid-cs",
	2016:  "bootserver",
	2017:  "bootclient",
	2018:  "rellpack",
	2019:  "about",
	2020:  "xinupageserver",
	2021:  "xinuexpansion1",
	2022:  "xinuexpansion2",
	2023:  "xinuexpansion3",
	2024:  "xinuexpansion4",
	2025:  "xribs",
	2026:  "scrabble",
	2027:  "shadowserver",
	2028:  "submitserver",
	2029:  "hsrpv6",
	2030:  "device2",
	2031:  "mobrien-chat",
	2032:  "blackboard",
	2033:  "glogger",
	2034:  "scoremgr",
	2035:  "imsldoc",
	2036:  "e-dpnet",
	2037:  "applus",
	2038:  "objectmanager",
	2039:  "prizma",
	2040:  "lam",
	2041:  "interbase",
	2042:  "isis",
	2043:  "isis-bcast",
	2044:  "rimsl",
	2045:  "cdfunc",
	2046:  "sdfunc",
	2047:  "dls",
	2048:  "dls-monitor",
	2049:  "shilp",
	2050:  "av-emb-config",
	2051:  "epnsdp",
	2052:  "clearvisn",
	2053:  "lot105-ds-upd",
	2054:  "weblogin",
	2055:  "iop",
	2056:  "omnisky",
	2057:  "rich-cp",
	2058:  "newwavesearch",
	2059:  "bmc-messaging",
	2060:  "teleniumdaemon",
	2061:  "netmount",
	2062:  "icg-swp",
	2063:  "icg-bridge",
	2064:  "icg-iprelay",
	2065:  "dlsrpn",
	2066:  "aura",
	2067:  "dlswpn",
	2068:  "avauthsrvprtcl",
	2069:  "event-port",
	2070:  "ah-esp-encap",
	2071:  "acp-port",
	2072:  "msync",
	2073:  "gxs-data-port",
	2074:  "vrtl-vmf-sa",
	2075:  "newlixengine",
	2076:  "newlixconfig",
	2077:  "tsrmagt",
	2078:  "tpcsrvr",
	2079:  "idware-router",
	2080:  "autodesk-nlm",
	2081:  "kme-trap-port",
	2082:  "infowave",
	2083:  "radsec",
	2084:  "sunclustergeo",
	2085:  "ada-cip",
	2086:  "gnunet",
	2087:  "eli",
	2088:  "ip-blf",
	2089:  "sep",
	2090:  "lrp",
	2091:  "prp",
	2092:  "descent3",
	2093:  "nbx-cc",
	2094:  "nbx-au",
	2095:  "nbx-ser",
	2096:  "nbx-dir",
	2097:  "jetformpreview",
	2098:  "dialog-port",
	2099:  "h2250-annex-g",
	2100:  "amiganetfs",
	2101:  "rtcm-sc104",
	2102:  "zephyr-srv",
	2103:  "zephyr-clt",
	2104:  "zephyr-hm",
	2105:  "minipay",
	2106:  "mzap",
	2107:  "bintec-admin",
	2108:  "comcam",
	2109:  "ergolight",
	2110:  "umsp",
	2111:  "dsatp",
	2112:  "idonix-metanet",
	2113:  "hsl-storm",
	2114:  "newheights",
	2115:  "kdm",
	2116:  "ccowcmr",
	2117:  "mentaclient",
	2118:  "mentaserver",
	2119:  "gsigatekeeper",
	2120:  "qencp",
	2121:  "scientia-ssdb",
	2122:  "caupc-remote",
	2123:  "gtp-control",
	2124:  "elatelink",
	2125:  "lockstep",
	2126:  "pktcable-cops",
	2127:  "index-pc-wb",
	2128:  "net-steward",
	2129:  "cs-live",
	2130:  "xds",
	2131:  "avantageb2b",
	2132:  "solera-epmap",
	2133:  "zymed-zpp",
	2134:  "avenue",
	2135:  "gris",
	2136:  "appworxsrv",
	2137:  "connect",
	2138:  "unbind-cluster",
	2139:  "ias-auth",
	2140:  "ias-reg",
	2141:  "ias-admind",
	2142:  "tdmoip",
	2143:  "lv-jc",
	2144:  "lv-ffx",
	2145:  "lv-pici",
	2146:  "lv-not",
	2147:  "lv-auth",
	2148:  "veritas-ucl",
	2149:  "acptsys",
	2150:  "dynamic3d",
	2151:  "docent",
	2152:  "gtp-user",
	2153:  "ctlptc",
	2154:  "stdptc",
	2155:  "brdptc",
	2156:  "trp",
	2157:  "xnds",
	2158:  "touchnetplus",
	2159:  "gdbremote",
	2160:  "apc-2160",
	2161:  "apc-2161",
	2162:  "navisphere",
	2163:  "navisphere-sec",
	2164:  "ddns-v3",
	2165:  "x-bone-api",
	2166:  "iwserver",
	2167:  "raw-serial",
	2168:  "easy-soft-mux",
	2169:  "brain",
	2170:  "eyetv",
	2171:  "msfw-storage",
	2172:  "msfw-s-storage",
	2173:  "msfw-replica",
	2174:  "msfw-array",
	2175:  "airsync",
	2176:  "rapi",
	2177:  "qwave",
	2178:  "bitspeer",
	2179:  "vmrdp",
	2180:  "mc-gt-srv",
	2181:  "eforward",
	2182:  "cgn-stat",
	2183:  "cgn-config",
	2184:  "nvd",
	2185:  "onbase-dds",
	2186:  "gtaua",
	2187:  "ssmd",
	2190:  "tivoconnect",
	2191:  "tvbus",
	2192:  "asdis",
	2193:  "drwcs",
	2197:  "mnp-exchange",
	2198:  "onehome-remote",
	2199:  "onehome-help",
	2200:  "ici",
	2201:  "ats",
	2202:  "imtc-map",
	2203:  "b2-runtime",
	2204:  "b2-license",
	2205:  "jps",
	2206:  "hpocbus",
	2207:  "hpssd",
	2208:  "hpiod",
	2209:  "rimf-ps",
	2210:  "noaaport",
	2211:  "emwin",
	2212:  "leecoposserver",
	2213:  "kali",
	2214:  "rpi",
	2215:  "ipcore",
	2216:  "vtu-comms",
	2217:  "gotodevice",
	2218:  "bounzza",
	2219:  "netiq-ncap",
	2220:  "netiq",
	2221:  "rockwell-csp1",
	2222:  "EtherNet-IP-1",
	2223:  "rockwell-csp2",
	2224:  "efi-mg",
	2226:  "di-drm",
	2227:  "di-msg",
	2228:  "ehome-ms",
	2229:  "datalens",
	2230:  "queueadm",
	2231:  "wimaxasncp",
	2232:  "ivs-video",
	2233:  "infocrypt",
	2234:  "directplay",
	2235:  "sercomm-wlink",
	2236:  "nani",
	2237:  "optech-port1-lm",
	2238:  "aviva-sna",
	2239:  "imagequery",
	2240:  "recipe",
	2241:  "ivsd",
	2242:  "foliocorp",
	2243:  "magicom",
	2244:  "nmsserver",
	2245:  "hao",
	2246:  "pc-mta-addrmap",
	2247:  "antidotemgrsvr",
	2248:  "ums",
	2249:  "rfmp",
	2250:  "remote-collab",
	2251:  "dif-port",
	2252:  "njenet-ssl",
	2253:  "dtv-chan-req",
	2254:  "seispoc",
	2255:  "vrtp",
	2256:  "pcc-mfp",
	2257:  "simple-tx-rx",
	2258:  "rcts",
	2260:  "apc-2260",
	2261:  "comotionmaster",
	2262:  "comotionback",
	2263:  "ecwcfg",
	2264:  "apx500api-1",
	2265:  "apx500api-2",
	2266:  "mfserver",
	2267:  "ontobroker",
	2268:  "amt",
	2269:  "mikey",
	2270:  "starschool",
	2271:  "mmcals",
	2272:  "mmcal",
	2273:  "mysql-im",
	2274:  "pcttunnell",
	2275:  "ibridge-data",
	2276:  "ibridge-mgmt",
	2277:  "bluectrlproxy",
	2278:  "s3db",
	2279:  "xmquery",
	2280:  "lnvpoller",
	2281:  "lnvconsole",
	2282:  "lnvalarm",
	2283:  "lnvstatus",
	2284:  "lnvmaps",
	2285:  "lnvmailmon",
	2286:  "nas-metering",
	2287:  "dna",
	2288:  "netml",
	2289:  "dict-lookup",
	2290:  "sonus-logging",
	2291:  "eapsp",
	2292:  "mib-streaming",
	2293:  "npdbgmngr",
	2294:  "konshus-lm",
	2295:  "advant-lm",
	2296:  "theta-lm",
	2297:  "d2k-datamover1",
	2298:  "d2k-datamover2",
	2299:  "pc-telecommute",
	2300:  "cvmmon",
	2301:  "cpq-wbem",
	2302:  "binderysupport",
	2303:  "proxy-gateway",
	2304:  "attachmate-uts",
	2305:  "mt-scaleserver",
	2306:  "tappi-boxnet",
	2307:  "pehelp",
	2308:  "sdhelp",
	2309:  "sdserver",
	2310:  "sdclient",
	2311:  "messageservice",
	2312:  "wanscaler",
	2313:  "iapp",
	2314:  "cr-websystems",
	2315:  "precise-sft",
	2316:  "sent-lm",
	2317:  "attachmate-g32",
	2318:  "cadencecontrol",
	2319:  "infolibria",
	2320:  "siebel-ns",
	2321:  "rdlap",
	2322:  "ofsd",
	2323:  "3d-nfsd",
	2324:  "cosmocall",
	2325:  "ansysli",
	2326:  "idcp",
	2327:  "xingcsm",
	2328:  "netrix-sftm",
	2329:  "nvd",
	2330:  "tscchat",
	2331:  "agentview",
	2332:  "rcc-host",
	2333:  "snapp",
	2334:  "ace-client",
	2335:  "ace-proxy",
	2336:  "appleugcontrol",
	2337:  "ideesrv",
	2338:  "norton-lambert",
	2339:  "3com-webview",
	2340:  "wrs-registry",
	2341:  "xiostatus",
	2342:  "manage-exec",
	2343:  "nati-logos",
	2344:  "fcmsys",
	2345:  "dbm",
	2346:  "redstorm-join",
	2347:  "redstorm-find",
	2348:  "redstorm-info",
	2349:  "redstorm-diag",
	2350:  "psbserver",
	2351:  "psrserver",
	2352:  "pslserver",
	2353:  "pspserver",
	2354:  "psprserver",
	2355:  "psdbserver",
	2356:  "gxtelmd",
	2357:  "unihub-server",
	2358:  "futrix",
	2359:  "flukeserver",
	2360:  "nexstorindltd",
	2361:  "tl1",
	2362:  "digiman",
	2363:  "mediacntrlnfsd",
	2364:  "oi-2000",
	2365:  "dbref",
	2366:  "qip-login",
	2367:  "service-ctrl",
	2368:  "opentable",
	2370:  "l3-hbmon",
	2372:  "lanmessenger",
	2381:  "compaq-https",
	2382:  "ms-olap3",
	2383:  "ms-olap4",
	2384:  "sd-capacity",
	2385:  "sd-data",
	2386:  "virtualtape",
	2387:  "vsamredirector",
	2388:  "mynahautostart",
	2389:  "ovsessionmgr",
	2390:  "rsmtp",
	2391:  "3com-net-mgmt",
	2392:  "tacticalauth",
	2393:  "ms-olap1",
	2394:  "ms-olap2",
	2395:  "lan900-remote",
	2396:  "wusage",
	2397:  "ncl",
	2398:  "orbiter",
	2399:  "fmpro-fdal",
	2400:  "opequus-server",
	2401:  "cvspserver",
	2402:  "taskmaster2000",
	2403:  "taskmaster2000",
	2404:  "iec-104",
	2405:  "trc-netpoll",
	2406:  "jediserver",
	2407:  "orion",
	2409:  "sns-protocol",
	2410:  "vrts-registry",
	2411:  "netwave-ap-mgmt",
	2412:  "cdn",
	2413:  "orion-rmi-reg",
	2414:  "beeyond",
	2415:  "codima-rtp",
	2416:  "rmtserver",
	2417:  "composit-server",
	2418:  "cas",
	2419:  "attachmate-s2s",
	2420:  "dslremote-mgmt",
	2421:  "g-talk",
	2422:  "crmsbits",
	2423:  "rnrp",
	2424:  "kofax-svr",
	2425:  "fjitsuappmgr",
	2427:  "mgcp-gateway",
	2428:  "ott",
	2429:  "ft-role",
	2430:  "venus",
	2431:  "venus-se",
	2432:  "codasrv",
	2433:  "codasrv-se",
	2434:  "pxc-epmap",
	2435:  "optilogic",
	2436:  "topx",
	2437:  "unicontrol",
	2438:  "msp",
	2439:  "sybasedbsynch",
	2440:  "spearway",
	2441:  "pvsw-inet",
	2442:  "netangel",
	2443:  "powerclientcsf",
	2444:  "btpp2sectrans",
	2445:  "dtn1",
	2446:  "bues-service",
	2447:  "ovwdb",
	2448:  "hpppssvr",
	2449:  "ratl",
	2450:  "netadmin",
	2451:  "netchat",
	2452:  "snifferclient",
	2453:  "madge-ltd",
	2454:  "indx-dds",
	2455:  "wago-io-system",
	2456:  "altav-remmgt",
	2457:  "rapido-ip",
	2458:  "griffin",
	2459:  "community",
	2460:  "ms-theater",
	2461:  "qadmifoper",
	2462:  "qadmifevent",
	2463:  "lsi-raid-mgmt",
	2464:  "direcpc-si",
	2465:  "lbm",
	2466:  "lbf",
	2467:  "high-criteria",
	2468:  "qip-msgd",
	2469:  "mti-tcs-comm",
	2470:  "taskman-port",
	2471:  "seaodbc",
	2472:  "c3",
	2473:  "aker-cdp",
	2474:  "vitalanalysis",
	2475:  "ace-server",
	2476:  "ace-svr-prop",
	2477:  "ssm-cvs",
	2478:  "ssm-cssps",
	2479:  "ssm-els",
	2480:  "powerexchange",
	2481:  "giop",
	2482:  "giop-ssl",
	2483:  "ttc",
	2484:  "ttc-ssl",
	2485:  "netobjects1",
	2486:  "netobjects2",
	2487:  "pns",
	2488:  "moy-corp",
	2489:  "tsilb",
	2490:  "qip-qdhcp",
	2491:  "conclave-cpp",
	2492:  "groove",
	2493:  "talarian-mqs",
	2494:  "bmc-ar",
	2495:  "fast-rem-serv",
	2496:  "dirgis",
	2497:  "quaddb",
	2498:  "odn-castraq",
	2499:  "unicontrol",
	2500:  "rtsserv",
	2501:  "rtsclient",
	2502:  "kentrox-prot",
	2503:  "nms-dpnss",
	2504:  "wlbs",
	2505:  "ppcontrol",
	2506:  "jbroker",
	2507:  "spock",
	2508:  "jdatastore",
	2509:  "fjmpss",
	2510:  "fjappmgrbulk",
	2511:  "metastorm",
	2512:  "citrixima",
	2513:  "citrixadmin",
	2514:  "facsys-ntp",
	2515:  "facsys-router",
	2516:  "maincontrol",
	2517:  "call-sig-trans",
	2518:  "willy",
	2519:  "globmsgsvc",
	2520:  "pvsw",
	2521:  "adaptecmgr",
	2522:  "windb",
	2523:  "qke-llc-v3",
	2524:  "optiwave-lm",
	2525:  "ms-v-worlds",
	2526:  "ema-sent-lm",
	2527:  "iqserver",
	2528:  "ncr-ccl",
	2529:  "utsftp",
	2530:  "vrcommerce",
	2531:  "ito-e-gui",
	2532:  "ovtopmd",
	2533:  "snifferserver",
	2534:  "combox-web-acc",
	2535:  "madcap",
	2536:  "btpp2audctr1",
	2537:  "upgrade",
	2538:  "vnwk-prapi",
	2539:  "vsiadmin",
	2540:  "lonworks",
	2541:  "lonworks2",
	2542:  "udrawgraph",
	2543:  "reftek",
	2544:  "novell-zen",
	2545:  "sis-emt",
	2546:  "vytalvaultbrtp",
	2547:  "vytalvaultvsmp",
	2548:  "vytalvaultpipe",
	2549:  "ipass",
	2550:  "ads",
	2551:  "isg-uda-server",
	2552:  "call-logging",
	2553:  "efidiningport",
	2554:  "vcnet-link-v10",
	2555:  "compaq-wcp",
	2556:  "nicetec-nmsvc",
	2557:  "nicetec-mgmt",
	2558:  "pclemultimedia",
	2559:  "lstp",
	2560:  "labrat",
	2561:  "mosaixcc",
	2562:  "delibo",
	2563:  "cti-redwood",
	2564:  "hp-3000-telnet",
	2565:  "coord-svr",
	2566:  "pcs-pcw",
	2567:  "clp",
	2568:  "spamtrap",
	2569:  "sonuscallsig",
	2570:  "hs-port",
	2571:  "cecsvc",
	2572:  "ibp",
	2573:  "trustestablish",
	2574:  "blockade-bpsp",
	2575:  "hl7",
	2576:  "tclprodebugger",
	2577:  "scipticslsrvr",
	2578:  "rvs-isdn-dcp",
	2579:  "mpfoncl",
	2580:  "tributary",
	2581:  "argis-te",
	2582:  "argis-ds",
	2583:  "mon",
	2584:  "cyaserv",
	2585:  "netx-server",
	2586:  "netx-agent",
	2587:  "masc",
	2588:  "privilege",
	2589:  "quartus-tcl",
	2590:  "idotdist",
	2591:  "maytagshuffle",
	2592:  "netrek",
	2593:  "mns-mail",
	2594:  "dts",
	2595:  "worldfusion1",
	2596:  "worldfusion2",
	2597:  "homesteadglory",
	2598:  "citriximaclient",
	2599:  "snapd",
	2600:  "hpstgmgr",
	2601:  "discp-client",
	2602:  "discp-server",
	2603:  "servicemeter",
	2604:  "nsc-ccs",
	2605:  "nsc-posa",
	2606:  "netmon",
	2607:  "connection",
	2608:  "wag-service",
	2609:  "system-monitor",
	2610:  "versa-tek",
	2611:  "lionhead",
	2612:  "qpasa-agent",
	2613:  "smntubootstrap",
	2614:  "neveroffline",
	2615:  "firepower",
	2616:  "appswitch-emp",
	2617:  "cmadmin",
	2618:  "priority-e-com",
	2619:  "bruce",
	2620:  "lpsrecommender",
	2621:  "miles-apart",
	2622:  "metricadbc",
	2623:  "lmdp",
	2624:  "aria",
	2625:  "blwnkl-port",
	2626:  "gbjd816",
	2627:  "moshebeeri",
	2628:  "dict",
	2629:  "sitaraserver",
	2630:  "sitaramgmt",
	2631:  "sitaradir",
	2632:  "irdg-post",
	2633:  "interintelli",
	2634:  "pk-electronics",
	2635:  "backburner",
	2636:  "solve",
	2637:  "imdocsvc",
	2638:  "sybaseanywhere",
	2639:  "aminet",
	2640:  "sai-sentlm",
	2641:  "hdl-srv",
	2642:  "tragic",
	2643:  "gte-samp",
	2644:  "travsoft-ipx-t",
	2645:  "novell-ipx-cmd",
	2646:  "and-lm",
	2647:  "syncserver",
	2648:  "upsnotifyprot",
	2649:  "vpsipport",
	2650:  "eristwoguns",
	2651:  "ebinsite",
	2652:  "interpathpanel",
	2653:  "sonus",
	2654:  "corel-vncadmin",
	2655:  "unglue",
	2656:  "kana",
	2657:  "sns-dispatcher",
	2658:  "sns-admin",
	2659:  "sns-query",
	2660:  "gcmonitor",
	2661:  "olhost",
	2662:  "bintec-capi",
	2663:  "bintec-tapi",
	2664:  "patrol-mq-gm",
	2665:  "patrol-mq-nm",
	2666:  "extensis",
	2667:  "alarm-clock-s",
	2668:  "alarm-clock-c",
	2669:  "toad",
	2670:  "tve-announce",
	2671:  "newlixreg",
	2672:  "nhserver",
	2673:  "firstcall42",
	2674:  "ewnn",
	2675:  "ttc-etap",
	2676:  "simslink",
	2677:  "gadgetgate1way",
	2678:  "gadgetgate2way",
	2679:  "syncserverssl",
	2680:  "pxc-sapxom",
	2681:  "mpnjsomb",
	2683:  "ncdloadbalance",
	2684:  "mpnjsosv",
	2685:  "mpnjsocl",
	2686:  "mpnjsomg",
	2687:  "pq-lic-mgmt",
	2688:  "md-cg-http",
	2689:  "fastlynx",
	2690:  "hp-nnm-data",
	2691:  "itinternet",
	2692:  "admins-lms",
	2694:  "pwrsevent",
	2695:  "vspread",
	2696:  "unifyadmin",
	2697:  "oce-snmp-trap",
	2698:  "mck-ivpip",
	2699:  "csoft-plusclnt",
	2700:  "tqdata",
	2701:  "sms-rcinfo",
	2702:  "sms-xfer",
	2703:  "sms-chat",
	2704:  "sms-remctrl",
	2705:  "sds-admin",
	2706:  "ncdmirroring",
	2707:  "emcsymapiport",
	2708:  "banyan-net",
	2709:  "supermon",
	2710:  "sso-service",
	2711:  "sso-control",
	2712:  "aocp",
	2713:  "raventbs",
	2714:  "raventdm",
	2715:  "hpstgmgr2",
	2716:  "inova-ip-disco",
	2717:  "pn-requester",
	2718:  "pn-requester2",
	2719:  "scan-change",
	2720:  "wkars",
	2721:  "smart-diagnose",
	2722:  "proactivesrvr",
	2723:  "watchdog-nt",
	2724:  "qotps",
	2725:  "msolap-ptp2",
	2726:  "tams",
	2727:  "mgcp-callagent",
	2728:  "sqdr",
	2729:  "tcim-control",
	2730:  "nec-raidplus",
	2731:  "fyre-messanger",
	2732:  "g5m",
	2733:  "signet-ctf",
	2734:  "ccs-software",
	2735:  "netiq-mc",
	2736:  "radwiz-nms-srv",
	2737:  "srp-feedback",
	2738:  "ndl-tcp-ois-gw",
	2739:  "tn-timing",
	2740:  "alarm",
	2741:  "tsb",
	2742:  "tsb2",
	2743:  "murx",
	2744:  "honyaku",
	2745:  "urbisnet",
	2746:  "cpudpencap",
	2747:  "fjippol-swrly",
	2748:  "fjippol-polsvr",
	2749:  "fjippol-cnsl",
	2750:  "fjippol-port1",
	2751:  "fjippol-port2",
	2752:  "rsisysaccess",
	2753:  "de-spot",
	2754:  "apollo-cc",
	2755:  "expresspay",
	2756:  "simplement-tie",
	2757:  "cnrp",
	2758:  "apollo-status",
	2759:  "apollo-gms",
	2760:  "sabams",
	2761:  "dicom-iscl",
	2762:  "dicom-tls",
	2763:  "desktop-dna",
	2764:  "data-insurance",
	2765:  "qip-audup",
	2766:  "compaq-scp",
	2767:  "uadtc",
	2768:  "uacs",
	2769:  "exce",
	2770:  "veronica",
	2771:  "vergencecm",
	2772:  "auris",
	2773:  "rbakcup1",
	2774:  "rbakcup2",
	2775:  "smpp",
	2776:  "ridgeway1",
	2777:  "ridgeway2",
	2778:  "gwen-sonya",
	2779:  "lbc-sync",
	2780:  "lbc-control",
	2781:  "whosells",
	2782:  "everydayrc",
	2783:  "aises",
	2784:  "www-dev",
	2785:  "aic-np",
	2786:  "aic-oncrpc",
	2787:  "piccolo",
	2788:  "fryeserv",
	2789:  "media-agent",
	2790:  "plgproxy",
	2791:  "mtport-regist",
	2792:  "f5-globalsite",
	2793:  "initlsmsad",
	2795:  "livestats",
	2796:  "ac-tech",
	2797:  "esp-encap",
	2798:  "tmesis-upshot",
	2799:  "icon-discover",
	2800:  "acc-raid",
	2801:  "igcp",
	2802:  "veritas-udp1",
	2803:  "btprjctrl",
	2804:  "dvr-esm",
	2805:  "wta-wsp-s",
	2806:  "cspuni",
	2807:  "cspmulti",
	2808:  "j-lan-p",
	2809:  "corbaloc",
	2810:  "netsteward",
	2811:  "gsiftp",
	2812:  "atmtcp",
	2813:  "llm-pass",
	2814:  "llm-csv",
	2815:  "lbc-measure",
	2816:  "lbc-watchdog",
	2817:  "nmsigport",
	2818:  "rmlnk",
	2819:  "fc-faultnotify",
	2820:  "univision",
	2821:  "vrts-at-port",
	2822:  "ka0wuc",
	2823:  "cqg-netlan",
	2824:  "cqg-netlan-1",
	2826:  "slc-systemlog",
	2827:  "slc-ctrlrloops",
	2828:  "itm-lm",
	2829:  "silkp1",
	2830:  "silkp2",
	2831:  "silkp3",
	2832:  "silkp4",
	2833:  "glishd",
	2834:  "evtp",
	2835:  "evtp-data",
	2836:  "catalyst",
	2837:  "repliweb",
	2838:  "starbot",
	2839:  "nmsigport",
	2840:  "l3-exprt",
	2841:  "l3-ranger",
	2842:  "l3-hawk",
	2843:  "pdnet",
	2844:  "bpcp-poll",
	2845:  "bpcp-trap",
	2846:  "aimpp-hello",
	2847:  "aimpp-port-req",
	2848:  "amt-blc-port",
	2849:  "fxp",
	2850:  "metaconsole",
	2851:  "webemshttp",
	2852:  "bears-01",
	2853:  "ispipes",
	2854:  "infomover",
	2856:  "cesdinv",
	2857:  "simctlp",
	2858:  "ecnp",
	2859:  "activememory",
	2860:  "dialpad-voice1",
	2861:  "dialpad-voice2",
	2862:  "ttg-protocol",
	2863:  "sonardata",
	2864:  "astromed-main",
	2865:  "pit-vpn",
	2866:  "iwlistener",
	2867:  "esps-portal",
	2868:  "npep-messaging",
	2869:  "icslap",
	2870:  "daishi",
	2871:  "msi-selectplay",
	2872:  "radix",
	2874:  "dxmessagebase1",
	2875:  "dxmessagebase2",
	2876:  "sps-tunnel",
	2877:  "bluelance",
	2878:  "aap",
	2879:  "ucentric-ds",
	2880:  "synapse",
	2881:  "ndsp",
	2882:  "ndtp",
	2883:  "ndnp",
	2884:  "flashmsg",
	2885:  "topflow",
	2886:  "responselogic",
	2887:  "aironetddp",
	2888:  "spcsdlobby",
	2889:  "rsom",
	2890:  "cspclmulti",
	2891:  "cinegrfx-elmd",
	2892:  "snifferdata",
	2893:  "vseconnector",
	2894:  "abacus-remote",
	2895:  "natuslink",
	2896:  "ecovisiong6-1",
	2897:  "citrix-rtmp",
	2898:  "appliance-cfg",
	2899:  "powergemplus",
	2900:  "quicksuite",
	2901:  "allstorcns",
	2902:  "netaspi",
	2903:  "suitcase",
	2904:  "m2ua",
	2906:  "caller9",
	2907:  "webmethods-b2b",
	2908:  "mao",
	2909:  "funk-dialout",
	2910:  "tdaccess",
	2911:  "blockade",
	2912:  "epicon",
	2913:  "boosterware",
	2914:  "gamelobby",
	2915:  "tksocket",
	2916:  "elvin-server",
	2917:  "elvin-client",
	2918:  "kastenchasepad",
	2919:  "roboer",
	2920:  "roboeda",
	2921:  "cesdcdman",
	2922:  "cesdcdtrn",
	2923:  "wta-wsp-wtp-s",
	2924:  "precise-vip",
	2926:  "mobile-file-dl",
	2927:  "unimobilectrl",
	2928:  "redstone-cpss",
	2929:  "amx-webadmin",
	2930:  "amx-weblinx",
	2931:  "circle-x",
	2932:  "incp",
	2933:  "4-tieropmgw",
	2934:  "4-tieropmcli",
	2935:  "qtp",
	2936:  "otpatch",
	2937:  "pnaconsult-lm",
	2938:  "sm-pas-1",
	2939:  "sm-pas-2",
	2940:  "sm-pas-3",
	2941:  "sm-pas-4",
	2942:  "sm-pas-5",
	2943:  "ttnrepository",
	2944:  "megaco-h248",
	2945:  "h248-binary",
	2946:  "fjsvmpor",
	2947:  "gpsd",
	2948:  "wap-push",
	2949:  "wap-pushsecure",
	2950:  "esip",
	2951:  "ottp",
	2952:  "mpfwsas",
	2953:  "ovalarmsrv",
	2954:  "ovalarmsrv-cmd",
	2955:  "csnotify",
	2956:  "ovrimosdbman",
	2957:  "jmact5",
	2958:  "jmact6",
	2959:  "rmopagt",
	2960:  "dfoxserver",
	2961:  "boldsoft-lm",
	2962:  "iph-policy-cli",
	2963:  "iph-policy-adm",
	2964:  "bullant-srap",
	2965:  "bullant-rap",
	2966:  "idp-infotrieve",
	2967:  "ssc-agent",
	2968:  "enpp",
	2969:  "essp",
	2970:  "index-net",
	2971:  "netclip",
	2972:  "pmsm-webrctl",
	2973:  "svnetworks",
	2974:  "signal",
	2975:  "fjmpcm",
	2976:  "cns-srv-port",
	2977:  "ttc-etap-ns",
	2978:  "ttc-etap-ds",
	2979:  "h263-video",
	2980:  "wimd",
	2981:  "mylxamport",
	2982:  "iwb-whiteboard",
	2983:  "netplan",
	2984:  "hpidsadmin",
	2985:  "hpidsagent",
	2986:  "stonefalls",
	2987:  "identify",
	2988:  "hippad",
	2989:  "zarkov",
	2990:  "boscap",
	2991:  "wkstn-mon",
	2992:  "avenyo",
	2993:  "veritas-vis1",
	2994:  "veritas-vis2",
	2995:  "idrs",
	2996:  "vsixml",
	2997:  "rebol",
	2998:  "realsecure",
	2999:  "remoteware-un",
	3000:  "hbci",
	3002:  "exlm-agent",
	3003:  "cgms",
	3004:  "csoftragent",
	3005:  "geniuslm",
	3006:  "ii-admin",
	3007:  "lotusmtap",
	3008:  "midnight-tech",
	3009:  "pxc-ntfy",
	3010:  "ping-pong",
	3011:  "trusted-web",
	3012:  "twsdss",
	3013:  "gilatskysurfer",
	3014:  "broker-service",
	3015:  "nati-dstp",
	3016:  "notify-srvr",
	3017:  "event-listener",
	3018:  "srvc-registry",
	3019:  "resource-mgr",
	3020:  "cifs",
	3021:  "agriserver",
	3022:  "csregagent",
	3023:  "magicnotes",
	3024:  "nds-sso",
	3025:  "arepa-raft",
	3026:  "agri-gateway",
	3027:  "LiebDevMgmt-C",
	3028:  "LiebDevMgmt-DM",
	3029:  "LiebDevMgmt-A",
	3030:  "arepa-cas",
	3031:  "eppc",
	3032:  "redwood-chat",
	3033:  "pdb",
	3034:  "osmosis-aeea",
	3035:  "fjsv-gssagt",
	3036:  "hagel-dump",
	3037:  "hp-san-mgmt",
	3038:  "santak-ups",
	3039:  "cogitate",
	3040:  "tomato-springs",
	3041:  "di-traceware",
	3042:  "journee",
	3043:  "brp",
	3044:  "epp",
	3045:  "responsenet",
	3046:  "di-ase",
	3047:  "hlserver",
	3048:  "pctrader",
	3049:  "nsws",
	3050:  "gds-db",
	3051:  "galaxy-server",
	3052:  "apc-3052",
	3053:  "dsom-server",
	3054:  "amt-cnf-prot",
	3055:  "policyserver",
	3056:  "cdl-server",
	3057:  "goahead-fldup",
	3058:  "videobeans",
	3059:  "qsoft",
	3060:  "interserver",
	3061:  "cautcpd",
	3062:  "ncacn-ip-tcp",
	3063:  "ncadg-ip-udp",
	3064:  "rprt",
	3065:  "slinterbase",
	3066:  "netattachsdmp",
	3067:  "fjhpjp",
	3068:  "ls3bcast",
	3069:  "ls3",
	3070:  "mgxswitch",
	3071:  "csd-mgmt-port",
	3072:  "csd-monitor",
	3073:  "vcrp",
	3074:  "xbox",
	3075:  "orbix-locator",
	3076:  "orbix-config",
	3077:  "orbix-loc-ssl",
	3078:  "orbix-cfg-ssl",
	3079:  "lv-frontpanel",
	3080:  "stm-pproc",
	3081:  "tl1-lv",
	3082:  "tl1-raw",
	3083:  "tl1-telnet",
	3084:  "itm-mccs",
	3085:  "pcihreq",
	3086:  "jdl-dbkitchen",
	3087:  "asoki-sma",
	3088:  "xdtp",
	3089:  "ptk-alink",
	3090:  "stss",
	3091:  "1ci-smcs",
	3093:  "rapidmq-center",
	3094:  "rapidmq-reg",
	3095:  "panasas",
	3096:  "ndl-aps",
	3098:  "umm-port",
	3099:  "chmd",
	3100:  "opcon-xps",
	3101:  "hp-pxpib",
	3102:  "slslavemon",
	3103:  "autocuesmi",
	3104:  "autocuetime",
	3105:  "cardbox",
	3106:  "cardbox-http",
	3107:  "business",
	3108:  "geolocate",
	3109:  "personnel",
	3110:  "sim-control",
	3111:  "wsynch",
	3112:  "ksysguard",
	3113:  "cs-auth-svr",
	3114:  "ccmad",
	3115:  "mctet-master",
	3116:  "mctet-gateway",
	3117:  "mctet-jserv",
	3118:  "pkagent",
	3119:  "d2000kernel",
	3120:  "d2000webserver",
	3122:  "vtr-emulator",
	3123:  "edix",
	3124:  "beacon-port",
	3125:  "a13-an",
	3127:  "ctx-bridge",
	3128:  "ndl-aas",
	3129:  "netport-id",
	3130:  "icpv2",
	3131:  "netbookmark",
	3132:  "ms-rule-engine",
	3133:  "prism-deploy",
	3134:  "ecp",
	3135:  "peerbook-port",
	3136:  "grubd",
	3137:  "rtnt-1",
	3138:  "rtnt-2",
	3139:  "incognitorv",
	3140:  "ariliamulti",
	3141:  "vmodem",
	3142:  "rdc-wh-eos",
	3143:  "seaview",
	3144:  "tarantella",
	3145:  "csi-lfap",
	3146:  "bears-02",
	3147:  "rfio",
	3148:  "nm-game-admin",
	3149:  "nm-game-server",
	3150:  "nm-asses-admin",
	3151:  "nm-assessor",
	3152:  "feitianrockey",
	3153:  "s8-client-port",
	3154:  "ccmrmi",
	3155:  "jpegmpeg",
	3156:  "indura",
	3157:  "e3consultants",
	3158:  "stvp",
	3159:  "navegaweb-port",
	3160:  "tip-app-server",
	3161:  "doc1lm",
	3162:  "sflm",
	3163:  "res-sap",
	3164:  "imprs",
	3165:  "newgenpay",
	3166:  "sossecollector",
	3167:  "nowcontact",
	3168:  "poweronnud",
	3169:  "serverview-as",
	3170:  "serverview-asn",
	3171:  "serverview-gf",
	3172:  "serverview-rm",
	3173:  "serverview-icc",
	3174:  "armi-server",
	3175:  "t1-e1-over-ip",
	3176:  "ars-master",
	3177:  "phonex-port",
	3178:  "radclientport",
	3179:  "h2gf-w-2m",
	3180:  "mc-brk-srv",
	3181:  "bmcpatrolagent",
	3182:  "bmcpatrolrnvu",
	3183:  "cops-tls",
	3184:  "apogeex-port",
	3185:  "smpppd",
	3186:  "iiw-port",
	3187:  "odi-port",
	3188:  "brcm-comm-port",
	3189:  "pcle-infex",
	3190:  "csvr-proxy",
	3191:  "csvr-sslproxy",
	3192:  "firemonrcc",
	3193:  "spandataport",
	3194:  "magbind",
	3195:  "ncu-1",
	3196:  "ncu-2",
	3197:  "embrace-dp-s",
	3198:  "embrace-dp-c",
	3199:  "dmod-workspace",
	3200:  "tick-port",
	3201:  "cpq-tasksmart",
	3202:  "intraintra",
	3203:  "netwatcher-mon",
	3204:  "netwatcher-db",
	3205:  "isns",
	3206:  "ironmail",
	3207:  "vx-auth-port",
	3208:  "pfu-prcallback",
	3209:  "netwkpathengine",
	3210:  "flamenco-proxy",
	3211:  "avsecuremgmt",
	3212:  "surveyinst",
	3213:  "neon24x7",
	3214:  "jmq-daemon-1",
	3215:  "jmq-daemon-2",
	3216:  "ferrari-foam",
	3217:  "unite",
	3218:  "smartpackets",
	3219:  "wms-messenger",
	3220:  "xnm-ssl",
	3221:  "xnm-clear-text",
	3222:  "glbp",
	3223:  "digivote",
	3224:  "aes-discovery",
	3225:  "fcip-port",
	3226:  "isi-irp",
	3227:  "dwnmshttp",
	3228:  "dwmsgserver",
	3229:  "global-cd-port",
	3230:  "sftdst-port",
	3231:  "vidigo",
	3232:  "mdtp",
	3233:  "whisker",
	3234:  "alchemy",
	3235:  "mdap-port",
	3236:  "apparenet-ts",
	3237:  "apparenet-tps",
	3238:  "apparenet-as",
	3239:  "apparenet-ui",
	3240:  "triomotion",
	3241:  "sysorb",
	3242:  "sdp-id-port",
	3243:  "timelot",
	3244:  "onesaf",
	3245:  "vieo-fe",
	3246:  "dvt-system",
	3247:  "dvt-data",
	3248:  "procos-lm",
	3249:  "ssp",
	3250:  "hicp",
	3251:  "sysscanner",
	3252:  "dhe",
	3253:  "pda-data",
	3254:  "pda-sys",
	3255:  "semaphore",
	3256:  "cpqrpm-agent",
	3257:  "cpqrpm-server",
	3258:  "ivecon-port",
	3259:  "epncdp2",
	3260:  "iscsi-target",
	3261:  "winshadow",
	3262:  "necp",
	3263:  "ecolor-imager",
	3264:  "ccmail",
	3265:  "altav-tunnel",
	3266:  "ns-cfg-server",
	3267:  "ibm-dial-out",
	3268:  "msft-gc",
	3269:  "msft-gc-ssl",
	3270:  "verismart",
	3271:  "csoft-prev",
	3272:  "user-manager",
	3273:  "sxmp",
	3274:  "ordinox-server",
	3275:  "samd",
	3276:  "maxim-asics",
	3277:  "awg-proxy",
	3278:  "lkcmserver",
	3279:  "admind",
	3280:  "vs-server",
	3281:  "sysopt",
	3282:  "datusorb",
	3283:  "Apple Remote Desktop (Net Assistant)",
	3284:  "4talk",
	3285:  "plato",
	3286:  "e-net",
	3287:  "directvdata",
	3288:  "cops",
	3289:  "enpc",
	3290:  "caps-lm",
	3291:  "sah-lm",
	3292:  "cart-o-rama",
	3293:  "fg-fps",
	3294:  "fg-gip",
	3295:  "dyniplookup",
	3296:  "rib-slm",
	3297:  "cytel-lm",
	3298:  "deskview",
	3299:  "pdrncs",
	3302:  "mcs-fastmail",
	3303:  "opsession-clnt",
	3304:  "opsession-srvr",
	3305:  "odette-ftp",
	3306:  "mysql",
	3307:  "opsession-prxy",
	3308:  "tns-server",
	3309:  "tns-adv",
	3310:  "dyna-access",
	3311:  "mcns-tel-ret",
	3312:  "appman-server",
	3313:  "uorb",
	3314:  "uohost",
	3315:  "cdid",
	3316:  "aicc-cmi",
	3317:  "vsaiport",
	3318:  "ssrip",
	3319:  "sdt-lmd",
	3320:  "officelink2000",
	3321:  "vnsstr",
	3326:  "sftu",
	3327:  "bbars",
	3328:  "egptlm",
	3329:  "hp-device-disc",
	3330:  "mcs-calypsoicf",
	3331:  "mcs-messaging",
	3332:  "mcs-mailsvr",
	3333:  "dec-notes",
	3334:  "directv-web",
	3335:  "directv-soft",
	3336:  "directv-tick",
	3337:  "directv-catlg",
	3338:  "anet-b",
	3339:  "anet-l",
	3340:  "anet-m",
	3341:  "anet-h",
	3342:  "webtie",
	3343:  "ms-cluster-net",
	3344:  "bnt-manager",
	3345:  "influence",
	3346:  "trnsprntproxy",
	3347:  "phoenix-rpc",
	3348:  "pangolin-laser",
	3349:  "chevinservices",
	3350:  "findviatv",
	3351:  "btrieve",
	3352:  "ssql",
	3353:  "fatpipe",
	3354:  "suitjd",
	3355:  "ordinox-dbase",
	3356:  "upnotifyps",
	3357:  "adtech-test",
	3358:  "mpsysrmsvr",
	3359:  "wg-netforce",
	3360:  "kv-server",
	3361:  "kv-agent",
	3362:  "dj-ilm",
	3363:  "nati-vi-server",
	3364:  "creativeserver",
	3365:  "contentserver",
	3366:  "creativepartnr",
	3372:  "tip2",
	3373:  "lavenir-lm",
	3374:  "cluster-disc",
	3375:  "vsnm-agent",
	3376:  "cdbroker",
	3377:  "cogsys-lm",
	3378:  "wsicopy",
	3379:  "socorfs",
	3380:  "sns-channels",
	3381:  "geneous",
	3382:  "fujitsu-neat",
	3383:  "esp-lm",
	3384:  "hp-clic",
	3385:  "qnxnetman",
	3386:  "gprs-sig",
	3387:  "backroomnet",
	3388:  "cbserver",
	3389:  "ms-wbt-server",
	3390:  "dsc",
	3391:  "savant",
	3392:  "efi-lm",
	3393:  "d2k-tapestry1",
	3394:  "d2k-tapestry2",
	3395:  "dyna-lm",
	3396:  "printer-agent",
	3397:  "cloanto-lm",
	3398:  "mercantile",
	3399:  "csms",
	3400:  "csms2",
	3401:  "filecast",
	3402:  "fxaengine-net",
	3405:  "nokia-ann-ch1",
	3406:  "nokia-ann-ch2",
	3407:  "ldap-admin",
	3408:  "BESApi",
	3409:  "networklens",
	3410:  "networklenss",
	3411:  "biolink-auth",
	3412:  "xmlblaster",
	3413:  "svnet",
	3414:  "wip-port",
	3415:  "bcinameservice",
	3416:  "commandport",
	3417:  "csvr",
	3418:  "rnmap",
	3419:  "softaudit",
	3420:  "ifcp-port",
	3421:  "bmap",
	3422:  "rusb-sys-port",
	3423:  "xtrm",
	3424:  "xtrms",
	3425:  "agps-port",
	3426:  "arkivio",
	3427:  "websphere-snmp",
	3428:  "twcss",
	3429:  "gcsp",
	3430:  "ssdispatch",
	3431:  "ndl-als",
	3432:  "osdcp",
	3433:  "opnet-smp",
	3434:  "opencm",
	3435:  "pacom",
	3436:  "gc-config",
	3437:  "autocueds",
	3438:  "spiral-admin",
	3439:  "hri-port",
	3440:  "ans-console",
	3441:  "connect-client",
	3442:  "connect-server",
	3443:  "ov-nnm-websrv",
	3444:  "denali-server",
	3445:  "monp",
	3446:  "3comfaxrpc",
	3447:  "directnet",
	3448:  "dnc-port",
	3449:  "hotu-chat",
	3450:  "castorproxy",
	3451:  "asam",
	3452:  "sabp-signal",
	3453:  "pscupd",
	3454:  "mira",
	3455:  "prsvp",
	3456:  "vat",
	3457:  "vat-control",
	3458:  "d3winosfi",
	3459:  "integral",
	3460:  "edm-manager",
	3461:  "edm-stager",
	3462:  "edm-std-notify",
	3463:  "edm-adm-notify",
	3464:  "edm-mgr-sync",
	3465:  "edm-mgr-cntrl",
	3466:  "workflow",
	3467:  "rcst",
	3468:  "ttcmremotectrl",
	3469:  "pluribus",
	3470:  "jt400",
	3471:  "jt400-ssl",
	3472:  "jaugsremotec-1",
	3473:  "jaugsremotec-2",
	3474:  "ttntspauto",
	3475:  "genisar-port",
	3476:  "nppmp",
	3477:  "ecomm",
	3478:  "stun",
	3479:  "twrpc",
	3480:  "plethora",
	3481:  "cleanerliverc",
	3482:  "vulture",
	3483:  "slim-devices",
	3484:  "gbs-stp",
	3485:  "celatalk",
	3486:  "ifsf-hb-port",
	3487:  "ltcudp",
	3488:  "fs-rh-srv",
	3489:  "dtp-dia",
	3490:  "colubris",
	3491:  "swr-port",
	3492:  "tvdumtray-port",
	3493:  "nut",
	3494:  "ibm3494",
	3495:  "seclayer-tcp",
	3496:  "seclayer-tls",
	3497:  "ipether232port",
	3498:  "dashpas-port",
	3499:  "sccip-media",
	3500:  "rtmp-port",
	3501:  "isoft-p2p",
	3502:  "avinstalldisc",
	3503:  "lsp-ping",
	3504:  "ironstorm",
	3505:  "ccmcomm",
	3506:  "apc-3506",
	3507:  "nesh-broker",
	3508:  "interactionweb",
	3509:  "vt-ssl",
	3510:  "xss-port",
	3511:  "webmail-2",
	3512:  "aztec",
	3513:  "arcpd",
	3514:  "must-p2p",
	3515:  "must-backplane",
	3516:  "smartcard-port",
	3517:  "802-11-iapp",
	3518:  "artifact-msg",
	3519:  "galileo",
	3520:  "galileolog",
	3521:  "mc3ss",
	3522:  "nssocketport",
	3523:  "odeumservlink",
	3524:  "ecmport",
	3525:  "eisport",
	3526:  "starquiz-port",
	3527:  "beserver-msg-q",
	3528:  "jboss-iiop",
	3529:  "jboss-iiop-ssl",
	3530:  "gf",
	3531:  "joltid",
	3532:  "raven-rmp",
	3533:  "raven-rdp",
	3534:  "urld-port",
	3535:  "ms-la",
	3536:  "snac",
	3537:  "ni-visa-remote",
	3538:  "ibm-diradm",
	3539:  "ibm-diradm-ssl",
	3540:  "pnrp-port",
	3541:  "voispeed-port",
	3542:  "hacl-monitor",
	3543:  "qftest-lookup",
	3544:  "teredo",
	3545:  "camac",
	3547:  "symantec-sim",
	3548:  "interworld",
	3549:  "tellumat-nms",
	3550:  "ssmpp",
	3551:  "apcupsd",
	3552:  "taserver",
	3553:  "rbr-discovery",
	3554:  "questnotify",
	3555:  "razor",
	3556:  "sky-transport",
	3557:  "personalos-001",
	3558:  "mcp-port",
	3559:  "cctv-port",
	3560:  "iniserve-port",
	3561:  "bmc-onekey",
	3562:  "sdbproxy",
	3563:  "watcomdebug",
	3564:  "esimport",
	3567:  "enc-eps",
	3568:  "enc-tunnel-sec",
	3569:  "mbg-ctrl",
	3570:  "mccwebsvr-port",
	3571:  "megardsvr-port",
	3572:  "megaregsvrport",
	3573:  "tag-ups-1",
	3574:  "dmaf-caster",
	3575:  "ccm-port",
	3576:  "cmc-port",
	3577:  "config-port",
	3578:  "data-port",
	3579:  "ttat3lb",
	3580:  "nati-svrloc",
	3581:  "kfxaclicensing",
	3582:  "press",
	3583:  "canex-watch",
	3584:  "u-dbap",
	3585:  "emprise-lls",
	3586:  "emprise-lsc",
	3587:  "p2pgroup",
	3588:  "sentinel",
	3589:  "isomair",
	3590:  "wv-csp-sms",
	3591:  "gtrack-server",
	3592:  "gtrack-ne",
	3593:  "bpmd",
	3594:  "mediaspace",
	3595:  "shareapp",
	3596:  "iw-mmogame",
	3597:  "a14",
	3598:  "a15",
	3599:  "quasar-server",
	3600:  "trap-daemon",
	3601:  "visinet-gui",
	3602:  "infiniswitchcl",
	3603:  "int-rcv-cntrl",
	3604:  "bmc-jmx-port",
	3605:  "comcam-io",
	3606:  "splitlock",
	3607:  "precise-i3",
	3608:  "trendchip-dcp",
	3609:  "cpdi-pidas-cm",
	3610:  "echonet",
	3611:  "six-degrees",
	3612:  "hp-dataprotect",
	3613:  "alaris-disc",
	3614:  "sigma-port",
	3615:  "start-network",
	3616:  "cd3o-protocol",
	3617:  "sharp-server",
	3618:  "aairnet-1",
	3619:  "aairnet-2",
	3620:  "ep-pcp",
	3621:  "ep-nsp",
	3622:  "ff-lr-port",
	3623:  "haipe-discover",
	3624:  "dist-upgrade",
	3625:  "volley",
	3626:  "bvcdaemon-port",
	3627:  "jamserverport",
	3628:  "ept-machine",
	3629:  "escvpnet",
	3630:  "cs-remote-db",
	3631:  "cs-services",
	3632:  "distcc",
	3633:  "wacp",
	3634:  "hlibmgr",
	3635:  "sdo",
	3636:  "servistaitsm",
	3637:  "scservp",
	3638:  "ehp-backup",
	3639:  "xap-ha",
	3640:  "netplay-port1",
	3641:  "netplay-port2",
	3642:  "juxml-port",
	3643:  "audiojuggler",
	3644:  "ssowatch",
	3645:  "cyc",
	3646:  "xss-srv-port",
	3647:  "splitlock-gw",
	3648:  "fjcp",
	3649:  "nmmp",
	3650:  "prismiq-plugin",
	3651:  "xrpc-registry",
	3652:  "vxcrnbuport",
	3653:  "tsp",
	3654:  "vaprtm",
	3655:  "abatemgr",
	3656:  "abatjss",
	3657:  "immedianet-bcn",
	3658:  "ps-ams",
	3659:  "apple-sasl",
	3660:  "can-nds-ssl",
	3661:  "can-ferret-ssl",
	3662:  "pserver",
	3663:  "dtp",
	3664:  "ups-engine",
	3665:  "ent-engine",
	3666:  "eserver-pap",
	3667:  "infoexch",
	3668:  "dell-rm-port",
	3669:  "casanswmgmt",
	3670:  "smile",
	3671:  "efcp",
	3672:  "lispworks-orb",
	3673:  "mediavault-gui",
	3674:  "wininstall-ipc",
	3675:  "calltrax",
	3676:  "va-pacbase",
	3677:  "roverlog",
	3678:  "ipr-dglt",
	3679:  "Escale (Newton Dock)",
	3680:  "npds-tracker",
	3681:  "bts-x73",
	3682:  "cas-mapi",
	3683:  "bmc-ea",
	3684:  "faxstfx-port",
	3685:  "dsx-agent",
	3686:  "tnmpv2",
	3687:  "simple-push",
	3688:  "simple-push-s",
	3689:  "daap",
	3690:  "svn",
	3691:  "magaya-network",
	3692:  "intelsync",
	3695:  "bmc-data-coll",
	3696:  "telnetcpcd",
	3697:  "nw-license",
	3698:  "sagectlpanel",
	3699:  "kpn-icw",
	3700:  "lrs-paging",
	3701:  "netcelera",
	3702:  "ws-discovery",
	3703:  "adobeserver-3",
	3704:  "adobeserver-4",
	3705:  "adobeserver-5",
	3706:  "rt-event",
	3707:  "rt-event-s",
	3708:  "sun-as-iiops",
	3709:  "ca-idms",
	3710:  "portgate-auth",
	3711:  "edb-server2",
	3712:  "sentinel-ent",
	3713:  "tftps",
	3714:  "delos-dms",
	3715:  "anoto-rendezv",
	3716:  "wv-csp-sms-cir",
	3717:  "wv-csp-udp-cir",
	3718:  "opus-services",
	3719:  "itelserverport",
	3720:  "ufastro-instr",
	3721:  "xsync",
	3722:  "xserveraid",
	3723:  "sychrond",
	3724:  "blizwow",
	3725:  "na-er-tip",
	3726:  "array-manager",
	3727:  "e-mdu",
	3728:  "e-woa",
	3729:  "fksp-audit",
	3730:  "client-ctrl",
	3731:  "smap",
	3732:  "m-wnn",
	3733:  "multip-msg",
	3734:  "synel-data",
	3735:  "pwdis",
	3736:  "rs-rmi",
	3738:  "versatalk",
	3739:  "launchbird-lm",
	3740:  "heartbeat",
	3741:  "wysdma",
	3742:  "cst-port",
	3743:  "ipcs-command",
	3744:  "sasg",
	3745:  "gw-call-port",
	3746:  "linktest",
	3747:  "linktest-s",
	3748:  "webdata",
	3749:  "cimtrak",
	3750:  "cbos-ip-port",
	3751:  "gprs-cube",
	3752:  "vipremoteagent",
	3753:  "nattyserver",
	3754:  "timestenbroker",
	3755:  "sas-remote-hlp",
	3756:  "canon-capt",
	3757:  "grf-port",
	3758:  "apw-registry",
	3759:  "exapt-lmgr",
	3760:  "adtempusclient",
	3761:  "gsakmp",
	3762:  "gbs-smp",
	3763:  "xo-wave",
	3764:  "mni-prot-rout",
	3765:  "rtraceroute",
	3767:  "listmgr-port",
	3768:  "rblcheckd",
	3769:  "haipe-otnk",
	3770:  "cindycollab",
	3771:  "paging-port",
	3772:  "ctp",
	3773:  "ctdhercules",
	3774:  "zicom",
	3775:  "ispmmgr",
	3776:  "dvcprov-port",
	3777:  "jibe-eb",
	3778:  "c-h-it-port",
	3779:  "cognima",
	3780:  "nnp",
	3781:  "abcvoice-port",
	3782:  "iso-tp0s",
	3783:  "bim-pem",
	3784:  "bfd-control",
	3785:  "bfd-echo",
	3786:  "upstriggervsw",
	3787:  "fintrx",
	3788:  "isrp-port",
	3789:  "remotedeploy",
	3790:  "quickbooksrds",
	3791:  "tvnetworkvideo",
	3792:  "sitewatch",
	3793:  "dcsoftware",
	3794:  "jaus",
	3795:  "myblast",
	3796:  "spw-dialer",
	3797:  "idps",
	3798:  "minilock",
	3799:  "radius-dynauth",
	3800:  "pwgpsi",
	3801:  "ibm-mgr",
	3802:  "vhd",
	3803:  "soniqsync",
	3804:  "iqnet-port",
	3805:  "tcpdataserver",
	3806:  "wsmlb",
	3807:  "spugna",
	3808:  "sun-as-iiops-ca",
	3809:  "apocd",
	3810:  "wlanauth",
	3811:  "amp",
	3812:  "neto-wol-server",
	3813:  "rap-ip",
	3814:  "neto-dcs",
	3815:  "lansurveyorxml",
	3816:  "sunlps-http",
	3817:  "tapeware",
	3818:  "crinis-hb",
	3819:  "epl-slp",
	3820:  "scp",
	3821:  "pmcp",
	3822:  "acp-discovery",
	3823:  "acp-conduit",
	3824:  "acp-policy",
	3825:  "ffserver",
	3826:  "warmux",
	3827:  "netmpi",
	3828:  "neteh",
	3829:  "neteh-ext",
	3830:  "cernsysmgmtagt",
	3831:  "dvapps",
	3832:  "xxnetserver",
	3833:  "aipn-auth",
	3834:  "spectardata",
	3835:  "spectardb",
	3836:  "markem-dcp",
	3837:  "mkm-discovery",
	3838:  "sos",
	3839:  "amx-rms",
	3840:  "flirtmitmir",
	3842:  "nhci",
	3843:  "quest-agent",
	3844:  "rnm",
	3845:  "v-one-spp",
	3846:  "an-pcp",
	3847:  "msfw-control",
	3848:  "item",
	3849:  "spw-dnspreload",
	3850:  "qtms-bootstrap",
	3851:  "spectraport",
	3852:  "sse-app-config",
	3853:  "sscan",
	3854:  "stryker-com",
	3855:  "opentrac",
	3856:  "informer",
	3857:  "trap-port",
	3858:  "trap-port-mom",
	3859:  "nav-port",
	3860:  "sasp",
	3861:  "winshadow-hd",
	3862:  "giga-pocket",
	3863:  "asap-udp",
	3865:  "xpl",
	3866:  "dzdaemon",
	3867:  "dzoglserver",
	3869:  "ovsam-mgmt",
	3870:  "ovsam-d-agent",
	3871:  "avocent-adsap",
	3872:  "oem-agent",
	3873:  "fagordnc",
	3874:  "sixxsconfig",
	3875:  "pnbscada",
	3876:  "dl-agent",
	3877:  "xmpcr-interface",
	3878:  "fotogcad",
	3879:  "appss-lm",
	3880:  "igrs",
	3881:  "idac",
	3882:  "msdts1",
	3883:  "vrpn",
	3884:  "softrack-meter",
	3885:  "topflow-ssl",
	3886:  "nei-management",
	3887:  "ciphire-data",
	3888:  "ciphire-serv",
	3889:  "dandv-tester",
	3890:  "ndsconnect",
	3891:  "rtc-pm-port",
	3892:  "pcc-image-port",
	3893:  "cgi-starapi",
	3894:  "syam-agent",
	3895:  "syam-smc",
	3896:  "sdo-tls",
	3897:  "sdo-ssh",
	3898:  "senip",
	3899:  "itv-control",
	3900:  "udt-os",
	3901:  "nimsh",
	3902:  "nimaux",
	3903:  "charsetmgr",
	3904:  "omnilink-port",
	3905:  "mupdate",
	3906:  "topovista-data",
	3907:  "imoguia-port",
	3908:  "hppronetman",
	3909:  "surfcontrolcpa",
	3910:  "prnrequest",
	3911:  "prnstatus",
	3912:  "gbmt-stars",
	3913:  "listcrt-port",
	3914:  "listcrt-port-2",
	3915:  "agcat",
	3916:  "wysdmc",
	3917:  "aftmux",
	3918:  "pktcablemmcops",
	3919:  "hyperip",
	3920:  "exasoftport1",
	3921:  "herodotus-net",
	3922:  "sor-update",
	3923:  "symb-sb-port",
	3924:  "mpl-gprs-port",
	3925:  "zmp",
	3926:  "winport",
	3927:  "natdataservice",
	3928:  "netboot-pxe",
	3929:  "smauth-port",
	3930:  "syam-webserver",
	3931:  "msr-plugin-port",
	3932:  "dyn-site",
	3933:  "plbserve-port",
	3934:  "sunfm-port",
	3935:  "sdp-portmapper",
	3936:  "mailprox",
	3937:  "dvbservdsc",
	3938:  "dbcontrol-agent",
	3939:  "aamp",
	3940:  "xecp-node",
	3941:  "homeportal-web",
	3942:  "srdp",
	3943:  "tig",
	3944:  "sops",
	3945:  "emcads",
	3946:  "backupedge",
	3947:  "ccp",
	3948:  "apdap",
	3949:  "drip",
	3950:  "namemunge",
	3951:  "pwgippfax",
	3952:  "i3-sessionmgr",
	3953:  "xmlink-connect",
	3954:  "adrep",
	3955:  "p2pcommunity",
	3956:  "gvcp",
	3957:  "mqe-broker",
	3958:  "mqe-agent",
	3959:  "treehopper",
	3960:  "bess",
	3961:  "proaxess",
	3962:  "sbi-agent",
	3963:  "thrp",
	3964:  "sasggprs",
	3965:  "ati-ip-to-ncpe",
	3966:  "bflckmgr",
	3967:  "ppsms",
	3968:  "ianywhere-dbns",
	3969:  "landmarks",
	3970:  "lanrevagent",
	3971:  "lanrevserver",
	3972:  "iconp",
	3973:  "progistics",
	3974:  "citysearch",
	3975:  "airshot",
	3976:  "opswagent",
	3977:  "opswmanager",
	3978:  "secure-cfg-svr",
	3979:  "smwan",
	3980:  "acms",
	3981:  "starfish",
	3982:  "eis",
	3983:  "eisp",
	3984:  "mapper-nodemgr",
	3985:  "mapper-mapethd",
	3986:  "mapper-ws-ethd",
	3987:  "centerline",
	3988:  "dcs-config",
	3989:  "bv-queryengine",
	3990:  "bv-is",
	3991:  "bv-smcsrv",
	3992:  "bv-ds",
	3993:  "bv-agent",
	3995:  "iss-mgmt-ssl",
	3996:  "abcsoftware",
	3997:  "agentsease-db",
	3998:  "dnx",
	3999:  "nvcnet",
	4000:  "terabase",
	4001:  "newoak",
	4002:  "pxc-spvr-ft",
	4003:  "pxc-splr-ft",
	4004:  "pxc-roid",
	4005:  "pxc-pin",
	4006:  "pxc-spvr",
	4007:  "pxc-splr",
	4008:  "netcheque",
	4009:  "chimera-hwm",
	4010:  "samsung-unidex",
	4011:  "altserviceboot",
	4012:  "pda-gate",
	4013:  "acl-manager",
	4014:  "taiclock",
	4015:  "talarian-mcast1",
	4016:  "talarian-mcast2",
	4017:  "talarian-mcast3",
	4018:  "talarian-mcast4",
	4019:  "talarian-mcast5",
	4020:  "trap",
	4021:  "nexus-portal",
	4022:  "dnox",
	4023:  "esnm-zoning",
	4024:  "tnp1-port",
	4025:  "partimage",
	4026:  "as-debug",
	4027:  "bxp",
	4028:  "dtserver-port",
	4029:  "ip-qsig",
	4030:  "jdmn-port",
	4031:  "suucp",
	4032:  "vrts-auth-port",
	4033:  "sanavigator",
	4034:  "ubxd",
	4035:  "wap-push-http",
	4036:  "wap-push-https",
	4037:  "ravehd",
	4038:  "fazzt-ptp",
	4039:  "fazzt-admin",
	4040:  "yo-main",
	4041:  "houston",
	4042:  "ldxp",
	4043:  "nirp",
	4044:  "ltp",
	4045:  "npp",
	4046:  "acp-proto",
	4047:  "ctp-state",
	4049:  "wafs",
	4050:  "cisco-wafs",
	4051:  "cppdp",
	4052:  "interact",
	4053:  "ccu-comm-1",
	4054:  "ccu-comm-2",
	4055:  "ccu-comm-3",
	4056:  "lms",
	4057:  "wfm",
	4058:  "kingfisher",
	4059:  "dlms-cosem",
	4060:  "dsmeter-iatc",
	4061:  "ice-location",
	4062:  "ice-slocation",
	4063:  "ice-router",
	4064:  "ice-srouter",
	4065:  "avanti-cdp",
	4066:  "pmas",
	4067:  "idp",
	4068:  "ipfltbcst",
	4069:  "minger",
	4070:  "tripe",
	4071:  "aibkup",
	4072:  "zieto-sock",
	4073:  "iRAPP",
	4074:  "cequint-cityid",
	4075:  "perimlan",
	4076:  "seraph",
	4077:  "ascomalarm",
	4079:  "santools",
	4080:  "lorica-in",
	4081:  "lorica-in-sec",
	4082:  "lorica-out",
	4083:  "lorica-out-sec",
	4084:  "fortisphere-vm",
	4086:  "ftsync",
	4089:  "opencore",
	4090:  "omasgport",
	4091:  "ewinstaller",
	4092:  "ewdgs",
	4093:  "pvxpluscs",
	4094:  "sysrqd",
	4095:  "xtgui",
	4096:  "bre",
	4097:  "patrolview",
	4098:  "drmsfsd",
	4099:  "dpcp",
	4100:  "igo-incognito",
	4101:  "brlp-0",
	4102:  "brlp-1",
	4103:  "brlp-2",
	4104:  "brlp-3",
	4105:  "shofar",
	4106:  "synchronite",
	4107:  "j-ac",
	4108:  "accel",
	4109:  "izm",
	4110:  "g2tag",
	4111:  "xgrid",
	4112:  "apple-vpns-rp",
	4113:  "aipn-reg",
	4114:  "jomamqmonitor",
	4115:  "cds",
	4116:  "smartcard-tls",
	4117:  "hillrserv",
	4118:  "netscript",
	4119:  "assuria-slm",
	4121:  "e-builder",
	4122:  "fprams",
	4123:  "z-wave",
	4124:  "tigv2",
	4125:  "opsview-envoy",
	4126:  "ddrepl",
	4127:  "unikeypro",
	4128:  "nufw",
	4129:  "nuauth",
	4130:  "fronet",
	4131:  "stars",
	4132:  "nuts-dem",
	4133:  "nuts-bootp",
	4134:  "nifty-hmi",
	4135:  "cl-db-attach",
	4136:  "cl-db-request",
	4137:  "cl-db-remote",
	4138:  "nettest",
	4139:  "thrtx",
	4140:  "cedros-fds",
	4141:  "oirtgsvc",
	4142:  "oidocsvc",
	4143:  "oidsr",
	4145:  "vvr-control",
	4146:  "tgcconnect",
	4147:  "vrxpservman",
	4148:  "hhb-handheld",
	4149:  "agslb",
	4150:  "PowerAlert-nsa",
	4151:  "menandmice-noh",
	4152:  "idig-mux",
	4153:  "mbl-battd",
	4154:  "atlinks",
	4155:  "bzr",
	4156:  "stat-results",
	4157:  "stat-scanner",
	4158:  "stat-cc",
	4159:  "nss",
	4160:  "jini-discovery",
	4161:  "omscontact",
	4162:  "omstopology",
	4163:  "silverpeakpeer",
	4164:  "silverpeakcomm",
	4165:  "altcp",
	4166:  "joost",
	4167:  "ddgn",
	4168:  "pslicser",
	4169:  "iadt-disc",
	4172:  "pcoip",
	4173:  "mma-discovery",
	4174:  "sm-disc",
	4177:  "wello",
	4178:  "storman",
	4179:  "MaxumSP",
	4180:  "httpx",
	4181:  "macbak",
	4182:  "pcptcpservice",
	4183:  "gmmp",
	4184:  "universe-suite",
	4185:  "wcpp",
	4188:  "vatata",
	4191:  "dsmipv6",
	4192:  "azeti-bd",
	4199:  "eims-admin",
	4300:  "corelccam",
	4301:  "d-data",
	4302:  "d-data-control",
	4303:  "srcp",
	4304:  "owserver",
	4305:  "batman",
	4306:  "pinghgl",
	4307:  "visicron-vs",
	4308:  "compx-lockview",
	4309:  "dserver",
	4310:  "mirrtex",
	4320:  "fdt-rcatp",
	4321:  "rwhois",
	4322:  "trim-event",
	4323:  "trim-ice",
	4324:  "balour",
	4325:  "geognosisman",
	4326:  "geognosis",
	4327:  "jaxer-web",
	4328:  "jaxer-manager",
	4333:  "ahsp",
	4340:  "gaia",
	4341:  "lisp-data",
	4342:  "lisp-control",
	4343:  "unicall",
	4344:  "vinainstall",
	4345:  "m4-network-as",
	4346:  "elanlm",
	4347:  "lansurveyor",
	4348:  "itose",
	4349:  "fsportmap",
	4350:  "net-device",
	4351:  "plcy-net-svcs",
	4352:  "pjlink",
	4353:  "f5-iquery",
	4354:  "qsnet-trans",
	4355:  "qsnet-workst",
	4356:  "qsnet-assist",
	4357:  "qsnet-cond",
	4358:  "qsnet-nucl",
	4359:  "omabcastltkm",
	4361:  "nacnl",
	4362:  "afore-vdp-disc",
	4368:  "wxbrief",
	4369:  "epmd",
	4370:  "elpro-tunnel",
	4371:  "l2c-disc",
	4372:  "l2c-data",
	4373:  "remctl",
	4375:  "tolteces",
	4376:  "bip",
	4377:  "cp-spxsvr",
	4378:  "cp-spxdpy",
	4379:  "ctdb",
	4389:  "xandros-cms",
	4390:  "wiegand",
	4394:  "apwi-disc",
	4395:  "omnivisionesx",
	4400:  "ds-srv",
	4401:  "ds-srvr",
	4402:  "ds-clnt",
	4403:  "ds-user",
	4404:  "ds-admin",
	4405:  "ds-mail",
	4406:  "ds-slp",
	4425:  "netrockey6",
	4426:  "beacon-port-2",
	4430:  "rsqlserver",
	4432:  "l-acoustics",
	4441:  "netblox",
	4442:  "saris",
	4443:  "pharos",
	4444:  "krb524",
	4445:  "upnotifyp",
	4446:  "n1-fwp",
	4447:  "n1-rmgmt",
	4448:  "asc-slmd",
	4449:  "privatewire",
	4450:  "camp",
	4451:  "ctisystemmsg",
	4452:  "ctiprogramload",
	4453:  "nssalertmgr",
	4454:  "nssagentmgr",
	4455:  "prchat-user",
	4456:  "prchat-server",
	4457:  "prRegister",
	4458:  "mcp",
	4484:  "hpssmgmt",
	4486:  "icms",
	4488:  "awacs-ice",
	4500:  "ipsec-nat-t",
	4534:  "armagetronad",
	4535:  "ehs",
	4536:  "ehs-ssl",
	4537:  "wssauthsvc",
	4538:  "swx-gate",
	4545:  "worldscores",
	4546:  "sf-lm",
	4547:  "lanner-lm",
	4548:  "synchromesh",
	4549:  "aegate",
	4550:  "gds-adppiw-db",
	4551:  "ieee-mih",
	4552:  "menandmice-mon",
	4554:  "msfrs",
	4555:  "rsip",
	4556:  "dtn-bundle",
	4557:  "mtcevrunqss",
	4558:  "mtcevrunqman",
	4559:  "hylafax",
	4566:  "kwtc",
	4567:  "tram",
	4568:  "bmc-reporting",
	4569:  "iax",
	4591:  "l3t-at-an",
	4592:  "hrpd-ith-at-an",
	4593:  "ipt-anri-anri",
	4594:  "ias-session",
	4595:  "ias-paging",
	4596:  "ias-neighbor",
	4597:  "a21-an-1xbs",
	4598:  "a16-an-an",
	4599:  "a17-an-an",
	4600:  "piranha1",
	4601:  "piranha2",
	4658:  "playsta2-app",
	4659:  "playsta2-lob",
	4660:  "smaclmgr",
	4661:  "kar2ouche",
	4662:  "oms",
	4663:  "noteit",
	4664:  "ems",
	4665:  "contclientms",
	4666:  "eportcomm",
	4667:  "mmacomm",
	4668:  "mmaeds",
	4669:  "eportcommdata",
	4670:  "light",
	4671:  "acter",
	4672:  "rfa",
	4673:  "cxws",
	4674:  "appiq-mgmt",
	4675:  "dhct-status",
	4676:  "dhct-alerts",
	4677:  "bcs",
	4678:  "traversal",
	4679:  "mgesupervision",
	4680:  "mgemanagement",
	4681:  "parliant",
	4682:  "finisar",
	4683:  "spike",
	4684:  "rfid-rp1",
	4685:  "autopac",
	4686:  "msp-os",
	4687:  "nst",
	4688:  "mobile-p2p",
	4689:  "altovacentral",
	4690:  "prelude",
	4691:  "mtn",
	4692:  "conspiracy",
	4700:  "netxms-agent",
	4701:  "netxms-mgmt",
	4702:  "netxms-sync",
	4725:  "truckstar",
	4726:  "a26-fap-fgw",
	4727:  "fcis-disc",
	4728:  "capmux",
	4729:  "gsmtap",
	4730:  "gearman",
	4732:  "ohmtrigger",
	4737:  "ipdr-sp",
	4738:  "solera-lpn",
	4739:  "ipfix",
	4740:  "ipfixs",
	4741:  "lumimgrd",
	4742:  "sicct-sdp",
	4743:  "openhpid",
	4744:  "ifsp",
	4745:  "fmp",
	4747:  "buschtrommel",
	4749:  "profilemac",
	4750:  "ssad",
	4751:  "spocp",
	4752:  "snap",
	4753:  "simon-disc",
	4784:  "bfd-multi-ctl",
	4785:  "cncp",
	4789:  "vxlan",
	4790:  "vxlan-gpe",
	4800:  "iims",
	4801:  "iwec",
	4802:  "ilss",
	4803:  "notateit-disc",
	4804:  "aja-ntv4-disc",
	4827:  "htcp",
	4837:  "varadero-0",
	4838:  "varadero-1",
	4839:  "varadero-2",
	4840:  "opcua-udp",
	4841:  "quosa",
	4842:  "gw-asv",
	4843:  "opcua-tls",
	4844:  "gw-log",
	4845:  "wcr-remlib",
	4846:  "contamac-icm",
	4847:  "wfc",
	4848:  "appserv-http",
	4849:  "appserv-https",
	4850:  "sun-as-nodeagt",
	4851:  "derby-repli",
	4867:  "unify-debug",
	4868:  "phrelay",
	4869:  "phrelaydbg",
	4870:  "cc-tracking",
	4871:  "wired",
	4876:  "tritium-can",
	4877:  "lmcs",
	4878:  "inst-discovery",
	4881:  "socp-t",
	4882:  "socp-c",
	4884:  "hivestor",
	4885:  "abbs",
	4894:  "lyskom",
	4899:  "radmin-port",
	4900:  "hfcs",
	4914:  "bones",
	4936:  "an-signaling",
	4937:  "atsc-mh-ssc",
	4940:  "eq-office-4940",
	4941:  "eq-office-4941",
	4942:  "eq-office-4942",
	4949:  "munin",
	4950:  "sybasesrvmon",
	4951:  "pwgwims",
	4952:  "sagxtsds",
	4969:  "ccss-qmm",
	4970:  "ccss-qsm",
	4986:  "mrip",
	4987:  "smar-se-port1",
	4988:  "smar-se-port2",
	4989:  "parallel",
	4990:  "busycal",
	4991:  "vrt",
	4999:  "hfcs-manager",
	5000:  "commplex-main",
	5001:  "commplex-link",
	5002:  "rfe",
	5003:  "fmpro-internal",
	5004:  "avt-profile-1",
	5005:  "avt-profile-2",
	5006:  "wsm-server",
	5007:  "wsm-server-ssl",
	5008:  "synapsis-edge",
	5009:  "winfs",
	5010:  "telelpathstart",
	5011:  "telelpathattack",
	5012:  "nsp",
	5013:  "fmpro-v6",
	5014:  "onpsocket",
	5020:  "zenginkyo-1",
	5021:  "zenginkyo-2",
	5022:  "mice",
	5023:  "htuilsrv",
	5024:  "scpi-telnet",
	5025:  "scpi-raw",
	5026:  "strexec-d",
	5027:  "strexec-s",
	5029:  "infobright",
	5030:  "surfpass",
	5031:  "dmp",
	5042:  "asnaacceler8db",
	5043:  "swxadmin",
	5044:  "lxi-evntsvc",
	5046:  "vpm-udp",
	5047:  "iscape",
	5049:  "ivocalize",
	5050:  "mmcc",
	5051:  "ita-agent",
	5052:  "ita-manager",
	5053:  "rlm-disc",
	5055:  "unot",
	5056:  "intecom-ps1",
	5057:  "intecom-ps2",
	5058:  "locus-disc",
	5059:  "sds",
	5060:  "sip",
	5061:  "sips",
	5062:  "na-localise",
	5064:  "ca-1",
	5065:  "ca-2",
	5066:  "stanag-5066",
	5067:  "authentx",
	5069:  "i-net-2000-npr",
	5070:  "vtsas",
	5071:  "powerschool",
	5072:  "ayiya",
	5073:  "tag-pm",
	5074:  "alesquery",
	5078:  "pixelpusher",
	5079:  "cp-spxrpts",
	5080:  "onscreen",
	5081:  "sdl-ets",
	5082:  "qcp",
	5083:  "qfp",
	5084:  "llrp",
	5085:  "encrypted-llrp",
	5092:  "magpie",
	5093:  "sentinel-lm",
	5094:  "hart-ip",
	5099:  "sentlm-srv2srv",
	5100:  "socalia",
	5101:  "talarian-udp",
	5102:  "oms-nonsecure",
	5104:  "tinymessage",
	5105:  "hughes-ap",
	5111:  "taep-as-svc",
	5112:  "pm-cmdsvr",
	5116:  "emb-proj-cmd",
	5120:  "barracuda-bbs",
	5133:  "nbt-pc",
	5136:  "minotaur-sa",
	5137:  "ctsd",
	5145:  "rmonitor-secure",
	5150:  "atmp",
	5151:  "esri-sde",
	5152:  "sde-discovery",
	5154:  "bzflag",
	5155:  "asctrl-agent",
	5164:  "vpa-disc",
	5165:  "ife-icorp",
	5166:  "winpcs",
	5167:  "scte104",
	5168:  "scte30",
	5190:  "aol",
	5191:  "aol-1",
	5192:  "aol-2",
	5193:  "aol-3",
	5200:  "targus-getdata",
	5201:  "targus-getdata1",
	5202:  "targus-getdata2",
	5203:  "targus-getdata3",
	5223:  "hpvirtgrp",
	5224:  "hpvirtctrl",
	5225:  "hp-server",
	5226:  "hp-status",
	5227:  "perfd",
	5234:  "eenet",
	5235:  "galaxy-network",
	5236:  "padl2sim",
	5237:  "mnet-discovery",
	5245:  "downtools-disc",
	5246:  "capwap-control",
	5247:  "capwap-data",
	5248:  "caacws",
	5249:  "caaclang2",
	5250:  "soagateway",
	5251:  "caevms",
	5252:  "movaz-ssc",
	5264:  "3com-njack-1",
	5265:  "3com-njack-2",
	5270:  "cartographerxmp",
	5271:  "cuelink-disc",
	5272:  "pk",
	5282:  "transmit-port",
	5298:  "presence",
	5299:  "nlg-data",
	5300:  "hacl-hb",
	5301:  "hacl-gs",
	5302:  "hacl-cfg",
	5303:  "hacl-probe",
	5304:  "hacl-local",
	5305:  "hacl-test",
	5306:  "sun-mc-grp",
	5307:  "sco-aip",
	5308:  "cfengine",
	5309:  "jprinter",
	5310:  "outlaws",
	5312:  "permabit-cs",
	5313:  "rrdp",
	5314:  "opalis-rbt-ipc",
	5315:  "hacl-poll",
	5343:  "kfserver",
	5344:  "xkotodrcp",
	5349:  "stuns",
	5350:  "pcp-multicast",
	5351:  "pcp",
	5352:  "dns-llq",
	5353:  "mdns",
	5354:  "mdnsresponder",
	5355:  "llmnr",
	5356:  "ms-smlbiz",
	5357:  "wsdapi",
	5358:  "wsdapi-s",
	5359:  "ms-alerter",
	5360:  "ms-sideshow",
	5361:  "ms-s-sideshow",
	5362:  "serverwsd2",
	5363:  "net-projection",
	5364:  "kdnet",
	5397:  "stresstester",
	5398:  "elektron-admin",
	5399:  "securitychase",
	5400:  "excerpt",
	5401:  "excerpts",
	5402:  "mftp",
	5403:  "hpoms-ci-lstn",
	5404:  "hpoms-dps-lstn",
	5405:  "netsupport",
	5406:  "systemics-sox",
	5407:  "foresyte-clear",
	5408:  "foresyte-sec",
	5409:  "salient-dtasrv",
	5410:  "salient-usrmgr",
	5411:  "actnet",
	5412:  "continuus",
	5413:  "wwiotalk",
	5414:  "statusd",
	5415:  "ns-server",
	5416:  "sns-gateway",
	5417:  "sns-agent",
	5418:  "mcntp",
	5419:  "dj-ice",
	5420:  "cylink-c",
	5421:  "netsupport2",
	5422:  "salient-mux",
	5423:  "virtualuser",
	5424:  "beyond-remote",
	5425:  "br-channel",
	5426:  "devbasic",
	5427:  "sco-peer-tta",
	5428:  "telaconsole",
	5429:  "base",
	5430:  "radec-corp",
	5431:  "park-agent",
	5432:  "postgresql",
	5433:  "pyrrho",
	5434:  "sgi-arrayd",
	5435:  "sceanics",
	5436:  "pmip6-cntl",
	5437:  "pmip6-data",
	5443:  "spss",
	5453:  "surebox",
	5454:  "apc-5454",
	5455:  "apc-5455",
	5456:  "apc-5456",
	5461:  "silkmeter",
	5462:  "ttl-publisher",
	5463:  "ttlpriceproxy",
	5464:  "quailnet",
	5465:  "netops-broker",
	5500:  "fcp-addr-srvr1",
	5501:  "fcp-addr-srvr2",
	5502:  "fcp-srvr-inst1",
	5503:  "fcp-srvr-inst2",
	5504:  "fcp-cics-gw1",
	5505:  "checkoutdb",
	5506:  "amc",
	5553:  "sgi-eventmond",
	5554:  "sgi-esphttp",
	5555:  "personal-agent",
	5556:  "freeciv",
	5567:  "enc-eps-mc-sec",
	5568:  "sdt",
	5569:  "rdmnet-device",
	5573:  "sdmmp",
	5580:  "tmosms0",
	5581:  "tmosms1",
	5582:  "fac-restore",
	5583:  "tmo-icon-sync",
	5584:  "bis-web",
	5585:  "bis-sync",
	5597:  "ininmessaging",
	5598:  "mctfeed",
	5599:  "esinstall",
	5600:  "esmmanager",
	5601:  "esmagent",
	5602:  "a1-msc",
	5603:  "a1-bs",
	5604:  "a3-sdunode",
	5605:  "a4-sdunode",
	5627:  "ninaf",
	5628:  "htrust",
	5629:  "symantec-sfdb",
	5630:  "precise-comm",
	5631:  "pcanywheredata",
	5632:  "pcanywherestat",
	5633:  "beorl",
	5634:  "xprtld",
	5670:  "zre-disc",
	5671:  "amqps",
	5672:  "amqp",
	5673:  "jms",
	5674:  "hyperscsi-port",
	5675:  "v5ua",
	5676:  "raadmin",
	5677:  "questdb2-lnchr",
	5678:  "rrac",
	5679:  "dccm",
	5680:  "auriga-router",
	5681:  "ncxcp",
	5682:  "brightcore",
	5683:  "coap",
	5684:  "coaps",
	5687:  "gog-multiplayer",
	5688:  "ggz",
	5689:  "qmvideo",
	5713:  "proshareaudio",
	5714:  "prosharevideo",
	5715:  "prosharedata",
	5716:  "prosharerequest",
	5717:  "prosharenotify",
	5718:  "dpm",
	5719:  "dpm-agent",
	5720:  "ms-licensing",
	5721:  "dtpt",
	5722:  "msdfsr",
	5723:  "omhs",
	5724:  "omsdk",
	5728:  "io-dist-group",
	5729:  "openmail",
	5730:  "unieng",
	5741:  "ida-discover1",
	5742:  "ida-discover2",
	5743:  "watchdoc-pod",
	5744:  "watchdoc",
	5745:  "fcopy-server",
	5746:  "fcopys-server",
	5747:  "tunatic",
	5748:  "tunalyzer",
	5750:  "rscd",
	5755:  "openmailg",
	5757:  "x500ms",
	5766:  "openmailns",
	5767:  "s-openmail",
	5768:  "openmailpxy",
	5769:  "spramsca",
	5770:  "spramsd",
	5771:  "netagent",
	5777:  "dali-port",
	5781:  "3par-evts",
	5782:  "3par-mgmt",
	5783:  "3par-mgmt-ssl",
	5784:  "ibar",
	5785:  "3par-rcopy",
	5786:  "cisco-redu",
	5787:  "waascluster",
	5793:  "xtreamx",
	5794:  "spdp",
	5813:  "icmpd",
	5814:  "spt-automation",
	5859:  "wherehoo",
	5863:  "ppsuitemsg",
	5900:  "rfb",
	5910:  "cm",
	5911:  "cpdlc",
	5912:  "fis",
	5913:  "ads-c",
	5963:  "indy",
	5968:  "mppolicy-v5",
	5969:  "mppolicy-mgr",
	5984:  "couchdb",
	5985:  "wsman",
	5986:  "wsmans",
	5987:  "wbem-rmi",
	5988:  "wbem-http",
	5989:  "wbem-https",
	5990:  "wbem-exp-https",
	5991:  "nuxsl",
	5992:  "consul-insight",
	5999:  "cvsup",
	6064:  "ndl-ahp-svc",
	6065:  "winpharaoh",
	6066:  "ewctsp",
	6069:  "trip",
	6070:  "messageasap",
	6071:  "ssdtp",
	6072:  "diagnose-proc",
	6073:  "directplay8",
	6074:  "max",
	6081:  "geneve",
	6082:  "p25cai",
	6083:  "miami-bcast",
	6085:  "konspire2b",
	6086:  "pdtp",
	6087:  "ldss",
	6088:  "doglms-notify",
	6100:  "synchronet-db",
	6101:  "synchronet-rtc",
	6102:  "synchronet-upd",
	6103:  "rets",
	6104:  "dbdb",
	6105:  "primaserver",
	6106:  "mpsserver",
	6107:  "etc-control",
	6108:  "sercomm-scadmin",
	6109:  "globecast-id",
	6110:  "softcm",
	6111:  "spc",
	6112:  "dtspcd",
	6118:  "tipc",
	6122:  "bex-webadmin",
	6123:  "backup-express",
	6124:  "pnbs",
	6133:  "nbt-wol",
	6140:  "pulsonixnls",
	6141:  "meta-corp",
	6142:  "aspentec-lm",
	6143:  "watershed-lm",
	6144:  "statsci1-lm",
	6145:  "statsci2-lm",
	6146:  "lonewolf-lm",
	6147:  "montage-lm",
	6148:  "ricardo-lm",
	6149:  "tal-pod",
	6160:  "ecmp-data",
	6161:  "patrol-ism",
	6162:  "patrol-coll",
	6163:  "pscribe",
	6200:  "lm-x",
	6201:  "thermo-calc",
	6222:  "radmind",
	6241:  "jeol-nsddp-1",
	6242:  "jeol-nsddp-2",
	6243:  "jeol-nsddp-3",
	6244:  "jeol-nsddp-4",
	6251:  "tl1-raw-ssl",
	6252:  "tl1-ssh",
	6253:  "crip",
	6268:  "grid",
	6269:  "grid-alt",
	6300:  "bmc-grx",
	6301:  "bmc-ctd-ldap",
	6306:  "ufmp",
	6315:  "scup-disc",
	6316:  "abb-escp",
	6317:  "nav-data",
	6320:  "repsvc",
	6321:  "emp-server1",
	6322:  "emp-server2",
	6324:  "hrd-ns-disc",
	6343:  "sflow",
	6346:  "gnutella-svc",
	6347:  "gnutella-rtr",
	6350:  "adap",
	6355:  "pmcs",
	6360:  "metaedit-mu",
	6363:  "ndn",
	6370:  "metaedit-se",
	6382:  "metatude-mds",
	6389:  "clariion-evr01",
	6390:  "metaedit-ws",
	6417:  "faxcomservice",
	6420:  "nim-vdrshell",
	6421:  "nim-wan",
	6443:  "sun-sr-https",
	6444:  "sge-qmaster",
	6445:  "sge-execd",
	6446:  "mysql-proxy",
	6455:  "skip-cert-recv",
	6456:  "skip-cert-send",
	6471:  "lvision-lm",
	6480:  "sun-sr-http",
	6481:  "servicetags",
	6482:  "ldoms-mgmt",
	6483:  "SunVTS-RMI",
	6484:  "sun-sr-jms",
	6485:  "sun-sr-iiop",
	6486:  "sun-sr-iiops",
	6487:  "sun-sr-iiop-aut",
	6488:  "sun-sr-jmx",
	6489:  "sun-sr-admin",
	6500:  "boks",
	6501:  "boks-servc",
	6502:  "boks-servm",
	6503:  "boks-clntd",
	6505:  "badm-priv",
	6506:  "badm-pub",
	6507:  "bdir-priv",
	6508:  "bdir-pub",
	6509:  "mgcs-mfp-port",
	6510:  "mcer-port",
	6511:  "dccp-udp",
	6514:  "syslog-tls",
	6515:  "elipse-rec",
	6543:  "lds-distrib",
	6544:  "lds-dump",
	6547:  "apc-6547",
	6548:  "apc-6548",
	6549:  "apc-6549",
	6550:  "fg-sysupdate",
	6551:  "sum",
	6558:  "xdsxdm",
	6566:  "sane-port",
	6568:  "rp-reputation",
	6579:  "affiliate",
	6580:  "parsec-master",
	6581:  "parsec-peer",
	6582:  "parsec-game",
	6583:  "joaJewelSuite",
	6619:  "odette-ftps",
	6620:  "kftp-data",
	6621:  "kftp",
	6622:  "mcftp",
	6623:  "ktelnet",
	6626:  "wago-service",
	6627:  "nexgen",
	6628:  "afesc-mc",
	6633:  "cisco-vpath-tun",
	6634:  "mpls-pm",
	6653:  "openflow",
	6657:  "palcom-disc",
	6670:  "vocaltec-gold",
	6671:  "p4p-portal",
	6672:  "vision-server",
	6673:  "vision-elmd",
	6678:  "vfbp-disc",
	6679:  "osaut",
	6689:  "tsa",
	6696:  "babel",
	6701:  "kti-icad-srvr",
	6702:  "e-design-net",
	6703:  "e-design-web",
	6714:  "ibprotocol",
	6715:  "fibotrader-com",
	6767:  "bmc-perf-agent",
	6768:  "bmc-perf-mgrd",
	6769:  "adi-gxp-srvprt",
	6770:  "plysrv-http",
	6771:  "plysrv-https",
	6784:  "bfd-lag",
	6785:  "dgpf-exchg",
	6786:  "smc-jmx",
	6787:  "smc-admin",
	6788:  "smc-http",
	6789:  "smc-https",
	6790:  "hnmp",
	6791:  "hnm",
	6801:  "acnet",
	6831:  "ambit-lm",
	6841:  "netmo-default",
	6842:  "netmo-http",
	6850:  "iccrushmore",
	6868:  "acctopus-st",
	6888:  "muse",
	6935:  "ethoscan",
	6936:  "xsmsvc",
	6946:  "bioserver",
	6951:  "otlp",
	6961:  "jmact3",
	6962:  "jmevt2",
	6963:  "swismgr1",
	6964:  "swismgr2",
	6965:  "swistrap",
	6966:  "swispol",
	6969:  "acmsoda",
	6997:  "MobilitySrv",
	6998:  "iatp-highpri",
	6999:  "iatp-normalpri",
	7000:  "afs3-fileserver",
	7001:  "afs3-callback",
	7002:  "afs3-prserver",
	7003:  "afs3-vlserver",
	7004:  "afs3-kaserver",
	7005:  "afs3-volser",
	7006:  "afs3-errors",
	7007:  "afs3-bos",
	7008:  "afs3-update",
	7009:  "afs3-rmtsys",
	7010:  "ups-onlinet",
	7011:  "talon-disc",
	7012:  "talon-engine",
	7013:  "microtalon-dis",
	7014:  "microtalon-com",
	7015:  "talon-webserver",
	7019:  "doceri-view",
	7020:  "dpserve",
	7021:  "dpserveadmin",
	7022:  "ctdp",
	7023:  "ct2nmcs",
	7024:  "vmsvc",
	7025:  "vmsvc-2",
	7030:  "op-probe",
	7040:  "quest-disc",
	7070:  "arcp",
	7071:  "iwg1",
	7080:  "empowerid",
	7095:  "jdp-disc",
	7099:  "lazy-ptop",
	7100:  "font-service",
	7101:  "elcn",
	7107:  "aes-x170",
	7121:  "virprot-lm",
	7128:  "scenidm",
	7129:  "scenccs",
	7161:  "cabsm-comm",
	7162:  "caistoragemgr",
	7163:  "cacsambroker",
	7164:  "fsr",
	7165:  "doc-server",
	7166:  "aruba-server",
	7169:  "ccag-pib",
	7170:  "nsrp",
	7171:  "drm-production",
	7174:  "clutild",
	7181:  "janus-disc",
	7200:  "fodms",
	7201:  "dlip",
	7227:  "ramp",
	7235:  "aspcoordination",
	7262:  "cnap",
	7272:  "watchme-7272",
	7273:  "oma-rlp",
	7274:  "oma-rlp-s",
	7275:  "oma-ulp",
	7276:  "oma-ilp",
	7277:  "oma-ilp-s",
	7278:  "oma-dcdocbs",
	7279:  "ctxlic",
	7280:  "itactionserver1",
	7281:  "itactionserver2",
	7282:  "mzca-alert",
	7365:  "lcm-server",
	7391:  "mindfilesys",
	7392:  "mrssrendezvous",
	7393:  "nfoldman",
	7394:  "fse",
	7395:  "winqedit",
	7397:  "hexarc",
	7400:  "rtps-discovery",
	7401:  "rtps-dd-ut",
	7402:  "rtps-dd-mt",
	7410:  "ionixnetmon",
	7411:  "daqstream",
	7421:  "mtportmon",
	7426:  "pmdmgr",
	7427:  "oveadmgr",
	7428:  "ovladmgr",
	7429:  "opi-sock",
	7430:  "xmpv7",
	7431:  "pmd",
	7437:  "faximum",
	7443:  "oracleas-https",
	7473:  "rise",
	7491:  "telops-lmd",
	7500:  "silhouette",
	7501:  "ovbus",
	7510:  "ovhpas",
	7511:  "pafec-lm",
	7542:  "saratoga",
	7543:  "atul",
	7544:  "nta-ds",
	7545:  "nta-us",
	7546:  "cfs",
	7547:  "cwmp",
	7548:  "tidp",
	7549:  "nls-tl",
	7550:  "cloudsignaling",
	7560:  "sncp",
	7566:  "vsi-omega",
	7570:  "aries-kfinder",
	7574:  "coherence-disc",
	7588:  "sun-lm",
	7624:  "indi",
	7627:  "soap-http",
	7628:  "zen-pawn",
	7629:  "xdas",
	7633:  "pmdfmgt",
	7648:  "cuseeme",
	7674:  "imqtunnels",
	7675:  "imqtunnel",
	7676:  "imqbrokerd",
	7677:  "sun-user-https",
	7680:  "pando-pub",
	7689:  "collaber",
	7697:  "klio",
	7707:  "sync-em7",
	7708:  "scinet",
	7720:  "medimageportal",
	7724:  "nsdeepfreezectl",
	7725:  "nitrogen",
	7726:  "freezexservice",
	7727:  "trident-data",
	7734:  "smip",
	7738:  "aiagent",
	7741:  "scriptview",
	7743:  "sstp-1",
	7744:  "raqmon-pdu",
	7747:  "prgp",
	7777:  "cbt",
	7778:  "interwise",
	7779:  "vstat",
	7781:  "accu-lmgr",
	7786:  "minivend",
	7787:  "popup-reminders",
	7789:  "office-tools",
	7794:  "q3ade",
	7797:  "pnet-conn",
	7798:  "pnet-enc",
	7799:  "altbsdp",
	7800:  "asr",
	7801:  "ssp-client",
	7802:  "vns-tp",
	7810:  "rbt-wanopt",
	7845:  "apc-7845",
	7846:  "apc-7846",
	7872:  "mipv6tls",
	7880:  "pss",
	7887:  "ubroker",
	7900:  "mevent",
	7901:  "tnos-sp",
	7902:  "tnos-dp",
	7903:  "tnos-dps",
	7913:  "qo-secure",
	7932:  "t2-drm",
	7933:  "t2-brm",
	7962:  "generalsync",
	7967:  "supercell",
	7979:  "micromuse-ncps",
	7980:  "quest-vista",
	7982:  "sossd-disc",
	7998:  "usicontentpush",
	7999:  "irdmi2",
	8000:  "irdmi",
	8001:  "vcom-tunnel",
	8002:  "teradataordbms",
	8003:  "mcreport",
	8005:  "mxi",
	8008:  "http-alt",
	8019:  "qbdb",
	8020:  "intu-ec-svcdisc",
	8021:  "intu-ec-client",
	8022:  "oa-system",
	8025:  "ca-audit-da",
	8026:  "ca-audit-ds",
	8032:  "pro-ed",
	8033:  "mindprint",
	8034:  "vantronix-mgmt",
	8040:  "ampify",
	8052:  "senomix01",
	8053:  "senomix02",
	8054:  "senomix03",
	8055:  "senomix04",
	8056:  "senomix05",
	8057:  "senomix06",
	8058:  "senomix07",
	8059:  "senomix08",
	8060:  "aero",
	8074:  "gadugadu",
	8080:  "http-alt",
	8081:  "sunproxyadmin",
	8082:  "us-cli",
	8083:  "us-srv",
	8086:  "d-s-n",
	8087:  "simplifymedia",
	8088:  "radan-http",
	8097:  "sac",
	8100:  "xprint-server",
	8115:  "mtl8000-matrix",
	8116:  "cp-cluster",
	8118:  "privoxy",
	8121:  "apollo-data",
	8122:  "apollo-admin",
	8128:  "paycash-online",
	8129:  "paycash-wbp",
	8130:  "indigo-vrmi",
	8131:  "indigo-vbcp",
	8132:  "dbabble",
	8148:  "isdd",
	8149:  "eor-game",
	8160:  "patrol",
	8161:  "patrol-snmp",
	8182:  "vmware-fdm",
	8184:  "itach",
	8192:  "spytechphone",
	8194:  "blp1",
	8195:  "blp2",
	8199:  "vvr-data",
	8200:  "trivnet1",
	8201:  "trivnet2",
	8202:  "aesop",
	8204:  "lm-perfworks",
	8205:  "lm-instmgr",
	8206:  "lm-dta",
	8207:  "lm-sserver",
	8208:  "lm-webwatcher",
	8230:  "rexecj",
	8243:  "synapse-nhttps",
	8276:  "pando-sec",
	8280:  "synapse-nhttp",
	8292:  "blp3",
	8294:  "blp4",
	8300:  "tmi",
	8301:  "amberon",
	8320:  "tnp-discover",
	8321:  "tnp",
	8351:  "server-find",
	8376:  "cruise-enum",
	8377:  "cruise-swroute",
	8378:  "cruise-config",
	8379:  "cruise-diags",
	8380:  "cruise-update",
	8383:  "m2mservices",
	8400:  "cvd",
	8401:  "sabarsd",
	8402:  "abarsd",
	8403:  "admind",
	8416:  "espeech",
	8417:  "espeech-rtp",
	8442:  "cybro-a-bus",
	8443:  "pcsync-https",
	8444:  "pcsync-http",
	8445:  "copy-disc",
	8450:  "npmp",
	8472:  "otv",
	8473:  "vp2p",
	8474:  "noteshare",
	8500:  "fmtp",
	8501:  "cmtp-av",
	8554:  "rtsp-alt",
	8555:  "d-fence",
	8567:  "enc-tunnel",
	8600:  "asterix",
	8609:  "canon-cpp-disc",
	8610:  "canon-mfnp",
	8611:  "canon-bjnp1",
	8612:  "canon-bjnp2",
	8613:  "canon-bjnp3",
	8614:  "canon-bjnp4",
	8675:  "msi-cps-rm-disc",
	8686:  "sun-as-jmxrmi",
	8732:  "dtp-net",
	8733:  "ibus",
	8763:  "mc-appserver",
	8764:  "openqueue",
	8765:  "ultraseek-http",
	8766:  "amcs",
	8770:  "dpap",
	8786:  "msgclnt",
	8787:  "msgsrvr",
	8793:  "acd-pm",
	8800:  "sunwebadmin",
	8804:  "truecm",
	8873:  "dxspider",
	8880:  "cddbp-alt",
	8883:  "secure-mqtt",
	8888:  "ddi-udp-1",
	8889:  "ddi-udp-2",
	8890:  "ddi-udp-3",
	8891:  "ddi-udp-4",
	8892:  "ddi-udp-5",
	8893:  "ddi-udp-6",
	8894:  "ddi-udp-7",
	8899:  "ospf-lite",
	8900:  "jmb-cds1",
	8901:  "jmb-cds2",
	8910:  "manyone-http",
	8911:  "manyone-xml",
	8912:  "wcbackup",
	8913:  "dragonfly",
	8954:  "cumulus-admin",
	8989:  "sunwebadmins",
	8990:  "http-wmap",
	8991:  "https-wmap",
	8999:  "bctp",
	9000:  "cslistener",
	9001:  "etlservicemgr",
	9002:  "dynamid",
	9007:  "ogs-client",
	9009:  "pichat",
	9020:  "tambora",
	9021:  "panagolin-ident",
	9022:  "paragent",
	9023:  "swa-1",
	9024:  "swa-2",
	9025:  "swa-3",
	9026:  "swa-4",
	9080:  "glrpc",
	9084:  "aurora",
	9085:  "ibm-rsyscon",
	9086:  "net2display",
	9087:  "classic",
	9088:  "sqlexec",
	9089:  "sqlexec-ssl",
	9090:  "websm",
	9091:  "xmltec-xmlmail",
	9092:  "XmlIpcRegSvc",
	9100:  "hp-pdl-datastr",
	9101:  "bacula-dir",
	9102:  "bacula-fd",
	9103:  "bacula-sd",
	9104:  "peerwire",
	9105:  "xadmin",
	9106:  "astergate-disc",
	9119:  "mxit",
	9131:  "dddp",
	9160:  "apani1",
	9161:  "apani2",
	9162:  "apani3",
	9163:  "apani4",
	9164:  "apani5",
	9191:  "sun-as-jpda",
	9200:  "wap-wsp",
	9201:  "wap-wsp-wtp",
	9202:  "wap-wsp-s",
	9203:  "wap-wsp-wtp-s",
	9204:  "wap-vcard",
	9205:  "wap-vcal",
	9206:  "wap-vcard-s",
	9207:  "wap-vcal-s",
	9208:  "rjcdb-vcards",
	9209:  "almobile-system",
	9210:  "oma-mlp",
	9211:  "oma-mlp-s",
	9212:  "serverviewdbms",
	9213:  "serverstart",
	9214:  "ipdcesgbs",
	9215:  "insis",
	9216:  "acme",
	9217:  "fsc-port",
	9222:  "teamcoherence",
	9255:  "mon",
	9277:  "traingpsdata",
	9278:  "pegasus",
	9279:  "pegasus-ctl",
	9280:  "pgps",
	9281:  "swtp-port1",
	9282:  "swtp-port2",
	9283:  "callwaveiam",
	9284:  "visd",
	9285:  "n2h2server",
	9286:  "n2receive",
	9287:  "cumulus",
	9292:  "armtechdaemon",
	9293:  "storview",
	9294:  "armcenterhttp",
	9295:  "armcenterhttps",
	9300:  "vrace",
	9318:  "secure-ts",
	9321:  "guibase",
	9343:  "mpidcmgr",
	9344:  "mphlpdmc",
	9346:  "ctechlicensing",
	9374:  "fjdmimgr",
	9380:  "boxp",
	9396:  "fjinvmgr",
	9397:  "mpidcagt",
	9400:  "sec-t4net-srv",
	9401:  "sec-t4net-clt",
	9402:  "sec-pc2fax-srv",
	9418:  "git",
	9443:  "tungsten-https",
	9444:  "wso2esb-console",
	9450:  "sntlkeyssrvr",
	9500:  "ismserver",
	9522:  "sma-spw",
	9535:  "mngsuite",
	9536:  "laes-bf",
	9555:  "trispen-sra",
	9592:  "ldgateway",
	9593:  "cba8",
	9594:  "msgsys",
	9595:  "pds",
	9596:  "mercury-disc",
	9597:  "pd-admin",
	9598:  "vscp",
	9599:  "robix",
	9600:  "micromuse-ncpw",
	9612:  "streamcomm-ds",
	9618:  "condor",
	9628:  "odbcpathway",
	9629:  "uniport",
	9632:  "mc-comm",
	9667:  "xmms2",
	9668:  "tec5-sdctp",
	9694:  "client-wakeup",
	9695:  "ccnx",
	9700:  "board-roar",
	9747:  "l5nas-parchan",
	9750:  "board-voip",
	9753:  "rasadv",
	9762:  "tungsten-http",
	9800:  "davsrc",
	9801:  "sstp-2",
	9802:  "davsrcs",
	9875:  "sapv1",
	9878:  "kca-service",
	9888:  "cyborg-systems",
	9889:  "gt-proxy",
	9898:  "monkeycom",
	9899:  "sctp-tunneling",
	9900:  "iua",
	9901:  "enrp",
	9903:  "multicast-ping",
	9909:  "domaintime",
	9911:  "sype-transport",
	9950:  "apc-9950",
	9951:  "apc-9951",
	9952:  "apc-9952",
	9953:  "acis",
	9955:  "alljoyn-mcm",
	9956:  "alljoyn",
	9966:  "odnsp",
	9987:  "dsm-scm-target",
	9990:  "osm-appsrvr",
	9991:  "osm-oev",
	9992:  "palace-1",
	9993:  "palace-2",
	9994:  "palace-3",
	9995:  "palace-4",
	9996:  "palace-5",
	9997:  "palace-6",
	9998:  "distinct32",
	9999:  "distinct",
	10000: "ndmp",
	10001: "scp-config",
	10002: "documentum",
	10003: "documentum-s",
	10007: "mvs-capacity",
	10008: "octopus",
	10009: "swdtp-sv",
	10050: "zabbix-agent",
	10051: "zabbix-trapper",
	10080: "amanda",
	10081: "famdc",
	10100: "itap-ddtp",
	10101: "ezmeeting-2",
	10102: "ezproxy-2",
	10103: "ezrelay",
	10104: "swdtp",
	10107: "bctp-server",
	10110: "nmea-0183",
	10111: "nmea-onenet",
	10113: "netiq-endpoint",
	10114: "netiq-qcheck",
	10115: "netiq-endpt",
	10116: "netiq-voipa",
	10117: "iqrm",
	10128: "bmc-perf-sd",
	10160: "qb-db-server",
	10161: "snmpdtls",
	10162: "snmpdtls-trap",
	10200: "trisoap",
	10201: "rscs",
	10252: "apollo-relay",
	10260: "axis-wimp-port",
	10288: "blocks",
	10439: "bngsync",
	10500: "hip-nat-t",
	10540: "MOS-lower",
	10541: "MOS-upper",
	10542: "MOS-aux",
	10543: "MOS-soap",
	10544: "MOS-soap-opt",
	10800: "gap",
	10805: "lpdg",
	10810: "nmc-disc",
	10860: "helix",
	10880: "bveapi",
	10990: "rmiaux",
	11000: "irisa",
	11001: "metasys",
	10023: "cefd-vmp",
	11095: "weave",
	11106: "sgi-lk",
	11108: "myq-termlink",
	11111: "vce",
	11112: "dicom",
	11161: "suncacao-snmp",
	11162: "suncacao-jmxmp",
	11163: "suncacao-rmi",
	11164: "suncacao-csa",
	11165: "suncacao-websvc",
	11171: "snss",
	11201: "smsqp",
	11208: "wifree",
	11211: "memcache",
	11319: "imip",
	11320: "imip-channels",
	11321: "arena-server",
	11367: "atm-uhas",
	11371: "hkp",
	11430: "lsdp",
	11600: "tempest-port",
	11720: "h323callsigalt",
	11723: "emc-xsw-dcache",
	11751: "intrepid-ssl",
	11796: "lanschool-mpt",
	11876: "xoraya",
	11877: "x2e-disc",
	11967: "sysinfo-sp",
	12000: "entextxid",
	12001: "entextnetwk",
	12002: "entexthigh",
	12003: "entextmed",
	12004: "entextlow",
	12005: "dbisamserver1",
	12006: "dbisamserver2",
	12007: "accuracer",
	12008: "accuracer-dbms",
	12009: "ghvpn",
	12012: "vipera",
	12013: "vipera-ssl",
	12109: "rets-ssl",
	12121: "nupaper-ss",
	12168: "cawas",
	12172: "hivep",
	12300: "linogridengine",
	12321: "warehouse-sss",
	12322: "warehouse",
	12345: "italk",
	12753: "tsaf",
	13160: "i-zipqd",
	13216: "bcslogc",
	13217: "rs-pias",
	13218: "emc-vcas-udp",
	13223: "powwow-client",
	13224: "powwow-server",
	13400: "doip-disc",
	13720: "bprd",
	13721: "bpdbm",
	13722: "bpjava-msvc",
	13724: "vnetd",
	13782: "bpcd",
	13783: "vopied",
	13785: "nbdb",
	13786: "nomdb",
	13818: "dsmcc-config",
	13819: "dsmcc-session",
	13820: "dsmcc-passthru",
	13821: "dsmcc-download",
	13822: "dsmcc-ccp",
	13894: "ucontrol",
	13929: "dta-systems",
	14000: "scotty-ft",
	14001: "sua",
	14002: "scotty-disc",
	14033: "sage-best-com1",
	14034: "sage-best-com2",
	14141: "vcs-app",
	14142: "icpp",
	14145: "gcm-app",
	14149: "vrts-tdd",
	14154: "vad",
	14250: "cps",
	14414: "ca-web-update",
	14936: "hde-lcesrvr-1",
	14937: "hde-lcesrvr-2",
	15000: "hydap",
	15118: "v2g-secc",
	15345: "xpilot",
	15363: "3link",
	15555: "cisco-snat",
	15660: "bex-xr",
	15740: "ptp",
	15998: "2ping",
	16003: "alfin",
	16161: "sun-sea-port",
	16309: "etb4j",
	16310: "pduncs",
	16311: "pdefmns",
	16360: "netserialext1",
	16361: "netserialext2",
	16367: "netserialext3",
	16368: "netserialext4",
	16384: "connected",
	16666: "vtp",
	16900: "newbay-snc-mc",
	16950: "sgcip",
	16991: "intel-rci-mp",
	16992: "amt-soap-http",
	16993: "amt-soap-https",
	16994: "amt-redir-tcp",
	16995: "amt-redir-tls",
	17007: "isode-dua",
	17185: "soundsvirtual",
	17219: "chipper",
	17220: "avtp",
	17221: "avdecc",
	17222: "cpsp",
	17234: "integrius-stp",
	17235: "ssh-mgmt",
	17500: "db-lsp-disc",
	17729: "ea",
	17754: "zep",
	17755: "zigbee-ip",
	17756: "zigbee-ips",
	18000: "biimenu",
	18181: "opsec-cvp",
	18182: "opsec-ufp",
	18183: "opsec-sam",
	18184: "opsec-lea",
	18185: "opsec-omi",
	18186: "ohsc",
	18187: "opsec-ela",
	18241: "checkpoint-rtm",
	18262: "gv-pf",
	18463: "ac-cluster",
	18634: "rds-ib",
	18635: "rds-ip",
	18769: "ique",
	18881: "infotos",
	18888: "apc-necmp",
	19000: "igrid",
	19007: "scintilla",
	19191: "opsec-uaa",
	19194: "ua-secureagent",
	19283: "keysrvr",
	19315: "keyshadow",
	19398: "mtrgtrans",
	19410: "hp-sco",
	19411: "hp-sca",
	19412: "hp-sessmon",
	19539: "fxuptp",
	19540: "sxuptp",
	19541: "jcp",
	19788: "mle",
	19999: "dnp-sec",
	20000: "dnp",
	20001: "microsan",
	20002: "commtact-http",
	20003: "commtact-https",
	20005: "openwebnet",
	20012: "ss-idi-disc",
	20014: "opendeploy",
	20034: "nburn-id",
	20046: "tmophl7mts",
	20048: "mountd",
	20049: "nfsrdma",
	20167: "tolfab",
	20202: "ipdtp-port",
	20222: "ipulse-ics",
	20480: "emwavemsg",
	20670: "track",
	20999: "athand-mmp",
	21000: "irtrans",
	21554: "dfserver",
	21590: "vofr-gateway",
	21800: "tvpm",
	21845: "webphone",
	21846: "netspeak-is",
	21847: "netspeak-cs",
	21848: "netspeak-acd",
	21849: "netspeak-cps",
	22000: "snapenetio",
	22001: "optocontrol",
	22002: "optohost002",
	22003: "optohost003",
	22004: "optohost004",
	22005: "optohost004",
	22273: "wnn6",
	22305: "cis",
	22343: "cis-secure",
	22347: "wibukey",
	22350: "codemeter",
	22555: "vocaltec-phone",
	22763: "talikaserver",
	22800: "aws-brf",
	22951: "brf-gw",
	23000: "inovaport1",
	23001: "inovaport2",
	23002: "inovaport3",
	23003: "inovaport4",
	23004: "inovaport5",
	23005: "inovaport6",
	23272: "s102",
	23333: "elxmgmt",
	23400: "novar-dbase",
	23401: "novar-alarm",
	23402: "novar-global",
	24000: "med-ltp",
	24001: "med-fsp-rx",
	24002: "med-fsp-tx",
	24003: "med-supp",
	24004: "med-ovw",
	24005: "med-ci",
	24006: "med-net-svc",
	24242: "filesphere",
	24249: "vista-4gl",
	24321: "ild",
	24322: "hid",
	24386: "intel-rci",
	24465: "tonidods",
	24554: "binkp",
	24577: "bilobit-update",
	24676: "canditv",
	24677: "flashfiler",
	24678: "proactivate",
	24680: "tcc-http",
	24850: "assoc-disc",
	24922: "find",
	25000: "icl-twobase1",
	25001: "icl-twobase2",
	25002: "icl-twobase3",
	25003: "icl-twobase4",
	25004: "icl-twobase5",
	25005: "icl-twobase6",
	25006: "icl-twobase7",
	25007: "icl-twobase8",
	25008: "icl-twobase9",
	25009: "icl-twobase10",
	25793: "vocaltec-hos",
	25900: "tasp-net",
	25901: "niobserver",
	25902: "nilinkanalyst",
	25903: "niprobe",
	25954: "bf-game",
	25955: "bf-master",
	26000: "quake",
	26133: "scscp",
	26208: "wnn6-ds",
	26260: "ezproxy",
	26261: "ezmeeting",
	26262: "k3software-svr",
	26263: "k3software-cli",
	26486: "exoline-udp",
	26487: "exoconfig",
	26489: "exonet",
	27345: "imagepump",
	27442: "jesmsjc",
	27504: "kopek-httphead",
	27782: "ars-vista",
	27999: "tw-auth-key",
	28000: "nxlmd",
	28119: "a27-ran-ran",
	28200: "voxelstorm",
	28240: "siemensgsm",
	29167: "otmp",
	30001: "pago-services1",
	30002: "pago-services2",
	30003: "amicon-fpsu-ra",
	30004: "amicon-fpsu-s",
	30260: "kingdomsonline",
	30832: "samsung-disc",
	30999: "ovobs",
	31029: "yawn",
	31416: "xqosd",
	31457: "tetrinet",
	31620: "lm-mon",
	31765: "gamesmith-port",
	31948: "iceedcp-tx",
	31949: "iceedcp-rx",
	32034: "iracinghelper",
	32249: "t1distproc60",
	32483: "apm-link",
	32635: "sec-ntb-clnt",
	32636: "DMExpress",
	32767: "filenet-powsrm",
	32768: "filenet-tms",
	32769: "filenet-rpc",
	32770: "filenet-nch",
	32771: "filenet-rmi",
	32772: "filenet-pa",
	32773: "filenet-cm",
	32774: "filenet-re",
	32775: "filenet-pch",
	32776: "filenet-peior",
	32777: "filenet-obrok",
	32801: "mlsn",
	32896: "idmgratm",
	33123: "aurora-balaena",
	33331: "diamondport",
	33334: "speedtrace-disc",
	33434: "traceroute",
	33656: "snip-slave",
	34249: "turbonote-2",
	34378: "p-net-local",
	34379: "p-net-remote",
	34962: "profinet-rt",
	34963: "profinet-rtm",
	34964: "profinet-cm",
	34980: "ethercat",
	35001: "rt-viewer",
	35004: "rt-classmanager",
	35355: "altova-lm-disc",
	36001: "allpeers",
	36865: "kastenxpipe",
	37475: "neckar",
	37654: "unisys-eportal",
	38201: "galaxy7-data",
	38202: "fairview",
	38203: "agpolicy",
	39681: "turbonote-1",
	40000: "safetynetp",
	40841: "cscp",
	40842: "csccredir",
	40843: "csccfirewall",
	40853: "ortec-disc",
	41111: "fs-qos",
	41794: "crestron-cip",
	41795: "crestron-ctp",
	42508: "candp",
	42509: "candrp",
	42510: "caerpc",
	43000: "recvr-rc-disc",
	43188: "reachout",
	43189: "ndm-agent-port",
	43190: "ip-provision",
	43210: "shaperai-disc",
	43439: "eq3-config",
	43440: "ew-disc-cmd",
	43441: "ciscocsdb",
	44321: "pmcd",
	44322: "pmcdproxy",
	44544: "domiq",
	44553: "rbr-debug",
	44600: "asihpi",
	44818: "EtherNet-IP-2",
	44900: "m3da-disc",
	45000: "asmp-mon",
	45054: "invision-ag",
	45678: "eba",
	45825: "qdb2service",
	45966: "ssr-servermgr",
	46999: "mediabox",
	47000: "mbus",
	47100: "jvl-mactalk",
	47557: "dbbrowse",
	47624: "directplaysrvr",
	47806: "ap",
	47808: "bacnet",
	47809: "presonus-ucnet",
	48000: "nimcontroller",
	48001: "nimspooler",
	48002: "nimhub",
	48003: "nimgtw",
	48128: "isnetserv",
	48129: "blp5",
	48556: "com-bardac-dw",
	48619: "iqobject",
	48653: "robotraconteur",
}
var sctpPortNames = map[SCTPPort]string{
	9:     "discard",
	20:    "ftp-data",
	21:    "ftp",
	22:    "ssh",
	80:    "http",
	179:   "bgp",
	443:   "https",
	1021:  "exp1",
	1022:  "exp2",
	1167:  "cisco-ipsla",
	1720:  "h323hostcall",
	2049:  "nfs",
	2225:  "rcip-itu",
	2904:  "m2ua",
	2905:  "m3ua",
	2944:  "megaco-h248",
	2945:  "h248-binary",
	3097:  "itu-bicc-stc",
	3565:  "m2pa",
	3863:  "asap-sctp",
	3864:  "asap-sctp-tls",
	3868:  "diameter",
	4333:  "ahsp",
	4502:  "a25-fap-fgw",
	4739:  "ipfix",
	4740:  "ipfixs",
	5060:  "sip",
	5061:  "sips",
	5090:  "car",
	5091:  "cxtp",
	5215:  "noteza",
	5445:  "smbdirect",
	5672:  "amqp",
	5675:  "v5ua",
	5868:  "diameters",
	5910:  "cm",
	5911:  "cpdlc",
	5912:  "fis",
	5913:  "ads-c",
	6704:  "frc-hp",
	6705:  "frc-mp",
	6706:  "frc-lp",
	6970:  "conductor-mpx",
	7626:  "simco",
	8471:  "pim-port",
	9082:  "lcs-ap",
	9084:  "aurora",
	9900:  "iua",
	9901:  "enrp-sctp",
	9902:  "enrp-sctp-tls",
	11997: "wmereceiving",
	11998: "wmedistribution",
	11999: "wmereporting",
	14001: "sua",
	20049: "nfsrdma",
	25471: "rna",
	29118: "sgsap",
	29168: "sbcap",
	29169: "iuhsctpassoc",
	36412: "s1-control",
	36422: "x2-control",
	36443: "m2ap",
	36444: "m3ap",
}
