#!/usr/bin/env perl
#
# Copyright (c) 2015 Martins Innus.  All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# This utility will generate a config file suitable for use with
# pmlogrewrite to update the metrics generated by the perfevent pmda.


use warnings;
use strict;

open PERFEVENTS, "pminfo perfevent |"
    or die "Can't load perfevents: $!";

open CONFIG, ">perfevent_rewrite.conf"
    or die "Can't open perfevent_rewrite.conf for writing";

while (<PERFEVENTS>) {
    my $line = $_;
    chomp $line;
    if ($line =~ /[^a-zA-Z0-9_\.]/){
        my $newline = $line;
        $newline =~ s/[^a-zA-Z0-9_\.]/_/g;

        print CONFIG "METRIC $line { NAME -> $newline }\n"
    }
} 

close PERFEVENTS;
close CONFIG;
