#!/bin/bash
set -euo pipefail

TMPDIR="$PWD/venv-build"
mkdir "$TMPDIR"
VENV_PATH=$TMPDIR/usr/share/ucs-test/playwright-venv

python3 -m venv --system-site-packages --upgrade "$VENV_PATH"

./install_typing_extensions.sh && ./install_playwright.sh && ./install_pytest_playwright.sh
grep -rIl "$TMPDIR" | xargs sed -i "s#$TMPDIR##g"

