#!/bin/bash
set -euo pipefail

export TMPDIR="$PWD/venv-build"
export VENV_PATH=$TMPDIR/usr/share/ucs-test/playwright-venv

mkdir "$TMPDIR"

python3 -m venv --system-site-packages --upgrade "$VENV_PATH"

./install_typing_extensions.sh \
  && ./install_playwright.sh \
  && ./install_pytest_playwright.sh \
  && ./install_urllib3.sh \
  && ./install_python_keycloak.sh
grep -rIl "$TMPDIR" | xargs sed -i "s#$TMPDIR##g"

