# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._text_analytics_client_enums import *


class JobManifest(msrest.serialization.Model):
    """JobManifest.

    All required parameters must be populated in order to send to Azure.

    :param tasks: Required. The set of tasks to execute on the input documents. Cannot specify the
     same task more than once.
    :type tasks: ~azure.ai.textanalytics.v3_1_preview_3.models.JobManifestTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'JobManifestTasks'},
    }

    def __init__(
        self,
        *,
        tasks: "JobManifestTasks",
        **kwargs
    ):
        super(JobManifest, self).__init__(**kwargs)
        self.tasks = tasks


class JobDescriptor(msrest.serialization.Model):
    """JobDescriptor.

    :param display_name: Optional display name for the analysis job.
    :type display_name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(JobDescriptor, self).__init__(**kwargs)
        self.display_name = display_name


class AnalyzeBatchInput(JobDescriptor, JobManifest):
    """AnalyzeBatchInput.

    All required parameters must be populated in order to send to Azure.

    :param tasks: Required. The set of tasks to execute on the input documents. Cannot specify the
     same task more than once.
    :type tasks: ~azure.ai.textanalytics.v3_1_preview_3.models.JobManifestTasks
    :param display_name: Optional display name for the analysis job.
    :type display_name: str
    :param analysis_input: Required. Contains a set of input documents to be analyzed by the
     service.
    :type analysis_input: ~azure.ai.textanalytics.v3_1_preview_3.models.MultiLanguageBatchInput
    """

    _validation = {
        'tasks': {'required': True},
        'analysis_input': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'JobManifestTasks'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'analysis_input': {'key': 'analysisInput', 'type': 'MultiLanguageBatchInput'},
    }

    def __init__(
        self,
        *,
        tasks: "JobManifestTasks",
        analysis_input: "MultiLanguageBatchInput",
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(AnalyzeBatchInput, self).__init__(display_name=display_name, tasks=tasks, **kwargs)
        self.tasks = tasks
        self.analysis_input = analysis_input
        self.display_name = display_name
        self.analysis_input = analysis_input


class Pagination(msrest.serialization.Model):
    """Pagination.

    :param next_link:
    :type next_link: str
    """

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(Pagination, self).__init__(**kwargs)
        self.next_link = next_link


class TasksState(msrest.serialization.Model):
    """TasksState.

    All required parameters must be populated in order to send to Azure.

    :param tasks: Required.
    :type tasks: ~azure.ai.textanalytics.v3_1_preview_3.models.TasksStateTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
    }

    def __init__(
        self,
        *,
        tasks: "TasksStateTasks",
        **kwargs
    ):
        super(TasksState, self).__init__(**kwargs)
        self.tasks = tasks


class JobMetadata(msrest.serialization.Model):
    """JobMetadata.

    All required parameters must be populated in order to send to Azure.

    :param created_date_time: Required.
    :type created_date_time: ~datetime.datetime
    :param display_name:
    :type display_name: str
    :param expiration_date_time:
    :type expiration_date_time: ~datetime.datetime
    :param job_id: Required.
    :type job_id: str
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(JobMetadata, self).__init__(**kwargs)
        self.created_date_time = created_date_time
        self.display_name = display_name
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status


class AnalyzeJobState(JobMetadata, TasksState, Pagination):
    """AnalyzeJobState.

    All required parameters must be populated in order to send to Azure.

    :param next_link:
    :type next_link: str
    :param tasks: Required.
    :type tasks: ~azure.ai.textanalytics.v3_1_preview_3.models.TasksStateTasks
    :param created_date_time: Required.
    :type created_date_time: ~datetime.datetime
    :param display_name:
    :type display_name: str
    :param expiration_date_time:
    :type expiration_date_time: ~datetime.datetime
    :param job_id: Required.
    :type job_id: str
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    :param errors:
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    """

    _validation = {
        'tasks': {'required': True},
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'tasks': {'key': 'tasks', 'type': 'TasksStateTasks'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
    }

    def __init__(
        self,
        *,
        tasks: "TasksStateTasks",
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        next_link: Optional[str] = None,
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[List["TextAnalyticsError"]] = None,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(AnalyzeJobState, self).__init__(created_date_time=created_date_time, display_name=display_name, expiration_date_time=expiration_date_time, job_id=job_id, last_update_date_time=last_update_date_time, status=status, tasks=tasks, next_link=next_link, **kwargs)
        self.next_link = next_link
        self.tasks = tasks
        self.errors = errors
        self.statistics = statistics
        self.next_link = next_link
        self.created_date_time = created_date_time
        self.display_name = display_name
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.errors = errors
        self.statistics = statistics
        self.tasks = tasks
        self.created_date_time = created_date_time
        self.display_name = display_name
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.errors = errors
        self.statistics = statistics


class AspectConfidenceScoreLabel(msrest.serialization.Model):
    """Represents the confidence scores across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :param positive: Required.
    :type positive: float
    :param negative: Required.
    :type negative: float
    """

    _validation = {
        'positive': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        positive: float,
        negative: float,
        **kwargs
    ):
        super(AspectConfidenceScoreLabel, self).__init__(**kwargs)
        self.positive = positive
        self.negative = negative


class AspectRelation(msrest.serialization.Model):
    """AspectRelation.

    All required parameters must be populated in order to send to Azure.

    :param relation_type: Required. The type related to the aspect. Possible values include:
     "opinion", "aspect".
    :type relation_type: str or ~azure.ai.textanalytics.v3_1_preview_3.models.AspectRelationType
    :param ref: Required. The JSON pointer indicating the linked object.
    :type ref: str
    """

    _validation = {
        'relation_type': {'required': True},
        'ref': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'ref': {'key': 'ref', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        relation_type: Union[str, "AspectRelationType"],
        ref: str,
        **kwargs
    ):
        super(AspectRelation, self).__init__(**kwargs)
        self.relation_type = relation_type
        self.ref = ref


class Components15Gvwi3SchemasTasksstatePropertiesTasksPropertiesEntityrecognitiontasksItemsAllof1(msrest.serialization.Model):
    """Components15Gvwi3SchemasTasksstatePropertiesTasksPropertiesEntityrecognitiontasksItemsAllof1.

    All required parameters must be populated in order to send to Azure.

    :param results: Required.
    :type results: ~azure.ai.textanalytics.v3_1_preview_3.models.EntitiesResult
    """

    _validation = {
        'results': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntitiesResult'},
    }

    def __init__(
        self,
        *,
        results: "EntitiesResult",
        **kwargs
    ):
        super(Components15Gvwi3SchemasTasksstatePropertiesTasksPropertiesEntityrecognitiontasksItemsAllof1, self).__init__(**kwargs)
        self.results = results


class Components15X8E9LSchemasTasksstatePropertiesTasksPropertiesEntityrecognitionpiitasksItemsAllof1(msrest.serialization.Model):
    """Components15X8E9LSchemasTasksstatePropertiesTasksPropertiesEntityrecognitionpiitasksItemsAllof1.

    All required parameters must be populated in order to send to Azure.

    :param results: Required.
    :type results: ~azure.ai.textanalytics.v3_1_preview_3.models.PiiResult
    """

    _validation = {
        'results': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'PiiResult'},
    }

    def __init__(
        self,
        *,
        results: "PiiResult",
        **kwargs
    ):
        super(Components15X8E9LSchemasTasksstatePropertiesTasksPropertiesEntityrecognitionpiitasksItemsAllof1, self).__init__(**kwargs)
        self.results = results


class Components1D9IzucSchemasTasksstatePropertiesTasksPropertiesKeyphraseextractiontasksItemsAllof1(msrest.serialization.Model):
    """Components1D9IzucSchemasTasksstatePropertiesTasksPropertiesKeyphraseextractiontasksItemsAllof1.

    All required parameters must be populated in order to send to Azure.

    :param results: Required.
    :type results: ~azure.ai.textanalytics.v3_1_preview_3.models.KeyPhraseResult
    """

    _validation = {
        'results': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
    }

    def __init__(
        self,
        *,
        results: "KeyPhraseResult",
        **kwargs
    ):
        super(Components1D9IzucSchemasTasksstatePropertiesTasksPropertiesKeyphraseextractiontasksItemsAllof1, self).__init__(**kwargs)
        self.results = results


class DetectedLanguage(msrest.serialization.Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Long name of a detected language (e.g. English, French).
    :type name: str
    :param iso6391_name: Required. A two letter representation of the detected language according
     to the ISO 639-1 standard (e.g. en, fr).
    :type iso6391_name: str
    :param confidence_score: Required. A confidence score between 0 and 1. Scores close to 1
     indicate 100% certainty that the identified language is true.
    :type confidence_score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'iso6391_name': {'key': 'iso6391Name', 'type': 'str'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        name: str,
        iso6391_name: str,
        confidence_score: float,
        **kwargs
    ):
        super(DetectedLanguage, self).__init__(**kwargs)
        self.name = name
        self.iso6391_name = iso6391_name
        self.confidence_score = confidence_score


class DocumentEntities(msrest.serialization.Model):
    """DocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Recognized entities in the document.
    :type entities: list[~azure.ai.textanalytics.v3_1_preview_3.models.Entity]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        entities: List["Entity"],
        warnings: List["TextAnalyticsWarning"],
        statistics: Optional["DocumentStatistics"] = None,
        **kwargs
    ):
        super(DocumentEntities, self).__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class DocumentError(msrest.serialization.Model):
    """DocumentError.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Document Id.
    :type id: str
    :param error: Required. Document Error.
    :type error: ~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsError
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        *,
        id: str,
        error: "TextAnalyticsError",
        **kwargs
    ):
        super(DocumentError, self).__init__(**kwargs)
        self.id = id
        self.error = error


class DocumentHealthcareEntities(msrest.serialization.Model):
    """DocumentHealthcareEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Healthcare entities.
    :type entities: list[~azure.ai.textanalytics.v3_1_preview_3.models.HealthcareEntity]
    :param relations: Required. Healthcare entity relations.
    :type relations: list[~azure.ai.textanalytics.v3_1_preview_3.models.HealthcareRelation]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[HealthcareEntity]'},
        'relations': {'key': 'relations', 'type': '[HealthcareRelation]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        entities: List["HealthcareEntity"],
        relations: List["HealthcareRelation"],
        warnings: List["TextAnalyticsWarning"],
        statistics: Optional["DocumentStatistics"] = None,
        **kwargs
    ):
        super(DocumentHealthcareEntities, self).__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.relations = relations
        self.warnings = warnings
        self.statistics = statistics


class DocumentKeyPhrases(msrest.serialization.Model):
    """DocumentKeyPhrases.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param key_phrases: Required. A list of representative words or phrases. The number of key
     phrases returned is proportional to the number of words in the input document.
    :type key_phrases: list[str]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'key_phrases': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key_phrases': {'key': 'keyPhrases', 'type': '[str]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        key_phrases: List[str],
        warnings: List["TextAnalyticsWarning"],
        statistics: Optional["DocumentStatistics"] = None,
        **kwargs
    ):
        super(DocumentKeyPhrases, self).__init__(**kwargs)
        self.id = id
        self.key_phrases = key_phrases
        self.warnings = warnings
        self.statistics = statistics


class DocumentLanguage(msrest.serialization.Model):
    """DocumentLanguage.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param detected_language: Required. Detected Language.
    :type detected_language: ~azure.ai.textanalytics.v3_1_preview_3.models.DetectedLanguage
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'detected_language': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'detected_language': {'key': 'detectedLanguage', 'type': 'DetectedLanguage'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        detected_language: "DetectedLanguage",
        warnings: List["TextAnalyticsWarning"],
        statistics: Optional["DocumentStatistics"] = None,
        **kwargs
    ):
        super(DocumentLanguage, self).__init__(**kwargs)
        self.id = id
        self.detected_language = detected_language
        self.warnings = warnings
        self.statistics = statistics


class DocumentLinkedEntities(msrest.serialization.Model):
    """DocumentLinkedEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param entities: Required. Recognized well-known entities in the document.
    :type entities: list[~azure.ai.textanalytics.v3_1_preview_3.models.LinkedEntity]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[LinkedEntity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        entities: List["LinkedEntity"],
        warnings: List["TextAnalyticsWarning"],
        statistics: Optional["DocumentStatistics"] = None,
        **kwargs
    ):
        super(DocumentLinkedEntities, self).__init__(**kwargs)
        self.id = id
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class DocumentSentiment(msrest.serialization.Model):
    """DocumentSentiment.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param sentiment: Required. Predicted sentiment for document (Negative, Neutral, Positive, or
     Mixed). Possible values include: "positive", "neutral", "negative", "mixed".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentSentimentValue
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentStatistics
    :param confidence_scores: Required. Document level sentiment confidence scores between 0 and 1
     for each sentiment class.
    :type confidence_scores:
     ~azure.ai.textanalytics.v3_1_preview_3.models.SentimentConfidenceScorePerLabel
    :param sentences: Required. Sentence level sentiment analysis.
    :type sentences: list[~azure.ai.textanalytics.v3_1_preview_3.models.SentenceSentiment]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsWarning]
    """

    _validation = {
        'id': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'sentences': {'key': 'sentences', 'type': '[SentenceSentiment]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
    }

    def __init__(
        self,
        *,
        id: str,
        sentiment: Union[str, "DocumentSentimentValue"],
        confidence_scores: "SentimentConfidenceScorePerLabel",
        sentences: List["SentenceSentiment"],
        warnings: List["TextAnalyticsWarning"],
        statistics: Optional["DocumentStatistics"] = None,
        **kwargs
    ):
        super(DocumentSentiment, self).__init__(**kwargs)
        self.id = id
        self.sentiment = sentiment
        self.statistics = statistics
        self.confidence_scores = confidence_scores
        self.sentences = sentences
        self.warnings = warnings


class DocumentStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :param characters_count: Required. Number of text elements recognized in the document.
    :type characters_count: int
    :param transactions_count: Required. Number of transactions for the document.
    :type transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'characters_count': {'key': 'charactersCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        characters_count: int,
        transactions_count: int,
        **kwargs
    ):
        super(DocumentStatistics, self).__init__(**kwargs)
        self.characters_count = characters_count
        self.transactions_count = transactions_count


class EntitiesResult(msrest.serialization.Model):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["DocumentEntities"],
        errors: List["DocumentError"],
        model_version: str,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(EntitiesResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class EntitiesTask(msrest.serialization.Model):
    """EntitiesTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1_preview_3.models.EntitiesTaskParameters
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'EntitiesTaskParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["EntitiesTaskParameters"] = None,
        **kwargs
    ):
        super(EntitiesTask, self).__init__(**kwargs)
        self.parameters = parameters


class EntitiesTaskParameters(msrest.serialization.Model):
    """EntitiesTaskParameters.

    :param model_version:
    :type model_version: str
    :param string_index_type:  Possible values include: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :type string_index_type: str or
     ~azure.ai.textanalytics.v3_1_preview_3.models.StringIndexTypeResponse
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model_version: Optional[str] = "latest",
        string_index_type: Optional[Union[str, "StringIndexTypeResponse"]] = "TextElements_v8",
        **kwargs
    ):
        super(EntitiesTaskParameters, self).__init__(**kwargs)
        self.model_version = model_version
        self.string_index_type = string_index_type


class Entity(msrest.serialization.Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param category: Required. Entity type.
    :type category: str
    :param subcategory: (Optional) Entity sub type.
    :type subcategory: str
    :param offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :type offset: int
    :param length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :type length: int
    :param confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :type confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        **kwargs
    ):
        super(Entity, self).__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score


class EntityLinkingResult(msrest.serialization.Model):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentLinkedEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLinkedEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["DocumentLinkedEntities"],
        errors: List["DocumentError"],
        model_version: str,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(EntityLinkingResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. Document Error.
    :type error: ~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'TextAnalyticsError'},
    }

    def __init__(
        self,
        *,
        error: "TextAnalyticsError",
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class HealthcareEntity(Entity):
    """HealthcareEntity.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param category: Required. Entity type.
    :type category: str
    :param subcategory: (Optional) Entity sub type.
    :type subcategory: str
    :param offset: Required. Start position for the entity text. Use of different 'stringIndexType'
     values can affect the offset returned.
    :type offset: int
    :param length: Required. Length for the entity text. Use of different 'stringIndexType' values
     can affect the length returned.
    :type length: int
    :param confidence_score: Required. Confidence score between 0 and 1 of the extracted entity.
    :type confidence_score: float
    :param is_negated: Required.
    :type is_negated: bool
    :param links: Entity references in known data sources.
    :type links: list[~azure.ai.textanalytics.v3_1_preview_3.models.HealthcareEntityLink]
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
        'is_negated': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'subcategory': {'key': 'subcategory', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'is_negated': {'key': 'isNegated', 'type': 'bool'},
        'links': {'key': 'links', 'type': '[HealthcareEntityLink]'},
    }

    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        is_negated: bool,
        subcategory: Optional[str] = None,
        links: Optional[List["HealthcareEntityLink"]] = None,
        **kwargs
    ):
        super(HealthcareEntity, self).__init__(text=text, category=category, subcategory=subcategory, offset=offset, length=length, confidence_score=confidence_score, **kwargs)
        self.is_negated = is_negated
        self.links = links


class HealthcareEntityLink(msrest.serialization.Model):
    """HealthcareEntityLink.

    All required parameters must be populated in order to send to Azure.

    :param data_source: Required. Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
    :type data_source: str
    :param id: Required. Entity id in the given source catalog.
    :type id: str
    """

    _validation = {
        'data_source': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_source: str,
        id: str,
        **kwargs
    ):
        super(HealthcareEntityLink, self).__init__(**kwargs)
        self.data_source = data_source
        self.id = id


class HealthcareJobState(JobMetadata, Pagination):
    """HealthcareJobState.

    All required parameters must be populated in order to send to Azure.

    :param next_link:
    :type next_link: str
    :param created_date_time: Required.
    :type created_date_time: ~datetime.datetime
    :param display_name:
    :type display_name: str
    :param expiration_date_time:
    :type expiration_date_time: ~datetime.datetime
    :param job_id: Required.
    :type job_id: str
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    :param results:
    :type results: ~azure.ai.textanalytics.v3_1_preview_3.models.HealthcareResult
    :param errors:
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsError]
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': '@nextLink', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'results': {'key': 'results', 'type': 'HealthcareResult'},
        'errors': {'key': 'errors', 'type': '[TextAnalyticsError]'},
    }

    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        next_link: Optional[str] = None,
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        results: Optional["HealthcareResult"] = None,
        errors: Optional[List["TextAnalyticsError"]] = None,
        **kwargs
    ):
        super(HealthcareJobState, self).__init__(created_date_time=created_date_time, display_name=display_name, expiration_date_time=expiration_date_time, job_id=job_id, last_update_date_time=last_update_date_time, status=status, next_link=next_link, **kwargs)
        self.next_link = next_link
        self.results = results
        self.errors = errors
        self.created_date_time = created_date_time
        self.display_name = display_name
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.results = results
        self.errors = errors


class HealthcareRelation(msrest.serialization.Model):
    """HealthcareRelation.

    All required parameters must be populated in order to send to Azure.

    :param relation_type: Required. Type of relation. Examples include: ``DosageOfMedication`` or
     'FrequencyOfMedication', etc.
    :type relation_type: str
    :param bidirectional: Required. If true the relation between the entities is bidirectional,
     otherwise directionality is source to target.
    :type bidirectional: bool
    :param source: Required. Reference link to the source entity.
    :type source: str
    :param target: Required. Reference link to the target entity.
    :type target: str
    """

    _validation = {
        'relation_type': {'required': True},
        'bidirectional': {'required': True},
        'source': {'required': True},
        'target': {'required': True},
    }

    _attribute_map = {
        'relation_type': {'key': 'relationType', 'type': 'str'},
        'bidirectional': {'key': 'bidirectional', 'type': 'bool'},
        'source': {'key': 'source', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        relation_type: str,
        bidirectional: bool,
        source: str,
        target: str,
        **kwargs
    ):
        super(HealthcareRelation, self).__init__(**kwargs)
        self.relation_type = relation_type
        self.bidirectional = bidirectional
        self.source = source
        self.target = target


class HealthcareResult(msrest.serialization.Model):
    """HealthcareResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentHealthcareEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentHealthcareEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["DocumentHealthcareEntities"],
        errors: List["DocumentError"],
        model_version: str,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(HealthcareResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class InnerError(msrest.serialization.Model):
    """InnerError.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include: "InvalidParameterValue",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputRecords", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode",
     "InvalidCountryHint".
    :type code: str or ~azure.ai.textanalytics.v3_1_preview_3.models.InnerErrorCodeValue
    :param message: Required. Error message.
    :type message: str
    :param details: Error details.
    :type details: dict[str, str]
    :param target: Error target.
    :type target: str
    :param innererror: Inner error contains more specific information.
    :type innererror: ~azure.ai.textanalytics.v3_1_preview_3.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "InnerErrorCodeValue"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["InnerError"] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class JobManifestTasks(msrest.serialization.Model):
    """The set of tasks to execute on the input documents. Cannot specify the same task more than once.

    :param entity_recognition_tasks:
    :type entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_1_preview_3.models.EntitiesTask]
    :param entity_recognition_pii_tasks:
    :type entity_recognition_pii_tasks: list[~azure.ai.textanalytics.v3_1_preview_3.models.PiiTask]
    :param key_phrase_extraction_tasks:
    :type key_phrase_extraction_tasks:
     list[~azure.ai.textanalytics.v3_1_preview_3.models.KeyPhrasesTask]
    """

    _attribute_map = {
        'entity_recognition_tasks': {'key': 'entityRecognitionTasks', 'type': '[EntitiesTask]'},
        'entity_recognition_pii_tasks': {'key': 'entityRecognitionPiiTasks', 'type': '[PiiTask]'},
        'key_phrase_extraction_tasks': {'key': 'keyPhraseExtractionTasks', 'type': '[KeyPhrasesTask]'},
    }

    def __init__(
        self,
        *,
        entity_recognition_tasks: Optional[List["EntitiesTask"]] = None,
        entity_recognition_pii_tasks: Optional[List["PiiTask"]] = None,
        key_phrase_extraction_tasks: Optional[List["KeyPhrasesTask"]] = None,
        **kwargs
    ):
        super(JobManifestTasks, self).__init__(**kwargs)
        self.entity_recognition_tasks = entity_recognition_tasks
        self.entity_recognition_pii_tasks = entity_recognition_pii_tasks
        self.key_phrase_extraction_tasks = key_phrase_extraction_tasks


class KeyPhraseResult(msrest.serialization.Model):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentKeyPhrases]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentKeyPhrases]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["DocumentKeyPhrases"],
        errors: List["DocumentError"],
        model_version: str,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(KeyPhraseResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class KeyPhrasesTask(msrest.serialization.Model):
    """KeyPhrasesTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1_preview_3.models.KeyPhrasesTaskParameters
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'KeyPhrasesTaskParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["KeyPhrasesTaskParameters"] = None,
        **kwargs
    ):
        super(KeyPhrasesTask, self).__init__(**kwargs)
        self.parameters = parameters


class KeyPhrasesTaskParameters(msrest.serialization.Model):
    """KeyPhrasesTaskParameters.

    :param model_version:
    :type model_version: str
    """

    _attribute_map = {
        'model_version': {'key': 'model-version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model_version: Optional[str] = "latest",
        **kwargs
    ):
        super(KeyPhrasesTaskParameters, self).__init__(**kwargs)
        self.model_version = model_version


class LanguageBatchInput(msrest.serialization.Model):
    """LanguageBatchInput.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.LanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[LanguageInput]'},
    }

    def __init__(
        self,
        *,
        documents: List["LanguageInput"],
        **kwargs
    ):
        super(LanguageBatchInput, self).__init__(**kwargs)
        self.documents = documents


class LanguageInput(msrest.serialization.Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param text: Required.
    :type text: str
    :param country_hint:
    :type country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'country_hint': {'key': 'countryHint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        text: str,
        country_hint: Optional[str] = None,
        **kwargs
    ):
        super(LanguageInput, self).__init__(**kwargs)
        self.id = id
        self.text = text
        self.country_hint = country_hint


class LanguageResult(msrest.serialization.Model):
    """LanguageResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentLanguage]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentLanguage]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["DocumentLanguage"],
        errors: List["DocumentError"],
        model_version: str,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(LanguageResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class LinkedEntity(msrest.serialization.Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Entity Linking formal name.
    :type name: str
    :param matches: Required. List of instances this entity appears in the text.
    :type matches: list[~azure.ai.textanalytics.v3_1_preview_3.models.Match]
    :param language: Required. Language used in the data source.
    :type language: str
    :param id: Unique identifier of the recognized entity from the data source.
    :type id: str
    :param url: Required. URL for the entity's page from the data source.
    :type url: str
    :param data_source: Required. Data source used to extract entity linking, such as Wiki/Bing
     etc.
    :type data_source: str
    :param bing_id: Bing Entity Search API unique identifier of the recognized entity.
    :type bing_id: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'matches': {'key': 'matches', 'type': '[Match]'},
        'language': {'key': 'language', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        matches: List["Match"],
        language: str,
        url: str,
        data_source: str,
        id: Optional[str] = None,
        bing_id: Optional[str] = None,
        **kwargs
    ):
        super(LinkedEntity, self).__init__(**kwargs)
        self.name = name
        self.matches = matches
        self.language = language
        self.id = id
        self.url = url
        self.data_source = data_source
        self.bing_id = bing_id


class Match(msrest.serialization.Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :param confidence_score: Required. If a well-known item is recognized, a decimal number
     denoting the confidence level between 0 and 1 will be returned.
    :type confidence_score: float
    :param text: Required. Entity text as appears in the request.
    :type text: str
    :param offset: Required. Start position for the entity match text.
    :type offset: int
    :param length: Required. Length for the entity match text.
    :type length: int
    """

    _validation = {
        'confidence_score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'confidence_score': {'key': 'confidenceScore', 'type': 'float'},
        'text': {'key': 'text', 'type': 'str'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        text: str,
        offset: int,
        length: int,
        **kwargs
    ):
        super(Match, self).__init__(**kwargs)
        self.confidence_score = confidence_score
        self.text = text
        self.offset = offset
        self.length = length


class MultiLanguageBatchInput(msrest.serialization.Model):
    """Contains a set of input documents to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. The set of documents to process as part of this batch.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.MultiLanguageInput]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[MultiLanguageInput]'},
    }

    def __init__(
        self,
        *,
        documents: List["MultiLanguageInput"],
        **kwargs
    ):
        super(MultiLanguageBatchInput, self).__init__(**kwargs)
        self.documents = documents


class MultiLanguageInput(msrest.serialization.Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A unique, non-empty document identifier.
    :type id: str
    :param text: Required. The input text to process.
    :type text: str
    :param language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :type language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        text: str,
        language: Optional[str] = None,
        **kwargs
    ):
        super(MultiLanguageInput, self).__init__(**kwargs)
        self.id = id
        self.text = text
        self.language = language


class PiiDocumentEntities(msrest.serialization.Model):
    """PiiDocumentEntities.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique, non-empty document identifier.
    :type id: str
    :param redacted_text: Required. Returns redacted text.
    :type redacted_text: str
    :param entities: Required. Recognized entities in the document.
    :type entities: list[~azure.ai.textanalytics.v3_1_preview_3.models.Entity]
    :param warnings: Required. Warnings encountered while processing document.
    :type warnings: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsWarning]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'redacted_text': {'key': 'redactedText', 'type': 'str'},
        'entities': {'key': 'entities', 'type': '[Entity]'},
        'warnings': {'key': 'warnings', 'type': '[TextAnalyticsWarning]'},
        'statistics': {'key': 'statistics', 'type': 'DocumentStatistics'},
    }

    def __init__(
        self,
        *,
        id: str,
        redacted_text: str,
        entities: List["Entity"],
        warnings: List["TextAnalyticsWarning"],
        statistics: Optional["DocumentStatistics"] = None,
        **kwargs
    ):
        super(PiiDocumentEntities, self).__init__(**kwargs)
        self.id = id
        self.redacted_text = redacted_text
        self.entities = entities
        self.warnings = warnings
        self.statistics = statistics


class PiiResult(msrest.serialization.Model):
    """PiiResult.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Response by document.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.PiiDocumentEntities]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[PiiDocumentEntities]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["PiiDocumentEntities"],
        errors: List["DocumentError"],
        model_version: str,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(PiiResult, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class PiiTask(msrest.serialization.Model):
    """PiiTask.

    :param parameters:
    :type parameters: ~azure.ai.textanalytics.v3_1_preview_3.models.PiiTaskParameters
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': 'PiiTaskParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["PiiTaskParameters"] = None,
        **kwargs
    ):
        super(PiiTask, self).__init__(**kwargs)
        self.parameters = parameters


class PiiTaskParameters(msrest.serialization.Model):
    """PiiTaskParameters.

    :param domain:  Possible values include: "phi", "none". Default value: "none".
    :type domain: str or ~azure.ai.textanalytics.v3_1_preview_3.models.PiiTaskParametersDomain
    :param model_version:
    :type model_version: str
    :param string_index_type:  Possible values include: "TextElements_v8", "UnicodeCodePoint",
     "Utf16CodeUnit". Default value: "TextElements_v8".
    :type string_index_type: str or
     ~azure.ai.textanalytics.v3_1_preview_3.models.StringIndexTypeResponse
    """

    _attribute_map = {
        'domain': {'key': 'domain', 'type': 'str'},
        'model_version': {'key': 'model-version', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain: Optional[Union[str, "PiiTaskParametersDomain"]] = "none",
        model_version: Optional[str] = "latest",
        string_index_type: Optional[Union[str, "StringIndexTypeResponse"]] = "TextElements_v8",
        **kwargs
    ):
        super(PiiTaskParameters, self).__init__(**kwargs)
        self.domain = domain
        self.model_version = model_version
        self.string_index_type = string_index_type


class RequestStatistics(msrest.serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :param documents_count: Required. Number of documents submitted in the request.
    :type documents_count: int
    :param valid_documents_count: Required. Number of valid documents. This excludes empty, over-
     size limit or non-supported languages documents.
    :type valid_documents_count: int
    :param erroneous_documents_count: Required. Number of invalid documents. This includes empty,
     over-size limit or non-supported languages documents.
    :type erroneous_documents_count: int
    :param transactions_count: Required. Number of transactions for the request.
    :type transactions_count: long
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        'documents_count': {'key': 'documentsCount', 'type': 'int'},
        'valid_documents_count': {'key': 'validDocumentsCount', 'type': 'int'},
        'erroneous_documents_count': {'key': 'erroneousDocumentsCount', 'type': 'int'},
        'transactions_count': {'key': 'transactionsCount', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
        **kwargs
    ):
        super(RequestStatistics, self).__init__(**kwargs)
        self.documents_count = documents_count
        self.valid_documents_count = valid_documents_count
        self.erroneous_documents_count = erroneous_documents_count
        self.transactions_count = transactions_count


class SentenceAspect(msrest.serialization.Model):
    """SentenceAspect.

    All required parameters must be populated in order to send to Azure.

    :param sentiment: Required. Aspect level sentiment for the aspect in the sentence. Possible
     values include: "positive", "mixed", "negative".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1_preview_3.models.TokenSentimentValue
    :param confidence_scores: Required. Aspect level sentiment confidence scores for the aspect in
     the sentence.
    :type confidence_scores:
     ~azure.ai.textanalytics.v3_1_preview_3.models.AspectConfidenceScoreLabel
    :param offset: Required. The aspect offset from the start of the sentence.
    :type offset: int
    :param length: Required. The length of the aspect.
    :type length: int
    :param text: Required. The aspect text detected.
    :type text: str
    :param relations: Required. The array of either opinion or aspect object which is related to
     the aspect.
    :type relations: list[~azure.ai.textanalytics.v3_1_preview_3.models.AspectRelation]
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'AspectConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'relations': {'key': 'relations', 'type': '[AspectRelation]'},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "TokenSentimentValue"],
        confidence_scores: "AspectConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        relations: List["AspectRelation"],
        **kwargs
    ):
        super(SentenceAspect, self).__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.relations = relations


class SentenceOpinion(msrest.serialization.Model):
    """SentenceOpinion.

    All required parameters must be populated in order to send to Azure.

    :param sentiment: Required. Opinion level sentiment for the aspect in the sentence. Possible
     values include: "positive", "mixed", "negative".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1_preview_3.models.TokenSentimentValue
    :param confidence_scores: Required. Opinion level sentiment confidence scores for the aspect in
     the sentence.
    :type confidence_scores:
     ~azure.ai.textanalytics.v3_1_preview_3.models.AspectConfidenceScoreLabel
    :param offset: Required. The opinion offset from the start of the sentence.
    :type offset: int
    :param length: Required. The length of the opinion.
    :type length: int
    :param text: Required. The aspect text detected.
    :type text: str
    :param is_negated: Required. The indicator representing if the opinion is negated.
    :type is_negated: bool
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'is_negated': {'required': True},
    }

    _attribute_map = {
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'AspectConfidenceScoreLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'is_negated': {'key': 'isNegated', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "TokenSentimentValue"],
        confidence_scores: "AspectConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        is_negated: bool,
        **kwargs
    ):
        super(SentenceOpinion, self).__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.is_negated = is_negated


class SentenceSentiment(msrest.serialization.Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. The sentence text.
    :type text: str
    :param sentiment: Required. The predicted Sentiment for the sentence. Possible values include:
     "positive", "neutral", "negative".
    :type sentiment: str or ~azure.ai.textanalytics.v3_1_preview_3.models.SentenceSentimentValue
    :param confidence_scores: Required. The sentiment confidence score between 0 and 1 for the
     sentence for all classes.
    :type confidence_scores:
     ~azure.ai.textanalytics.v3_1_preview_3.models.SentimentConfidenceScorePerLabel
    :param offset: Required. The sentence offset from the start of the document.
    :type offset: int
    :param length: Required. The length of the sentence.
    :type length: int
    :param aspects: The array of aspect object for the sentence.
    :type aspects: list[~azure.ai.textanalytics.v3_1_preview_3.models.SentenceAspect]
    :param opinions: The array of opinion object for the sentence.
    :type opinions: list[~azure.ai.textanalytics.v3_1_preview_3.models.SentenceOpinion]
    """

    _validation = {
        'text': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'sentiment': {'key': 'sentiment', 'type': 'str'},
        'confidence_scores': {'key': 'confidenceScores', 'type': 'SentimentConfidenceScorePerLabel'},
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
        'aspects': {'key': 'aspects', 'type': '[SentenceAspect]'},
        'opinions': {'key': 'opinions', 'type': '[SentenceOpinion]'},
    }

    def __init__(
        self,
        *,
        text: str,
        sentiment: Union[str, "SentenceSentimentValue"],
        confidence_scores: "SentimentConfidenceScorePerLabel",
        offset: int,
        length: int,
        aspects: Optional[List["SentenceAspect"]] = None,
        opinions: Optional[List["SentenceOpinion"]] = None,
        **kwargs
    ):
        super(SentenceSentiment, self).__init__(**kwargs)
        self.text = text
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.aspects = aspects
        self.opinions = opinions


class SentimentConfidenceScorePerLabel(msrest.serialization.Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :param positive: Required.
    :type positive: float
    :param neutral: Required.
    :type neutral: float
    :param negative: Required.
    :type negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        'positive': {'key': 'positive', 'type': 'float'},
        'neutral': {'key': 'neutral', 'type': 'float'},
        'negative': {'key': 'negative', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        positive: float,
        neutral: float,
        negative: float,
        **kwargs
    ):
        super(SentimentConfidenceScorePerLabel, self).__init__(**kwargs)
        self.positive = positive
        self.neutral = neutral
        self.negative = negative


class SentimentResponse(msrest.serialization.Model):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :param documents: Required. Sentiment analysis per document.
    :type documents: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentSentiment]
    :param errors: Required. Errors by document id.
    :type errors: list[~azure.ai.textanalytics.v3_1_preview_3.models.DocumentError]
    :param statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :type statistics: ~azure.ai.textanalytics.v3_1_preview_3.models.RequestStatistics
    :param model_version: Required. This field indicates which model is used for scoring.
    :type model_version: str
    """

    _validation = {
        'documents': {'required': True},
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        'documents': {'key': 'documents', 'type': '[DocumentSentiment]'},
        'errors': {'key': 'errors', 'type': '[DocumentError]'},
        'statistics': {'key': 'statistics', 'type': 'RequestStatistics'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        documents: List["DocumentSentiment"],
        errors: List["DocumentError"],
        model_version: str,
        statistics: Optional["RequestStatistics"] = None,
        **kwargs
    ):
        super(SentimentResponse, self).__init__(**kwargs)
        self.documents = documents
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class TasksStateTasks(msrest.serialization.Model):
    """TasksStateTasks.

    All required parameters must be populated in order to send to Azure.

    :param details:
    :type details: ~azure.ai.textanalytics.v3_1_preview_3.models.TaskState
    :param completed: Required.
    :type completed: int
    :param failed: Required.
    :type failed: int
    :param in_progress: Required.
    :type in_progress: int
    :param total: Required.
    :type total: int
    :param entity_recognition_tasks:
    :type entity_recognition_tasks:
     list[~azure.ai.textanalytics.v3_1_preview_3.models.TasksStateTasksEntityRecognitionTasksItem]
    :param entity_recognition_pii_tasks:
    :type entity_recognition_pii_tasks:
     list[~azure.ai.textanalytics.v3_1_preview_3.models.TasksStateTasksEntityRecognitionPiiTasksItem]
    :param key_phrase_extraction_tasks:
    :type key_phrase_extraction_tasks:
     list[~azure.ai.textanalytics.v3_1_preview_3.models.TasksStateTasksKeyPhraseExtractionTasksItem]
    """

    _validation = {
        'completed': {'required': True},
        'failed': {'required': True},
        'in_progress': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        'details': {'key': 'details', 'type': 'TaskState'},
        'completed': {'key': 'completed', 'type': 'int'},
        'failed': {'key': 'failed', 'type': 'int'},
        'in_progress': {'key': 'inProgress', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
        'entity_recognition_tasks': {'key': 'entityRecognitionTasks', 'type': '[TasksStateTasksEntityRecognitionTasksItem]'},
        'entity_recognition_pii_tasks': {'key': 'entityRecognitionPiiTasks', 'type': '[TasksStateTasksEntityRecognitionPiiTasksItem]'},
        'key_phrase_extraction_tasks': {'key': 'keyPhraseExtractionTasks', 'type': '[TasksStateTasksKeyPhraseExtractionTasksItem]'},
    }

    def __init__(
        self,
        *,
        completed: int,
        failed: int,
        in_progress: int,
        total: int,
        details: Optional["TaskState"] = None,
        entity_recognition_tasks: Optional[List["TasksStateTasksEntityRecognitionTasksItem"]] = None,
        entity_recognition_pii_tasks: Optional[List["TasksStateTasksEntityRecognitionPiiTasksItem"]] = None,
        key_phrase_extraction_tasks: Optional[List["TasksStateTasksKeyPhraseExtractionTasksItem"]] = None,
        **kwargs
    ):
        super(TasksStateTasks, self).__init__(**kwargs)
        self.details = details
        self.completed = completed
        self.failed = failed
        self.in_progress = in_progress
        self.total = total
        self.entity_recognition_tasks = entity_recognition_tasks
        self.entity_recognition_pii_tasks = entity_recognition_pii_tasks
        self.key_phrase_extraction_tasks = key_phrase_extraction_tasks


class TaskState(msrest.serialization.Model):
    """TaskState.

    All required parameters must be populated in order to send to Azure.

    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param name:
    :type name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        name: Optional[str] = None,
        **kwargs
    ):
        super(TaskState, self).__init__(**kwargs)
        self.last_update_date_time = last_update_date_time
        self.name = name
        self.status = status


class TasksStateTasksDetails(TaskState):
    """TasksStateTasksDetails.

    All required parameters must be populated in order to send to Azure.

    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param name:
    :type name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        name: Optional[str] = None,
        **kwargs
    ):
        super(TasksStateTasksDetails, self).__init__(last_update_date_time=last_update_date_time, name=name, status=status, **kwargs)


class TasksStateTasksEntityRecognitionPiiTasksItem(TaskState, Components15X8E9LSchemasTasksstatePropertiesTasksPropertiesEntityrecognitionpiitasksItemsAllof1):
    """TasksStateTasksEntityRecognitionPiiTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results: Required.
    :type results: ~azure.ai.textanalytics.v3_1_preview_3.models.PiiResult
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param name:
    :type name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    """

    _validation = {
        'results': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'PiiResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        results: "PiiResult",
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        name: Optional[str] = None,
        **kwargs
    ):
        super(TasksStateTasksEntityRecognitionPiiTasksItem, self).__init__(last_update_date_time=last_update_date_time, name=name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.name = name
        self.status = status


class TasksStateTasksEntityRecognitionTasksItem(TaskState, Components15Gvwi3SchemasTasksstatePropertiesTasksPropertiesEntityrecognitiontasksItemsAllof1):
    """TasksStateTasksEntityRecognitionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results: Required.
    :type results: ~azure.ai.textanalytics.v3_1_preview_3.models.EntitiesResult
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param name:
    :type name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    """

    _validation = {
        'results': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'EntitiesResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        results: "EntitiesResult",
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        name: Optional[str] = None,
        **kwargs
    ):
        super(TasksStateTasksEntityRecognitionTasksItem, self).__init__(last_update_date_time=last_update_date_time, name=name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.name = name
        self.status = status


class TasksStateTasksKeyPhraseExtractionTasksItem(TaskState, Components1D9IzucSchemasTasksstatePropertiesTasksPropertiesKeyphraseextractiontasksItemsAllof1):
    """TasksStateTasksKeyPhraseExtractionTasksItem.

    All required parameters must be populated in order to send to Azure.

    :param results: Required.
    :type results: ~azure.ai.textanalytics.v3_1_preview_3.models.KeyPhraseResult
    :param last_update_date_time: Required.
    :type last_update_date_time: ~datetime.datetime
    :param name:
    :type name: str
    :param status: Required.  Possible values include: "notStarted", "running", "succeeded",
     "failed", "rejected", "cancelled", "cancelling", "partiallyCompleted".
    :type status: str or ~azure.ai.textanalytics.v3_1_preview_3.models.State
    """

    _validation = {
        'results': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': 'KeyPhraseResult'},
        'last_update_date_time': {'key': 'lastUpdateDateTime', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        results: "KeyPhraseResult",
        last_update_date_time: datetime.datetime,
        status: Union[str, "State"],
        name: Optional[str] = None,
        **kwargs
    ):
        super(TasksStateTasksKeyPhraseExtractionTasksItem, self).__init__(last_update_date_time=last_update_date_time, name=name, status=status, results=results, **kwargs)
        self.results = results
        self.last_update_date_time = last_update_date_time
        self.name = name
        self.status = status


class TextAnalyticsError(msrest.serialization.Model):
    """TextAnalyticsError.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include: "InvalidRequest",
     "InvalidArgument", "InternalServerError", "ServiceUnavailable", "NotFound".
    :type code: str or ~azure.ai.textanalytics.v3_1_preview_3.models.ErrorCodeValue
    :param message: Required. Error message.
    :type message: str
    :param target: Error target.
    :type target: str
    :param innererror: Inner error contains more specific information.
    :type innererror: ~azure.ai.textanalytics.v3_1_preview_3.models.InnerError
    :param details: Details about specific errors that led to this reported error.
    :type details: list[~azure.ai.textanalytics.v3_1_preview_3.models.TextAnalyticsError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'details': {'key': 'details', 'type': '[TextAnalyticsError]'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "ErrorCodeValue"],
        message: str,
        target: Optional[str] = None,
        innererror: Optional["InnerError"] = None,
        details: Optional[List["TextAnalyticsError"]] = None,
        **kwargs
    ):
        super(TextAnalyticsError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.innererror = innererror
        self.details = details


class TextAnalyticsWarning(msrest.serialization.Model):
    """TextAnalyticsWarning.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code. Possible values include: "LongWordsInDocument",
     "DocumentTruncated".
    :type code: str or ~azure.ai.textanalytics.v3_1_preview_3.models.WarningCodeValue
    :param message: Required. Warning message.
    :type message: str
    :param target_ref: A JSON pointer reference indicating the target object.
    :type target_ref: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target_ref': {'key': 'targetRef', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Union[str, "WarningCodeValue"],
        message: str,
        target_ref: Optional[str] = None,
        **kwargs
    ):
        super(TextAnalyticsWarning, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target_ref = target_ref
