# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, overload
from urllib.parse import parse_qs, urljoin, urlparse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._azure_app_configuration_operations import (
    build_check_key_value_request,
    build_check_key_values_request,
    build_check_keys_request,
    build_check_labels_request,
    build_check_revisions_request,
    build_delete_key_value_request,
    build_delete_lock_request,
    build_get_key_value_request,
    build_get_key_values_request,
    build_get_keys_request,
    build_get_labels_request,
    build_get_revisions_request,
    build_put_key_value_request,
    build_put_lock_request,
)
from .._vendor import MixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AzureAppConfigurationOperationsMixin(MixinABC):
    @distributed_trace
    def get_keys(
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Key"]:
        """Gets a list of keys.

        Gets a list of keys.

        :param name: A filter for the name of the returned keys. Default value is None.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Key or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.Key]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_keys_request(
                    name=name,
                    after=after,
                    accept_datetime=accept_datetime,
                    sync_token=self._config.sync_token,
                    api_version=api_version,
                    template_url=self.get_keys.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("KeyListResult", pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_keys.metadata = {"url": "/keys"}  # type: ignore

    @distributed_trace_async
    async def check_keys(  # pylint: disable=inconsistent-return-statements
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param name: A filter for the name of the returned keys. Default value is None.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_check_keys_request(
            name=name,
            after=after,
            accept_datetime=accept_datetime,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.check_keys.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_keys.metadata = {"url": "/keys"}  # type: ignore

    @distributed_trace
    def get_key_values(
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Get6ItemsItem"]]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.KeyValue"]:
        """Gets a list of key-values.

        Gets a list of key-values.

        :param key: A filter used to match keys. Default value is None.
        :type key: str
        :param label: A filter used to match labels. Default value is None.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Get6ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyValue or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.KeyValue]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyValueListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_key_values_request(
                    key=key,
                    label=label,
                    after=after,
                    accept_datetime=accept_datetime,
                    select=select,
                    sync_token=self._config.sync_token,
                    api_version=api_version,
                    template_url=self.get_key_values.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("KeyValueListResult", pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_key_values.metadata = {"url": "/kv"}  # type: ignore

    @distributed_trace_async
    async def check_key_values(  # pylint: disable=inconsistent-return-statements
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Head6ItemsItem"]]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param key: A filter used to match keys. Default value is None.
        :type key: str
        :param label: A filter used to match labels. Default value is None.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Head6ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_check_key_values_request(
            key=key,
            label=label,
            after=after,
            accept_datetime=accept_datetime,
            select=select,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.check_key_values.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_key_values.metadata = {"url": "/kv"}  # type: ignore

    @distributed_trace_async
    async def get_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Get7ItemsItem"]]] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Gets a single key-value.

        Gets a single key-value.

        :param key: The key of the key-value to retrieve. Required.
        :type key: str
        :param label: The label of the key-value to retrieve. Default value is None.
        :type label: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided. Default value is None.
        :type if_none_match: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Get7ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyValue]

        request = build_get_key_value_request(
            key=key,
            label=label,
            accept_datetime=accept_datetime,
            if_match=if_match,
            if_none_match=if_none_match,
            select=select,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.get_key_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("str", response.headers.get("Last-Modified"))

        deserialized = self._deserialize("KeyValue", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_key_value.metadata = {"url": "/kv/{key}"}  # type: ignore

    @overload
    async def put_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        entity: Optional[_models.KeyValue] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyValue:
        """Creates a key-value.

        Creates a key-value.

        :param key: The key of the key-value to create. Required.
        :type key: str
        :param label: The label of the key-value to create. Default value is None.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided. Default value is None.
        :type if_none_match: str
        :param entity: The key-value to create. Default value is None.
        :type entity: ~azure.appconfiguration.models.KeyValue
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def put_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        entity: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyValue:
        """Creates a key-value.

        Creates a key-value.

        :param key: The key of the key-value to create. Required.
        :type key: str
        :param label: The label of the key-value to create. Default value is None.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided. Default value is None.
        :type if_none_match: str
        :param entity: The key-value to create. Default value is None.
        :type entity: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'application/json-patch+json',
         'application/vnd.microsoft.appconfig.kv+json',
         'application/vnd.microsoft.appconfig.kvset+json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def put_key_value(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        entity: Optional[Union[_models.KeyValue, IO]] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Creates a key-value.

        Creates a key-value.

        :param key: The key of the key-value to create. Required.
        :type key: str
        :param label: The label of the key-value to create. Default value is None.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided. Default value is None.
        :type if_none_match: str
        :param entity: The key-value to create. Is either a model type or a IO type. Default value is
         None.
        :type entity: ~azure.appconfiguration.models.KeyValue or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'application/json-patch+json',
         'application/vnd.microsoft.appconfig.kv+json',
         'application/vnd.microsoft.appconfig.kvset+json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyValue]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(entity, (IO, bytes)):
            _content = entity
        else:
            if entity is not None:
                _json = self._serialize.body(entity, "KeyValue")
            else:
                _json = None

        request = build_put_key_value_request(
            key=key,
            label=label,
            if_match=if_match,
            if_none_match=if_none_match,
            sync_token=self._config.sync_token,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.put_key_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("KeyValue", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    put_key_value.metadata = {"url": "/kv/{key}"}  # type: ignore

    @distributed_trace_async
    async def delete_key_value(
        self, key: str, label: Optional[str] = None, if_match: Optional[str] = None, **kwargs: Any
    ) -> Optional[_models.KeyValue]:
        """Deletes a key-value.

        Deletes a key-value.

        :param key: The key of the key-value to delete. Required.
        :type key: str
        :param label: The label of the key-value to delete. Default value is None.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue or None or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.KeyValue]]

        request = build_delete_key_value_request(
            key=key,
            label=label,
            if_match=if_match,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.delete_key_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

            deserialized = self._deserialize("KeyValue", pipeline_response)

        if response.status_code == 204:
            response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    delete_key_value.metadata = {"url": "/kv/{key}"}  # type: ignore

    @distributed_trace_async
    async def check_key_value(  # pylint: disable=inconsistent-return-statements
        self,
        key: str,
        label: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Head7ItemsItem"]]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param key: The key of the key-value to retrieve. Required.
        :type key: str
        :param label: The label of the key-value to retrieve. Default value is None.
        :type label: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided. Default value is None.
        :type if_none_match: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Head7ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_check_key_value_request(
            key=key,
            label=label,
            accept_datetime=accept_datetime,
            if_match=if_match,
            if_none_match=if_none_match,
            select=select,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.check_key_value.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("str", response.headers.get("Last-Modified"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_key_value.metadata = {"url": "/kv/{key}"}  # type: ignore

    @distributed_trace
    def get_labels(
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Get5ItemsItem"]]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Label"]:
        """Gets a list of labels.

        Gets a list of labels.

        :param name: A filter for the name of the returned labels. Default value is None.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Get5ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Label or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.Label]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.LabelListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_labels_request(
                    name=name,
                    after=after,
                    accept_datetime=accept_datetime,
                    select=select,
                    sync_token=self._config.sync_token,
                    api_version=api_version,
                    template_url=self.get_labels.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LabelListResult", pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_labels.metadata = {"url": "/labels"}  # type: ignore

    @distributed_trace_async
    async def check_labels(  # pylint: disable=inconsistent-return-statements
        self,
        name: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Head5ItemsItem"]]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param name: A filter for the name of the returned labels. Default value is None.
        :type name: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Head5ItemsItem]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_check_labels_request(
            name=name,
            after=after,
            accept_datetime=accept_datetime,
            select=select,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.check_labels.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_labels.metadata = {"url": "/labels"}  # type: ignore

    @distributed_trace_async
    async def put_lock(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Locks a key-value.

        Locks a key-value.

        :param key: The key of the key-value to lock. Required.
        :type key: str
        :param label: The label, if any, of the key-value to lock. Default value is None.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided. Default value is None.
        :type if_none_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyValue]

        request = build_put_lock_request(
            key=key,
            label=label,
            if_match=if_match,
            if_none_match=if_none_match,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.put_lock.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("KeyValue", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    put_lock.metadata = {"url": "/locks/{key}"}  # type: ignore

    @distributed_trace_async
    async def delete_lock(
        self,
        key: str,
        label: Optional[str] = None,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.KeyValue:
        """Unlocks a key-value.

        Unlocks a key-value.

        :param key: The key of the key-value to unlock. Required.
        :type key: str
        :param label: The label, if any, of the key-value to unlock. Default value is None.
        :type label: str
        :param if_match: Used to perform an operation only if the targeted resource's etag matches the
         value provided. Default value is None.
        :type if_match: str
        :param if_none_match: Used to perform an operation only if the targeted resource's etag does
         not match the value provided. Default value is None.
        :type if_none_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyValue or the result of cls(response)
        :rtype: ~azure.appconfiguration.models.KeyValue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyValue]

        request = build_delete_lock_request(
            key=key,
            label=label,
            if_match=if_match,
            if_none_match=if_none_match,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.delete_lock.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("KeyValue", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    delete_lock.metadata = {"url": "/locks/{key}"}  # type: ignore

    @distributed_trace
    def get_revisions(
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Enum6"]]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.KeyValue"]:
        """Gets a list of key-value revisions.

        Gets a list of key-value revisions.

        :param key: A filter used to match keys. Default value is None.
        :type key: str
        :param label: A filter used to match labels. Default value is None.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Enum6]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyValue or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.appconfiguration.models.KeyValue]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.KeyValueListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_revisions_request(
                    key=key,
                    label=label,
                    after=after,
                    accept_datetime=accept_datetime,
                    select=select,
                    sync_token=self._config.sync_token,
                    api_version=api_version,
                    template_url=self.get_revisions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("KeyValueListResult", pipeline_response)
            list_of_elem = deserialized.items
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_revisions.metadata = {"url": "/revisions"}  # type: ignore

    @distributed_trace_async
    async def check_revisions(  # pylint: disable=inconsistent-return-statements
        self,
        key: Optional[str] = None,
        label: Optional[str] = None,
        after: Optional[str] = None,
        accept_datetime: Optional[str] = None,
        select: Optional[List[Union[str, "_models.Enum7"]]] = None,
        **kwargs: Any
    ) -> None:
        """Requests the headers and status of the given resource.

        Requests the headers and status of the given resource.

        :param key: A filter used to match keys. Default value is None.
        :type key: str
        :param label: A filter used to match labels. Default value is None.
        :type label: str
        :param after: Instructs the server to return elements that appear after the element referred to
         by the specified token. Default value is None.
        :type after: str
        :param accept_datetime: Requests the server to respond with the state of the resource at the
         specified time. Default value is None.
        :type accept_datetime: str
        :param select: Used to select what fields are present in the returned resource(s). Default
         value is None.
        :type select: list[str or ~azure.appconfiguration.models.Enum7]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_check_revisions_request(
            key=key,
            label=label,
            after=after,
            accept_datetime=accept_datetime,
            select=select,
            sync_token=self._config.sync_token,
            api_version=api_version,
            template_url=self.check_revisions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Sync-Token"] = self._deserialize("str", response.headers.get("Sync-Token"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    check_revisions.metadata = {"url": "/revisions"}  # type: ignore
