# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class FunctionProperties(_serialization.Model):
    """The properties that are associated with a function.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AggregateFunctionProperties, ScalarFunctionProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of function. Required.
    :vartype type: str
    :ivar etag: The current entity tag for the function. This is an opaque string. You can use it
     to detect whether the resource has changed between requests. You can also use it in the
     If-Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar inputs:
    :vartype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
    :ivar output: Describes the output of a function.
    :vartype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
    :ivar binding: The physical binding of the function. For example, in the Azure Machine Learning
     web service’s case, this describes the endpoint.
    :vartype binding: ~azure.mgmt.streamanalytics.models.FunctionBinding
    """

    _validation = {
        "type": {"required": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "inputs": {"key": "properties.inputs", "type": "[FunctionInput]"},
        "output": {"key": "properties.output", "type": "FunctionOutput"},
        "binding": {"key": "properties.binding", "type": "FunctionBinding"},
    }

    _subtype_map = {"type": {"Aggregate": "AggregateFunctionProperties", "Scalar": "ScalarFunctionProperties"}}

    def __init__(
        self,
        *,
        inputs: Optional[List["_models.FunctionInput"]] = None,
        output: Optional["_models.FunctionOutput"] = None,
        binding: Optional["_models.FunctionBinding"] = None,
        **kwargs
    ):
        """
        :keyword inputs:
        :paramtype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
        :keyword output: Describes the output of a function.
        :paramtype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
        :keyword binding: The physical binding of the function. For example, in the Azure Machine
         Learning web service’s case, this describes the endpoint.
        :paramtype binding: ~azure.mgmt.streamanalytics.models.FunctionBinding
        """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.etag = None
        self.inputs = inputs
        self.output = output
        self.binding = binding


class AggregateFunctionProperties(FunctionProperties):
    """The properties that are associated with an aggregate function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of function. Required.
    :vartype type: str
    :ivar etag: The current entity tag for the function. This is an opaque string. You can use it
     to detect whether the resource has changed between requests. You can also use it in the
     If-Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar inputs:
    :vartype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
    :ivar output: Describes the output of a function.
    :vartype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
    :ivar binding: The physical binding of the function. For example, in the Azure Machine Learning
     web service’s case, this describes the endpoint.
    :vartype binding: ~azure.mgmt.streamanalytics.models.FunctionBinding
    """

    _validation = {
        "type": {"required": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "inputs": {"key": "properties.inputs", "type": "[FunctionInput]"},
        "output": {"key": "properties.output", "type": "FunctionOutput"},
        "binding": {"key": "properties.binding", "type": "FunctionBinding"},
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["_models.FunctionInput"]] = None,
        output: Optional["_models.FunctionOutput"] = None,
        binding: Optional["_models.FunctionBinding"] = None,
        **kwargs
    ):
        """
        :keyword inputs:
        :paramtype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
        :keyword output: Describes the output of a function.
        :paramtype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
        :keyword binding: The physical binding of the function. For example, in the Azure Machine
         Learning web service’s case, this describes the endpoint.
        :paramtype binding: ~azure.mgmt.streamanalytics.models.FunctionBinding
        """
        super().__init__(inputs=inputs, output=output, binding=binding, **kwargs)
        self.type = "Aggregate"  # type: str


class Serialization(_serialization.Model):
    """Describes how data from an input is serialized or how data is serialized when written to an output.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AvroSerialization, CsvSerialization, CustomClrSerialization, JsonSerialization,
    ParquetSerialization

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of serialization that the input or output uses. Required on PUT
     (CreateOrReplace) requests. Required. Known values are: "Csv", "Avro", "Json", "CustomClr", and
     "Parquet".
    :vartype type: str or ~azure.mgmt.streamanalytics.models.EventSerializationType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "Avro": "AvroSerialization",
            "Csv": "CsvSerialization",
            "CustomClr": "CustomClrSerialization",
            "Json": "JsonSerialization",
            "Parquet": "ParquetSerialization",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AvroSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in Avro format.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of serialization that the input or output uses. Required on PUT
     (CreateOrReplace) requests. Required. Known values are: "Csv", "Avro", "Json", "CustomClr", and
     "Parquet".
    :vartype type: str or ~azure.mgmt.streamanalytics.models.EventSerializationType
    :ivar properties: The properties that are associated with the Avro serialization type. Required
     on PUT (CreateOrReplace) requests.
    :vartype properties: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(self, *, properties: Optional[JSON] = None, **kwargs):
        """
        :keyword properties: The properties that are associated with the Avro serialization type.
         Required on PUT (CreateOrReplace) requests.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.type = "Avro"  # type: str
        self.properties = properties


class OutputDataSource(_serialization.Model):
    """Describes the data source that output will be written to.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GatewayMessageBusOutputDataSource, AzureFunctionOutputDataSource, PostgreSQLOutputDataSource,
    AzureDataLakeStoreOutputDataSource, EventHubV2OutputDataSource, EventHubOutputDataSource,
    ServiceBusQueueOutputDataSource, ServiceBusTopicOutputDataSource, AzureSynapseOutputDataSource,
    AzureSqlDatabaseOutputDataSource, BlobOutputDataSource, DocumentDbOutputDataSource,
    AzureTableOutputDataSource, PowerBIOutputDataSource, RawOutputDatasource

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "GatewayMessageBus": "GatewayMessageBusOutputDataSource",
            "Microsoft.AzureFunction": "AzureFunctionOutputDataSource",
            "Microsoft.DBForPostgreSQL/servers/databases": "PostgreSQLOutputDataSource",
            "Microsoft.DataLake/Accounts": "AzureDataLakeStoreOutputDataSource",
            "Microsoft.EventHub/EventHub": "EventHubV2OutputDataSource",
            "Microsoft.ServiceBus/EventHub": "EventHubOutputDataSource",
            "Microsoft.ServiceBus/Queue": "ServiceBusQueueOutputDataSource",
            "Microsoft.ServiceBus/Topic": "ServiceBusTopicOutputDataSource",
            "Microsoft.Sql/Server/DataWarehouse": "AzureSynapseOutputDataSource",
            "Microsoft.Sql/Server/Database": "AzureSqlDatabaseOutputDataSource",
            "Microsoft.Storage/Blob": "BlobOutputDataSource",
            "Microsoft.Storage/DocumentDB": "DocumentDbOutputDataSource",
            "Microsoft.Storage/Table": "AzureTableOutputDataSource",
            "PowerBI": "PowerBIOutputDataSource",
            "Raw": "RawOutputDatasource",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureDataLakeStoreOutputDataSource(OutputDataSource):
    """Describes an Azure Data Lake Store output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :vartype refresh_token: str
    :ivar token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :vartype token_user_principal_name: str
    :ivar token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :vartype token_user_display_name: str
    :ivar account_name: The name of the Azure Data Lake Store account. Required on PUT
     (CreateOrReplace) requests.
    :vartype account_name: str
    :ivar tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT
     (CreateOrReplace) requests.
    :vartype tenant_id: str
    :ivar file_path_prefix: The location of the file to which the output should be written to.
     Required on PUT (CreateOrReplace) requests.
    :vartype file_path_prefix: str
    :ivar date_format: The date format. Wherever {date} appears in filePathPrefix, the value of
     this property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in filePathPrefix, the value of
     this property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "refresh_token": {"key": "properties.refreshToken", "type": "str"},
        "token_user_principal_name": {"key": "properties.tokenUserPrincipalName", "type": "str"},
        "token_user_display_name": {"key": "properties.tokenUserDisplayName", "type": "str"},
        "account_name": {"key": "properties.accountName", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "file_path_prefix": {"key": "properties.filePathPrefix", "type": "str"},
        "date_format": {"key": "properties.dateFormat", "type": "str"},
        "time_format": {"key": "properties.timeFormat", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        account_name: Optional[str] = None,
        tenant_id: Optional[str] = None,
        file_path_prefix: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword refresh_token: A refresh token that can be used to obtain a valid access token that
         can then be used to authenticate with the data source. A valid refresh token is currently only
         obtainable via the Azure Portal. It is recommended to put a dummy string value here when
         creating the data source and then going to the Azure Portal to authenticate the data source
         which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
         requests.
        :paramtype refresh_token: str
        :keyword token_user_principal_name: The user principal name (UPN) of the user that was used to
         obtain the refresh token. Use this property to help remember which user was used to obtain the
         refresh token.
        :paramtype token_user_principal_name: str
        :keyword token_user_display_name: The user display name of the user that was used to obtain the
         refresh token. Use this property to help remember which user was used to obtain the refresh
         token.
        :paramtype token_user_display_name: str
        :keyword account_name: The name of the Azure Data Lake Store account. Required on PUT
         (CreateOrReplace) requests.
        :paramtype account_name: str
        :keyword tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT
         (CreateOrReplace) requests.
        :paramtype tenant_id: str
        :keyword file_path_prefix: The location of the file to which the output should be written to.
         Required on PUT (CreateOrReplace) requests.
        :paramtype file_path_prefix: str
        :keyword date_format: The date format. Wherever {date} appears in filePathPrefix, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in filePathPrefix, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.DataLake/Accounts"  # type: str
        self.refresh_token = refresh_token
        self.token_user_principal_name = token_user_principal_name
        self.token_user_display_name = token_user_display_name
        self.account_name = account_name
        self.tenant_id = tenant_id
        self.file_path_prefix = file_path_prefix
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode


class OAuthBasedDataSourceProperties(_serialization.Model):
    """The properties that are associated with data sources that use OAuth as their authentication model.

    :ivar refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :vartype refresh_token: str
    :ivar token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :vartype token_user_principal_name: str
    :ivar token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :vartype token_user_display_name: str
    """

    _attribute_map = {
        "refresh_token": {"key": "refreshToken", "type": "str"},
        "token_user_principal_name": {"key": "tokenUserPrincipalName", "type": "str"},
        "token_user_display_name": {"key": "tokenUserDisplayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword refresh_token: A refresh token that can be used to obtain a valid access token that
         can then be used to authenticate with the data source. A valid refresh token is currently only
         obtainable via the Azure Portal. It is recommended to put a dummy string value here when
         creating the data source and then going to the Azure Portal to authenticate the data source
         which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
         requests.
        :paramtype refresh_token: str
        :keyword token_user_principal_name: The user principal name (UPN) of the user that was used to
         obtain the refresh token. Use this property to help remember which user was used to obtain the
         refresh token.
        :paramtype token_user_principal_name: str
        :keyword token_user_display_name: The user display name of the user that was used to obtain the
         refresh token. Use this property to help remember which user was used to obtain the refresh
         token.
        :paramtype token_user_display_name: str
        """
        super().__init__(**kwargs)
        self.refresh_token = refresh_token
        self.token_user_principal_name = token_user_principal_name
        self.token_user_display_name = token_user_display_name


class AzureDataLakeStoreOutputDataSourceProperties(OAuthBasedDataSourceProperties):
    """The properties that are associated with an Azure Data Lake Store.

    :ivar refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :vartype refresh_token: str
    :ivar token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :vartype token_user_principal_name: str
    :ivar token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :vartype token_user_display_name: str
    :ivar account_name: The name of the Azure Data Lake Store account. Required on PUT
     (CreateOrReplace) requests.
    :vartype account_name: str
    :ivar tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT
     (CreateOrReplace) requests.
    :vartype tenant_id: str
    :ivar file_path_prefix: The location of the file to which the output should be written to.
     Required on PUT (CreateOrReplace) requests.
    :vartype file_path_prefix: str
    :ivar date_format: The date format. Wherever {date} appears in filePathPrefix, the value of
     this property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in filePathPrefix, the value of
     this property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "refresh_token": {"key": "refreshToken", "type": "str"},
        "token_user_principal_name": {"key": "tokenUserPrincipalName", "type": "str"},
        "token_user_display_name": {"key": "tokenUserDisplayName", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "file_path_prefix": {"key": "filePathPrefix", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "str"},
        "time_format": {"key": "timeFormat", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        account_name: Optional[str] = None,
        tenant_id: Optional[str] = None,
        file_path_prefix: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword refresh_token: A refresh token that can be used to obtain a valid access token that
         can then be used to authenticate with the data source. A valid refresh token is currently only
         obtainable via the Azure Portal. It is recommended to put a dummy string value here when
         creating the data source and then going to the Azure Portal to authenticate the data source
         which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
         requests.
        :paramtype refresh_token: str
        :keyword token_user_principal_name: The user principal name (UPN) of the user that was used to
         obtain the refresh token. Use this property to help remember which user was used to obtain the
         refresh token.
        :paramtype token_user_principal_name: str
        :keyword token_user_display_name: The user display name of the user that was used to obtain the
         refresh token. Use this property to help remember which user was used to obtain the refresh
         token.
        :paramtype token_user_display_name: str
        :keyword account_name: The name of the Azure Data Lake Store account. Required on PUT
         (CreateOrReplace) requests.
        :paramtype account_name: str
        :keyword tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT
         (CreateOrReplace) requests.
        :paramtype tenant_id: str
        :keyword file_path_prefix: The location of the file to which the output should be written to.
         Required on PUT (CreateOrReplace) requests.
        :paramtype file_path_prefix: str
        :keyword date_format: The date format. Wherever {date} appears in filePathPrefix, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in filePathPrefix, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(
            refresh_token=refresh_token,
            token_user_principal_name=token_user_principal_name,
            token_user_display_name=token_user_display_name,
            **kwargs
        )
        self.account_name = account_name
        self.tenant_id = tenant_id
        self.file_path_prefix = file_path_prefix
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode


class AzureFunctionOutputDataSource(OutputDataSource):
    """Defines the metadata of AzureFunctionOutputDataSource.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar function_app_name: The name of your Azure Functions app.
    :vartype function_app_name: str
    :ivar function_name: The name of the function in your Azure Functions app.
    :vartype function_name: str
    :ivar api_key: If you want to use an Azure Function from another subscription, you can do so by
     providing the key to access your function.
    :vartype api_key: str
    :ivar max_batch_size: A property that lets you set the maximum size for each output batch
     that's sent to your Azure function. The input unit is in bytes. By default, this value is
     262,144 bytes (256 KB).
    :vartype max_batch_size: float
    :ivar max_batch_count: A property that lets you specify the maximum number of events in each
     batch that's sent to Azure Functions. The default value is 100.
    :vartype max_batch_count: float
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "function_app_name": {"key": "properties.functionAppName", "type": "str"},
        "function_name": {"key": "properties.functionName", "type": "str"},
        "api_key": {"key": "properties.apiKey", "type": "str"},
        "max_batch_size": {"key": "properties.maxBatchSize", "type": "float"},
        "max_batch_count": {"key": "properties.maxBatchCount", "type": "float"},
    }

    def __init__(
        self,
        *,
        function_app_name: Optional[str] = None,
        function_name: Optional[str] = None,
        api_key: Optional[str] = None,
        max_batch_size: Optional[float] = None,
        max_batch_count: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword function_app_name: The name of your Azure Functions app.
        :paramtype function_app_name: str
        :keyword function_name: The name of the function in your Azure Functions app.
        :paramtype function_name: str
        :keyword api_key: If you want to use an Azure Function from another subscription, you can do so
         by providing the key to access your function.
        :paramtype api_key: str
        :keyword max_batch_size: A property that lets you set the maximum size for each output batch
         that's sent to your Azure function. The input unit is in bytes. By default, this value is
         262,144 bytes (256 KB).
        :paramtype max_batch_size: float
        :keyword max_batch_count: A property that lets you specify the maximum number of events in each
         batch that's sent to Azure Functions. The default value is 100.
        :paramtype max_batch_count: float
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.AzureFunction"  # type: str
        self.function_app_name = function_app_name
        self.function_name = function_name
        self.api_key = api_key
        self.max_batch_size = max_batch_size
        self.max_batch_count = max_batch_count


class FunctionBinding(_serialization.Model):
    """The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureMachineLearningStudioFunctionBinding, AzureMachineLearningServiceFunctionBinding,
    CSharpFunctionBinding, JavaScriptFunctionBinding

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the function binding type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "Microsoft.MachineLearning/WebService": "AzureMachineLearningStudioFunctionBinding",
            "Microsoft.MachineLearningServices": "AzureMachineLearningServiceFunctionBinding",
            "Microsoft.StreamAnalytics/CLRUdf": "CSharpFunctionBinding",
            "Microsoft.StreamAnalytics/JavascriptUdf": "JavaScriptFunctionBinding",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureMachineLearningServiceFunctionBinding(FunctionBinding):
    """The binding to an Azure Machine Learning web service.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the function binding type. Required.
    :vartype type: str
    :ivar endpoint: The Request-Response execute endpoint of the Azure Machine Learning web
     service.
    :vartype endpoint: str
    :ivar api_key: The API key used to authenticate with Request-Response endpoint.
    :vartype api_key: str
    :ivar inputs: The inputs for the Azure Machine Learning web service endpoint.
    :vartype inputs:
     list[~azure.mgmt.streamanalytics.models.AzureMachineLearningServiceInputColumn]
    :ivar outputs: A list of outputs from the Azure Machine Learning web service endpoint
     execution.
    :vartype outputs:
     list[~azure.mgmt.streamanalytics.models.AzureMachineLearningServiceOutputColumn]
    :ivar batch_size: Number between 1 and 10000 describing maximum number of rows for every Azure
     ML RRS execute request. Default is 1000.
    :vartype batch_size: int
    :ivar number_of_parallel_requests: The number of parallel requests that will be sent per
     partition of your job to the machine learning service. Default is 1.
    :vartype number_of_parallel_requests: int
    :ivar input_request_name: Label for the input request object.
    :vartype input_request_name: str
    :ivar output_response_name: Label for the output request object.
    :vartype output_response_name: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "api_key": {"key": "properties.apiKey", "type": "str"},
        "inputs": {"key": "properties.inputs", "type": "[AzureMachineLearningServiceInputColumn]"},
        "outputs": {"key": "properties.outputs", "type": "[AzureMachineLearningServiceOutputColumn]"},
        "batch_size": {"key": "properties.batchSize", "type": "int"},
        "number_of_parallel_requests": {"key": "properties.numberOfParallelRequests", "type": "int"},
        "input_request_name": {"key": "properties.inputRequestName", "type": "str"},
        "output_response_name": {"key": "properties.outputResponseName", "type": "str"},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        api_key: Optional[str] = None,
        inputs: Optional[List["_models.AzureMachineLearningServiceInputColumn"]] = None,
        outputs: Optional[List["_models.AzureMachineLearningServiceOutputColumn"]] = None,
        batch_size: Optional[int] = None,
        number_of_parallel_requests: Optional[int] = None,
        input_request_name: Optional[str] = None,
        output_response_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword endpoint: The Request-Response execute endpoint of the Azure Machine Learning web
         service.
        :paramtype endpoint: str
        :keyword api_key: The API key used to authenticate with Request-Response endpoint.
        :paramtype api_key: str
        :keyword inputs: The inputs for the Azure Machine Learning web service endpoint.
        :paramtype inputs:
         list[~azure.mgmt.streamanalytics.models.AzureMachineLearningServiceInputColumn]
        :keyword outputs: A list of outputs from the Azure Machine Learning web service endpoint
         execution.
        :paramtype outputs:
         list[~azure.mgmt.streamanalytics.models.AzureMachineLearningServiceOutputColumn]
        :keyword batch_size: Number between 1 and 10000 describing maximum number of rows for every
         Azure ML RRS execute request. Default is 1000.
        :paramtype batch_size: int
        :keyword number_of_parallel_requests: The number of parallel requests that will be sent per
         partition of your job to the machine learning service. Default is 1.
        :paramtype number_of_parallel_requests: int
        :keyword input_request_name: Label for the input request object.
        :paramtype input_request_name: str
        :keyword output_response_name: Label for the output request object.
        :paramtype output_response_name: str
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.MachineLearningServices"  # type: str
        self.endpoint = endpoint
        self.api_key = api_key
        self.inputs = inputs
        self.outputs = outputs
        self.batch_size = batch_size
        self.number_of_parallel_requests = number_of_parallel_requests
        self.input_request_name = input_request_name
        self.output_response_name = output_response_name


class FunctionRetrieveDefaultDefinitionParameters(_serialization.Model):
    """Parameters used to specify the type of function to retrieve the default definition for.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters,
    AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters,
    CSharpFunctionRetrieveDefaultDefinitionParameters,
    JavaScriptFunctionRetrieveDefaultDefinitionParameters

    All required parameters must be populated in order to send to Azure.

    :ivar binding_type: Indicates the function binding type. Required.
    :vartype binding_type: str
    """

    _validation = {
        "binding_type": {"required": True},
    }

    _attribute_map = {
        "binding_type": {"key": "bindingType", "type": "str"},
    }

    _subtype_map = {
        "binding_type": {
            "Microsoft.MachineLearning/WebService": "AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters",
            "Microsoft.MachineLearningServices": "AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters",
            "Microsoft.StreamAnalytics/CLRUdf": "CSharpFunctionRetrieveDefaultDefinitionParameters",
            "Microsoft.StreamAnalytics/JavascriptUdf": "JavaScriptFunctionRetrieveDefaultDefinitionParameters",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.binding_type = None  # type: Optional[str]


class AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters(
    FunctionRetrieveDefaultDefinitionParameters
):
    """The parameters needed to retrieve the default function definition for an Azure Machine Learning web service function.

    All required parameters must be populated in order to send to Azure.

    :ivar binding_type: Indicates the function binding type. Required.
    :vartype binding_type: str
    :ivar execute_endpoint: The Request-Response execute endpoint of the Azure Machine Learning web
     service.
    :vartype execute_endpoint: str
    :ivar udf_type: The function type. Default value is "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        "binding_type": {"required": True},
    }

    _attribute_map = {
        "binding_type": {"key": "bindingType", "type": "str"},
        "execute_endpoint": {"key": "bindingRetrievalProperties.executeEndpoint", "type": "str"},
        "udf_type": {"key": "bindingRetrievalProperties.udfType", "type": "str"},
    }

    def __init__(
        self, *, execute_endpoint: Optional[str] = None, udf_type: Optional[Literal["Scalar"]] = None, **kwargs
    ):
        """
        :keyword execute_endpoint: The Request-Response execute endpoint of the Azure Machine Learning
         web service.
        :paramtype execute_endpoint: str
        :keyword udf_type: The function type. Default value is "Scalar".
        :paramtype udf_type: str
        """
        super().__init__(**kwargs)
        self.binding_type = "Microsoft.MachineLearningServices"  # type: str
        self.execute_endpoint = execute_endpoint
        self.udf_type = udf_type


class AzureMachineLearningServiceInputColumn(_serialization.Model):
    """Describes an input column for the Azure Machine Learning web service endpoint.

    :ivar name: The name of the input column.
    :vartype name: str
    :ivar data_type: The (Azure Machine Learning supported) data type of the input column.
    :vartype data_type: str
    :ivar map_to: The zero based index of the function parameter this input maps to.
    :vartype map_to: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "map_to": {"key": "mapTo", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, data_type: Optional[str] = None, map_to: Optional[int] = None, **kwargs
    ):
        """
        :keyword name: The name of the input column.
        :paramtype name: str
        :keyword data_type: The (Azure Machine Learning supported) data type of the input column.
        :paramtype data_type: str
        :keyword map_to: The zero based index of the function parameter this input maps to.
        :paramtype map_to: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.data_type = data_type
        self.map_to = map_to


class AzureMachineLearningServiceInputs(_serialization.Model):
    """The inputs for the Azure Machine Learning web service endpoint.

    :ivar name: The name of the input. This is the name provided while authoring the endpoint.
    :vartype name: str
    :ivar column_names: A list of input columns for the Azure Machine Learning web service
     endpoint.
    :vartype column_names:
     list[~azure.mgmt.streamanalytics.models.AzureMachineLearningServiceInputColumn]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "column_names": {"key": "columnNames", "type": "[AzureMachineLearningServiceInputColumn]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        column_names: Optional[List["_models.AzureMachineLearningServiceInputColumn"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the input. This is the name provided while authoring the endpoint.
        :paramtype name: str
        :keyword column_names: A list of input columns for the Azure Machine Learning web service
         endpoint.
        :paramtype column_names:
         list[~azure.mgmt.streamanalytics.models.AzureMachineLearningServiceInputColumn]
        """
        super().__init__(**kwargs)
        self.name = name
        self.column_names = column_names


class AzureMachineLearningServiceOutputColumn(_serialization.Model):
    """Describes an output column for the Azure Machine Learning web service endpoint.

    :ivar name: The name of the output column.
    :vartype name: str
    :ivar data_type: The (Azure Machine Learning supported) data type of the output column.
    :vartype data_type: str
    :ivar map_to: The zero based index of the function parameter this input maps to.
    :vartype map_to: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "map_to": {"key": "mapTo", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, data_type: Optional[str] = None, map_to: Optional[int] = None, **kwargs
    ):
        """
        :keyword name: The name of the output column.
        :paramtype name: str
        :keyword data_type: The (Azure Machine Learning supported) data type of the output column.
        :paramtype data_type: str
        :keyword map_to: The zero based index of the function parameter this input maps to.
        :paramtype map_to: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.data_type = data_type
        self.map_to = map_to


class AzureMachineLearningStudioFunctionBinding(FunctionBinding):
    """The binding to an Azure Machine Learning Studio.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the function binding type. Required.
    :vartype type: str
    :ivar endpoint: The Request-Response execute endpoint of the Azure Machine Learning Studio.
     Find out more here:
     https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs.
    :vartype endpoint: str
    :ivar api_key: The API key used to authenticate with Request-Response endpoint.
    :vartype api_key: str
    :ivar inputs: The inputs for the Azure Machine Learning Studio endpoint.
    :vartype inputs: ~azure.mgmt.streamanalytics.models.AzureMachineLearningStudioInputs
    :ivar outputs: A list of outputs from the Azure Machine Learning Studio endpoint execution.
    :vartype outputs:
     list[~azure.mgmt.streamanalytics.models.AzureMachineLearningStudioOutputColumn]
    :ivar batch_size: Number between 1 and 10000 describing maximum number of rows for every Azure
     ML RRS execute request. Default is 1000.
    :vartype batch_size: int
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "api_key": {"key": "properties.apiKey", "type": "str"},
        "inputs": {"key": "properties.inputs", "type": "AzureMachineLearningStudioInputs"},
        "outputs": {"key": "properties.outputs", "type": "[AzureMachineLearningStudioOutputColumn]"},
        "batch_size": {"key": "properties.batchSize", "type": "int"},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        api_key: Optional[str] = None,
        inputs: Optional["_models.AzureMachineLearningStudioInputs"] = None,
        outputs: Optional[List["_models.AzureMachineLearningStudioOutputColumn"]] = None,
        batch_size: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword endpoint: The Request-Response execute endpoint of the Azure Machine Learning Studio.
         Find out more here:
         https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs.
        :paramtype endpoint: str
        :keyword api_key: The API key used to authenticate with Request-Response endpoint.
        :paramtype api_key: str
        :keyword inputs: The inputs for the Azure Machine Learning Studio endpoint.
        :paramtype inputs: ~azure.mgmt.streamanalytics.models.AzureMachineLearningStudioInputs
        :keyword outputs: A list of outputs from the Azure Machine Learning Studio endpoint execution.
        :paramtype outputs:
         list[~azure.mgmt.streamanalytics.models.AzureMachineLearningStudioOutputColumn]
        :keyword batch_size: Number between 1 and 10000 describing maximum number of rows for every
         Azure ML RRS execute request. Default is 1000.
        :paramtype batch_size: int
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.MachineLearning/WebService"  # type: str
        self.endpoint = endpoint
        self.api_key = api_key
        self.inputs = inputs
        self.outputs = outputs
        self.batch_size = batch_size


class AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters(
    FunctionRetrieveDefaultDefinitionParameters
):
    """The parameters needed to retrieve the default function definition for an Azure Machine Learning Studio function.

    All required parameters must be populated in order to send to Azure.

    :ivar binding_type: Indicates the function binding type. Required.
    :vartype binding_type: str
    :ivar execute_endpoint: The Request-Response execute endpoint of the Azure Machine Learning
     Studio. Find out more here:
     https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs.
    :vartype execute_endpoint: str
    :ivar udf_type: The function type. Default value is "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        "binding_type": {"required": True},
    }

    _attribute_map = {
        "binding_type": {"key": "bindingType", "type": "str"},
        "execute_endpoint": {"key": "bindingRetrievalProperties.executeEndpoint", "type": "str"},
        "udf_type": {"key": "bindingRetrievalProperties.udfType", "type": "str"},
    }

    def __init__(
        self, *, execute_endpoint: Optional[str] = None, udf_type: Optional[Literal["Scalar"]] = None, **kwargs
    ):
        """
        :keyword execute_endpoint: The Request-Response execute endpoint of the Azure Machine Learning
         Studio. Find out more here:
         https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs.
        :paramtype execute_endpoint: str
        :keyword udf_type: The function type. Default value is "Scalar".
        :paramtype udf_type: str
        """
        super().__init__(**kwargs)
        self.binding_type = "Microsoft.MachineLearning/WebService"  # type: str
        self.execute_endpoint = execute_endpoint
        self.udf_type = udf_type


class AzureMachineLearningStudioInputColumn(_serialization.Model):
    """Describes an input column for the Azure Machine Learning Studio endpoint.

    :ivar name: The name of the input column.
    :vartype name: str
    :ivar data_type: The (Azure Machine Learning supported) data type of the input column. A list
     of valid  Azure Machine Learning data types are described at
     https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
    :vartype data_type: str
    :ivar map_to: The zero based index of the function parameter this input maps to.
    :vartype map_to: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "map_to": {"key": "mapTo", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, data_type: Optional[str] = None, map_to: Optional[int] = None, **kwargs
    ):
        """
        :keyword name: The name of the input column.
        :paramtype name: str
        :keyword data_type: The (Azure Machine Learning supported) data type of the input column. A
         list of valid  Azure Machine Learning data types are described at
         https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        :paramtype data_type: str
        :keyword map_to: The zero based index of the function parameter this input maps to.
        :paramtype map_to: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.data_type = data_type
        self.map_to = map_to


class AzureMachineLearningStudioInputs(_serialization.Model):
    """The inputs for the Azure Machine Learning Studio endpoint.

    :ivar name: The name of the input. This is the name provided while authoring the endpoint.
    :vartype name: str
    :ivar column_names: A list of input columns for the Azure Machine Learning Studio endpoint.
    :vartype column_names:
     list[~azure.mgmt.streamanalytics.models.AzureMachineLearningStudioInputColumn]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "column_names": {"key": "columnNames", "type": "[AzureMachineLearningStudioInputColumn]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        column_names: Optional[List["_models.AzureMachineLearningStudioInputColumn"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the input. This is the name provided while authoring the endpoint.
        :paramtype name: str
        :keyword column_names: A list of input columns for the Azure Machine Learning Studio endpoint.
        :paramtype column_names:
         list[~azure.mgmt.streamanalytics.models.AzureMachineLearningStudioInputColumn]
        """
        super().__init__(**kwargs)
        self.name = name
        self.column_names = column_names


class AzureMachineLearningStudioOutputColumn(_serialization.Model):
    """Describes an output column for the Azure Machine Learning Studio endpoint.

    :ivar name: The name of the output column.
    :vartype name: str
    :ivar data_type: The (Azure Machine Learning supported) data type of the output column. A list
     of valid  Azure Machine Learning data types are described at
     https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
    :vartype data_type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, data_type: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the output column.
        :paramtype name: str
        :keyword data_type: The (Azure Machine Learning supported) data type of the output column. A
         list of valid  Azure Machine Learning data types are described at
         https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        :paramtype data_type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.data_type = data_type


class AzureSqlDatabaseDataSourceProperties(_serialization.Model):
    """The properties that are associated with an Azure SQL database data source.

    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar max_batch_count: Max Batch count for write to Sql database, the default value is 10,000.
     Optional on PUT requests.
    :vartype max_batch_count: float
    :ivar max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on query
     partition) are available. Optional on PUT requests.
    :vartype max_writer_count: float
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "user": {"key": "user", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "max_batch_count": {"key": "maxBatchCount", "type": "float"},
        "max_writer_count": {"key": "maxWriterCount", "type": "float"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        table: Optional[str] = None,
        max_batch_count: Optional[float] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword max_batch_count: Max Batch count for write to Sql database, the default value is
         10,000. Optional on PUT requests.
        :paramtype max_batch_count: float
        :keyword max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on
         query partition) are available. Optional on PUT requests.
        :paramtype max_writer_count: float
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.server = server
        self.database = database
        self.user = user
        self.password = password
        self.table = table
        self.max_batch_count = max_batch_count
        self.max_writer_count = max_writer_count
        self.authentication_mode = authentication_mode


class AzureSqlDatabaseOutputDataSource(OutputDataSource):
    """Describes an Azure SQL database output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar max_batch_count: Max Batch count for write to Sql database, the default value is 10,000.
     Optional on PUT requests.
    :vartype max_batch_count: float
    :ivar max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on query
     partition) are available. Optional on PUT requests.
    :vartype max_writer_count: float
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "server": {"key": "properties.server", "type": "str"},
        "database": {"key": "properties.database", "type": "str"},
        "user": {"key": "properties.user", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "table": {"key": "properties.table", "type": "str"},
        "max_batch_count": {"key": "properties.maxBatchCount", "type": "float"},
        "max_writer_count": {"key": "properties.maxWriterCount", "type": "float"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        table: Optional[str] = None,
        max_batch_count: Optional[float] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword max_batch_count: Max Batch count for write to Sql database, the default value is
         10,000. Optional on PUT requests.
        :paramtype max_batch_count: float
        :keyword max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on
         query partition) are available. Optional on PUT requests.
        :paramtype max_writer_count: float
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Sql/Server/Database"  # type: str
        self.server = server
        self.database = database
        self.user = user
        self.password = password
        self.table = table
        self.max_batch_count = max_batch_count
        self.max_writer_count = max_writer_count
        self.authentication_mode = authentication_mode


class AzureSqlDatabaseOutputDataSourceProperties(AzureSqlDatabaseDataSourceProperties):
    """The properties that are associated with an Azure SQL database output.

    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar max_batch_count: Max Batch count for write to Sql database, the default value is 10,000.
     Optional on PUT requests.
    :vartype max_batch_count: float
    :ivar max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on query
     partition) are available. Optional on PUT requests.
    :vartype max_writer_count: float
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "user": {"key": "user", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "max_batch_count": {"key": "maxBatchCount", "type": "float"},
        "max_writer_count": {"key": "maxWriterCount", "type": "float"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        table: Optional[str] = None,
        max_batch_count: Optional[float] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword max_batch_count: Max Batch count for write to Sql database, the default value is
         10,000. Optional on PUT requests.
        :paramtype max_batch_count: float
        :keyword max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on
         query partition) are available. Optional on PUT requests.
        :paramtype max_writer_count: float
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(
            server=server,
            database=database,
            user=user,
            password=password,
            table=table,
            max_batch_count=max_batch_count,
            max_writer_count=max_writer_count,
            authentication_mode=authentication_mode,
            **kwargs
        )


class ReferenceInputDataSource(_serialization.Model):
    """Describes an input data source that contains reference data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FileReferenceInputDataSource, AzureSqlReferenceInputDataSource, BlobReferenceInputDataSource,
    RawReferenceInputDataSource

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing reference data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "File": "FileReferenceInputDataSource",
            "Microsoft.Sql/Server/Database": "AzureSqlReferenceInputDataSource",
            "Microsoft.Storage/Blob": "BlobReferenceInputDataSource",
            "Raw": "RawReferenceInputDataSource",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureSqlReferenceInputDataSource(ReferenceInputDataSource):
    """Describes an Azure SQL database reference input data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing reference data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar server: This element is associated with the datasource element. This is the name of the
     server that contains the database that will be written to.
    :vartype server: str
    :ivar database: This element is associated with the datasource element. This is the name of the
     database that output will be written to.
    :vartype database: str
    :ivar user: This element is associated with the datasource element. This is the user name that
     will be used to connect to the SQL Database instance.
    :vartype user: str
    :ivar password: This element is associated with the datasource element. This is the password
     that will be used to connect to the SQL Database instance.
    :vartype password: str
    :ivar refresh_type: Indicates the type of data refresh option. Known values are: "Static",
     "RefreshPeriodicallyWithFull", and "RefreshPeriodicallyWithDelta".
    :vartype refresh_type: str or ~azure.mgmt.streamanalytics.models.RefreshType
    :ivar refresh_rate: This element is associated with the datasource element. This indicates how
     frequently the data will be fetched from the database. It is of DateTime format.
    :vartype refresh_rate: str
    :ivar full_snapshot_query: This element is associated with the datasource element. This query
     is used to fetch data from the sql database.
    :vartype full_snapshot_query: str
    :ivar delta_snapshot_query: This element is associated with the datasource element. This query
     is used to fetch incremental changes from the SQL database. To use this option, we recommend
     using temporal tables in Azure SQL Database.
    :vartype delta_snapshot_query: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "server": {"key": "properties.server", "type": "str"},
        "database": {"key": "properties.database", "type": "str"},
        "user": {"key": "properties.user", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "refresh_type": {"key": "properties.refreshType", "type": "str"},
        "refresh_rate": {"key": "properties.refreshRate", "type": "str"},
        "full_snapshot_query": {"key": "properties.fullSnapshotQuery", "type": "str"},
        "delta_snapshot_query": {"key": "properties.deltaSnapshotQuery", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        refresh_type: Optional[Union[str, "_models.RefreshType"]] = None,
        refresh_rate: Optional[str] = None,
        full_snapshot_query: Optional[str] = None,
        delta_snapshot_query: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: This element is associated with the datasource element. This is the name of
         the server that contains the database that will be written to.
        :paramtype server: str
        :keyword database: This element is associated with the datasource element. This is the name of
         the database that output will be written to.
        :paramtype database: str
        :keyword user: This element is associated with the datasource element. This is the user name
         that will be used to connect to the SQL Database instance.
        :paramtype user: str
        :keyword password: This element is associated with the datasource element. This is the password
         that will be used to connect to the SQL Database instance.
        :paramtype password: str
        :keyword refresh_type: Indicates the type of data refresh option. Known values are: "Static",
         "RefreshPeriodicallyWithFull", and "RefreshPeriodicallyWithDelta".
        :paramtype refresh_type: str or ~azure.mgmt.streamanalytics.models.RefreshType
        :keyword refresh_rate: This element is associated with the datasource element. This indicates
         how frequently the data will be fetched from the database. It is of DateTime format.
        :paramtype refresh_rate: str
        :keyword full_snapshot_query: This element is associated with the datasource element. This
         query is used to fetch data from the sql database.
        :paramtype full_snapshot_query: str
        :keyword delta_snapshot_query: This element is associated with the datasource element. This
         query is used to fetch incremental changes from the SQL database. To use this option, we
         recommend using temporal tables in Azure SQL Database.
        :paramtype delta_snapshot_query: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Sql/Server/Database"  # type: str
        self.server = server
        self.database = database
        self.user = user
        self.password = password
        self.refresh_type = refresh_type
        self.refresh_rate = refresh_rate
        self.full_snapshot_query = full_snapshot_query
        self.delta_snapshot_query = delta_snapshot_query
        self.authentication_mode = authentication_mode


class AzureSynapseDataSourceProperties(_serialization.Model):
    """The properties that are associated with an Azure SQL database data source.

    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "user": {"key": "user", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.server = server
        self.database = database
        self.table = table
        self.user = user
        self.password = password
        self.authentication_mode = authentication_mode


class AzureSynapseOutputDataSource(OutputDataSource):
    """Describes an Azure Synapse output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "server": {"key": "properties.server", "type": "str"},
        "database": {"key": "properties.database", "type": "str"},
        "table": {"key": "properties.table", "type": "str"},
        "user": {"key": "properties.user", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Sql/Server/DataWarehouse"  # type: str
        self.server = server
        self.database = database
        self.table = table
        self.user = user
        self.password = password
        self.authentication_mode = authentication_mode


class AzureSynapseOutputDataSourceProperties(AzureSynapseDataSourceProperties):
    """The properties that are associated with an Azure Synapse output.

    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "user": {"key": "user", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(
            server=server,
            database=database,
            table=table,
            user=user,
            password=password,
            authentication_mode=authentication_mode,
            **kwargs
        )


class AzureTableOutputDataSource(OutputDataSource):
    """Describes an Azure Table output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
     requests.
    :vartype account_name: str
    :ivar account_key: The account key for the Azure Storage account. Required on PUT
     (CreateOrReplace) requests.
    :vartype account_key: str
    :ivar table: The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
    :vartype table: str
    :ivar partition_key: This element indicates the name of a column from the SELECT statement in
     the query that will be used as the partition key for the Azure Table. Required on PUT
     (CreateOrReplace) requests.
    :vartype partition_key: str
    :ivar row_key: This element indicates the name of a column from the SELECT statement in the
     query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace)
     requests.
    :vartype row_key: str
    :ivar columns_to_remove: If specified, each item in the array is the name of a column to remove
     (if present) from output event entities.
    :vartype columns_to_remove: list[str]
    :ivar batch_size: The number of rows to write to the Azure Table at a time.
    :vartype batch_size: int
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "account_name": {"key": "properties.accountName", "type": "str"},
        "account_key": {"key": "properties.accountKey", "type": "str"},
        "table": {"key": "properties.table", "type": "str"},
        "partition_key": {"key": "properties.partitionKey", "type": "str"},
        "row_key": {"key": "properties.rowKey", "type": "str"},
        "columns_to_remove": {"key": "properties.columnsToRemove", "type": "[str]"},
        "batch_size": {"key": "properties.batchSize", "type": "int"},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        table: Optional[str] = None,
        partition_key: Optional[str] = None,
        row_key: Optional[str] = None,
        columns_to_remove: Optional[List[str]] = None,
        batch_size: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
         requests.
        :paramtype account_name: str
        :keyword account_key: The account key for the Azure Storage account. Required on PUT
         (CreateOrReplace) requests.
        :paramtype account_key: str
        :keyword table: The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
        :paramtype table: str
        :keyword partition_key: This element indicates the name of a column from the SELECT statement
         in the query that will be used as the partition key for the Azure Table. Required on PUT
         (CreateOrReplace) requests.
        :paramtype partition_key: str
        :keyword row_key: This element indicates the name of a column from the SELECT statement in the
         query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace)
         requests.
        :paramtype row_key: str
        :keyword columns_to_remove: If specified, each item in the array is the name of a column to
         remove (if present) from output event entities.
        :paramtype columns_to_remove: list[str]
        :keyword batch_size: The number of rows to write to the Azure Table at a time.
        :paramtype batch_size: int
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Storage/Table"  # type: str
        self.account_name = account_name
        self.account_key = account_key
        self.table = table
        self.partition_key = partition_key
        self.row_key = row_key
        self.columns_to_remove = columns_to_remove
        self.batch_size = batch_size


class BlobDataSourceProperties(_serialization.Model):
    """The properties that are associated with a blob data source.

    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :vartype container: str
    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "storage_accounts": {"key": "storageAccounts", "type": "[StorageAccount]"},
        "container": {"key": "container", "type": "str"},
        "path_pattern": {"key": "pathPattern", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "str"},
        "time_format": {"key": "timeFormat", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword container: The name of a container within the associated Storage account. This
         container contains either the blob(s) to be read from or written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype container: str
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode


class BlobOutputDataSource(OutputDataSource):
    """Describes a blob output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :vartype container: str
    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar blob_path_prefix: Blob path prefix.
    :vartype blob_path_prefix: str
    :ivar blob_write_mode: Blob write mode. Known values are: "Append" and "Once".
    :vartype blob_write_mode: str or ~azure.mgmt.streamanalytics.models.BlobWriteMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[StorageAccount]"},
        "container": {"key": "properties.container", "type": "str"},
        "path_pattern": {"key": "properties.pathPattern", "type": "str"},
        "date_format": {"key": "properties.dateFormat", "type": "str"},
        "time_format": {"key": "properties.timeFormat", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "blob_path_prefix": {"key": "properties.blobPathPrefix", "type": "str"},
        "blob_write_mode": {"key": "properties.blobWriteMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        blob_path_prefix: Optional[str] = None,
        blob_write_mode: Optional[Union[str, "_models.BlobWriteMode"]] = None,
        **kwargs
    ):
        """
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword container: The name of a container within the associated Storage account. This
         container contains either the blob(s) to be read from or written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype container: str
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword blob_path_prefix: Blob path prefix.
        :paramtype blob_path_prefix: str
        :keyword blob_write_mode: Blob write mode. Known values are: "Append" and "Once".
        :paramtype blob_write_mode: str or ~azure.mgmt.streamanalytics.models.BlobWriteMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Storage/Blob"  # type: str
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode
        self.blob_path_prefix = blob_path_prefix
        self.blob_write_mode = blob_write_mode


class BlobOutputDataSourceProperties(BlobDataSourceProperties):
    """The properties that are associated with a blob output.

    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :vartype container: str
    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar blob_path_prefix: Blob path prefix.
    :vartype blob_path_prefix: str
    :ivar blob_write_mode: Blob write mode. Known values are: "Append" and "Once".
    :vartype blob_write_mode: str or ~azure.mgmt.streamanalytics.models.BlobWriteMode
    """

    _attribute_map = {
        "storage_accounts": {"key": "storageAccounts", "type": "[StorageAccount]"},
        "container": {"key": "container", "type": "str"},
        "path_pattern": {"key": "pathPattern", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "str"},
        "time_format": {"key": "timeFormat", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "blob_path_prefix": {"key": "blobPathPrefix", "type": "str"},
        "blob_write_mode": {"key": "blobWriteMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        blob_path_prefix: Optional[str] = None,
        blob_write_mode: Optional[Union[str, "_models.BlobWriteMode"]] = None,
        **kwargs
    ):
        """
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword container: The name of a container within the associated Storage account. This
         container contains either the blob(s) to be read from or written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype container: str
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword blob_path_prefix: Blob path prefix.
        :paramtype blob_path_prefix: str
        :keyword blob_write_mode: Blob write mode. Known values are: "Append" and "Once".
        :paramtype blob_write_mode: str or ~azure.mgmt.streamanalytics.models.BlobWriteMode
        """
        super().__init__(
            storage_accounts=storage_accounts,
            container=container,
            path_pattern=path_pattern,
            date_format=date_format,
            time_format=time_format,
            authentication_mode=authentication_mode,
            **kwargs
        )
        self.blob_path_prefix = blob_path_prefix
        self.blob_write_mode = blob_write_mode


class BlobReferenceInputDataSource(ReferenceInputDataSource):  # pylint: disable=too-many-instance-attributes
    """Describes a blob input data source that contains reference data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing reference data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :vartype container: str
    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar blob_name: The name of the blob input.
    :vartype blob_name: str
    :ivar delta_path_pattern: The path pattern of the delta snapshot.
    :vartype delta_path_pattern: str
    :ivar source_partition_count: The partition count of the blob input data source. Range 1 - 256.
    :vartype source_partition_count: int
    :ivar full_snapshot_refresh_rate: The refresh interval of the blob input data source.
    :vartype full_snapshot_refresh_rate: str
    :ivar delta_snapshot_refresh_rate: The interval that the user generates a delta snapshot of
     this reference blob input data source.
    :vartype delta_snapshot_refresh_rate: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[StorageAccount]"},
        "container": {"key": "properties.container", "type": "str"},
        "path_pattern": {"key": "properties.pathPattern", "type": "str"},
        "date_format": {"key": "properties.dateFormat", "type": "str"},
        "time_format": {"key": "properties.timeFormat", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "blob_name": {"key": "properties.blobName", "type": "str"},
        "delta_path_pattern": {"key": "properties.deltaPathPattern", "type": "str"},
        "source_partition_count": {"key": "properties.sourcePartitionCount", "type": "int"},
        "full_snapshot_refresh_rate": {"key": "properties.fullSnapshotRefreshRate", "type": "str"},
        "delta_snapshot_refresh_rate": {"key": "properties.deltaSnapshotRefreshRate", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        blob_name: Optional[str] = None,
        delta_path_pattern: Optional[str] = None,
        source_partition_count: Optional[int] = None,
        full_snapshot_refresh_rate: Optional[str] = None,
        delta_snapshot_refresh_rate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword container: The name of a container within the associated Storage account. This
         container contains either the blob(s) to be read from or written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype container: str
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword blob_name: The name of the blob input.
        :paramtype blob_name: str
        :keyword delta_path_pattern: The path pattern of the delta snapshot.
        :paramtype delta_path_pattern: str
        :keyword source_partition_count: The partition count of the blob input data source. Range 1 -
         256.
        :paramtype source_partition_count: int
        :keyword full_snapshot_refresh_rate: The refresh interval of the blob input data source.
        :paramtype full_snapshot_refresh_rate: str
        :keyword delta_snapshot_refresh_rate: The interval that the user generates a delta snapshot of
         this reference blob input data source.
        :paramtype delta_snapshot_refresh_rate: str
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Storage/Blob"  # type: str
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode
        self.blob_name = blob_name
        self.delta_path_pattern = delta_path_pattern
        self.source_partition_count = source_partition_count
        self.full_snapshot_refresh_rate = full_snapshot_refresh_rate
        self.delta_snapshot_refresh_rate = delta_snapshot_refresh_rate


class BlobReferenceInputDataSourceProperties(BlobDataSourceProperties):  # pylint: disable=too-many-instance-attributes
    """The properties that are associated with a blob input containing reference data.

    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :vartype container: str
    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar blob_name: The name of the blob input.
    :vartype blob_name: str
    :ivar delta_path_pattern: The path pattern of the delta snapshot.
    :vartype delta_path_pattern: str
    :ivar source_partition_count: The partition count of the blob input data source. Range 1 - 256.
    :vartype source_partition_count: int
    :ivar full_snapshot_refresh_rate: The refresh interval of the blob input data source.
    :vartype full_snapshot_refresh_rate: str
    :ivar delta_snapshot_refresh_rate: The interval that the user generates a delta snapshot of
     this reference blob input data source.
    :vartype delta_snapshot_refresh_rate: str
    """

    _attribute_map = {
        "storage_accounts": {"key": "storageAccounts", "type": "[StorageAccount]"},
        "container": {"key": "container", "type": "str"},
        "path_pattern": {"key": "pathPattern", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "str"},
        "time_format": {"key": "timeFormat", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "blob_name": {"key": "blobName", "type": "str"},
        "delta_path_pattern": {"key": "deltaPathPattern", "type": "str"},
        "source_partition_count": {"key": "sourcePartitionCount", "type": "int"},
        "full_snapshot_refresh_rate": {"key": "fullSnapshotRefreshRate", "type": "str"},
        "delta_snapshot_refresh_rate": {"key": "deltaSnapshotRefreshRate", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        blob_name: Optional[str] = None,
        delta_path_pattern: Optional[str] = None,
        source_partition_count: Optional[int] = None,
        full_snapshot_refresh_rate: Optional[str] = None,
        delta_snapshot_refresh_rate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword container: The name of a container within the associated Storage account. This
         container contains either the blob(s) to be read from or written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype container: str
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword blob_name: The name of the blob input.
        :paramtype blob_name: str
        :keyword delta_path_pattern: The path pattern of the delta snapshot.
        :paramtype delta_path_pattern: str
        :keyword source_partition_count: The partition count of the blob input data source. Range 1 -
         256.
        :paramtype source_partition_count: int
        :keyword full_snapshot_refresh_rate: The refresh interval of the blob input data source.
        :paramtype full_snapshot_refresh_rate: str
        :keyword delta_snapshot_refresh_rate: The interval that the user generates a delta snapshot of
         this reference blob input data source.
        :paramtype delta_snapshot_refresh_rate: str
        """
        super().__init__(
            storage_accounts=storage_accounts,
            container=container,
            path_pattern=path_pattern,
            date_format=date_format,
            time_format=time_format,
            authentication_mode=authentication_mode,
            **kwargs
        )
        self.blob_name = blob_name
        self.delta_path_pattern = delta_path_pattern
        self.source_partition_count = source_partition_count
        self.full_snapshot_refresh_rate = full_snapshot_refresh_rate
        self.delta_snapshot_refresh_rate = delta_snapshot_refresh_rate


class StreamInputDataSource(_serialization.Model):
    """Describes an input data source that contains stream data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GatewayMessageBusStreamInputDataSource, IoTHubStreamInputDataSource,
    EventGridStreamInputDataSource, EventHubV2StreamInputDataSource, EventHubStreamInputDataSource,
    BlobStreamInputDataSource, RawStreamInputDataSource

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "GatewayMessageBus": "GatewayMessageBusStreamInputDataSource",
            "Microsoft.Devices/IotHubs": "IoTHubStreamInputDataSource",
            "Microsoft.EventGrid/EventSubscriptions": "EventGridStreamInputDataSource",
            "Microsoft.EventHub/EventHub": "EventHubV2StreamInputDataSource",
            "Microsoft.ServiceBus/EventHub": "EventHubStreamInputDataSource",
            "Microsoft.Storage/Blob": "BlobStreamInputDataSource",
            "Raw": "RawStreamInputDataSource",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class BlobStreamInputDataSource(StreamInputDataSource):
    """Describes a blob input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :vartype container: str
    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar source_partition_count: The partition count of the blob input data source. Range 1 -
     1024.
    :vartype source_partition_count: int
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[StorageAccount]"},
        "container": {"key": "properties.container", "type": "str"},
        "path_pattern": {"key": "properties.pathPattern", "type": "str"},
        "date_format": {"key": "properties.dateFormat", "type": "str"},
        "time_format": {"key": "properties.timeFormat", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "source_partition_count": {"key": "properties.sourcePartitionCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        source_partition_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword container: The name of a container within the associated Storage account. This
         container contains either the blob(s) to be read from or written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype container: str
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword source_partition_count: The partition count of the blob input data source. Range 1 -
         1024.
        :paramtype source_partition_count: int
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Storage/Blob"  # type: str
        self.storage_accounts = storage_accounts
        self.container = container
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format
        self.authentication_mode = authentication_mode
        self.source_partition_count = source_partition_count


class BlobStreamInputDataSourceProperties(BlobDataSourceProperties):
    """The properties that are associated with a blob input containing stream data.

    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar container: The name of a container within the associated Storage account. This container
     contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace)
     requests.
    :vartype container: str
    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar source_partition_count: The partition count of the blob input data source. Range 1 -
     1024.
    :vartype source_partition_count: int
    """

    _attribute_map = {
        "storage_accounts": {"key": "storageAccounts", "type": "[StorageAccount]"},
        "container": {"key": "container", "type": "str"},
        "path_pattern": {"key": "pathPattern", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "str"},
        "time_format": {"key": "timeFormat", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "source_partition_count": {"key": "sourcePartitionCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        container: Optional[str] = None,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        source_partition_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword container: The name of a container within the associated Storage account. This
         container contains either the blob(s) to be read from or written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype container: str
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword source_partition_count: The partition count of the blob input data source. Range 1 -
         1024.
        :paramtype source_partition_count: int
        """
        super().__init__(
            storage_accounts=storage_accounts,
            container=container,
            path_pattern=path_pattern,
            date_format=date_format,
            time_format=time_format,
            authentication_mode=authentication_mode,
            **kwargs
        )
        self.source_partition_count = source_partition_count


class Resource(_serialization.Model):
    """The base resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, location: Optional[str] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):
    """A Stream Analytics Cluster object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar sku: The SKU of the cluster. This determines the size/capacity of the cluster. Required
     on PUT (CreateOrUpdate) requests.
    :vartype sku: ~azure.mgmt.streamanalytics.models.ClusterSku
    :ivar etag: The current entity tag for the cluster. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar properties: The properties associated with a Stream Analytics cluster.
    :vartype properties: ~azure.mgmt.streamanalytics.models.ClusterProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "ClusterSku"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "ClusterProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        sku: Optional["_models.ClusterSku"] = None,
        properties: Optional["_models.ClusterProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword sku: The SKU of the cluster. This determines the size/capacity of the cluster.
         Required on PUT (CreateOrUpdate) requests.
        :paramtype sku: ~azure.mgmt.streamanalytics.models.ClusterSku
        :keyword properties: The properties associated with a Stream Analytics cluster.
        :paramtype properties: ~azure.mgmt.streamanalytics.models.ClusterProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.etag = None
        self.properties = properties


class ClusterInfo(_serialization.Model):
    """The properties associated with a Stream Analytics cluster.

    :ivar id: The resource id of cluster.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource id of cluster.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ClusterJob(_serialization.Model):
    """A streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the streaming job.
    :vartype id: str
    :ivar streaming_units: The number of streaming units that are used by the streaming job.
    :vartype streaming_units: int
    :ivar job_state: The current execution state of the streaming job. Known values are: "Created",
     "Starting", "Running", "Stopping", "Stopped", "Deleting", "Failed", "Degraded", "Restarting",
     and "Scaling".
    :vartype job_state: str or ~azure.mgmt.streamanalytics.models.JobState
    """

    _validation = {
        "id": {"readonly": True},
        "streaming_units": {"readonly": True},
        "job_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "streaming_units": {"key": "streamingUnits", "type": "int"},
        "job_state": {"key": "jobState", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.streaming_units = None
        self.job_state = None


class ClusterJobListResult(_serialization.Model):
    """A list of streaming jobs. Populated by a List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of streaming jobs.
    :vartype value: list[~azure.mgmt.streamanalytics.models.ClusterJob]
    :ivar next_link: The URL to fetch the next set of streaming jobs.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClusterListResult(_serialization.Model):
    """A list of clusters populated by a 'list' operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of clusters.
    :vartype value: list[~azure.mgmt.streamanalytics.models.Cluster]
    :ivar next_link: The URL to fetch the next set of clusters.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Cluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClusterProperties(_serialization.Model):
    """The properties associated with a Stream Analytics cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_date: The date this cluster was created.
    :vartype created_date: ~datetime.datetime
    :ivar cluster_id: Unique identifier for the cluster.
    :vartype cluster_id: str
    :ivar provisioning_state: The status of the cluster provisioning. The three terminal states
     are: Succeeded, Failed and Canceled. Known values are: "Succeeded", "Failed", "Canceled", and
     "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.streamanalytics.models.ClusterProvisioningState
    :ivar capacity_allocated: Represents the number of streaming units currently being used on the
     cluster.
    :vartype capacity_allocated: int
    :ivar capacity_assigned: Represents the sum of the SUs of all streaming jobs associated with
     the cluster. If all of the jobs were running, this would be the capacity allocated.
    :vartype capacity_assigned: int
    """

    _validation = {
        "created_date": {"readonly": True},
        "cluster_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "capacity_allocated": {"readonly": True},
        "capacity_assigned": {"readonly": True},
    }

    _attribute_map = {
        "created_date": {"key": "createdDate", "type": "iso-8601"},
        "cluster_id": {"key": "clusterId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "capacity_allocated": {"key": "capacityAllocated", "type": "int"},
        "capacity_assigned": {"key": "capacityAssigned", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.created_date = None
        self.cluster_id = None
        self.provisioning_state = None
        self.capacity_allocated = None
        self.capacity_assigned = None


class ClusterSku(_serialization.Model):
    """The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.

    :ivar name: Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
     "Default"
    :vartype name: str or ~azure.mgmt.streamanalytics.models.ClusterSkuName
    :ivar capacity: Denotes the number of streaming units the cluster can support. Valid values for
     this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required
     on PUT (CreateOrUpdate) requests.
    :vartype capacity: int
    """

    _validation = {
        "capacity": {"maximum": 396, "minimum": 36},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.ClusterSkuName"]] = None, capacity: Optional[int] = None, **kwargs
    ):
        """
        :keyword name: Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate)
         requests. "Default"
        :paramtype name: str or ~azure.mgmt.streamanalytics.models.ClusterSkuName
        :keyword capacity: Denotes the number of streaming units the cluster can support. Valid values
         for this property are multiples of 36 with a minimum value of 36 and maximum value of 216.
         Required on PUT (CreateOrUpdate) requests.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class CompileQuery(_serialization.Model):
    """The query compilation object which defines the input, output, and transformation for the query compilation.

    All required parameters must be populated in order to send to Azure.

    :ivar query: The query to compile. Required.
    :vartype query: str
    :ivar inputs: The inputs for the query compilation.
    :vartype inputs: list[~azure.mgmt.streamanalytics.models.QueryInput]
    :ivar functions: The functions for the query compilation.
    :vartype functions: list[~azure.mgmt.streamanalytics.models.QueryFunction]
    :ivar job_type: Describes the type of the job. Valid values are ``Cloud`` and 'Edge'. Required.
     Known values are: "Cloud" and "Edge".
    :vartype job_type: str or ~azure.mgmt.streamanalytics.models.JobType
    :ivar compatibility_level: The query to compile. Known values are: "1.0" and "1.2".
    :vartype compatibility_level: str or ~azure.mgmt.streamanalytics.models.CompatibilityLevel
    """

    _validation = {
        "query": {"required": True},
        "job_type": {"required": True},
    }

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "inputs": {"key": "inputs", "type": "[QueryInput]"},
        "functions": {"key": "functions", "type": "[QueryFunction]"},
        "job_type": {"key": "jobType", "type": "str"},
        "compatibility_level": {"key": "compatibilityLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        query: str,
        job_type: Union[str, "_models.JobType"],
        inputs: Optional[List["_models.QueryInput"]] = None,
        functions: Optional[List["_models.QueryFunction"]] = None,
        compatibility_level: Optional[Union[str, "_models.CompatibilityLevel"]] = None,
        **kwargs
    ):
        """
        :keyword query: The query to compile. Required.
        :paramtype query: str
        :keyword inputs: The inputs for the query compilation.
        :paramtype inputs: list[~azure.mgmt.streamanalytics.models.QueryInput]
        :keyword functions: The functions for the query compilation.
        :paramtype functions: list[~azure.mgmt.streamanalytics.models.QueryFunction]
        :keyword job_type: Describes the type of the job. Valid values are ``Cloud`` and 'Edge'.
         Required. Known values are: "Cloud" and "Edge".
        :paramtype job_type: str or ~azure.mgmt.streamanalytics.models.JobType
        :keyword compatibility_level: The query to compile. Known values are: "1.0" and "1.2".
        :paramtype compatibility_level: str or ~azure.mgmt.streamanalytics.models.CompatibilityLevel
        """
        super().__init__(**kwargs)
        self.query = query
        self.inputs = inputs
        self.functions = functions
        self.job_type = job_type
        self.compatibility_level = compatibility_level


class Compression(_serialization.Model):
    """Describes how input data is compressed.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of compression that the input uses. Required on PUT
     (CreateOrReplace) requests. Known values are: "None", "GZip", and "Deflate".
    :vartype type: str or ~azure.mgmt.streamanalytics.models.CompressionType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.CompressionType"] = "None", **kwargs):
        """
        :keyword type: Indicates the type of compression that the input uses. Required on PUT
         (CreateOrReplace) requests. Known values are: "None", "GZip", and "Deflate".
        :paramtype type: str or ~azure.mgmt.streamanalytics.models.CompressionType
        """
        super().__init__(**kwargs)
        self.type = type


class CSharpFunctionBinding(FunctionBinding):
    """The binding to a CSharp function.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the function binding type. Required.
    :vartype type: str
    :ivar dll_path: The Csharp code containing a single function definition.
    :vartype dll_path: str
    :ivar class_property: The Csharp code containing a single function definition.
    :vartype class_property: str
    :ivar method: The Csharp code containing a single function definition.
    :vartype method: str
    :ivar update_mode: Refresh modes for Stream Analytics functions. Known values are: "Static" and
     "Refreshable".
    :vartype update_mode: str or ~azure.mgmt.streamanalytics.models.UpdateMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "dll_path": {"key": "properties.dllPath", "type": "str"},
        "class_property": {"key": "properties.class", "type": "str"},
        "method": {"key": "properties.method", "type": "str"},
        "update_mode": {"key": "properties.updateMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        dll_path: Optional[str] = None,
        class_property: Optional[str] = None,
        method: Optional[str] = None,
        update_mode: Optional[Union[str, "_models.UpdateMode"]] = None,
        **kwargs
    ):
        """
        :keyword dll_path: The Csharp code containing a single function definition.
        :paramtype dll_path: str
        :keyword class_property: The Csharp code containing a single function definition.
        :paramtype class_property: str
        :keyword method: The Csharp code containing a single function definition.
        :paramtype method: str
        :keyword update_mode: Refresh modes for Stream Analytics functions. Known values are: "Static"
         and "Refreshable".
        :paramtype update_mode: str or ~azure.mgmt.streamanalytics.models.UpdateMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.StreamAnalytics/CLRUdf"  # type: str
        self.dll_path = dll_path
        self.class_property = class_property
        self.method = method
        self.update_mode = update_mode


class CSharpFunctionRetrieveDefaultDefinitionParameters(FunctionRetrieveDefaultDefinitionParameters):
    """The parameters needed to retrieve the default function definition for a CSharp function.

    All required parameters must be populated in order to send to Azure.

    :ivar binding_type: Indicates the function binding type. Required.
    :vartype binding_type: str
    :ivar script: The CSharp code containing a single function definition.
    :vartype script: str
    :ivar udf_type: The function type. Default value is "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        "binding_type": {"required": True},
    }

    _attribute_map = {
        "binding_type": {"key": "bindingType", "type": "str"},
        "script": {"key": "bindingRetrievalProperties.script", "type": "str"},
        "udf_type": {"key": "bindingRetrievalProperties.udfType", "type": "str"},
    }

    def __init__(self, *, script: Optional[str] = None, udf_type: Optional[Literal["Scalar"]] = None, **kwargs):
        """
        :keyword script: The CSharp code containing a single function definition.
        :paramtype script: str
        :keyword udf_type: The function type. Default value is "Scalar".
        :paramtype udf_type: str
        """
        super().__init__(**kwargs)
        self.binding_type = "Microsoft.StreamAnalytics/CLRUdf"  # type: str
        self.script = script
        self.udf_type = udf_type


class CsvSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in CSV format.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of serialization that the input or output uses. Required on PUT
     (CreateOrReplace) requests. Required. Known values are: "Csv", "Avro", "Json", "CustomClr", and
     "Parquet".
    :vartype type: str or ~azure.mgmt.streamanalytics.models.EventSerializationType
    :ivar field_delimiter: Specifies the delimiter that will be used to separate comma-separated
     value (CSV) records. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of
     supported values. Required on PUT (CreateOrReplace) requests.
    :vartype field_delimiter: str
    :ivar encoding: Specifies the encoding of the incoming data in the case of input and the
     encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     "UTF8"
    :vartype encoding: str or ~azure.mgmt.streamanalytics.models.Encoding
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "field_delimiter": {"key": "properties.fieldDelimiter", "type": "str"},
        "encoding": {"key": "properties.encoding", "type": "str"},
    }

    def __init__(
        self,
        *,
        field_delimiter: Optional[str] = None,
        encoding: Optional[Union[str, "_models.Encoding"]] = None,
        **kwargs
    ):
        """
        :keyword field_delimiter: Specifies the delimiter that will be used to separate comma-separated
         value (CSV) records. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of
         supported values. Required on PUT (CreateOrReplace) requests.
        :paramtype field_delimiter: str
        :keyword encoding: Specifies the encoding of the incoming data in the case of input and the
         encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
         "UTF8"
        :paramtype encoding: str or ~azure.mgmt.streamanalytics.models.Encoding
        """
        super().__init__(**kwargs)
        self.type = "Csv"  # type: str
        self.field_delimiter = field_delimiter
        self.encoding = encoding


class CustomClrSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in custom format.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of serialization that the input or output uses. Required on PUT
     (CreateOrReplace) requests. Required. Known values are: "Csv", "Avro", "Json", "CustomClr", and
     "Parquet".
    :vartype type: str or ~azure.mgmt.streamanalytics.models.EventSerializationType
    :ivar serialization_dll_path: The serialization library path.
    :vartype serialization_dll_path: str
    :ivar serialization_class_name: The serialization class name.
    :vartype serialization_class_name: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "serialization_dll_path": {"key": "properties.serializationDllPath", "type": "str"},
        "serialization_class_name": {"key": "properties.serializationClassName", "type": "str"},
    }

    def __init__(
        self, *, serialization_dll_path: Optional[str] = None, serialization_class_name: Optional[str] = None, **kwargs
    ):
        """
        :keyword serialization_dll_path: The serialization library path.
        :paramtype serialization_dll_path: str
        :keyword serialization_class_name: The serialization class name.
        :paramtype serialization_class_name: str
        """
        super().__init__(**kwargs)
        self.type = "CustomClr"  # type: str
        self.serialization_dll_path = serialization_dll_path
        self.serialization_class_name = serialization_class_name


class DiagnosticCondition(_serialization.Model):
    """Condition applicable to the resource, or to the job overall, that warrant customer attention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar since: The UTC timestamp of when the condition started. Customers should be able to find
     a corresponding event in the ops log around this time.
    :vartype since: str
    :ivar code: The opaque diagnostic code.
    :vartype code: str
    :ivar message: The human-readable message describing the condition in detail. Localized in the
     Accept-Language of the client request.
    :vartype message: str
    """

    _validation = {
        "since": {"readonly": True},
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "since": {"key": "since", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.since = None
        self.code = None
        self.message = None


class Diagnostics(_serialization.Model):
    """Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar conditions: A collection of zero or more conditions applicable to the resource, or to the
     job overall, that warrant customer attention.
    :vartype conditions: list[~azure.mgmt.streamanalytics.models.DiagnosticCondition]
    """

    _validation = {
        "conditions": {"readonly": True},
    }

    _attribute_map = {
        "conditions": {"key": "conditions", "type": "[DiagnosticCondition]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.conditions = None


class DocumentDbOutputDataSource(OutputDataSource):
    """Describes a DocumentDB output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar account_id: The DocumentDB account name or ID. Required on PUT (CreateOrReplace)
     requests.
    :vartype account_id: str
    :ivar account_key: The account key for the DocumentDB account. Required on PUT
     (CreateOrReplace) requests.
    :vartype account_key: str
    :ivar database: The name of the DocumentDB database. Required on PUT (CreateOrReplace)
     requests.
    :vartype database: str
    :ivar collection_name_pattern: The collection name pattern for the collections to be used. The
     collection name format can be constructed using the optional {partition} token, where
     partitions start from 0. See the DocumentDB section of
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more
     information. Required on PUT (CreateOrReplace) requests.
    :vartype collection_name_pattern: str
    :ivar partition_key: The name of the field in output events used to specify the key for
     partitioning output across collections. If 'collectionNamePattern' contains the {partition}
     token, this property is required to be specified.
    :vartype partition_key: str
    :ivar document_id: The name of the field in output events used to specify the primary key which
     insert or update operations are based on.
    :vartype document_id: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "account_id": {"key": "properties.accountId", "type": "str"},
        "account_key": {"key": "properties.accountKey", "type": "str"},
        "database": {"key": "properties.database", "type": "str"},
        "collection_name_pattern": {"key": "properties.collectionNamePattern", "type": "str"},
        "partition_key": {"key": "properties.partitionKey", "type": "str"},
        "document_id": {"key": "properties.documentId", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_id: Optional[str] = None,
        account_key: Optional[str] = None,
        database: Optional[str] = None,
        collection_name_pattern: Optional[str] = None,
        partition_key: Optional[str] = None,
        document_id: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword account_id: The DocumentDB account name or ID. Required on PUT (CreateOrReplace)
         requests.
        :paramtype account_id: str
        :keyword account_key: The account key for the DocumentDB account. Required on PUT
         (CreateOrReplace) requests.
        :paramtype account_key: str
        :keyword database: The name of the DocumentDB database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword collection_name_pattern: The collection name pattern for the collections to be used.
         The collection name format can be constructed using the optional {partition} token, where
         partitions start from 0. See the DocumentDB section of
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more
         information. Required on PUT (CreateOrReplace) requests.
        :paramtype collection_name_pattern: str
        :keyword partition_key: The name of the field in output events used to specify the key for
         partitioning output across collections. If 'collectionNamePattern' contains the {partition}
         token, this property is required to be specified.
        :paramtype partition_key: str
        :keyword document_id: The name of the field in output events used to specify the primary key
         which insert or update operations are based on.
        :paramtype document_id: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Storage/DocumentDB"  # type: str
        self.account_id = account_id
        self.account_key = account_key
        self.database = database
        self.collection_name_pattern = collection_name_pattern
        self.partition_key = partition_key
        self.document_id = document_id
        self.authentication_mode = authentication_mode


class Error(_serialization.Model):
    """Common error representation.

    :ivar error: Error definition properties.
    :vartype error: ~azure.mgmt.streamanalytics.models.ErrorError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorError"},
    }

    def __init__(self, *, error: Optional["_models.ErrorError"] = None, **kwargs):
        """
        :keyword error: Error definition properties.
        :paramtype error: ~azure.mgmt.streamanalytics.models.ErrorError
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorDetails(_serialization.Model):
    """Common error details representation.

    :ivar code: Error code.
    :vartype code: str
    :ivar target: Error target.
    :vartype target: str
    :ivar message: Error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword message: Error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ErrorError(_serialization.Model):
    """Error definition properties.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error details.
    :vartype details: list[~azure.mgmt.streamanalytics.models.ErrorDetails]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetails]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorDetails"]] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: Error details.
        :paramtype details: list[~azure.mgmt.streamanalytics.models.ErrorDetails]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ErrorResponse(_serialization.Model):
    """Describes the error that occurred.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code associated with the error that occurred.
    :vartype code: str
    :ivar message: Describes the error in detail.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class EventGridStreamInputDataSource(StreamInputDataSource):
    """Describes an event grid input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar subscriber: Subscribers for the Event Grid. Currently only EventHub Subscriber is
     supported.
    :vartype subscriber: ~azure.mgmt.streamanalytics.models.EventHubV2StreamInputDataSource
    :ivar schema: Indicates the Event Grid schema type. Known values are: "EventGridEventSchema"
     and "CloudEventSchema".
    :vartype schema: str or ~azure.mgmt.streamanalytics.models.EventGridEventSchemaType
    :ivar storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
     (CreateOrReplace) requests.
    :vartype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
    :ivar event_types: List of Event Types that are supported by the Event Grid adapter.
    :vartype event_types: list[str]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "subscriber": {"key": "properties.subscriber", "type": "EventHubV2StreamInputDataSource"},
        "schema": {"key": "properties.schema", "type": "str"},
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[StorageAccount]"},
        "event_types": {"key": "properties.eventTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        subscriber: Optional["_models.EventHubV2StreamInputDataSource"] = None,
        schema: Optional[Union[str, "_models.EventGridEventSchemaType"]] = None,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        event_types: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword subscriber: Subscribers for the Event Grid. Currently only EventHub Subscriber is
         supported.
        :paramtype subscriber: ~azure.mgmt.streamanalytics.models.EventHubV2StreamInputDataSource
        :keyword schema: Indicates the Event Grid schema type. Known values are: "EventGridEventSchema"
         and "CloudEventSchema".
        :paramtype schema: str or ~azure.mgmt.streamanalytics.models.EventGridEventSchemaType
        :keyword storage_accounts: A list of one or more Azure Storage accounts. Required on PUT
         (CreateOrReplace) requests.
        :paramtype storage_accounts: list[~azure.mgmt.streamanalytics.models.StorageAccount]
        :keyword event_types: List of Event Types that are supported by the Event Grid adapter.
        :paramtype event_types: list[str]
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.EventGrid/EventSubscriptions"  # type: str
        self.subscriber = subscriber
        self.schema = schema
        self.storage_accounts = storage_accounts
        self.event_types = event_types


class ServiceBusDataSourceProperties(_serialization.Model):
    """The common properties that are associated with Service Bus data sources (Queues, Topics, Event Hubs, etc.).

    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "service_bus_namespace": {"key": "serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode


class EventHubDataSourceProperties(ServiceBusDataSourceProperties):
    """The common properties that are associated with Event Hub data sources.

    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :vartype event_hub_name: str
    :ivar partition_count: The partition count of the event hub data source. Range 1 - 256.
    :vartype partition_count: int
    """

    _attribute_map = {
        "service_bus_namespace": {"key": "serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "event_hub_name": {"key": "eventHubName", "type": "str"},
        "partition_count": {"key": "partitionCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        event_hub_name: Optional[str] = None,
        partition_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :paramtype event_hub_name: str
        :keyword partition_count: The partition count of the event hub data source. Range 1 - 256.
        :paramtype partition_count: int
        """
        super().__init__(
            service_bus_namespace=service_bus_namespace,
            shared_access_policy_name=shared_access_policy_name,
            shared_access_policy_key=shared_access_policy_key,
            authentication_mode=authentication_mode,
            **kwargs
        )
        self.event_hub_name = event_hub_name
        self.partition_count = partition_count


class EventHubOutputDataSource(OutputDataSource):
    """Describes an Event Hub output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :vartype event_hub_name: str
    :ivar partition_count: The partition count of the event hub data source. Range 1 - 256.
    :vartype partition_count: int
    :ivar partition_key: The key/column that is used to determine to which partition to send event
     data.
    :vartype partition_key: str
    :ivar property_columns: The properties associated with this Event Hub output.
    :vartype property_columns: list[str]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "properties.sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "properties.sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "event_hub_name": {"key": "properties.eventHubName", "type": "str"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "partition_key": {"key": "properties.partitionKey", "type": "str"},
        "property_columns": {"key": "properties.propertyColumns", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        event_hub_name: Optional[str] = None,
        partition_count: Optional[int] = None,
        partition_key: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :paramtype event_hub_name: str
        :keyword partition_count: The partition count of the event hub data source. Range 1 - 256.
        :paramtype partition_count: int
        :keyword partition_key: The key/column that is used to determine to which partition to send
         event data.
        :paramtype partition_key: str
        :keyword property_columns: The properties associated with this Event Hub output.
        :paramtype property_columns: list[str]
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.ServiceBus/EventHub"  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.partition_count = partition_count
        self.partition_key = partition_key
        self.property_columns = property_columns


class EventHubOutputDataSourceProperties(EventHubDataSourceProperties):
    """The properties that are associated with an Event Hub output.

    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :vartype event_hub_name: str
    :ivar partition_count: The partition count of the event hub data source. Range 1 - 256.
    :vartype partition_count: int
    :ivar partition_key: The key/column that is used to determine to which partition to send event
     data.
    :vartype partition_key: str
    :ivar property_columns: The properties associated with this Event Hub output.
    :vartype property_columns: list[str]
    """

    _attribute_map = {
        "service_bus_namespace": {"key": "serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "event_hub_name": {"key": "eventHubName", "type": "str"},
        "partition_count": {"key": "partitionCount", "type": "int"},
        "partition_key": {"key": "partitionKey", "type": "str"},
        "property_columns": {"key": "propertyColumns", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        event_hub_name: Optional[str] = None,
        partition_count: Optional[int] = None,
        partition_key: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :paramtype event_hub_name: str
        :keyword partition_count: The partition count of the event hub data source. Range 1 - 256.
        :paramtype partition_count: int
        :keyword partition_key: The key/column that is used to determine to which partition to send
         event data.
        :paramtype partition_key: str
        :keyword property_columns: The properties associated with this Event Hub output.
        :paramtype property_columns: list[str]
        """
        super().__init__(
            service_bus_namespace=service_bus_namespace,
            shared_access_policy_name=shared_access_policy_name,
            shared_access_policy_key=shared_access_policy_key,
            authentication_mode=authentication_mode,
            event_hub_name=event_hub_name,
            partition_count=partition_count,
            **kwargs
        )
        self.partition_key = partition_key
        self.property_columns = property_columns


class EventHubStreamInputDataSource(StreamInputDataSource):
    """Describes an Event Hub input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :vartype event_hub_name: str
    :ivar partition_count: The partition count of the event hub data source. Range 1 - 256.
    :vartype partition_count: int
    :ivar consumer_group_name: The name of an Event Hub Consumer Group that should be used to read
     events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows
     each of those inputs to receive the same events from the Event Hub. If not specified, the input
     uses the Event Hub’s default consumer group.
    :vartype consumer_group_name: str
    :ivar prefetch_count: The number of messages that the message receiver can simultaneously
     request.
    :vartype prefetch_count: int
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "properties.sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "properties.sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "event_hub_name": {"key": "properties.eventHubName", "type": "str"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "consumer_group_name": {"key": "properties.consumerGroupName", "type": "str"},
        "prefetch_count": {"key": "properties.prefetchCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        event_hub_name: Optional[str] = None,
        partition_count: Optional[int] = None,
        consumer_group_name: Optional[str] = None,
        prefetch_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :paramtype event_hub_name: str
        :keyword partition_count: The partition count of the event hub data source. Range 1 - 256.
        :paramtype partition_count: int
        :keyword consumer_group_name: The name of an Event Hub Consumer Group that should be used to
         read events from the Event Hub. Specifying distinct consumer group names for multiple inputs
         allows each of those inputs to receive the same events from the Event Hub. If not specified,
         the input uses the Event Hub’s default consumer group.
        :paramtype consumer_group_name: str
        :keyword prefetch_count: The number of messages that the message receiver can simultaneously
         request.
        :paramtype prefetch_count: int
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.ServiceBus/EventHub"  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.partition_count = partition_count
        self.consumer_group_name = consumer_group_name
        self.prefetch_count = prefetch_count


class EventHubStreamInputDataSourceProperties(EventHubDataSourceProperties):
    """The properties that are associated with a Event Hub input containing stream data.

    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :vartype event_hub_name: str
    :ivar partition_count: The partition count of the event hub data source. Range 1 - 256.
    :vartype partition_count: int
    :ivar consumer_group_name: The name of an Event Hub Consumer Group that should be used to read
     events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows
     each of those inputs to receive the same events from the Event Hub. If not specified, the input
     uses the Event Hub’s default consumer group.
    :vartype consumer_group_name: str
    :ivar prefetch_count: The number of messages that the message receiver can simultaneously
     request.
    :vartype prefetch_count: int
    """

    _attribute_map = {
        "service_bus_namespace": {"key": "serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "event_hub_name": {"key": "eventHubName", "type": "str"},
        "partition_count": {"key": "partitionCount", "type": "int"},
        "consumer_group_name": {"key": "consumerGroupName", "type": "str"},
        "prefetch_count": {"key": "prefetchCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        event_hub_name: Optional[str] = None,
        partition_count: Optional[int] = None,
        consumer_group_name: Optional[str] = None,
        prefetch_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :paramtype event_hub_name: str
        :keyword partition_count: The partition count of the event hub data source. Range 1 - 256.
        :paramtype partition_count: int
        :keyword consumer_group_name: The name of an Event Hub Consumer Group that should be used to
         read events from the Event Hub. Specifying distinct consumer group names for multiple inputs
         allows each of those inputs to receive the same events from the Event Hub. If not specified,
         the input uses the Event Hub’s default consumer group.
        :paramtype consumer_group_name: str
        :keyword prefetch_count: The number of messages that the message receiver can simultaneously
         request.
        :paramtype prefetch_count: int
        """
        super().__init__(
            service_bus_namespace=service_bus_namespace,
            shared_access_policy_name=shared_access_policy_name,
            shared_access_policy_key=shared_access_policy_key,
            authentication_mode=authentication_mode,
            event_hub_name=event_hub_name,
            partition_count=partition_count,
            **kwargs
        )
        self.consumer_group_name = consumer_group_name
        self.prefetch_count = prefetch_count


class EventHubV2OutputDataSource(OutputDataSource):
    """Describes an Event Hub output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :vartype event_hub_name: str
    :ivar partition_count: The partition count of the event hub data source. Range 1 - 256.
    :vartype partition_count: int
    :ivar partition_key: The key/column that is used to determine to which partition to send event
     data.
    :vartype partition_key: str
    :ivar property_columns: The properties associated with this Event Hub output.
    :vartype property_columns: list[str]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "properties.sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "properties.sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "event_hub_name": {"key": "properties.eventHubName", "type": "str"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "partition_key": {"key": "properties.partitionKey", "type": "str"},
        "property_columns": {"key": "properties.propertyColumns", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        event_hub_name: Optional[str] = None,
        partition_count: Optional[int] = None,
        partition_key: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :paramtype event_hub_name: str
        :keyword partition_count: The partition count of the event hub data source. Range 1 - 256.
        :paramtype partition_count: int
        :keyword partition_key: The key/column that is used to determine to which partition to send
         event data.
        :paramtype partition_key: str
        :keyword property_columns: The properties associated with this Event Hub output.
        :paramtype property_columns: list[str]
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.EventHub/EventHub"  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.partition_count = partition_count
        self.partition_key = partition_key
        self.property_columns = property_columns


class EventHubV2StreamInputDataSource(StreamInputDataSource):
    """Describes an Event Hub input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
    :vartype event_hub_name: str
    :ivar partition_count: The partition count of the event hub data source. Range 1 - 256.
    :vartype partition_count: int
    :ivar consumer_group_name: The name of an Event Hub Consumer Group that should be used to read
     events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows
     each of those inputs to receive the same events from the Event Hub. If not specified, the input
     uses the Event Hub’s default consumer group.
    :vartype consumer_group_name: str
    :ivar prefetch_count: The number of messages that the message receiver can simultaneously
     request.
    :vartype prefetch_count: int
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "properties.sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "properties.sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "event_hub_name": {"key": "properties.eventHubName", "type": "str"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "consumer_group_name": {"key": "properties.consumerGroupName", "type": "str"},
        "prefetch_count": {"key": "properties.prefetchCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        event_hub_name: Optional[str] = None,
        partition_count: Optional[int] = None,
        consumer_group_name: Optional[str] = None,
        prefetch_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :paramtype event_hub_name: str
        :keyword partition_count: The partition count of the event hub data source. Range 1 - 256.
        :paramtype partition_count: int
        :keyword consumer_group_name: The name of an Event Hub Consumer Group that should be used to
         read events from the Event Hub. Specifying distinct consumer group names for multiple inputs
         allows each of those inputs to receive the same events from the Event Hub. If not specified,
         the input uses the Event Hub’s default consumer group.
        :paramtype consumer_group_name: str
        :keyword prefetch_count: The number of messages that the message receiver can simultaneously
         request.
        :paramtype prefetch_count: int
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.EventHub/EventHub"  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.event_hub_name = event_hub_name
        self.partition_count = partition_count
        self.consumer_group_name = consumer_group_name
        self.prefetch_count = prefetch_count


class External(_serialization.Model):
    """The storage account where the custom code artifacts are located.

    :ivar storage_account: The properties that are associated with an Azure Storage account.
    :vartype storage_account: ~azure.mgmt.streamanalytics.models.StorageAccount
    :ivar container: The UserCustomCode container.
    :vartype container: str
    :ivar path: The UserCustomCode path.
    :vartype path: str
    :ivar refresh_configuration: The refresh parameters for any/all updatable user defined
     functions present in the job config.
    :vartype refresh_configuration: ~azure.mgmt.streamanalytics.models.RefreshConfiguration
    """

    _attribute_map = {
        "storage_account": {"key": "storageAccount", "type": "StorageAccount"},
        "container": {"key": "container", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "refresh_configuration": {"key": "refreshConfiguration", "type": "RefreshConfiguration"},
    }

    def __init__(
        self,
        *,
        storage_account: Optional["_models.StorageAccount"] = None,
        container: Optional[str] = None,
        path: Optional[str] = None,
        refresh_configuration: Optional["_models.RefreshConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword storage_account: The properties that are associated with an Azure Storage account.
        :paramtype storage_account: ~azure.mgmt.streamanalytics.models.StorageAccount
        :keyword container: The UserCustomCode container.
        :paramtype container: str
        :keyword path: The UserCustomCode path.
        :paramtype path: str
        :keyword refresh_configuration: The refresh parameters for any/all updatable user defined
         functions present in the job config.
        :paramtype refresh_configuration: ~azure.mgmt.streamanalytics.models.RefreshConfiguration
        """
        super().__init__(**kwargs)
        self.storage_account = storage_account
        self.container = container
        self.path = path
        self.refresh_configuration = refresh_configuration


class FileReferenceInputDataSource(ReferenceInputDataSource):
    """Describes a file input data source that contains reference data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing reference data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar path: The path of the file.
    :vartype path: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "path": {"key": "properties.path", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, **kwargs):
        """
        :keyword path: The path of the file.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.type = "File"  # type: str
        self.path = path


class SubResource(_serialization.Model):
    """The base sub-resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: Resource name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None


class Function(SubResource):
    """A function object, containing all information associated with the named function. All functions are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The properties that are associated with a function.
    :vartype properties: ~azure.mgmt.streamanalytics.models.FunctionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "FunctionProperties"},
    }

    def __init__(
        self, *, name: Optional[str] = None, properties: Optional["_models.FunctionProperties"] = None, **kwargs
    ):
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword properties: The properties that are associated with a function.
        :paramtype properties: ~azure.mgmt.streamanalytics.models.FunctionProperties
        """
        super().__init__(name=name, **kwargs)
        self.properties = properties


class FunctionInput(_serialization.Model):
    """Describes one input parameter of a function.

    :ivar data_type: The (Azure Stream Analytics supported) data type of the function input
     parameter. A list of valid Azure Stream Analytics data types are described at
     https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx.
    :vartype data_type: str
    :ivar is_configuration_parameter: A flag indicating if the parameter is a configuration
     parameter. True if this input parameter is expected to be a constant. Default is false.
    :vartype is_configuration_parameter: bool
    """

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "is_configuration_parameter": {"key": "isConfigurationParameter", "type": "bool"},
    }

    def __init__(self, *, data_type: Optional[str] = None, is_configuration_parameter: Optional[bool] = None, **kwargs):
        """
        :keyword data_type: The (Azure Stream Analytics supported) data type of the function input
         parameter. A list of valid Azure Stream Analytics data types are described at
         https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx.
        :paramtype data_type: str
        :keyword is_configuration_parameter: A flag indicating if the parameter is a configuration
         parameter. True if this input parameter is expected to be a constant. Default is false.
        :paramtype is_configuration_parameter: bool
        """
        super().__init__(**kwargs)
        self.data_type = data_type
        self.is_configuration_parameter = is_configuration_parameter


class FunctionListResult(_serialization.Model):
    """Object containing a list of functions under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of functions under a streaming job. Populated by a 'List' operation.
    :vartype value: list[~azure.mgmt.streamanalytics.models.Function]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Function]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class FunctionOutput(_serialization.Model):
    """Describes the output of a function.

    :ivar data_type: The (Azure Stream Analytics supported) data type of the function output. A
     list of valid Azure Stream Analytics data types are described at
     https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx.
    :vartype data_type: str
    """

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
    }

    def __init__(self, *, data_type: Optional[str] = None, **kwargs):
        """
        :keyword data_type: The (Azure Stream Analytics supported) data type of the function output. A
         list of valid Azure Stream Analytics data types are described at
         https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx.
        :paramtype data_type: str
        """
        super().__init__(**kwargs)
        self.data_type = data_type


class GatewayMessageBusOutputDataSource(OutputDataSource):
    """Describes a Gateway Message Bus output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar topic: The name of the Service Bus topic.
    :vartype topic: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "topic": {"key": "properties.topic", "type": "str"},
    }

    def __init__(self, *, topic: Optional[str] = None, **kwargs):
        """
        :keyword topic: The name of the Service Bus topic.
        :paramtype topic: str
        """
        super().__init__(**kwargs)
        self.type = "GatewayMessageBus"  # type: str
        self.topic = topic


class GatewayMessageBusSourceProperties(_serialization.Model):
    """The properties that are associated with a gateway message bus datasource.

    :ivar topic: The name of the Service Bus topic.
    :vartype topic: str
    """

    _attribute_map = {
        "topic": {"key": "topic", "type": "str"},
    }

    def __init__(self, *, topic: Optional[str] = None, **kwargs):
        """
        :keyword topic: The name of the Service Bus topic.
        :paramtype topic: str
        """
        super().__init__(**kwargs)
        self.topic = topic


class GatewayMessageBusOutputDataSourceProperties(GatewayMessageBusSourceProperties):
    """The properties that are associated with a Gateway Message Bus.

    :ivar topic: The name of the Service Bus topic.
    :vartype topic: str
    """

    _attribute_map = {
        "topic": {"key": "topic", "type": "str"},
    }

    def __init__(self, *, topic: Optional[str] = None, **kwargs):
        """
        :keyword topic: The name of the Service Bus topic.
        :paramtype topic: str
        """
        super().__init__(topic=topic, **kwargs)


class GatewayMessageBusStreamInputDataSource(StreamInputDataSource):
    """Describes a blob input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar topic: The name of the Service Bus topic.
    :vartype topic: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "topic": {"key": "properties.topic", "type": "str"},
    }

    def __init__(self, *, topic: Optional[str] = None, **kwargs):
        """
        :keyword topic: The name of the Service Bus topic.
        :paramtype topic: str
        """
        super().__init__(**kwargs)
        self.type = "GatewayMessageBus"  # type: str
        self.topic = topic


class GatewayMessageBusStreamInputDataSourceProperties(GatewayMessageBusSourceProperties):
    """The properties that are associated with a gateway message bus input containing stream data.

    :ivar topic: The name of the Service Bus topic.
    :vartype topic: str
    """

    _attribute_map = {
        "topic": {"key": "topic", "type": "str"},
    }

    def __init__(self, *, topic: Optional[str] = None, **kwargs):
        """
        :keyword topic: The name of the Service Bus topic.
        :paramtype topic: str
        """
        super().__init__(topic=topic, **kwargs)


class GetStreamingJobSkuResult(_serialization.Model):
    """Describes an available SKU information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
     "Microsoft.StreamAnalytics/streamingjobs"
    :vartype resource_type: str or ~azure.mgmt.streamanalytics.models.ResourceType
    :ivar sku: The properties that are associated with a SKU.
    :vartype sku: ~azure.mgmt.streamanalytics.models.GetStreamingJobSkuResultSku
    :ivar capacity: Describes scaling information of a SKU.
    :vartype capacity: ~azure.mgmt.streamanalytics.models.SkuCapacity
    """

    _validation = {
        "resource_type": {"readonly": True},
        "sku": {"readonly": True},
        "capacity": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "GetStreamingJobSkuResultSku"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class GetStreamingJobSkuResults(_serialization.Model):
    """Result of the request to get streaming job SKUs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of available SKUs that the streaming job can use.
    :vartype value: list[~azure.mgmt.streamanalytics.models.GetStreamingJobSkuResult]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GetStreamingJobSkuResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.GetStreamingJobSkuResult"]] = None, **kwargs):
        """
        :keyword value: The list of available SKUs that the streaming job can use.
        :paramtype value: list[~azure.mgmt.streamanalytics.models.GetStreamingJobSkuResult]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class GetStreamingJobSkuResultSku(_serialization.Model):
    """The properties that are associated with a SKU.

    :ivar name: The name of the SKU. "Standard"
    :vartype name: str or ~azure.mgmt.streamanalytics.models.SkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.SkuName"]] = None, **kwargs):
        """
        :keyword name: The name of the SKU. "Standard"
        :paramtype name: str or ~azure.mgmt.streamanalytics.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name


class Identity(_serialization.Model):
    """Describes how identity is verified.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tenant_id: The tenantId of the identity.
    :vartype tenant_id: str
    :ivar principal_id: The principalId of the identity.
    :vartype principal_id: str
    :ivar type: The type of identity, can be SystemAssigned or UserAssigned.
    :vartype type: str
    :ivar user_assigned_identities: The user assigned identities associated with the streaming job
     resource.
    :vartype user_assigned_identities: JSON
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "object"},
    }

    def __init__(self, *, type: Optional[str] = None, user_assigned_identities: Optional[JSON] = None, **kwargs):
        """
        :keyword type: The type of identity, can be SystemAssigned or UserAssigned.
        :paramtype type: str
        :keyword user_assigned_identities: The user assigned identities associated with the streaming
         job resource.
        :paramtype user_assigned_identities: JSON
        """
        super().__init__(**kwargs)
        self.tenant_id = None
        self.principal_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Input(SubResource):
    """An input object, containing all information associated with the named input. All inputs are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The properties that are associated with an input. Required on PUT
     (CreateOrReplace) requests.
    :vartype properties: ~azure.mgmt.streamanalytics.models.InputProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "InputProperties"},
    }

    def __init__(self, *, name: Optional[str] = None, properties: Optional["_models.InputProperties"] = None, **kwargs):
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword properties: The properties that are associated with an input. Required on PUT
         (CreateOrReplace) requests.
        :paramtype properties: ~azure.mgmt.streamanalytics.models.InputProperties
        """
        super().__init__(name=name, **kwargs)
        self.properties = properties


class InputListResult(_serialization.Model):
    """Object containing a list of inputs under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of inputs under a streaming job. Populated by a 'List' operation.
    :vartype value: list[~azure.mgmt.streamanalytics.models.Input]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Input]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class InputProperties(_serialization.Model):
    """The properties that are associated with an input.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ReferenceInputProperties, StreamInputProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates whether the input is a source of reference data or stream data. Required
     on PUT (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :vartype serialization: ~azure.mgmt.streamanalytics.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~azure.mgmt.streamanalytics.models.Diagnostics
    :ivar etag: The current entity tag for the input. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar compression: Describes how input data is compressed.
    :vartype compression: ~azure.mgmt.streamanalytics.models.Compression
    :ivar partition_key: partitionKey Describes a key in the input data which is used for
     partitioning the input data.
    :vartype partition_key: str
    :ivar watermark_settings: Settings which determine whether to read watermark events.
    :vartype watermark_settings: ~azure.mgmt.streamanalytics.models.InputWatermarkProperties
    """

    _validation = {
        "type": {"required": True},
        "diagnostics": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "serialization": {"key": "serialization", "type": "Serialization"},
        "diagnostics": {"key": "diagnostics", "type": "Diagnostics"},
        "etag": {"key": "etag", "type": "str"},
        "compression": {"key": "compression", "type": "Compression"},
        "partition_key": {"key": "partitionKey", "type": "str"},
        "watermark_settings": {"key": "watermarkSettings", "type": "InputWatermarkProperties"},
    }

    _subtype_map = {"type": {"Reference": "ReferenceInputProperties", "Stream": "StreamInputProperties"}}

    def __init__(
        self,
        *,
        serialization: Optional["_models.Serialization"] = None,
        compression: Optional["_models.Compression"] = None,
        partition_key: Optional[str] = None,
        watermark_settings: Optional["_models.InputWatermarkProperties"] = None,
        **kwargs
    ):
        """
        :keyword serialization: Describes how data from an input is serialized or how data is
         serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        :paramtype serialization: ~azure.mgmt.streamanalytics.models.Serialization
        :keyword compression: Describes how input data is compressed.
        :paramtype compression: ~azure.mgmt.streamanalytics.models.Compression
        :keyword partition_key: partitionKey Describes a key in the input data which is used for
         partitioning the input data.
        :paramtype partition_key: str
        :keyword watermark_settings: Settings which determine whether to read watermark events.
        :paramtype watermark_settings: ~azure.mgmt.streamanalytics.models.InputWatermarkProperties
        """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.serialization = serialization
        self.diagnostics = None
        self.etag = None
        self.compression = compression
        self.partition_key = partition_key
        self.watermark_settings = watermark_settings


class InputWatermarkProperties(_serialization.Model):
    """Settings which determine whether to read watermark events.

    :ivar watermark_mode: The input watermark mode. Known values are: "None" and "ReadWatermark".
    :vartype watermark_mode: str or ~azure.mgmt.streamanalytics.models.InputWatermarkMode
    """

    _attribute_map = {
        "watermark_mode": {"key": "watermarkMode", "type": "str"},
    }

    def __init__(self, *, watermark_mode: Optional[Union[str, "_models.InputWatermarkMode"]] = None, **kwargs):
        """
        :keyword watermark_mode: The input watermark mode. Known values are: "None" and
         "ReadWatermark".
        :paramtype watermark_mode: str or ~azure.mgmt.streamanalytics.models.InputWatermarkMode
        """
        super().__init__(**kwargs)
        self.watermark_mode = watermark_mode


class IoTHubStreamInputDataSource(StreamInputDataSource):
    """Describes an IoT Hub input data source that contains stream data.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar iot_hub_namespace: The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace)
     requests.
    :vartype iot_hub_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the IoT Hub. This policy
     must contain at least the Service connect permission. Required on PUT (CreateOrReplace)
     requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar consumer_group_name: The name of an IoT Hub Consumer Group that should be used to read
     events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
    :vartype consumer_group_name: str
    :ivar endpoint: The IoT Hub endpoint to connect to (ie. messages/events,
     messages/operationsMonitoringEvents, etc.).
    :vartype endpoint: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "iot_hub_namespace": {"key": "properties.iotHubNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "properties.sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "properties.sharedAccessPolicyKey", "type": "str"},
        "consumer_group_name": {"key": "properties.consumerGroupName", "type": "str"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        iot_hub_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        consumer_group_name: Optional[str] = None,
        endpoint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword iot_hub_namespace: The name or the URI of the IoT Hub. Required on PUT
         (CreateOrReplace) requests.
        :paramtype iot_hub_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the IoT Hub. This policy
         must contain at least the Service connect permission. Required on PUT (CreateOrReplace)
         requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword consumer_group_name: The name of an IoT Hub Consumer Group that should be used to read
         events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
        :paramtype consumer_group_name: str
        :keyword endpoint: The IoT Hub endpoint to connect to (ie. messages/events,
         messages/operationsMonitoringEvents, etc.).
        :paramtype endpoint: str
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.Devices/IotHubs"  # type: str
        self.iot_hub_namespace = iot_hub_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.consumer_group_name = consumer_group_name
        self.endpoint = endpoint


class JavaScriptFunctionBinding(FunctionBinding):
    """The binding to a JavaScript function.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the function binding type. Required.
    :vartype type: str
    :ivar script: The JavaScript code containing a single function definition. For example:
     'function (x, y) { return x + y; }'.
    :vartype script: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "script": {"key": "properties.script", "type": "str"},
    }

    def __init__(self, *, script: Optional[str] = None, **kwargs):
        """
        :keyword script: The JavaScript code containing a single function definition. For example:
         'function (x, y) { return x + y; }'.
        :paramtype script: str
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.StreamAnalytics/JavascriptUdf"  # type: str
        self.script = script


class JavaScriptFunctionRetrieveDefaultDefinitionParameters(FunctionRetrieveDefaultDefinitionParameters):
    """The parameters needed to retrieve the default function definition for a JavaScript function.

    All required parameters must be populated in order to send to Azure.

    :ivar binding_type: Indicates the function binding type. Required.
    :vartype binding_type: str
    :ivar script: The JavaScript code containing a single function definition. For example:
     'function (x, y) { return x + y; }'.
    :vartype script: str
    :ivar udf_type: The function type. Default value is "Scalar".
    :vartype udf_type: str
    """

    _validation = {
        "binding_type": {"required": True},
    }

    _attribute_map = {
        "binding_type": {"key": "bindingType", "type": "str"},
        "script": {"key": "bindingRetrievalProperties.script", "type": "str"},
        "udf_type": {"key": "bindingRetrievalProperties.udfType", "type": "str"},
    }

    def __init__(self, *, script: Optional[str] = None, udf_type: Optional[Literal["Scalar"]] = None, **kwargs):
        """
        :keyword script: The JavaScript code containing a single function definition. For example:
         'function (x, y) { return x + y; }'.
        :paramtype script: str
        :keyword udf_type: The function type. Default value is "Scalar".
        :paramtype udf_type: str
        """
        super().__init__(**kwargs)
        self.binding_type = "Microsoft.StreamAnalytics/JavascriptUdf"  # type: str
        self.script = script
        self.udf_type = udf_type


class StorageAccount(_serialization.Model):
    """The properties that are associated with an Azure Storage account.

    :ivar account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
     requests.
    :vartype account_name: str
    :ivar account_key: The account key for the Azure Storage account. Required on PUT
     (CreateOrReplace) requests.
    :vartype account_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "account_key": {"key": "accountKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
         requests.
        :paramtype account_name: str
        :keyword account_key: The account key for the Azure Storage account. Required on PUT
         (CreateOrReplace) requests.
        :paramtype account_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.account_name = account_name
        self.account_key = account_key
        self.authentication_mode = authentication_mode


class JobStorageAccount(StorageAccount):
    """The properties that are associated with an Azure Storage account with MSI.

    :ivar account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
     requests.
    :vartype account_name: str
    :ivar account_key: The account key for the Azure Storage account. Required on PUT
     (CreateOrReplace) requests.
    :vartype account_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "account_key": {"key": "accountKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace)
         requests.
        :paramtype account_name: str
        :keyword account_key: The account key for the Azure Storage account. Required on PUT
         (CreateOrReplace) requests.
        :paramtype account_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(
            account_name=account_name, account_key=account_key, authentication_mode=authentication_mode, **kwargs
        )


class JsonSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in JSON format.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of serialization that the input or output uses. Required on PUT
     (CreateOrReplace) requests. Required. Known values are: "Csv", "Avro", "Json", "CustomClr", and
     "Parquet".
    :vartype type: str or ~azure.mgmt.streamanalytics.models.EventSerializationType
    :ivar encoding: Specifies the encoding of the incoming data in the case of input and the
     encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     "UTF8"
    :vartype encoding: str or ~azure.mgmt.streamanalytics.models.Encoding
    :ivar format: This property only applies to JSON serialization of outputs only. It is not
     applicable to inputs. This property specifies the format of the JSON the output will be written
     in. The currently supported values are 'lineSeparated' indicating the output will be formatted
     by having each JSON object separated by a new line and 'array' indicating the output will be
     formatted as an array of JSON objects. Default value is 'lineSeparated' if left null. Known
     values are: "LineSeparated" and "Array".
    :vartype format: str or ~azure.mgmt.streamanalytics.models.JsonOutputSerializationFormat
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "encoding": {"key": "properties.encoding", "type": "str"},
        "format": {"key": "properties.format", "type": "str"},
    }

    def __init__(
        self,
        *,
        encoding: Optional[Union[str, "_models.Encoding"]] = None,
        format: Optional[Union[str, "_models.JsonOutputSerializationFormat"]] = None,
        **kwargs
    ):
        """
        :keyword encoding: Specifies the encoding of the incoming data in the case of input and the
         encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
         "UTF8"
        :paramtype encoding: str or ~azure.mgmt.streamanalytics.models.Encoding
        :keyword format: This property only applies to JSON serialization of outputs only. It is not
         applicable to inputs. This property specifies the format of the JSON the output will be written
         in. The currently supported values are 'lineSeparated' indicating the output will be formatted
         by having each JSON object separated by a new line and 'array' indicating the output will be
         formatted as an array of JSON objects. Default value is 'lineSeparated' if left null. Known
         values are: "LineSeparated" and "Array".
        :paramtype format: str or ~azure.mgmt.streamanalytics.models.JsonOutputSerializationFormat
        """
        super().__init__(**kwargs)
        self.type = "Json"  # type: str
        self.encoding = encoding
        self.format = format


class LastOutputEventTimestamp(_serialization.Model):
    """An output event timestamp.

    :ivar last_output_event_time: The last output event time.
    :vartype last_output_event_time: str
    :ivar last_update_time: The time that the last update happened.
    :vartype last_update_time: str
    """

    _attribute_map = {
        "last_output_event_time": {"key": "lastOutputEventTime", "type": "str"},
        "last_update_time": {"key": "lastUpdateTime", "type": "str"},
    }

    def __init__(
        self, *, last_output_event_time: Optional[str] = None, last_update_time: Optional[str] = None, **kwargs
    ):
        """
        :keyword last_output_event_time: The last output event time.
        :paramtype last_output_event_time: str
        :keyword last_update_time: The time that the last update happened.
        :paramtype last_update_time: str
        """
        super().__init__(**kwargs)
        self.last_output_event_time = last_output_event_time
        self.last_update_time = last_update_time


class Operation(_serialization.Model):
    """A Stream Analytics REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Contains the localized display information for this particular operation /
     action.
    :vartype display: ~azure.mgmt.streamanalytics.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, is_data_action: Optional[bool] = None, **kwargs):
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = is_data_action
        self.display = None


class OperationDisplay(_serialization.Model):
    """Contains the localized display information for this particular operation / action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """Result of the request to list Stream Analytics operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Stream Analytics operations supported by the Microsoft.StreamAnalytics
     resource provider.
    :vartype value: list[~azure.mgmt.streamanalytics.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Output(SubResource):  # pylint: disable=too-many-instance-attributes
    """An output object, containing all information associated with the named output. All outputs are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar datasource: Describes the data source that output will be written to. Required on PUT
     (CreateOrReplace) requests.
    :vartype datasource: ~azure.mgmt.streamanalytics.models.OutputDataSource
    :ivar time_window: The time frame for filtering Stream Analytics job outputs.
    :vartype time_window: str
    :ivar size_window: The size window to constrain a Stream Analytics output to.
    :vartype size_window: float
    :ivar serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :vartype serialization: ~azure.mgmt.streamanalytics.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~azure.mgmt.streamanalytics.models.Diagnostics
    :ivar etag: The current entity tag for the output. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar last_output_event_timestamps: A list of the last output event times for each output
     partition. The index of the array corresponds to the partition number.
    :vartype last_output_event_timestamps:
     list[~azure.mgmt.streamanalytics.models.LastOutputEventTimestamp]
    :ivar watermark_settings: Settings which determine whether to send watermarks to downstream.
    :vartype watermark_settings: ~azure.mgmt.streamanalytics.models.OutputWatermarkProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "diagnostics": {"readonly": True},
        "etag": {"readonly": True},
        "last_output_event_timestamps": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "datasource": {"key": "properties.datasource", "type": "OutputDataSource"},
        "time_window": {"key": "properties.timeWindow", "type": "str"},
        "size_window": {"key": "properties.sizeWindow", "type": "float"},
        "serialization": {"key": "properties.serialization", "type": "Serialization"},
        "diagnostics": {"key": "properties.diagnostics", "type": "Diagnostics"},
        "etag": {"key": "properties.etag", "type": "str"},
        "last_output_event_timestamps": {
            "key": "properties.lastOutputEventTimestamps",
            "type": "[LastOutputEventTimestamp]",
        },
        "watermark_settings": {"key": "properties.watermarkSettings", "type": "OutputWatermarkProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        datasource: Optional["_models.OutputDataSource"] = None,
        time_window: Optional[str] = None,
        size_window: Optional[float] = None,
        serialization: Optional["_models.Serialization"] = None,
        watermark_settings: Optional["_models.OutputWatermarkProperties"] = None,
        **kwargs
    ):
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword datasource: Describes the data source that output will be written to. Required on PUT
         (CreateOrReplace) requests.
        :paramtype datasource: ~azure.mgmt.streamanalytics.models.OutputDataSource
        :keyword time_window: The time frame for filtering Stream Analytics job outputs.
        :paramtype time_window: str
        :keyword size_window: The size window to constrain a Stream Analytics output to.
        :paramtype size_window: float
        :keyword serialization: Describes how data from an input is serialized or how data is
         serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        :paramtype serialization: ~azure.mgmt.streamanalytics.models.Serialization
        :keyword watermark_settings: Settings which determine whether to send watermarks to downstream.
        :paramtype watermark_settings: ~azure.mgmt.streamanalytics.models.OutputWatermarkProperties
        """
        super().__init__(name=name, **kwargs)
        self.datasource = datasource
        self.time_window = time_window
        self.size_window = size_window
        self.serialization = serialization
        self.diagnostics = None
        self.etag = None
        self.last_output_event_timestamps = None
        self.watermark_settings = watermark_settings


class OutputListResult(_serialization.Model):
    """Object containing a list of outputs under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of outputs under a streaming job. Populated by a 'List' operation.
    :vartype value: list[~azure.mgmt.streamanalytics.models.Output]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Output]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OutputWatermarkProperties(_serialization.Model):
    """Settings which determine whether to send watermarks to downstream.

    :ivar watermark_mode: The output watermark mode. Known values are: "None",
     "SendCurrentPartitionWatermark", and "SendLowestWatermarkAcrossPartitions".
    :vartype watermark_mode: str or ~azure.mgmt.streamanalytics.models.OutputWatermarkMode
    :ivar max_watermark_difference_across_partitions: Describes the maximal delta between the
     fastest and slowest partitions, so the out of order window that catches all necessary events in
     downstream jobs is well defined.
    :vartype max_watermark_difference_across_partitions: str
    """

    _attribute_map = {
        "watermark_mode": {"key": "watermarkMode", "type": "str"},
        "max_watermark_difference_across_partitions": {"key": "maxWatermarkDifferenceAcrossPartitions", "type": "str"},
    }

    def __init__(
        self,
        *,
        watermark_mode: Optional[Union[str, "_models.OutputWatermarkMode"]] = None,
        max_watermark_difference_across_partitions: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword watermark_mode: The output watermark mode. Known values are: "None",
         "SendCurrentPartitionWatermark", and "SendLowestWatermarkAcrossPartitions".
        :paramtype watermark_mode: str or ~azure.mgmt.streamanalytics.models.OutputWatermarkMode
        :keyword max_watermark_difference_across_partitions: Describes the maximal delta between the
         fastest and slowest partitions, so the out of order window that catches all necessary events in
         downstream jobs is well defined.
        :paramtype max_watermark_difference_across_partitions: str
        """
        super().__init__(**kwargs)
        self.watermark_mode = watermark_mode
        self.max_watermark_difference_across_partitions = max_watermark_difference_across_partitions


class ParquetSerialization(Serialization):
    """Describes how data from an input is serialized or how data is serialized when written to an output in Parquet format.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of serialization that the input or output uses. Required on PUT
     (CreateOrReplace) requests. Required. Known values are: "Csv", "Avro", "Json", "CustomClr", and
     "Parquet".
    :vartype type: str or ~azure.mgmt.streamanalytics.models.EventSerializationType
    :ivar properties: The properties that are associated with the Parquet serialization type.
     Required on PUT (CreateOrReplace) requests.
    :vartype properties: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(self, *, properties: Optional[JSON] = None, **kwargs):
        """
        :keyword properties: The properties that are associated with the Parquet serialization type.
         Required on PUT (CreateOrReplace) requests.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.type = "Parquet"  # type: str
        self.properties = properties


class PostgreSQLDataSourceProperties(_serialization.Model):
    """The properties that are associated with an Azure SQL database data source.

    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on query
     partition) are available. Optional on PUT requests.
    :vartype max_writer_count: float
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "user": {"key": "user", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "max_writer_count": {"key": "maxWriterCount", "type": "float"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on
         query partition) are available. Optional on PUT requests.
        :paramtype max_writer_count: float
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.server = server
        self.database = database
        self.table = table
        self.user = user
        self.password = password
        self.max_writer_count = max_writer_count
        self.authentication_mode = authentication_mode


class PostgreSQLOutputDataSource(OutputDataSource):
    """Describes a PostgreSQL output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on query
     partition) are available. Optional on PUT requests.
    :vartype max_writer_count: float
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "server": {"key": "properties.server", "type": "str"},
        "database": {"key": "properties.database", "type": "str"},
        "table": {"key": "properties.table", "type": "str"},
        "user": {"key": "properties.user", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "max_writer_count": {"key": "properties.maxWriterCount", "type": "float"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on
         query partition) are available. Optional on PUT requests.
        :paramtype max_writer_count: float
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.DBForPostgreSQL/servers/databases"  # type: str
        self.server = server
        self.database = database
        self.table = table
        self.user = user
        self.password = password
        self.max_writer_count = max_writer_count
        self.authentication_mode = authentication_mode


class PostgreSQLOutputDataSourceProperties(PostgreSQLDataSourceProperties):
    """The properties that are associated with a PostgreSQL output.

    :ivar server: The name of the SQL server containing the Azure SQL database. Required on PUT
     (CreateOrReplace) requests.
    :vartype server: str
    :ivar database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
    :vartype database: str
    :ivar table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace)
     requests.
    :vartype table: str
    :ivar user: The user name that will be used to connect to the Azure SQL database. Required on
     PUT (CreateOrReplace) requests.
    :vartype user: str
    :ivar password: The password that will be used to connect to the Azure SQL database. Required
     on PUT (CreateOrReplace) requests.
    :vartype password: str
    :ivar max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on query
     partition) are available. Optional on PUT requests.
    :vartype max_writer_count: float
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "user": {"key": "user", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "max_writer_count": {"key": "maxWriterCount", "type": "float"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        database: Optional[str] = None,
        table: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        max_writer_count: Optional[float] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword server: The name of the SQL server containing the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype server: str
        :keyword database: The name of the Azure SQL database. Required on PUT (CreateOrReplace)
         requests.
        :paramtype database: str
        :keyword table: The name of the table in the Azure SQL database. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword user: The user name that will be used to connect to the Azure SQL database. Required
         on PUT (CreateOrReplace) requests.
        :paramtype user: str
        :keyword password: The password that will be used to connect to the Azure SQL database.
         Required on PUT (CreateOrReplace) requests.
        :paramtype password: str
        :keyword max_writer_count: Max Writer count, currently only 1(single writer) and 0(based on
         query partition) are available. Optional on PUT requests.
        :paramtype max_writer_count: float
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(
            server=server,
            database=database,
            table=table,
            user=user,
            password=password,
            max_writer_count=max_writer_count,
            authentication_mode=authentication_mode,
            **kwargs
        )


class PowerBIOutputDataSource(OutputDataSource):
    """Describes a Power BI output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :vartype refresh_token: str
    :ivar token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :vartype token_user_principal_name: str
    :ivar token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :vartype token_user_display_name: str
    :ivar dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
    :vartype dataset: str
    :ivar table: The name of the Power BI table under the specified dataset. Required on PUT
     (CreateOrReplace) requests.
    :vartype table: str
    :ivar group_id: The ID of the Power BI group.
    :vartype group_id: str
    :ivar group_name: The name of the Power BI group. Use this property to help remember which
     specific Power BI group id was used.
    :vartype group_name: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "refresh_token": {"key": "properties.refreshToken", "type": "str"},
        "token_user_principal_name": {"key": "properties.tokenUserPrincipalName", "type": "str"},
        "token_user_display_name": {"key": "properties.tokenUserDisplayName", "type": "str"},
        "dataset": {"key": "properties.dataset", "type": "str"},
        "table": {"key": "properties.table", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "group_name": {"key": "properties.groupName", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        dataset: Optional[str] = None,
        table: Optional[str] = None,
        group_id: Optional[str] = None,
        group_name: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword refresh_token: A refresh token that can be used to obtain a valid access token that
         can then be used to authenticate with the data source. A valid refresh token is currently only
         obtainable via the Azure Portal. It is recommended to put a dummy string value here when
         creating the data source and then going to the Azure Portal to authenticate the data source
         which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
         requests.
        :paramtype refresh_token: str
        :keyword token_user_principal_name: The user principal name (UPN) of the user that was used to
         obtain the refresh token. Use this property to help remember which user was used to obtain the
         refresh token.
        :paramtype token_user_principal_name: str
        :keyword token_user_display_name: The user display name of the user that was used to obtain the
         refresh token. Use this property to help remember which user was used to obtain the refresh
         token.
        :paramtype token_user_display_name: str
        :keyword dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
        :paramtype dataset: str
        :keyword table: The name of the Power BI table under the specified dataset. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword group_id: The ID of the Power BI group.
        :paramtype group_id: str
        :keyword group_name: The name of the Power BI group. Use this property to help remember which
         specific Power BI group id was used.
        :paramtype group_name: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(**kwargs)
        self.type = "PowerBI"  # type: str
        self.refresh_token = refresh_token
        self.token_user_principal_name = token_user_principal_name
        self.token_user_display_name = token_user_display_name
        self.dataset = dataset
        self.table = table
        self.group_id = group_id
        self.group_name = group_name
        self.authentication_mode = authentication_mode


class PowerBIOutputDataSourceProperties(OAuthBasedDataSourceProperties):
    """The properties that are associated with a Power BI output.

    :ivar refresh_token: A refresh token that can be used to obtain a valid access token that can
     then be used to authenticate with the data source. A valid refresh token is currently only
     obtainable via the Azure Portal. It is recommended to put a dummy string value here when
     creating the data source and then going to the Azure Portal to authenticate the data source
     which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
     requests.
    :vartype refresh_token: str
    :ivar token_user_principal_name: The user principal name (UPN) of the user that was used to
     obtain the refresh token. Use this property to help remember which user was used to obtain the
     refresh token.
    :vartype token_user_principal_name: str
    :ivar token_user_display_name: The user display name of the user that was used to obtain the
     refresh token. Use this property to help remember which user was used to obtain the refresh
     token.
    :vartype token_user_display_name: str
    :ivar dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
    :vartype dataset: str
    :ivar table: The name of the Power BI table under the specified dataset. Required on PUT
     (CreateOrReplace) requests.
    :vartype table: str
    :ivar group_id: The ID of the Power BI group.
    :vartype group_id: str
    :ivar group_name: The name of the Power BI group. Use this property to help remember which
     specific Power BI group id was used.
    :vartype group_name: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    """

    _attribute_map = {
        "refresh_token": {"key": "refreshToken", "type": "str"},
        "token_user_principal_name": {"key": "tokenUserPrincipalName", "type": "str"},
        "token_user_display_name": {"key": "tokenUserDisplayName", "type": "str"},
        "dataset": {"key": "dataset", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "group_name": {"key": "groupName", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        refresh_token: Optional[str] = None,
        token_user_principal_name: Optional[str] = None,
        token_user_display_name: Optional[str] = None,
        dataset: Optional[str] = None,
        table: Optional[str] = None,
        group_id: Optional[str] = None,
        group_name: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        **kwargs
    ):
        """
        :keyword refresh_token: A refresh token that can be used to obtain a valid access token that
         can then be used to authenticate with the data source. A valid refresh token is currently only
         obtainable via the Azure Portal. It is recommended to put a dummy string value here when
         creating the data source and then going to the Azure Portal to authenticate the data source
         which will update this property with a valid refresh token. Required on PUT (CreateOrReplace)
         requests.
        :paramtype refresh_token: str
        :keyword token_user_principal_name: The user principal name (UPN) of the user that was used to
         obtain the refresh token. Use this property to help remember which user was used to obtain the
         refresh token.
        :paramtype token_user_principal_name: str
        :keyword token_user_display_name: The user display name of the user that was used to obtain the
         refresh token. Use this property to help remember which user was used to obtain the refresh
         token.
        :paramtype token_user_display_name: str
        :keyword dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
        :paramtype dataset: str
        :keyword table: The name of the Power BI table under the specified dataset. Required on PUT
         (CreateOrReplace) requests.
        :paramtype table: str
        :keyword group_id: The ID of the Power BI group.
        :paramtype group_id: str
        :keyword group_name: The name of the Power BI group. Use this property to help remember which
         specific Power BI group id was used.
        :paramtype group_name: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        """
        super().__init__(
            refresh_token=refresh_token,
            token_user_principal_name=token_user_principal_name,
            token_user_display_name=token_user_display_name,
            **kwargs
        )
        self.dataset = dataset
        self.table = table
        self.group_id = group_id
        self.group_name = group_name
        self.authentication_mode = authentication_mode


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class PrivateEndpoint(ProxyResource):
    """Complete information about the private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar properties: The properties associated with a private endpoint.
    :vartype properties: ~azure.mgmt.streamanalytics.models.PrivateEndpointProperties
    :ivar etag: Unique opaque string (generally a GUID) that represents the metadata state of the
     resource (private endpoint) and changes whenever the resource is updated. Required on PUT
     (CreateOrUpdate) requests.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointProperties"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateEndpointProperties"] = None, **kwargs):
        """
        :keyword properties: The properties associated with a private endpoint.
        :paramtype properties: ~azure.mgmt.streamanalytics.models.PrivateEndpointProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.etag = None


class PrivateEndpointListResult(_serialization.Model):
    """A list of private endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of private endpoints.
    :vartype value: list[~azure.mgmt.streamanalytics.models.PrivateEndpoint]
    :ivar next_link: The URL to fetch the next set of private endpoints.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointProperties(_serialization.Model):
    """The properties associated with a private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_date: The date when this private endpoint was created.
    :vartype created_date: str
    :ivar manual_private_link_service_connections: A list of connections to the remote resource.
     Immutable after it is set.
    :vartype manual_private_link_service_connections:
     list[~azure.mgmt.streamanalytics.models.PrivateLinkServiceConnection]
    """

    _validation = {
        "created_date": {"readonly": True},
    }

    _attribute_map = {
        "created_date": {"key": "createdDate", "type": "str"},
        "manual_private_link_service_connections": {
            "key": "manualPrivateLinkServiceConnections",
            "type": "[PrivateLinkServiceConnection]",
        },
    }

    def __init__(
        self,
        *,
        manual_private_link_service_connections: Optional[List["_models.PrivateLinkServiceConnection"]] = None,
        **kwargs
    ):
        """
        :keyword manual_private_link_service_connections: A list of connections to the remote resource.
         Immutable after it is set.
        :paramtype manual_private_link_service_connections:
         list[~azure.mgmt.streamanalytics.models.PrivateLinkServiceConnection]
        """
        super().__init__(**kwargs)
        self.created_date = None
        self.manual_private_link_service_connections = manual_private_link_service_connections


class PrivateLinkConnectionState(_serialization.Model):
    """A collection of read-only information about the state of the connection to the private remote resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the remote resource/service.
    :vartype status: str
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"readonly": True},
        "description": {"readonly": True},
        "actions_required": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.description = None
        self.actions_required = None


class PrivateLinkServiceConnection(_serialization.Model):
    """A grouping of information about the connection to the remote resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_link_service_id: The resource id of the private link service. Required on PUT
     (CreateOrUpdate) requests.
    :vartype private_link_service_id: str
    :ivar group_ids: The ID(s) of the group(s) obtained from the remote resource that this private
     endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
    :vartype group_ids: list[str]
    :ivar request_message: A message passed to the owner of the remote resource with this
     connection request. Restricted to 140 chars.
    :vartype request_message: str
    :ivar private_link_service_connection_state: A collection of read-only information about the
     state of the connection to the private remote resource.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.streamanalytics.models.PrivateLinkConnectionState
    """

    _validation = {
        "request_message": {"readonly": True},
    }

    _attribute_map = {
        "private_link_service_id": {"key": "properties.privateLinkServiceId", "type": "str"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "request_message": {"key": "properties.requestMessage", "type": "str"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_link_service_id: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_link_service_id: The resource id of the private link service. Required on PUT
         (CreateOrUpdate) requests.
        :paramtype private_link_service_id: str
        :keyword group_ids: The ID(s) of the group(s) obtained from the remote resource that this
         private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
        :paramtype group_ids: list[str]
        :keyword private_link_service_connection_state: A collection of read-only information about the
         state of the connection to the private remote resource.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.streamanalytics.models.PrivateLinkConnectionState
        """
        super().__init__(**kwargs)
        self.private_link_service_id = private_link_service_id
        self.group_ids = group_ids
        self.request_message = None
        self.private_link_service_connection_state = private_link_service_connection_state


class QueryCompilationError(_serialization.Model):
    """An error produced by the compiler.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: The content of the error message.
    :vartype message: str
    :ivar start_line: Describes the error location in the original query. Not set if isGlobal is
     true.
    :vartype start_line: int
    :ivar start_column: Describes the error location in the original query. Not set if isGlobal is
     true.
    :vartype start_column: int
    :ivar end_line: Describes the error location in the original query. Not set if isGlobal is
     true.
    :vartype end_line: int
    :ivar end_column: Describes the error location in the original query. Not set if isGlobal is
     true.
    :vartype end_column: int
    :ivar is_global: Whether the error is not for a specific part but for the entire query.
    :vartype is_global: bool
    """

    _validation = {
        "message": {"readonly": True},
        "start_line": {"readonly": True},
        "start_column": {"readonly": True},
        "end_line": {"readonly": True},
        "end_column": {"readonly": True},
        "is_global": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "start_line": {"key": "startLine", "type": "int"},
        "start_column": {"key": "startColumn", "type": "int"},
        "end_line": {"key": "endLine", "type": "int"},
        "end_column": {"key": "endColumn", "type": "int"},
        "is_global": {"key": "isGlobal", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.message = None
        self.start_line = None
        self.start_column = None
        self.end_line = None
        self.end_column = None
        self.is_global = None


class QueryCompilationResult(_serialization.Model):
    """The result of the query compilation request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar errors: Error messages produced by the compiler.
    :vartype errors: list[~azure.mgmt.streamanalytics.models.QueryCompilationError]
    :ivar warnings: Warning messages produced by the compiler.
    :vartype warnings: list[str]
    :ivar inputs: All input names used by the query.
    :vartype inputs: list[str]
    :ivar outputs: All output names used by the query.
    :vartype outputs: list[str]
    :ivar functions: All function names used by the query.
    :vartype functions: list[str]
    """

    _validation = {
        "errors": {"readonly": True},
        "warnings": {"readonly": True},
        "inputs": {"readonly": True},
        "outputs": {"readonly": True},
        "functions": {"readonly": True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[QueryCompilationError]"},
        "warnings": {"key": "warnings", "type": "[str]"},
        "inputs": {"key": "inputs", "type": "[str]"},
        "outputs": {"key": "outputs", "type": "[str]"},
        "functions": {"key": "functions", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.errors = None
        self.warnings = None
        self.inputs = None
        self.outputs = None
        self.functions = None


class QueryFunction(_serialization.Model):
    """A function for the query compilation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the function. Required.
    :vartype name: str
    :ivar type: The type of the function. Required.
    :vartype type: str
    :ivar binding_type: The type of the function binding. Required.
    :vartype binding_type: str
    :ivar inputs: The inputs for the function. Required.
    :vartype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
    :ivar output: An output for the function. Required.
    :vartype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "binding_type": {"required": True},
        "inputs": {"required": True},
        "output": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "binding_type": {"key": "bindingType", "type": "str"},
        "inputs": {"key": "inputs", "type": "[FunctionInput]"},
        "output": {"key": "output", "type": "FunctionOutput"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: str,
        binding_type: str,
        inputs: List["_models.FunctionInput"],
        output: "_models.FunctionOutput",
        **kwargs
    ):
        """
        :keyword name: The name of the function. Required.
        :paramtype name: str
        :keyword type: The type of the function. Required.
        :paramtype type: str
        :keyword binding_type: The type of the function binding. Required.
        :paramtype binding_type: str
        :keyword inputs: The inputs for the function. Required.
        :paramtype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
        :keyword output: An output for the function. Required.
        :paramtype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.binding_type = binding_type
        self.inputs = inputs
        self.output = output


class QueryInput(_serialization.Model):
    """An input for the query compilation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the input. Required.
    :vartype name: str
    :ivar type: The type of the input, can be Stream or Reference. Required.
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: str, **kwargs):
        """
        :keyword name: The name of the input. Required.
        :paramtype name: str
        :keyword type: The type of the input, can be Stream or Reference. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class QueryTestingResult(Error):
    """The result of the query testing request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error definition properties.
    :vartype error: ~azure.mgmt.streamanalytics.models.ErrorError
    :ivar status: The status of the query testing request. Known values are: "Started", "Success",
     "CompilerError", "RuntimeError", "Timeout", and "UnknownError".
    :vartype status: str or ~azure.mgmt.streamanalytics.models.QueryTestingResultStatus
    :ivar output_uri: The SAS URL to the outputs payload.
    :vartype output_uri: str
    """

    _validation = {
        "status": {"readonly": True},
        "output_uri": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorError"},
        "status": {"key": "status", "type": "str"},
        "output_uri": {"key": "outputUri", "type": "str"},
    }

    def __init__(self, *, error: Optional["_models.ErrorError"] = None, **kwargs):
        """
        :keyword error: Error definition properties.
        :paramtype error: ~azure.mgmt.streamanalytics.models.ErrorError
        """
        super().__init__(error=error, **kwargs)
        self.status = None
        self.output_uri = None


class RawOutputDatasource(OutputDataSource):
    """Describes a raw output data source. This data source type is only applicable/usable when using the query testing API. You cannot create a job with this data source type or add an output of this data source type to an existing job.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar payload_uri: The SAS URL to a blob where the output should be written. If this property
     is not set, output data will be written into a temporary storage, and a SAS URL to that
     temporary storage will be included in the result.
    :vartype payload_uri: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "payload_uri": {"key": "properties.payloadUri", "type": "str"},
    }

    def __init__(self, *, payload_uri: Optional[str] = None, **kwargs):
        """
        :keyword payload_uri: The SAS URL to a blob where the output should be written. If this
         property is not set, output data will be written into a temporary storage, and a SAS URL to
         that temporary storage will be included in the result.
        :paramtype payload_uri: str
        """
        super().__init__(**kwargs)
        self.type = "Raw"  # type: str
        self.payload_uri = payload_uri


class RawReferenceInputDataSource(ReferenceInputDataSource):
    """Describes a raw input data source that contains reference data. This data source type is only applicable/usable when using the query testing API. You cannot create a job with this data source type or add an input of this data source type to an existing job.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing reference data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar payload: The JSON serialized content of the input data. Either payload or payloadUri must
     be set, but not both.
    :vartype payload: str
    :ivar payload_uri: The SAS URL to a blob containing the JSON serialized content of the input
     data. Either payload or payloadUri must be set, but not both.
    :vartype payload_uri: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "payload": {"key": "properties.payload", "type": "str"},
        "payload_uri": {"key": "properties.payloadUri", "type": "str"},
    }

    def __init__(self, *, payload: Optional[str] = None, payload_uri: Optional[str] = None, **kwargs):
        """
        :keyword payload: The JSON serialized content of the input data. Either payload or payloadUri
         must be set, but not both.
        :paramtype payload: str
        :keyword payload_uri: The SAS URL to a blob containing the JSON serialized content of the input
         data. Either payload or payloadUri must be set, but not both.
        :paramtype payload_uri: str
        """
        super().__init__(**kwargs)
        self.type = "Raw"  # type: str
        self.payload = payload
        self.payload_uri = payload_uri


class RawStreamInputDataSource(StreamInputDataSource):
    """Describes a raw input data source that contains stream data. This data source type is only applicable/usable when using the query testing API. You cannot create a job with this data source type or add an input of this data source type to an existing job.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of input data source containing stream data. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar payload: The JSON serialized content of the input data. Either payload or payloadUri must
     be set, but not both.
    :vartype payload: str
    :ivar payload_uri: The SAS URL to a blob containing the JSON serialized content of the input
     data. Either payload or payloadUri must be set, but not both.
    :vartype payload_uri: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "payload": {"key": "properties.payload", "type": "str"},
        "payload_uri": {"key": "properties.payloadUri", "type": "str"},
    }

    def __init__(self, *, payload: Optional[str] = None, payload_uri: Optional[str] = None, **kwargs):
        """
        :keyword payload: The JSON serialized content of the input data. Either payload or payloadUri
         must be set, but not both.
        :paramtype payload: str
        :keyword payload_uri: The SAS URL to a blob containing the JSON serialized content of the input
         data. Either payload or payloadUri must be set, but not both.
        :paramtype payload_uri: str
        """
        super().__init__(**kwargs)
        self.type = "Raw"  # type: str
        self.payload = payload
        self.payload_uri = payload_uri


class ReferenceInputProperties(InputProperties):
    """The properties that are associated with an input containing reference data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates whether the input is a source of reference data or stream data. Required
     on PUT (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :vartype serialization: ~azure.mgmt.streamanalytics.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~azure.mgmt.streamanalytics.models.Diagnostics
    :ivar etag: The current entity tag for the input. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar compression: Describes how input data is compressed.
    :vartype compression: ~azure.mgmt.streamanalytics.models.Compression
    :ivar partition_key: partitionKey Describes a key in the input data which is used for
     partitioning the input data.
    :vartype partition_key: str
    :ivar watermark_settings: Settings which determine whether to read watermark events.
    :vartype watermark_settings: ~azure.mgmt.streamanalytics.models.InputWatermarkProperties
    :ivar datasource: Describes an input data source that contains reference data. Required on PUT
     (CreateOrReplace) requests.
    :vartype datasource: ~azure.mgmt.streamanalytics.models.ReferenceInputDataSource
    """

    _validation = {
        "type": {"required": True},
        "diagnostics": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "serialization": {"key": "serialization", "type": "Serialization"},
        "diagnostics": {"key": "diagnostics", "type": "Diagnostics"},
        "etag": {"key": "etag", "type": "str"},
        "compression": {"key": "compression", "type": "Compression"},
        "partition_key": {"key": "partitionKey", "type": "str"},
        "watermark_settings": {"key": "watermarkSettings", "type": "InputWatermarkProperties"},
        "datasource": {"key": "datasource", "type": "ReferenceInputDataSource"},
    }

    def __init__(
        self,
        *,
        serialization: Optional["_models.Serialization"] = None,
        compression: Optional["_models.Compression"] = None,
        partition_key: Optional[str] = None,
        watermark_settings: Optional["_models.InputWatermarkProperties"] = None,
        datasource: Optional["_models.ReferenceInputDataSource"] = None,
        **kwargs
    ):
        """
        :keyword serialization: Describes how data from an input is serialized or how data is
         serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        :paramtype serialization: ~azure.mgmt.streamanalytics.models.Serialization
        :keyword compression: Describes how input data is compressed.
        :paramtype compression: ~azure.mgmt.streamanalytics.models.Compression
        :keyword partition_key: partitionKey Describes a key in the input data which is used for
         partitioning the input data.
        :paramtype partition_key: str
        :keyword watermark_settings: Settings which determine whether to read watermark events.
        :paramtype watermark_settings: ~azure.mgmt.streamanalytics.models.InputWatermarkProperties
        :keyword datasource: Describes an input data source that contains reference data. Required on
         PUT (CreateOrReplace) requests.
        :paramtype datasource: ~azure.mgmt.streamanalytics.models.ReferenceInputDataSource
        """
        super().__init__(
            serialization=serialization,
            compression=compression,
            partition_key=partition_key,
            watermark_settings=watermark_settings,
            **kwargs
        )
        self.type = "Reference"  # type: str
        self.datasource = datasource


class RefreshConfiguration(_serialization.Model):
    """The refresh parameters for any/all updatable user defined functions present in the job config.

    :ivar path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
     against which blob names will be matched to determine whether or not they should be included as
     input or output to the job. See
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
     https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
     detailed explanation and example.
    :vartype path_pattern: str
    :ivar date_format: The date format. Wherever {date} appears in pathPattern, the value of this
     property is used as the date format instead.
    :vartype date_format: str
    :ivar time_format: The time format. Wherever {time} appears in pathPattern, the value of this
     property is used as the time format instead.
    :vartype time_format: str
    :ivar refresh_interval: The refresh interval.
    :vartype refresh_interval: str
    :ivar refresh_type: This property indicates which data refresh option to use, Blocking or
     Nonblocking. Known values are: "Blocking" and "Nonblocking".
    :vartype refresh_type: str or ~azure.mgmt.streamanalytics.models.UpdatableUdfRefreshType
    """

    _attribute_map = {
        "path_pattern": {"key": "pathPattern", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "str"},
        "time_format": {"key": "timeFormat", "type": "str"},
        "refresh_interval": {"key": "refreshInterval", "type": "str"},
        "refresh_type": {"key": "refreshType", "type": "str"},
    }

    def __init__(
        self,
        *,
        path_pattern: Optional[str] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        refresh_interval: Optional[str] = None,
        refresh_type: Optional[Union[str, "_models.UpdatableUdfRefreshType"]] = None,
        **kwargs
    ):
        """
        :keyword path_pattern: The blob path pattern. Not a regular expression. It represents a pattern
         against which blob names will be matched to determine whether or not they should be included as
         input or output to the job. See
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or
         https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more
         detailed explanation and example.
        :paramtype path_pattern: str
        :keyword date_format: The date format. Wherever {date} appears in pathPattern, the value of
         this property is used as the date format instead.
        :paramtype date_format: str
        :keyword time_format: The time format. Wherever {time} appears in pathPattern, the value of
         this property is used as the time format instead.
        :paramtype time_format: str
        :keyword refresh_interval: The refresh interval.
        :paramtype refresh_interval: str
        :keyword refresh_type: This property indicates which data refresh option to use, Blocking or
         Nonblocking. Known values are: "Blocking" and "Nonblocking".
        :paramtype refresh_type: str or ~azure.mgmt.streamanalytics.models.UpdatableUdfRefreshType
        """
        super().__init__(**kwargs)
        self.path_pattern = path_pattern
        self.date_format = date_format
        self.time_format = time_format
        self.refresh_interval = refresh_interval
        self.refresh_type = refresh_type


class ResourceTestStatus(_serialization.Model):
    """Describes the status of the test operation along with error information, if applicable.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the test operation.
    :vartype status: str
    :ivar error: Describes the error that occurred.
    :vartype error: ~azure.mgmt.streamanalytics.models.ErrorResponse
    """

    _validation = {
        "status": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.error = None


class SampleInput(_serialization.Model):
    """The stream analytics input to sample.

    :ivar input: The stream analytics input to sample.
    :vartype input: ~azure.mgmt.streamanalytics.models.Input
    :ivar compatibility_level: Defaults to the default ASA job compatibility level. Today it is
     1.2.
    :vartype compatibility_level: str
    :ivar events_uri: The SAS URI of the storage blob for service to write the sampled events to.
     If this parameter is not provided, service will write events to he system account and share a
     temporary SAS URI to it.
    :vartype events_uri: str
    :ivar data_locale: Defaults to en-US.
    :vartype data_locale: str
    """

    _attribute_map = {
        "input": {"key": "input", "type": "Input"},
        "compatibility_level": {"key": "compatibilityLevel", "type": "str"},
        "events_uri": {"key": "eventsUri", "type": "str"},
        "data_locale": {"key": "dataLocale", "type": "str"},
    }

    def __init__(
        self,
        *,
        input: Optional["_models.Input"] = None,
        compatibility_level: Optional[str] = None,
        events_uri: Optional[str] = None,
        data_locale: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword input: The stream analytics input to sample.
        :paramtype input: ~azure.mgmt.streamanalytics.models.Input
        :keyword compatibility_level: Defaults to the default ASA job compatibility level. Today it is
         1.2.
        :paramtype compatibility_level: str
        :keyword events_uri: The SAS URI of the storage blob for service to write the sampled events
         to. If this parameter is not provided, service will write events to he system account and share
         a temporary SAS URI to it.
        :paramtype events_uri: str
        :keyword data_locale: Defaults to en-US.
        :paramtype data_locale: str
        """
        super().__init__(**kwargs)
        self.input = input
        self.compatibility_level = compatibility_level
        self.events_uri = events_uri
        self.data_locale = data_locale


class SampleInputResult(Error):
    """The result of the sample input request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error definition properties.
    :vartype error: ~azure.mgmt.streamanalytics.models.ErrorError
    :ivar status: The status of the sample input request. Known values are: "ReadAllEventsInRange",
     "NoEventsFoundInRange", and "ErrorConnectingToInput".
    :vartype status: str or ~azure.mgmt.streamanalytics.models.SampleInputResultStatus
    :ivar diagnostics: Diagnostics messages. E.g. message indicating some partitions from the input
     have no data.
    :vartype diagnostics: list[str]
    :ivar events_download_url: A SAS URL to download the sampled input data.
    :vartype events_download_url: str
    :ivar last_arrival_time: The timestamp for the last event in the data. It is in DateTime
     format.
    :vartype last_arrival_time: str
    """

    _validation = {
        "status": {"readonly": True},
        "diagnostics": {"readonly": True},
        "events_download_url": {"readonly": True},
        "last_arrival_time": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorError"},
        "status": {"key": "status", "type": "str"},
        "diagnostics": {"key": "diagnostics", "type": "[str]"},
        "events_download_url": {"key": "eventsDownloadUrl", "type": "str"},
        "last_arrival_time": {"key": "lastArrivalTime", "type": "str"},
    }

    def __init__(self, *, error: Optional["_models.ErrorError"] = None, **kwargs):
        """
        :keyword error: Error definition properties.
        :paramtype error: ~azure.mgmt.streamanalytics.models.ErrorError
        """
        super().__init__(error=error, **kwargs)
        self.status = None
        self.diagnostics = None
        self.events_download_url = None
        self.last_arrival_time = None


class ScalarFunctionProperties(FunctionProperties):
    """The properties that are associated with a scalar function.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of function. Required.
    :vartype type: str
    :ivar etag: The current entity tag for the function. This is an opaque string. You can use it
     to detect whether the resource has changed between requests. You can also use it in the
     If-Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar inputs:
    :vartype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
    :ivar output: Describes the output of a function.
    :vartype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
    :ivar binding: The physical binding of the function. For example, in the Azure Machine Learning
     web service’s case, this describes the endpoint.
    :vartype binding: ~azure.mgmt.streamanalytics.models.FunctionBinding
    """

    _validation = {
        "type": {"required": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "inputs": {"key": "properties.inputs", "type": "[FunctionInput]"},
        "output": {"key": "properties.output", "type": "FunctionOutput"},
        "binding": {"key": "properties.binding", "type": "FunctionBinding"},
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["_models.FunctionInput"]] = None,
        output: Optional["_models.FunctionOutput"] = None,
        binding: Optional["_models.FunctionBinding"] = None,
        **kwargs
    ):
        """
        :keyword inputs:
        :paramtype inputs: list[~azure.mgmt.streamanalytics.models.FunctionInput]
        :keyword output: Describes the output of a function.
        :paramtype output: ~azure.mgmt.streamanalytics.models.FunctionOutput
        :keyword binding: The physical binding of the function. For example, in the Azure Machine
         Learning web service’s case, this describes the endpoint.
        :paramtype binding: ~azure.mgmt.streamanalytics.models.FunctionBinding
        """
        super().__init__(inputs=inputs, output=output, binding=binding, **kwargs)
        self.type = "Scalar"  # type: str


class ScaleStreamingJobParameters(_serialization.Model):
    """Parameters supplied to the Scale Streaming Job operation.

    :ivar streaming_units: Specifies the number of streaming units that the streaming job will
     scale to.
    :vartype streaming_units: int
    """

    _attribute_map = {
        "streaming_units": {"key": "streamingUnits", "type": "int"},
    }

    def __init__(self, *, streaming_units: Optional[int] = None, **kwargs):
        """
        :keyword streaming_units: Specifies the number of streaming units that the streaming job will
         scale to.
        :paramtype streaming_units: int
        """
        super().__init__(**kwargs)
        self.streaming_units = streaming_units


class ServiceBusQueueOutputDataSource(OutputDataSource):
    """Describes a Service Bus Queue output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace)
     requests.
    :vartype queue_name: str
    :ivar property_columns: A string array of the names of output columns to be attached to Service
     Bus messages as custom properties.
    :vartype property_columns: list[str]
    :ivar system_property_columns: The system properties associated with the Service Bus Queue. The
     following system properties are supported: ReplyToSessionId, ContentType, To, Subject,
     CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo,
     Label, ScheduledEnqueueTimeUtc.
    :vartype system_property_columns: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "properties.sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "properties.sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "queue_name": {"key": "properties.queueName", "type": "str"},
        "property_columns": {"key": "properties.propertyColumns", "type": "[str]"},
        "system_property_columns": {"key": "properties.systemPropertyColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        queue_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace)
         requests.
        :paramtype queue_name: str
        :keyword property_columns: A string array of the names of output columns to be attached to
         Service Bus messages as custom properties.
        :paramtype property_columns: list[str]
        :keyword system_property_columns: The system properties associated with the Service Bus Queue.
         The following system properties are supported: ReplyToSessionId, ContentType, To, Subject,
         CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo,
         Label, ScheduledEnqueueTimeUtc.
        :paramtype system_property_columns: JSON
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.ServiceBus/Queue"  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.queue_name = queue_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class ServiceBusQueueOutputDataSourceProperties(ServiceBusDataSourceProperties):
    """The properties that are associated with a Service Bus Queue output.

    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace)
     requests.
    :vartype queue_name: str
    :ivar property_columns: A string array of the names of output columns to be attached to Service
     Bus messages as custom properties.
    :vartype property_columns: list[str]
    :ivar system_property_columns: The system properties associated with the Service Bus Queue. The
     following system properties are supported: ReplyToSessionId, ContentType, To, Subject,
     CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo,
     Label, ScheduledEnqueueTimeUtc.
    :vartype system_property_columns: JSON
    """

    _attribute_map = {
        "service_bus_namespace": {"key": "serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "queue_name": {"key": "queueName", "type": "str"},
        "property_columns": {"key": "propertyColumns", "type": "[str]"},
        "system_property_columns": {"key": "systemPropertyColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        queue_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace)
         requests.
        :paramtype queue_name: str
        :keyword property_columns: A string array of the names of output columns to be attached to
         Service Bus messages as custom properties.
        :paramtype property_columns: list[str]
        :keyword system_property_columns: The system properties associated with the Service Bus Queue.
         The following system properties are supported: ReplyToSessionId, ContentType, To, Subject,
         CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo,
         Label, ScheduledEnqueueTimeUtc.
        :paramtype system_property_columns: JSON
        """
        super().__init__(
            service_bus_namespace=service_bus_namespace,
            shared_access_policy_name=shared_access_policy_name,
            shared_access_policy_key=shared_access_policy_key,
            authentication_mode=authentication_mode,
            **kwargs
        )
        self.queue_name = queue_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class ServiceBusTopicOutputDataSource(OutputDataSource):
    """Describes a Service Bus Topic output data source.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates the type of data source output will be written to. Required on PUT
     (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace)
     requests.
    :vartype topic_name: str
    :ivar property_columns: A string array of the names of output columns to be attached to Service
     Bus messages as custom properties.
    :vartype property_columns: list[str]
    :ivar system_property_columns: The system properties associated with the Service Bus Topic
     Output. The following system properties are supported: ReplyToSessionId, ContentType, To,
     Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId,
     ReplyTo, Label, ScheduledEnqueueTimeUtc.
    :vartype system_property_columns: dict[str, str]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "properties.sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "properties.sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "properties.authenticationMode", "type": "str"},
        "topic_name": {"key": "properties.topicName", "type": "str"},
        "property_columns": {"key": "properties.propertyColumns", "type": "[str]"},
        "system_property_columns": {"key": "properties.systemPropertyColumns", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        topic_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace)
         requests.
        :paramtype topic_name: str
        :keyword property_columns: A string array of the names of output columns to be attached to
         Service Bus messages as custom properties.
        :paramtype property_columns: list[str]
        :keyword system_property_columns: The system properties associated with the Service Bus Topic
         Output. The following system properties are supported: ReplyToSessionId, ContentType, To,
         Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId,
         ReplyTo, Label, ScheduledEnqueueTimeUtc.
        :paramtype system_property_columns: dict[str, str]
        """
        super().__init__(**kwargs)
        self.type = "Microsoft.ServiceBus/Topic"  # type: str
        self.service_bus_namespace = service_bus_namespace
        self.shared_access_policy_name = shared_access_policy_name
        self.shared_access_policy_key = shared_access_policy_key
        self.authentication_mode = authentication_mode
        self.topic_name = topic_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class ServiceBusTopicOutputDataSourceProperties(ServiceBusDataSourceProperties):
    """The properties that are associated with a Service Bus Topic output.

    :ivar service_bus_namespace: The namespace that is associated with the desired Event Hub,
     Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype service_bus_namespace: str
    :ivar shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus
     Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_name: str
    :ivar shared_access_policy_key: The shared access policy key for the specified shared access
     policy. Required on PUT (CreateOrReplace) requests.
    :vartype shared_access_policy_key: str
    :ivar authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
     "ConnectionString".
    :vartype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
    :ivar topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace)
     requests.
    :vartype topic_name: str
    :ivar property_columns: A string array of the names of output columns to be attached to Service
     Bus messages as custom properties.
    :vartype property_columns: list[str]
    :ivar system_property_columns: The system properties associated with the Service Bus Topic
     Output. The following system properties are supported: ReplyToSessionId, ContentType, To,
     Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId,
     ReplyTo, Label, ScheduledEnqueueTimeUtc.
    :vartype system_property_columns: dict[str, str]
    """

    _attribute_map = {
        "service_bus_namespace": {"key": "serviceBusNamespace", "type": "str"},
        "shared_access_policy_name": {"key": "sharedAccessPolicyName", "type": "str"},
        "shared_access_policy_key": {"key": "sharedAccessPolicyKey", "type": "str"},
        "authentication_mode": {"key": "authenticationMode", "type": "str"},
        "topic_name": {"key": "topicName", "type": "str"},
        "property_columns": {"key": "propertyColumns", "type": "[str]"},
        "system_property_columns": {"key": "systemPropertyColumns", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        service_bus_namespace: Optional[str] = None,
        shared_access_policy_name: Optional[str] = None,
        shared_access_policy_key: Optional[str] = None,
        authentication_mode: Union[str, "_models.AuthenticationMode"] = "ConnectionString",
        topic_name: Optional[str] = None,
        property_columns: Optional[List[str]] = None,
        system_property_columns: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword service_bus_namespace: The namespace that is associated with the desired Event Hub,
         Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype service_bus_namespace: str
        :keyword shared_access_policy_name: The shared access policy name for the Event Hub, Service
         Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_name: str
        :keyword shared_access_policy_key: The shared access policy key for the specified shared access
         policy. Required on PUT (CreateOrReplace) requests.
        :paramtype shared_access_policy_key: str
        :keyword authentication_mode: Authentication Mode. Known values are: "Msi", "UserToken", and
         "ConnectionString".
        :paramtype authentication_mode: str or ~azure.mgmt.streamanalytics.models.AuthenticationMode
        :keyword topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace)
         requests.
        :paramtype topic_name: str
        :keyword property_columns: A string array of the names of output columns to be attached to
         Service Bus messages as custom properties.
        :paramtype property_columns: list[str]
        :keyword system_property_columns: The system properties associated with the Service Bus Topic
         Output. The following system properties are supported: ReplyToSessionId, ContentType, To,
         Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId,
         ReplyTo, Label, ScheduledEnqueueTimeUtc.
        :paramtype system_property_columns: dict[str, str]
        """
        super().__init__(
            service_bus_namespace=service_bus_namespace,
            shared_access_policy_name=shared_access_policy_name,
            shared_access_policy_key=shared_access_policy_key,
            authentication_mode=authentication_mode,
            **kwargs
        )
        self.topic_name = topic_name
        self.property_columns = property_columns
        self.system_property_columns = system_property_columns


class Sku(_serialization.Model):
    """The properties that are associated with a SKU.

    :ivar name: The name of the SKU. Required on PUT (CreateOrReplace) requests. "Standard"
    :vartype name: str or ~azure.mgmt.streamanalytics.models.SkuName
    :ivar capacity: The capacity of the SKU.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.SkuName"]] = None, capacity: Optional[int] = None, **kwargs
    ):
        """
        :keyword name: The name of the SKU. Required on PUT (CreateOrReplace) requests. "Standard"
        :paramtype name: str or ~azure.mgmt.streamanalytics.models.SkuName
        :keyword capacity: The capacity of the SKU.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class SkuCapacity(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: Specifies the minimum streaming units that the streaming job can use.
    :vartype minimum: int
    :ivar maximum: Specifies the maximum streaming units that the streaming job can use.
    :vartype maximum: int
    :ivar default: Specifies the default streaming units that the streaming job can use.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the SKU. Known values are: "automatic",
     "manual", and "none".
    :vartype scale_type: str or ~azure.mgmt.streamanalytics.models.SkuCapacityScaleType
    :ivar allowed_values: Specifies the valid streaming units a streaming job can scale to.
    :vartype allowed_values: list[int]
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default": {"readonly": True},
        "scale_type": {"readonly": True},
        "allowed_values": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
        "allowed_values": {"key": "allowedValues", "type": "[int]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None
        self.allowed_values = None


class StartStreamingJobParameters(_serialization.Model):
    """Parameters supplied to the Start Streaming Job operation.

    :ivar output_start_mode: Value may be JobStartTime, CustomTime, or LastOutputEventTime to
     indicate whether the starting point of the output event stream should start whenever the job is
     started, start at a custom user time stamp specified via the outputStartTime property, or start
     from the last event output time. Known values are: "JobStartTime", "CustomTime", and
     "LastOutputEventTime".
    :vartype output_start_mode: str or ~azure.mgmt.streamanalytics.models.OutputStartMode
    :ivar output_start_time: Value is either an ISO-8601 formatted time stamp that indicates the
     starting point of the output event stream, or null to indicate that the output event stream
     will start whenever the streaming job is started. This property must have a value if
     outputStartMode is set to CustomTime.
    :vartype output_start_time: ~datetime.datetime
    """

    _attribute_map = {
        "output_start_mode": {"key": "outputStartMode", "type": "str"},
        "output_start_time": {"key": "outputStartTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        output_start_mode: Optional[Union[str, "_models.OutputStartMode"]] = None,
        output_start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword output_start_mode: Value may be JobStartTime, CustomTime, or LastOutputEventTime to
         indicate whether the starting point of the output event stream should start whenever the job is
         started, start at a custom user time stamp specified via the outputStartTime property, or start
         from the last event output time. Known values are: "JobStartTime", "CustomTime", and
         "LastOutputEventTime".
        :paramtype output_start_mode: str or ~azure.mgmt.streamanalytics.models.OutputStartMode
        :keyword output_start_time: Value is either an ISO-8601 formatted time stamp that indicates the
         starting point of the output event stream, or null to indicate that the output event stream
         will start whenever the streaming job is started. This property must have a value if
         outputStartMode is set to CustomTime.
        :paramtype output_start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.output_start_mode = output_start_mode
        self.output_start_time = output_start_time


class StreamingJob(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A streaming job object, containing all information associated with the named streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar sku: Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
    :vartype sku: ~azure.mgmt.streamanalytics.models.Sku
    :ivar identity: Describes the managed identity assigned to this job that can be used to
     authenticate with inputs and outputs.
    :vartype identity: ~azure.mgmt.streamanalytics.models.Identity
    :ivar sku_properties_sku: Describes the SKU of the streaming job. Required on PUT
     (CreateOrReplace) requests.
    :vartype sku_properties_sku: ~azure.mgmt.streamanalytics.models.Sku
    :ivar job_id: A GUID uniquely identifying the streaming job. This GUID is generated upon
     creation of the streaming job.
    :vartype job_id: str
    :ivar provisioning_state: Describes the provisioning status of the streaming job.
    :vartype provisioning_state: str
    :ivar job_state: Describes the state of the streaming job.
    :vartype job_state: str
    :ivar job_type: Describes the type of the job. Valid modes are ``Cloud`` and 'Edge'. Known
     values are: "Cloud" and "Edge".
    :vartype job_type: str or ~azure.mgmt.streamanalytics.models.JobType
    :ivar output_start_mode: This property should only be utilized when it is desired that the job
     be started immediately upon creation. Value may be JobStartTime, CustomTime, or
     LastOutputEventTime to indicate whether the starting point of the output event stream should
     start whenever the job is started, start at a custom user time stamp specified via the
     outputStartTime property, or start from the last event output time. Known values are:
     "JobStartTime", "CustomTime", and "LastOutputEventTime".
    :vartype output_start_mode: str or ~azure.mgmt.streamanalytics.models.OutputStartMode
    :ivar output_start_time: Value is either an ISO-8601 formatted time stamp that indicates the
     starting point of the output event stream, or null to indicate that the output event stream
     will start whenever the streaming job is started. This property must have a value if
     outputStartMode is set to CustomTime.
    :vartype output_start_time: ~datetime.datetime
    :ivar last_output_event_time: Value is either an ISO-8601 formatted timestamp indicating the
     last output event time of the streaming job or null indicating that output has not yet been
     produced. In case of multiple outputs or multiple streams, this shows the latest value in that
     set.
    :vartype last_output_event_time: ~datetime.datetime
    :ivar events_out_of_order_policy: Indicates the policy to apply to events that arrive out of
     order in the input event stream. Known values are: "Adjust" and "Drop".
    :vartype events_out_of_order_policy: str or
     ~azure.mgmt.streamanalytics.models.EventsOutOfOrderPolicy
    :ivar output_error_policy: Indicates the policy to apply to events that arrive at the output
     and cannot be written to the external storage due to being malformed (missing column values,
     column values of wrong type or size). Known values are: "Stop" and "Drop".
    :vartype output_error_policy: str or ~azure.mgmt.streamanalytics.models.OutputErrorPolicy
    :ivar events_out_of_order_max_delay_in_seconds: The maximum tolerable delay in seconds where
     out-of-order events can be adjusted to be back in order.
    :vartype events_out_of_order_max_delay_in_seconds: int
    :ivar events_late_arrival_max_delay_in_seconds: The maximum tolerable delay in seconds where
     events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days)
     and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to
     have a value of -1.
    :vartype events_late_arrival_max_delay_in_seconds: int
    :ivar data_locale: The data locale of the stream analytics job. Value should be the name of a
     supported .NET Culture from the set
     https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx.
     Defaults to 'en-US' if none specified.
    :vartype data_locale: str
    :ivar compatibility_level: Controls certain runtime behaviors of the streaming job. Known
     values are: "1.0" and "1.2".
    :vartype compatibility_level: str or ~azure.mgmt.streamanalytics.models.CompatibilityLevel
    :ivar created_date: Value is an ISO-8601 formatted UTC timestamp indicating when the streaming
     job was created.
    :vartype created_date: ~datetime.datetime
    :ivar inputs: A list of one or more inputs to the streaming job. The name property for each
     input is required when specifying this property in a PUT request. This property cannot be
     modify via a PATCH operation. You must use the PATCH API available for the individual input.
    :vartype inputs: list[~azure.mgmt.streamanalytics.models.Input]
    :ivar transformation: Indicates the query and the number of streaming units to use for the
     streaming job. The name property of the transformation is required when specifying this
     property in a PUT request. This property cannot be modify via a PATCH operation. You must use
     the PATCH API available for the individual transformation.
    :vartype transformation: ~azure.mgmt.streamanalytics.models.Transformation
    :ivar outputs: A list of one or more outputs for the streaming job. The name property for each
     output is required when specifying this property in a PUT request. This property cannot be
     modify via a PATCH operation. You must use the PATCH API available for the individual output.
    :vartype outputs: list[~azure.mgmt.streamanalytics.models.Output]
    :ivar functions: A list of one or more functions for the streaming job. The name property for
     each function is required when specifying this property in a PUT request. This property cannot
     be modify via a PATCH operation. You must use the PATCH API available for the individual
     transformation.
    :vartype functions: list[~azure.mgmt.streamanalytics.models.Function]
    :ivar etag: The current entity tag for the streaming job. This is an opaque string. You can use
     it to detect whether the resource has changed between requests. You can also use it in the
     If-Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar job_storage_account: The properties that are associated with an Azure Storage account
     with MSI.
    :vartype job_storage_account: ~azure.mgmt.streamanalytics.models.JobStorageAccount
    :ivar content_storage_policy: Valid values are JobStorageAccount and SystemAccount. If set to
     JobStorageAccount, this requires the user to also specify jobStorageAccount property. . Known
     values are: "SystemAccount" and "JobStorageAccount".
    :vartype content_storage_policy: str or ~azure.mgmt.streamanalytics.models.ContentStoragePolicy
    :ivar externals: The storage account where the custom code artifacts are located.
    :vartype externals: ~azure.mgmt.streamanalytics.models.External
    :ivar cluster: The cluster which streaming jobs will run on.
    :vartype cluster: ~azure.mgmt.streamanalytics.models.ClusterInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "job_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "job_state": {"readonly": True},
        "last_output_event_time": {"readonly": True},
        "created_date": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "sku_properties_sku": {"key": "properties.sku", "type": "Sku"},
        "job_id": {"key": "properties.jobId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "job_state": {"key": "properties.jobState", "type": "str"},
        "job_type": {"key": "properties.jobType", "type": "str"},
        "output_start_mode": {"key": "properties.outputStartMode", "type": "str"},
        "output_start_time": {"key": "properties.outputStartTime", "type": "iso-8601"},
        "last_output_event_time": {"key": "properties.lastOutputEventTime", "type": "iso-8601"},
        "events_out_of_order_policy": {"key": "properties.eventsOutOfOrderPolicy", "type": "str"},
        "output_error_policy": {"key": "properties.outputErrorPolicy", "type": "str"},
        "events_out_of_order_max_delay_in_seconds": {
            "key": "properties.eventsOutOfOrderMaxDelayInSeconds",
            "type": "int",
        },
        "events_late_arrival_max_delay_in_seconds": {
            "key": "properties.eventsLateArrivalMaxDelayInSeconds",
            "type": "int",
        },
        "data_locale": {"key": "properties.dataLocale", "type": "str"},
        "compatibility_level": {"key": "properties.compatibilityLevel", "type": "str"},
        "created_date": {"key": "properties.createdDate", "type": "iso-8601"},
        "inputs": {"key": "properties.inputs", "type": "[Input]"},
        "transformation": {"key": "properties.transformation", "type": "Transformation"},
        "outputs": {"key": "properties.outputs", "type": "[Output]"},
        "functions": {"key": "properties.functions", "type": "[Function]"},
        "etag": {"key": "properties.etag", "type": "str"},
        "job_storage_account": {"key": "properties.jobStorageAccount", "type": "JobStorageAccount"},
        "content_storage_policy": {"key": "properties.contentStoragePolicy", "type": "str"},
        "externals": {"key": "properties.externals", "type": "External"},
        "cluster": {"key": "properties.cluster", "type": "ClusterInfo"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        sku_properties_sku: Optional["_models.Sku"] = None,
        job_type: Optional[Union[str, "_models.JobType"]] = None,
        output_start_mode: Optional[Union[str, "_models.OutputStartMode"]] = None,
        output_start_time: Optional[datetime.datetime] = None,
        events_out_of_order_policy: Optional[Union[str, "_models.EventsOutOfOrderPolicy"]] = None,
        output_error_policy: Optional[Union[str, "_models.OutputErrorPolicy"]] = None,
        events_out_of_order_max_delay_in_seconds: Optional[int] = None,
        events_late_arrival_max_delay_in_seconds: Optional[int] = None,
        data_locale: Optional[str] = None,
        compatibility_level: Optional[Union[str, "_models.CompatibilityLevel"]] = None,
        inputs: Optional[List["_models.Input"]] = None,
        transformation: Optional["_models.Transformation"] = None,
        outputs: Optional[List["_models.Output"]] = None,
        functions: Optional[List["_models.Function"]] = None,
        job_storage_account: Optional["_models.JobStorageAccount"] = None,
        content_storage_policy: Optional[Union[str, "_models.ContentStoragePolicy"]] = None,
        externals: Optional["_models.External"] = None,
        cluster: Optional["_models.ClusterInfo"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword sku: Describes the SKU of the streaming job. Required on PUT (CreateOrReplace)
         requests.
        :paramtype sku: ~azure.mgmt.streamanalytics.models.Sku
        :keyword identity: Describes the managed identity assigned to this job that can be used to
         authenticate with inputs and outputs.
        :paramtype identity: ~azure.mgmt.streamanalytics.models.Identity
        :keyword sku_properties_sku: Describes the SKU of the streaming job. Required on PUT
         (CreateOrReplace) requests.
        :paramtype sku_properties_sku: ~azure.mgmt.streamanalytics.models.Sku
        :keyword job_type: Describes the type of the job. Valid modes are ``Cloud`` and 'Edge'. Known
         values are: "Cloud" and "Edge".
        :paramtype job_type: str or ~azure.mgmt.streamanalytics.models.JobType
        :keyword output_start_mode: This property should only be utilized when it is desired that the
         job be started immediately upon creation. Value may be JobStartTime, CustomTime, or
         LastOutputEventTime to indicate whether the starting point of the output event stream should
         start whenever the job is started, start at a custom user time stamp specified via the
         outputStartTime property, or start from the last event output time. Known values are:
         "JobStartTime", "CustomTime", and "LastOutputEventTime".
        :paramtype output_start_mode: str or ~azure.mgmt.streamanalytics.models.OutputStartMode
        :keyword output_start_time: Value is either an ISO-8601 formatted time stamp that indicates the
         starting point of the output event stream, or null to indicate that the output event stream
         will start whenever the streaming job is started. This property must have a value if
         outputStartMode is set to CustomTime.
        :paramtype output_start_time: ~datetime.datetime
        :keyword events_out_of_order_policy: Indicates the policy to apply to events that arrive out of
         order in the input event stream. Known values are: "Adjust" and "Drop".
        :paramtype events_out_of_order_policy: str or
         ~azure.mgmt.streamanalytics.models.EventsOutOfOrderPolicy
        :keyword output_error_policy: Indicates the policy to apply to events that arrive at the output
         and cannot be written to the external storage due to being malformed (missing column values,
         column values of wrong type or size). Known values are: "Stop" and "Drop".
        :paramtype output_error_policy: str or ~azure.mgmt.streamanalytics.models.OutputErrorPolicy
        :keyword events_out_of_order_max_delay_in_seconds: The maximum tolerable delay in seconds where
         out-of-order events can be adjusted to be back in order.
        :paramtype events_out_of_order_max_delay_in_seconds: int
        :keyword events_late_arrival_max_delay_in_seconds: The maximum tolerable delay in seconds where
         events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days)
         and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to
         have a value of -1.
        :paramtype events_late_arrival_max_delay_in_seconds: int
        :keyword data_locale: The data locale of the stream analytics job. Value should be the name of
         a supported .NET Culture from the set
         https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx.
         Defaults to 'en-US' if none specified.
        :paramtype data_locale: str
        :keyword compatibility_level: Controls certain runtime behaviors of the streaming job. Known
         values are: "1.0" and "1.2".
        :paramtype compatibility_level: str or ~azure.mgmt.streamanalytics.models.CompatibilityLevel
        :keyword inputs: A list of one or more inputs to the streaming job. The name property for each
         input is required when specifying this property in a PUT request. This property cannot be
         modify via a PATCH operation. You must use the PATCH API available for the individual input.
        :paramtype inputs: list[~azure.mgmt.streamanalytics.models.Input]
        :keyword transformation: Indicates the query and the number of streaming units to use for the
         streaming job. The name property of the transformation is required when specifying this
         property in a PUT request. This property cannot be modify via a PATCH operation. You must use
         the PATCH API available for the individual transformation.
        :paramtype transformation: ~azure.mgmt.streamanalytics.models.Transformation
        :keyword outputs: A list of one or more outputs for the streaming job. The name property for
         each output is required when specifying this property in a PUT request. This property cannot be
         modify via a PATCH operation. You must use the PATCH API available for the individual output.
        :paramtype outputs: list[~azure.mgmt.streamanalytics.models.Output]
        :keyword functions: A list of one or more functions for the streaming job. The name property
         for each function is required when specifying this property in a PUT request. This property
         cannot be modify via a PATCH operation. You must use the PATCH API available for the individual
         transformation.
        :paramtype functions: list[~azure.mgmt.streamanalytics.models.Function]
        :keyword job_storage_account: The properties that are associated with an Azure Storage account
         with MSI.
        :paramtype job_storage_account: ~azure.mgmt.streamanalytics.models.JobStorageAccount
        :keyword content_storage_policy: Valid values are JobStorageAccount and SystemAccount. If set
         to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
         Known values are: "SystemAccount" and "JobStorageAccount".
        :paramtype content_storage_policy: str or
         ~azure.mgmt.streamanalytics.models.ContentStoragePolicy
        :keyword externals: The storage account where the custom code artifacts are located.
        :paramtype externals: ~azure.mgmt.streamanalytics.models.External
        :keyword cluster: The cluster which streaming jobs will run on.
        :paramtype cluster: ~azure.mgmt.streamanalytics.models.ClusterInfo
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.identity = identity
        self.sku_properties_sku = sku_properties_sku
        self.job_id = None
        self.provisioning_state = None
        self.job_state = None
        self.job_type = job_type
        self.output_start_mode = output_start_mode
        self.output_start_time = output_start_time
        self.last_output_event_time = None
        self.events_out_of_order_policy = events_out_of_order_policy
        self.output_error_policy = output_error_policy
        self.events_out_of_order_max_delay_in_seconds = events_out_of_order_max_delay_in_seconds
        self.events_late_arrival_max_delay_in_seconds = events_late_arrival_max_delay_in_seconds
        self.data_locale = data_locale
        self.compatibility_level = compatibility_level
        self.created_date = None
        self.inputs = inputs
        self.transformation = transformation
        self.outputs = outputs
        self.functions = functions
        self.etag = None
        self.job_storage_account = job_storage_account
        self.content_storage_policy = content_storage_policy
        self.externals = externals
        self.cluster = cluster


class StreamingJobListResult(_serialization.Model):
    """Object containing a list of streaming jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of streaming jobs. Populated by a 'List' operation.
    :vartype value: list[~azure.mgmt.streamanalytics.models.StreamingJob]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StreamingJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StreamInputProperties(InputProperties):
    """The properties that are associated with an input containing stream data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Indicates whether the input is a source of reference data or stream data. Required
     on PUT (CreateOrReplace) requests. Required.
    :vartype type: str
    :ivar serialization: Describes how data from an input is serialized or how data is serialized
     when written to an output. Required on PUT (CreateOrReplace) requests.
    :vartype serialization: ~azure.mgmt.streamanalytics.models.Serialization
    :ivar diagnostics: Describes conditions applicable to the Input, Output, or the job overall,
     that warrant customer attention.
    :vartype diagnostics: ~azure.mgmt.streamanalytics.models.Diagnostics
    :ivar etag: The current entity tag for the input. This is an opaque string. You can use it to
     detect whether the resource has changed between requests. You can also use it in the If-Match
     or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    :ivar compression: Describes how input data is compressed.
    :vartype compression: ~azure.mgmt.streamanalytics.models.Compression
    :ivar partition_key: partitionKey Describes a key in the input data which is used for
     partitioning the input data.
    :vartype partition_key: str
    :ivar watermark_settings: Settings which determine whether to read watermark events.
    :vartype watermark_settings: ~azure.mgmt.streamanalytics.models.InputWatermarkProperties
    :ivar datasource: Describes an input data source that contains stream data. Required on PUT
     (CreateOrReplace) requests.
    :vartype datasource: ~azure.mgmt.streamanalytics.models.StreamInputDataSource
    """

    _validation = {
        "type": {"required": True},
        "diagnostics": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "serialization": {"key": "serialization", "type": "Serialization"},
        "diagnostics": {"key": "diagnostics", "type": "Diagnostics"},
        "etag": {"key": "etag", "type": "str"},
        "compression": {"key": "compression", "type": "Compression"},
        "partition_key": {"key": "partitionKey", "type": "str"},
        "watermark_settings": {"key": "watermarkSettings", "type": "InputWatermarkProperties"},
        "datasource": {"key": "datasource", "type": "StreamInputDataSource"},
    }

    def __init__(
        self,
        *,
        serialization: Optional["_models.Serialization"] = None,
        compression: Optional["_models.Compression"] = None,
        partition_key: Optional[str] = None,
        watermark_settings: Optional["_models.InputWatermarkProperties"] = None,
        datasource: Optional["_models.StreamInputDataSource"] = None,
        **kwargs
    ):
        """
        :keyword serialization: Describes how data from an input is serialized or how data is
         serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        :paramtype serialization: ~azure.mgmt.streamanalytics.models.Serialization
        :keyword compression: Describes how input data is compressed.
        :paramtype compression: ~azure.mgmt.streamanalytics.models.Compression
        :keyword partition_key: partitionKey Describes a key in the input data which is used for
         partitioning the input data.
        :paramtype partition_key: str
        :keyword watermark_settings: Settings which determine whether to read watermark events.
        :paramtype watermark_settings: ~azure.mgmt.streamanalytics.models.InputWatermarkProperties
        :keyword datasource: Describes an input data source that contains stream data. Required on PUT
         (CreateOrReplace) requests.
        :paramtype datasource: ~azure.mgmt.streamanalytics.models.StreamInputDataSource
        """
        super().__init__(
            serialization=serialization,
            compression=compression,
            partition_key=partition_key,
            watermark_settings=watermark_settings,
            **kwargs
        )
        self.type = "Stream"  # type: str
        self.datasource = datasource


class SubscriptionQuota(SubResource):
    """Describes the current quota for the subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar max_count: The max permitted usage of this resource.
    :vartype max_count: int
    :ivar current_count: The current usage of this resource.
    :vartype current_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "max_count": {"readonly": True},
        "current_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "max_count": {"key": "properties.maxCount", "type": "int"},
        "current_count": {"key": "properties.currentCount", "type": "int"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: Resource name.
        :paramtype name: str
        """
        super().__init__(name=name, **kwargs)
        self.max_count = None
        self.current_count = None


class SubscriptionQuotasListResult(_serialization.Model):
    """Result of the GetQuotas operation. It contains a list of quotas for the subscription in a particular region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of quotas for the subscription in a particular region.
    :vartype value: list[~azure.mgmt.streamanalytics.models.SubscriptionQuota]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SubscriptionQuota]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class TestDatasourceResult(Error):
    """The result of the test input or output request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error definition properties.
    :vartype error: ~azure.mgmt.streamanalytics.models.ErrorError
    :ivar status: The status of the sample output request. Known values are: "TestSucceeded" and
     "TestFailed".
    :vartype status: str or ~azure.mgmt.streamanalytics.models.TestDatasourceResultStatus
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorError"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, error: Optional["_models.ErrorError"] = None, **kwargs):
        """
        :keyword error: Error definition properties.
        :paramtype error: ~azure.mgmt.streamanalytics.models.ErrorError
        """
        super().__init__(error=error, **kwargs)
        self.status = None


class TestInput(_serialization.Model):
    """A stream analytics input.

    All required parameters must be populated in order to send to Azure.

    :ivar input: The stream analytics input to test. Required.
    :vartype input: ~azure.mgmt.streamanalytics.models.Input
    """

    _validation = {
        "input": {"required": True},
    }

    _attribute_map = {
        "input": {"key": "input", "type": "Input"},
    }

    def __init__(self, *, input: "_models.Input", **kwargs):
        """
        :keyword input: The stream analytics input to test. Required.
        :paramtype input: ~azure.mgmt.streamanalytics.models.Input
        """
        super().__init__(**kwargs)
        self.input = input


class TestOutput(_serialization.Model):
    """A stream analytics output.

    All required parameters must be populated in order to send to Azure.

    :ivar output: The stream analytics output to test. Required.
    :vartype output: ~azure.mgmt.streamanalytics.models.Output
    """

    _validation = {
        "output": {"required": True},
    }

    _attribute_map = {
        "output": {"key": "output", "type": "Output"},
    }

    def __init__(self, *, output: "_models.Output", **kwargs):
        """
        :keyword output: The stream analytics output to test. Required.
        :paramtype output: ~azure.mgmt.streamanalytics.models.Output
        """
        super().__init__(**kwargs)
        self.output = output


class TestQuery(_serialization.Model):
    """The request object for query testing.

    All required parameters must be populated in order to send to Azure.

    :ivar diagnostics: Diagnostics information related to query testing.
    :vartype diagnostics: ~azure.mgmt.streamanalytics.models.TestQueryDiagnostics
    :ivar streaming_job: Stream analytics job object which defines the input, output, and
     transformation for the query testing. Required.
    :vartype streaming_job: ~azure.mgmt.streamanalytics.models.StreamingJob
    """

    _validation = {
        "streaming_job": {"required": True},
    }

    _attribute_map = {
        "diagnostics": {"key": "diagnostics", "type": "TestQueryDiagnostics"},
        "streaming_job": {"key": "streamingJob", "type": "StreamingJob"},
    }

    def __init__(
        self,
        *,
        streaming_job: "_models.StreamingJob",
        diagnostics: Optional["_models.TestQueryDiagnostics"] = None,
        **kwargs
    ):
        """
        :keyword diagnostics: Diagnostics information related to query testing.
        :paramtype diagnostics: ~azure.mgmt.streamanalytics.models.TestQueryDiagnostics
        :keyword streaming_job: Stream analytics job object which defines the input, output, and
         transformation for the query testing. Required.
        :paramtype streaming_job: ~azure.mgmt.streamanalytics.models.StreamingJob
        """
        super().__init__(**kwargs)
        self.diagnostics = diagnostics
        self.streaming_job = streaming_job


class TestQueryDiagnostics(_serialization.Model):
    """Diagnostics information related to query testing.

    All required parameters must be populated in order to send to Azure.

    :ivar write_uri: The SAS URI to the container or directory. Required.
    :vartype write_uri: str
    :ivar path: The path to the subdirectory.
    :vartype path: str
    """

    _validation = {
        "write_uri": {"required": True},
    }

    _attribute_map = {
        "write_uri": {"key": "writeUri", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, write_uri: str, path: Optional[str] = None, **kwargs):
        """
        :keyword write_uri: The SAS URI to the container or directory. Required.
        :paramtype write_uri: str
        :keyword path: The path to the subdirectory.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.write_uri = write_uri
        self.path = path


class Transformation(SubResource):
    """A transformation object, containing all information associated with the named transformation. All transformations are contained under a streaming job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar streaming_units: Specifies the number of streaming units that the streaming job uses.
    :vartype streaming_units: int
    :ivar valid_streaming_units: Specifies the valid streaming units a streaming job can scale to.
    :vartype valid_streaming_units: list[int]
    :ivar query: Specifies the query that will be run in the streaming job. You can learn more
     about the Stream Analytics Query Language (SAQL) here:
     https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
    :vartype query: str
    :ivar etag: The current entity tag for the transformation. This is an opaque string. You can
     use it to detect whether the resource has changed between requests. You can also use it in the
     If-Match or If-None-Match headers for write operations for optimistic concurrency.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "streaming_units": {"key": "properties.streamingUnits", "type": "int"},
        "valid_streaming_units": {"key": "properties.validStreamingUnits", "type": "[int]"},
        "query": {"key": "properties.query", "type": "str"},
        "etag": {"key": "properties.etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        streaming_units: int = 3,
        valid_streaming_units: Optional[List[int]] = None,
        query: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword streaming_units: Specifies the number of streaming units that the streaming job uses.
        :paramtype streaming_units: int
        :keyword valid_streaming_units: Specifies the valid streaming units a streaming job can scale
         to.
        :paramtype valid_streaming_units: list[int]
        :keyword query: Specifies the query that will be run in the streaming job. You can learn more
         about the Stream Analytics Query Language (SAQL) here:
         https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
        :paramtype query: str
        """
        super().__init__(name=name, **kwargs)
        self.streaming_units = streaming_units
        self.valid_streaming_units = valid_streaming_units
        self.query = query
        self.etag = None
