#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2005, 2006 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching	<crunchy@bitkipper.net>

"""
signal example
"""

from __future__ import print_function

import notifier
import notifier.signals as signals


class TestSignal(signals.Provider):
	def __init__(self):
		signals.Provider.__init__(self)
		self.signal_new('test-signal')


test = TestSignal()


def timer_cb(a):
	print('timer argument:%s' % a)
	signals.emit('test-signal')
	test.signal_emit('test-signal')
	print('-------------------------')
	return True


def signal_cb(signal, a, b):
	print('signal arguments:%s\t%s\t%s' % (signal, a, b))
	# disconnect global signal
	signals.disconnect('test-signal', signal_cb)


notifier.init(notifier.GENERIC)

signals.new('test-signal')
signals.connect('test-signal', notifier.Callback(signal_cb, 1, 2, 'global signal'))
test.signal_connect('test-signal', notifier.Callback(signal_cb, 1, 2, 'TestSignal signal'))
notifier.timer_add(2000, notifier.Callback(timer_cb, 7))

notifier.loop()
