#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright 2015-2022 Univention GmbH
# Copyright (C) 2004, 2005, 2006, 2007 Andreas Büsching <crunchy@bitkipper.net>
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
test programm for the QT3 and QT4 notifier
"""

from __future__ import print_function

import sys

import PyQt5.Qt as qt

import notifier


class QTestApp(qt.QApplication):
	def __init__(self):
		qt.QApplication.__init__(self, sys.argv)
		self.dialog = qt.QDialog()
		self.setActiveWindow(self.dialog)

		self.button = qt.QPushButton('Hello World', self.dialog)
		self.dialog.show()
		qt.QObject.connect(self.button, qt.SIGNAL('clicked()'), self.clickedButton)
		self.timer_id = notifier.timer_add(1000, self.timerTest)
		self.dispatch_it = 10

	def recvQuit(self, mmsg, data=None):
		self.quit()

	def clickedButton(self):
		print("bye")
		self.quit(1)

	def timerTest(self):
		print('tick')
		return True

	def _dispatch(self):
		print('dispatch')
		self.dispatch_it -= 1
		return self.dispatch_it > 0


if __name__ == '__main__':
	notifier.init(notifier.QT)
	app = QTestApp()

	notifier.dispatcher_add(app._dispatch)
	print('exit code: %d' % notifier.loop())
