#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2006, 2009 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
en example demonstrating the process handler class
"""

from __future__ import print_function

import time
from typing import List  # noqa: F401

import notifier
import notifier.threads as threads


def my_thread(words):
	# type: (List[str]) -> List[str]
	for i in range(5):
		print("%s\t%s" % (i, words))
		time.sleep(0.1)
	return words


def done_with_it(thread, result, another):
	# type: (threads.Simple, List[str], str) -> None
	print("Thread '%s' is finished" % thread.name)
	print("Argument:%s" % another)
	print("Result:%s" % (result))


def doing_something_else():
	# type: () -> bool
	print('doing something else')
	return True


if __name__ == '__main__':
	notifier.init(notifier.GENERIC)

	# task = threads.Simple('test', notifier.Callback(my_thread, ['hello', 'world']), done_with_it)
	task = threads.Simple('test', notifier.Callback(my_thread, ['hello', 'world']), notifier.Callback(done_with_it, 'another argument'))
	task.run()
	notifier.timer_add(1000, doing_something_else)
	notifier.loop()
