# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2008 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
Simple test program for the Twisted notifier.
"""

import os
import tempfile
import time

import mock
import pytest

import notifier

pytest.importorskip("twisted")
_stdout = tempfile.TemporaryFile()

# notifier-timer testfunction


def test_twisted():
	notifier.init(notifier.TWISTED)

	def _stdin(fd):
		print('read: ')
		print(os.read(fd, 512))
		notifier.socket_remove(0)
		return False

	timer_test = mock.Mock()
	timer_test.return_value = True
	timer_once = mock.Mock()
	timer_once.return_value = False
	dispatcher_test = mock.Mock()
	dispatcher_test.return_value = True

	#notifier.socket_add(0, _stdin)

	notifier.timer_add(140, notifier.Callback(timer_once))
	notifier.timer_add(1000, notifier.Callback(timer_test))
	notifier.dispatcher_add(notifier.Callback(dispatcher_test, 1, 2, 3))

	for i in range(3):
		notifier.step()
		time.sleep(1)

	timer_once.assert_called()
	assert timer_once.call_count == 1
	timer_test.assert_called()
	assert timer_test.call_count == 2
	dispatcher_test.assert_called_with(1, 2, 3)
	assert dispatcher_test.call_count >= 3
