# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.accounts.v1.auth_token_promotion import AuthTokenPromotionList
from twilio.rest.accounts.v1.credential import CredentialList
from twilio.rest.accounts.v1.secondary_auth_token import SecondaryAuthTokenList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Accounts

        :returns: V1 version of Accounts
        :rtype: twilio.rest.accounts.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._auth_token_promotion = None
        self._credentials = None
        self._secondary_auth_token = None

    @property
    def auth_token_promotion(self):
        """
        :rtype: twilio.rest.accounts.v1.auth_token_promotion.AuthTokenPromotionList
        """
        if self._auth_token_promotion is None:
            self._auth_token_promotion = AuthTokenPromotionList(self)
        return self._auth_token_promotion

    @property
    def credentials(self):
        """
        :rtype: twilio.rest.accounts.v1.credential.CredentialList
        """
        if self._credentials is None:
            self._credentials = CredentialList(self)
        return self._credentials

    @property
    def secondary_auth_token(self):
        """
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenList
        """
        if self._secondary_auth_token is None:
            self._secondary_auth_token = SecondaryAuthTokenList(self)
        return self._secondary_auth_token

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Accounts.V1>'
