#!/bin/bash
set -e

sp='/-\|'
OUTPUT=${0%.sh}
truncate -s0 ${OUTPUT}

DEST=usr/src/pytorch
FILES=( $(LANG=C find . | sort) )
echo Found roughly ${#FILES[@]} source files to install.
echo -n Rewriting ${OUTPUT} '...  '

if ! test -d debian; then
    echo please run this script at root directory of source
    exit 1
fi

for F in ${FILES[@]}; do
    # progress bar
    printf '\b%.1s' "$sp"
    sp=${sp#?}${sp%???}
    # write installation control file
    if (echo ${F} | grep .git --silent); then
        continue
    elif test -d ${F}; then
        continue
    elif (echo ${F} | grep debian/ --silent); then
        continue
    elif test "${F}" != "${F#./.}"; then
        continue
    fi
    echo ${F#./} ${DEST}/$(dirname ${F#./})/  >> ${OUTPUT}
done
echo
