/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.perflib.analysis;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.ImmutableList;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.NonRecursiveVisitor;
import com.squareup.haha.perflib.RootObj;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.List;

public class TopologicalSort {
    public static ImmutableList<Instance> compute(Iterable<RootObj> roots) {
        TopologicalSortVisitor visitor = new TopologicalSortVisitor();
        visitor.doVisit(roots);
        ImmutableList<Instance> instances = visitor.getOrderedInstances();
        Snapshot.SENTINEL_ROOT.setTopologicalOrder(0);
        int currentIndex = 0;
        for (Instance node : instances) {
            node.setTopologicalOrder(++currentIndex);
        }
        return instances;
    }

    static class TopologicalSortVisitor
    extends NonRecursiveVisitor {
        private final TLongHashSet mVisited = new TLongHashSet();
        private final List<Instance> mPostorder = new ArrayList<Instance>();

        private TopologicalSortVisitor() {
        }

        @Override
        public void visitLater(Instance parent, Instance child) {
            if (!this.mSeen.contains(child.getId())) {
                this.mStack.push(child);
            }
        }

        @Override
        public void doVisit(Iterable<? extends Instance> startNodes) {
            for (Instance instance : startNodes) {
                instance.accept(this);
            }
            while (!this.mStack.isEmpty()) {
                Instance node = (Instance)this.mStack.peek();
                if (this.mSeen.add(node.getId())) {
                    node.accept(this);
                    continue;
                }
                this.mStack.pop();
                if (!this.mVisited.add(node.getId())) continue;
                this.mPostorder.add(node);
            }
        }

        ImmutableList<Instance> getOrderedInstances() {
            return ImmutableList.copyOf(Ascii.reverse(this.mPostorder));
        }
    }
}

