% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_epred.R
\name{posterior_linpred.brmsfit}
\alias{posterior_linpred.brmsfit}
\alias{posterior_linpred}
\title{Posterior Samples of the Linear Predictor}
\usage{
\method{posterior_linpred}{brmsfit}(
  object,
  transform = FALSE,
  newdata = NULL,
  re_formula = NULL,
  re.form = NULL,
  resp = NULL,
  dpar = NULL,
  nlpar = NULL,
  nsamples = NULL,
  subset = NULL,
  sort = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{transform}{(Deprecated) Logical; if \code{FALSE}
(the default), samples of the linear predictor are returned.
If \code{TRUE}, samples of transformed linear predictor,
that is, the mean of the posterior predictive distribution
are returned instead (see \code{\link{posterior_epred}} for details).
Only implemented for compatibility with the 
\code{\link[rstantools:posterior_linpred]{posterior_linpred}}
generic.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{re.form}{Alias of \code{re_formula}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, expected predictions of this parameters are returned.}

\item{nlpar}{Optional name of a predicted non-linear parameter.
If specified, expected predictions of this parameters are returned.}

\item{nsamples}{Positive integer indicating how many posterior samples should
be used. If \code{NULL} (the default) all samples are used. Ignored if
\code{subset} is not \code{NULL}.}

\item{subset}{A numeric vector specifying the posterior samples to be used.
If \code{NULL} (the default), all samples are used.}

\item{sort}{Logical. Only relevant for time series models. 
Indicating whether to return predicted values in the original 
order (\code{FALSE}; default) or in the order of the 
time series (\code{TRUE}).}

\item{...}{Further arguments passed to \code{\link{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\description{
Compute posterior samples of the linear predictor, that is samples before
applying any link functions or other transformations. Can be performed for
the data used to fit the model (posterior predictive checks) or for new data.
}
\examples{
\dontrun{
## fit a model
fit <- brm(rating ~ treat + period + carry + (1|subject), 
           data = inhaler)

## extract linear predictor values
pl <- posterior_linpred(fit)
str(pl)
}

}
\seealso{
\code{\link{posterior_epred.brmsfit}}
}
