% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_custom.R
\name{batchtools_custom}
\alias{batchtools_custom}
\title{Batchtools futures for custom batchtools configuration}
\usage{
batchtools_custom(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  resources = list(),
  workers = NULL,
  conf.file = findConfFile(),
  cluster.functions = NULL,
  registry = list(),
  ...
)
}
\arguments{
\item{expr}{The R expression to be evaluated}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or a
\link[globals:Globals]{Globals} object.  If TRUE, globals are identified by code
inspection based on \code{expr} and \code{tweak} searching from environment
\code{envir}.  If FALSE, no globals are used.  If a character vector, then
globals are identified by lookup based their names \code{globals} searching
from environment \code{envir}.  If a named list or a Globals object, the
globals are used as is.}

\item{label}{(optional) Label of the future (where applicable, becomes the
job name for most job schedulers).}

\item{resources}{(optional) A named list passed to the \pkg{batchtools}
template (available as variable \code{resources}).  See Section 'Resources'
in \code{\link[batchtools:submitJobs]{batchtools::submitJobs()}} more details.}

\item{workers}{(optional) The maximum number of workers the batchtools
backend may use at any time.   Interactive and "local" backends can only
process one future at the time (\code{workers = 1L}), whereas HPC backends,
where futures are resolved via separate jobs on a scheduler, can have
multiple workers.  In the latter, the default is \code{workers = NULL}, which
will resolve to
\code{getOption("\link{future.batchtools.workers}")}.
If neither are specified, then the default is \code{100}.}

\item{conf.file}{(character) A batchtools configuration file as for
instance returned by \code{\link[batchtools:findConfFile]{batchtools::findConfFile()}}.}

\item{cluster.functions}{A
\link[batchtools:makeClusterFunctions]{ClusterFunctions} object.}

\item{registry}{(optional) A named list of settings to control the setup
of the batchtools registry.}

\item{\ldots}{Additional arguments passed to \code{\link[=BatchtoolsFuture]{BatchtoolsFuture()}}.}
}
\value{
An object of class \code{BatchtoolsFuture}.
}
\description{
Batchtools futures for custom batchtools configuration
}
\examples{
options(error = function(...) {
  print(traceback())
})

cf <- batchtools::makeClusterFunctionsInteractive(external = TRUE)
print(cf)
str(cf)
plan(batchtools_custom, cluster.functions = cf)
print(plan())
print(nbrOfWorkers())

## Create explicit future
f <- future({
  cat("PID:", Sys.getpid(), "\n")
  42L
})
print(f)
v <- value(f)
print(v)

options(error = NULL)


## Create explicit future
f <- future({
  cat("PID:", Sys.getpid(), "\n")
  42L
})
print(f)
v <- value(f)
print(v)



## Create explicit future
f <- future({
  cat("PID:", Sys.getpid(), "\n")
  42L
})
v <- value(f)
print(v)
}
