% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{gh}
\alias{gh}
\alias{gh-package}
\alias{gh}
\title{GitHub API}
\usage{
gh(endpoint, ..., .token = NULL, .api_url = NULL, .method = "GET",
  .limit = NULL, .send_headers = NULL)
}
\arguments{
\item{endpoint}{GitHub API endpoint. Must be one of the following forms:

\itemize{
\item "METHOD path", e.g. "GET /rate_limit"
\item "path", e.g. "/rate_limit".
\item "METHOD url", e.g. "GET https://api.github.com/rate_limit"
\item "url", e.g. "https://api.github.com/rate_limit".
}

If the method is not supplied, will use \code{.method}, which defaults
to \code{GET}.}

\item{...}{Name-value pairs giving API parameters. Will be matched
into \code{url} placeholders, sent as query parameters in \code{GET}
requests, and in the JSON body of \code{POST} requests.}

\item{.token}{Authentication token.}

\item{.api_url}{Github API url (default: \url{https://api.github.com}).
Used if \code{endpoint} just contains a path.}

\item{.method}{HTTP method to use if not explicitly supplied in the
\code{endpoint}.}

\item{.limit}{Number of records to return. This can be used
instead of manual pagination. By default it is \code{NULL},
which means that the defaults of the GitHub API are used.
You can set it to a number to request more (or less)
records, and also to \code{Inf} to request all records.
Note, that if you request many records, then multiple GitHub
API calls are used to get them, and this can take a potentially
long time.}

\item{.send_headers}{Named character vector of header field values
(excepting \code{Authorization}, which is handled via
\code{.token}). This can be used to override or augment the
defaults, which are as follows: the \code{Accept} field defaults
to \code{"application/vnd.github.v3+json"} and the
\code{User-Agent} field defaults to
\code{"https://github.com/r-lib/gh"}. This can be used
to, e.g., provide a custom media type, in order to access a
preview feature of the API.}
}
\value{
Answer from the API as a \code{gh_response} object, which is also a
\code{list}. Failed requests will generate an R error.
}
\description{
Minimal wrapper to access GitHub's API.

This is an extremely minimal client. You need to know the API
to be able to use this client. All this function does is:
\itemize{
\item Try to substitute each listed parameter into
\code{endpoint}, using the \code{:parameter} notation.
\item If a GET request (the default), then add
all other listed parameters as query parameters.
\item If not a GET request, then send the other parameters
in the request body, as JSON.
\item Convert the response to an R list using
\code{jsonlite::fromJSON}.
}
}
\examples{
\dontrun{
## Repositories of a user, these are equivalent
gh("/users/hadley/repos")
gh("/users/:username/repos", username = "hadley")

## Starred repositories of a user
gh("/users/hadley/starred")
gh("/users/:username/starred", username = "hadley")

## Create a repository, needs a token in GITHUB_PAT (or GITHUB_TOKEN)
## environment variable
gh("POST /user/repos", name = "foobar")

## Issues of a repository
gh("/repos/hadley/dplyr/issues")
gh("/repos/:owner/:repo/issues", owner = "hadley", repo = "dplyr")

## Automatic pagination
users <- gh("/users", .limit = 50)
length(users)

## Access developer preview of Licenses API (in preview as of 2015-09-24)
gh("/licenses") # error code 415
gh("/licenses",
   .send_headers = c("Accept" = "application/vnd.github.drax-preview+json"))

## Access Github Enterprise API
gh("/user/repos", type = "public", .api_url = "https://github.foobar.edu/api/v3")

## Use I() to force body part to be sent as an array, even if length 1
## This works whether assignees has length 1 or > 1
assignees <- "gh_user"
assignees <- c("gh_user1", "gh_user2")
gh("PATCH /repos/OWNER/REPO/issues/1", assignees = I(assignees))
}

}
\seealso{
\code{\link{gh_whoami}()} for details on GitHub API token
management.
}
