% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{ROCR.hiv}
\alias{ROCR.hiv}
\title{Data set: Support vector machines and neural networks applied to the
  prediction of HIV-1 coreceptor usage}
\format{
A list consisting of the SVM (\code{ROCR.hiv$hiv.svm}) and NN
(\code{ROCR.hiv$hiv.nn}) classification data. Each of those is in turn a list
consisting of the two elements \code{$predictions} and \code{$labels} (10
element list representing cross-validation data).
}
\usage{
data(ROCR.hiv)
}
\description{
Linear support vector machines (libsvm) and neural networks (R package
nnet) were applied to predict usage of the coreceptors CCR5 and CXCR4
based on sequence data of the third variable loop of the HIV envelope
protein.
}
\examples{
library(ROCR)
data(ROCR.hiv)
attach(ROCR.hiv)
pred.svm <- prediction(hiv.svm$predictions, hiv.svm$labels)
pred.svm
perf.svm <- performance(pred.svm, 'tpr', 'fpr')
perf.svm
pred.nn <- prediction(hiv.nn$predictions, hiv.svm$labels)
pred.nn
perf.nn <- performance(pred.nn, 'tpr', 'fpr')
perf.nn
plot(perf.svm, lty=3, col="red",main="SVMs and NNs for prediction of
HIV-1 coreceptor usage")
plot(perf.nn, lty=3, col="blue",add=TRUE)
plot(perf.svm, avg="vertical", lwd=3, col="red",
     spread.estimate="stderror",plotCI.lwd=2,add=TRUE)
plot(perf.nn, avg="vertical", lwd=3, col="blue",
     spread.estimate="stderror",plotCI.lwd=2,add=TRUE)
legend(0.6,0.6,c('SVM','NN'),col=c('red','blue'),lwd=3)
}
\references{
Sing, T. & Beerenwinkel, N. & Lengauer, T.  "Learning mixtures
of localized rules by maximizing the area under the ROC curve".  1st
  International Workshop on ROC Analysis in AI, 89-96, 2004.
}
\keyword{datasets}
