% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_fisher_combination_test.R
\name{getDesignFisher}
\alias{getDesignFisher}
\title{Get Design Fisher}
\usage{
getDesignFisher(..., kMax = NA_integer_, alpha = NA_real_,
  method = C_FISHER_METHOD_DEFAULT, userAlphaSpending = NA_real_,
  alpha0Vec = NA_real_, informationRates = NA_real_, sided = 1,
  bindingFutility = C_BINDING_FUTILITY_FISHER_DEFAULT,
  tolerance = C_ANALYSIS_TOLERANCE_FISHER_DEFAULT, iterations = 0,
  seed = NA_real_)
}
\arguments{
\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{kMax}{The maximum number of stages K. K = 2, 3, ..., 6, default is 3.}

\item{alpha}{The significance level alpha, default is 0.025.}

\item{method}{"equalAlpha", "fullAlpha", "noInteraction", or "userDefinedAlpha", default is "equalAlpha".}

\item{userAlphaSpending}{A vector of levels 0 < alpha_1 < ... < alpha_K < alpha 
specifying the cumulative Type I error rate.}

\item{alpha0Vec}{Stopping for futility bounds for stage-wise p-values.}

\item{informationRates}{Information rates that must be fixed prior to the trial, \cr
default is \code{(1 : kMax) / kMax}.}

\item{sided}{Is the alternative one-sided (1) or two-sided (2), default is 1.}

\item{bindingFutility}{If \code{bindingFutility = FALSE} is specified the calculation of 
the critical values is not affected by the futility bounds (default is \code{TRUE}).}

\item{tolerance}{The tolerance, default is 1E-14.}

\item{iterations}{The number of simulation iterations, e.g.,
getDesignFisher(iterations = 100000) checks the validity of the critical values for the default design. 
The default value of \code{iterations} is 0, i.e., no simulation will be executed.}

\item{seed}{Seed for simulating the power for Fisher's combination test. See above, default is a random seed.}
}
\value{
Returns a \code{\link{TrialDesignFisher}} object
}
\description{
Performs Fisher's combination test and returns critical values for this design.
}
\details{
\code{getDesignFisher} calculates the critical values and stage levels for Fisher's combination test as described in Bauer (1989), Bauer and Koehne (1994), 
Bauer and Roehmel (1995), and Wassmer (1999) for equally and unequally sized stages.
}
\examples{
# Run with default values
getDesignFisher() 

# The output is:
#  
# Design parameters and output of Fisher design:
# User defined parameters: not available
# 
# Derived from user defined parameters: not available
# 
# Default parameters:
#   Method                          : equalAlpha 
#   Maximum number of stages        : 3 
#   Stages                          : 1, 2, 3 
#   Information rates               : 0.333, 0.667, 1.000 
#   Significance level              : 0.0250 
#   Alpha_0                         : 1.0000, 1.0000 
#   Binding futility                : TRUE 
#   Test                            : one-sided 
#   Tolerance                       : 1e-14 
# 
# Output:
#   Cumulative alpha spending       : 0.01231, 0.01962, 0.02500 
#   Critical values                 : 0.0123085, 0.0016636, 0.0002911 
#   Stage levels                    : 0.01231, 0.01231, 0.01231 
#   Scale                           : 1, 1 
#   Non stochastic curtailment      : FALSE 

}
\seealso{
\code{\link{getDesignSet}} for creating a set of designs to compare.
}
