#! /usr/bin/env perl

# Test package that computes default database settings:

# Check how database name and engine is determined from varouos URLs

use strict;
use warnings;
use utf8;

use lib 'lib';
use RestfulDB::DBSettings qw(get_database_settings);

binmode( STDOUT, "utf8" );

my @cases = (
    { env => {REQUEST_URI => "/~saulius/test/dbase/tbl"},     cgi => {}, par => {} },
    { env => {REQUEST_URI => "/~saulius/test/dbase.db/tbl"},  cgi => {}, par => {} },
    { env => {REQUEST_URI => "/~saulius/test/dbase.db2/tbl"}, cgi => {}, par => {} },
    { env => {REQUEST_URI => "/~saulius/test/dbase.db3/tbl"}, cgi => {}, par => {} },

    { env => {REQUEST_URI => "/~saulius/test/dbase/rec"},     cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test/dbase.db/rec"},  cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test/dbase.db2/rec"}, cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test/dbase.db3/rec"}, cgi => {}, par => {level => 2} },

    { env => {REQUEST_URI => "/~saulius/test/dbase.db2/rec"},         cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test.sqlite/dbase.db2/rec"},  cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test.sqlite2/dbase.db3/rec"}, cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test.sqlite3/dbase.db2/rec"}, cgi => {}, par => {level => 2} },

    { env => {REQUEST_URI => "/~saulius/test/dbtbl/123"},     cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test.db/dbtbl/123"},  cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test.db2/dbtbl/123"}, cgi => {}, par => {level => 2} },
    { env => {REQUEST_URI => "/~saulius/test.db3/dbtbl/123"}, cgi => {}, par => {level => 2} },
);

my $n = 0;
my $separator = "";
for my $case (@cases) {

    print $separator;
    print "test" . ++$n . ":\n";
    $separator = "\n";

    $case->{par}{db_dir} = "/tmp/try";
    my $settings = &get_database_settings( $case->{cgi},
                                           $case->{env},
                                           $case->{par} );

    local $\ = "\n";

    $case->{settings} = $settings;
    for my $argument_name (qw(cgi env par settings)) {
        my $hash = $case->{$argument_name};
        print "$argument_name:";
        for my $key ((sort keys %{$hash})) {
            printf "\t%-21s ", $key;
            print "= ", defined $hash->{$key} ?
                ("'" . $hash->{$key} . "'") : 'undef';
        }
    }
};
