#!/usr/share/ucs-test/runner python3
## desc: Test Database integration of Docker Apps
## tags: [docker]
## bugs: [42690]
## exposure: dangerous
## packages:
##   - docker.io

from subprocess import check_output
from textwrap import dedent

from univention.testing.utils import restart_firewall

from dockertest import Appcenter, get_app_name, get_app_version, tiny_app


if __name__ == '__main__':
    with Appcenter() as appcenter:

        try:
            for database in ['mysql', 'postgresql']:
                app_name = get_app_name()
                app_version = get_app_version()
                app = tiny_app(app_name, app_version)
                app.set_ini_parameter(Database=database)
                app.add_script(uinst=dedent('''\
                    #!/bin/bash
                    VERSION=1
                    . /usr/share/univention-join/joinscripthelper.lib
                    joinscript_init
                    mysql -u root -p$(cat /etc/mysql.secret) %s -e "DROP DATABASE IF EXISTS %s"
                    su postgres -c "psql -c 'DROP DATABASE IF EXISTS %s'"
                    joinscript_remove_script_from_status_file %s
                    exit 0''' % (app_name, app_name, app_name, app_name)))
                app.add_to_local_appcenter()
                appcenter.update()
                for i in [1, 2]:
                    app.install()
                    if database == 'mysql':
                        output = check_output(['mysql', '-u', 'root', '-p%s' % (open('/etc/mysql.secret').read().strip()), 'INFORMATION_SCHEMA', '-e', "SELECT SCHEMA_NAME FROM SCHEMATA WHERE SCHEMA_NAME = '%s'" % app_name], text=True)  # noqa: S608
                    elif database == 'postgresql':
                        output = check_output(['su', 'postgres', '-c', 'psql -l'], text=True)
                    print(output)
                    assert app_name in output, 'No %s database named %s found in run #%d' % (database, app_name, i)
                    app.uninstall()
                app.remove()
        except Exception:
            app.uninstall()
            app.remove()
            raise
    # make sure that all ports used by mysql and postgres are properly closed
    restart_firewall()
