/*
 * Like what you see? Join us!
 * https://www.univention.com/about-us/careers/vacancies/
 *
 * SPDX-FileCopyrightText: 2015-2025 Univention GmbH
 * SPDX-License-Identifier: AGPL-3.0-only
 */
/*global define*/

define([
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/_base/array",
	"dojo/Deferred",
	"dojox/html/entities",
	"umc/tools",
	"umc/widgets/ProgressBar",
	"umc/widgets/Form",
	"umc/widgets/Text",
	"umc/widgets/ComboBox",
	"umc/widgets/ContainerWidget",
	"umc/widgets/Page",
	"./_AppDialogMixin",
	"./AppSettings",
	"umc/i18n!umc/modules/appcenter"
], function(declare, lang, array, Deferred, entities, tools, ProgressBar, Form, Text, ComboBox, ContainerWidget, Page, _AppDialogMixin, AppSettings, _) {
	return declare("umc.modules.appcenter.AppConfigDialog", [ Page, _AppDialogMixin ], {
		_container: null,
		_appSettingsForm: null,
		title: _('App management'),
		mainContentClass: 'umcCard2',

		showUp: function() {
			this.standbyDuring(tools.umcpCommand('appcenter/config', {app: this.app.id, phase: 'Settings'}).then(lang.hitch(this, function(data) {
				this._showUp(data.result);
			})));
		},

		postMixInProperties: function() {
			this.inherited(arguments);
			this._progressBar = new ProgressBar({});
			this.own(this._progressBar);
		},

		_showUp: function(result) {
			this._clearWidget('_container');

			this.set('headerText', _('Configure %s', entities.encode(this.app.name)));

			this.set('headerButtons', [{
				name: 'submit',
				iconClass: 'save',
				label: _('Apply changes'),
				callback: lang.hitch(this, function() {
					var serviceValues = {};
					var confValues = {};
					if (this._serviceForm) {
						if (! this._serviceForm.validate()) {
							return;
						}
						serviceValues = this._serviceForm.get('value');
					}
					if (this._appSettingsForm) {
						if (!this._appSettingsForm.validate()) {
							this._appSettingsForm.focusFirstInvalidWidget();
							return;
						}
						confValues = this._appSettingsForm.get('value');
					}
					this.apply(serviceValues, confValues).then(lang.hitch(this, 'onBack', true));
				})
			}, {
				name: 'close',
				label: _('Cancel configuration'),
				callback: lang.hitch(this, 'onBack', false)
			}]);

			this._container = new ContainerWidget({});
			this.addChild(this._container);

			if (this.app.isDocker) {
				var statusMessage = _('The App is currently not running.') + ' <strong>' + _('It can only be configured while it is running.') + '</strong>';
				if (result.is_running) {
					statusMessage = _('The App is currently running.');
				}
				var widgets = [{
					name: 'status',
					type: Text,
					content: statusMessage
				}, {
					name: 'autostart',
					type: ComboBox,
					label: _('Autostart'),
					size: 'One',
					value: result.autostart,
					staticValues: [{
						id: 'yes',
						label: _('Started automatically')
					}, {
						id: 'manually',
						label: _('Started manually')
					}, {
						id: 'no',
						label: _('Starting is prevented')
					}]
				}];
				var buttons = [{
					name: 'start',
					visible: !result.is_running,
					label: _('Start the App'),
					callback: lang.hitch(this, function() {
						this.startStop('start');
					})
				}, {
					name: 'stop',
					visible: result.is_running,
					label: _('Stop the App'),
					callback: lang.hitch(this, function() {
						this.startStop('stop');
					})
				}];
				this._serviceForm = new Form({
					widgets: widgets,
					buttons: buttons,
					layout: [
						['status'],
						['start', 'stop'],
						['autostart']
					]
				});
				this._container.addChild(this._serviceForm);
			} else {
				this._serviceForm = null;
			}

			var form = AppSettings.getForm(this.app, result.values, 'Settings');
			if (form) {
				this._appSettingsForm = form;
				this._container.addChild(this._appSettingsForm);
			}
			this.onShowUp();
		},

		startStop: function(mode) {
			this.standbyDuring(tools.umcpCommand('appcenter/service', {app: this.app.id, mode: mode}).then(lang.hitch(this, function() {
				this.onUpdate();
			})));
		},

		apply: function(serviceValues, confValues) {
			var autostart = serviceValues.autostart;
			this._progressBar.reset(_('%s: Configuring', entities.encode(this.app.name)));
			this._progressBar._progressBar.set('value', Infinity); // TODO: Remove when this is done automatically by .reset()
			var deferred = new Deferred();
			tools.umcpProgressCommand(this._progressBar, 'appcenter/configure', {app: this.app.id, autostart: autostart, values: confValues}).then(
				lang.hitch(this, function() {
					this._progressBar.stop(function() {
						deferred.resolve();
					}, undefined, true);
				}),
				function() {
					deferred.reject();
				},
				lang.hitch(this, function(result) {
					this._progressBar._addErrors(result.errors);
					var errors = array.map(result.intermediate, function(res) {
						if (res.level == 'ERROR' || res.level == 'CRITICAL') {
							return res.message;
						}
					});
					this._progressBar._addErrors(errors);
				})
			);
			return this.standbyDuring(deferred, this._progressBar);
		}
	});
});

