# Provisioning Service Documentation for UCS Systems

## Overview

The *Nubus Provisioning* service was originally designed for running in Kubernetes.
It was then migrated to UCS.
UCS' system role concept (Primary, Backup, Replica, Memberserver) requires the Provisioning system
to work slightly different in UCS and Kubernetes,
with the main differences being in the "NATS cluster management" (see section *Architecture*)
and the *Backup to Primary failover* mechanism (see section of the same name).

## Architecture

The provisioning service on UCS systems consists of two apps:

- `provisioning-service-backend`: This app installs a listener module that captures LDAP changes
   and writes them to the LDAP-queue. This app is only installed on the Primary Directory Node.
- `provisioning-service`: This app contains the main provisioning service components:
   udm-transformer, prefill, dispatcher, and provisioning API and is installed on the Primary and
   on all Backups.

See [architecture.md](architecture.md) for an in-depth explanation of the architecture of the
provisioning service on UCS.

## Backup to Primary failover (univention-backup2master)

The provisioning service supports backup to primary failover.

The backup-to-primary scenario is automatically handled via
`apps/50provisioning-service-backup2master`, which is executed during `univention-backup2master`.
It installs the `provisioning-service-backend` app on the new Primary Directory Node and
reinitializes the `provisioning-service` app.

Location of the script on a UCS system:

> /usr/lib/univention-backup2master/post/50provisioning-service-backup2master

### Manual steps after univention-backup2master

- On all remaining Backup Directoy Nodes:
  - follow this article (specifically `ldap/master` needs to be correct):
    https://help.univention.com/t/how-to-backup2master/19514
  -execute `univention-app configure provisioning-service --set provisioning-service/udm-rest-api-host=<REPLACE_ME> --set provisioning-service/primary/url=<REPLACE_ME>"`
- Restart all provisioning consumers (they usually just terminate and in k8s that's enough to
  trigger the automatic restart, but not in UCS).

## Manual maintenance and update steps

The maintenance and update process consists of two primary manual workflows:
  1. Third-party dependency and image maintenance: Reviewing security scan results for third-party
     dependencies and updating image versions as needed to address security findings.
  2. Internal code change management: Executing all required follow-up steps after changes to
     internally developed code.

### Third-party dependency and image maintenance

The first essential part of this workflow is our security monitoring. Security monitoring is
performed using DependencyTrack, which periodically analyzes the Software Bill of Materials (SBOMs)
for all container images used by us to identify known security vulnerabilities (CVEs).

When DependencyTrack reports that a package used in one of our container images is associated with a
CVE, we first assess whether the vulnerability is applicable to our specific usage of the affected
package ("triage"). If the vulnerability does not impact our use case, we document this assessment
by creating a corresponding entry in a Rego chart, detailing the rationale for why the CVE is not
relevant to the shipped software.

If the vulnerability is determined to be relevant, the affected container images must be updated to
reference a package or library version that includes the corresponding fix. After updating the
affected container images, new versions of N4K and the Provisioning Service app need to be released.
The necessary manual steps for that are documented below.

- Links:
  - [DependencyTrack](https://deptrack.knut.univention.de/projects/)
  - [NATS in DependencyTrack](https://deptrack.knut.univention.de/projects/39b0ca23-96d3-46ef-8c11-a1f33a104009/findings)
  - [Rego Chart Example](https://git.knut.univention.de/univention/dev/tooling/vulnerability-management/-/commit/e2cf187135661557e7d0f4a35f6f951a762e6fda)

#### CVE fix for NATS container image

If the NATS image version needs to be inscreased, changes must be made to three repositories: nats-helm, provisioning, nubus-helm.
- Links:
  - [Repository nats-helm](https://git.knut.univention.de/univention/dev/nubus-for-k8s/nats-helm)
  - [Repository provisioning service](https://git.knut.univention.de/univention/dev/projects/provisioning)
  - [Repository nubus-helm](https://git.knut.univention.de/univention/dev/nubus-for-k8s/nubus-helm)

The following steps must be performed:
  1. nats-helm/helm/nats/values.yaml: update nats container image version -> push -> merge -> new NATS helm chart version generated by pipeline
  2. provisioning/helm/provisioning/Chart.yaml: update the nats helm chart version in Chart.yaml -> execute `helm dependency update helm/provisioning` -> push -> merge -> new provisioning helm chart version generated by pipeline
  3. nubus-helm/helm/nubus/Chart.yaml: update the provisioning helm chart version in Chart.yaml -> execute `helm dependeny update helm/nubus` ->  push -> merge -> automatic new nubus release
  4. perform [Provisioning Service app release for UCS](#provisioning-service-app-release-for-ucs)

#### CVE fix for Python libraries

Security fixes for internally developed components of the Provisioning Service, i.e. Dispatcher, are
limited to the Python libraries they use. Library versions are managed via Python package manager
`UV`, so remediation involves updating the version number of the affected python library in the
`pyproject.toml` file of all affected components. After modifying a pyproject.toml, run: `uv sync`
once before pushing.

The following steps must be performed:
  1. update `pyproject.toml` of affected components -> `uv sync` -> push -> merge
  2. perform [Provisioning Service app release for UCS](#provisioning-service-app-release-for-ucs)

### Internal code change management

All Python dependencies in this project are managed using the Python package manager `UV`. Any
changes to dependencies must be reflected in the relevant `pyproject.toml` files and accompanied by
updated lock files (`uv sync`) to ensure reproducible builds across environments.

#### Provisioning Service app release for UCS

After changes are pushed to or merged into `main` and new container images are generated by the
GitLab pipeline, a new app release is required to make the changes available in UCS. The regular
manual steps for releasing UCS apps apply to the Provisioning Service app.

The following steps must be performed:
  1. Create new app version in Provider Portal
  2. Update the App Center scripts in this repository (files under `/apps/provisioning-service/` and
    `/apps/provisioning-service-backend/`). (Update `Version` field in `ini` file and replace old
    image versions in the `compose` file)
  3. After changing any of the App Center files, run the script `/apps/push_config_to_appcenter` to
    keep the App Center files in this repository in sync with the versions used by the Provider
    Portal.
  4. Run `docker-update` of [this Jenkins job](https://jenkins2022.knut.univention.de/job/UCS-5.2/job/Apps/job/provisioning-service/job/App%20Autotest%20MultiEnv/SambaVersion=s4,Systemrolle=docker-update/)
    (Uncheck all other parts of that job before running)
    - NOTE: This job checks whether the target image already exists and fails if it does. So you
      cannot run this command twice, unless you use the checkmark "Overwrite" in the job.
  5. On omar, run the following commands to release the app:
    - `cd /var/univention/buildsystem2/mirror/appcenter`
    - `./copy_from_appcenter.test.sh 5.2 $app_component_id` (The component ID looks like this:
      `provisioning-service_20260109142411` and can be found on the page of the app in the Provider
      Portal or
      [here](https://appcenter-test.software-univention.de/meta-inf/5.2/provisioning-service/)
    - `sudo update_mirror.sh --verbose appcenter`
  6. Write mail to `app-announcement@univenton.de` with descriptions of new features and fixes

### Execute automated tests for Kubernetes and UCS deployment

Before releasing a new version of the Provisioning Service, all automated tests must be executed and their results reviewed.

#### Automated tests for Kubernetes deployment

The automated Kubernetes tests consist of multiple jobs within the nubus-helm pipeline and can be
triggered manually. These jobs include smoke tests and end-to-end (E2E) tests.  
- [Example pipeline in nubus-helm](https://git.knut.univention.de/univention/dev/nubus-for-k8s/nubus-helm/-/pipelines/378408)

#### Automated tests for UCS deployment

Execute this [Jenkins test](https://jenkins2022.knut.univention.de/job/UCS-5.2/job/UCS-5.2-4/view/Product%20Tests/job/product-test-base-provisioning/)
for UCS.

## Additional information about automations of the update and maintenance processes

All Provisioning Service containers, except the NATS container, are based on the ucs-base-image. A
new ucs-base-image version with pinned apt cache is created every Thursday by a scheduled GitLab
pipeline and includes errata updates from the regular UCS errata release process. The ucs-base-image
version is automatically updated by Renovate Bot in this repository.

- Links:
  - [Renovate Bot schedules](https://git.knut.univention.de/univention/dev/nubus-for-k8s/common-renovate/-/pipeline_schedules)
  - [ucs-base-image schedules](https://git.knut.univention.de/univention/dev/projects/ucs-base-image/-/pipeline_schedules)
