#!/usr/bin/env python
# SPDX-FileCopyrightText: 2016-2023 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

import sys
import os
import re
from glob import glob
try:
    from typing import Iterable, Pattern  # noqa: F401
except ImportError:
    pass


def segfaults_in_syslog(syslog_path, search_string):  # type: (str, Pattern[str]) -> int
    # find segfaults in syslogfiles
    count = 0
    with open(syslog_path) as infile:
        for line in infile:
            m = search_string.match(line)
            if m:
                count += 1
    return count


def get_logfiles(filename):  # type: (str) -> Iterable[str]
    # logfiles einsammeln
    usi_path = sys.argv[1]
    path = os.path.join(usi_path, 'files')
    return glob(path + '/' + filename)


def logfile_count(search_string):  # type: (Pattern[str]) -> int
    status = 0
    syslogfiles = get_logfiles('var_log_syslog_*')
    for logfile in syslogfiles:
        # print (logfile)
        try:
            syslog_count = segfaults_in_syslog(logfile, search_string)
            if syslog_count > 0:
                print("'%s' enthaelt %s segfaults" % (logfile, syslog_count))
                status += 1
        except IOError as exc:
            print(repr(exc))
            print("Error opening '%s': %s" % (logfile, exc))
            return -1
    return status


RE_SEARCH_STRING = re.compile(r'.*segfault.*', re.I)


def main():  # type: () -> int
    return logfile_count(RE_SEARCH_STRING)


exit_status = main()
sys.exit(exit_status)

# vim: set ts=4 sw=4 tw=0 et :
