#!/usr/bin/env python
# SPDX-FileCopyrightText: 2015-2023 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

import sys

from ucr import UCR

# load ucr variables
ucr = UCR(sys.argv[1])
RETURN = []

if ucr.get('connector/s4/autostart', 'no').lower() in ('yes', 'true', '1'):
    if ucr.get('connector/ldap/binddn', 'none').lower() not in ('none', ucr.get('ldap/hostdn')):
        RETURN.append('WARNING: LDAP Host-DN and S4-Connector Bind-DN does not match!')

sys.exit("\n".join(RETURN))

# vim: set ts=4 sw=4 tw=0 et :
