#!/usr/bin/env python
# SPDX-FileCopyrightText: 2015-2023 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

import sys
import os

from ucr import UCR

# load ucr variables
ucr = UCR(sys.argv[1])
RETURN = []

if ucr.get('connector/s4/autostart', 'yes').lower() in ('yes', 'true', '1'):
    with open(os.path.join(sys.argv[1], 'info', 'ps'), 'r') as infile:
        h_lines = [
            line.strip()
            for line in infile
            if 's4connector' in line
        ]
    if len(h_lines) > 1:
        RETURN.append('CRITICAL: multiple instances of s4-connector are running:')
        RETURN.extend(h_lines)

sys.exit("\n".join(RETURN))

# vim: set ts=4 sw=4 tw=0 et :
