#!/usr/bin/env python
# SPDX-FileCopyrightText: 2015-2023 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

import sys
import os
from ucr import UCR

# load ucr variables
ucr = UCR(sys.argv[1])
RETURN = []

if ucr.get('samba4/autostart', 'no').lower() in ('yes', 'true', '1'):
    if ucr.get('kerberos/autostart', 'no').lower() in ('yes', 'true', '1'):
        RETURN.append('CRITICAL: both "kerberos/autostart" and "samba4/autostart" active')

    with open(os.path.join(sys.argv[1], 'info', 'ps'), 'r') as infile:
        h_lines = [
            line.strip()
            for line in infile
            if 'heimdal' in line
        ]

    if h_lines:
        RETURN.append('CRITICAL: heimdal running on samba4 system:')
        RETURN.extend(h_lines)

sys.exit("\n".join(RETURN))

# vim: set ts=4 sw=4 tw=0 et :
