import os
import re
try:
    from typing import Dict, Optional  # noqa: F401
except ImportError:
    pass


class UCR(object):
    data = {}  # type: Dict[str, str]

    def __init__(self, usi_path):  # type: (str) -> None
        dumpfile = os.path.join(usi_path, 'info', 'ucr-dump')
        with open(dumpfile, 'r') as fin:
            for line in fin:
                key, value = line.split(': ', 1)
                self.data[key.strip()] = value.strip()

    def get(self, key, default=None):  # type: (str, None) -> Optional[str]
        if key in self.data:
            return self.data[key]
        return default

    def getall(self, re_key):  # type: (str) -> Dict[str, str]
        cre = re.compile(re_key)
        ret = {}
        for key in self.data:
            if cre.match(key):
                ret[key] = self.data[key]
        return ret

    def is_true(self, **kwargs):  # type: (**str) -> bool
        ''' Test if UCR key = value
        .is(nameserver1='127.0.0.1', hostname='localhost')

        Returns false if one condition is not true
        '''
        return all(
            self.get(key) == val
            for key, val in kwargs.items()
        )

# vim: set ts=4 sw=4 tw=0 et :
