#!/usr/bin/env python
# SPDX-FileCopyrightText: 2016-2025 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

import re
import os
import sys

RETURN = []
RESULT = 0

# load join status from file
file_path = os.path.join(sys.argv[1], 'info', 'join-status')
try:
    with open(file_path) as statusfile:
        statuscontent = statusfile.read()

    if re.compile(r"Joined successful").match(statuscontent) is None:
        RETURN.append(statuscontent)
        RESULT = 1
except IOError as ex:
    RETURN.append("ERROR: %s" % (ex))
    RESULT = 3

sys.exit("\n".join(RETURN))
