#!/usr/bin/env python
# SPDX-FileCopyrightText: 2015-2025 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

import sys

from ucr import UCR

# load ucr variables
ucr = UCR(sys.argv[1])
RETURN = []

if ucr.get('kerberos/realm').lower() != ucr.get('domainname').lower():
    if ucr.get('samba/role') == "DC":
        RETURN.append("CRITICAL: Kerberos realm '%(kerberos/realm)s' and DNS domainname '%(domainname)s' does not match\n\tsamba role is '%(samba/role)s'" % ucr)
    elif ucr.get('samba4/role') == "DC":
        RETURN.append("CRITICAL: Kerberos realm '%(kerberos/realm)s' and DNS domainname '%(domainname)s' does not match\n\tsamba4 role is '%(samba4/role)s'" % ucr)
    else:
        if ucr.get('samba/role') is not None:
            RETURN.append("INFO: Kerberos realm '%(kerberos/realm)s' and DNS domainname '%(domainname)s' does not match\n\tdue to samba role '%(samba/role)s' this is not critical" % ucr)
        elif ucr.get('samba4/role') is not None:
            RETURN.append("INFO: Kerberos realm '%(kerberos/realm)s' and DNS domainname '%(domainname)s' does not match\n\tdue to samba4 role '%(samba4/role)s' this is not critical" % ucr)
        else:
            RETURN.append("WARNING: Kerberos realm '%(kerberos/realm)s' and DNS domainname '%(domainname)s' does not match\n\tSamba seems not installed (can not determine samba server role)!" % ucr)

sys.exit("\n".join(RETURN))

# vim: set ts=4 sw=4 tw=0 et :
